      SUBROUTINE LIS(THETAE,THETAES,PP,PSC,SIGMA,PTOP,I1,J1,K1,THLI,             LIS.1
     *                THMEAN,KABOVE,TH500                          )             LIS.2
#     include <scratch.incl>                                                     LIS.3
C                                                                                LIS.4
      INEED = 3*I1*J1                                                            LIS.5
      IN1 = NTEMP                                                                LIS.6
      IN2 = IN1+I1*J1                                                            LIS.7
      IN3 = IN2+I1*J1                                                            LIS.8
      NTEMP = NTEMP+INEED                                                        LIS.9
      IF(NTEMP .GT. I_SCRATCH) CALL SPACE_STOP('LIS')                            LIS.10
      IF(VERBOSE) WRITE(6,*) ' CALLING LIS ',INEED,IN1,NTEMP                     LIS.11
        CALL LIS_0(THETAE,THETAES,PP,PSC,SIGMA,PTOP,I1,J1,K1,THLI,               LIS.12
     *                SCR(IN1),SCR(IN2),SCR(IN3))                                LIS.13
      NTEMP = NTEMP - INEED                                                      LIS.14
      IF(VERBOSE) WRITE(6,*) ' RET FROM LIS ',NTEMP                              LIS.15
      RETURN                                                                     LIS.16
      END                                                                        LIS.17
C                                                                                LIS.18
      SUBROUTINE LIS_0(THETAE,THETAES,PP,PSC,SIGMA,PTOP,I1,J1,K1,THLI,           LIS.19
     *                THMEAN,KABOVE,TH500                          )             LIS.20
C                                                                                LIS.21
#     include <scratch.incl>                                                     LIS.22
      DIMENSION THETAE(I1,J1,K1),THETAES(I1,J1,K1),PP(I1,J1,K1),                 LIS.23
     *          PSC(I1,J1),SIGMA(K1),THLI(I1,J1)                                 LIS.24
      DIMENSION THMEAN(I1,J1),SIGF(K_MAX),DSG(K_MAX),KABOVE(I1,J1),              LIS.25
     *          TH500(I1,J1),P(4),T(4)                                           LIS.26
C                                                                                LIS.27
C     ... COMPUTE FULL SIGMA AND DELTA-SIGMA                                     LIS.28
C                                                                                LIS.29
      SIGF(1)=0.                                                                 LIS.30
      DO 50 K=1,K1                                                               LIS.31
         SIGF(K+1)=2.*SIGMA(K)-SIGF(K)                                           LIS.32
50    CONTINUE                                                                   LIS.33
C                                                                                LIS.34
      DO 60 K=1,K1                                                               LIS.35
         DSG(K)=SIGF(K+1)-SIGF(K)                                                LIS.36
60    CONTINUE                                                                   LIS.37
C                                                                                LIS.38
C     ... FIND LEVEL OF SIGMA TO INCLUDE 0.95 AND BELOW                          LIS.39
C                                                                                LIS.40
      K95=0                                                                      LIS.41
      DO 100 K=1,K1                                                              LIS.42
         IF(SIGMA(K).GE.0.94) THEN                                               LIS.43
            K95=K                                                                LIS.44
            GOTO 101                                                             LIS.45
         ENDIF                                                                   LIS.46
100   CONTINUE                                                                   LIS.47
      PRINT *,'HEY, NO SIGMA LEVELS > 0.95!!!'                                   LIS.48
      K95=K1                                                                     LIS.49
101   CONTINUE                                                                   LIS.50
C                                                                                LIS.51
C     ... GET DEPTH OF THOSE SIGMA LAYERS                                        LIS.52
C                                                                                LIS.53
      SIGDEPTH=0.                                                                LIS.54
      DO 150 K=K95,K1                                                            LIS.55
         SIGDEPTH=SIGDEPTH+DSG(K)                                                LIS.56
150   CONTINUE                                                                   LIS.57
C                                                                                LIS.58
C     ... SUM THETA-E AT THESE LEVELS, WEIGHTED BY LAYER DEPTH                   LIS.59
C                                                                                LIS.60
      DO 200 J=1,J1-1                                                            LIS.61
      DO 200 I=1,I1-1                                                            LIS.62
         THMEAN(I,J)=THETAE(I,J,K95)*DSG(K95)                                    LIS.63
200   CONTINUE                                                                   LIS.64
C                                                                                LIS.65
      DO 201 K=K95+1,K1                                                          LIS.66
      DO 201 J=1,J1-1                                                            LIS.67
      DO 201 I=1,I1-1                                                            LIS.68
         THMEAN(I,J)=THMEAN(I,J)+THETAE(I,J,K)*DSG(K)                            LIS.69
201   CONTINUE                                                                   LIS.70
C                                                                                LIS.71
      DO 202 J=1,J1-1                                                            LIS.72
      DO 202 I=1,I1-1                                                            LIS.73
         THMEAN(I,J)=THMEAN(I,J)/SIGDEPTH                                        LIS.74
202   CONTINUE                                                                   LIS.75
C                                                                                LIS.76
C     ... FIND K LEVEL WHERE P > 500 MB                                          LIS.77
C                                                                                LIS.78
      DO 250 J=1,J1-1                                                            LIS.79
      DO 250 I=1,I1-1                                                            LIS.80
         KABOVE(I,J)=0                                                           LIS.81
250   CONTINUE                                                                   LIS.82
C                                                                                LIS.83
      DO 400 J=1,J1-1                                                            LIS.84
      DO 400 I=1,I1-1                                                            LIS.85
         DO 300 K=1,K1                                                           LIS.86
            IF(SIGMA(K)*PSC(I,J)+PTOP+PP(I,J,K).GE.500.0) THEN                   LIS.87
               KABOVE(I,J)=K                                                     LIS.88
               GOTO 301                                                          LIS.89
            ENDIF                                                                LIS.90
300      CONTINUE                                                                LIS.91
         PRINT *,'FOR I,J=',I,J,' COULD NOT FIND P > 500 MB'                     LIS.92
         KABOVE(I,J)=K1-1                                                        LIS.93
301      CONTINUE                                                                LIS.94
400   CONTINUE                                                                   LIS.95
C                                                                                LIS.96
C     ... COMPUTE 500 MB SATURATED THETA-E, 3RD ORDER LAGRANGE INTERP            LIS.97
C                                                                                LIS.98
      DO 500 J=1,J1-1                                                            LIS.99
      DO 500 I=1,I1-1                                                            LIS.100
         P(1)=SIGMA(KABOVE(I,J)+1)*PSC(I,J)+PTOP+PP(I,J,KABOVE(I,J)+1)           LIS.101
         P(2)=SIGMA(KABOVE(I,J)  )*PSC(I,J)+PTOP+PP(I,J,KABOVE(I,J))             LIS.102
         P(3)=SIGMA(KABOVE(I,J)-1)*PSC(I,J)+PTOP+PP(I,J,KABOVE(I,J)-1)           LIS.103
         P(4)=SIGMA(KABOVE(I,J)-2)*PSC(I,J)+PTOP+PP(I,J,KABOVE(I,J)-2)           LIS.104
         T(1)=THETAES(I,J,KABOVE(I,J)+1)                                         LIS.105
         T(2)=THETAES(I,J,KABOVE(I,J)  )                                         LIS.106
         T(3)=THETAES(I,J,KABOVE(I,J)-1)                                         LIS.107
         T(4)=THETAES(I,J,KABOVE(I,J)-2)                                         LIS.108
         CALL LAGRANGE(4,P,T,500.,TH500(I,J))                                    LIS.109
500   CONTINUE                                                                   LIS.110
C                                                                                LIS.111
C     ... NOW (SATURATED THETAE AT 500 MB) - (MEAN THETAE NEAR SFC)              LIS.112
C                                                                                LIS.113
      DO 600 J=1,J1-1                                                            LIS.114
      DO 600 I=1,I1-1                                                            LIS.115
         THLI(I,J)= TH500(I,J) - THMEAN(I,J)                                     LIS.116
600   CONTINUE                                                                   LIS.117
C                                                                                LIS.118
      RETURN                                                                     LIS.119
      END                                                                        LIS.120
