      SUBROUTINE LLXY(XLAT,XLON,X,Y)                                             LLXY.1
C                                                                                LLXY.2
C     SUBPROGRAM TO CALCULATE X AND Y GIVEN LATITUDE AND LONGITUDE.              LLXY.3
C     PETER HOWELLS, NCAR, 1984                                                  LLXY.4
C                                                                                LLXY.5
      COMMON /XYLLC/ XN,DS,XLATC,XLONC,IMAX,JMAX,KPROJ,PSI1,PSI2                 LLXY.6
C                                                                                LLXY.7
      CONV = 57.29578                                                            LLXY.8
      A = 6370.0                                                                 LLXY.9
      PHI1 = 90.0-PSI2                                                           LLXY.10
      POLE = 90.0                                                                LLXY.11
      IF ( XLATC.LT.0.0 ) THEN                                                   LLXY.12
         PHI1 = -90.0-PSI2                                                       LLXY.13
         POLE = -POLE                                                            LLXY.14
      END IF                                                                     LLXY.15
                                                                                 LLXY.16
      IF (KPROJ.EQ.3) THEN                                                       LLXY.17
C MERCATOR PROJECTION                                                            LLXY.18
         C2     = A*COS(PSI1)                                                    LLXY.19
         XC     = 0.0                                                            LLXY.20
         PHICR  = XLATC/CONV                                                     LLXY.21
         CELL   = COS(PHICR)/(1.0+SIN(PHICR))                                    LLXY.22
         YC     = - C2*ALOG(CELL)                                                LLXY.23
         IF (XLAT.NE.-90.) THEN                                                  LLXY.24
             XLATR = XLAT/CONV                                                   LLXY.25
             CELL = COS(XLATR)/(1.0+SIN(XLATR))                                  LLXY.26
             YY = -C2*ALOG(CELL)                                                 LLXY.27
             IF (XLONC.LT.0.0) THEN                                              LLXY.28
                IF (XLON.GT.0.0) XLON=XLON-360.                                  LLXY.29
             ELSE                                                                LLXY.30
                IF (XLON.LT.0.0) XLON=360.+XLON                                  LLXY.31
             ENDIF                                                               LLXY.32
             XX = C2*(XLON-XLONC)/CONV                                           LLXY.33
         ENDIF                                                                   LLXY.34
                                                                                 LLXY.35
      ELSE IF (KPROJ.EQ.1) THEN                                                  LLXY.36
C LAMBERT-COMFORMAL PROJECTION                                                   LLXY.37
      PHIC = ( POLE - XLATC )/CONV                                               LLXY.38
      PHI1 = PHI1/CONV                                                           LLXY.39
      XC = 0.0                                                                   LLXY.40
      YC = -A/XN*SIN(PHI1)*(TAN(PHIC/2.0)/TAN(PHI1/2.0))**XN                     LLXY.41
C                                                                                LLXY.42
C     CALCULATE X,Y COORDS. RELATIVE TO POLE                                     LLXY.43
C                                                                                LLXY.44
      YLON = XLON - XLONC                                                        LLXY.45
      IF(YLON.GT.180) YLON = YLON - 360.                                         LLXY.46
      IF(YLON.LT.-180) YLON = YLON + 360.                                        LLXY.47
      FLP = XN*YLON/CONV                                                         LLXY.48
      PSX = ( POLE - XLAT )/CONV                                                 LLXY.49
      R = -A/XN*SIN(PHI1)*(TAN(PSX/2.0)/TAN(PHI1/2.0))**XN                       LLXY.50
      IF ( XLATC.LT.0.0 ) THEN                                                   LLXY.51
         XX = R*SIN(FLP)                                                         LLXY.52
         YY = R*COS(FLP)                                                         LLXY.53
      ELSE                                                                       LLXY.54
         XX = -R*SIN(FLP)                                                        LLXY.55
         YY = R*COS(FLP)                                                         LLXY.56
      END IF                                                                     LLXY.57
      END IF                                                                     LLXY.58
C                                                                                LLXY.59
C  TRANSFORM (1,1) TO THE ORIGIN                                                 LLXY.60
C                                                                                LLXY.61
      CENTRI = FLOAT(IMAX + 1)/2.0                                               LLXY.62
      CENTRJ = FLOAT(JMAX + 1)/2.0                                               LLXY.63
      X = ( XX - XC )/DS + CENTRJ                                                LLXY.64
      Y = ( YY - YC )/DS + CENTRI                                                LLXY.65
      RETURN                                                                     LLXY.66
      END                                                                        LLXY.67
