      SUBROUTINE LLXYST(LAT,LON,X,Y)                                             LLXYST.1
      REAL LAT,LON                                                               LLXYST.2
      COMMON /XYLLC/ CC,DS,XLATC,XLONC,IBIG,JBIG,IPROJ,PSI1,PSI2                 LLXYST.3
      INTEGER DASH1, DASH2, COLOR1, COLOR2, COLOR3,                              LLXYST.4
     *                      COLOR4, COLOR5, COLOR6                               LLXYST.5
      LOGICAL HDRINFO,ICONDRV(2)                                                 LLXYST.6
      REAL LEVELS(100)                                                           LLXYST.7
      COMMON /DEFAULTS/ TRUELAT1, TRUELAT2, LW1, LW2,                            LLXYST.8
     * DASH1, DASH2, COLOR1, COLOR2, COLOR3,COLOR4,COLOR5,COLOR6,                LLXYST.9
     * HDRINFO,LOGP,XPTOP,ICONDRV,LMETH,LEVELS,UREL,VREL,                        LLXYST.10
     * LABLINE,LABMESG,NOZERO                                                    LLXYST.11
C                                                                                LLXYST.12
C  CONVERT LAT-LONG VALUES TO X-Y GRID LOCATIONS.                                LLXYST.13
C  WE ARE CONVERTING TO (DOT) POINTS                                             LLXYST.14
C                                                                                LLXYST.15
C                                                                                LLXYST.16
C  IMAX=MAX POINTS IN Y DIR FOR MAP GRID                                         LLXYST.17
C  JMAX=MAX POINTS IN X DIR FOR MAP GRID                                         LLXYST.18
C  XLATC=CENTER LAT                                                              LLXYST.19
C  XLONC=CENTER LONG                                                             LLXYST.20
C  DS=GRID SPACING(KM)                                                           LLXYST.21
C  WEST LONGITUDE IS ENTERED AS NEGATIVE                                         LLXYST.22
C  PSI IS THE CO-LATITUDE WHERE THE PROJECTION IS TRUE                           LLXYST.23
C                                                                                LLXYST.24
C                                                                                LLXYST.25
      EARTH=6370.                                                                LLXYST.26
      RAD=57.29578                                                               LLXYST.27
C                                                                                LLXYST.28
C  CONSTANTS THAT DEPEND ON THE MAP PROJECTION                                   LLXYST.29
C                                                                                LLXYST.30
      IF((TRUELAT1.LT.-90.).OR.(TRUELAT1.GT.90.)) THEN                           LLXYST.31
         PSI1=60.                                                                LLXYST.32
      ELSE IF ((TRUELAT1.GE.-90.) .AND.(TRUELAT1.LE.90.)) THEN                   LLXYST.33
         PSI1=TRUELAT1                                                           LLXYST.34
      ENDIF                                                                      LLXYST.35
      POLE=90.                                                                   LLXYST.39
      IF(XLATC.LT.0.) THEN                                                       LLXYST.40
         POLE=-POLE
      END IF                                                                     LLXYST.43
      PSI=POLE-PSI1
      PSI=PSI/RAD                                                                LLXYST.44
      TANXX=TAN(PSI/2.)                                                          LLXYST.45
      COSXX=COS(PSI)                                                             LLXYST.46
      SINEA=EARTH*SIN(PSI)                                                       LLXYST.47
C                                                                                LLXYST.48
C  CONSTANTS THAT ALSO DEPEND ON THE LOCATION                                    LLXYST.49
C  AND SIZE OF THE MAP                                                           LLXYST.50
C                                                                                LLXYST.51
      CI=FLOAT(IBIG+1)/2.                                                        LLXYST.52
      CJ=FLOAT(JBIG+1)/2.                                                        LLXYST.53
      PC=(POLE-XLATC)/RAD                                                        LLXYST.54
      A1=EARTH*SIN(PC)
      B1=(1.+COSXX)/(1.+COS(PC))                                                 LLXYST.56
      RC=A1*B1
      CX=(CJ-1.)*DS                                                              LLXYST.58
      CY=(CI-1.)*DS+RC                                                           LLXYST.59
C                                                                                LLXYST.60
C  VALUES THAT DEPEND ON LAT/LON LOCATION                                        LLXYST.61
C                                                                                LLXYST.62
      F=(LON-XLONC-POLE)/RAD
      P1=(POLE-LAT)/RAD                                                          LLXYST.64
      A=EARTH*SIN(P1)
      B=(1.+COSXX)/(1.+COS(P1))                                                  LLXYST.66
      R=A*B
      IF(XLATC.LT.0.) R=-R                                                       LLXYST.68
C                                                                                LLXYST.69
C  GET MAP GRID LOCATION                                                         LLXYST.70
C                                                                                LLXYST.71
      IF(XLATC.GE.0) THEN
         X=(R*COS(F)+CX)/DS+1.
      ELSE
         X=(-R*COS(F)+CX)/DS+1.
      END IF
      Y=(R*SIN(F)+CY)/DS+1.                                                      LLXYST.73
C                                                                                LLXYST.79
      RETURN                                                                     LLXYST.80
      END                                                                        LLXYST.81
