      SUBROUTINE MDIV(U,V,DMF,XMF,Q,I1,J1,K1,DS,DIV)                             MDIV.1
C                                                                                MDIV.2
C  SECTION DIAGNOSTIC                                                            MDIV.3
C  PUPOSE  COMPUTES MOISTURE DIVERGENCE                                          MDIV.4
C          MDIV (DEL DOT VQ) = Q * M*M (DU/DX + DV/DY)                           MDIV.5
C                              + V DOT DEL Q                                     MDIV.6
C                (PATTERNED AFTER SUBR DIVERG)                                   MDIV.7
C                ON ENTRY, ARRAY DIV CONTAINS THE MIXING RATIO Q.                MDIV.8
C                                                                                MDIV.9
      DIMENSION U(I1,J1,K1), V(I1,J1,K1), DIV(I1,J1,K1),                         MDIV.10
     &  XMF(I1,J1), DMF(I1,J1), Q(I1,J1)                                         MDIV.11
C                                                                                MDIV.12
      IF (DS .LT. 1000.) THEN                                                    MDIV.13
         DS2R = 1./(2.*DS*1000.)                                                 MDIV.14
      ELSE                                                                       MDIV.15
         DS2R = 1./(2.*DS)                                                       MDIV.16
      ENDIF                                                                      MDIV.17
C                                                                                MDIV.18
      DO 200 K = 1, K1                                                           MDIV.19
         DO 90 J = 1, J1-1                                                       MDIV.20
         DO 90 I = 1, I1-1                                                       MDIV.21
            Q(I,J)=DIV(I,J,K)                                                    MDIV.22
90       CONTINUE                                                                MDIV.23
         DO 100 J = 2, J1-2                                                      MDIV.24
         DO 100 I = 2, I1-2                                                      MDIV.25
            U1=U(I  ,J  ,K)/DMF(I  ,J  )                                         MDIV.26
            U2=U(I+1,J  ,K)/DMF(I+1,J  )                                         MDIV.27
            U3=U(I  ,J+1,K)/DMF(I  ,J+1)                                         MDIV.28
            U4=U(I+1,J+1,K)/DMF(I+1,J+1)                                         MDIV.29
            V1=V(I  ,J  ,K)/DMF(I  ,J  )                                         MDIV.30
            V2=V(I+1,J  ,K)/DMF(I+1,J  )                                         MDIV.31
            V3=V(I  ,J+1,K)/DMF(I  ,J+1)                                         MDIV.32
            V4=V(I+1,J+1,K)/DMF(I+1,J+1)                                         MDIV.33
            DIVM=Q(I,J)*(XMF(I,J)*XMF(I,J)*DS2R*                                 MDIV.34
     &           ((U3-U1+U4-U2)+(V2-V1+V4-V3)))                                  MDIV.35
            DQDX = (Q(I,J+1) - Q(I,J-1)) * DS2R                                  MDIV.36
            DQDY = (Q(I+1,J) - Q(I-1,J)) * DS2R                                  MDIV.37
            ADV=XMF(I,J)*XMF(I,J)*0.25*                                          MDIV.38
     &          ((U1+U2+U3+U4)*DQDX + (V1+V2+V3+V4)*DQDY)                        MDIV.39
            DIV(I,J,K) = DIVM + ADV                                              MDIV.40
100      CONTINUE                                                                MDIV.41
200   CONTINUE                                                                   MDIV.42
      CALL FILLIT(DIV,I1,J1,K1,I1,J1,2,I1-2,2,J1-2)                              MDIV.43
      RETURN                                                                     MDIV.44
      END                                                                        MDIV.45
