      SUBROUTINE MINMAX (Z,L,MM,NN,ISSIZM,AASH,JOFFDT)                           MINMAX.1
C                                                                                MINMAX.2
C THIS ROUTINE FINDS RELATIVE MINIMUMS AND MAXIMUMS.  A RELATIVE MINIMUM         MINMAX.3
C (OR MAXIMUM) IS DEFINED TO BE THE LOWEST (OR HIGHEST) POINT WITHIN             MINMAX.4
C A CERTAIN NEIGHBORHOOD OF THE POINT.  THE NEIGHBORHOOD USED HERE               MINMAX.5
C IS + OR - MN IN THE X DIRECTION AND + OR - NM IN THE Y DIRECTION.              MINMAX.6
C                                                                                MINMAX.7
C ORIGINATOR       DAVID KENNISON                                                MINMAX.8
C                                                                                MINMAX.9
      SAVE                                                                       MINMAX.10
      CHARACTER*7     IA                                                         MINMAX.11
      DIMENSION       Z(L,NN)                                                    MINMAX.12
C                                                                                MINMAX.13
C                                                                                MINMAX.14
C                                                                                MINMAX.15
      COMMON /CONRE1/ IOFFP      ,SPVAL                                          MINMAX.16
      COMMON /CONRE5/ SCLY                                                       MINMAX.17
C                                                                                MINMAX.18
C     FX(X,Y) = X                                                                MINMAX.19
C     FY(X,Y) = Y                                                                MINMAX.20
C                                                                                MINMAX.21
      M = MM                                                                     MINMAX.22
      N = NN                                                                     MINMAX.23
C                                                                                MINMAX.24
C SET UP SCALING FOR LABELS                                                      MINMAX.25
C                                                                                MINMAX.26
      SIZEM = (ISSIZM + 1)*256*SCLY                                              MINMAX.27
      ISIZEM = ISSIZM                                                            MINMAX.28
C                                                                                MINMAX.29
      ASH = ABS(AASH)                                                            MINMAX.30
      IOFFDT = JOFFDT                                                            MINMAX.31
C                                                                                MINMAX.32
      IF (AASH .LT. 0.0) GO TO 128                                               MINMAX.33
C                                                                                MINMAX.34
      MN = MIN0(15,MAX0(2,IFIX(FLOAT(M)/8.)))                                    MINMAX.35
      NM = MIN0(15,MAX0(2,IFIX(FLOAT(N)/8.)))                                    MINMAX.36
      NM1 = N-1                                                                  MINMAX.37
      MM1 = M-1                                                                  MINMAX.38
C                                                                                MINMAX.39
C LINE LOOP FOLLOWS - THE COMPLETE TWO-DIMENSIONAL TEST FOR A MINIMUM OR         MINMAX.40
C MAXIMUM OF THE FIELD IS ONLY PERFORMED FOR POINTS WHICH ARE MINIMA OR          MINMAX.41
C MAXIMA ALONG SOME LINE - FINDING THESE CANDIDATES IS MADE EFFICIENT BY         MINMAX.42
C USING A COUNT OF CONSECUTIVE INCREASES OR DECREASES OF THE FUNCTION            MINMAX.43
C ALONG THE LINE                                                                 MINMAX.44
C                                                                                MINMAX.45
      DO 127 JP=2,NM1                                                            MINMAX.46
C                                                                                MINMAX.47
         IM = MN-1                                                               MINMAX.48
         IP = -1                                                                 MINMAX.49
         GO TO 126                                                               MINMAX.50
C                                                                                MINMAX.51
C CONTROL RETURNS TO STATEMENT 10 AS LONG AS THE FUNCTION IS INCREASING          MINMAX.52
C ALONG THE LINE - WE SEEK A POSSIBLE MAXIMUM                                    MINMAX.53
C                                                                                MINMAX.54
  101    IP = IP+1                                                               MINMAX.55
         AA = AN                                                                 MINMAX.56
         IF (IP .EQ. MM1) GO TO 104                                              MINMAX.57
         AN = Z(IP+1,JP)                                                         MINMAX.58
         IF (IOFFP.NE.0 .AND. AN.EQ.SPVAL) GO TO 125                             MINMAX.59
         IF (AA-AN) 102,103,104                                                  MINMAX.60
  102    IM = IM+1                                                               MINMAX.61
         GO TO 101                                                               MINMAX.62
  103    IM = 0                                                                  MINMAX.63
         GO TO 101                                                               MINMAX.64
C                                                                                MINMAX.65
C FUNCTION DECREASED - TEST FOR MAXIMUM ON LINE                                  MINMAX.66
C                                                                                MINMAX.67
  104    IF (IM .GE. MN) GO TO 106                                               MINMAX.68
         IS = MAX0(1,IP-MN)                                                      MINMAX.69
         IT = IP-IM-1                                                            MINMAX.70
         IF (IS .GT. IT) GO TO 106                                               MINMAX.71
         DO 105 II=IS,IT                                                         MINMAX.72
            IF (AA .LE. Z(II,JP)) GO TO 112                                      MINMAX.73
  105    CONTINUE                                                                MINMAX.74
  106    IS = IP+2                                                               MINMAX.75
         IT = MIN0(M,IP+MN)                                                      MINMAX.76
         IF (IS .GT. IT) GO TO 109                                               MINMAX.77
         DO 108 II=IS,IT                                                         MINMAX.78
            IF (IOFFP.EQ.0 .OR. Z(II,JP).NE.SPVAL) GO TO 107                     MINMAX.79
            IP = II-1                                                            MINMAX.80
            GO TO 125                                                            MINMAX.81
  107       IF (AA .LE. Z(II,JP)) GO TO 112                                      MINMAX.82
  108    CONTINUE                                                                MINMAX.83
C                                                                                MINMAX.84
C WE HAVE MAXIMUM ON LINE - DO TWO-DIMENSIONAL TEST FOR MAXIMUM OF FIELD         MINMAX.85
C                                                                                MINMAX.86
  109    JS = MAX0(1,JP-NM)                                                      MINMAX.87
         JT = MIN0(N,JP+NM)                                                      MINMAX.88
         IS = MAX0(1,IP-MN)                                                      MINMAX.89
         IT = MIN0(M,IP+MN)                                                      MINMAX.90
         DO 111 JK=JS,JT                                                         MINMAX.91
            IF (JK .EQ. JP) GO TO 111                                            MINMAX.92
            DO 110 IK=IS,IT                                                      MINMAX.93
               IF (Z(IK,JK).GE.AA .OR.                                           MINMAX.94
     1             (IOFFP.NE.0 .AND. Z(IK,JK).EQ.SPVAL)) GO TO 112               MINMAX.95
  110       CONTINUE                                                             MINMAX.96
  111    CONTINUE                                                                MINMAX.97
C                                                                                MINMAX.98
         X = FLOAT(IP)                                                           MINMAX.99
         Y = FLOAT(JP)                                                           MINMAX.100
         CALL WTSTR ( FX(X,Y),FY(X,Y),'H',ISIZEM,0,0 )                           MINMAX.101
         CALL FL2INT ( FX(X,Y),FY(X,Y),IFX,IFY )                                 MINMAX.102
C                                                                                MINMAX.103
C SCALE TO USER SET RESOLUTION                                                   MINMAX.104
C                                                                                MINMAX.105
         IFY = IFY*SCLY                                                          MINMAX.106
         CALL ENCD (AA,ASH,IA,NC,IOFFDT)                                         MINMAX.107
         MY = IFY - SIZEM                                                        MINMAX.108
         TMY = CPUY ( MY )                                                       MINMAX.109
         CALL WTSTR ( FX(X,Y),TMY,IA(1:NC),ISIZEM,0,0 )                          MINMAX.110
  112    IM = 1                                                                  MINMAX.111
         IF (IP-MM1) 113,127,127                                                 MINMAX.112
C                                                                                MINMAX.113
C CONTROL RETURNS TO STATEMENT 20 AS LONG AS THE FUNCTION IS DECREASING          MINMAX.114
C ALONG THE LINE - WE SEEK A POSSIBLE MINIMUM                                    MINMAX.115
C                                                                                MINMAX.116
  113    IP = IP+1                                                               MINMAX.117
         AA = AN                                                                 MINMAX.118
         IF (IP .EQ. MM1) GO TO 116                                              MINMAX.119
         AN = Z(IP+1,JP)                                                         MINMAX.120
         IF (IOFFP.NE.0 .AND. AN.EQ.SPVAL) GO TO 125                             MINMAX.121
         IF (AA-AN) 116,115,114                                                  MINMAX.122
  114    IM = IM+1                                                               MINMAX.123
         GO TO 113                                                               MINMAX.124
  115    IM = 0                                                                  MINMAX.125
         GO TO 113                                                               MINMAX.126
C                                                                                MINMAX.127
C FUNCTION INCREASED - TEST FOR MINIMUM ON LINE                                  MINMAX.128
C                                                                                MINMAX.129
  116    IF (IM .GE. MN) GO TO 118                                               MINMAX.130
         IS = MAX0(1,IP-MN)                                                      MINMAX.131
         IT = IP-IM-1                                                            MINMAX.132
         IF (IS .GT. IT) GO TO 118                                               MINMAX.133
         DO 117 II=IS,IT                                                         MINMAX.134
            IF (AA .GE. Z(II,JP)) GO TO 124                                      MINMAX.135
  117    CONTINUE                                                                MINMAX.136
  118    IS = IP+2                                                               MINMAX.137
         IT = MIN0(M,IP+MN)                                                      MINMAX.138
         IF (IS .GT. IT) GO TO 121                                               MINMAX.139
         DO 120 II=IS,IT                                                         MINMAX.140
            IF (IOFFP.EQ.0 .OR. Z(II,JP).NE.SPVAL) GO TO 119                     MINMAX.141
            IP = II-1                                                            MINMAX.142
            GO TO 125                                                            MINMAX.143
  119       IF (AA .GE. Z(II,JP)) GO TO 124                                      MINMAX.144
  120    CONTINUE                                                                MINMAX.145
C                                                                                MINMAX.146
C WE HAVE MINIMUM ON LINE - DO TWO-DIMENSIONAL TEST FOR MINIMUM OF FIELD         MINMAX.147
C                                                                                MINMAX.148
  121    JS = MAX0(1,JP-NM)                                                      MINMAX.149
         JT = MIN0(N,JP+NM)                                                      MINMAX.150
         IS = MAX0(1,IP-MN)                                                      MINMAX.151
         IT = MIN0(M,IP+MN)                                                      MINMAX.152
         DO 123 JK=JS,JT                                                         MINMAX.153
            IF (JK .EQ. JP) GO TO 123                                            MINMAX.154
            DO 122 IK=IS,IT                                                      MINMAX.155
               IF (Z(IK,JK).LE.AA .OR.                                           MINMAX.156
     1             (IOFFP.NE.0 .AND. Z(IK,JK).EQ.SPVAL)) GO TO 124               MINMAX.157
  122       CONTINUE                                                             MINMAX.158
  123    CONTINUE                                                                MINMAX.159
C                                                                                MINMAX.160
         X = FLOAT(IP)                                                           MINMAX.161
         Y = FLOAT(JP)                                                           MINMAX.162
         CALL WTSTR ( FX(X,Y),FY(X,Y),'L',ISIZEM,0,0 )                           MINMAX.163
         CALL FL2INT( FX(X,Y),FY(X,Y),IFX,IFY )                                  MINMAX.164
         IFY = SCLY*IFY                                                          MINMAX.165
         CALL ENCD (AA,ASH,IA,NC,IOFFDT)                                         MINMAX.166
         MY = IFY - SIZEM                                                        MINMAX.167
         TMY = CPUY ( MY )                                                       MINMAX.168
         CALL WTSTR ( FX(X,Y),TMY,IA(1:NC),ISIZEM,0,0 )                          MINMAX.169
  124    IM = 1                                                                  MINMAX.170
         IF (IP-MM1) 101,127,127                                                 MINMAX.171
C                                                                                MINMAX.172
C SKIP SPECIAL VALUES ON LINE                                                    MINMAX.173
C                                                                                MINMAX.174
  125    IM = 0                                                                  MINMAX.175
  126    IP = IP+1                                                               MINMAX.176
         IF (IP .GE. MM1) GO TO 127                                              MINMAX.177
         IF (IOFFP.NE.0 .AND. Z(IP+1,JP).EQ.SPVAL) GO TO 125                     MINMAX.178
         IM = IM+1                                                               MINMAX.179
         IF (IM .LE. MN) GO TO 126                                               MINMAX.180
         IM = 1                                                                  MINMAX.181
         AN = Z(IP+1,JP)                                                         MINMAX.182
         IF (Z(IP,JP)-AN) 101,103,113                                            MINMAX.183
C                                                                                MINMAX.184
  127 CONTINUE                                                                   MINMAX.185
C                                                                                MINMAX.186
      RETURN                                                                     MINMAX.187
C                                                                                MINMAX.188
C ****************************** ENTRY PNTVAL **************************         MINMAX.189
C     ENTRY PNTVAL (Z,L,MM,NN,ISSIZM,AASH,JOFFDT)                                MINMAX.190
C                                                                                MINMAX.191
  128 CONTINUE                                                                   MINMAX.192
      II = (M-1+24)/24                                                           MINMAX.193
      JJ = (N-1+48)/48                                                           MINMAX.194
      NIQ = 1                                                                    MINMAX.195
      NJQ = 1                                                                    MINMAX.196
      DO 130 J=NJQ,N,JJ                                                          MINMAX.197
         Y = J                                                                   MINMAX.198
         DO 129 I=NIQ,M,II                                                       MINMAX.199
            X = I                                                                MINMAX.200
            ZZ = Z(I,J)                                                          MINMAX.201
            IF (IOFFP.NE.0 .AND. ZZ.EQ.SPVAL) GO TO 129                          MINMAX.202
            CALL ENCD (ZZ,ASH,IA,NC,IOFFDT)                                      MINMAX.203
            CALL WTSTR (FX(X,Y),FY(X,Y),IA(1:NC),ISIZEM,0,0 )                    MINMAX.204
  129    CONTINUE                                                                MINMAX.205
  130 CONTINUE                                                                   MINMAX.206
      RETURN                                                                     MINMAX.207
      END                                                                        MINMAX.208
