      SUBROUTINE MSESS(T,GHT, PP,SIG,SFP,I1,J1,K1,PTOP,XMSE)                     MSESS.1
C                                                                                MSESS.2
C     SECTION  DIAGNOSTICS                                                       MSESS.3
C     PURPOSE  SATURATED MOIST STATIC ENERGY ON SIGMA LEVELS                     MSESS.4
C                                                                                MSESS.5
      DIMENSION T(I1,J1,K1),GHT(I1,J1,K1),SIG(K1),SFP(I1,J1),                    MSESS.6
     *          PP(I1,J1,K1), XMSE(I1,J1,K1)                                     MSESS.7
C                                                                                MSESS.8
      CONST3 = (18.016*2.5E10)/8.3144E7                                          MSESS.9
      DO 100 K=1,K1                                                              MSESS.10
      DO 100 J=1,J1-1                                                            MSESS.11
      DO 100 I=1,I1-1                                                            MSESS.12
         P=SIG(K)*SFP(I,J)+PTOP+PP(I,J,K)                                        MSESS.13
         ES=6.11*EXP(CONST3/273.16 - CONST3/T(I,J,K))                            MSESS.14
         QS=0.622*ES/(P-ES)                                                      MSESS.15
         XMSE(I,J,K)=1004.*T(I,J,K)+9.81*GHT(I,J,K)+2.5E6*QS                     MSESS.16
 100  CONTINUE                                                                   MSESS.17
C                                                                                MSESS.18
      RETURN                                                                     MSESS.19
      END                                                                        MSESS.20
