      SUBROUTINE MXRAT(RH,T,P,IMX,JMX,KX,                                        MXRAT.1
     *                   Q)                                                      MXRAT.2
C                                                                                MXRAT.3
C     SECTION  DIAGNOSTIC                                                        MXRAT.4
C     PURPOSE  COMPUTES THE MIXING RATIO FROM THE 3D TEMPERATURE,                MXRAT.5
C              RELATIVE HUMIDITY AND 3D PRESSURE VALUE.                          MXRAT.6
C                                                                                MXRAT.7
C     INPUT       RH       RELATIVE HUMIDITY          CROSS    3D                MXRAT.8
C                 T        T                          CROSS    3D                MXRAT.9
C                 P        PRESSURE                            3D                MXRAT.10
C                 IMX      DOT POINT DIMENSION N-S                               MXRAT.11
C                 JMX      DOT POINT DIMENSION E-W                               MXRAT.12
C                 KX       NUMBER OF VERTICAL LEVELS                             MXRAT.13
C                                                                                MXRAT.14
C     OUTPUT      Q        MIXING RATIO               CROSS    3D                MXRAT.15
C                                                                                MXRAT.16
      DIMENSION RH(IMX,JMX,KX) ,T(IMX,JMX,KX) ,P(IMX,JMX,KX)                     MXRAT.17
      DIMENSION Q(IMX,JMX,KX)                                                    MXRAT.18
C                                                                                MXRAT.19
      CONST1 = (18.016*2.5E10)/(8.3144E7*273.16)                                 MXRAT.20
      CONST2 = (18.016*2.5E10)/ 8.3144E7                                         MXRAT.21
C                                                                                MXRAT.22
C     ... MIXING RATIO                                                           MXRAT.23
C                                                                                MXRAT.24
      DO 600 K=1,KX                                                              MXRAT.25
      DO 600 J=1,JMX-1                                                           MXRAT.26
      DO 600 I=1,IMX-1                                                           MXRAT.27
         ES=6.11*EXP(CONST1-CONST2/T(I,J,K))                                     MXRAT.28
         QS=0.622*ES/(P(I,J,K)-ES)                                               MXRAT.29
         Q(I,J,K)=AMAX1(0.01*RH(I,J,K)*QS,0.0)                                   MXRAT.30
600   CONTINUE                                                                   MXRAT.31
      RETURN                                                                     MXRAT.32
      END                                                                        MXRAT.33
