      SUBROUTINE MXRATPRS(RH,T,P,PSFC,IMX,JMX,KX,ISFC,                           MXRATPRS.1
     *                   Q)                                                      MXRATPRS.2
C                                                                                MXRATPRS.3
C     SECTION  DIAGNOSTIC                                                        MXRATPRS.4
C     PURPOSE  COMPUTES THE MIXING RATIO FROM THE 3D TEMPERATURE,                MXRATPRS.5
C              RELATIVE HUMIDITY AND PRESSURE VALUE.  THIS IS                    MXRATPRS.6
C              COMPUTED ON P SURFACES.  THIS ALSO CAN COMPUTE                    MXRATPRS.7
C              SURFACE Q, FROM SURFACE T, SURFACE RH, AND                        MXRATPRS.8
C              SURFACE P.  IN  THIS CASE THE ISFC =1.                            MXRATPRS.9
C                                                                                MXRATPRS.10
C     INPUT       RH       RELATIVE HUMIDITY          CROSS    3D                MXRATPRS.11
C                 T        T                          CROSS    3D                MXRATPRS.12
C                 P        P LEVELS                            1D                MXRATPRS.13
C                 PSFC     SURFACE PRESSURE           CROSS    2D                MXRATPRS.14
C                 IMX      DOT POINT DIMENSION N-S                               MXRATPRS.15
C                 JMX      DOT POINT DIMENSION E-W                               MXRATPRS.16
C                 KX       NUMBER OF VERTICAL LEVELS                             MXRATPRS.17
C                 ISFC     =1 SURFACE, =0 3D DOMAIN                              MXRATPRS.18
C                                                                                MXRATPRS.19
C     OUTPUT      Q        MIXING RATIO               CROSS    3D                MXRATPRS.20
C                                                                                MXRATPRS.21
      DIMENSION RH(IMX,JMX,KX) ,T(IMX,JMX,KX) ,P(KX),                            MXRATPRS.22
     *          PSFC(IMX,JMX)                                                    MXRATPRS.23
      DIMENSION Q(IMX,JMX,KX)                                                    MXRATPRS.24
C                                                                                MXRATPRS.25
      CONST1 = (18.016*2.5E10)/(8.3144E7*273.16)                                 MXRATPRS.26
      CONST2 = (18.016*2.5E10)/ 8.3144E7                                         MXRATPRS.27
C                                                                                MXRATPRS.28
C     ... MIXING RATIO                                                           MXRATPRS.29
C                                                                                MXRATPRS.30
      IF(ISFC.EQ.0) THEN     ! 3D DOMAIN                                         MXRATPRS.31
         DO 600 K=1,KX                                                           MXRATPRS.32
         DO 600 J=1,JMX-1                                                        MXRATPRS.33
         DO 600 I=1,IMX-1                                                        MXRATPRS.34
            ES=6.11*EXP(CONST1-CONST2/T(I,J,K))                                  MXRATPRS.35
            QS=0.622*ES/(P(K)-ES)                                                MXRATPRS.36
            Q(I,J,K)=AMAX1(0.01*RH(I,J,K)*QS,0.0)                                MXRATPRS.37
600      CONTINUE                                                                MXRATPRS.38
      ELSE IF(ISFC.EQ.1) THEN  ! SURFACE VALUES                                  MXRATPRS.39
         K=1                                                                     MXRATPRS.40
         DO 700 J=1,JMX-1                                                        MXRATPRS.41
         DO 700 I=1,IMX-1                                                        MXRATPRS.42
            ES=6.11*EXP(CONST1-CONST2/T(I,J,K))                                  MXRATPRS.43
            QS=0.622*ES/(PSFC(I,J)-ES)                                           MXRATPRS.44
            Q(I,J,K)=AMAX1(.01*RH(I,J,K)*QS,0.0)                                 MXRATPRS.45
700      CONTINUE                                                                MXRATPRS.46
      ELSE IF(ISFC.EQ.2) THEN     ! 3D + SFC DOMAIN                              MXRATPRS.47
         DO 800 K=2,KX                                                           MXRATPRS.48
         DO 800 J=1,JMX-1                                                        MXRATPRS.49
         DO 800 I=1,IMX-1                                                        MXRATPRS.50
            ES=6.11*EXP(CONST1-CONST2/T(I,J,K))                                  MXRATPRS.51
            QS=0.622*ES/(P(K)-ES)                                                MXRATPRS.52
            Q(I,J,K)=AMAX1(0.01*RH(I,J,K)*QS,0.0)                                MXRATPRS.53
800      CONTINUE                                                                MXRATPRS.54
         K=1                                                                     MXRATPRS.55
         DO 900 J=1,JMX-1                                                        MXRATPRS.56
         DO 900 I=1,IMX-1                                                        MXRATPRS.57
            ES=6.11*EXP(CONST1-CONST2/T(I,J,K))                                  MXRATPRS.58
            QS=0.622*ES/(PSFC(I,J)-ES)                                           MXRATPRS.59
            Q(I,J,K)=AMAX1(.01*RH(I,J,K)*QS,0.0)                                 MXRATPRS.60
900      CONTINUE                                                                MXRATPRS.61
      END IF                                                                     MXRATPRS.62
      RETURN                                                                     MXRATPRS.63
      END                                                                        MXRATPRS.64
