      SUBROUTINE NHGEOSIG(PSC,SIGMA,PTOP,I1,J1,K1,H)                             NHGEOSIG.1
C                                                                                NHGEOSIG.2
#     include <headerv3.incl>                                                    NHGEOSIG.3
C                                                                                NHGEOSIG.4
      DIMENSION PSC(I1,J1),SIGMA(K1),H(I1,J1,K1)                                 NHGEOSIG.5
C                                                                                NHGEOSIG.6
      R    = 287.04                                                              05DEC01.110
      IDNT = BHI(  1,1)                                                          NHGEOSIG.8
      P0S  = BHR(  2,5)/100.                                                     NHGEOSIG.9
      TS0  = BHR(  3,5)                                                          NHGEOSIG.10
      TLP  = BHR(  4,5)                                                          NHGEOSIG.11
      TISO = BHR(  5,5)                                                          NHGEOSIG.12
      G    = 9.81                                                                05DEC01.111
      DO 100 K=1,K1                                                              NHGEOSIG.14
      DO 100 J=1,J1-1                                                            NHGEOSIG.15
      DO 100 I=1,I1-1                                                            NHGEOSIG.16
         P0=SIGMA(K)*PSC(I,J)+PTOP                                               NHGEOSIG.17
         TERM1=R*TLP/(2.*G)*(ALOG(P0/P0S))**2                                    NHGEOSIG.18
         TERM2=R*TS0/G * ALOG(P0/P0S)                                            NHGEOSIG.19
         H(I,J,K)=-(TERM1+TERM2)                                                 NHGEOSIG.20
100   CONTINUE                                                                   NHGEOSIG.21
C                                                                                NHGEOSIG.22
C ... FIND THE HEIGHT WHERE THE BASE STATE TURNS ISOTHERMAL,                     NHGEOSIG.23
C       THEN CORRECT HEIGHT ABOVE THAT TEMPERATURE                               NHGEOSIG.24
C                                                                                NHGEOSIG.25
      IF (TISO.GT.0) THEN                                                        NHGEOSIG.26
         DO K=1,K1                                                               NHGEOSIG.27
         DO J=1,J1-1                                                             NHGEOSIG.28
         DO I=1,I1-1                                                             NHGEOSIG.29
           P0ISO=P0S*EXP( (TISO-TS0)/TLP )                                       NHGEOSIG.30
           TERM1=R*TLP/(2.*G)*(ALOG(P0ISO/P0S))**2                               NHGEOSIG.31
           TERM2=R*TS0/G * ALOG(P0ISO/P0S)                                       NHGEOSIG.32
           ZISO =-(TERM1+TERM2)                                                  NHGEOSIG.33
           IF (H(I,J,K).GT.ZISO) THEN                                            NHGEOSIG.34
              P0=SIGMA(K)*PSC(I,J)+PTOP                                          NHGEOSIG.35
              H(I,J,K)=ZISO+(R*TISO)/G*(ALOG(P0ISO)-ALOG(P0))                    NHGEOSIG.36
           END IF                                                                NHGEOSIG.37
         END DO                                                                  NHGEOSIG.38
         END DO                                                                  NHGEOSIG.39
         END DO                                                                  NHGEOSIG.40
      END IF                                                                     NHGEOSIG.41
                                                                                 NHGEOSIG.42
      RETURN                                                                     NHGEOSIG.43
      END                                                                        NHGEOSIG.44
