      SUBROUTINE OMEGAP(DIV,US,VS,DMF,XMF,PSFC,P,DS,I1,J1,K1,PROG,               OMEGAP.1
     *                  OMG)                                                     OMEGAP.2
C                                                                                OMEGAP.3
C  SECTION DIAGNOSTIC                                                            OMEGAP.4
C  PUPOSE  COMPUTES OMEGA ON PRESSURE SURFACES.                                  OMEGAP.5
C          FOR MODEL OUTPUT, ALLOW OMEGA AT SFC.                                 OMEGAP.6
C          FOR ANALYSIS DATA, USE O'BRIEN CORRECTION TO BRING                    OMEGAP.7
C          OMEGA = 0 AT TOP OF DOMAIN.                                           OMEGAP.8
C                                                                                OMEGAP.9
#     include <scratch.incl>                                                     OMEGAP.10
      DIMENSION OMG(I1,J1,K1), PSFC(I1,J1),P(K1),DIV(I1,J1,K1),                  OMEGAP.11
     *          US(I1,J1), VS(I1,J1), DMF(I1,J1), XMF(I1,J1)                     OMEGAP.12
      DIMENSION XK1(K_MAX)                                                       OMEGAP.13
      CHARACTER *6 PROG                                                          OMEGAP.14
                                                                                 OMEGAP.15
C ...... COMPUTE OMEGA AT THE SURFACE, IF MODEL OUTPUT                           OMEGAP.16
                                                                                 OMEGAP.17
      DX8 = 8.*DS                                                                OMEGAP.18
      IF((PROG(1:6).EQ.'MMOUTP') .OR.                                            OMEGAP.19
     *   (PROG(1:6).EQ.'MZIGPR')) THEN                                           OMEGAP.20
         DO 10 I = 1,I1                                                          OMEGAP.21
         DO 10 J = 1,J1                                                          OMEGAP.22
            US(I,J) = US(I,J)/DMF(I,J)                                           OMEGAP.23
            VS(I,J) = VS(I,J)/DMF(I,J)                                           OMEGAP.24
10       CONTINUE                                                                OMEGAP.25
                                                                                 OMEGAP.26
         DO 20 I = 2,I1-2                                                        OMEGAP.27
         DO 20 J = 2,J1-2                                                        OMEGAP.28
            OMG(I,J,1) =( (US(I,J)+US(I,J+1)+US(I+1,J)+US(I+1,J+1))              OMEGAP.29
     *                   *(PSFC(I,J+1)-PSFC(I,J-1))                              OMEGAP.30
     *                   +(VS(I,J)+VS(I,J+1)+VS(I+1,J)+VS(I+1,J+1))              OMEGAP.31
     *                   *(PSFC(I+1,J)-PSFC(I-1,J)) )*XMF(I,J) / DX8             OMEGAP.32
20       CONTINUE                                                                OMEGAP.33
      ELSE                                                                       OMEGAP.34
         DO 30 J=1,J1                                                            OMEGAP.35
         DO 30 I=1,I1                                                            OMEGAP.36
            OMG(I,J,1)=1.E-6                                                     OMEGAP.37
30       CONTINUE                                                                OMEGAP.38
      ENDIF                                                                      OMEGAP.39
      CALL FILLIT(OMG(1,1,1),I1,J1,1,I1,J1,2,I1-2,2,J1-2)                        OMEGAP.40
                                                                                 OMEGAP.41
C----------------------------------------------------------                      OMEGAP.42
                                                                                 OMEGAP.43
      DO 100 I = 1,I1-1                                                          OMEGAP.44
      DO 100 J = 1,J1-1                                                          OMEGAP.45
         KABOVEG = 0                                                             OMEGAP.46
      DO 90 K = 2,K1                                                             OMEGAP.47
         IF (P(K).GT.PSFC(I,J)) THEN                                             OMEGAP.48
            OMG(I,J,K) = 0.                                                      OMEGAP.49
            KABOVEG = 1                                                          OMEGAP.50
         ELSE                                                                    OMEGAP.51
            IF (KABOVEG.LE.1) THEN                                               OMEGAP.52
               OMG(I,J,K) = OMG(I,J,1)                                           OMEGAP.53
               KABOVEG = 2                                                       OMEGAP.54
               GOTO 90                                                           OMEGAP.55
            ELSE IF (KABOVEG.EQ.2) THEN                                          OMEGAP.56
               DP = PSFC(I,J) - P(K)                                             OMEGAP.57
               KABOVEG = 3                                                       OMEGAP.58
            ELSE                                                                 OMEGAP.59
               DP = P(K-1) - P(K)                                                OMEGAP.60
            END IF                                                               OMEGAP.61
               DD = 0.5*(DIV(I,J,K-1)+DIV(I,J,K))                                OMEGAP.62
               OMG(I,J,K) = OMG(I,J,K-1) + DD * DP                               OMEGAP.63
C ...... ESTIMATE OMEGA FOR THE FIRST LEVEL ABOVE THE GROUND                     OMEGAP.64
               IF (KABOVEG.EQ.3) THEN                                            OMEGAP.65
                   OMG(I,J,K-1) = OMG(I,J,1)+(OMG(I,J,K)-OMG(I,J,1))             OMEGAP.66
     *               *(PSFC(I,J)-P(K-1))/(PSFC(I,J)-P(K))                        OMEGAP.67
                   KABOVEG = KABOVEG + 1                                         OMEGAP.68
               END IF                                                            OMEGAP.69
         END IF                                                                  OMEGAP.70
90    CONTINUE                                                                   OMEGAP.71
100   CONTINUE                                                                   OMEGAP.72
                                                                                 OMEGAP.73
C ...... USE O'BRIEN METHOD TO CORRECT BOTH DIVERGENCE AND OMEGA                 OMEGAP.74
C        ASSUMING OMEGA = 0. AT K=K1                                             OMEGAP.75
C        (THE PROPORTIONAL COEFF IS A LINEAR FUNCTION OF PRESSURE)               OMEGAP.76
                                                                                 OMEGAP.77
      IF((PROG(1:6).EQ.'REGRID').OR.                                             OMEGAP.78
     *   (PROG(1:6).EQ.'RAWINS')) THEN                                           OMEGAP.79
         DO 110 I = 1,I1-1                                                       OMEGAP.80
         DO 110 J = 1,J1-1                                                       OMEGAP.81
            KABOVEG = 2                                                          OMEGAP.82
            XKK     = 0.                                                         OMEGAP.83
            XK2     = 0.                                                         OMEGAP.84
            DO 120 K = 2,K1                                                      OMEGAP.85
               IF (P(K).GT.PSFC(I,J)) THEN                                       OMEGAP.86
                  KABOVEG = KABOVEG + 1                                          OMEGAP.87
                  XK1(K) = 0.                                                    OMEGAP.88
               ELSE                                                              OMEGAP.89
                  XK1(K) = PSFC(I,J)-P(K)                                        OMEGAP.90
                  XKK = XKK + XK1(K)                                             OMEGAP.91
               END IF                                                            OMEGAP.92
120         CONTINUE                                                             OMEGAP.93
               XK2 = XK2 + XK1(K)                                                OMEGAP.94
               OMG(I,J,K) = OMG(I,J,K) - XK2/XKK*OMG(I,J,K1)                     OMEGAP.95
130         CONTINUE                                                             OMEGAP.96
110      CONTINUE                                                                OMEGAP.97
      ENDIF                                                                      OMEGAP.98
C                                                                                OMEGAP.99
      RETURN                                                                     OMEGAP.100
      END                                                                        OMEGAP.101
