      SUBROUTINE OMEGAS(U,V,DM,XM,PSC,PSD,SIGH,                                  OMEGAS.1
     *   I1,J1,K1,DS,OMG,                                                        OMEGAS.2
     *   PUM,PVM,DIV,DPDT,SDOT,DUDX,DVDY,XMSQ,                                   OMEGAS.3
     *   DPDX,DPDY,UX,VX,DSG )                                                   OMEGAS.4
C                                                                                OMEGAS.5
#     include <scratch.incl>                                                     OMEGAS.6
C                                                                                OMEGAS.7
      INEED = 10*I1*J1 + 2*I1*J1*(K1+1) + K1                                     OMEGAS.8
C                                                                                OMEGAS.9
      IN1 = NTEMP                                                                OMEGAS.10
      IN2 = IN1+I1*J1                                                            OMEGAS.11
      IN3 = IN2+I1*J1                                                            OMEGAS.12
      IN4 = IN3+I1*J1*(K1+1)                                                     OMEGAS.13
      IN5 = IN4+I1*J1                                                            OMEGAS.14
      IN6 = IN5+I1*J1*(K1+1)                                                     OMEGAS.15
      IN7 = IN6+I1*J1                                                            OMEGAS.16
      IN8 = IN7+I1*J1                                                            OMEGAS.17
      IN9 = IN8+I1*J1                                                            OMEGAS.18
      IN10 = IN9+I1*J1                                                           OMEGAS.19
      IN11 = IN10+I1*J1                                                          OMEGAS.20
      IN12 = IN11+I1*J1                                                          OMEGAS.21
      IN13 = IN12+I1*J1                                                          OMEGAS.22
C                                                                                OMEGAS.23
      NTEMP = NTEMP+INEED                                                        OMEGAS.24
      IF(NTEMP .GT. I_SCRATCH) CALL SPACE_STOP('OMEGAS')                         OMEGAS.25
      IF(VERBOSE) WRITE(6,*) ' CALLING OMEGAS ',INEED,IN1,NTEMP                  OMEGAS.26
        CALL OMEGAS_0(U,V,DM,XM,PSC,PSD,SIGH,                                    OMEGAS.27
     *   I1,J1,K1,DS,OMG,                                                        OMEGAS.28
     *   SCR(IN1),SCR(IN2),SCR(IN3),SCR(IN4),SCR(IN5),                           OMEGAS.29
     *   SCR(IN6),SCR(IN7),SCR(IN8),SCR(IN9),SCR(IN10),                          OMEGAS.30
     *   SCR(IN11),SCR(IN12),SCR(IN13) )                                         OMEGAS.31
C                                                                                OMEGAS.32
      NTEMP = NTEMP - INEED                                                      OMEGAS.33
      IF(VERBOSE) WRITE(6,*) ' RET FROM OMEGAS ',NTEMP                           OMEGAS.34
      RETURN                                                                     OMEGAS.35
      END                                                                        OMEGAS.36
C                                                                                OMEGAS.37
      SUBROUTINE OMEGAS_0(U,V,DM,XM,PSC,PSD,SIGH,                                OMEGAS.38
     *   I1,J1,K1,DS,OMG,                                                        OMEGAS.39
     *   PUM,PVM,DIV,DPDT,SDOT,DUDX,DVDY,XMSQ,                                   OMEGAS.40
     *   DPDX,DPDY,UX,VX,DSG )                                                   OMEGAS.41
C                                                                                OMEGAS.42
C     SECTION  DIAGNOSTIC                                                        OMEGAS.43
C     PURPOSE  COMPUTES THE VERTICAL VELOCITY OMEGA ON SIGMA SURFACES            OMEGAS.44
C              USING DIV(P* VELOCITY/M).                                         OMEGAS.45
C                                                                                OMEGAS.46
C     INPUT       U        U                          DOT      3D                OMEGAS.47
C                 V        V                          DOT      3D                OMEGAS.48
C                 DM       MAP FACTOR                 DOT      2D                OMEGAS.49
C                 XM       MAP FACTOR                 CROSS    2D                OMEGAS.50
C                 PSC      P* = PSURF - PTOP          CROSS    2D                OMEGAS.51
C                 PSD      P* = PSURF - PTOP          DOT      2D                OMEGAS.52
C                 DSG      DELTA SIGMA                         1D                OMEGAS.53
C                 SIGH     SIGMA ON HALF LEVELS                1D                OMEGAS.54
C                 I1      DOT POINT DIMENSION N-S                                OMEGAS.55
C                 J1      DOT POINT DIMENSION E-W                                OMEGAS.56
C                 DS       GRID DISTANCE                                         OMEGAS.57
C                                                                                OMEGAS.58
C     STACK       PUM      U COUPLED WITH P* AND MF   DOT      2D                OMEGAS.59
C                 PVM      V COUPLED WITH P* AND MF   DOT      2D                OMEGAS.60
C                 DPDT     PRESS TENDENCY             CROSS    2D                OMEGAS.61
C                 SDOT     SIGMA DOT, FULL LEVELS     CROSS    3D                OMEGAS.62
C               E DPDX     PARTIAL OF P*              CROSS    2D                OMEGAS.63
C               E DPDY     PARTIAL OF P*              CROSS    2D                OMEGAS.64
C               E UX       U ON CROSS POINT, SLAB     CROSS    2D                OMEGAS.65
C               E VX       V ON CROSS POINT, SLAB     CROSS    2D                OMEGAS.66
C                                                                                OMEGAS.67
C     OUTPUT      OMG      OMEGA                      CROSS    3D                OMEGAS.68
C                                                                                OMEGAS.69
      DIMENSION U(I1,J1,K1)  ,V(I1,J1,K1)  ,DM(I1,J1)   ,                        OMEGAS.70
     *          XM(I1,J1)     ,PSC(I1,J1)    ,PSD(I1,J1)  ,                      OMEGAS.71
     *          SIGH(K1)                                                         OMEGAS.72
C                                                                                OMEGAS.73
      DIMENSION PUM(I1,J1)  ,PVM(I1,J1)  ,DIV(I1,J1,K1),                         OMEGAS.74
     *          DPDT(I1,J1) ,SDOT(I1,J1,K1+1),                                   OMEGAS.75
     *          DUDX(I1,J1) ,DVDY(I1,J1) ,XMSQ(I1,J1),                           OMEGAS.76
     *          DPDX(I1,J1) ,DPDY(I1,J1) ,UX(I1,J1)  ,                           OMEGAS.77
     *          DSG(K1)        ,VX(I1,J1)                                        OMEGAS.78
      DIMENSION OMG(I1,J1,K1)                                                    OMEGAS.79
C                                                                                OMEGAS.80
C     EQUIVALENCE (PUM(1,1),DPDX(1,1))                                           OMEGAS.81
C     EQUIVALENCE (PVM(1,1),DPDY(1,1))                                           OMEGAS.82
C     EQUIVALENCE (DUDX(1,1),UX(1,1))                                            OMEGAS.83
C     EQUIVALENCE (DVDY(1,1),VX(1,1))                                            OMEGAS.84
C     EQUIVALENCE (SDOT(1,1,2),DIV(1,1,1))                                       OMEGAS.85
C                                                                                OMEGAS.86
      SFT=0.                                                                     OMEGAS.87
      DO 10 K=1,K1                                                               OMEGAS.88
         SFB=2.*SIGH(K)-SFT                                                      OMEGAS.89
         DSG(K)=SFB-SFT                                                          OMEGAS.90
         SFT=SFB                                                                 OMEGAS.91
10    CONTINUE                                                                   OMEGAS.92
C                                                                                OMEGAS.93
      DO 100 I=1,I1-1                                                            OMEGAS.94
      DO 100 J=1,J1-1                                                            OMEGAS.95
         DPDT(I,J) = 0.                                                          OMEGAS.96
         XMSQ(I,J)=XM(I,J)*XM(I,J)                                               OMEGAS.97
100   CONTINUE                                                                   OMEGAS.98
C                                                                                OMEGAS.99
C     ... COUPLE U AND V WITH P* AND MAP FACTORS                                 OMEGAS.100
C                                                                                OMEGAS.101
      ONEOV2DS=1./(2.*DS)                                                        OMEGAS.102
      DO 150 K=1,K1                                                              OMEGAS.103
         DO 120 J=1,J1                                                           OMEGAS.104
         DO 120 I=1,I1                                                           OMEGAS.105
            PUM(I,J) = PSD(I,J) * U(I,J,K) / DM(I,J)                             OMEGAS.106
            PVM(I,J) = PSD(I,J) * V(I,J,K) / DM(I,J)                             OMEGAS.107
120      CONTINUE                                                                OMEGAS.108
         DO 130 J=1,J1-1                                                         OMEGAS.109
         DO 130 I=1,I1-1                                                         OMEGAS.110
            DUDX(I,J)=PUM(I+1,J+1)+PUM(I,J+1)-                                   OMEGAS.111
     *      PUM(I+1,J)-PUM(I,J)                                                  OMEGAS.112
            DVDY(I,J)=PVM(I+1,J+1)+PVM(I+1,J)-                                   OMEGAS.113
     *      PVM(I,J+1)-PVM(I,J)                                                  OMEGAS.114
130      CONTINUE                                                                OMEGAS.115
         DO 140 J=1,J1-1                                                         OMEGAS.116
         DO 140 I=1,I1-1                                                         OMEGAS.117
            DIV(I,J,K)=(DUDX(I,J)*ONEOV2DS+DVDY(I,J)*ONEOV2DS)*XMSQ(I,J)         OMEGAS.118
            DPDT(I,J) = DPDT(I,J) - DIV(I,J,K)*DSG(K)                            OMEGAS.119
140      CONTINUE                                                                OMEGAS.120
150   CONTINUE                                                                   OMEGAS.121
C                                                                                OMEGAS.122
C     ... SIGMA DOT ON FULL SIGMA LEVELS, SDOT AT MODEL LID SET TO 0             OMEGAS.123
C                                                                                OMEGAS.124
      DO 170 J=1,J1-1                                                            OMEGAS.125
      DO 170 I=1,I1-1                                                            OMEGAS.126
         SDOT(I,J,1)=0.                                                          OMEGAS.127
170   CONTINUE                                                                   OMEGAS.128
C                                                                                OMEGAS.129
      DO 260 K=1,K1                                                              OMEGAS.130
      DO 260 J=1,J1-1                                                            OMEGAS.131
      DO 260 I=1,I1-1                                                            OMEGAS.132
         SDOT(I,J,K+1) = SDOT(I,J,K) - (DSG(K)/PSC(I,J)) *                       OMEGAS.133
     *   (DPDT(I,J) + DIV(I,J,K))                                                OMEGAS.134
260   CONTINUE                                                                   OMEGAS.135
C                                                                                OMEGAS.136
C     ... COMPUTE OMEGA ON HALF SIGMA LEVELS                                     OMEGAS.137
C                                                                                OMEGAS.138
      DS8=DS*8.                                                                  OMEGAS.139
      DO 280 J=1,J1-1                                                            OMEGAS.140
      DO 280 I=1,I1-1                                                            OMEGAS.141
         DPDX(I,J)=(PSD(I+1,J+1)+PSD(I,J+1)-PSD(I+1,J)-PSD(I,J))*XM(I,J)         OMEGAS.142
         DPDY(I,J)=(PSD(I+1,J+1)+PSD(I+1,J)-PSD(I,J+1)-PSD(I,J))*XM(I,J)         OMEGAS.143
         DPDT(I,J)=DPDT(I,J) * DS8                                               OMEGAS.144
280   CONTINUE                                                                   OMEGAS.145
C                                                                                OMEGAS.146
      DO 350 K=1,K1                                                              OMEGAS.147
         DO 290 J=1,J1-1                                                         OMEGAS.148
         DO 290 I=1,I1-1                                                         OMEGAS.149
            UX(I,J)=U(I+1,J+1,K)+U(I,J+1,K)+U(I+1,J,K)+U(I,J,K)                  OMEGAS.150
            VX(I,J)=V(I+1,J+1,K)+V(I,J+1,K)+V(I+1,J,K)+V(I,J,K)                  OMEGAS.151
290      CONTINUE                                                                OMEGAS.152
         CON=SIGH(K)/(8.*DS)                                                     OMEGAS.153
         DO 300 J=1,J1-1                                                         OMEGAS.154
         DO 300 I=1,I1-1                                                         OMEGAS.155
            OMG(I,J,K)=PSC(I,J)*(SDOT(I,J,K)+SDOT(I,J,K+1))*0.5 +                OMEGAS.156
     *      CON * (DPDT(I,J)+UX(I,J)*DPDX(I,J)+VX(I,J)*DPDY(I,J))                OMEGAS.157
300      CONTINUE                                                                OMEGAS.158
350   CONTINUE                                                                   OMEGAS.159
C                                                                                OMEGAS.160
      CALL FILLIT(OMG,I1,J1,K1,I1,J1,2,I1-2,2,J1-2)                              OMEGAS.161
      RETURN                                                                     OMEGAS.162
      END                                                                        OMEGAS.163
