      subroutine clproc (xcs,ycs,ncs,aid,gid,nid)                                PLOTS.1
                                                                                 PLOTS.2
C*****************************************************************************C  PLOTS.3
C  clproc   - This is a MAPDRV routine                                        C  PLOTS.4
C  Section  - Fill                                                            C  PLOTS.5
C  Purpose  - This is the routine that does the color fill on countries,      C  PLOTS.6
C             states and continents.                                          C  PLOTS.7
C                                                                             C  PLOTS.8
C  On entry - XCS and YCS contain NCS  pairs which are x, y  coordinate pairs C  PLOTS.9
C             that describe a polygon to be filled.   AID  is an array of NID C  PLOTS.10
C             area identifiers for the polygon.  GID is an array of NID group C  PLOTS.11
C             identifiers for  the  polygon.   Color information for all non- C  PLOTS.12
C             water colors is passed in through the common block  FLINFO  and C  PLOTS.13
C             WACOLR, water color is passed in through common block FLWATR.   C  PLOTS.14
C                                                                             C  PLOTS.15
C  On exit  - The map in has been colored.                                    C  PLOTS.16
C                                                                             C  PLOTS.17
C  Assume   - GKS is open.  This routine is called by the AREAS utility.      C  PLOTS.18
C                                                                             C  PLOTS.19
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.20
C             ----------------------------------------------------------------C  PLOTS.21
C             SFSGFA              SOFTFILL utility*                           C  PLOTS.22
C             ----------------------------------------------------------------C  PLOTS.23
C             * NCAR Graphics routine                                         C  PLOTS.24
C                                                                             C  PLOTS.25
C             This routine is not called by the MAPDRV utility, rather it  is C  PLOTS.26
C             called by the AREAS utility.                                    C  PLOTS.27
C                                                                             C  PLOTS.28
C  Author   - Jeremy Asbill        Date - July 7, 1990       for the MM4 club C  PLOTS.29
C*****************************************************************************C  PLOTS.30
                                                                                 PLOTS.31
C  Integer variables                                                             PLOTS.32
                                                                                 PLOTS.33
      integer          aid(*),           ! area identifiers                (in)  PLOTS.34
     *                 gid(*),           ! group identifiers               (in)  PLOTS.35
     *                 nid,              ! dimension of AID,GID            (in)  PLOTS.36
     *                 ncs               ! dimension of XCS,YCS            (in)  PLOTS.37
      integer          fscolr,           ! for common block FLINFO               PLOTS.38
     *                 secolr,           ! for common block FLINFO               PLOTS.39
     *                 thcolr,           ! for common block FLINFO               PLOTS.40
     *                 frcolr,           ! for common block FLINFO               PLOTS.41
     *                 fvcolr,           ! for common block FLINFO               PLOTS.42
     *                 sicolr            ! for common block FLINFO               PLOTS.43
      integer          wacolr            ! for common block FLWATR               PLOTS.44
      integer          ind(200),         ! scratch array for SOFTFILL   (local)  PLOTS.45
     *                 index,            ! color index to use           (local)  PLOTS.46
     *                 itm               ! test value                   (local)  PLOTS.47
                                                                                 PLOTS.48
C  Real variables                                                                PLOTS.49
                                                                                 PLOTS.50
      real             xcs(*),           ! point locations x direction     (in)  PLOTS.51
     *                 ycs(*)            ! point locations y direction     (in)  PLOTS.52
      real             dst(100)          ! scratch array                (local)  PLOTS.53
                                                                                 PLOTS.54
C  Common blocks                                                                 PLOTS.55
                                                                                 PLOTS.56
      common /flinfo/  fscolr,           ! first color                           PLOTS.57
     *                 secolr,           ! second color                          PLOTS.58
     *                 thcolr,           ! third color                           PLOTS.59
     *                 frcolr,           ! fourth color                          PLOTS.60
     *                 fvcolr,           ! fifth color                           PLOTS.61
     *                 sicolr            ! sixth color                           PLOTS.62
      common /flwatr/  wacolr            ! water color                           PLOTS.63
                                                                                 PLOTS.64
C****************************  subroutine begin  *****************************C  PLOTS.65
                                                                                 PLOTS.66
C  Be certain that the current polygon is on the map                             PLOTS.67
                                                                                 PLOTS.68
      if ((aid(1) .ge. 0) .and. (aid(2) .ge. 0)) then                            PLOTS.69
                                                                                 PLOTS.70
C  If one is zero or negative and the other isn't test on the one that isn't     PLOTS.71
                                                                                 PLOTS.72
        itm = max0(aid(1),aid(2))                                                PLOTS.73
        if (itm .gt. 0) then                                                     PLOTS.74
                                                                                 PLOTS.75
C  Determine proper color index, MAPACI is an EZMAPA utility function            PLOTS.76
                                                                                 PLOTS.77
          index = mapaci(itm)                                                    PLOTS.78
          if (index .eq. 1) then                                                 PLOTS.79
            index = wacolr                                                       PLOTS.80
          else if (index .eq. 2) then                                            PLOTS.81
            index = fscolr                                                       PLOTS.82
          else if (index .eq. 3) then                                            PLOTS.83
            index = secolr                                                       PLOTS.84
          else if (index .eq. 4) then                                            PLOTS.85
            index = thcolr                                                       PLOTS.86
          else if (index .eq. 5) then                                            PLOTS.87
            index = frcolr                                                       PLOTS.88
          else if (index .eq. 6) then                                            PLOTS.89
            index = fvcolr                                                       PLOTS.90
          else if (index .eq. 7) then                                            PLOTS.91
            index = sicolr                                                       PLOTS.92
          end if                                                                 PLOTS.93
        else                                                                     PLOTS.94
          index = wacolr                                                         PLOTS.95
        end if                                                                   PLOTS.96
                                                                                 PLOTS.97
C  Do color fill                                                                 PLOTS.98
                                                                                 PLOTS.99
        call sfsgfa (xcs,ycs,ncs-1,dst,100,ind,200,index)                        PLOTS.100
      end if                                                                     PLOTS.101
                                                                                 PLOTS.102
C*****************************  subroutine end  ******************************C  PLOTS.103
                                                                                 PLOTS.104
      return                                                                     PLOTS.105
      end                                                                        PLOTS.106
      subroutine crdrci (test,error,colind,defind,whline,i,name,                 PLOTS.107
     *                   size,errsev,noplt,util)                                 PLOTS.108
                                                                                 PLOTS.109
C*****************************************************************************C  PLOTS.110
C  crdrci   - This is a CONDRV/MAPDRV routine                                 C  PLOTS.111
C  Section  - Tables                                                          C  PLOTS.112
C  Purpose  - To read in a single color index and check it for validity.      C  PLOTS.113
C                                                                             C  PLOTS.114
C  On entry - TEST is a logical that must be true for the index to be  parsed C  PLOTS.115
C             from the table.  ERROR is true if an error has occured in which C  PLOTS.116
C             case the index should not be parsed from the table.  DEFIND  is C  PLOTS.117
C             a default color index to use if needed.  WHLINE is a whole line C  PLOTS.118
C             taken from the current table.  I is the current place in WHLINE.C  PLOTS.119
C             NAME is the name of the color index to use when giving an error C  PLOTS.120
C             message.  SIZE is the number of characters in NAME.  ERRSEV in- C  PLOTS.121
C             dicates what severity of error should stop execution.   UTIL is C  PLOTS.122
C             is the name of the utility using this routine.                  C  PLOTS.123
C                                                                             C  PLOTS.124
C  On exit  - COLIND  contains  the value set to the  color index.   NOPLT is C  PLOTS.125
C             true if a non-correctable error has occured.  ERROR is true  if C  PLOTS.126
C             an error has occured and is false otherwise.                    C  PLOTS.127
C                                                                             C  PLOTS.128
C  Notes    - Routine             Location of Definition                      C  PLOTS.129
C             ----------------------------------------------------------------C  PLOTS.130
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.131
C             GQCR                GKS                                         C  PLOTS.132
C             ----------------------------------------------------------------C  PLOTS.133
C                                                                             C  PLOTS.134
C  Assume   - Nothing                                                         C  PLOTS.135
C                                                                             C  PLOTS.136
C  Author   - Jeremy Asbill      Date - August 7, 1990      for the MM4 club  C  PLOTS.137
C*****************************************************************************C  PLOTS.138
                                                                                 PLOTS.139
C  Character variables                                                           PLOTS.140
                                                                                 PLOTS.141
      character*80     whline            ! a line of text from table       (in)  PLOTS.142
      character*36     name              ! name of color index             (in)  PLOTS.143
      character*6      util              ! name of using utility           (in)  PLOTS.144
      character*60     ermes             ! error message string         (local)  PLOTS.145
                                                                                 PLOTS.146
C  Integer variables                                                             PLOTS.147
                                                                                 PLOTS.148
      integer          defind,           ! default color index             (in)  PLOTS.149
     *                 i,                ! position in WHLINE              (in)  PLOTS.150
     *                 size,             ! number of chars in NAME         (in)  PLOTS.151
     *                 errsev            ! error severity comparitor       (in)  PLOTS.152
      integer          colind            ! color index                    (out)  PLOTS.153
      integer          j,                ! loop counter                 (local)  PLOTS.154
     *                 ier               ! error flag from GKS          (local)  PLOTS.155
                                                                                 PLOTS.156
C  Logical variables                                                             PLOTS.157
                                                                                 PLOTS.158
      logical          test,             ! use the table ?                 (in)  PLOTS.159
     *                 error             ! has an error occured ?          (in)  PLOTS.160
      logical          noplt             ! will a plot be drawn ?         (out)  PLOTS.161
                                                                                 PLOTS.162
C  Real variables                                                                PLOTS.163
                                                                                 PLOTS.164
      real             f1,f2,f3          ! junk fillers                 (local)  PLOTS.165
                                                                                 PLOTS.166
C****************************  Subroutine Begin  *****************************C  PLOTS.167
                                                                                 PLOTS.168
C  Check to see if we should use the table                                       PLOTS.169
                                                                                 PLOTS.170
      if ((test) .and. (.not. error)) then                                       PLOTS.171
                                                                                 PLOTS.172
C  Use the table to read the color index                                         PLOTS.173
                                                                                 PLOTS.174
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.175
          colind = defind                                                        PLOTS.176
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.177
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.178
          read (whline(i:i+1),20,err=30) colind                                  PLOTS.179
        else                                                                     PLOTS.180
          read (whline(i:i),10,err=30) colind                                    PLOTS.181
        end if                                                                   PLOTS.182
                                                                                 PLOTS.183
C  Check that the color index is a valid one                                     PLOTS.184
                                                                                 PLOTS.185
        if (colind .ge. 0) then                                                  PLOTS.186
          call gqcr (1,colind,0,ier,f1,f2,f3)                                    PLOTS.187
        end if                                                                   PLOTS.188
        if ((ier .eq. 87) .or. ((colind .lt. 0) .and.                            PLOTS.189
     *      (colind .ne. defind)) .or. (colind .gt. 255) .or.                    PLOTS.190
     *      (ier .eq. 86)) then                                                  PLOTS.191
          ermes(1:size) = name(1:size)                                           PLOTS.192
          ermes(size+1:size+11) = ' Is Invalid'                                  PLOTS.193
          do 40 j = size+12,60                                                   PLOTS.194
            ermes(j:j) = ' '                                                     PLOTS.195
40        continue                                                               PLOTS.196
          call errhan (util,1,ermes,errsev)                                      PLOTS.197
          colind = defind                                                        PLOTS.198
          error = .true.                                                         PLOTS.199
        else if (ier .ne. 0) then                                                PLOTS.200
                                                                                 PLOTS.201
C  If GKS returns another error, who knows what is wrong                         PLOTS.202
                                                                                 PLOTS.203
          ermes(1:30)  = 'Non-Correctable Error Encounte'                        PLOTS.204
          ermes(31:60) = 'red                           '                        PLOTS.205
          call errhan (util,1,ermes,errsev)                                      PLOTS.206
          noplt = .true.                                                         PLOTS.207
        else if (colind .ge. 100) then                                           PLOTS.208
                                                                                 PLOTS.209
C  Warn the user if the index is within a reserved region                        PLOTS.210
C  100 - 199 is reserved for CONDRV                                              PLOTS.211
C  200 - 255 is reserved for MAPDRV                                              PLOTS.212
                                                                                 PLOTS.213
          ermes(1:size) = name(1:size)                                           PLOTS.214
          ermes(size+1:size+24) = ' Is In A Reserved Region'                     PLOTS.215
          do 50 j = size+24,60                                                   PLOTS.216
            ermes(j:j) = ' '                                                     PLOTS.217
50        continue                                                               PLOTS.218
          call errhan (util,0,ermes,errsev)                                      PLOTS.219
          colind = defind                                                        PLOTS.220
        end if                                                                   PLOTS.221
        goto 60                                                                  PLOTS.222
                                                                                 PLOTS.223
C  If an error occured during the read tell the user                             PLOTS.224
                                                                                 PLOTS.225
30      ermes(1:size) = name(1:size)                                             PLOTS.226
        ermes(size+1:size+17) = ' Input Conversion'                              PLOTS.227
        call errhan (util,1,ermes,errsev)                                        PLOTS.228
        colind = defind                                                          PLOTS.229
        error = .true.                                                           PLOTS.230
      else                                                                       PLOTS.231
        colind = defind                                                          PLOTS.232
      end if                                                                     PLOTS.233
                                                                                 PLOTS.234
C*****************************  subroutine end  ******************************C  PLOTS.235
                                                                                 PLOTS.236
C  Format statements begin ...                                                   PLOTS.237
                                                                                 PLOTS.238
10    format (I1)                                                                PLOTS.239
20    format (I2)                                                                PLOTS.240
                                                                                 PLOTS.241
C  Format statements end.                                                        PLOTS.242
                                                                                 PLOTS.243
60    return                                                                     PLOTS.244
      end                                                                        PLOTS.245
      subroutine errfil (flnum)                                                  PLOTS.246
                                                                                 PLOTS.247
C*****************************************************************************C  PLOTS.248
C  errfil   - this is a MAPDRV routine                                        C  PLOTS.249
C  Section  - Error Handling                                                  C  PLOTS.250
C  Purpose  - To assign fill colors after an  error has  occured in the  fill C  PLOTS.251
C             table read.                                                     C  PLOTS.252
C                                                                             C  PLOTS.253
C  On entry - FLNUM is the number of the color indicies still needed.         C  PLOTS.254
C                                                                             C  PLOTS.255
C  On exit  - Those color indicies below  the  one erred upon,  and including C  PLOTS.256
C             the one erred upon have been set up with some valid guesses.    C  PLOTS.257
C                                                                             C  PLOTS.258
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.259
C             ----------------------------------------------------------------C  PLOTS.260
C             GSCR                GKS                                         C  PLOTS.261
C             ----------------------------------------------------------------C  PLOTS.262
C                                                                             C  PLOTS.263
C  Assume   - GKS is open.  Color indicies above 200 are reserved for  MAPDRV C  PLOTS.264
C             use.                                                            C  PLOTS.265
C                                                                             C  PLOTS.266
C  Author   - Jeremy Asbill       Date - July 13, 1990       for the MM4 club C  PLOTS.267
C*****************************************************************************C  PLOTS.268
                                                                                 PLOTS.269
C  Integer variable                                                              PLOTS.270
                                                                                 PLOTS.271
      integer          flnum             ! number of indicies needed       (in)  PLOTS.272
      integer          fscolr,           ! for common block FLINFO               PLOTS.273
     *                 secolr,           ! for common block FLINFO               PLOTS.274
     *                 thcolr,           ! for common block FLINFO               PLOTS.275
     *                 frcolr,           ! for common block FLINFO               PLOTS.276
     *                 fvcolr,           ! for common block FLINFO               PLOTS.277
     *                 sicolr            ! for common block FLINFO               PLOTS.278
      integer          wacolr            ! for common block FLWATR               PLOTS.279
                                                                                 PLOTS.280
C  Common blocks                                                                 PLOTS.281
                                                                                 PLOTS.282
      common /flinfo/  fscolr,           ! first color                           PLOTS.283
     *                 secolr,           ! second color                          PLOTS.284
     *                 thcolr,           ! third color                           PLOTS.285
     *                 frcolr,           ! fourth color                          PLOTS.286
     *                 fvcolr,           ! fifth color                           PLOTS.287
     *                 sicolr            ! sixth color                           PLOTS.288
      common /flwatr/  wacolr            ! water color                           PLOTS.289
                                                                                 PLOTS.290
C****************************  subroutine begin  *****************************C  PLOTS.291
                                                                                 PLOTS.292
C  If execution did not stop in ERRHAN, make up some colors                      PLOTS.293
                                                                                 PLOTS.294
      if (flnum .gt. 0) then                                                     PLOTS.295
        call gscr (1,206,0.86,0.58,0.44)                                         PLOTS.296
        sicolr = 206                       ! Tan                                 PLOTS.297
      end if                                                                     PLOTS.298
                                                                                 PLOTS.299
      if (flnum .gt. 1) then                                                     PLOTS.300
        call gscr (1,205,0.57,0.00,0.87)                                         PLOTS.301
        fvcolr = 205                       ! Purple                              PLOTS.302
      end if                                                                     PLOTS.303
                                                                                 PLOTS.304
      if (flnum  .gt. 2) then                                                    PLOTS.305
        call gscr (1,204,1.00,0.00,0.00)                                         PLOTS.306
        frcolr = 204                       ! Red                                 PLOTS.307
      end if                                                                     PLOTS.308
                                                                                 PLOTS.309
      if (flnum .gt. 3) then                                                     PLOTS.310
        call gscr (1,203,0.14,0.56,0.14)                                         PLOTS.311
        thcolr = 203                       ! Forest Green                        PLOTS.312
      end if                                                                     PLOTS.313
                                                                                 PLOTS.314
      if (flnum .gt. 4) then                                                     PLOTS.315
        call gscr (1,202,1.00,1.00,0.00)                                         PLOTS.316
        secolr = 202                       ! Yellow                              PLOTS.317
      end if                                                                     PLOTS.318
                                                                                 PLOTS.319
      if (flnum .gt. 5) then                                                     PLOTS.320
        call gscr (1,201,1.00,0.00,1.00)                                         PLOTS.321
        fscolr = 201                       ! Magenta                             PLOTS.322
      end if                                                                     PLOTS.323
                                                                                 PLOTS.324
      if (flnum .gt. 6) then                                                     PLOTS.325
        call gscr (1,200,0.20,0.56,0.80)                                         PLOTS.326
        wacolr = 200                       ! Sky blue (A.K.A. Sea blue)          PLOTS.327
      end if                                                                     PLOTS.328
                                                                                 PLOTS.329
C*****************************  subroutine end  ******************************C  PLOTS.330
                                                                                 PLOTS.331
      return                                                                     PLOTS.332
      end                                                                        PLOTS.333
      subroutine errhan (util,errwar,ermes,errsev)                               PLOTS.334
                                                                                 PLOTS.335
C*****************************************************************************C  PLOTS.336
C  errhan   - this is a MAPDRV/CONDRV routine                                 C  PLOTS.337
C  Section  - Error Handling                                                  C  PLOTS.338
C  Purpose  - To deliver error  message  to  the user and determine  if  exe- C  PLOTS.339
C             execution should be halted.                                     C  PLOTS.340
C                                                                             C  PLOTS.341
C  On entry - UTIL contains the name of  the utility that has encountered the C  PLOTS.342
C             error.   ERMES  contains the string to be provided to the user. C  PLOTS.343
C             ERRWAR indicates a warning or a message.  ERRSEV indicates  the C  PLOTS.344
C             severity of an error at which execution should stop.   The cur- C  PLOTS.345
C             rent error count and warning count are passed in through common C  PLOTS.346
C             block ERRORS.                                                   C  PLOTS.347
C                                                                             C  PLOTS.348
C  On exit  - The message has been delivered.  The routine may or may not re- C  PLOTS.349
C             turn.                                                           C  PLOTS.350
C                                                                             C  PLOTS.351
C  Assume   - Nothing.                                                        C  PLOTS.352
C                                                                             C  PLOTS.353
C  Author   - Jeremy Asbill       Date - June 21, 1990       for the MM4 club C  PLOTS.354
C*****************************************************************************C  PLOTS.355
                                                                                 PLOTS.356
C  Character variables                                                           PLOTS.357
                                                                                 PLOTS.358
      character*60     ermes             ! error message to deliver        (in)  PLOTS.359
      character*6      util              ! the utility with a problem      (in)  PLOTS.360
      character*27     fmstp             ! first part of stop message   (local)  PLOTS.361
      character*12     smstp             ! second part of stop message  (local)  PLOTS.362
      character*9      tmstp             ! third part of stop message   (local)  PLOTS.363
                                                                                 PLOTS.364
C  Integer variables                                                             PLOTS.365
                                                                                 PLOTS.366
      integer          errwar,           ! severity of the error           (in)  PLOTS.367
     *                 errsev            ! execution stop level            (in)  PLOTS.368
      integer          error,            ! for common block ERRORS               PLOTS.369
     *                 warns             ! for common block ERRORS               PLOTS.370
                                                                                 PLOTS.371
C  Common blocks                                                                 PLOTS.372
                                                                                 PLOTS.373
      common /errors/  error,            ! current error count                   PLOTS.374
     *                 warns             ! current warning count                 PLOTS.375
                                                                                 PLOTS.376
C****************************  subroutine begin  *****************************C  PLOTS.377
                                                                                 PLOTS.378
C  Deliver the message                                                           PLOTS.379
C  ERRWAR = 0  => A Warning Message                                              PLOTS.380
C  ERRWAR = 1  => An Error Message                                               PLOTS.381
                                                                                 PLOTS.382
      if (errwar .eq. 0) then                                                    PLOTS.383
        warns = warns + 1                                                        PLOTS.384
        write (6,20) util,ermes                                                  PLOTS.385
      else                                                                       PLOTS.386
        error = error + 1                                                        PLOTS.387
        write (6,10) util,ermes                                                  PLOTS.388
      end if                                                                     PLOTS.389
                                                                                 PLOTS.390
C  Check to see if execution should be halted or not                             PLOTS.391
C  ERRSEV = 1    => Nothing Halts Execution                                      PLOTS.392
C  ERRSEV = 0    => Error Halt Execution                                         PLOTS.393
C  ERRSEV = -1   => Errors and Warnings Halt Execution                           PLOTS.394
                                                                                 PLOTS.395
      if (errwar .gt. errsev) then                                               PLOTS.396
        if ((warns .gt. 9) .and. (error .gt. 9)) then                            PLOTS.397
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.398
          smstp(1:12) = ' Errors And '                                           PLOTS.399
          tmstp(1:9) = ' Warnings'                                               PLOTS.400
          write (6,30) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.401
     *                 warns,tmstp(1:9)                                          PLOTS.402
        else if ((warns .gt. 9) .and. (error .eq. 1)) then                       PLOTS.403
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.404
          smstp(1:11) = ' Error And '                                            PLOTS.405
          tmstp(1:9) = ' Warnings'                                               PLOTS.406
          write (6,55) util,fmstp(1:27),error,smstp(1:11),                       PLOTS.407
     *                 warns,tmstp(1:9)                                          PLOTS.408
        else if ((warns .gt. 9) .and.                                            PLOTS.409
     *           (((error .gt. 1) .and. (error .le. 9)) .or.                     PLOTS.410
     *            (error .eq. 0))) then                                          PLOTS.411
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.412
          smstp(1:12) = ' Errors And '                                           PLOTS.413
          tmstp(1:9) = ' Warnings'                                               PLOTS.414
          write (6,50) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.415
     *                 warns,tmstp(1:9)                                          PLOTS.416
        else if ((warns .eq. 1) .and. (error .gt. 9)) then                       PLOTS.417
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.418
          smstp(1:12) = ' Errors And '                                           PLOTS.419
          tmstp(1:8) = ' Warning'                                                PLOTS.420
          write (6,45) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.421
     *                 warns,tmstp(1:8)                                          PLOTS.422
        else if ((((warns .le. 9) .and. (warns .gt. 1)) .or.                     PLOTS.423
     *            (warns .eq. 0)) .and. (error .gt. 9)) then                     PLOTS.424
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.425
          smstp(1:12) = ' Errors And '                                           PLOTS.426
          tmstp(1:9) = ' Warnings'                                               PLOTS.427
          write (6,40) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.428
     *                 warns,tmstp(1:9)                                          PLOTS.429
        else if ((warns .eq. 1) .and. (error .eq. 1)) then                       PLOTS.430
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.431
          smstp(1:11) = ' Error And '                                            PLOTS.432
          tmstp(1:8) = ' Warning'                                                PLOTS.433
          write (6,65) util,fmstp(1:27),error,smstp(1:11),                       PLOTS.434
     *                 warns,tmstp(1:8)                                          PLOTS.435
        else if ((((warns .le. 9) .and. (warns .gt. 1)) .or.                     PLOTS.436
     *            (warns .eq. 0)) .and. (error .eq. 1)) then                     PLOTS.437
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.438
          smstp(1:11) = ' Error And '                                            PLOTS.439
          tmstp(1:9) = ' Warnings'                                               PLOTS.440
          write (6,70) util,fmstp(1:27),error,smstp(1:11),                       PLOTS.441
     *                 warns,tmstp(1:9)                                          PLOTS.442
        else if ((warns .eq. 1) .and. (((error .le. 9) .and.                     PLOTS.443
     *           (error .gt. 1)) .or. (error .eq. 0))) then                      PLOTS.444
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.445
          smstp(1:12) = ' Errors And '                                           PLOTS.446
          tmstp(1:8) = ' Warning'                                                PLOTS.447
          write (6,75) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.448
     *                 warns,tmstp(1:8)                                          PLOTS.449
        else                                                                     PLOTS.450
          fmstp(1:27) = ' - Halting Execution After '                            PLOTS.451
          smstp(1:12) = ' Errors And '                                           PLOTS.452
          tmstp(1:9) = ' Warnings'                                               PLOTS.453
          write (6,60) util,fmstp(1:27),error,smstp(1:12),                       PLOTS.454
     *                 warns,tmstp(1:9)                                          PLOTS.455
        end if                                                                   PLOTS.456
        stop                                                                     PLOTS.457
      end if                                                                     PLOTS.458
                                                                                 PLOTS.459
C*****************************  subroutine end  ******************************C  PLOTS.460
                                                                                 PLOTS.461
C  Format statements begin ...                                                   PLOTS.462
                                                                                 PLOTS.463
10    format (' ',A6,' - Error - ',A60)                                          PLOTS.464
20    format (' ',A6,' - Warning - ',A60)                                        PLOTS.465
30    format (' ',A6,A27,I2,A12,I2,A9)                                           PLOTS.466
40    format (' ',A6,A27,I2,A12,I1,A9)                                           PLOTS.467
45    format (' ',A6,A27,I2,A12,I1,A8)                                           PLOTS.468
50    format (' ',A6,A27,I1,A12,I2,A9)                                           PLOTS.469
55    format (' ',A6,A27,I1,A11,I2,A9)                                           PLOTS.470
60    format (' ',A6,A27,I1,A12,I1,A9)                                           PLOTS.471
65    format (' ',A6,A27,I1,A11,I1,A8)                                           PLOTS.472
70    format (' ',A6,A27,I1,A11,I1,A9)                                           PLOTS.473
75    format (' ',A6,A27,I1,A12,I1,A8)                                           PLOTS.474
                                                                                 PLOTS.475
C  Format statements end.                                                        PLOTS.476
                                                                                 PLOTS.477
      return                                                                     PLOTS.478
      end                                                                        PLOTS.479
      subroutine gtreal (cval,rval,error)                                        PLOTS.480
                                                                                 PLOTS.481
C*****************************************************************************C  PLOTS.482
C  gtreal   - this is a MAPDRV/CONDRV routine                                 C  PLOTS.483
C  Section  - Tables                                                          C  PLOTS.484
C  Purpose  - To read from a character string a real, regardless of what      C  PLOTS.485
C             format it is in (that is, xxx.xxx or xxx.xxxExx).               C  PLOTS.486
C                                                                             C  PLOTS.487
C  On entry - CVAL  is  a character variable  of fixed size that contains the C  PLOTS.488
C             number to be converted to a real.  ERROR is false.              C  PLOTS.489
C                                                                             C  PLOTS.490
C  On exit  - RVAL  is the value in question.   If an error occured  ERROR is C  PLOTS.491
C             TRUE otherwise it is FALSE.                                     C  PLOTS.492
C                                                                             C  PLOTS.493
C  Assume   - Nothing                                                         C  PLOTS.494
C                                                                             C  PLOTS.495
C  Author   - Jeremy Asbill       Date - June 21, 1990      for the MM4 club  C  PLOTS.496
C*****************************************************************************C  PLOTS.497
                                                                                 PLOTS.498
C  Character variables                                                           PLOTS.499
                                                                                 PLOTS.500
      character*20     cval              ! character version of number     (in)  PLOTS.501
                                                                                 PLOTS.502
C  Integer variables                                                             PLOTS.503
                                                                                 PLOTS.504
      integer          unum              ! safe to use unit number      (local)  PLOTS.505
                                                                                 PLOTS.506
C  Logical variables                                                             PLOTS.507
                                                                                 PLOTS.508
      logical          error             ! has an error occured ?         (out)  PLOTS.509
      logical          used              ! is a unit number in use ?    (local)  PLOTS.510
                                                                                 PLOTS.511
C  Real variables                                                                PLOTS.512
                                                                                 PLOTS.513
      real             rval              ! real version of number          (in)  PLOTS.514
                                                                                 PLOTS.515
C****************************  subroutine begin  *****************************C  PLOTS.516
                                                                                 PLOTS.517
C  First make sure there are only numeric like chars in the string               PLOTS.518
                                                                                 PLOTS.519
      error = .false.                                                            PLOTS.520
      do 50 i = 1,20                                                             PLOTS.521
        if ((cval(i:i) .ne. ' ') .and. (cval(i:i) .ne. 'E') .and.                PLOTS.522
     *      (cval(i:i) .ne. 'e') .and. (cval(i:i) .ne. '.') .and.                PLOTS.523
     *      (cval(i:i) .ne. '+') .and. (cval(i:i) .ne. '-') .and.                PLOTS.524
     *      ((ichar(cval(i:i)) .lt. 48) .or.                                     PLOTS.525
     *       (ichar(cval(i:i)) .gt. 57))) error = .true.                         PLOTS.526
50    continue                                                                   PLOTS.527
      if (.not. error) then                                                      PLOTS.528
                                                                                 PLOTS.529
C  Determine a unit number that is safe to use                                   PLOTS.530
                                                                                 PLOTS.531
        unum = 7                                                                 PLOTS.532
40      unum = unum + 1                                                          PLOTS.533
        inquire (unit=unum,opened=used)                                          PLOTS.534
        if (used) goto 40                                                        PLOTS.535
                                                                                 PLOTS.536
C  Open a scratch file as unit number UNUM                                       PLOTS.537
                                                                                 PLOTS.538
        open (unum,status='SCRATCH',err=20)
C       open (unum,file='CONDRV.SCR',status='SCRATCH',err=20)                    PLOTS.540
                                                                                 PLOTS.541
C  Write CVAL out to the scratch file                                            PLOTS.542
                                                                                 PLOTS.543
        write (unum,10,err=20) cval                                              PLOTS.544
                                                                                 PLOTS.545
C  Rewind and read the value back in as a real                                   PLOTS.546
                                                                                 PLOTS.547
        rewind (unum)                                                            PLOTS.548
        read (unum,*,err=20) rval                                                PLOTS.549
                                                                                 PLOTS.550
C  Close the scratch file                                                        PLOTS.551
                                                                                 PLOTS.552
        close (unum)                                                             PLOTS.553
        goto 30                                                                  PLOTS.554
                                                                                 PLOTS.555
C  Handle the errors                                                             PLOTS.556
                                                                                 PLOTS.557
20      continue                                                                 PLOTS.558
        error = .true.                                                           PLOTS.559
      end if                                                                     PLOTS.560
                                                                                 PLOTS.561
C*****************************  subroutine end  ******************************C  PLOTS.562
                                                                                 PLOTS.563
C  Format statements ...                                                         PLOTS.564
                                                                                 PLOTS.565
10    format (A20)                                                               PLOTS.566
                                                                                 PLOTS.567
C  Format statements end.                                                        PLOTS.568
                                                                                 PLOTS.569
30    return                                                                     PLOTS.570
      end                                                                        PLOTS.571
      subroutine interr (nomap,fsplat,ssplat,jmax,imax,xpa,ypa,xpb,ypb,          PLOTS.572
     *                   project,grds,cenlat,cenlon,buff,errsev)                 PLOTS.573
                                                                                 PLOTS.574
C*****************************************************************************C  PLOTS.575
C  interr   - This is a MAPDRV routine                                        C  PLOTS.576
C  Section  - Error handling                                                  C  PLOTS.577
C  Purpose  - To check for a few obvious errors and  to  initialize the error C  PLOTS.578
C             handling variables.                                             C  PLOTS.579
C                                                                             C  PLOTS.580
C  On entry - JMAX is the x dimension of the entire domain grid.  IMAX is the C  PLOTS.581
C             y  dimension of the entire domain grid.    FSPLAT is the  first C  PLOTS.582
C             standard parallel if project = 'LC'.  SSPLAT is the second such C  PLOTS.583
C             parallel.  XPA, YPA form the lower left grid  point of the map. C  PLOTS.584
C             XPB, YPB the upper right  grid point of the map.  PROJECT is  2 C  PLOTS.585
C             characters denoting which projection is to be used. GRDS is the C  PLOTS.586
C             distance  between two grid  points.  CENLAT and CENLON are  the C  PLOTS.587
C             center latitude and longitude respectively.   ERRSEV  indicates C  PLOTS.588
C             what severity of error will halt execution of the program.   If C  PLOTS.589
C             BUFF  is negative, then no WISS workstation need be open.       C  PLOTS.590
C                                                                             C  PLOTS.591
C  On exit  - NOMAP is true if any errors occured.  The  counters in the com- C  PLOTS.592
C             mon block  ERRORS have been initialized correctly.              C  PLOTS.593
C                                                                             C  PLOTS.594
C  Assume   - Nothing.                                                        C  PLOTS.595
C                                                                             C  PLOTS.596
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.597
C             ----------------------------------------------------------------C  PLOTS.598
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.599
C             GQOPS               GKS                                         C  PLOTS.600
C             OPNGKS              SPPS*                                       C  PLOTS.601
C             GOPWK               GKS                                         C  PLOTS.602
C             GACWK               GKS                                         C  PLOTS.603
C             GQOPWK              GKS                                         C  PLOTS.604
C             GQCR                GKS                                         C  PLOTS.605
C             GSCR                GKS                                         C  PLOTS.606
C             GQWKC               GKS                                         C  PLOTS.607
C             GQWKCA              GKS                                         C  PLOTS.608
C             LCCONE              MAPDRV utility                              C  PLOTS.609
C             ----------------------------------------------------------------C  PLOTS.610
C                                                                             C  PLOTS.611
C  Author   - Jeremy Asbill       Date - July 14, 1990       for the MM4 club C  PLOTS.612
C*****************************************************************************C  PLOTS.613
                                                                                 PLOTS.614
C  Parameter                                                                     PLOTS.615
                                                                                 PLOTS.616
C  ECIRC is the circumference of the earth in kilometers                         PLOTS.617
                                                                                 PLOTS.618
      parameter        (ecirc = 40023.8904)                                      PLOTS.619
                                                                                 PLOTS.620
C  Character varaibles                                                           PLOTS.621
                                                                                 PLOTS.622
      character*2      project           ! specifies projection            (in)  PLOTS.623
      character*60     ermes             ! error message string         (local)  PLOTS.624
                                                                                 PLOTS.625
C  Integer variables                                                             PLOTS.626
                                                                                 PLOTS.627
      integer          imax,             ! y dimension size of entire grid (in)  PLOTS.628
     *                 jmax,             ! x dimension size of entire grid (in)  PLOTS.629
     *                 buff,             ! GFLASH buffer number to use     (in)  PLOTS.630
     *                 errsev            ! error severity comparitor       (in)  PLOTS.631
      integer          error,            ! for common block ERRORS               PLOTS.632
     *                 warns             ! for common block ERRORS               PLOTS.633
      integer          ier,              ! error flag from GKS          (local)  PLOTS.634
     *                 nwk,              ! number of open workstations  (local)  PLOTS.635
     *                 num,              ! workstation identifier       (local)  PLOTS.636
     *                 temp,             ! junk filler                  (local)  PLOTS.637
     *                 wtype,            ! workstation type             (local)  PLOTS.638
     *                 categ,            ! workstation category         (local)  PLOTS.639
     *                 i,                ! loop counter                 (local)  PLOTS.640
     *                 unum,             ! free unit number             (local)  PLOTS.641
     *                 opst              ! GKS operating state          (local)  PLOTS.642
                                                                                 PLOTS.643
C  Logical variables                                                             PLOTS.644
                                                                                 PLOTS.645
      logical          nomap             ! don't draw a map ?             (out)  PLOTS.646
      logical          awiss,            ! is a WISS workstation open ? (local)  PLOTS.647
     *                 used              ! is a unit number used ?      (local)  PLOTS.648
                                                                                 PLOTS.649
C  Real variables                                                                PLOTS.650
                                                                                 PLOTS.651
      real             xpa,              ! lower left x grid pt. on map    (in)  PLOTS.652
     *                 xpb,              ! upper right x grid pt. on map   (in)  PLOTS.653
     *                 ypa,              ! lower left y grid pt. on map    (in)  PLOTS.654
     *                 ypb,              ! upper right y grid pt. on map   (in)  PLOTS.655
     *                 grds,             ! grid distance in kilometers     (in)  PLOTS.656
     *                 fsplat,           ! first standard parallel (LC)    (in)  PLOTS.657
     *                 ssplat,           ! second standard parallel (LC)   (in)  PLOTS.658
     *                 cenlat,           ! center lattitude of domain      (in)  PLOTS.659
     *                 cenlon            ! center longitude of domain      (in)  PLOTS.660
      real             red,              ! red component of color rep.  (local)  PLOTS.661
     *                 blue,             ! blue component of color rep. (local)  PLOTS.662
     *                 green             ! green component of color rep.(local)  PLOTS.663
                                                                                 PLOTS.664
C  Common blocks                                                                 PLOTS.665
                                                                                 PLOTS.666
      common /errors/  error,            ! error count                           PLOTS.667
     *                 warns             ! warning count                         PLOTS.668
                                                                                 PLOTS.669
C****************************  subroutine begin  *****************************C  PLOTS.670
                                                                                 PLOTS.671
C  Initialize error counters                                                     PLOTS.672
                                                                                 PLOTS.673
      error = 0                                                                  PLOTS.674
      warns = 0                                                                  PLOTS.675
                                                                                 PLOTS.676
C  Initialize NOMAP                                                              PLOTS.677
                                                                                 PLOTS.678
      nomap = .false.                                                            PLOTS.679
                                                                                 PLOTS.680
C  Check for some obvious errors                                                 PLOTS.681
                                                                                 PLOTS.682
C  Grid dimensions of the domain don't jive                                      PLOTS.683
                                                                                 PLOTS.684
      if ((imax .le. 0.0) .or.                                                   PLOTS.685
     *    (jmax .le. 0.0)) then                                                  PLOTS.686
        ermes(1:34)  = 'Grid Is Short A Dimension Or Two, '                      PLOTS.687
        ermes(35:60) = 'Check JMAX and IMAX       '                              PLOTS.688
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.689
        nomap = .true.                                                           PLOTS.690
      end if                                                                     PLOTS.691
                                                                                 PLOTS.692
C  Grid dimensions of the map don't jive                                         PLOTS.693
                                                                                 PLOTS.694
      if ((xpb .le. xpa) .or.                                                    PLOTS.695
     *    (ypb .le. ypa)) then                                                   PLOTS.696
        ermes(1:30)  = 'Map Cannot Be Inverted, xpb An'                          PLOTS.697
        ermes(31:60) = 'd ypb Must Be > xpa And ypa   '                          PLOTS.698
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.699
        nomap = .true.                                                           PLOTS.700
      end if                                                                     PLOTS.701
                                                                                 PLOTS.702
C  Projection is not supported by MAPDRV                                         PLOTS.703
                                                                                 PLOTS.704
      if ((project(1:2) .ne. 'ST') .and.                                         PLOTS.705
     *    (project(1:2) .ne. 'LC') .and.                                         PLOTS.706
     *    (project(1:2) .ne. 'ME') .and.                                         PLOTS.707
     *    (project(1:2) .ne. 'CE')) then                                         PLOTS.708
        ermes(1:25)  = 'Incapable Of Projection, '                               PLOTS.709
        ermes(26:27) = project(1:2)                                              PLOTS.710
        ermes(28:60) = ', Choose From ST, LC, Or ME      '                       PLOTS.711
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.712
        nomap = .true.                                                           PLOTS.713
      end if                                                                     PLOTS.714
                                                                                 PLOTS.715
C  If the projection is Lambert Conformal make sure the given                    PLOTS.716
C  standard parallels are valid.  If they are calculate the cone factor          PLOTS.717
                                                                                 PLOTS.718
      if (project(1:2) .eq. 'LC') then                                           PLOTS.719
        if ((abs(fsplat) .gt. 90.0) .or. (abs(ssplat) .gt. 90.0)) then           PLOTS.720
          if (cenlat .gt. 0.0) then                                              PLOTS.721
            call lccone (30.0,60.0,1)                                            PLOTS.722
          else                                                                   PLOTS.723
            call lccone (-30.0,-60.0,-1)                                         PLOTS.724
            fsplat = -91.0                                                       PLOTS.725
          end if                                                                 PLOTS.726
        else if ((fsplat/ssplat) .lt. 0.0) then                                  PLOTS.727
          ermes(1:30)  = 'Lambert Projection Around The '                        PLOTS.728
          ermes(31:60) = 'Equator, Use Mercator         '                        PLOTS.729
          call errhan ('MAPDRV',1,ermes,errsev)                                  PLOTS.730
          nomap = .true.                                                         PLOTS.731
        else                                                                     PLOTS.732
          if (cenlat .gt. 0.0) then                                              PLOTS.733
            call lccone (fsplat,ssplat,1)                                        PLOTS.734
          else                                                                   PLOTS.735
            call lccone (fsplat,ssplat,-1)                                       PLOTS.736
          end if                                                                 PLOTS.737
        end if                                                                   PLOTS.738
                                                                                 PLOTS.739
C  Make sure the given standard parallels are on the same half of the globe      PLOTS.740
C  as the center latitude                                                        PLOTS.741
                                                                                 PLOTS.742
        if ((fsplat/cenlat) .lt. 0.0) then                                       PLOTS.743
          ermes(1:30)  = 'Lambert Parallels And Domain C'                        PLOTS.744
          ermes(31:60) = 'enter In Opposite Hemispheres '                        PLOTS.745
          call errhan ('MAPDRV',1,ermes,errsev)                                  PLOTS.746
          nomap = .true.                                                         PLOTS.747
        end if                                                                   PLOTS.748
                                                                                 PLOTS.749
C  If the projection is Polar Stereographic make sure the FSPLAT parameter       PLOTS.750
C  is a valid true latitude.                                                     PLOTS.751
                                                                                 PLOTS.752
      else if (project(1:2) .eq. 'ST') then                                      PLOTS.753
        if (abs(fsplat) .gt. 90.0) then                                          PLOTS.754
          if (cenlat .gt. 0.0) then                                              PLOTS.755
            call lccone (60.0,0.0,1)                                             PLOTS.756
          else                                                                   PLOTS.757
            call lccone (-60.0,0.0,-1)                                           PLOTS.758
            fsplat = -91.0                                                       PLOTS.759
          end if                                                                 PLOTS.760
        else                                                                     PLOTS.761
          if (cenlat .gt. 0.0) then                                              PLOTS.762
            call lccone (fsplat,0.0,1)                                           PLOTS.763
          else                                                                   PLOTS.764
            call lccone (fsplat,0.0,-1)                                          PLOTS.765
          end if                                                                 PLOTS.766
        end if                                                                   PLOTS.767
                                                                                 PLOTS.768
C  Make sure the domain is in the same hemisphere as the projection is true in   PLOTS.769
                                                                                 PLOTS.770
        if ((fsplat/cenlat) .lt. 0.0) then                                       PLOTS.771
          ermes(1:30)  = 'Polar True Lat. And Domain Cen'                        PLOTS.772
          ermes(31:60) = 'ter In Opposite Hemispheres   '                        PLOTS.773
          call errhan ('MAPDRV',1,ermes,errsev)                                  PLOTS.774
          nomap = .true.                                                         PLOTS.775
        end if                                                                   PLOTS.776
      end if                                                                     PLOTS.777
                                                                                 PLOTS.778
C  Make sure the subdomain is at least an improper subdomain of the domain       PLOTS.779
                                                                                 PLOTS.780
      if ((xpa .lt. 1.0) .or. (ypa .lt. 1.0) .or.                                PLOTS.781
     *    (xpb .gt. float(jmax)) .or. (ypb .gt. float(imax))) then               PLOTS.782
        ermes(1:43)  = 'Subdomain Defined By xpa,ypa And xpb,ypb Is'             PLOTS.783
        ermes(44:60) = ' Not A Subdomain'                                        PLOTS.784
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.785
        nomap = .true.                                                           PLOTS.786
      end if                                                                     PLOTS.787
                                                                                 PLOTS.788
C  Check that the domain will even fit on the earth                              PLOTS.789
                                                                                 PLOTS.790
      if ((jmax * nint(grds) .gt. ecirc) .or.                                    PLOTS.791
     *    (imax * nint(grds) .gt. ecirc)) then                                   PLOTS.792
        ermes(1:31)  = 'Domain Is Larger Than The Earth'                         PLOTS.793
        ermes(32:60) = '                             '                           PLOTS.794
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.795
        nomap = .true.                                                           PLOTS.796
      end if                                                                     PLOTS.797
                                                                                 PLOTS.798
C  Make sure the center lat and lon are withing reason                           PLOTS.799
                                                                                 PLOTS.800
      if ((cenlat .gt. 90) .or. (cenlat .lt. -90) .or.                           PLOTS.801
     *    (cenlon .gt. 180) .or. (cenlon .lt. -180)) then                        PLOTS.802
        ermes(1:30)  = 'Center Latitude And Longitude '                          PLOTS.803
        ermes(31:60) = 'Are Out Of This World         '                          PLOTS.804
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.805
        nomap = .true.                                                           PLOTS.806
      end if                                                                     PLOTS.807
                                                                                 PLOTS.808
C  Make sure the state of GKS is proper                                          PLOTS.809
                                                                                 PLOTS.810
      call gqops (opst)                                                          PLOTS.811
      if (opst .eq. 0) then                                                      PLOTS.812
        ermes(1:30)  = 'GKS Is Not Open               '                          PLOTS.813
        ermes(31:60) = '                              '                          PLOTS.814
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.815
        call opngks                                                              PLOTS.816
        nomap = .true.                                                           PLOTS.817
      else if (opst .eq. 1) then                                                 PLOTS.818
        ermes(1:30)  = 'There Are No Open Workstations'                          PLOTS.819
        ermes(31:60) = '                              '                          PLOTS.820
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.821
        call gopwk (1,2,1)                                                       PLOTS.822
        call gacwk (1)                                                           PLOTS.823
        nomap = .true.                                                           PLOTS.824
      else if (opst .eq. 2) then                                                 PLOTS.825
        ermes(1:30)  = 'There Are No Active Workstatio'                          PLOTS.826
        ermes(31:60) = 'ns                            '                          PLOTS.827
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.828
        call gqopwk (1,ier,nwk,num)                                              PLOTS.829
        call gacwk (num)                                                         PLOTS.830
        nomap = .true.                                                           PLOTS.831
      end if                                                                     PLOTS.832
                                                                                 PLOTS.833
C  Make certain background and foreground color are defined                      PLOTS.834
                                                                                 PLOTS.835
      call gqcr (1,0,0,ier,red,blue,green)                                       PLOTS.836
                                                                                 PLOTS.837
C  Check for errors from GKS                                                     PLOTS.838
                                                                                 PLOTS.839
      if ((ier .eq. 87) .or. (ier .eq. 93)) then                                 PLOTS.840
        ermes(1:30)  = 'Background Color Index Is Inva'                          PLOTS.841
        ermes(31:60) = 'lid                           '                          PLOTS.842
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.843
        nomap = .true.                                                           PLOTS.844
      else if ((ier .ne. 0) .and. (ier .ne. 94)) then                            PLOTS.845
        ermes(1:30)  = 'Uncorrectable Error Encoutered'                          PLOTS.846
        ermes(31:60) = '                              '                          PLOTS.847
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.848
        nomap = .true.                                                           PLOTS.849
      end if                                                                     PLOTS.850
                                                                                 PLOTS.851
C  If Background color is not black warn the user that their maps may look       PLOTS.852
C  stupid                                                                        PLOTS.853
                                                                                 PLOTS.854
      if ((red .ne. 0.0) .and. (blue .ne. 0.0) .and.                             PLOTS.855
     *    (green .ne. 0.0)) then                                                 PLOTS.856
        ermes(1:30)  = 'Background Color Index Is Not '                          PLOTS.857
        ermes(31:60) = 'Black, Background Color Reset '                          PLOTS.858
C       call errhan ('MAPDRV',0,ermes,errsev)                                    PLOTS.859
C        call gscr (1,0,0.00,0.00,0.00)                                           PLOTS.860
      end if                                                                     PLOTS.861
                                                                                 PLOTS.862
      call gqcr (1,1,0,ier,red,blue,green)                                       PLOTS.863
                                                                                 PLOTS.864
C  Check for errors from GKS                                                     PLOTS.865
                                                                                 PLOTS.866
      if ((ier .eq. 87) .or. (ier .eq. 93)) then                                 PLOTS.867
        ermes(1:30)  = 'Foreground Color Index Is Inva'                          PLOTS.868
        ermes(31:60) = 'lid                           '                          PLOTS.869
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.870
        nomap = .true.                                                           PLOTS.871
      else if ((ier .ne. 0) .and. (ier .ne. 94)) then                            PLOTS.872
        ermes(1:30)  = 'Uncorrectable Error Encoutered'                          PLOTS.873
        ermes(31:60) = '                              '                          PLOTS.874
        call errhan ('MAPDRV',1,ermes,errsev)                                    PLOTS.875
        nomap = .true.                                                           PLOTS.876
      end if                                                                     PLOTS.877
                                                                                 PLOTS.878
C  If Background color is not black warn the user that their maps may look       PLOTS.879
C  stupid                                                                        PLOTS.880
                                                                                 PLOTS.881
      if ((red .lt. 0.8) .and. (blue .lt. 0.8) .and.                             PLOTS.882
     *    (green .lt. 0.8)) then                                                 PLOTS.883
        ermes(1:30)  = 'Foreground Color Index Is Not '                          PLOTS.884
        ermes(31:60) = 'White, Foreground Color Reset '                          PLOTS.885
        call errhan ('MAPDRV',0,ermes,errsev)                                    PLOTS.886
C        call gscr (1,1,0.80,0.80,0.80)                                           PLOTS.887
      end if                                                                     PLOTS.888
                                                                                 PLOTS.889
C  Check that a WISS workstation has been opened for GFLASH                      PLOTS.890
                                                                                 PLOTS.891
      if (buff .ge. 0) then                                                      PLOTS.892
        call gqopwk (1,ier,nwk,num)                                              PLOTS.893
        do 10 i = 1,nwk                                                          PLOTS.894
          call gqopwk (i,ier,temp,num)                                           PLOTS.895
          call gqwkc (num,ier,temp,wtype)                                        PLOTS.896
          call gqwkca (wtype,ier,categ)                                          PLOTS.897
          if (categ .eq. 3) awiss = .true.                                       PLOTS.898
10      continue                                                                 PLOTS.899
        if (.not. awiss) then                                                    PLOTS.900
          ermes(1:30)  = 'No WISS Workstation Open      '                        PLOTS.901
          ermes(31:60) = '                              '                        PLOTS.902
          call errhan ('MAPDRV',1,ermes,errsev)                                  PLOTS.903
          unum = 0                                                               PLOTS.904
20        unum = unum + 1                                                        PLOTS.905
          inquire (unit=unum,opened=used)                                        PLOTS.906
          if (used) goto 20                                                      PLOTS.907
          call gopwk (2,unum,3)                                                  PLOTS.908
          nomap = .true.                                                         PLOTS.909
        end if                                                                   PLOTS.910
      end if                                                                     PLOTS.911
                                                                                 PLOTS.912
C*****************************  subroutine end *******************************C  PLOTS.913
                                                                                 PLOTS.914
      return                                                                     PLOTS.915
      end                                                                        PLOTS.916
      subroutine lccone (fsplat,ssplat,sign)                                     PLOTS.917
                                                                                 PLOTS.918
C*****************************************************************************C  PLOTS.919
C  lccone   - This is a MAPDRV routine                                        C  PLOTS.920
C  Section  - Design                                                          C  PLOTS.921
C  Purpose  - To calculate the cone factor to use in a Lambert Conformal Pro- C  PLOTS.922
C             jection.                                                        C  PLOTS.923
C                                                                             C  PLOTS.924
C  On entry - FSPLAT is the first standard parallel to use in the calculation C  PLOTS.925
C             of the cone factor.  SSPLAT is the second such parallel.   SIGN C  PLOTS.926
C             indicates what hemisphere the projection is in.                 C  PLOTS.927
C                                                                             C  PLOTS.928
C  On exit  - CONFAC is calculated and stored in the common block LAMSTF with C  PLOTS.929
C             FSPLAT and SSPLAT.                                              C  PLOTS.930
C                                                                             C  PLOTS.931
C  Assume   - Nothing.                                                        C  PLOTS.932
C                                                                             C  PLOTS.933
C  Author   - Jeremy Asbill       Date - October 10, 1990    for the MM4 club C  PLOTS.934
C*****************************************************************************C  PLOTS.935
                                                                                 PLOTS.936
C  Parameters                                                                    PLOTS.937
                                                                                 PLOTS.938
      parameter       (conv = 0.01745329251994)                                  PLOTS.939
                                                                                 PLOTS.940
C  Integer variables                                                             PLOTS.941
                                                                                 PLOTS.942
      integer          sign              ! indicates which hemisphere      (in)  PLOTS.943
                                                                                 PLOTS.944
C  Real variables                                                                PLOTS.945
                                                                                 PLOTS.946
      real             fsplat,           ! first standard parallel lat.    (in)  PLOTS.947
     *                 ssplat            ! second standard parallel lat.   (in)  PLOTS.948
      real             confac,           ! for common block LAMSTF               PLOTS.949
     *                 fsparl,           ! for common block LAMSTF               PLOTS.950
     *                 ssparl            ! for common block LAMSTF               PLOTS.951
                                                                                 PLOTS.952
C  Common blocks                                                                 PLOTS.953
                                                                                 PLOTS.954
      common /lamstf/  confac,           ! cone factor to be used                PLOTS.955
     *                 fsparl,           ! first standard parallel lat.          PLOTS.956
     *                 ssparl            ! second standard parallel lat.         PLOTS.957
                                                                                 PLOTS.958
C****************************  subroutine begin  *****************************C  PLOTS.959
                                                                                 PLOTS.960
C  Calculate CONFAC using input parameters                                       PLOTS.961
                                                                                 PLOTS.962
      if ( abs(fsplat-ssplat) .gt. 1.e-1 ) then                                  19DEC02.44
      confac = alog10(cos(fsplat * conv)) - alog10(cos(ssplat * conv))           PLOTS.963
      confac = confac/(alog10(tan((45.0 - float(sign) *                          PLOTS.964
     *                             fsplat/2.0) * conv)) -                        PLOTS.965
     *                 alog10(tan((45.0 - float(sign) *                          PLOTS.966
     *                             ssplat/2.0) * conv)))                         PLOTS.967
      else                                                                       19DEC02.45
      confac = sign*sin(fsplat * conv)                                           19DEC02.46
      end if                                                                     19DEC02.47
                                                                                 PLOTS.968
C  Stuff it all into the common block                                            PLOTS.969
                                                                                 PLOTS.970
      fsparl = fsplat                                                            PLOTS.971
      ssparl = ssplat                                                            PLOTS.972
                                                                                 PLOTS.973
C*****************************  subroutine end  ******************************C  PLOTS.974
                                                                                 PLOTS.975
      return                                                                     PLOTS.976
      end                                                                        PLOTS.977
      subroutine llproc (xcs,ycs,ncs,aid,gid,nid)                                PLOTS.978
                                                                                 PLOTS.979
C*****************************************************************************C  PLOTS.980
C   llproc  - This is a MAPDRV routine                                        C  PLOTS.981
C   Section - Lat/Lon Lines                                                   C  PLOTS.982
C   Purpose - To draw lat/lon  lines  for  all  patterns  except  publication C  PLOTS.983
C             style.                                                          C  PLOTS.984
C                                                                             C  PLOTS.985
C  On entry - XCS and YCS hold the x  and y  coordinates,  in  the fractional C  PLOTS.986
C             coordinate system, of NCS points defining a segment of the lat/ C  PLOTS.987
C             lon grid to be drawn. AID and GID contain NID pairs of area and C  PLOTS.988
C             group identifiers describing the polygon.   Common block LLLDET C  PLOTS.989
C             contains the detail information about where the lines go an how C  PLOTS.990
C             they should look.  Common block LLLCOL contains  the  color  to C  PLOTS.991
C             make them.  Common block MOCDET contains information about what C  PLOTS.992
C             outlines were used to draw and fill the map.   Finally,  common C  PLOTS.993
C             block MAPEDGE contains the fraction  coordinates  defining  the C  PLOTS.994
C             edge of the map.                                                C  PLOTS.995
C                                                                             C  PLOTS.996
C  On exit  - A portion of the grid has been drawn.   If the current  portion C  PLOTS.997
C             of the lat/lon grid intersected the edge of the map the approp- C  PLOTS.998
C             riate variables in common blocks LABNUM  and LABPOS  have  been C  PLOTS.999
C             updated.                                                        C  PLOTS.1000
C                                                                             C  PLOTS.1001
C  Assume   - GKS is open.  This routine is called by the EZMAPA utility.     C  PLOTS.1002
C                                                                             C  PLOTS.1003
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1004
C             ----------------------------------------------------------------C  PLOTS.1005
C             GQPLCI              GKS                                         C  PLOTS.1006
C             GSPLCI              GKS                                         C  PLOTS.1007
C             DASHDB              DASHLINE utility*                           C  PLOTS.1008
C             CURVED              DASHLINE utility*                           C  PLOTS.1009
C             ----------------------------------------------------------------C  PLOTS.1010
C             * NCAR Graphics routine                                         C  PLOTS.1011
C                                                                             C  PLOTS.1012
C             This routine is not called by MAPDRV, it is called by the AREAS C  PLOTS.1013
C             utility which is called by the EZMAPA utility routine MAPGRM.   C  PLOTS.1014
C                                                                             C  PLOTS.1015
C             Also note that the first part of this routine checks for  label C  PLOTS.1016
C             positions for the MAPDRV style labels.                          C  PLOTS.1017
C                                                                             C  PLOTS.1018
C  Author   - Jeremy Asbill       Date - July 7, 1990        for the MM4 club C  PLOTS.1019
C*****************************************************************************C  PLOTS.1020
                                                                                 PLOTS.1021
C  Parameters                                                                    PLOTS.1022
                                                                                 PLOTS.1023
      parameter        (tol = 0.0005)                                            PLOTS.1024
                                                                                 PLOTS.1025
C  Character variables                                                           PLOTS.1026
                                                                                 PLOTS.1027
      character*2      wouts             ! for common block MOCDET               PLOTS.1028
                                                                                 PLOTS.1029
C  Integer variables                                                             PLOTS.1030
                                                                                 PLOTS.1031
      integer          aid(*),           ! area identifiers                (in)  PLOTS.1032
     *                 gid(*),           ! group identifiers               (in)  PLOTS.1033
     *                 ncs,              ! dimension for XCS and YCS       (in)  PLOTS.1034
     *                 nid               ! dimension for AID and GID       (in)  PLOTS.1035
      integer          llplc,            ! for common block LLLDET               PLOTS.1036
     *                 grdsh,            ! for common block LLLDET               PLOTS.1037
     *                 llint             ! for common block LLLDET               PLOTS.1038
      integer          llcolr            ! for common block LLLCOL               PLOTS.1039
      integer          lfnum,            ! for common block LABNUM               PLOTS.1040
     *                 rgnum,            ! for common block LABNUM               PLOTS.1041
     *                 btnum,            ! for common block LABNUM               PLOTS.1042
     *                 tpnum             ! for common block LABNUM               PLOTS.1043
      integer          itm,              ! calculation variable         (local)  PLOTS.1044
     *                 plsv,             ! integer save variable        (local)  PLOTS.1045
     *                 ier               ! junk filler                  (local)  PLOTS.1046
                                                                                 PLOTS.1047
C  Real variables                                                                PLOTS.1048
                                                                                 PLOTS.1049
      real             xcs(*),           ! the grid line x coordinates     (in)  PLOTS.1050
     *                 ycs(*)            ! the grid line y coordinates     (in)  PLOTS.1051
      real             left,             ! for common block MAPEDGE              PLOTS.1052
     *                 right,            ! for common block MAPEDGE              PLOTS.1053
     *                 bottom,           ! for common block MAPEDGE              PLOTS.1054
     *                 top               ! for common block MAPEDGE              PLOTS.1055
      real             lfpos(360,2),     ! for common block LABPOS               PLOTS.1056
     *                 rgpos(360,2),     ! for common block LABPOS               PLOTS.1057
     *                 btpos(360,2),     ! for common block LABPOS               PLOTS.1058
     *                 tppos(360,2)      ! for common block LABPOS               PLOTS.1059
                                                                                 PLOTS.1060
C  Common blocks                                                                 PLOTS.1061
                                                                                 PLOTS.1062
      common /llldet/  llplc,            ! where do we draw lat/lon lines        PLOTS.1063
     *                 grdsh,            ! lat/lon grid dash pattern             PLOTS.1064
     *                 llint             ! not used                              PLOTS.1065
      common /lllcol/  llcolr            ! color of lat/lon lines                PLOTS.1066
      common /mocdet/  wouts             ! which outlines were used              PLOTS.1067
      common /mapedge/ left,             ! fractional coord. of left edge        PLOTS.1068
     *                 right,            ! fractional coord. of right edge       PLOTS.1069
     *                 bottom,           ! fractional coord. of bottom edge      PLOTS.1070
     *                 top               ! fractional coord. of top edge         PLOTS.1071
      common /labpos/  lfpos,            ! positions of labels along the left    PLOTS.1072
     *                 rgpos,            ! positions of labels along the right   PLOTS.1073
     *                 btpos,            ! positions of labels along the bottom  PLOTS.1074
     *                 tppos             ! positions of labels along the top     PLOTS.1075
      common /labnum/  lfnum,            ! # of positions in LFPOS               PLOTS.1076
     *                 rgnum,            ! # of positions in RGPOS               PLOTS.1077
     *                 btnum,            ! # of positions in BTPOS               PLOTS.1078
     *                 tpnum             ! # of positions in TPPOS               PLOTS.1079
                                                                                 PLOTS.1080
C****************************  subroutine begin  ****************************C   PLOTS.1081
                                                                                 PLOTS.1082
C  Iteratively search for all intersections with the boundary                    PLOTS.1083
C  These intersections are locations for lat/lon line labels or MAPDRV           PLOTS.1084
C  labels                                                                        PLOTS.1085
                                                                                 PLOTS.1086
      do 10 i = 1,ncs                                                            PLOTS.1087
                                                                                 PLOTS.1088
C  First check for an intersection with the bottom                               PLOTS.1089
                                                                                 PLOTS.1090
        if ((ycs(i) .ge. (bottom - tol))  .and.                                  PLOTS.1091
     *      (ycs(i) .le. (bottom + tol))) then                                   PLOTS.1092
          if (xcs(i) .ne. btpos(btnum,1)) then                                   PLOTS.1093
            btnum = btnum + 1                                                    PLOTS.1094
            if (btnum .eq. 362) then                                             PLOTS.1095
              btnum = btnum - 1                                                  PLOTS.1096
            else if (btnum .lt. 361) then                                        PLOTS.1097
              btpos(btnum,1) = xcs(i)                                            PLOTS.1098
              btpos(btnum,2) = ycs(i)                                            PLOTS.1099
            end if                                                               PLOTS.1100
          end if                                                                 PLOTS.1101
                                                                                 PLOTS.1102
C  Second check for an intersection with the top                                 PLOTS.1103
                                                                                 PLOTS.1104
        else if ((ycs(i) .ge. (top - tol)) .and.                                 PLOTS.1105
     *           (ycs(i) .le. (top + tol))) then                                 PLOTS.1106
          if (xcs(i) .ne. tppos(tpnum,1)) then                                   PLOTS.1107
            tpnum = tpnum + 1                                                    PLOTS.1108
            if (tpnum .eq. 362) then                                             PLOTS.1109
              tpnum = tpnum - 1                                                  PLOTS.1110
            else if (tpnum .lt. 361) then                                        PLOTS.1111
              tppos(tpnum,1) = xcs(i)                                            PLOTS.1112
              tppos(tpnum,2) = ycs(i)                                            PLOTS.1113
            end if                                                               PLOTS.1114
          end if                                                                 PLOTS.1115
                                                                                 PLOTS.1116
C  First check for intersection with the left                                    PLOTS.1117
                                                                                 PLOTS.1118
        else if ((xcs(i) .ge. (left - tol)) .and.                                PLOTS.1119
     *           (xcs(i) .le. (left + tol))) then                                PLOTS.1120
          if (ycs(i) .ne. lfpos(lfnum,2)) then                                   PLOTS.1121
            lfnum = lfnum + 1                                                    PLOTS.1122
            if (lfnum .eq. 362) then                                             PLOTS.1123
              lfnum = lfnum - 1                                                  PLOTS.1124
            else if (lfnum .lt. 361) then                                        PLOTS.1125
              lfpos(lfnum,1) = xcs(i)                                            PLOTS.1126
              lfpos(lfnum,2) = ycs(i)                                            PLOTS.1127
            end if                                                               PLOTS.1128
          end if                                                                 PLOTS.1129
                                                                                 PLOTS.1130
C  Second check for an intersection with the right                               PLOTS.1131
                                                                                 PLOTS.1132
        else if ((xcs(i) .ge. (right - tol)) .and.                               PLOTS.1133
     *           (xcs(i) .le. (right + tol))) then                               PLOTS.1134
          if (ycs(i) .ne. rgpos(rgnum,2)) then                                   PLOTS.1135
            rgnum = rgnum + 1                                                    PLOTS.1136
            if (rgnum .eq. 362) then                                             PLOTS.1137
              rgnum = rgnum - 1                                                  PLOTS.1138
            else if (rgnum .lt. 361) then                                        PLOTS.1139
              rgpos(rgnum,1) = xcs(i)                                            PLOTS.1140
              rgpos(rgnum,2) = ycs(i)                                            PLOTS.1141
            end if                                                               PLOTS.1142
          endif                                                                  PLOTS.1143
        end if                                                                   PLOTS.1144
10    continue                                                                   PLOTS.1145
                                                                                 PLOTS.1146
C  Only draw lat/lon lines if some were requested                                PLOTS.1147
C  LLPLC = 0 means no lat/lon lines were requested                               PLOTS.1148
C  LLPLC = 0 means publication style lat/lon lines were requested                PLOTS.1149
                                                                                 PLOTS.1150
      if ((llplc .ne. 0) .and. (grdsh .ne. 0)) then                              PLOTS.1151
                                                                                 PLOTS.1152
C  Get and save polyline color index                                             PLOTS.1153
                                                                                 PLOTS.1154
        call gqplci (ier,plsv)                                                   PLOTS.1155
                                                                                 PLOTS.1156
C  Set up new index                                                              PLOTS.1157
                                                                                 PLOTS.1158
        call gsplci (llcolr)                                                     PLOTS.1159
                                                                                 PLOTS.1160
C  Set up correct dash pattern                                                   PLOTS.1161
                                                                                 PLOTS.1162
        call dashdb (grdsh)                                                      PLOTS.1163
                                                                                 PLOTS.1164
C  Make sure the polygon lies within the map                                     PLOTS.1165
                                                                                 PLOTS.1166
        if ((aid(1) .ge. 0) .and. (aid(2) .ge. 0)) then                          PLOTS.1167
                                                                                 PLOTS.1168
C  Get the maximum of the area identifiers                                       PLOTS.1169
                                                                                 PLOTS.1170
          itm = max0(aid(1),aid(2))                                              PLOTS.1171
                                                                                 PLOTS.1172
C  If we want lat/lon lines over land then draw them when the suggested color    PLOTS.1173
C  index is not 1.  The areas package suggests that oceans have color index 1.   PLOTS.1174
C  MAPACI is an EZMAPA function.                                                 PLOTS.1175
                                                                                 PLOTS.1176
          if ((llplc .eq. 1) .and. (wouts(1:2) .ne. 'NO')) then                  PLOTS.1177
            if ((mapaci(itm) .ne. 1) .and. (itm .ne. 223) .and.                  PLOTS.1178
     *          (itm .ne. 0))                                                    PLOTS.1179
                                                                                 PLOTS.1180
C  Draw the line and do it using grdsh.                                          PLOTS.1181
                                                                                 PLOTS.1182
     *        call curved (xcs,ycs,ncs)                                          PLOTS.1183
                                                                                 PLOTS.1184
C  If we want lat/lon lines over water then draw them when the area is           PLOTS.1185
C  identified as either ocean or no within the outlines                          PLOTS.1186
C  ITM = 2,1005 means the line is over the ocean                                 PLOTS.1187
C  ITM = 223 means the line is outside the U.S. States                           PLOTS.1188
C  ITM = 0 means, even though outlines were requested there are none             PLOTS.1189
C          in the map, so it is all water                                        PLOTS.1190
                                                                                 PLOTS.1191
          else if ((llplc .eq. -1) .and. (wouts(1:2) .ne. 'NO')) then            PLOTS.1192
            if ((itm .eq. 2) .or. (itm .eq. 223) .or.                            PLOTS.1193
     *          (itm .eq. 1005) .or. (itm .eq. 0))                               PLOTS.1194
                                                                                 PLOTS.1195
C  Draw the line and try to do it using grdsh.                                   PLOTS.1196
                                                                                 PLOTS.1197
     *        call curved (xcs,ycs,ncs)                                          PLOTS.1198
                                                                                 PLOTS.1199
C  If we want lat/lon lines over both land and water just draw them              PLOTS.1200
C  Also if there are no outlines, just draw them                                 PLOTS.1201
                                                                                 PLOTS.1202
          else                                                                   PLOTS.1203
            call curved (xcs,ycs,ncs)                                            PLOTS.1204
          end if                                                                 PLOTS.1205
        end if                                                                   PLOTS.1206
                                                                                 PLOTS.1207
C  Reset the polyline color index                                                PLOTS.1208
                                                                                 PLOTS.1209
        call gsplci (plsv)                                                       PLOTS.1210
      end if                                                                     PLOTS.1211
                                                                                 PLOTS.1212
C****************************  subroutine end  ******************************C   PLOTS.1213
                                                                                 PLOTS.1214
      return                                                                     PLOTS.1215
      end                                                                        PLOTS.1216
      subroutine mapdrv (project,fsplat,ssplat,cenlat,cenlon,grds,jmax,          PLOTS.1217
     *                   imax,xpa,xpb,ypa,ypb,titline,titlen,buff,unum,          PLOTS.1218
     *                   doset,errsev)                                           PLOTS.1219
                                                                                 PLOTS.1220
C*****************************************************************************C  PLOTS.1221
C  mapdrv   - Map Driver                                                      C  PLOTS.1222
C                                                                             C  PLOTS.1223
C  Purpose  - To generate esthetically pleasing maps for use in analysis pro- C  PLOTS.1224
C             gram.  It is the hopes of the programmer that this utility will C  PLOTS.1225
C             be used in GRAPH, RAWINS, TERRAIN and other programs of the MM4 C  PLOTS.1226
C             modelling system.  This utility is completely general and gives C  PLOTS.1227
C             the user flexibility in map appearence.                         C  PLOTS.1228
C                                                                             C  PLOTS.1229
C  On entry - PROJECT  describes what projection is being  used.   FSPLAT and C  PLOTS.1230
C             SSPLAT are only valid if PROJECT = 'LC' and then they represent C  PLOTS.1231
C             the first and second standard parallels respectively to be used C  PLOTS.1232
C             when calculating the projection cone factor.  CENLAT and CENLON C  PLOTS.1233
C             is  the central latitude and longitude of the domain.  GRDS  is C  PLOTS.1234
C             the grid distance of the grid the domain is described on.  JMAX C  PLOTS.1235
C             and IMAX define the overall size of the grid.  XPA, YPA are the C  PLOTS.1236
C             lower left hand grid point of the subdomain to be drawn.   XPB, C  PLOTS.1237
C             YPB  are the upper right hand grid point of the subdomain to be C  PLOTS.1238
C             drawn.  TITLINE is the title to go below the map. TITLEN is the C  PLOTS.1239
C             number of characters in TITLINE.  BUFF is the GFLASH  buffer to C  PLOTS.1240
C             store the map in and UNUM is the unit number to read the tables C  PLOTS.1241
C             from.  If BUFF is negative then only an area map is to be  gen- C  PLOTS.1242
C             erated for CONDRV to use.  If UNUM is negative there are no ta- C  PLOTS.1243
C             bles and everything defaults.  DOSET  tells MAPDRV if it should C  PLOTS.1244
C             do  its  own set call or use the set call the  user  has  made. C  PLOTS.1245
C             ERRSEV  is either a negative positive or zero.                  C  PLOTS.1246
C               ERRSEV > 0 means, nothing stops execution                     C  PLOTS.1247
C               ERRSEV = 0 means, errors stop execution, warnings do not      C  PLOTS.1248
C               ERRSEV < 0 means, both errors and warnings stop execution.    C  PLOTS.1249
C                                                                             C  PLOTS.1250
C  On exit  - The map has been stored in GFLASH buffer BUFF.                  C  PLOTS.1251
C                                                                             C  PLOTS.1252
C  Assume   - That a color table has been set up and GKS is open and active.  C  PLOTS.1253
C             The defining grid begins at 1,1.                                C  PLOTS.1254
C                                                                             C  PLOTS.1255
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1256
C             ----------------------------------------------------------------C  PLOTS.1257
C             INTERR              MAPDRV utility                              C  PLOTS.1258
C             MRDDET              MAPDRV utility                              C  PLOTS.1259
C             MRDFIL              MAPDRV utility                              C  PLOTS.1260
C             MRDCLT              MAPDRV utility                              C  PLOTS.1261
C             SETWIN              MAPDRV utility                              C  PLOTS.1262
C             SETPRO              MAPDRV utility                              C  PLOTS.1263
C             MAPSTI              EZMAP utility*                              C  PLOTS.1264
C             SETMAP              MAPDRV utility                              C  PLOTS.1265
C             MPDRLL              MAPDRV utility                              C  PLOTS.1266
C             MPDRCL              MAPDRV utility                              C  PLOTS.1267
C             GSFAIS              GKS                                         C  PLOTS.1268
C             MAPINT              EZMAP utility*                              C  PLOTS.1269
C             GFLAS1              GFLASH utility*                             C  PLOTS.1270
C             MPDROL              MAPDRV utility                              C  PLOTS.1271
C             PERIM               GRIDAL utility*                             C  PLOTS.1272
C             MPDREL              MAPDRV utility                              C  PLOTS.1273
C             MPDRML              MAPDRV utility                              C  PLOTS.1274
C             MPDRTL              MAPDRV utility                              C  PLOTS.1275
C             GFLAS2              GFLASH utility*                             C  PLOTS.1276
C             MAPFIL              MAPDRV utility                              C  PLOTS.1277
C             GQCLIP              GKS                                         C  PLOTS.1278
C             GSCLIP              GKS                                         C  PLOTS.1279
C             ----------------------------------------------------------------C  PLOTS.1280
C             * NCAR Graphics routine                                         C  PLOTS.1281
C                                                                             C  PLOTS.1282
C             If this is the domain ...                                       C  PLOTS.1283
C                                                                             C  PLOTS.1284
C        imax ----------------------------|--------------------------         C  PLOTS.1285
C             |      ypb -------------------------------------      |         C  PLOTS.1286
C             |          |                |                  |      |         C  PLOTS.1287
C             |          |                |                  |      |         C  PLOTS.1288
C             |          |                |                  |      |         C  PLOTS.1289
C             |          |                |                  |      |         C  PLOTS.1290
C             |          |                |                  |      |         C  PLOTS.1291
C             |          |                |                  |      |         C  PLOTS.1292
C             |          |                |                  |      |         C  PLOTS.1293
C        cenlat----------|----------------|------------------|-------         C  PLOTS.1294
C             |          |                |                  |      |         C  PLOTS.1295
C             |      ypa -------------------------------------      |         C  PLOTS.1296
C             |          xpa              |                xpb      |         C  PLOTS.1297
C             |                           |                         |         C  PLOTS.1298
C             |                           |                         |         C  PLOTS.1299
C             |                         cenlon                      |         C  PLOTS.1300
C             |                           |                         |         C  PLOTS.1301
C             |                           |                         |         C  PLOTS.1302
C             ----------------------------|--------------------------         C  PLOTS.1303
C                                                                jmax         C  PLOTS.1304
C                                                                             C  PLOTS.1305
C  Author   - Jeremy Asbill        Date - July 6, 1990       for the MM4 club C  PLOTS.1306
C*****************************************************************************C  PLOTS.1307
                                                                                 PLOTS.1308
C  Character variables                                                           PLOTS.1309
                                                                                 PLOTS.1310
      character*80     titline           ! string containing the title     (in)  PLOTS.1311
      character*2      project           ! specifies projection            (in)  PLOTS.1312
                                                                                 PLOTS.1313
C  Integer variables                                                             PLOTS.1314
                                                                                 PLOTS.1315
      integer          imax,             ! y dimension size of entire grid (in)  PLOTS.1316
     *                 jmax,             ! x dimension size of entire grid (in)  PLOTS.1317
     *                 titlen,           ! # of characters in title string (in)  PLOTS.1318
     *                 buff,             ! GFLASH buffer to use            (in)  PLOTS.1319
     *                 unum,             ! unit number tables are on       (in)  PLOTS.1320
     *                 errsev            ! error severity indicator        (in)  PLOTS.1321
      integer          wlabs,            ! which labels do we want      (local)  PLOTS.1322
     *                 cfsv,             ! clipping flag save variable  (local)  PLOTS.1323
     *                 ier               ! junk filler                  (local)  PLOTS.1324
                                                                                 PLOTS.1325
C  Logical variables                                                             PLOTS.1326
                                                                                 PLOTS.1327
      logical          doset             ! do our own set here ?           (in)  PLOTS.1328
      logical          flmap,            ! is the map being filled ?    (local)  PLOTS.1329
     *                 title,            ! put a title on the map ?     (local)  PLOTS.1330
     *                 perm,             ! put a perimeter on the map ? (local)  PLOTS.1331
     *                 nomap             ! don't draw a map ?           (local)  PLOTS.1332
                                                                                 PLOTS.1333
C  Real variables                                                                PLOTS.1334
                                                                                 PLOTS.1335
      real             cenlat,           ! central latitude of the domain  (in)  PLOTS.1336
     *                 cenlon,           ! central longitude of the domain (in)  PLOTS.1337
     *                 fsplat,           ! first standard parallel (LC)    (in)  PLOTS.1338
     *                 ssplat,           ! second standard parallel (LC)   (in)  PLOTS.1339
     *                 grds,             ! grid distance in kilometers     (in)  PLOTS.1340
     *                 xpa,              ! lower left x grid pt. on map    (in)  PLOTS.1341
     *                 xpb,              ! upper right x grid pt. on map   (in)  PLOTS.1342
     *                 ypa,              ! lower left y grid pt. on map    (in)  PLOTS.1343
     *                 ypb               ! upper right y grid pt. on map   (in)  PLOTS.1344
      real             junk(4)           ! junk filler                  (local)  PLOTS.1345
                                                                                 PLOTS.1346
C*********************** subroutine begin ************************************C  PLOTS.1347
                                                                                 PLOTS.1348
C  EZMAP internal parameters used in this routine are:                           PLOTS.1349
C  VS  - Vertical Slicing                                                        PLOTS.1350
                                                                                 PLOTS.1351
C  Assume the map will not be filled until otherwise decided                     PLOTS.1352
                                                                                 PLOTS.1353
      flmap = .false.                                                            PLOTS.1354
                                                                                 PLOTS.1355
C  Do initial error checking                                                     PLOTS.1356
                                                                                 PLOTS.1357
      call interr (nomap,fsplat,ssplat,jmax,imax,xpa,ypa,xpb,ypb,                PLOTS.1358
     *             project,grds,cenlat,cenlon,buff,errsev)                       PLOTS.1359
                                                                                 PLOTS.1360
C  Get map details                                                               PLOTS.1361
                                                                                 PLOTS.1362
      call mrddet (unum,buff,llplc,wlabs,title,perm,errsev,nomap)                PLOTS.1363
                                                                                 PLOTS.1364
C  If an area map has been requested rather than a drawn map                     PLOTS.1365
C  skip the next two table reads                                                 PLOTS.1366
                                                                                 PLOTS.1367
      if (buff .ge. 0) then                                                      PLOTS.1368
                                                                                 PLOTS.1369
C  Get map fill information                                                      PLOTS.1370
                                                                                 PLOTS.1371
        call mrdfil (unum,flmap,errsev,nomap)                                    PLOTS.1372
                                                                                 PLOTS.1373
C  Get map color information                                                     PLOTS.1374
                                                                                 PLOTS.1375
        call mrdclt (unum,llplc,wlabs,title,errsev,nomap)                        PLOTS.1376
                                                                                 PLOTS.1377
C  Save the users setting for clipping and then turn it off                      PLOTS.1378
                                                                                 PLOTS.1379
        call gqclip (ier,cfsv,junk)                                              PLOTS.1380
        call gsclip (0)                                                          PLOTS.1381
      end if                                                                     PLOTS.1382
                                                                                 PLOTS.1383
C  Do not design the map if NOMAP is set                                         PLOTS.1384
                                                                                 PLOTS.1385
      if (.not. nomap) then                                                      PLOTS.1386
                                                                                 PLOTS.1387
C  Set up the proper projection                                                  PLOTS.1388
                                                                                 PLOTS.1389
        call setpro (project,cenlat,cenlon)                                      PLOTS.1390
                                                                                 PLOTS.1391
C  Set the window up, making sure there is room above and below it               PLOTS.1392
                                                                                 PLOTS.1393
        call setwin (xpa,ypa,xpb,ypb,doset)                                      PLOTS.1394
                                                                                 PLOTS.1395
C  Set up the map window on the globe                                            PLOTS.1396
                                                                                 PLOTS.1397
        call setmap (cenlat,cenlon,project,grds,                                 PLOTS.1398
     *               xpa,ypa,xpb,ypb,imax,jmax)                                  PLOTS.1399
                                                                                 PLOTS.1400
C  Set up the outline, outline colors, and text colors for the map               PLOTS.1401
                                                                                 PLOTS.1402
        call mpdrcl (perm,buff)                                                  PLOTS.1403
                                                                                 PLOTS.1404
C  If color fill is requested, force solid fill                                  PLOTS.1405
                                                                                 PLOTS.1406
        if ((flmap) .and. (buff .ge. 0)) then                                    PLOTS.1407
          call gsfais (1)                                                        PLOTS.1408
                                                                                 PLOTS.1409
C  Use 20 vertical slice to stay within polygon size limits of devices           PLOTS.1410
                                                                                 PLOTS.1411
          call mapsti ('VS',20)                                                  PLOTS.1412
        end if                                                                   PLOTS.1413
                                                                                 PLOTS.1414
C  Initialize EZMAP                                                              PLOTS.1415
                                                                                 PLOTS.1416
        call mapint                                                              PLOTS.1417
      end if                                                                     PLOTS.1418
                                                                                 PLOTS.1419
C  Start saving metacode instructions                                            PLOTS.1420
                                                                                 PLOTS.1421
      if (buff .ge. 0) call gflas1 (buff)                                        PLOTS.1422
                                                                                 PLOTS.1423
C  Do not draw the map if a non-correctable error occured                        PLOTS.1424
                                                                                 PLOTS.1425
      if (.not. nomap) then                                                      PLOTS.1426
                                                                                 PLOTS.1427
C  Call user subroutine                                                          PLOTS.1428
                                                                                 PLOTS.1429
        call mpdrus                                                              PLOTS.1430
                                                                                 PLOTS.1431
C  Prepare for and do color fill                                                 PLOTS.1432
                                                                                 PLOTS.1433
        call mapfil (flmap,buff)                                                 PLOTS.1434
                                                                                 PLOTS.1435
C  Draw the outlines                                                             PLOTS.1436
                                                                                 PLOTS.1437
        if (buff .ge. 0) then                                                    PLOTS.1438
          call mpdrol                                                            PLOTS.1439
                                                                                 PLOTS.1440
C  Draw in the lat/lon line grid                                                 PLOTS.1441
                                                                                 PLOTS.1442
          call mpdrll (grds,flmap,wlabs,cenlon,xpa,xpb,project)                  PLOTS.1443
                                                                                 PLOTS.1444
C  Draw a nice perimeter                                                         PLOTS.1445
                                                                                 PLOTS.1446
          if (perm)                                                              PLOTS.1447
     *      call perim (0,nint(xpb - xpa),0,nint(ypb - ypa))                     PLOTS.1448
                                                                                 PLOTS.1449
C  Set up and draw EZMAP labels                                                  PLOTS.1450
                                                                                 PLOTS.1451
          call mpdrel (perm)                                                     PLOTS.1452
                                                                                 PLOTS.1453
C  Set up and draw MAPDRV labels                                                 PLOTS.1454
                                                                                 PLOTS.1455
          call mpdrml (xpa,ypa,xpb,ypb,project,grds,cenlat,cenlon,               PLOTS.1456
     *                 jmax,imax,errsev)                                         PLOTS.1457
                                                                                 PLOTS.1458
C  Inform the user about there map only if one was made                          PLOTS.1459
                                                                                 PLOTS.1460
          print *, 'MAPDRV - Map Successfully Completed'                         PLOTS.1461
        end if                                                                   PLOTS.1462
      end if                                                                     PLOTS.1463
                                                                                 PLOTS.1464
C  Put on the title                                                              PLOTS.1465
                                                                                 PLOTS.1466
      if (buff .ge. 0) then                                                      PLOTS.1467
        call mpdrtl (titline,titlen,nomap)                                       PLOTS.1468
                                                                                 PLOTS.1469
C  Restore the users clipping setting                                            PLOTS.1470
                                                                                 PLOTS.1471
        call gsclip (cfsv)                                                       PLOTS.1472
                                                                                 PLOTS.1473
C  Save all this on the map background to be flashed                             PLOTS.1474
                                                                                 PLOTS.1475
        call gflas2                                                              PLOTS.1476
      end if                                                                     PLOTS.1477
                                                                                 PLOTS.1478
C*****************************  subroutine end  ******************************C  PLOTS.1479
                                                                                 PLOTS.1480
      return                                                                     PLOTS.1481
      end                                                                        PLOTS.1482
      subroutine mapfil (flmap,buff)                                             PLOTS.1483
                                                                                 PLOTS.1484
C*****************************************************************************C  PLOTS.1485
C  mapfil   - This is a MAPDRV routine                                        C  PLOTS.1486
C  Section  - Fill                                                            C  PLOTS.1487
C  Purpose  - To do requested color fill, including filling the background if C  PLOTS.1488
C             no geographical outlines are requested.                         C  PLOTS.1489
C                                                                             C  PLOTS.1490
C  On entry - FLMAP tells us if we should fill or not.  WOUTS in common block C  PLOTS.1491
C             MOCDET tells us which geographical outlines are requested.   If C  PLOTS.1492
C             BUFF is negative then the map should be put into the CONDRV ar- C  PLOTS.1493
C             ea map and not filled to the buffer.                            C  PLOTS.1494
C                                                                             C  PLOTS.1495
C  On exit  - The map has been filled.                                        C  PLOTS.1496
C                                                                             C  PLOTS.1497
C  Assume   - GKS is open.                                                    C  PLOTS.1498
C                                                                             C  PLOTS.1499
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1500
C             ----------------------------------------------------------------C  PLOTS.1501
C             ARINAM              AREAS utility*                              C  PLOTS.1502
C             MAPBLA              EZMAPA utility*                             C  PLOTS.1503
C             ARPRAM              AREAS utility*                              C  PLOTS.1504
C             ARSCAM              AREAS utility*                              C  PLOTS.1505
C             GETSET              SPPS*                                       C  PLOTS.1506
C             SFSGFA              SOFTFILL utility*                           C  PLOTS.1507
C             ----------------------------------------------------------------C  PLOTS.1508
C             * NCAR Graphics routine                                         C  PLOTS.1509
C                                                                             C  PLOTS.1510
C  Author   - Jeremy Asbill        Date - July 9, 1990       for the MM4 club C  PLOTS.1511
C*****************************************************************************C  PLOTS.1512
                                                                                 PLOTS.1513
C  Character variables                                                           PLOTS.1514
                                                                                 PLOTS.1515
      character*2      wouts             ! for common block MOCDET               PLOTS.1516
                                                                                 PLOTS.1517
C  Integer varaibles                                                             PLOTS.1518
                                                                                 PLOTS.1519
      integer          buff              ! GFLASH buffer to use            (in)  PLOTS.1520
      integer          amapf(255000)     ! for common block ARAMAP               PLOTS.1521
      integer          cfmap(500000)     ! for common block CSCAMP               PLOTS.1522
      integer          cdmap(100000)     ! for common block CLNAMP               PLOTS.1523
      integer          wacolr            ! for common block FLWATR               PLOTS.1524
      integer          binhr             ! for common block CONFLG               PLOTS.1525
      integer          aid(10),          ! area idfiers array for AREAS (local)  PLOTS.1526
     *                 gid(10),          ! group idfiers array , AREAS  (local)  PLOTS.1527
     *                 ind(12),          ! scratch array for SOFTFILL   (local)  PLOTS.1528
     *                 llsv              ! junk filler                  (local)  PLOTS.1529
                                                                                 PLOTS.1530
C  Logical variables                                                             PLOTS.1531
                                                                                 PLOTS.1532
      logical          flmap             ! will we fill the map ?          (in)  PLOTS.1533
                                                                                 PLOTS.1534
C  Real variables                                                                PLOTS.1535
                                                                                 PLOTS.1536
      real             xcs(5500),        ! x dimension array for AREAS  (local)  PLOTS.1537
     *                 ycs(5500),        ! y dimension array for AREAS  (local)  PLOTS.1538
     *                 xvp(4),           ! x coords for viewport        (local)  PLOTS.1539
     *                 yvp(4),           ! y coords for viewport        (local)  PLOTS.1540
     *                 dst(8),           ! scratch array for SOFTFILL   (local)  PLOTS.1541
     *                 ulsv,             ! junk filler                  (local)  PLOTS.1542
     *                 ursv,             ! junk filler                  (local)  PLOTS.1543
     *                 utsv,             ! junk filler                  (local)  PLOTS.1544
     *                 ubsv              ! junk filler                  (local)  PLOTS.1545
                                                                                 PLOTS.1546
C  Common blocks                                                                 PLOTS.1547
                                                                                 PLOTS.1548
      common /mocdet/  wouts             ! geographical outline indicator        PLOTS.1549
      common /aramap/  amapf             ! area map for fill                     PLOTS.1550
      common /flwatr/  wacolr            ! background color                      PLOTS.1551
      common /cscamp/  cfmap             ! CONDRV area map for shade and color   PLOTS.1552
      common /clnamp/  cdmap             ! CONDRV area map for drawing           PLOTS.1553
      common /conflg/  binhr             ! 722 => we have been in here           PLOTS.1554
                                                                                 PLOTS.1555
C  External routines                                                             PLOTS.1556
                                                                                 PLOTS.1557
      external         clproc            ! does actual filling of polygons       PLOTS.1558
                                                                                 PLOTS.1559
C****************************  subroutine begin  *****************************C  PLOTS.1560
                                                                                 PLOTS.1561
C  Do a regular map fill if a fill is requested and there are geographical       PLOTS.1562
C  outlines to use                                                               PLOTS.1563
                                                                                 PLOTS.1564
      if ((flmap) .and. (wouts(1:2) .ne. 'NO')) then                             PLOTS.1565
                                                                                 PLOTS.1566
C  Initialize area map                                                           PLOTS.1567
                                                                                 PLOTS.1568
        call arinam (amapf,255000)                                               PLOTS.1569
                                                                                 PLOTS.1570
C  Set the group identifiers to the EZMAPA defaults                              PLOTS.1571
                                                                                 PLOTS.1572
        call mapsti ('G1',1)                                                     PLOTS.1573
        call mapsti ('G2',2)                                                     PLOTS.1574
                                                                                 PLOTS.1575
C  Add edges to the area map                                                     PLOTS.1576
                                                                                 PLOTS.1577
#if defined(NCARG42)                                                             05DEC01.115
        call mplnam ( 'Earth..2' , 5 , amapf )                                   05DEC01.116
#elif defined(NCARG41)                                                           05DEC01.117
        call mplnam ( 'Earth..1' , 4 , amapf )                                   05DEC01.118
#else                                                                            05DEC01.119
        call mapbla (amapf)                                                      PLOTS.1578
#endif                                                                           05DEC01.120
                                                                                 PLOTS.1579
C  Preprocess the area map                                                       PLOTS.1580
                                                                                 PLOTS.1581
        call arpram (amapf,0,0,0)                                                PLOTS.1582
                                                                                 PLOTS.1583
C  Fill the map                                                                  PLOTS.1584
                                                                                 PLOTS.1585
        call arscam (amapf,xcs,ycs,5500,aid,gid,10,clproc)                       PLOTS.1586
                                                                                 PLOTS.1587
C  Fill the entire viewport if no outlines are request and fill is still         PLOTS.1588
C  desired                                                                       PLOTS.1589
                                                                                 PLOTS.1590
      else if ((flmap) .and. (wouts(1:2) .eq. 'NO')) then                        PLOTS.1591
                                                                                 PLOTS.1592
C  Define the polygon in an array                                                PLOTS.1593
                                                                                 PLOTS.1594
        call getset (ulsv,ursv,ubsv,utsv,xvp(1),xvp(3),yvp(1),yvp(2),            PLOTS.1595
     *               llsv)                                                       PLOTS.1596
        xvp(2) = xvp(1)                                                          PLOTS.1597
        yvp(3) = yvp(2)                                                          PLOTS.1598
        xvp(4) = xvp(3)                                                          PLOTS.1599
        yvp(4) = yvp(1)                                                          PLOTS.1600
                                                                                 PLOTS.1601
C  Fill the viewport                                                             PLOTS.1602
                                                                                 PLOTS.1603
        call sfsgfa (xvp,yvp,4,dst,8,ind,12,wacolr)                              PLOTS.1604
                                                                                 PLOTS.1605
C  Put the map into the CONDRV area map if BUFF is negative                      PLOTS.1606
                                                                                 PLOTS.1607
      else if (buff .lt. 0) then                                                 PLOTS.1608
                                                                                 PLOTS.1609
C  Let CONDRV know that we have been here                                        PLOTS.1610
                                                                                 PLOTS.1611
        binhr = 722                                                              PLOTS.1612
                                                                                 PLOTS.1613
C  Initialize both area maps                                                     PLOTS.1614
                                                                                 PLOTS.1615
        call arinam (cfmap,500000)                                               PLOTS.1616
        call arinam (cdmap,100000)                                               PLOTS.1617
                                                                                 PLOTS.1618
C  Set the group identifiers to 6 and 7                                          PLOTS.1619
                                                                                 PLOTS.1620
        call mapsti ('G1',6)                                                     PLOTS.1621
        call mapsti ('G2',7)                                                     PLOTS.1622
                                                                                 PLOTS.1623
C  Add the map to both area maps                                                 PLOTS.1624
                                                                                 PLOTS.1625
        call mapbla (cfmap)                                                      PLOTS.1626
        call mapbla (cdmap)                                                      PLOTS.1627
      end if                                                                     PLOTS.1628
                                                                                 PLOTS.1629
C*****************************  subroutine end  ******************************C  PLOTS.1630
                                                                                 PLOTS.1631
      return                                                                     PLOTS.1632
      end                                                                        PLOTS.1633
      subroutine mpdrcl (perm,buff)                                              PLOTS.1634
                                                                                 PLOTS.1635
C*****************************************************************************C  PLOTS.1636
C   mpdrcl  - This is a MAPDRV routine                                        C  PLOTS.1637
C   Section - Design                                                          C  PLOTS.1638
C   Purpose - To set up those internal parameters, and a few other parameters C  PLOTS.1639
C             that define the colors for the map.   To define the proper geo- C  PLOTS.1640
C             graphical outlines for the map.                                 C  PLOTS.1641
C                                                                             C  PLOTS.1642
C  On entry - Common block OUTCOL contains the outline colors.   Common block C  PLOTS.1643
C             PERCOL  contains the perimeter  color.   WOUTS  in common block C  PLOTS.1644
C             MOCDET tells us which outline colors to set.   PERM tells  what C  PLOTS.1645
C             kind of perimeter will be put on the map.   If BUFF is negative C  PLOTS.1646
C             only set up the outline.                                        C  PLOTS.1647
C                                                                             C  PLOTS.1648
C  On exit  - The color for the map outlines have been set up.  The color for C  PLOTS.1649
C             the perimeter has been set up.  The correct outlines have  been C  PLOTS.1650
C             set up with EZMAP.                                              C  PLOTS.1651
C                                                                             C  PLOTS.1652
C  Assume   - GKS is open.                                                    C  PLOTS.1653
C                                                                             C  PLOTS.1654
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1655
C             ----------------------------------------------------------------C  PLOTS.1656
C             MAPSTI              EZMAP utility*                              C  PLOTS.1657
C             GACOLR              GRIDAL utility*                             C  PLOTS.1658
C             ----------------------------------------------------------------C  PLOTS.1659
C             * NCAR Graphics routine                                         C  PLOTS.1660
C                                                                             C  PLOTS.1661
C  Author   - Jeremy Asbill        Date - July 7, 1990       for the MM4 club C  PLOTS.1662
C*****************************************************************************C  PLOTS.1663
                                                                                 PLOTS.1664
C  Character variables                                                           PLOTS.1665
                                                                                 PLOTS.1666
      character*2      wouts             ! for common block MOCDET               PLOTS.1667
                                                                                 PLOTS.1668
C  Integer variables                                                             PLOTS.1669
                                                                                 PLOTS.1670
      integer          buff              ! GFLASH buffer number            (in)  PLOTS.1671
      integer          cocolr,           ! for common block OUTCOL               PLOTS.1672
     *                 uscolr,           ! for common block OUTCOL               PLOTS.1673
     *                 cncolr            ! for common block OUTCOL               PLOTS.1674
      integer          pecolr            ! for common block PERCOL               PLOTS.1675
                                                                                 PLOTS.1676
C  Logical variables                                                             PLOTS.1677
                                                                                 PLOTS.1678
      logical          perm              ! what perimeter will be used ?   (in)  PLOTS.1679
                                                                                 PLOTS.1680
C  Common blocks                                                                 PLOTS.1681
                                                                                 PLOTS.1682
      common /outcol/  cocolr,           ! color of continents                   PLOTS.1683
     *                 uscolr,           ! color of states                       PLOTS.1684
     *                 cncolr            ! color of countries                    PLOTS.1685
      common /percol/  pecolr            ! color of perimeter                    PLOTS.1686
      common /mocdet/  wouts             ! desired outline indicator             PLOTS.1687
                                                                                 PLOTS.1688
C****************************  subroutine begin  ****************************C   PLOTS.1689
                                                                                 PLOTS.1690
C  EZMAP internal parameters used are:                                           PLOTS.1691
C  C1  - Color of EZMAP perimeter                                                PLOTS.1692
C  C5  - Color index for CO, continental boundaries                              PLOTS.1693
C  C6  - Color index for US, state boundaries                                    PLOTS.1694
C  C7  - Color index for CN, country boundaries                                  PLOTS.1695
C  OU  - geographical OUtlines                                                   PLOTS.1696
                                                                                 PLOTS.1697
C  Only set up colors if a map is going to be drawn                              PLOTS.1698
                                                                                 PLOTS.1699
      if (buff .ge. 0) then                                                      PLOTS.1700
                                                                                 PLOTS.1701
C  Determine which outlines will be drawn and set those colors                   PLOTS.1702
                                                                                 PLOTS.1703
        if (wouts(1:2) .eq. 'US') then                                           PLOTS.1704
          call mapsti ('C6',uscolr)                                              PLOTS.1705
        else if (wouts(1:2) .eq. 'PS') then                                      PLOTS.1706
          call mapsti ('C6',uscolr)                                              PLOTS.1707
          call mapsti ('C5',cocolr)                                              PLOTS.1708
          call mapsti ('C7',cncolr)                                              PLOTS.1709
        else if (wouts(1:2) .eq. 'PO') then                                      PLOTS.1710
          call mapsti ('C5',cocolr)                                              PLOTS.1711
          call mapsti ('C7',cncolr)                                              PLOTS.1712
        else if (wouts(1:2) .eq. 'CO') then                                      PLOTS.1713
          call mapsti ('C5',cocolr)                                              PLOTS.1714
        end if                                                                   PLOTS.1715
                                                                                 PLOTS.1716
C  Set up the color of the perimeter                                             PLOTS.1717
                                                                                 PLOTS.1718
        if (perm) then                                                           PLOTS.1719
          call gacolr (pecolr,pecolr,pecolr,pecolr)                              PLOTS.1720
        else                                                                     PLOTS.1721
          call mapsti ('C1',pecolr)                                              PLOTS.1722
        end if                                                                   PLOTS.1723
      end if                                                                     PLOTS.1724
                                                                                 PLOTS.1725
C  Setup the outline                                                             PLOTS.1726
                                                                                 PLOTS.1727
      call mapstc ('OU',wouts(1:2))                                              PLOTS.1728
                                                                                 PLOTS.1729
C****************************  subroutine end  ******************************C   PLOTS.1730
                                                                                 PLOTS.1731
      return                                                                     PLOTS.1732
      end                                                                        PLOTS.1733
      subroutine mpdrel  (perm)                                                  PLOTS.1734
                                                                                 PLOTS.1735
C*****************************************************************************C  PLOTS.1736
C  mpdrel   - This is a MAPDRV routine                                        C  PLOTS.1737
C  Section  - Labels                                                          C  PLOTS.1738
C  Purpose  - To design and draw EZMAP labels.                                C  PLOTS.1739
C                                                                             C  PLOTS.1740
C  On entry - PERM indicates if the EZMAP perimeter should  be drawn with the C  PLOTS.1741
C             labels.                                                         C  PLOTS.1742
C                                                                             C  PLOTS.1743
C  On exit  - The labels have been written to the GFLASH buffer.              C  PLOTS.1744
C                                                                             C  PLOTS.1745
C  Assume   - GKS is open.  The map itself has been drawn.                    C  PLOTS.1746
C                                                                             C  PLOTS.1747
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1748
C             ----------------------------------------------------------------C  PLOTS.1749
C             MAPSTI              EZMAP utility*                              C  PLOTS.1750
C             MAPLBL              EZMAP utility*                              C  PLOTS.1751
C             ----------------------------------------------------------------C  PLOTS.1752
C             * NCAR Graphics routine                                         C  PLOTS.1753
C                                                                             C  PLOTS.1754
C  Author   - Jeremy Asbill        Date - July 7, 1990       for the MM4 club C  PLOTS.1755
C*****************************************************************************C  PLOTS.1756
                                                                                 PLOTS.1757
C  Parameter                                                                     PLOTS.1758
                                                                                 PLOTS.1759
      parameter        (scale = 20.0)    ! scales LBSIZ for EZMAP                PLOTS.1760
                                                                                 PLOTS.1761
C  Integer variables                                                             PLOTS.1762
                                                                                 PLOTS.1763
      integer          wlabs,            ! for common block MLBDET               PLOTS.1764
     *                 lbqul(2)          ! for common block MLBDET               PLOTS.1765
      integer          lacolr            ! for common block LABCOL               PLOTS.1766
                                                                                 PLOTS.1767
C  Logical variables                                                             PLOTS.1768
                                                                                 PLOTS.1769
      logical          perm              ! put a perimeter on the map ?    (in)  PLOTS.1770
                                                                                 PLOTS.1771
C  Real variables                                                                PLOTS.1772
                                                                                 PLOTS.1773
      real             lbsiz             ! for common block MLBDET               PLOTS.1774
      real             temp              ! calculation variable         (local)  PLOTS.1775
                                                                                 PLOTS.1776
C  Common blocks                                                                 PLOTS.1777
                                                                                 PLOTS.1778
      common /mlbdet/  wlabs,            ! which labels do we want               PLOTS.1779
     *                 lbsiz,            ! alternate label size                  PLOTS.1780
     *                 lbqul             ! not used                              PLOTS.1781
      common /labcol/  lacolr            ! label color                           PLOTS.1782
                                                                                 PLOTS.1783
C****************************  subroutine begin  *****************************C  PLOTS.1784
                                                                                 PLOTS.1785
C  EZMAP internal parameters used in this routine are:                           PLOTS.1786
C  LS  - Label Size                                                              PLOTS.1787
C  C3  - Color index for EZMAP labels                                            PLOTS.1788
C  PE  - PErimeter flag                                                          PLOTS.1789
C  LA  - LAbel flag                                                              PLOTS.1790
                                                                                 PLOTS.1791
C  Set up EZMAP labels                                                           PLOTS.1792
                                                                                 PLOTS.1793
      if ((wlabs .eq. 2) .or. (wlabs .eq. -1)) then                              PLOTS.1794
                                                                                 PLOTS.1795
C  Turn on the EZMAP labels                                                      PLOTS.1796
                                                                                 PLOTS.1797
        call mapstl ('LA',.true.)                                                PLOTS.1798
                                                                                 PLOTS.1799
C  Set up correct color for EZMAP labels                                         PLOTS.1800
                                                                                 PLOTS.1801
        call mapsti ('C3',lacolr)                                                PLOTS.1802
                                                                                 PLOTS.1803
C  Set up proper label size for EZMAP labels                                     PLOTS.1804
                                                                                 PLOTS.1805
        temp = scale * lbsiz                                                     PLOTS.1806
        temp = amod(temp,12.0)                                                   PLOTS.1807
        temp = temp/12                                                           PLOTS.1808
        if (temp .eq. 0.0) then                                                  PLOTS.1809
          temp = 1.0                                                             PLOTS.1810
        end if                                                                   PLOTS.1811
        call mapsti ('LS',nint(temp))                                            PLOTS.1812
      else                                                                       PLOTS.1813
                                                                                 PLOTS.1814
C  Turn of the EZMAP labels                                                      PLOTS.1815
                                                                                 PLOTS.1816
        call mapstl ('LA',.false.)                                               PLOTS.1817
      end if                                                                     PLOTS.1818
                                                                                 PLOTS.1819
                                                                                 PLOTS.1820
C  Set up the EZMAP perimeter                                                    PLOTS.1821
                                                                                 PLOTS.1822
      if (perm) then                                                             PLOTS.1823
        call mapstl ('PE',.false.)                                               PLOTS.1824
      else                                                                       PLOTS.1825
        call mapstl ('PE',.true.)                                                PLOTS.1826
      end if                                                                     PLOTS.1827
                                                                                 PLOTS.1828
C  Draw the EZMAP labels ( and possibly the perimeter)                           PLOTS.1829
                                                                                 PLOTS.1830
      if ((wlabs .eq. 2) .or. (wlabs .eq. -1) .or. (.not. perm))                 PLOTS.1831
     *  call maplbl                                                              PLOTS.1832
                                                                                 PLOTS.1833
C*****************************  subroutine end  ******************************C  PLOTS.1834
                                                                                 PLOTS.1835
      return                                                                     PLOTS.1836
      end                                                                        PLOTS.1837
      subroutine mpdrll (grds,flmap,wlabs,cenlon,xpa,xpb,project)                PLOTS.1838
                                                                                 PLOTS.1839
C*****************************************************************************C  PLOTS.1840
C  mpdrll   - This is a MAPDRV routine                                        C  PLOTS.1841
C  Section  - Lat/Lon Lines                                                   C  PLOTS.1842
C  Purpose  - To set up a lat/lon line grid and draw it to the map.           C  PLOTS.1843
C                                                                             C  PLOTS.1844
C  On entry - The common block LLLDET contains the design information for the C  PLOTS.1845
C             grid.  The common block LLLCOL contains the color index for the C  PLOTS.1846
C             grid.   GRDS  conatins  the  grid distance  on the domain grid. C  PLOTS.1847
C             FLMAP  tells us if the map was filled or not.   XPA  is  the  x C  PLOTS.1848
C             coord of the first grid point in the map.   XPB  is the x coord C  PLOTS.1849
C             of the last grid point  in  the map.   WLABS  tells what labels C  PLOTS.1850
C             have been requested.  PROJECT contains the projection used.     C  PLOTS.1851
C                                                                             C  PLOTS.1852
C  On exit  - The grid has been drawn to the GFLASH buffer.                   C  PLOTS.1853
C                                                                             C  PLOTS.1854
C  Assume   - GKS is open. A color table has been set up.  The map itself has C  PLOTS.1855
C             been drawn to the GFLASH buffer.                                C  PLOTS.1856
C                                                                             C  PLOTS.1857
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.1858
C             ----------------------------------------------------------------C  PLOTS.1859
C             ARINAM              AREAS utility*                              C  PLOTS.1860
C             MAPSTC              EZMAP utility*                              C  PLOTS.1861
C             MAPBLA              EZMAPA utility*                             C  PLOTS.1862
C             ARPRAM              AREAS utility*                              C  PLOTS.1863
C             MAPSTI              EZMAP utility*                              C  PLOTS.1864
C             MAPGRM              EZMAPA utility*                             C  PLOTS.1865
C             ----------------------------------------------------------------C  PLOTS.1866
C             * NCAR Graphics routine                                         C  PLOTS.1867
C                                                                             C  PLOTS.1868
C             This routine also  determines  the  locations  for  the  MAPDRV C  PLOTS.1869
C             labels.   This  determination  occurs in the  external  routine C  PLOTS.1870
C             LLPROC  which  is called by the  EZMAPA  routine  MAPGRM.  This C  PLOTS.1871
C             routine saves some  necessary  information and then, even if no C  PLOTS.1872
C             no lat/lon  lines are  requested  may have to call   MAPGRM  if C  PLOTS.1873
C             MAPDRV labels have been requested.                              C  PLOTS.1874
C                                                                             C  PLOTS.1875
C  Author   - Jeremy Asbill        Date - July 7, 1990       for the MM4 club C  PLOTS.1876
C*****************************************************************************C  PLOTS.1877
                                                                                 PLOTS.1878
C  Character variables                                                           PLOTS.1879
                                                                                 PLOTS.1880
      character*2      project           ! projection used in map          (in)  PLOTS.1881
      character*2      wouts             ! for common block MOCDET               PLOTS.1882
                                                                                 PLOTS.1883
C  Integer variables                                                             PLOTS.1884
                                                                                 PLOTS.1885
      integer          wlabs             ! which labels do we want         (in)  PLOTS.1886
      integer          llplc,            ! for common block LLLDET               PLOTS.1887
     *                 grdsh,            ! for common block LLLDET               PLOTS.1888
     *                 llint             ! for common block LLLDET               PLOTS.1889
      integer          amapf(255000)     ! for common block ARAMAP               PLOTS.1890
      integer          lfnum,            ! for common block LABNUM               PLOTS.1891
     *                 rgnum,            ! for common block LABNUM               PLOTS.1892
     *                 btnum,            ! for common block LABNUM               PLOTS.1893
     *                 tpnum             ! for common block LABNUM               PLOTS.1894
      integer          aid(10),          ! area identifiers for areas   (local)  PLOTS.1895
     *                 gid(10),          ! group identifiers for areas  (local)  PLOTS.1896
     *                 numdeg,           ! # of degs. lat/lon in domain (local)  PLOTS.1897
     *                 numgrd,           ! grid interval to use         (local)  PLOTS.1898
     *                 ngrd,             ! # of grid pts in map in x dir(local)  PLOTS.1899
     *                 lltm              ! junk filler                  (local)  PLOTS.1900
                                                                                 PLOTS.1901
C  Logical variables                                                             PLOTS.1902
                                                                                 PLOTS.1903
      logical          flmap             ! did we fill the map ?           (in)  PLOTS.1904
                                                                                 PLOTS.1905
C  Real variables                                                                PLOTS.1906
                                                                                 PLOTS.1907
      real             grds,             ! grid distance in kilometers     (in)  PLOTS.1908
     *                 xpa,              ! x coord of 1st grid in map      (in)  PLOTS.1909
     *                 xpb,              ! x coord of last grid in map     (in)  PLOTS.1910
     *                 cenlon            ! center longitude                (in)  PLOTS.1911
      real             left,             ! for common block MAPEDGE              PLOTS.1912
     *                 right,            ! for common block MAPEDGE              PLOTS.1913
     *                 bottom,           ! for common block MAPEDGE              PLOTS.1914
     *                 top               ! for common block MAPEDGE              PLOTS.1915
      real             xcs(1000),        ! x coords for polys in areas  (local)  PLOTS.1916
     *                 ycs(1000),        ! same as XCS for y coords     (local)  PLOTS.1917
     *                 ultm,             ! junk filler                  (local)  PLOTS.1918
     *                 urtm,             ! junk filler                  (local)  PLOTS.1919
     *                 ubtm,             ! junk filler                  (local)  PLOTS.1920
     *                 uttm              ! junk filler                  (local)  PLOTS.1921
                                                                                 PLOTS.1922
C  Common blocks                                                                 PLOTS.1923
                                                                                 PLOTS.1924
      common /llldet/  llplc,            ! where do we draw lat/lon lines        PLOTS.1925
     *                 grdsh,            ! lat/lon grid dash pattern             PLOTS.1926
     *                 llint             ! lat/lon grid interval in degrees      PLOTS.1927
      common /mocdet/  wouts             ! geographical outline indicator        PLOTS.1928
      common /aramap/  amapf             ! area map for lat/lon lines            PLOTS.1929
      common /mapedge/ left,             ! fractional coord. of left edge        PLOTS.1930
     *                 right,            ! fractional coord. of right edge       PLOTS.1931
     *                 bottom,           ! fractional coord. of bottom edge      PLOTS.1932
     *                 top               ! fractional coord. of top edge         PLOTS.1933
      common /labnum/  lfnum,            ! # of label positions on left          PLOTS.1934
     *                 rgnum,            ! # of label positions on right         PLOTS.1935
     *                 btnum,            ! # of label positions on bottom        PLOTS.1936
     *                 tpnum             ! # of label positions on top           PLOTS.1937
                                                                                 PLOTS.1938
C  External routines                                                             PLOTS.1939
                                                                                 PLOTS.1940
      external         llproc            ! does actual drawing of lat/lon lines  PLOTS.1941
                                                                                 PLOTS.1942
C****************************  subroutine begin  *****************************C  PLOTS.1943
                                                                                 PLOTS.1944
C  EZMAP internal parrameters used in this routine are:                          PLOTS.1945
C  GR  - lat/lon GRid interval                                                   PLOTS.1946
C  DA  - lat/lon grid DAsh pattern                                               PLOTS.1947
C  C2  - lat/lon grid Color index                                                PLOTS.1948
C  OU  - geographical OUtline indicator                                          PLOTS.1949
C  VS  - Vertical Slicing                                                        PLOTS.1950
                                                                                 PLOTS.1951
C  Set vertical slicing to 1 slice so that dash patterns will be okay            PLOTS.1952
                                                                                 PLOTS.1953
      if (llplc .ne. 0)                                                          PLOTS.1954
     *  call mapsti ('VS',1)                                                     PLOTS.1955
                                                                                 PLOTS.1956
C  See if grid needs to be masked                                                PLOTS.1957
C  We donn't need the areamap if                                                 PLOTS.1958
C    a - no lat/lon lines requested and                                          PLOTS.1959
C    b - no labels are requested                                                 PLOTS.1960
                                                                                 PLOTS.1961
      if ((llplc .ne. 0) .or. (wlabs .eq. 1) .or.                                PLOTS.1962
     *    (wlabs .eq. 2)) then                                                   PLOTS.1963
                                                                                 PLOTS.1964
C  Use the least time consuming outlines for the mask                            PLOTS.1965
                                                                                 PLOTS.1966
        if ((wouts(1:2) .eq. 'PS') .or. (wouts(1:2) .eq. 'PO') .or.              PLOTS.1967
     *      (wouts(1:2) .eq. 'NO'))                                              PLOTS.1968
     *    call mapstc ('OU','CO')                                                PLOTS.1969
                                                                                 PLOTS.1970
C  Initialize area map                                                           PLOTS.1971
                                                                                 PLOTS.1972
        call arinam (amapf,175000)                                               PLOTS.1973
                                                                                 PLOTS.1974
C  Also add the edges with which to mask                                         PLOTS.1975
                                                                                 PLOTS.1976
        call mapbla (amapf)                                                      PLOTS.1977
                                                                                 PLOTS.1978
C  Preprocess the area map                                                       PLOTS.1979
                                                                                 PLOTS.1980
        call arpram (amapf,0,0,0)                                                PLOTS.1981
                                                                                 PLOTS.1982
C  Get the fractional coordinates of the edges of the map                        PLOTS.1983
                                                                                 PLOTS.1984
        call getset (left,right,bottom,top,                                      PLOTS.1985
     *               ultm,urtm,ubtm,uttm,lltm)                                   PLOTS.1986
                                                                                 PLOTS.1987
C  Initialize the label counters                                                 PLOTS.1988
                                                                                 PLOTS.1989
        lfnum = 0                                                                PLOTS.1990
        rgnum = 0                                                                PLOTS.1991
        btnum = 0                                                                PLOTS.1992
        tpnum = 0                                                                PLOTS.1993
                                                                                 PLOTS.1994
C  If LLINT = 0 then choose a nice grid interval                                 PLOTS.1995
                                                                                 PLOTS.1996
        if (llint .eq. 0) then                                                   PLOTS.1997
          ngrd   = nint(xpb - xpa) + 1                                           PLOTS.1998
          numdeg = int(grds * float(ngrd)/111.0)                                 PLOTS.1999
          if (numdeg .lt. 10) then                                               PLOTS.2000
            numgrd = 2                                                           PLOTS.2001
          else if (numdeg .lt. 20) then                                          PLOTS.2002
            numgrd = 5                                                           PLOTS.2003
          else if (numdeg .lt. 90) then                                          PLOTS.2004
            numgrd = 10                                                          PLOTS.2005
          else                                                                   PLOTS.2006
            numgrd = 15                                                          PLOTS.2007
          end if                                                                 PLOTS.2008
        else                                                                     PLOTS.2009
                                                                                 PLOTS.2010
C  If LLINT isn't 0 then use it as the grid interval                             PLOTS.2011
                                                                                 PLOTS.2012
          numgrd = llint                                                         PLOTS.2013
        end if                                                                   PLOTS.2014
                                                                                 PLOTS.2015
C  Set up grid interval in EZMAP                                                 PLOTS.2016
                                                                                 PLOTS.2017
        call mapsti ('GR',numgrd)                                                PLOTS.2018
                                                                                 PLOTS.2019
C  Draw the latitude/longitude grid                                              PLOTS.2020
                                                                                 PLOTS.2021
        if ((grdsh .eq. 0) .and. (llplc .ne. 0)) then                            PLOTS.2022
          call prodll (numgrd,cenlon,project)                                    PLOTS.2023
        end if                                                                   PLOTS.2024
        call mapgrm (amapf,xcs,ycs,1000,aid,gid,10,llproc)                       PLOTS.2025
      end if                                                                     PLOTS.2026
                                                                                 PLOTS.2027
C*****************************  subroutine end  ******************************C  PLOTS.2028
                                                                                 PLOTS.2029
      return                                                                     PLOTS.2030
      end                                                                        PLOTS.2031
      subroutine mpdrml (xpa,ypa,xpb,ypb,project,grds,cenlat,cenlon,             PLOTS.2032
     *                   jend,iend,errsev)                                       PLOTS.2033
                                                                                 PLOTS.2034
C*****************************************************************************C  PLOTS.2035
C  mpdrml   - This is a MAPDRV routine                                        C  PLOTS.2036
C  Section  - Labels                                                          C  PLOTS.2037
C  Purpose  - To design and draw MAPDRV labels.                               C  PLOTS.2038
C                                                                             C  PLOTS.2039
C  On entry - XPA,vYPA forms the lower left grid point of the map.   XPB, YPB C  PLOTS.2040
C             forms the upper right grid point of the map.  PROJECT indicates C  PLOTS.2041
C             what projection  is  being used.   GRDS is the distance between C  PLOTS.2042
C             grid points in km.   CENLAT  and CENLON are the center latitude C  PLOTS.2043
C             and  longitude  respectively.   JEND, IEND form the upper right C  PLOTS.2044
C             grid point  of  the domain.   ERRSEV indicates what severity of C  PLOTS.2045
C             an error should halt execution.   Design information about  the C  PLOTS.2046
C             labels particularly is passed in through common blocks.         C  PLOTS.2047
C                                                                             C  PLOTS.2048
C  On exit  - The labels have been drawn.                                     C  PLOTS.2049
C                                                                             C  PLOTS.2050
C  Assume   - GKS is open.  The map itself has been drawn.                    C  PLOTS.2051
C                                                                             C  PLOTS.2052
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.2053
C             ----------------------------------------------------------------C  PLOTS.2054
C             MAPGTI              EZMAP utility*                              C  PLOTS.2055
C             PCSETI              PLOTCHAR utility*                           C  PLOTS.2056
C             XYTOLL              MAPDRV utility                              C  PLOTS.2057
C             PLCHHQ              PLOTCHAR utility*                           C  PLOTS.2058
C             GSTXCI              GKS                                         C  PLOTS.2059
C             GSPLCI              GKS                                         C  PLOTS.2060
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.2061
C             GETSET              SPPS*                                       C  PLOTS.2062
C             SET                 SPPS*                                       C  PLOTS.2063
C             ----------------------------------------------------------------C  PLOTS.2064
C             * NCAR Graphics routine                                         C  PLOTS.2065
C                                                                             C  PLOTS.2066
C             This  routine  also draws  in  the  publication style perimeter C  PLOTS.2067
C             ticks when they are requested.                                  C  PLOTS.2068
C                                                                             C  PLOTS.2069
C  Author   - Jeremy Asbill       Date - July 19, 1990       for the MM4 club C  PLOTS.2070
C*****************************************************************************C  PLOTS.2071
                                                                                 PLOTS.2072
C  Parameter                                                                     PLOTS.2073
                                                                                 PLOTS.2074
      parameter        (ito = 1)         ! redundancy tolerance                  PLOTS.2075
      parameter        (pi  = 3.14159)   ! pi! you know pi, irrational guy       PLOTS.2076
      parameter        (re  = 6370.0)    ! radius of the earth                   PLOTS.2077
                                                                                 PLOTS.2078
C  Character variables                                                           PLOTS.2079
                                                                                 PLOTS.2080
      character*2      project           ! projection indicator            (in)  PLOTS.2081
      character*60     ermes             ! error message string         (local)  PLOTS.2082
      character*5      str               ! label string                 (local)  PLOTS.2083
                                                                                 PLOTS.2084
C  Integer variables                                                             PLOTS.2085
                                                                                 PLOTS.2086
      integer          jend,             ! right grid point value, domain  (in)  PLOTS.2087
     *                 iend,             ! top grid point value, domain    (in)  PLOTS.2088
     *                 errsev            ! error severity comparitor       (in)  PLOTS.2089
      integer          wlabs,            ! for common block MLBDET               PLOTS.2090
     *                 lbqul(2)          ! for common block MLBDET               PLOTS.2091
      integer          imax,             ! for common block XYLLON               PLOTS.2092
     *                 jmax              ! for common block XYLLON               PLOTS.2093
      integer          lacolr            ! for common block LABCOL               PLOTS.2094
      integer          lfnum,            ! for common block LABNUM               PLOTS.2095
     *                 rgnum,            ! for common block LABNUM               PLOTS.2096
     *                 btnum,            ! for common block LABNUM               PLOTS.2097
     *                 tpnum             ! for common block LABNUM               PLOTS.2098
      integer          llplc,            ! for common block LLLDET               PLOTS.2099
     *                 grdsh,            ! for common block LLLDET               PLOTS.2100
     *                 llint             ! for common block LLLDET               PLOTS.2101
      integer          llcolr            ! for common block LLLCOL               PLOTS.2102
      integer          nmgr,             ! lat/lon grid interval        (local)  PLOTS.2103
     *                 llval(360,2),     ! lat/lon values per side      (local)  PLOTS.2104
     *                 tst1,             ! test variable                (local)  PLOTS.2105
     *                 tst2,             ! test variable                (local)  PLOTS.2106
     *                 latcnt,           ! latitude counter             (local)  PLOTS.2107
     *                 loncnt,           ! longitude counter            (local)  PLOTS.2108
     *                 i,j,              ! loop counter/place keeper    (local)  PLOTS.2109
     *                 xy,yz,            ! dimension picker             (local)  PLOTS.2110
     *                 slen,             ! label string length          (local)  PLOTS.2111
     *                 loop,             ! loop maximum                 (local)  PLOTS.2112
     *                 llsv              ! save variable                (local)  PLOTS.2113
                                                                                 PLOTS.2114
C  Real variables                                                                PLOTS.2115
                                                                                 PLOTS.2116
      real             xpa,              ! left grid point value, map      (in)  PLOTS.2117
     *                 ypa,              ! bottom grid point value, map    (in)  PLOTS.2118
     *                 xpb,              ! right grid point value, map     (in)  PLOTS.2119
     *                 ypb,              ! top grid point value, map       (in)  PLOTS.2120
     *                 grds,             ! grid distance in km             (in)  PLOTS.2121
     *                 cenlat,           ! center latitude, domain         (in)  PLOTS.2122
     *                 cenlon            ! center longitude, domain        (in)  PLOTS.2123
      real             dds,              ! for common block XYLLON               PLOTS.2124
     *                 xlat,             ! for common block XYLLON               PLOTS.2125
     *                 xlon              ! for common block XYLLON               PLOTS.2126
      real             lbsiz             ! for common block MLBDET               PLOTS.2127
      real             left,             ! for common block MAPEDGE              PLOTS.2128
     *                 right,            ! for common block MAPEDGE              PLOTS.2129
     *                 bottom,           ! for common block MAPEDGE              PLOTS.2130
     *                 top               ! for common block MAPEDGE              PLOTS.2131
      real             lfpos(360,2),     ! for common block LABPOS               PLOTS.2132
     *                 rgpos(360,2),     ! for common block LABPOS               PLOTS.2133
     *                 btpos(360,2),     ! for common block LABPOS               PLOTS.2134
     *                 tppos(360,2)      ! for common block LABPOS               PLOTS.2135
      real             xn,               ! cone factor for projection   (local)  PLOTS.2136
     *                 grx,              ! grid value x coord           (local)  PLOTS.2137
     *                 gry,              ! grid value y coord           (local)  PLOTS.2138
     *                 llx,              ! real latitude                (local)  PLOTS.2139
     *                 lly,              ! real longitude               (local)  PLOTS.2140
     *                 flsv,             ! save variable                (local)  PLOTS.2141
     *                 frsv,             ! save variable                (local)  PLOTS.2142
     *                 fbsv,             ! save variable                (local)  PLOTS.2143
     *                 ftsv,             ! save variable                (local)  PLOTS.2144
     *                 ulsv,             ! save variable                (local)  PLOTS.2145
     *                 ursv,             ! save variable                (local)  PLOTS.2146
     *                 ubsv,             ! save variable                (local)  PLOTS.2147
     *                 utsv,             ! save variable                (local)  PLOTS.2148
     *                 ang,              ! angle at which to draw tick  (local)  PLOTS.2149
     *                 dcgtb,            ! dst from grd center to edge  (local)  PLOTS.2150
     *                 dcltp,            ! dst from center to pole      (local)  PLOTS.2151
     *                 tang              ! test angle                   (local)  PLOTS.2152
                                                                                 PLOTS.2153
C  Common blocks                                                                 PLOTS.2154
                                                                                 PLOTS.2155
      common /mlbdet/  wlabs,            ! which labels do we want               PLOTS.2156
     *                 lbsiz,            ! alternate label size                  PLOTS.2157
     *                 lbqul             ! label quality                         PLOTS.2158
      common /xyllon/  dds,              ! grid distance in kilometers           PLOTS.2159
     *                 xlat,             ! center latitude                       PLOTS.2160
     *                 xlon,             ! center longitude                      PLOTS.2161
     *                 imax,             ! maximum vertical grid point           PLOTS.2162
     *                 jmax              ! maximum horizontal grid point         PLOTS.2163
      common /labcol/  lacolr            ! label color                           PLOTS.2164
      common /labpos/  lfpos,            ! positions of labels along the left    PLOTS.2165
     *                 rgpos,            ! positions of labels along the right   PLOTS.2166
     *                 btpos,            ! positions of labels along the bottom  PLOTS.2167
     *                 tppos             ! positions of labels along the top     PLOTS.2168
      common /labnum/  lfnum,            ! # of positions in LFPOS               PLOTS.2169
     *                 rgnum,            ! # of positions in RGPOS               PLOTS.2170
     *                 btnum,            ! # of positions in BTPOS               PLOTS.2171
     *                 tpnum             ! # of positions in TPPOS               PLOTS.2172
      common /mapedge/ left,             ! fractional coord. of left edge        PLOTS.2173
     *                 right,            ! fractional coord. of right edge       PLOTS.2174
     *                 bottom,           ! fractional coord. of bottom edge      PLOTS.2175
     *                 top               ! fractional coord. of top edge         PLOTS.2176
      common /llldet/  llplc,            ! lat/lon line flag                     PLOTS.2177
     *                 grdsh,            ! lat/lon grid dash pattern             PLOTS.2178
     *                 llint             ! not used                              PLOTS.2179
      common /lllcol/  llcolr            ! color of perimeter ticks              PLOTS.2180
                                                                                 PLOTS.2181
C****************************  subroutine begin  *****************************C  PLOTS.2182
                                                                                 PLOTS.2183
C  EZMAP internal parameters use in this routine are:                            PLOTS.2184
C  GR  - lat/lon GRid interval                                                   PLOTS.2185
                                                                                 PLOTS.2186
C  PLOTCHAR internal parameters use in this routine are:                         PLOTS.2187
C  CD  - Complex or Duplex characters                                            PLOTS.2188
C  QU  - QUality of charcters                                                    PLOTS.2189
                                                                                 PLOTS.2190
C  Don't draw anything unless MAPDRV labels were requested or publication        PLOTS.2191
C  style grid was used                                                           PLOTS.2192
                                                                                 PLOTS.2193
      if (((wlabs .eq. 1) .or. (wlabs .eq. 2)) .or.                              PLOTS.2194
     *    ((grdsh .eq. 0) .and. (llplc .ne. 0))) then                            PLOTS.2195
                                                                                 PLOTS.2196
C  Check right away for an error in locating them                                PLOTS.2197
                                                                                 PLOTS.2198
        if (lfnum .eq. 361) then                                                 PLOTS.2199
          ermes(1:30)  = 'Too Many MAPDRV Style Labels -'                        PLOTS.2200
          ermes(31:60) = ' 360 Per Side Maximum         '                        PLOTS.2201
          call errhan ('MAPDRV',0,ermes,errsev)                                  PLOTS.2202
          lfnum = 360                                                            PLOTS.2203
        end if                                                                   PLOTS.2204
                                                                                 PLOTS.2205
        if (rgnum .eq. 361) then                                                 PLOTS.2206
          ermes(1:30)  = 'Too Many MAPDRV Style Labels -'                        PLOTS.2207
          ermes(31:60) = ' 360 Per Side Maximum         '                        PLOTS.2208
          call errhan ('MAPDRV',0,ermes,errsev)                                  PLOTS.2209
          rgnum = 360                                                            PLOTS.2210
        end if                                                                   PLOTS.2211
                                                                                 PLOTS.2212
        if (btnum .eq. 361) then                                                 PLOTS.2213
          ermes(1:30)  = 'Too Many MAPDRV Style Labels -'                        PLOTS.2214
          ermes(31:60) = ' 360 Per Side Maximum         '                        PLOTS.2215
          call errhan ('MAPDRV',0,ermes,errsev)                                  PLOTS.2216
          btnum = 360                                                            PLOTS.2217
        end if                                                                   PLOTS.2218
                                                                                 PLOTS.2219
        if (tpnum .eq. 361) then                                                 PLOTS.2220
          ermes(1:30)  = 'Too Many MAPDRV Style Labels -'                        PLOTS.2221
          ermes(31:60) = ' 360 Per Side Maximum         '                        PLOTS.2222
          call errhan ('MAPDRV',0,ermes,errsev)                                  PLOTS.2223
          tpnum = 360                                                            PLOTS.2224
        end if                                                                   PLOTS.2225
                                                                                 PLOTS.2226
C  Set up routine XYTOLL for use                                                 PLOTS.2227
                                                                                 PLOTS.2228
        dds  = grds                                                              PLOTS.2229
        xlat = cenlat                                                            PLOTS.2230
        xlon = cenlon                                                            PLOTS.2231
        imax = iend                                                              PLOTS.2232
        jmax = jend                                                              PLOTS.2233
                                                                                 PLOTS.2234
C  Determine cone factor                                                         PLOTS.2235
                                                                                 PLOTS.2236
        if (project(1:2) .eq. 'LC') then                                         PLOTS.2237
          xn = 0.716                                                             PLOTS.2238
        else if (project .eq. 'ST') then                                         PLOTS.2239
          xn = 1.0                                                               PLOTS.2240
        else                                                                     PLOTS.2241
          xn = 0.0                                                               PLOTS.2242
        end if                                                                   PLOTS.2243
                                                                                 PLOTS.2244
C  Set quality as the user requested in PLOTCHAR                                 PLOTS.2245
                                                                                 PLOTS.2246
        call pcseti ('CD',lbqul(1))                                              PLOTS.2247
        call pcseti ('QU',lbqul(2))                                              PLOTS.2248
                                                                                 PLOTS.2249
C  Change user vieport to look like the grid so XYTOLL will be useful            PLOTS.2250
                                                                                 PLOTS.2251
        call getset (flsv,frsv,fbsv,ftsv,ulsv,ursv,ubsv,utsv,llsv)               PLOTS.2252
        j = 0                                                                    PLOTS.2253
60      j = j + 1                                                                PLOTS.2254
        call set    (left,right,bottom,top,                                      PLOTS.2255
     *               xpa,xpb,ypa,ypb,1)                                          PLOTS.2256
        latcnt = 0                                                               PLOTS.2257
        loncnt = 0                                                               PLOTS.2258
                                                                                 PLOTS.2259
C  Retrieve the GRid interval                                                    PLOTS.2260
                                                                                 PLOTS.2261
        call mapgti ('GR',nmgr)                                                  PLOTS.2262
                                                                                 PLOTS.2263
C  First we will do the left, then the right, then the top,                      PLOTS.2264
C  and last the bottom                                                           PLOTS.2265
                                                                                 PLOTS.2266
        if (j .eq. 1) then                                                       PLOTS.2267
          loop = lfnum                                                           PLOTS.2268
        else if (j .eq. 2) then                                                  PLOTS.2269
          loop = rgnum                                                           PLOTS.2270
        else if (j .eq. 3) then                                                  PLOTS.2271
          loop = tpnum                                                           PLOTS.2272
        else                                                                     PLOTS.2273
          loop = btnum                                                           PLOTS.2274
        end if                                                                   PLOTS.2275
                                                                                 PLOTS.2276
C  First convert the positions to lat/lon values                                 PLOTS.2277
                                                                                 PLOTS.2278
        do 10 i = 1,loop                                                         PLOTS.2279
                                                                                 PLOTS.2280
C  CFUX and CFUY are SPPS functions that convert from fractional coordinates     PLOTS.2281
C  to user coordinates.  This gets the grid values of each point                 PLOTS.2282
                                                                                 PLOTS.2283
          if (j .eq. 1) then                                                     PLOTS.2284
            grx = cfux(lfpos(i,1))                                               PLOTS.2285
            gry = cfuy(lfpos(i,2))                                               PLOTS.2286
          else if (j .eq. 2) then                                                PLOTS.2287
            grx = cfux(rgpos(i,1))                                               PLOTS.2288
            gry = cfuy(rgpos(i,2))                                               PLOTS.2289
          else if (j .eq. 3) then                                                PLOTS.2290
            grx = cfux(tppos(i,1))                                               PLOTS.2291
            gry = cfuy(tppos(i,2))                                               PLOTS.2292
          else                                                                   PLOTS.2293
            grx = cfux(btpos(i,1))                                               PLOTS.2294
            gry = cfuy(btpos(i,2))                                               PLOTS.2295
          end if                                                                 PLOTS.2296
                                                                                 PLOTS.2297
C  Convert the grid values to lat/lon values                                     PLOTS.2298
                                                                                 PLOTS.2299
          call xytoll (grx,gry,llx,lly,project)                                  PLOTS.2300
          llval(i,1) = nint(llx)                                                 PLOTS.2301
          llval(i,2) = nint(lly)                                                 PLOTS.2302
                                                                                 PLOTS.2303
C  Check to see which (the lat or lon) value cause the line to be drawn          PLOTS.2304
                                                                                 PLOTS.2305
          tst1 = mod (llval(i,1),nmgr)                                           PLOTS.2306
          tst2 = mod (llval(i,2),nmgr)                                           PLOTS.2307
          if (tst1 .eq. 0) then                                                  PLOTS.2308
            if ((i .ne. 1) .and. (llval(i,1) .ne. llval(1,1))) then              PLOTS.2309
              if ((llval(i,1) .ne. llval(i-1,1)) .or.                            PLOTS.2310
     *            (llval(i,2) .ne. llval(i-1,2)))                                PLOTS.2311
     *          latcnt = latcnt + 1                                              PLOTS.2312
            else if (i .eq. 1) then                                              PLOTS.2313
              latcnt = latcnt + 1                                                PLOTS.2314
            end if                                                               PLOTS.2315
          end if                                                                 PLOTS.2316
          if (tst2 .eq. 0) then                                                  PLOTS.2317
            if ((i .ne. 1) .and. (llval(i,2) .ne. llval(1,2))) then              PLOTS.2318
              if (abs(llval(i,2)) .ne. 180) then                                 PLOTS.2319
                if ((llval(i,1) .ne. llval(i-1,1)) .or.                          PLOTS.2320
     *              (llval(i,2) .ne. llval(i-1,2)))                              PLOTS.2321
     *            loncnt = loncnt + 1                                            PLOTS.2322
              else                                                               PLOTS.2323
                if ((llval(i,1) .ne. llval(i-1,1)) .or.                          PLOTS.2324
     *              ((llval(i,2) .ne. llval(i-1,2)) .and.                        PLOTS.2325
     *               (llval(i,2) .ne. -llval(i-1,2))))                           PLOTS.2326
     *            loncnt = loncnt + 1                                            PLOTS.2327
              end if                                                             PLOTS.2328
            else if (i .eq. 1) then                                              PLOTS.2329
              loncnt = loncnt + 1                                                PLOTS.2330
            end if                                                               PLOTS.2331
          end if                                                                 PLOTS.2332
10      continue                                                                 PLOTS.2333
                                                                                 PLOTS.2334
C  Label the edge with the one which cause the most lines to be drawn            PLOTS.2335
                                                                                 PLOTS.2336
        if ((j .eq. 1) .or. (j .eq. 2)) then                                     PLOTS.2337
          if (latcnt .ge. loncnt) then                                           PLOTS.2338
            xy = 1                                                               PLOTS.2339
          else                                                                   PLOTS.2340
            xy = 2                                                               PLOTS.2341
          end if                                                                 PLOTS.2342
        else                                                                     PLOTS.2343
          if (latcnt .gt. loncnt) then                                           PLOTS.2344
            xy = 1                                                               PLOTS.2345
          else                                                                   PLOTS.2346
            xy = 2                                                               PLOTS.2347
          end if                                                                 PLOTS.2348
        end if                                                                   PLOTS.2349
                                                                                 PLOTS.2350
C  Make a pass through LLVAL checking for duplicate and redundant labels         PLOTS.2351
                                                                                 PLOTS.2352
        do 80 k = 1,loop                                                         PLOTS.2353
          do 70 i = 1,loop                                                       PLOTS.2354
            if (xy .eq. 1) then                                                  PLOTS.2355
              yz = 2                                                             PLOTS.2356
            else                                                                 PLOTS.2357
              yz = 1                                                             PLOTS.2358
            end if                                                               PLOTS.2359
            if ((llval(k,xy) .eq. llval(i,xy)) .and.                             PLOTS.2360
     *          (llval(k,yz) .le. (llval(i,yz) + ito)) .and.                     PLOTS.2361
     *          (llval(k,yz) .ge. (llval(i,yz) - ito)) .and.                     PLOTS.2362
     *          (k .ne. i) .and. (llval(k,xy) .ne. 400)) then                    PLOTS.2363
              llval(i,1) = 400                                                   PLOTS.2364
              llval(i,2) = 400                                                   PLOTS.2365
            end if                                                               PLOTS.2366
70        continue                                                               PLOTS.2367
80      continue                                                                 PLOTS.2368
                                                                                 PLOTS.2369
C  Set up the viewport to draw                                                   PLOTS.2370
                                                                                 PLOTS.2371
        call set (0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,1)                             PLOTS.2372
                                                                                 PLOTS.2373
C  Make the string to be the label                                               PLOTS.2374
                                                                                 PLOTS.2375
        do 20 i = 1,loop                                                         PLOTS.2376
          if (llval(i,xy) .eq. 0) then                    ! Greenwich Meridian   PLOTS.2377
            if (xy .eq. 1) then                           ! or Equator           PLOTS.2378
              str(1:5) = 'EQ   '                                                 PLOTS.2379
            else                                                                 PLOTS.2380
              str(1:5) = 'GM   '                                                 PLOTS.2381
            end if                                                               PLOTS.2382
            slen     = 2                                                         PLOTS.2383
          else if ((llval(i,xy) .eq. -180) .or.           ! International        PLOTS.2384
     *             (llval(i,xy) .eq. 180)) then           ! Date Line            PLOTS.2385
            str(1:5) = 'ID   '                                                   PLOTS.2386
            slen     = 2                                                         PLOTS.2387
          else if ((mod(llval(i,xy),nmgr) .eq. 0) .and.                          PLOTS.2388
     *             (llval(i,xy) .ne. 400)) then                                  PLOTS.2389
            if (llval(i,xy) .ge. 100) then                ! [100 E,180)          PLOTS.2390
              write (str(1:3),30) llval(i,xy)                                    PLOTS.2391
              if (xy .eq. 1) then                                                PLOTS.2392
                str(4:5) = ' N'                                                  PLOTS.2393
              else                                                               PLOTS.2394
                str(4:5) = ' E'                                                  PLOTS.2395
              end if                                                             PLOTS.2396
              slen     = 5                                                       PLOTS.2397
            else if (llval(i,xy) .ge. 10) then            ! [10 E,100 E)         PLOTS.2398
              write (str(1:2),40) llval(i,xy)             ! [10 N,90 N]          PLOTS.2399
              if (xy .eq. 1) then                                                PLOTS.2400
                str(3:5) = ' N '                                                 PLOTS.2401
              else                                                               PLOTS.2402
                str(3:5) = ' E '                                                 PLOTS.2403
              end if                                                             PLOTS.2404
              slen     = 4                                                       PLOTS.2405
            else if (llval(i,xy) .gt. 0) then             ! (0,10 E)             PLOTS.2406
              write (str(1:1),50) llval(i,xy)             ! (0,10 N)             PLOTS.2407
              if (xy .eq. 1) then                                                PLOTS.2408
                str(2:5) = ' N  '                                                PLOTS.2409
              else                                                               PLOTS.2410
                str(2:5) = ' E  '                                                PLOTS.2411
              end if                                                             PLOTS.2412
              slen     = 3                                                       PLOTS.2413
            else if (llval(i,xy) .gt. -10) then           ! (10 W,0)             PLOTS.2414
              write (str(1:1),50) -1 * llval(i,xy)        ! (10 S,0)             PLOTS.2415
              if (xy .eq. 1) then                                                PLOTS.2416
                str(2:5) = ' S  '                                                PLOTS.2417
              else                                                               PLOTS.2418
                str(2:5) = ' W  '                                                PLOTS.2419
              end if                                                             PLOTS.2420
              slen     = 3                                                       PLOTS.2421
            else if (llval(i,xy) .gt. -100) then          ! (100 W,10 W]         PLOTS.2422
              write (str(1:2),40) -1 * llval(i,xy)        ! [90 S,10 S]          PLOTS.2423
              if (xy .eq. 1) then                                                PLOTS.2424
                str(3:5) = ' S '                                                 PLOTS.2425
              else                                                               PLOTS.2426
                str(3:5) = ' W '                                                 PLOTS.2427
              end if                                                             PLOTS.2428
              slen     = 4                                                       PLOTS.2429
            else                                          ! (180,100W]           PLOTS.2430
              write (str(1:3),30) -1 * llval(i,xy)                               PLOTS.2431
              if (xy .eq. 1) then                                                PLOTS.2432
                str(4:5) = ' S'                                                  PLOTS.2433
              else                                                               PLOTS.2434
                str(4:5) = ' W'                                                  PLOTS.2435
              end if                                                             PLOTS.2436
              slen     = 5                                                       PLOTS.2437
            end if                                                               PLOTS.2438
          end if                                                                 PLOTS.2439
                                                                                 PLOTS.2440
C  Draw the label in                                                             PLOTS.2441
                                                                                 PLOTS.2442
          if ((mod(llval(i,xy),nmgr) .eq. 0) .and.                               PLOTS.2443
     *        (llval(i,xy) .ne. 400)) then                                       PLOTS.2444
                                                                                 PLOTS.2445
C  Set up correct color for MAPDRV labels                                        PLOTS.2446
C  To understand what the quality of the letters has to do with the color        PLOTS.2447
C  read on page 2-14 in the NCAR Graphics Guide to New Utilities Version 3.00    PLOTS.2448
C  under the heading of PLOTCHAR                                                 PLOTS.2449
                                                                                 PLOTS.2450
            if ((lbqul(2) .eq. 0) .or. (lbqul(2) .eq. 1)) then                   PLOTS.2451
              call gsplci (lacolr)                                               PLOTS.2452
            else                                                                 PLOTS.2453
              call gstxci (lacolr)                                               PLOTS.2454
            end if                                                               PLOTS.2455
                                                                                 PLOTS.2456
C  Use PLOTCHAR to put the label up                                              PLOTS.2457
                                                                                 PLOTS.2458
            if (j .eq. 1) then                                                   PLOTS.2459
              call plchhq (lfpos(i,1)-lbsiz/85.0,lfpos(i,2),                     PLOTS.2460
     *                     str(1:slen),-lbsiz,0.0,1.0)                           PLOTS.2461
            else if (j .eq. 2) then                                              PLOTS.2462
              call plchhq (rgpos(i,1)+lbsiz/85.0,rgpos(i,2),                     PLOTS.2463
     *                     str(1:slen),-lbsiz,0.0,-1.0)                          PLOTS.2464
            else if (j .eq. 3) then                                              PLOTS.2465
              call plchhq (tppos(i,1),tppos(i,2)+lbsiz/55.0,                     PLOTS.2466
     *                     str(1:slen),-lbsiz,0.0,0.0)                           PLOTS.2467
            else                                                                 PLOTS.2468
              call plchhq (btpos(i,1),btpos(i,2)-lbsiz/45.0,                     PLOTS.2469
     *                     str(1:slen),-lbsiz,0.0,0.0)                           PLOTS.2470
            end if                                                               PLOTS.2471
                                                                                 PLOTS.2472
C  If publication style lat/lon grid was drawn, put in the tick marks            PLOTS.2473
                                                                                 PLOTS.2474
            if ((grdsh .eq. 0) .and. (llplc .ne. 0)) then                        PLOTS.2475
                                                                                 PLOTS.2476
C  Set up correct color for publication style perimeter ticks                    PLOTS.2477
                                                                                 PLOTS.2478
              if ((lbqul(2) .eq. 0) .or. (lbqul(2) .eq. 1)) then                 PLOTS.2479
                call gsplci (llcolr)                                             PLOTS.2480
              else                                                               PLOTS.2481
                call gstxci (llcolr)                                             PLOTS.2482
              end if                                                             PLOTS.2483
                                                                                 PLOTS.2484
C  Calculate the angle at which to draw the tick                                 PLOTS.2485
                                                                                 PLOTS.2486
              ang = (float(llval(i,2)) - cenlon) * xn                            PLOTS.2487
              if ((j .eq. 1) .and. (xy .eq. 2))                                  PLOTS.2488
     *          ang = ang + 90                                                   PLOTS.2489
              if ((j .eq. 2) .and. (xy .eq. 2))                                  PLOTS.2490
     *          ang = ang - 90                                                   PLOTS.2491
              if ((j .eq. 3) .and. (xy .eq. 1) .and.                             PLOTS.2492
     *            (project(1:2) .eq. 'LC') .and.                                 PLOTS.2493
     *            (llval(i,2) .lt. 0)) ang = ang + 90                            PLOTS.2494
              if ((j .eq. 3) .and. (xy .eq. 1) .and.                             PLOTS.2495
     *            (project(1:2) .eq. 'LC') .and.                                 PLOTS.2496
     *            (llval(i,2) .gt. 0)) ang = ang - 90                            PLOTS.2497
              if ((j .eq. 3) .and. (xy .eq. 2) .and.                             PLOTS.2498
     *            (project(1:2) .eq. 'ST')) then                                 PLOTS.2499
                if (cenlat .ge. 0.0) then                                        PLOTS.2500
                  tang = 90.0 - cenlat                                           PLOTS.2501
                else                                                             PLOTS.2502
                  tang = 90.0 + cenlat                                           PLOTS.2503
                end if                                                           PLOTS.2504
                dcltp = 2 * pi * re * (tang/360.0)                               PLOTS.2505
                dcgtb = grds * iend * 0.5                                        PLOTS.2506
                if (dcgtb .gt. dcltp) ang = ang + 180                            PLOTS.2507
              end if                                                             PLOTS.2508
              if ((j .eq. 3) .and. (xy .eq. 1) .and.                             PLOTS.2509
     *            (project(1:2) .eq. 'ST')) then                                 PLOTS.2510
                if (tppos(i,1) .gt. 0.5) then                                    PLOTS.2511
                  ang = ang - 90                                                 PLOTS.2512
                else if (tppos(i,1) .lt. 0.5) then                               PLOTS.2513
                  ang = ang + 90                                                 PLOTS.2514
                end if                                                           PLOTS.2515
              end if                                                             PLOTS.2516
                                                                                 PLOTS.2517
C  Draw the tick as if it were a character.  Using the PLOTCHAR utility          PLOTS.2518
C  allows easy specification of the angle at which to draw the tick.             PLOTS.2519
C  For ticks extending from the right hand side, use a minus sign centered       PLOTS.2520
C  on its right.  ...Extending from the left, use a minus sign centered on       PLOTS.2521
C  its left.  ...Extending from the top, write down the screen instead of        PLOTS.2522
C  across it and use a vertical bar centered on its top.  ...Extending from      PLOTS.2523
C  the bottom, write down the screen instead of across it and use a vertical     PLOTS.2524
C  bar centered on its bottom.                                                   PLOTS.2525
                                                                                 PLOTS.2526
              if (j .eq. 1) then                                                 PLOTS.2527
                call plchhq (lfpos(i,1),lfpos(i,2),                              PLOTS.2528
     *                       '-',-lbsiz,ang,-1.0)                                PLOTS.2529
              else if (j .eq. 2) then                                            PLOTS.2530
                call plchhq (rgpos(i,1),rgpos(i,2),                              PLOTS.2531
     *                       '-',-lbsiz,ang,1.0)                                 PLOTS.2532
              else if (j .eq. 3) then                                            PLOTS.2533
                call plchhq (tppos(i,1),tppos(i,2),                              PLOTS.2534
     *                       ':D:|',-0.667*lbsiz,ang,-1.0)                       PLOTS.2535
              else                                                               PLOTS.2536
                call plchhq (btpos(i,1),btpos(i,2),                              PLOTS.2537
     *                       ':D:|',-0.667*lbsiz,ang,1.0)                        PLOTS.2538
              end if                                                             PLOTS.2539
            end if                                                               PLOTS.2540
          end if                                                                 PLOTS.2541
20      continue                                                                 PLOTS.2542
                                                                                 PLOTS.2543
C  If there are more sides to do, do them                                        PLOTS.2544
                                                                                 PLOTS.2545
        if (j .ne. 4) goto 60                                                    PLOTS.2546
                                                                                 PLOTS.2547
C  Restore any disrupted set call                                                PLOTS.2548
                                                                                 PLOTS.2549
        call set (flsv,frsv,fbsv,ftsv,ulsv,ursv,ubsv,utsv,llsv)                  PLOTS.2550
      end if                                                                     PLOTS.2551
                                                                                 PLOTS.2552
C*****************************  subroutine end  ******************************C  PLOTS.2553
                                                                                 PLOTS.2554
C  Format statements begin ...                                                   PLOTS.2555
                                                                                 PLOTS.2556
30    format (I3)                                                                PLOTS.2557
40    format (I2)                                                                PLOTS.2558
50    format (I1)                                                                PLOTS.2559
                                                                                 PLOTS.2560
C  Format statements end.                                                        PLOTS.2561
                                                                                 PLOTS.2562
      return                                                                     PLOTS.2563
      end                                                                        PLOTS.2564
      subroutine mpdrol                                                          PLOTS.2565
                                                                                 PLOTS.2566
C*****************************************************************************C  PLOTS.2567
C  mpdrol   - This is a MAPDRV routine                                        C  PLOTS.2568
C  Section  - Draw                                                            C  PLOTS.2569
C  Purpose  - To set the correct outline style and draw the outlines.         C  PLOTS.2570
C                                                                             C  PLOTS.2571
C  On entry - The common block  MOTDET  contains dotted line,  and line width C  PLOTS.2572
C             information.                                                    C  PLOTS.2573
C                                                                             C  PLOTS.2574
C  On exit  - The outlines have been drawn.                                   C  PLOTS.2575
C                                                                             C  PLOTS.2576
C  Assume   - GKS is open.                                                    C  PLOTS.2577
C                                                                             C  PLOTS.2578
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.2579
C             ----------------------------------------------------------------C  PLOTS.2580
C             MAPSTC              EZMAP utility*                              C  PLOTS.2581
C             MAPSTI              EZMAP utility*                              C  PLOTS.2582
C             MAPSTL              EZMAP utility*                              C  PLOTS.2583
C             GETUSV              SPPS*                                       C  PLOTS.2584
C             SETUSV              SPPS*                                       C  PLOTS.2585
C             MAPLOT              EZMAP utility*                              C  PLOTS.2586
C             ----------------------------------------------------------------C  PLOTS.2587
C             * NCAR Graphics routine                                         C  PLOTS.2588
C                                                                             C  PLOTS.2589
C  Author   - Jeremy Asbill        Date - July 7, 1990       for the MM4 club C  PLOTS.2590
C*****************************************************************************C  PLOTS.2591
                                                                                 PLOTS.2592
C  Integer variables                                                             PLOTS.2593
                                                                                 PLOTS.2594
      integer          maplw,            ! for common block MOTDET               PLOTS.2595
     *                 dtdsp             ! for common block MOTDET               PLOTS.2596
      integer          lwsv              ! integer save variable                 PLOTS.2597
                                                                                 PLOTS.2598
C  Logical variables                                                             PLOTS.2599
                                                                                 PLOTS.2600
      logical          dtdmp             ! for common block MOTDET               PLOTS.2601
                                                                                 PLOTS.2602
C  Common blocks                                                                 PLOTS.2603
                                                                                 PLOTS.2604
      common /motdet/  dtdmp,            ! T => draw the map with dots ?         PLOTS.2605
     *                 maplw,            ! line width for map outlines           PLOTS.2606
     *                 dtdsp             ! dash spacing for map outlines         PLOTS.2607
                                                                                 PLOTS.2608
cdave                                                                            PLOTS.2609
      common /hires/   ihires            ! ihires=1 do a hi res, else NCARG      PLOTS.2610
                                                                                 PLOTS.2611
C****************************  subroutine begin  *****************************C  PLOTS.2612
                                                                                 PLOTS.2613
C  EZMAP internal parameters use in this routine are:                            PLOTS.2614
C  DO  - DOtted outline flag                                                     PLOTS.2615
C  DD  - Distance between Dots                                                   PLOTS.2616
                                                                                 PLOTS.2617
C  SPPS internal parameters used in this routine are                             PLOTS.2618
C  LW  - Line Width                                                              PLOTS.2619
                                                                                 PLOTS.2620
C  Set up map outline form (dotted or solid)                                     PLOTS.2621
                                                                                 PLOTS.2622
      call mapstl ('DO',dtdmp)                                                   PLOTS.2623
                                                                                 PLOTS.2624
C  Set up the proper line width for or dot spacing                               PLOTS.2625
                                                                                 PLOTS.2626
      if (dtdmp) then                                                            PLOTS.2627
        call mapsti ('DD',dtdsp)                                                 PLOTS.2628
      else                                                                       PLOTS.2629
        call getusv ('LW',lwsv)                                                  PLOTS.2630
        call setusv ('LW',maplw)                                                 PLOTS.2631
      end if                                                                     PLOTS.2632
                                                                                 PLOTS.2633
C  Draw the outlines                                                             PLOTS.2634
                                                                                 PLOTS.2635
cdave                                                                            PLOTS.2636
      if(ihires.eq.1) then                                                       PLOTS.2637
         call hiresmap(3)                                                        PLOTS.2638
      else                                                                       PLOTS.2639
                                                                                 05DEC01.121
#if defined(NCARG42)                                                             05DEC01.122
        call mplndr ( 'Earth..2' , 5 )                                           05DEC01.123
#elif defined(NCARG41)                                                           05DEC01.124
        call mplndr ( 'Earth..1' , 4 )                                           05DEC01.125
#else                                                                            05DEC01.126
        call maplot                                                              05DEC01.127
#endif                                                                           05DEC01.128
      endif                                                                      PLOTS.2641
                                                                                 PLOTS.2642
C  Reset the line width if need be                                               PLOTS.2643
                                                                                 PLOTS.2644
      if ((.not. dtdmp) .and. (lwsv .ne. maplw)) then                            PLOTS.2645
        call setusv ('LW',lwsv)                                                  PLOTS.2646
      end if                                                                     PLOTS.2647
                                                                                 PLOTS.2648
C*****************************  subroutine end  ******************************C  PLOTS.2649
                                                                                 PLOTS.2650
      return                                                                     PLOTS.2651
      end                                                                        PLOTS.2652
      subroutine mpdrtl (titline,titlen,nomap)                                   PLOTS.2653
                                                                                 PLOTS.2654
C*****************************************************************************C  PLOTS.2655
C  mpdrtl   - This is a MAPDRV routine                                        C  PLOTS.2656
C  Section  - Labels                                                          C  PLOTS.2657
C  Purpose  - To put the title of the map on the picture.                     C  PLOTS.2658
C                                                                             C  PLOTS.2659
C  On entry - TITLINE  contains the title string.   TITLEN  tells us how long C  PLOTS.2660
C             the string is.   TLSIZ  in the common block MTLDET tells us how C  PLOTS.2661
C             big to make the characters.  TLCOLR  in the common block TITCOL C  PLOTS.2662
C             contains the color index for the title.  If NOMAP is true,  the C  PLOTS.2663
C             routine delivers an error message to the plotting screen.       C  PLOTS.2664
C                                                                             C  PLOTS.2665
C  On exit  - The title has been drawn into the GFLASH buffer.                C  PLOTS.2666
C                                                                             C  PLOTS.2667
C  Assume   - GKS is open.                                                    C  PLOTS.2668
C                                                                             C  PLOTS.2669
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.2670
C             ----------------------------------------------------------------C  PLOTS.2671
C             GETSET              SPPS*                                       C  PLOTS.2672
C             SET                 SPPS*                                       C  PLOTS.2673
C             PCSETI              PLOTCHAR utility*                           C  PLOTS.2674
C             PLCHHQ              PLOTCHAR utility*                           C  PLOTS.2675
C             GSTXCI              GKS                                         C  PLOTS.2676
C             GSPLCI              GKS                                         C  PLOTS.2677
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.2678
C             ----------------------------------------------------------------C  PLOTS.2679
C             * NCAR Graphics routine                                         C  PLOTS.2680
C                                                                             C  PLOTS.2681
C  Author   - Jeremy Asbill        Date - July 8, 1990       for the MM4 club C  PLOTS.2682
C*****************************************************************************C  PLOTS.2683
                                                                                 PLOTS.2684
C  Character variables                                                           PLOTS.2685
                                                                                 PLOTS.2686
      character*80     titline           ! string containing the title     (in)  PLOTS.2687
                                                                                 PLOTS.2688
C  Integer variables                                                             PLOTS.2689
                                                                                 PLOTS.2690
      integer          titlen            ! # of characters in title string (in)  PLOTS.2691
      integer          tlqul(2)          ! for common block MTLDET               PLOTS.2692
      integer          tlcolr            ! for common block TITCOL               PLOTS.2693
      integer          llsv              ! viewport save variable       (local)  PLOTS.2694
                                                                                 PLOTS.2695
C  Logical variables                                                             PLOTS.2696
                                                                                 PLOTS.2697
      logical          nomap             ! we didn't draw a map ?          (in)  PLOTS.2698
                                                                                 PLOTS.2699
C  Real variables                                                                PLOTS.2700
                                                                                 PLOTS.2701
      real             tlsiz             ! for common block MTLDET               PLOTS.2702
      real             flsv,             ! viewport save variable       (local)  PLOTS.2703
     *                 frsv,             ! viewport save variable       (local)  PLOTS.2704
     *                 fbsv,             ! viewport save variable       (local)  PLOTS.2705
     *                 ftsv,             ! viewport save variable       (local)  PLOTS.2706
     *                 ulsv,             ! viewport save variable       (local)  PLOTS.2707
     *                 ursv,             ! viewport save variable       (local)  PLOTS.2708
     *                 ubsv,             ! viewport save variable       (local)  PLOTS.2709
     *                 utsv              ! viewport save variable       (local)  PLOTS.2710
                                                                                 PLOTS.2711
C  Common blocks                                                                 PLOTS.2712
                                                                                 PLOTS.2713
      common /mtldet/  tlsiz,            ! alternate title size                  PLOTS.2714
     *                 tlqul             ! title quality                         PLOTS.2715
      common /titcol/  tlcolr            ! title color                           PLOTS.2716
                                                                                 PLOTS.2717
C****************************  subroutine begin  *****************************C  PLOTS.2718
                                                                                 PLOTS.2719
C  PLOTCHAR internal parameters used in this routine are:                        PLOTS.2720
C  CD  - Complex Duplex flag                                                     PLOTS.2721
C  QU  - QUality forcing flag                                                    PLOTS.2722
                                                                                 PLOTS.2723
C  Make certian there is supposed to be a title plotted                          PLOTS.2724
                                                                                 PLOTS.2725
      if ((nint(tlsiz) .ne. 0) .or. (nomap)) then                                PLOTS.2726
                                                                                 PLOTS.2727
C  Get and save the current viewport                                             PLOTS.2728
                                                                                 PLOTS.2729
        call getset (flsv,frsv,fbsv,ftsv,ulsv,ursv,ubsv,utsv,llsv)               PLOTS.2730
                                                                                 PLOTS.2731
C  Set up viewport to be normalized                                              PLOTS.2732
                                                                                 PLOTS.2733
        call set (0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,1)                             PLOTS.2734
      end if                                                                     PLOTS.2735
                                                                                 PLOTS.2736
C  Set up the type of characters to use                                          PLOTS.2737
                                                                                 PLOTS.2738
      if ((nint(tlsiz) .ne. 0) .and. (.not. nomap)) then                         PLOTS.2739
        call pcseti ('CD',tlqul(1))                                              PLOTS.2740
                                                                                 PLOTS.2741
C  Force PLCHHQ to use the desired quality                                       PLOTS.2742
                                                                                 PLOTS.2743
        call pcseti ('QU',tlqul(2))                                              PLOTS.2744
                                                                                 PLOTS.2745
C  Set up the color properly                                                     PLOTS.2746
C  To understand how color and quality are related read on page 2-14 in the      PLOTS.2747
C  NCAR Graphics Guide to New utilities Version 3.00 under the heading of        PLOTS.2748
C  PLOTCHAR                                                                      PLOTS.2749
                                                                                 PLOTS.2750
        if ((tlqul(2) .eq. 0) .or. (tlqul(2) .eq. 1)) then                       PLOTS.2751
          call gsplci (tlcolr)                                                   PLOTS.2752
        else                                                                     PLOTS.2753
          call gstxci (tlcolr)                                                   PLOTS.2754
        end if                                                                   PLOTS.2755
      end if                                                                     PLOTS.2756
                                                                                 PLOTS.2757
C  If there was no map drawn put a title in the GFLASH buffer reflecting this    PLOTS.2758
                                                                                 PLOTS.2759
      if (nomap) then                                                            PLOTS.2760
                                                                                 PLOTS.2761
C  Mske the title                                                                PLOTS.2762
                                                                                 PLOTS.2763
        titline(1:43)  = 'No Map Drawn Due To A Non-Correctable Error'           PLOTS.2764
        titlen = 43                                                              PLOTS.2765
        tlsiz = 1.0                                                              PLOTS.2766
      end if                                                                     PLOTS.2767
                                                                                 PLOTS.2768
C  Put on title                                                                  PLOTS.2769
                                                                                 PLOTS.2770
      if ((nint(tlsiz) .ne. 0) .or. (nomap)) then                                PLOTS.2771
        call plchhq (0.5,0.035,titline(1:titlen),-tlsiz,0.0,0.0)                 PLOTS.2772
                                                                                 PLOTS.2773
C  Restore original viewport                                                     PLOTS.2774
                                                                                 PLOTS.2775
        call set (flsv,frsv,fbsv,ftsv,ulsv,ursv,ubsv,utsv,llsv)                  PLOTS.2776
      end if                                                                     PLOTS.2777
                                                                                 PLOTS.2778
C*****************************  subroutine end  ******************************C  PLOTS.2779
                                                                                 PLOTS.2780
      return                                                                     PLOTS.2781
      end                                                                        PLOTS.2782
      subroutine mpdrus                                                          PLOTS.2783
                                                                                 PLOTS.2784
C*****************************************************************************C  PLOTS.2785
C  mpdrus   - This is a MAPDRV routine                                        C  PLOTS.2786
C  Section  - Design                                                          C  PLOTS.2787
C  Purpose  - The default version of this routine does nothing.  It is called C  PLOTS.2788
C             just before any  drawing takes place so the user can reset some C  PLOTS.2789
C             things this way.                                                C  PLOTS.2790
C                                                                             C  PLOTS.2791
C  On entry - Nothing is input.                                               C  PLOTS.2792
C                                                                             C  PLOTS.2793
C  On exit  - Nothing is done.                                                C  PLOTS.2794
C                                                                             C  PLOTS.2795
C  Assume   - Nothing.                                                        C  PLOTS.2796
C                                                                             C  PLOTS.2797
C  Notes    - This is suppose to be a really well kept secret.                C  PLOTS.2798
C                                                                             C  PLOTS.2799
C  Author   - Jeremy Asbill       Date - July 11, 1990       for the MM4 club C  PLOTS.2800
C*****************************************************************************C  PLOTS.2801
                                                                                 PLOTS.2802
C****************************  subroutine begin  *****************************C  PLOTS.2803
                                                                                 PLOTS.2804
C*****************************  subroutine end  ******************************C  PLOTS.2805
                                                                                 PLOTS.2806
      return                                                                     PLOTS.2807
      end                                                                        PLOTS.2808
      subroutine mrdclt (unum,llplc,wlabs,title,errsev,nomap)                    PLOTS.2809
                                                                                 PLOTS.2810
C*****************************************************************************C  PLOTS.2811
C  mrdclt   - This is a MAPDRV routine                                        C  PLOTS.2812
C  Section  - Tables                                                          C  PLOTS.2813
C  Purpose  - To read in the map color table and assign  the map color  indi- C  PLOTS.2814
C             cators appropriately.                                           C  PLOTS.2815
C                                                                             C  PLOTS.2816
C  On entry - UNUM  is the unit number  where to look for the  table.   LLPLC C  PLOTS.2817
C             is the lat/lon line details flag.   WLABS  is the label details C  PLOTS.2818
C             flag.   TITLE  is true if a title will be drawn and false if no C  PLOTS.2819
C             title will be drawn.   ERRSEV  indicates the severity  of error C  PLOTS.2820
C             that will cause execution to halt.   NOMAP  is  true  if a non- C  PLOTS.2821
C             correctible error has occured  and no map is to be drawn and is C  PLOTS.2822
C             false otherwise.                                                C  PLOTS.2823
C                                                                             C  PLOTS.2824
C  On exit  - The color indication variables in common blocks LLLCOL, LABCOL, C  PLOTS.2825
C             OUTCOL, and PERCOL have been assigned correctly.  NOMAP is true C  PLOTS.2826
C             if a  non-correctible  error has  occured  and no map  is to be C  PLOTS.2827
C             drawn and is false otherwise.                                   C  PLOTS.2828
C                                                                             C  PLOTS.2829
C  Assume   - Nothing.                                                        C  PLOTS.2830
C                                                                             C  PLOTS.2831
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.2832
C             ----------------------------------------------------------------C  PLOTS.2833
C             TBLLOK              MAPDRV/CONDRV utility                       C  PLOTS.2834
C             CRDRCI              MAPDRV/CONDRV utility                       C  PLOTS.2835
C             SEARCH              MAPDRV/CONDRV utility                       C  PLOTS.2836
C             NEXT                MAPDRV/CONDRV utility                       C  PLOTS.2837
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.2838
C             ----------------------------------------------------------------C  PLOTS.2839
C             *NCAR Graphics Routine                                          C  PLOTS.2840
C                                                                             C  PLOTS.2841
C  Author   - Jeremy Asbill        Date - May 26, 1990       for the MM4 club C  PLOTS.2842
C*****************************************************************************C  PLOTS.2843
                                                                                 PLOTS.2844
C  Character variables                                                           PLOTS.2845
                                                                                 PLOTS.2846
      character*80     whline            ! line from map color table    (local)  PLOTS.2847
      character*60     p,                ! SEARCH error message string  (local)  PLOTS.2848
     *                 q,                ! NEXT error message string    (local)  PLOTS.2849
     *                 ermes             ! general error message string (local)  PLOTS.2850
      character*2      wouts             ! for common block MOCDET               PLOTS.2851
                                                                                 PLOTS.2852
C  Integer variables                                                             PLOTS.2853
                                                                                 PLOTS.2854
      integer          llplc,            ! where do we want lat/lon lines  (in)  PLOTS.2855
     *                 wlabs,            ! which labels do we want         (in)  PLOTS.2856
     *                 unum,             ! unit number of table file       (in)  PLOTS.2857
     *                 errsev            ! error severity indicator        (in)  PLOTS.2858
      integer          llcolr            ! for common block LLLCOL               PLOTS.2859
      integer          lacolr            ! for common block LABCOL               PLOTS.2860
      integer          tlcolr            ! for common block TITCOL               PLOTS.2861
      integer          cocolr,           ! for common block OUTCOL               PLOTS.2862
     *                 uscolr,           ! for common block OUTCOL               PLOTS.2863
     *                 cncolr            ! for common block OUTCOL               PLOTS.2864
      integer          pecolr            ! for common block PERCOL               PLOTS.2865
      integer          i                 ! loop counter/place keeper    (local)  PLOTS.2866
                                                                                 PLOTS.2867
C  Logical variables                                                             PLOTS.2868
                                                                                 PLOTS.2869
      logical          title,            ! put a title on the map ?        (in)  PLOTS.2870
     *                 nomap             ! don't draw a map ?              (in)  PLOTS.2871
      logical          error,            ! has an error occured ?       (local)  PLOTS.2872
     *                 found,            ! was the table found ?        (local)  PLOTS.2873
     *                 test              ! is this true ?               (local)  PLOTS.2874
                                                                                 PLOTS.2875
C  Common blocks                                                                 PLOTS.2876
                                                                                 PLOTS.2877
      common /lllcol/  llcolr            ! color of lat lon lines                PLOTS.2878
      common /labcol/  lacolr            ! color of labels                       PLOTS.2879
      common /titcol/  tlcolr            ! color of title                        PLOTS.2880
      common /outcol/  cocolr,           ! color of continents                   PLOTS.2881
     *                 uscolr,           ! color of states                       PLOTS.2882
     *                 cncolr            ! color of countries                    PLOTS.2883
      common /percol/  pecolr            ! color of perimeter                    PLOTS.2884
      common /mocdet/  wouts             ! desired outline indicator             PLOTS.2885
                                                                                 PLOTS.2886
C****************************  subroutine begin  *****************************C  PLOTS.2887
                                                                                 PLOTS.2888
C  If no map is to be drawn skip this routine                                    PLOTS.2889
                                                                                 PLOTS.2890
      if (nomap) goto 150                                                        PLOTS.2891
                                                                                 PLOTS.2892
C  Initialize error flag                                                         PLOTS.2893
                                                                                 PLOTS.2894
      error = .false.                                                            PLOTS.2895
                                                                                 PLOTS.2896
C  Look for the table                                                            PLOTS.2897
                                                                                 PLOTS.2898
      call tbllok (unum,'MAP COLORS',errsev,found,whline,'MAPDRV')               PLOTS.2899
                                                                                 PLOTS.2900
C  Parse table only if it was found                                              PLOTS.2901
                                                                                 PLOTS.2902
      if (found) then                                                            PLOTS.2903
                                                                                 PLOTS.2904
C  Initialize the place keeper                                                   PLOTS.2905
                                                                                 PLOTS.2906
        i = 1                                                                    PLOTS.2907
                                                                                 PLOTS.2908
C  Set up the error messages for SEARCH and NEXT errors                          PLOTS.2909
                                                                                 PLOTS.2910
        p(1:23)  = 'Reading Colors Table,  '                                     PLOTS.2911
        p(24:60) = 'Too Few Entries On Line              '                       PLOTS.2912
        q(1:23)  = p(1:23)                                                       PLOTS.2913
        q(24:60) = 'Entry Is Bizarre                     '                       PLOTS.2914
                                                                                 PLOTS.2915
C  First in line is the lat/lon line color index, LLCOLR                         PLOTS.2916
                                                                                 PLOTS.2917
        if (llplc .ne. 0) then                                                   PLOTS.2918
          call search (whline,i,error)                                           PLOTS.2919
C         if (error)                                                             PLOTS.2920
C    *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.2921
        end if                                                                   PLOTS.2922
                                                                                 PLOTS.2923
        if (llplc .ne. 0) then                                                   PLOTS.2924
          test = .true.                                                          PLOTS.2925
        else                                                                     PLOTS.2926
          test = .false.                                                         PLOTS.2927
        end if                                                                   PLOTS.2928
        call crdrci (test,error,llcolr,1,whline,i,                               PLOTS.2929
     *               'Lat/Lon Grid Color Index',24,errsev,                       PLOTS.2930
     *               nomap,'MAPDRV')                                             PLOTS.2931
        if (nomap) goto 150                                                      PLOTS.2932
                                                                                 PLOTS.2933
        if ((llplc .ne. 0) .and. (.not. error)) then                             PLOTS.2934
          call next (whline,i,error)                                             PLOTS.2935
C         if (error)                                                             PLOTS.2936
C    *      call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.2937
        end if                                                                   PLOTS.2938
                                                                                 PLOTS.2939
C  Second in line is the labels color index, LACOLR                              PLOTS.2940
                                                                                 PLOTS.2941
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.2942
          call search (whline,i,error)                                           PLOTS.2943
C         if (error)                                                             PLOTS.2944
C    *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.2945
        end if                                                                   PLOTS.2946
                                                                                 PLOTS.2947
        if (wlabs .ne. 0) then                                                   PLOTS.2948
          test = .true.                                                          PLOTS.2949
        else                                                                     PLOTS.2950
          test = .false.                                                         PLOTS.2951
        end if                                                                   PLOTS.2952
        call crdrci (test,error,lacolr,1,whline,i,                               PLOTS.2953
     *               'Label Color Index',17,errsev,                              PLOTS.2954
     *               nomap,'MAPDRV')                                             PLOTS.2955
        if (nomap) goto 150                                                      PLOTS.2956
                                                                                 PLOTS.2957
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.2958
          call next (whline,i,error)                                             PLOTS.2959
C         if (error)                                                             PLOTS.2960
C    *      call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.2961
        end if                                                                   PLOTS.2962
                                                                                 PLOTS.2963
C  Third in line is the title color index, TLCOLR                                PLOTS.2964
                                                                                 PLOTS.2965
        if ((title) .and. (.not. error)) then                                    PLOTS.2966
          call search (whline,i,error)                                           PLOTS.2967
C         if (error)                                                             PLOTS.2968
C    *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.2969
        end if                                                                   PLOTS.2970
                                                                                 PLOTS.2971
        call crdrci (title,error,tlcolr,1,whline,i,                              PLOTS.2972
     *               'Title Color Index ',17,errsev,                             PLOTS.2973
     *               nomap,'MAPDRV')                                             PLOTS.2974
        if (nomap) goto 150                                                      PLOTS.2975
                                                                                 PLOTS.2976
        if ((title) .and. (.not. error)) then                                    PLOTS.2977
          call next (whline,i,error)                                             PLOTS.2978
C         if (error)                                                             PLOTS.2979
C    *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.2980
        end if                                                                   PLOTS.2981
                                                                                 PLOTS.2982
C  Third in line is the U.S. States outline color index, USCOLR                  PLOTS.2983
                                                                                 PLOTS.2984
        if (((wouts(1:2) .eq. 'PS') .or. (wouts(1:2) .eq. 'US')) .and.           PLOTS.2985
     *      (.not. error)) then                                                  PLOTS.2986
          call search (whline,i,error)                                           PLOTS.2987
C         if (error)                                                             PLOTS.2988
C    *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.2989
        end if                                                                   PLOTS.2990
                                                                                 PLOTS.2991
        if ((wouts(1:2) .eq. 'PS') .or. (wouts(1:2) .eq. 'US')) then             PLOTS.2992
          test = .true.                                                          PLOTS.2993
        else                                                                     PLOTS.2994
          test = .false.                                                         PLOTS.2995
        end if                                                                   PLOTS.2996
        call crdrci (test,error,uscolr,1,whline,i,                               PLOTS.2997
     *               'U.S. State Outline Color Index',30,errsev,                 PLOTS.2998
     *               nomap,'MAPDRV')                                             PLOTS.2999
        if (nomap) goto 150                                                      PLOTS.3000
                                                                                 PLOTS.3001
        if (((wouts(1:2) .eq. 'PS') .or. (wouts(1:2) .eq. 'US')) .and.           PLOTS.3002
     *      (.not. error)) then                                                  PLOTS.3003
          call next (whline,i,error)                                             PLOTS.3004
C         if (error)                                                             PLOTS.3005
C    *      call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3006
        end if                                                                   PLOTS.3007
                                                                                 PLOTS.3008
C  Fourth in line is the countries outline color index, CNCOLR                   PLOTS.3009
                                                                                 PLOTS.3010
        if ((wouts(1:1) .eq. 'P') .and. (.not. error)) then                      PLOTS.3011
          call search (whline,i,error)                                           PLOTS.3012
C         if (error)                                                             PLOTS.3013
C    *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3014
        end if                                                                   PLOTS.3015
                                                                                 PLOTS.3016
        if (wouts(1:1) .eq. 'P') then                                            PLOTS.3017
          test = .true.                                                          PLOTS.3018
        else                                                                     PLOTS.3019
          test = .false.                                                         PLOTS.3020
        end if                                                                   PLOTS.3021
        call crdrci (test,error,cncolr,1,whline,i,                               PLOTS.3022
     *               'Political Outline Color Index',29,errsev,                  PLOTS.3023
     *               nomap,'MAPDRV')                                             PLOTS.3024
        if (nomap) goto 150                                                      PLOTS.3025
                                                                                 PLOTS.3026
        if ((wouts(1:1) .eq. 'P') .and. (.not. error)) then                      PLOTS.3027
          call next (whline,i,error)                                             PLOTS.3028
C         if (error)                                                             PLOTS.3029
C    *      call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3030
        end if                                                                   PLOTS.3031
                                                                                 PLOTS.3032
C  Fifth in line is Continental outline color index, COCOLR                      PLOTS.3033
                                                                                 PLOTS.3034
        if (((wouts(1:1) .eq. 'P') .or. (wouts(1:2) .eq. 'CO')) .and.            PLOTS.3035
     *      (.not. error)) then                                                  PLOTS.3036
          call search (whline,i,error)                                           PLOTS.3037
C         if (error)                                                             PLOTS.3038
C    *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3039
        end if                                                                   PLOTS.3040
                                                                                 PLOTS.3041
        if  ((wouts(1:1) .eq. 'P') .or. (wouts(1:2) .eq. 'CO')) then             PLOTS.3042
          test = .true.                                                          PLOTS.3043
        else                                                                     PLOTS.3044
          test = .false.                                                         PLOTS.3045
        end if                                                                   PLOTS.3046
        call crdrci (test,error,cocolr,1,whline,i,                               PLOTS.3047
     *               'Continental Outline Color Index',31,errsev,                PLOTS.3048
     *               nomap,'MAPDRV')                                             PLOTS.3049
        if (nomap) goto 150                                                      PLOTS.3050
                                                                                 PLOTS.3051
        if (((wouts(1:1) .eq. 'P') .or. (wouts(1:2) .eq. 'CO')) .and.            PLOTS.3052
     *      (.not. error)) then                                                  PLOTS.3053
          call next (whline,i,error)                                             PLOTS.3054
C         if (error)                                                             PLOTS.3055
C    *      call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3056
        end if                                                                   PLOTS.3057
                                                                                 PLOTS.3058
C  Sixth in line is the perimeter color index, PECOLR                            PLOTS.3059
                                                                                 PLOTS.3060
        if (.not. error) then                                                    PLOTS.3061
          call search (whline,i,error)                                           PLOTS.3062
C         if (error)                                                             PLOTS.3063
C    *      call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3064
        end if                                                                   PLOTS.3065
                                                                                 PLOTS.3066
        call crdrci (.true.,error,pecolr,1,whline,i,                             PLOTS.3067
     *               'Perimeter Color Index',21,errsev,                          PLOTS.3068
     *               nomap,'MAPDRV')                                             PLOTS.3069
        if (nomap) goto 150                                                      PLOTS.3070
                                                                                 PLOTS.3071
        if (.not. error) then                                                    PLOTS.3072
          call next (whline,i,error)                                             PLOTS.3073
C         if (error)                                                             PLOTS.3074
C    *      call errhan ('MAPDRV',0,q,errsev)                                    PLOTS.3075
        end if                                                                   PLOTS.3076
                                                                                 PLOTS.3077
C  Check to see if there were too many entries in the table                      PLOTS.3078
                                                                                 PLOTS.3079
        if (.not. error) then                                                    PLOTS.3080
          call search (whline,i,error)                                           PLOTS.3081
          if (.not. error) then                                                  PLOTS.3082
            ermes(1:24)  = 'Reading Colors Table, To'                            PLOTS.3083
            ermes(25:50) = 'o Many Entries On Line    '                          PLOTS.3084
            ermes(51:60) = '          '                                          PLOTS.3085
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3086
          end if                                                                 PLOTS.3087
        end if                                                                   PLOTS.3088
                                                                                 PLOTS.3089
C  Inform the user that things are at least okay                                 PLOTS.3090
                                                                                 PLOTS.3091
        print *, 'MAPDRV - Map Colors Set Up'                                    PLOTS.3092
      else                                                                       PLOTS.3093
                                                                                 PLOTS.3094
C  The table was not found, assign the defaults                                  PLOTS.3095
                                                                                 PLOTS.3096
        print *, 'MAPDRV - Default Map Colors Used'                              PLOTS.3097
        llcolr = 1                                                               PLOTS.3098
        tlcolr = 1                                                               PLOTS.3099
        lacolr = 1                                                               PLOTS.3100
        uscolr = 1                                                               PLOTS.3101
        cncolr = 1                                                               PLOTS.3102
        cocolr = 1                                                               PLOTS.3103
        pecolr = 1                                                               PLOTS.3104
        goto 150                                                                 PLOTS.3105
      end if                                                                     PLOTS.3106
                                                                                 PLOTS.3107
                                                                                 PLOTS.3108
C*****************************  subroutine end  ******************************C  PLOTS.3109
                                                                                 PLOTS.3110
C  Format statements begin ...                                                   PLOTS.3111
                                                                                 PLOTS.3112
30    format (I2)                                                                PLOTS.3113
40    format (I1)                                                                PLOTS.3114
                                                                                 PLOTS.3115
C  Format statements end.                                                        PLOTS.3116
                                                                                 PLOTS.3117
150   return                                                                     PLOTS.3118
      end                                                                        PLOTS.3119
      subroutine mrddet (unum,buff,ollplc,owlabs,title,perm,errsev,              PLOTS.3120
     *                   nomap)                                                  PLOTS.3121
                                                                                 PLOTS.3122
C*****************************************************************************C  PLOTS.3123
C  mrddet   - This is a MAPDRV routine                                        C  PLOTS.3124
C  Section  - Tables                                                          C  PLOTS.3125
C  Purpose  - This routine reads in  the map detail table and assigns the map C  PLOTS.3126
C             detail indicators appropriately.                                C  PLOTS.3127
C                                                                             C  PLOTS.3128
C  On entry - UNUM  is the unit number of the table file.   ERRSEV  indicates C  PLOTS.3129
C             the error severity at which execution should be halted.   NOMAP C  PLOTS.3130
C             is true if a non-correctable error has occured and no map is to C  PLOTS.3131
C             be made and is false otherwise.                                 C  PLOTS.3132
C                                                                             C  PLOTS.3133
C  On exit  - The information  variables in  common  blocks  MOCDET,  MOTDET, C  PLOTS.3134
C             LLLDET,  MLBDET, and MTLDET have been set up correctly.  OLLPLC C  PLOTS.3135
C             tells the driver where  to put lat/lon  lines, OWLABS tells the C  PLOTS.3136
C             driver what labels to use and TITLE tells the driver whether or C  PLOTS.3137
C             not a title is to be.  PERM is true if the perimeter with  tick C  PLOTS.3138
C             marks is to be drawn  and false if  the perimeter without  tick C  PLOTS.3139
C             marks should be drawn. NOMAP is true if a non-correctable error C  PLOTS.3140
C             has  occured and no map is to be made and is  false  otherwise. C  PLOTS.3141
C             If BUFF is negative special defaults are used.                  C  PLOTS.3142
C                                                                             C  PLOTS.3143
C  Assume   - Nothing.                                                        C  PLOTS.3144
C                                                                             C  PLOTS.3145
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.3146
C             ----------------------------------------------------------------C  PLOTS.3147
C             TBLLOK              MAPDRV/CONDRV utility                       C  PLOTS.3148
C             SEARCH              MAPDRV/CONDRV utility                       C  PLOTS.3149
C             NEXT                MAPDRV/CONDRV utility                       C  PLOTS.3150
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.3151
C             GTREAL              MAPDRV/CONDRV utility                       C  PLOTS.3152
C             ----------------------------------------------------------------C  PLOTS.3153
C                                                                             C  PLOTS.3154
C  Author   - Jeremy Asbill       Date - May 27, 1990        for the MM4 club C  PLOTS.3155
C*****************************************************************************C  PLOTS.3156
                                                                                 PLOTS.3157
C  Parameters                                                                    PLOTS.3158
                                                                                 PLOTS.3159
      parameter        (scale = 20.0)    ! scales LBSIZ and TLSIZ                PLOTS.3160
                                                                                 PLOTS.3161
C  Character variables                                                           PLOTS.3162
                                                                                 PLOTS.3163
      character*2      wouts             ! for common block MOCDET               PLOTS.3164
      character*80     whline            ! line of info. from table     (local)  PLOTS.3165
      character*60     p,                ! error message for SEARCH     (local)  PLOTS.3166
     *                 q,                ! error message for NEXT       (local)  PLOTS.3167
     *                 ermes             ! general error message        (local)  PLOTS.3168
      character*20     gstrng            ! temporary string             (local)  PLOTS.3169
                                                                                 PLOTS.3170
C  Integer variables                                                             PLOTS.3171
                                                                                 PLOTS.3172
      integer          unum,             ! unit number tables are on       (in)  PLOTS.3173
     *                 buff,             ! GFLASH buffer number            (in)  PLOTS.3174
     *                 errsev            ! error severity indicator        (in)  PLOTS.3175
      integer          ollplc,           ! out version of LLPLC           (out)  PLOTS.3176
     *                 owlabs            ! out version of WLABS           (out)  PLOTS.3177
      integer          llplc,            ! for common block LLLDET               PLOTS.3178
     *                 grdsh,            ! for common block LLLDET               PLOTS.3179
     *                 llint             ! for common block LLLDET               PLOTS.3180
      integer          wlabs,            ! for common block MLBDET               PLOTS.3181
     *                 lbqul(2)          ! for common block MLBDET               PLOTS.3182
      integer          tlqul(2)          ! for common block MTLDET               PLOTS.3183
      integer          maplw,            ! for common block MOTDET               PLOTS.3184
     *                 dtdsp             ! for common block MOTDET               PLOTS.3185
      integer          i,                ! loop counter/place keeper    (local)  PLOTS.3186
     *                 temp              ! temporary variable           (local)  PLOTS.3187
                                                                                 PLOTS.3188
C  Logical variables                                                             PLOTS.3189
                                                                                 PLOTS.3190
      logical          nomap             ! don't draw a map ?              (in)  PLOTS.3191
      logical          title,            ! draw a title to the map ?      (out)  PLOTS.3192
     *                 perm              ! draw a perimeter ?             (out)  PLOTS.3193
      logical          dtdmp             ! for common block MOTDET               PLOTS.3194
      logical          error,            ! has an error occurred ?      (local)  PLOTS.3195
     *                 found             ! is the table there ?         (local)  PLOTS.3196
                                                                                 PLOTS.3197
C  Real variables                                                                PLOTS.3198
                                                                                 PLOTS.3199
      real             lbsiz             ! for common block MLBDET               PLOTS.3200
      real             tlsiz             ! for common block MTLDET               PLOTS.3201
      real             dumy              ! dumy variable                (local)  PLOTS.3202
                                                                                 PLOTS.3203
C  Common blocks                                                                 PLOTS.3204
                                                                                 PLOTS.3205
      common /llldet/  llplc,            ! where do we draw lat/lon lines        PLOTS.3206
     *                 grdsh,            ! lat/lon grid dash pattern             PLOTS.3207
     *                 llint             ! lat/lon grid interval in degrees      PLOTS.3208
      common /mlbdet/  wlabs,            ! which labels do we want               PLOTS.3209
     *                 lbsiz,            ! alternate label size                  PLOTS.3210
     *                 lbqul             ! label quality                         PLOTS.3211
      common /mtldet/  tlsiz,            ! alternate title size                  PLOTS.3212
     *                 tlqul             ! title quality                         PLOTS.3213
      common /mocdet/  wouts             ! desired outline indicator             PLOTS.3214
      common /motdet/  dtdmp,            ! T => draw the map with dots ?         PLOTS.3215
     *                 maplw,            ! line width for map outlines           PLOTS.3216
     *                 dtdsp             ! dash spacing for map outlines         PLOTS.3217
                                                                                 PLOTS.3218
C****************************  subroutine begin  *****************************C  PLOTS.3219
                                                                                 PLOTS.3220
C  Check if we need to do this                                                   PLOTS.3221
                                                                                 PLOTS.3222
      if (nomap) goto 250                                                        PLOTS.3223
                                                                                 PLOTS.3224
C  Initialize the error flag                                                     PLOTS.3225
                                                                                 PLOTS.3226
      error = .false.                                                            PLOTS.3227
                                                                                 PLOTS.3228
C  Look for the table                                                            PLOTS.3229
                                                                                 PLOTS.3230
      call tbllok (unum,'MAP DETAIL',errsev,found,whline,'MAPDRV')               PLOTS.3231
                                                                                 PLOTS.3232
C  Don't do reading if it wasn't there                                           PLOTS.3233
                                                                                 PLOTS.3234
      if ((found) .and. (buff .ge. 0)) then                                      PLOTS.3235
                                                                                 PLOTS.3236
C  Initialize the place keeper                                                   PLOTS.3237
                                                                                 PLOTS.3238
        i = 1                                                                    PLOTS.3239
                                                                                 PLOTS.3240
C  Set up the error messages for SEARCH and NEXT errors                          PLOTS.3241
                                                                                 PLOTS.3242
        p(1:23)  = 'Reading Details Table, '                                     PLOTS.3243
        p(24:60) = 'Too Few Entries On Line              '                       PLOTS.3244
        q(1:23)  = p(1:23)                                                       PLOTS.3245
        q(24:60) = 'Entry Is Bizarre                     '                       PLOTS.3246
                                                                                 PLOTS.3247
C  Parse the line starting with lat/lon grid information                         PLOTS.3248
C  First is LLPLC which may be                                                   PLOTS.3249
C    L                => LLPLC = 1  ; or over land only                          PLOTS.3250
C    W                => LLPLC = -1 ; or over water only                         PLOTS.3251
C    N                => LLPLC = 0  ; or no lat/lon lines                        PLOTS.3252
C    D,A,E            => LLPLC = 2  ; or over both land and water                PLOTS.3253
                                                                                 PLOTS.3254
        call search (whline,i,error)                                             PLOTS.3255
        if (error) then                                                          PLOTS.3256
          call errhan ('MAPDRV',1,p,errsev)                                      PLOTS.3257
          llplc      = 2                                                         PLOTS.3258
          grdsh      = 21845                                                     PLOTS.3259
          llint      = 0                                                         PLOTS.3260
          wlabs      = 2                                                         PLOTS.3261
          lbsiz      = 0.4                                                       PLOTS.3262
          lbqul(1)   = 0                                                         PLOTS.3263
          lbqul(2)   = 0                                                         PLOTS.3264
          tlsiz      = 0.6                                                       PLOTS.3265
          tlqul(1)   = 0                                                         PLOTS.3266
          tlqul(2)   = 0                                                         PLOTS.3267
          wouts(1:2) = 'PS'                                                      PLOTS.3268
          dtdmp      = .false.                                                   PLOTS.3269
          maplw      = 1000                                                      PLOTS.3270
          dtdsp      = 0                                                         PLOTS.3271
          perm       = .true.                                                    PLOTS.3272
        end if                                                                   PLOTS.3273
                                                                                 PLOTS.3274
        if (.not. error) then                                                    PLOTS.3275
          if ((whline(i:i) .eq. 'L') .or. (whline(i:i) .eq. 'l')) then           PLOTS.3276
            llplc = 1                                                            PLOTS.3277
          else if ((whline(i:i) .eq. 'W') .or.                                   PLOTS.3278
     *             (whline(i:i) .eq. 'w')) then                                  PLOTS.3279
            llplc = -1                                                           PLOTS.3280
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.3281
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.3282
            llplc = 0                                                            PLOTS.3283
          else if ((whline(i:i) .eq. 'D') .or.                                   PLOTS.3284
     *             (whline(i:i) .eq. 'd') .or.                                   PLOTS.3285
     *             (whline(i:i) .eq. 'E') .or.                                   PLOTS.3286
     *             (whline(i:i) .eq. 'e') .or.                                   PLOTS.3287
     *             (whline(i:i) .eq. 'A') .or.                                   PLOTS.3288
     *             (whline(i:i) .eq. 'a')) then                                  PLOTS.3289
            llplc = 2                                                            PLOTS.3290
          else                                                                   PLOTS.3291
            ermes(1:19)  = 'Lat/Lon Grid Flag, '                                 PLOTS.3292
            ermes(20:20) = whline(i:i)                                           PLOTS.3293
            ermes(21:60) = ', Unknown, Default Used                 '            PLOTS.3294
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3295
            llplc = 2                                                            PLOTS.3296
          end if                                                                 PLOTS.3297
          call next (whline,i,error)                                             PLOTS.3298
          if (error) then                                                        PLOTS.3299
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3300
            if (llplc .ne. 0) then                                               PLOTS.3301
              grdsh    = 21845                                                   PLOTS.3302
            else                                                                 PLOTS.3303
              grdsh    = 0                                                       PLOTS.3304
            end if                                                               PLOTS.3305
            llint      = 0                                                       PLOTS.3306
            wlabs      = 2                                                       PLOTS.3307
            lbsiz      = 0.4                                                     PLOTS.3308
            lbqul(1)   = 0                                                       PLOTS.3309
            lbqul(2)   = 0                                                       PLOTS.3310
            tlsiz      = 0.6                                                     PLOTS.3311
            tlqul(1)   = 0                                                       PLOTS.3312
            tlqul(2)   = 0                                                       PLOTS.3313
            wouts(1:2) = 'PS'                                                    PLOTS.3314
            dtdmp      = .false.                                                 PLOTS.3315
            maplw      = 1000                                                    PLOTS.3316
            dtdsp      = 0                                                       PLOTS.3317
            perm       = .true.                                                  PLOTS.3318
          end if                                                                 PLOTS.3319
        end if                                                                   PLOTS.3320
                                                                                 PLOTS.3321
C  Second is the lat/lon grid dash pattern, or GRDSH which may be                PLOTS.3322
C    L  => GRDSH = 255   ; or 0000000011111111 ; or Large                        PLOTS.3323
C    M  => GRDSH = 3855  ; or 0000111100001111 ; or Medium                       PLOTS.3324
C    SM => GRDSH = 13107 ; or 0011001100110011 ; or SMall                        PLOTS.3325
C    T  => GRDSH = 21845 ; or 0101010101010101 ; or Tiny                         PLOTS.3326
C    SO => GRDSH = -1    ; or 1111111111111111 ; or SOlid                        PLOTS.3327
C    P  => GRDSH = 0     ; or publication style                                  PLOTS.3328
C    D  => GRDSH = 21845 ; or 0101010101010101 ; or Default                      PLOTS.3329
                                                                                 PLOTS.3330
        if ((.not. error) .and. (llplc .ne. 0)) then                             PLOTS.3331
          call search (whline,i,error)                                           PLOTS.3332
          if (error) then                                                        PLOTS.3333
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3334
            if (llplc .ne. 0) then                                               PLOTS.3335
              grdsh    = 21845                                                   PLOTS.3336
            else                                                                 PLOTS.3337
              grdsh    = 0                                                       PLOTS.3338
            end if                                                               PLOTS.3339
            llint      = 0                                                       PLOTS.3340
            wlabs      = 2                                                       PLOTS.3341
            lbsiz      = 0.4                                                     PLOTS.3342
            lbqul(1)   = 0                                                       PLOTS.3343
            lbqul(2)   = 0                                                       PLOTS.3344
            tlsiz      = 0.6                                                     PLOTS.3345
            tlqul(1)   = 0                                                       PLOTS.3346
            tlqul(2)   = 0                                                       PLOTS.3347
            wouts(1:2) = 'PS'                                                    PLOTS.3348
            dtdmp      = .false.                                                 PLOTS.3349
            maplw      = 1000                                                    PLOTS.3350
            dtdsp      = 0                                                       PLOTS.3351
            perm       = .true.                                                  PLOTS.3352
          end if                                                                 PLOTS.3353
        end if                                                                   PLOTS.3354
                                                                                 PLOTS.3355
        if ((.not. error) .and. (llplc .ne. 0)) then                             PLOTS.3356
          if ((whline(i:i) .eq. 'L') .or. (whline(i:i) .eq. 'l')) then           PLOTS.3357
            grdsh = 255                                                          PLOTS.3358
          else if ((whline(i:i) .eq. 'M') .or.                                   PLOTS.3359
     *             (whline(i:i) .eq. 'm')) then                                  PLOTS.3360
            grdsh = 3855                                                         PLOTS.3361
          else if ((whline(i:i+1) .eq. 'SM') .or.                                PLOTS.3362
     *             (whline(i:i+1) .eq. 'sm') .or.                                PLOTS.3363
     *             (whline(i:i+1) .eq. 'Sm') .or.                                PLOTS.3364
     *             (whline(i:i+1) .eq. 'sM')) then                               PLOTS.3365
            grdsh = 13107                                                        PLOTS.3366
          else if ((whline(i:i) .eq. 'T') .or.                                   PLOTS.3367
     *             (whline(i:i) .eq. 't') .or.                                   PLOTS.3368
     *             (whline(i:i) .eq. 'D') .or.                                   PLOTS.3369
     *             (whline(i:i) .eq. 'd')) then                                  PLOTS.3370
            grdsh = 21845                                                        PLOTS.3371
          else if ((whline(i:i+1) .eq. 'SO') .or.                                PLOTS.3372
     *             (whline(i:i+1) .eq. 'so') .or.                                PLOTS.3373
     *             (whline(i:i+1) .eq. 'So') .or.                                PLOTS.3374
     *             (whline(i:i+1) .eq. 'sO')) then                               PLOTS.3375
            grdsh = -1                                                           PLOTS.3376
          else if ((whline(i:i) .eq. 'P') .or.                                   PLOTS.3377
     *             (whline(i:i) .eq. 'p')) then                                  PLOTS.3378
            grdsh = 0                                                            PLOTS.3379
            if (llplc .ne. 2) then                                               PLOTS.3380
              ermes(1:31)  = 'Publication Style Lat/Lon Grids'                   PLOTS.3381
              ermes(32:60) = ' Are Plotted Over Land & Water'                    PLOTS.3382
              call errhan ('MAPDRV',0,ermes,errsev)
              llplc = 2                                                          PLOTS.3384
            end if                                                               PLOTS.3385
          else                                                                   PLOTS.3386
            ermes(1:27)  = 'Lat/Lon Grid Dash Pattern, '                         PLOTS.3387
            ermes(28:29) = whline(i:i+1)                                         PLOTS.3388
            ermes(30:60) = ', Unknown, Default Uesd        '                     PLOTS.3389
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3390
            grdsh = 21845                                                        PLOTS.3391
          end if                                                                 PLOTS.3392
          call next (whline,i,error)                                             PLOTS.3393
          if (error) then                                                        PLOTS.3394
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3395
            llint      = 0                                                       PLOTS.3396
            wlabs      = 2                                                       PLOTS.3397
            lbsiz      = 0.4                                                     PLOTS.3398
            lbqul(1)   = 0                                                       PLOTS.3399
            lbqul(2)   = 0                                                       PLOTS.3400
            tlsiz      = 0.6                                                     PLOTS.3401
            tlqul(1)   = 0                                                       PLOTS.3402
            tlqul(2)   = 0                                                       PLOTS.3403
            wouts(1:2) = 'PS'                                                    PLOTS.3404
            dtdmp      = .false.                                                 PLOTS.3405
            maplw      = 1000                                                    PLOTS.3406
            dtdsp      = 0                                                       PLOTS.3407
            perm       = .true.                                                  PLOTS.3408
          end if                                                                 PLOTS.3409
        end if                                                                   PLOTS.3410
                                                                                 PLOTS.3411
C  Third is the lat/lon grid interval, or LLINT                                  PLOTS.3412
                                                                                 PLOTS.3413
        if ((.not. error) .and. (llplc .ne. 0)) then                             PLOTS.3414
          call search (whline,i,error)                                           PLOTS.3415
          if (error) then                                                        PLOTS.3416
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3417
            llint      = 0                                                       PLOTS.3418
            wlabs      = 2                                                       PLOTS.3419
            lbsiz      = 0.4                                                     PLOTS.3420
            lbqul(1)   = 0                                                       PLOTS.3421
            lbqul(2)   = 0                                                       PLOTS.3422
            tlsiz      = 0.6                                                     PLOTS.3423
            tlqul(1)   = 0                                                       PLOTS.3424
            tlqul(2)   = 0                                                       PLOTS.3425
            wouts(1:2) = 'PS'                                                    PLOTS.3426
            dtdmp      = .false.                                                 PLOTS.3427
            maplw      = 1000                                                    PLOTS.3428
            dtdsp      = 0                                                       PLOTS.3429
            perm       = .true.                                                  PLOTS.3430
          end if                                                                 PLOTS.3431
        end if                                                                   PLOTS.3432
                                                                                 PLOTS.3433
        if ((.not. error) .and. (llplc .ne. 0)) then                             PLOTS.3434
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.3435
            llint = 0                                                            PLOTS.3436
          else                                                                   PLOTS.3437
            if ((whline(i+1:i+1) .ne. ' ') .and.                                 PLOTS.3438
     *          (whline(i+1:i+1) .ne. '|')) then                                 PLOTS.3439
              read (whline(i:i+1),50,err=110) llint                              PLOTS.3440
            else                                                                 PLOTS.3441
              read (whline(i:i),30,err=110) llint                                PLOTS.3442
            end if                                                               PLOTS.3443
          end if                                                                 PLOTS.3444
          call next (whline,i,error)                                             PLOTS.3445
          if (error) then                                                        PLOTS.3446
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3447
            wlabs      = 2                                                       PLOTS.3448
            lbsiz      = 0.4                                                     PLOTS.3449
            lbqul(1)   = 0                                                       PLOTS.3450
            lbqul(2)   = 0                                                       PLOTS.3451
            tlsiz      = 0.6                                                     PLOTS.3452
            tlqul(1)   = 0                                                       PLOTS.3453
            tlqul(2)   = 0                                                       PLOTS.3454
            wouts(1:2) = 'PS'                                                    PLOTS.3455
            dtdmp      = .false.                                                 PLOTS.3456
            maplw      = 1000                                                    PLOTS.3457
            dtdsp      = 0                                                       PLOTS.3458
            perm       = .true.                                                  PLOTS.3459
          end if                                                                 PLOTS.3460
        end if                                                                   PLOTS.3461
                                                                                 PLOTS.3462
C  Set up GRDSH and LLINT to be clean if no grid is desired                      PLOTS.3463
                                                                                 PLOTS.3464
        if ((llplc .eq. 0) .and. (.not. error)) then                             PLOTS.3465
          grdsh = 0                                                              PLOTS.3466
          llint = 0                                                              PLOTS.3467
        end if                                                                   PLOTS.3468
                                                                                 PLOTS.3469
C  Read in label information                                                     PLOTS.3470
C  First is WLABS, which can be                                                  PLOTS.3471
C    E                => WLABS = -1 ; or only EZMAP labels                       PLOTS.3472
C    M                => WLABS = 1  ; or only MAPDRV labels                      PLOTS.3473
C    N                => WLABS = 0  ; or no labels at all                        PLOTS.3474
C    D,A              => WLABS = 2  ; or both EZMAP and MAPDRV labels            PLOTS.3475
                                                                                 PLOTS.3476
        if (.not. error) then                                                    PLOTS.3477
          call search (whline,i,error)                                           PLOTS.3478
          if (error) then                                                        PLOTS.3479
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3480
            wlabs      = 2                                                       PLOTS.3481
            lbsiz      = 0.4                                                     PLOTS.3482
            lbqul(1)   = 0                                                       PLOTS.3483
            lbqul(2)   = 0                                                       PLOTS.3484
            tlsiz      = 0.6                                                     PLOTS.3485
            tlqul(1)   = 0                                                       PLOTS.3486
            tlqul(2)   = 0                                                       PLOTS.3487
            wouts(1:2) = 'PS'                                                    PLOTS.3488
            dtdmp      = .false.                                                 PLOTS.3489
            maplw      = 1000                                                    PLOTS.3490
            dtdsp      = 0                                                       PLOTS.3491
            perm       = .true.                                                  PLOTS.3492
          end if                                                                 PLOTS.3493
        end if                                                                   PLOTS.3494
                                                                                 PLOTS.3495
        if (.not. error) then                                                    PLOTS.3496
          if ((whline(i:i) .eq. 'E') .or.                                        PLOTS.3497
     *        (whline(i:i) .eq. 'e')) then                                       PLOTS.3498
            wlabs = -1                                                           PLOTS.3499
          else if ((whline(i:i) .eq. 'M') .or.                                   PLOTS.3500
     *             (whline(i:i) .eq. 'm')) then                                  PLOTS.3501
            wlabs = 1                                                            PLOTS.3502
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.3503
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.3504
            wlabs = 0                                                            PLOTS.3505
          else if ((whline(i:i) .eq. 'A') .or.                                   PLOTS.3506
     *             (whline(i:i) .eq. 'a') .or.                                   PLOTS.3507
     *             (whline(i:i) .eq. 'D') .or.                                   PLOTS.3508
     *             (whline(i:i) .eq. 'd')) then                                  PLOTS.3509
            wlabs = 2                                                            PLOTS.3510
          else                                                                   PLOTS.3511
            ermes(1:12)  = 'Label Flag, '                                        PLOTS.3512
            ermes(13:13) = whline(i:i)                                           PLOTS.3513
            ermes(14:36) = ', Unknown, Default Used'                             PLOTS.3514
            ermes(37:60) = '                        '                            PLOTS.3515
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3516
            wlabs = 2                                                            PLOTS.3517
          end if                                                                 PLOTS.3518
          call next (whline,i,error)                                             PLOTS.3519
          if (error) then                                                        PLOTS.3520
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3521
            if (wlabs .ne. 0) then                                               PLOTS.3522
              lbsiz    = 0.4                                                     PLOTS.3523
            else                                                                 PLOTS.3524
              lbsiz    = 0.0                                                     PLOTS.3525
            end if                                                               PLOTS.3526
            lbqul(1)   = 0                                                       PLOTS.3527
            lbqul(2)   = 0                                                       PLOTS.3528
            tlsiz      = 0.6                                                     PLOTS.3529
            tlqul(1)   = 0                                                       PLOTS.3530
            tlqul(2)   = 0                                                       PLOTS.3531
            wouts(1:2) = 'PS'                                                    PLOTS.3532
            dtdmp      = .false.                                                 PLOTS.3533
            maplw      = 1000                                                    PLOTS.3534
            dtdsp      = 0                                                       PLOTS.3535
            perm       = .true.                                                  PLOTS.3536
          end if                                                                 PLOTS.3537
        end if                                                                   PLOTS.3538
                                                                                 PLOTS.3539
C  Second is LBSIZ, or the label size                                            PLOTS.3540
                                                                                 PLOTS.3541
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.3542
          call search (whline,i,error)                                           PLOTS.3543
          if (error) then                                                        PLOTS.3544
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3545
            if (wlabs .ne. 0) then                                               PLOTS.3546
              lbsiz    = 0.4                                                     PLOTS.3547
            else                                                                 PLOTS.3548
              lbsiz    = 0.0                                                     PLOTS.3549
            end if                                                               PLOTS.3550
            lbqul(1)   = 0                                                       PLOTS.3551
            lbqul(2)   = 0                                                       PLOTS.3552
            tlsiz      = 0.6                                                     PLOTS.3553
            tlqul(1)   = 0                                                       PLOTS.3554
            tlqul(2)   = 0                                                       PLOTS.3555
            wouts(1:2) = 'PS'                                                    PLOTS.3556
            dtdmp      = .false.                                                 PLOTS.3557
            maplw      = 1000                                                    PLOTS.3558
            dtdsp      = 0                                                       PLOTS.3559
            perm       = .true.                                                  PLOTS.3560
          end if                                                                 PLOTS.3561
        end if                                                                   PLOTS.3562
                                                                                 PLOTS.3563
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.3564
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.3565
            lbsiz = 0.4                                                          PLOTS.3566
          else                                                                   PLOTS.3567
            if ((whline(i+1:i+1) .ne. ' ') .and.                                 PLOTS.3568
     *          (whline(i+1:i+1) .ne. '|')) then                                 PLOTS.3569
              read (whline(i:i+1),50,err=120) temp                               PLOTS.3570
            else                                                                 PLOTS.3571
              read (whline(i:i),30,err=120) temp                                 PLOTS.3572
            end if                                                               PLOTS.3573
                                                                                 PLOTS.3574
C  Label Size should not be less than 1 and should not be greater than           PLOTS.3575
C  25                                                                            PLOTS.3576
                                                                                 PLOTS.3577
            if (temp .lt. 1) then                                                PLOTS.3578
              ermes(1:30)  = 'Label Size Is Too Freaking Sma'                    PLOTS.3579
              ermes(31:60) = 'll, 1 Assumed                 '                    PLOTS.3580
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3581
              temp = 1                                                           PLOTS.3582
            end if                                                               PLOTS.3583
                                                                                 PLOTS.3584
            if (temp .gt. 25) then                                               PLOTS.3585
              ermes(1:30)  = 'Label Size Is Too Large, 25 As'                    PLOTS.3586
              ermes(31:60) = 'sumed                         '                    PLOTS.3587
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3588
              temp = 25                                                          PLOTS.3589
            end if                                                               PLOTS.3590
                                                                                 PLOTS.3591
            lbsiz = float(temp)/scale                                            PLOTS.3592
          end if                                                                 PLOTS.3593
          call next (whline,i,error)                                             PLOTS.3594
          if (error) then                                                        PLOTS.3595
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3596
            lbqul(1)   = 0                                                       PLOTS.3597
            lbqul(2)   = 0                                                       PLOTS.3598
            tlsiz      = 0.6                                                     PLOTS.3599
            tlqul(1)   = 0                                                       PLOTS.3600
            tlqul(2)   = 0                                                       PLOTS.3601
            wouts(1:2) = 'PS'                                                    PLOTS.3602
            dtdmp      = .false.                                                 PLOTS.3603
            maplw      = 1000                                                    PLOTS.3604
            dtdsp      = 0                                                       PLOTS.3605
            perm       = .true.                                                  PLOTS.3606
          end if                                                                 PLOTS.3607
        end if                                                                   PLOTS.3608
                                                                                 PLOTS.3609
C  Third in line is the label quality, LBQUL specified by to consecutive         PLOTS.3610
C  integers, combinations are                                                    PLOTS.3611
C  00 - Complex characters / High quality                                        PLOTS.3612
C  01 - Complex characters / Medium quality                                      PLOTS.3613
C  02 - Complex characters / Low quality                                         PLOTS.3614
C  10 - Duplex characters  / High quality                                        PLOTS.3615
C  11 - Duplex characters  / Medium quality                                      PLOTS.3616
C  12 - Duplex characters  / Low quality                                         PLOTS.3617
C  D  - Default = 11                                                             PLOTS.3618
                                                                                 PLOTS.3619
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.3620
          call search (whline,i,error)                                           PLOTS.3621
          if (error) then                                                        PLOTS.3622
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3623
            lbqul(1)   = 0                                                       PLOTS.3624
            lbqul(2)   = 0                                                       PLOTS.3625
            tlsiz      = 0.6                                                     PLOTS.3626
            tlqul(1)   = 0                                                       PLOTS.3627
            tlqul(2)   = 0                                                       PLOTS.3628
            wouts(1:2) = 'PS'                                                    PLOTS.3629
            dtdmp      = .false.                                                 PLOTS.3630
            maplw      = 1000                                                    PLOTS.3631
            dtdsp      = 0                                                       PLOTS.3632
            perm       = .true.                                                  PLOTS.3633
          end if                                                                 PLOTS.3634
        end if                                                                   PLOTS.3635
                                                                                 PLOTS.3636
        if ((wlabs .ne. 0) .and. (.not. error)) then                             PLOTS.3637
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.3638
            lbqul(1) = 1                                                         PLOTS.3639
            lbqul(2) = 1                                                         PLOTS.3640
          else                                                                   PLOTS.3641
            read (whline(i:i),30,err=130)     lbqul(1)                           PLOTS.3642
            read (whline(i+1:i+1),30,err=130) lbqul(2)                           PLOTS.3643
          end if                                                                 PLOTS.3644
                                                                                 PLOTS.3645
C  If the specified qualities are none of the defined ones                       PLOTS.3646
C  give and error message                                                        PLOTS.3647
                                                                                 PLOTS.3648
          if ((lbqul(1) .ne. 0) .and. (lbqul(1) .ne. 1)) then                    PLOTS.3649
            ermes(1:40) = 'Text Type Specified For Labels Unknown, '             PLOTS.3650
            ermes(41:60) = '1 Used (Duplex)     '                                PLOTS.3651
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3652
            lbqul(1) = 1                                                         PLOTS.3653
          end if                                                                 PLOTS.3654
          if ((lbqul(2) .lt. 0) .or. (lbqul(2) .gt. 2)) then                     PLOTS.3655
            ermes(1:40) = 'Text Quality Specified For Labels Unknow'             PLOTS.3656
            ermes(41:60) = 'n, 1 Used (Medium)  '                                PLOTS.3657
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3658
            lbqul(2) = 1                                                         PLOTS.3659
          end if                                                                 PLOTS.3660
                                                                                 PLOTS.3661
          call next (whline,i,error)                                             PLOTS.3662
          if (error) then                                                        PLOTS.3663
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3664
            tlsiz      = 0.6                                                     PLOTS.3665
            tlqul(1)   = 0                                                       PLOTS.3666
            tlqul(2)   = 0                                                       PLOTS.3667
            wouts(1:2) = 'PS'                                                    PLOTS.3668
            dtdmp      = .false.                                                 PLOTS.3669
            maplw      = 1000                                                    PLOTS.3670
            dtdsp      = 0                                                       PLOTS.3671
            perm       = .true.                                                  PLOTS.3672
          end if                                                                 PLOTS.3673
        end if                                                                   PLOTS.3674
                                                                                 PLOTS.3675
C  Set up label info to be clean if none were requested                          PLOTS.3676
                                                                                 PLOTS.3677
        if ((wlabs .eq. 0) .and. (.not. error)) then                             PLOTS.3678
          lbsiz    = 0.0                                                         PLOTS.3679
          lbqul(1) = 1                                                           PLOTS.3680
          lbqul(2) = 1                                                           PLOTS.3681
        end if                                                                   PLOTS.3682
                                                                                 PLOTS.3683
C  Read in the perimeter flag, PERM                                              PLOTS.3684
C  N   => Draw a line perimeter                                                  PLOTS.3685
C  Y   => Draw a perimeter with ticks                                            PLOTS.3686
                                                                                 PLOTS.3687
        if (((.not. error) .and. (grdsh .ne. 0)) .or.                            PLOTS.3688
     *      (llplc .eq. 0)) then                                                 PLOTS.3689
          call search (whline,i,error)                                           PLOTS.3690
          if (error) then                                                        PLOTS.3691
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3692
            tlsiz      = 0.6                                                     PLOTS.3693
            tlqul(1)   = 0                                                       PLOTS.3694
            tlqul(2)   = 0                                                       PLOTS.3695
            wouts(1:2) = 'PS'                                                    PLOTS.3696
            dtdmp      = .false.                                                 PLOTS.3697
            maplw      = 1000                                                    PLOTS.3698
            dtdsp      = 0                                                       PLOTS.3699
            perm       = .true.                                                  PLOTS.3700
          end if                                                                 PLOTS.3701
        end if                                                                   PLOTS.3702
                                                                                 PLOTS.3703
        if (.not. error) then                                                    PLOTS.3704
          if ((grdsh .eq. 0) .and. (llplc .eq. 2)) then                          PLOTS.3705
            perm = .false.                                                       PLOTS.3706
          else                                                                   PLOTS.3707
            if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then         PLOTS.3708
              perm = .false.                                                     PLOTS.3709
            else if ((whline(i:i) .eq. 'Y') .or.                                 PLOTS.3710
     *               (whline(i:i) .eq. 'y')) then                                PLOTS.3711
              perm = .true.                                                      PLOTS.3712
            else                                                                 PLOTS.3713
              ermes(1:35)  = 'Perimeter Flag Can Only Be Y or N, '               PLOTS.3714
              ermes(36:60) = 'Y Assumed                '                         PLOTS.3715
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3716
              perm = .true.                                                      PLOTS.3717
            end if                                                               PLOTS.3718
            call next (whline,i,error)                                           PLOTS.3719
            if (error) then                                                      PLOTS.3720
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.3721
              tlsiz      = 0.6                                                   PLOTS.3722
              tlqul(1)   = 0                                                     PLOTS.3723
              tlqul(2)   = 0                                                     PLOTS.3724
              wouts(1:2) = 'PS'                                                  PLOTS.3725
              dtdmp      = .false.                                               PLOTS.3726
              maplw      = 1000                                                  PLOTS.3727
              dtdsp      = 0                                                     PLOTS.3728
            end if                                                               PLOTS.3729
          end if                                                                 PLOTS.3730
        end if                                                                   PLOTS.3731
                                                                                 PLOTS.3732
C  Read in title information                                                     PLOTS.3733
C  First is the title flag                                                       PLOTS.3734
C    Y                   => read in TLSIZ and TLQUL                              PLOTS.3735
C    N                   => skip to outlines                                     PLOTS.3736
                                                                                 PLOTS.3737
        if (.not. error) then                                                    PLOTS.3738
          call search (whline,i,error)                                           PLOTS.3739
          if (error) then                                                        PLOTS.3740
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3741
            tlsiz      = 0.6                                                     PLOTS.3742
            tlqul(1)   = 0                                                       PLOTS.3743
            tlqul(2)   = 0                                                       PLOTS.3744
            wouts(1:2) = 'PS'                                                    PLOTS.3745
            dtdmp      = .false.                                                 PLOTS.3746
            maplw      = 1000                                                    PLOTS.3747
            dtdsp      = 0                                                       PLOTS.3748
          end if                                                                 PLOTS.3749
        end if                                                                   PLOTS.3750
                                                                                 PLOTS.3751
        if (.not. error) then                                                    PLOTS.3752
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.3753
            title = .true.                                                       PLOTS.3754
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.3755
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.3756
            title    = .false.                                                   PLOTS.3757
            tlsiz    = 0.0                                                       PLOTS.3758
            tlqul(1) = 0                                                         PLOTS.3759
            tlqul(2) = 0                                                         PLOTS.3760
          else                                                                   PLOTS.3761
            ermes(1:31)  = 'Title Flag Can Only Be Y or N, '                     PLOTS.3762
            ermes(32:60) = 'Y Assumed                    '                       PLOTS.3763
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3764
            title = .true.                                                       PLOTS.3765
          end if                                                                 PLOTS.3766
          call next (whline,i,error)                                             PLOTS.3767
          if (error) then                                                        PLOTS.3768
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3769
            if (.not. title) then                                                PLOTS.3770
              tlsiz      = 0.0                                                   PLOTS.3771
            else                                                                 PLOTS.3772
              tlsiz      = 0.6                                                   PLOTS.3773
            end if                                                               PLOTS.3774
            tlqul(1)   = 0                                                       PLOTS.3775
            tlqul(2)   = 0                                                       PLOTS.3776
            wouts(1:2) = 'PS'                                                    PLOTS.3777
            dtdmp      = .false.                                                 PLOTS.3778
            maplw      = 1000                                                    PLOTS.3779
            dtdsp      = 0                                                       PLOTS.3780
          end if                                                                 PLOTS.3781
        end if                                                                   PLOTS.3782
                                                                                 PLOTS.3783
C  Read in TLSIZ                                                                 PLOTS.3784
                                                                                 PLOTS.3785
        if ((title) .and. (.not. error)) then                                    PLOTS.3786
          call search (whline,i,error)                                           PLOTS.3787
          if (error) then                                                        PLOTS.3788
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3789
            tlsiz      = 0.6                                                     PLOTS.3790
            tlqul(1)   = 0                                                       PLOTS.3791
            tlqul(2)   = 0                                                       PLOTS.3792
            wouts(1:2) = 'PS'                                                    PLOTS.3793
            dtdmp      = .false.                                                 PLOTS.3794
            maplw      = 1000                                                    PLOTS.3795
            dtdsp      = 0                                                       PLOTS.3796
          end if                                                                 PLOTS.3797
        end if                                                                   PLOTS.3798
                                                                                 PLOTS.3799
        if ((title) .and. (.not. error)) then                                    PLOTS.3800
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.3801
            tlsiz = 0.6                                                          PLOTS.3802
          else                                                                   PLOTS.3803
            if ((whline(i+1:i+1) .ne. '|') .and.                                 PLOTS.3804
     *          (whline(i+1:i+1) .ne. ' ')) then                                 PLOTS.3805
              read (whline(i:i+1),50,err=140) temp                               PLOTS.3806
            else                                                                 PLOTS.3807
              read (whline(i:i),30,err=140) temp                                 PLOTS.3808
            end if                                                               PLOTS.3809
                                                                                 PLOTS.3810
C  Title size entered must be between 1 and 25                                   PLOTS.3811
                                                                                 PLOTS.3812
            if (temp .lt. 1) then                                                PLOTS.3813
              ermes(1:30)  = 'Title Size Is Too Freaking Sma'                    PLOTS.3814
              ermes(31:60) = 'll, 1 Assumed                 '                    PLOTS.3815
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3816
              temp = 1                                                           PLOTS.3817
            end if                                                               PLOTS.3818
                                                                                 PLOTS.3819
            if (temp .gt. 25) then                                               PLOTS.3820
              ermes(1:30)  = 'Title Size Is Too Large, 25 As'                    PLOTS.3821
              ermes(31:60) = 'sumed                         '                    PLOTS.3822
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3823
              temp = 25                                                          PLOTS.3824
            end if                                                               PLOTS.3825
                                                                                 PLOTS.3826
            tlsiz = float(temp)/scale                                            PLOTS.3827
          end if                                                                 PLOTS.3828
          call next (whline,i,error)                                             PLOTS.3829
          if (error) then                                                        PLOTS.3830
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3831
            tlqul(1)   = 0                                                       PLOTS.3832
            tlqul(2)   = 0                                                       PLOTS.3833
            wouts(1:2) = 'PS'                                                    PLOTS.3834
            dtdmp      = .false.                                                 PLOTS.3835
            maplw      = 1000                                                    PLOTS.3836
            dtdsp      = 0                                                       PLOTS.3837
          end if                                                                 PLOTS.3838
        end if                                                                   PLOTS.3839
                                                                                 PLOTS.3840
C  Read in TLQUL, which may be                                                   PLOTS.3841
C  00 - Complex characters / High quality                                        PLOTS.3842
C  01 - Complex characters / Medium quality                                      PLOTS.3843
C  02 - Complex characters / Low quality                                         PLOTS.3844
C  10 - Duplex characters  / High quality                                        PLOTS.3845
C  11 - Duplex characters  / Medium quality                                      PLOTS.3846
C  12 - Duplex characters  / Low quality                                         PLOTS.3847
C  D  - Default = 11                                                             PLOTS.3848
                                                                                 PLOTS.3849
        if ((title) .and. (.not. error)) then                                    PLOTS.3850
          call search (whline,i,error)                                           PLOTS.3851
          if (error) then                                                        PLOTS.3852
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3853
            tlqul(1)   = 0                                                       PLOTS.3854
            tlqul(2)   = 0                                                       PLOTS.3855
            wouts(1:2) = 'PS'                                                    PLOTS.3856
            dtdmp      = .false.                                                 PLOTS.3857
            maplw      = 1000                                                    PLOTS.3858
            dtdsp      = 0                                                       PLOTS.3859
          end if                                                                 PLOTS.3860
        end if                                                                   PLOTS.3861
                                                                                 PLOTS.3862
        if ((title) .and. (.not. error)) then                                    PLOTS.3863
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.3864
            tlqul(1) = 1                                                         PLOTS.3865
            tlqul(2) = 1                                                         PLOTS.3866
          else                                                                   PLOTS.3867
            read (whline(i:i),30,err=150)     tlqul(1)                           PLOTS.3868
            read (whline(i+1:i+1),30,err=150) tlqul(2)                           PLOTS.3869
          end if                                                                 PLOTS.3870
                                                                                 PLOTS.3871
C  If the specified quality numbers are not defined, deliver an error message    PLOTS.3872
                                                                                 PLOTS.3873
          if ((tlqul(1) .ne. 0) .and. (tlqul(1) .ne. 1)) then                    PLOTS.3874
            ermes(1:40) = 'Text Type Specified For Title Unknown, 1'             PLOTS.3875
            ermes(41:60) = ' Used (Duplex)      '                                PLOTS.3876
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3877
            tlqul(1) = 1                                                         PLOTS.3878
          end if                                                                 PLOTS.3879
          if ((tlqul(2) .lt. 0) .or. (tlqul(2) .gt. 2)) then                     PLOTS.3880
            ermes(1:40) = 'Text Quality Specified For Title Unknown'             PLOTS.3881
            ermes(41:60) = ', 1 Used (Medium)   '                                PLOTS.3882
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3883
            tlqul(2) = 1                                                         PLOTS.3884
          end if                                                                 PLOTS.3885
                                                                                 PLOTS.3886
          call next (whline,i,error)                                             PLOTS.3887
          if (error) then                                                        PLOTS.3888
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3889
            wouts(1:2) = 'PS'                                                    PLOTS.3890
            dtdmp      = .false.                                                 PLOTS.3891
            maplw      = 1000                                                    PLOTS.3892
            dtdsp      = 0                                                       PLOTS.3893
          end if                                                                 PLOTS.3894
        end if                                                                   PLOTS.3895
                                                                                 PLOTS.3896
C  Read in outline information, or WOUTS, which can be                           PLOTS.3897
C    NO => no outlines                                                           PLOTS.3898
C    CO => continental outlines only                                             PLOTS.3899
C    US => U.S. State outlines only                                              PLOTS.3900
C    PS => Continental + International + State outlines                          PLOTS.3901
C    PO => Continental + International outlines                                  PLOTS.3902
                                                                                 PLOTS.3903
        if (.not. error) then                                                    PLOTS.3904
          call search (whline,i,error)                                           PLOTS.3905
          if (error) then                                                        PLOTS.3906
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.3907
            wouts(1:2) = 'PS'                                                    PLOTS.3908
            dtdmp      = .false.                                                 PLOTS.3909
            maplw      = 1000                                                    PLOTS.3910
            dtdsp      = 0                                                       PLOTS.3911
          end if                                                                 PLOTS.3912
        end if                                                                   PLOTS.3913
                                                                                 PLOTS.3914
        if (.not. error) then                                                    PLOTS.3915
          wouts(1:2) = whline(i:i+1)                                             PLOTS.3916
                                                                                 PLOTS.3917
C  Make sure that WOUTS is given in all upper case                               PLOTS.3918
                                                                                 PLOTS.3919
          if ((ichar(wouts(1:1)) .le. ichar('z')) .and.                          PLOTS.3920
     *        (ichar(wouts(1:1)) .ge. ichar('a')))                               PLOTS.3921
     *      wouts(1:1) = char(ichar(wouts(1:1)) - 32)                            PLOTS.3922
          if ((ichar(wouts(2:2)) .le. ichar('z')) .and.                          PLOTS.3923
     *        (ichar(wouts(2:2)) .ge. ichar('a')))                               PLOTS.3924
     *      wouts(2:2) = char(ichar(wouts(2:2)) - 32)                            PLOTS.3925
                                                                                 PLOTS.3926
C  If WOUTS is not valid give an error                                           PLOTS.3927
                                                                                 PLOTS.3928
          if ((wouts(1:2) .ne. 'NO') .and.                                       PLOTS.3929
     *        (wouts(1:2) .ne. 'CO') .and.                                       PLOTS.3930
     *        (wouts(1:2) .ne. 'US') .and.                                       PLOTS.3931
     *        (wouts(1:2) .ne. 'PS') .and.                                       PLOTS.3932
     *        (wouts(1:2) .ne. 'PO')) then                                       PLOTS.3933
            ermes(1:32)  = 'Geographical Outline Specifier, '                    PLOTS.3934
            ermes(33:34) = wouts(1:2)                                            PLOTS.3935
            ermes(35:60) = ', Unknown, PS Used        '                          PLOTS.3936
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.3937
            wouts(1:2) = 'PS'                                                    PLOTS.3938
          end if                                                                 PLOTS.3939
          call next (whline,i,error)                                             PLOTS.3940
          if (error) then                                                        PLOTS.3941
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.3942
            dtdmp      = .false.                                                 PLOTS.3943
            maplw      = 1000                                                    PLOTS.3944
            dtdsp      = 0                                                       PLOTS.3945
          end if                                                                 PLOTS.3946
        end if                                                                   PLOTS.3947
                                                                                 PLOTS.3948
C  Read in outline details information                                           PLOTS.3949
C  First is the dotted outline flag, or DTDMP, which may be                      PLOTS.3950
C    Y                   => outlines are to be drawn with dots;                  PLOTS.3951
C                           read in the dot spacing                              PLOTS.3952
C    N                   => outlines are solid lines;                            PLOTS.3953
C                           read in the outline line width                       PLOTS.3954
                                                                                 PLOTS.3955
        if (wouts(1:2) .ne. 'NO') then                                           PLOTS.3956
          if (.not. error) then                                                  PLOTS.3957
            call search (whline,i,error)                                         PLOTS.3958
            if (error) then                                                      PLOTS.3959
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.3960
              dtdmp      = .false.                                               PLOTS.3961
              maplw      = 1000                                                  PLOTS.3962
              dtdsp      = 0                                                     PLOTS.3963
            end if                                                               PLOTS.3964
          end if                                                                 PLOTS.3965
                                                                                 PLOTS.3966
          if (.not. error) then                                                  PLOTS.3967
            if ((whline(i:i) .eq. 'y') .or. (whline(i:i) .eq. 'Y')) then         PLOTS.3968
              dtdmp = .true.                                                     PLOTS.3969
            else if ((whline(i:i) .eq. 'n') .or.                                 PLOTS.3970
     *               (whline(i:i) .eq. 'N')) then                                PLOTS.3971
              dtdmp = .false.                                                    PLOTS.3972
            else                                                                 PLOTS.3973
              ermes(1:40)  = 'Dotted Outline Flag Can Only Be Y or N, '          PLOTS.3974
              ermes(41:60) = 'N Assumed           '                              PLOTS.3975
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.3976
              dtdmp = .false.                                                    PLOTS.3977
            end if                                                               PLOTS.3978
            call next (whline,i,error)                                           PLOTS.3979
            if (error) then                                                      PLOTS.3980
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.3981
              maplw      = 1000                                                  PLOTS.3982
              dtdsp      = 0                                                     PLOTS.3983
            end if                                                               PLOTS.3984
          end if                                                                 PLOTS.3985
                                                                                 PLOTS.3986
C  Advance to next entry                                                         PLOTS.3987
                                                                                 PLOTS.3988
          if (.not. error) then                                                  PLOTS.3989
            call search (whline,i,error)                                         PLOTS.3990
            if (error) then                                                      PLOTS.3991
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.3992
              maplw      = 1000                                                  PLOTS.3993
              dtdsp      = 0                                                     PLOTS.3994
            end if                                                               PLOTS.3995
          end if                                                                 PLOTS.3996
                                                                                 PLOTS.3997
          if ((dtdmp) .and. (.not. error)) then                                  PLOTS.3998
                                                                                 PLOTS.3999
C  Read in the dot spacing                                                       PLOTS.4000
                                                                                 PLOTS.4001
            if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then         PLOTS.4002
              dtdsp = 12                                                         PLOTS.4003
            else                                                                 PLOTS.4004
              if ((whline(i+1:i+1) .ne. ' ') .or.                                PLOTS.4005
     *            (whline(i+1:i+1) .ne. '|')) then                               PLOTS.4006
                read (whline(i:i+1),50,err=160) dtdsp                            PLOTS.4007
              else                                                               PLOTS.4008
                read (whline(i:i+1),30,err=160) dtdsp                            PLOTS.4009
              end if                                                             PLOTS.4010
            end if                                                               PLOTS.4011
            if (dtdsp .lt. 1) then                                               PLOTS.4012
              ermes(1:38)  = 'Dot Spacing Must Be At Least 1, Change'            PLOTS.4013
              ermes(39:60) = 'd To 1                '                            PLOTS.4014
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.4015
              dtdsp = 1                                                          PLOTS.4016
            end if                                                               PLOTS.4017
            if (dtdsp .gt. 36) then                                              PLOTS.4018
              ermes(1:38)  = 'Dot Spacing Would Hardly Make A Map Re'            PLOTS.4019
              ermes(39:60) = 'set To 36             '                            PLOTS.4020
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.4021
              dtdsp = 36                                                         PLOTS.4022
            end if                                                               PLOTS.4023
            maplw = 0                                                            PLOTS.4024
          else                                                                   PLOTS.4025
                                                                                 PLOTS.4026
C  Read in the outline line width                                                PLOTS.4027
                                                                                 PLOTS.4028
            if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then         PLOTS.4029
              maplw = 1000                                                       PLOTS.4030
            else                                                                 PLOTS.4031
              j = i                                                              PLOTS.4032
              call next (whline,i,error)                                         PLOTS.4033
              if (.not. error) then                                              PLOTS.4034
                gstrng(1:i-j) = whline(j:i-1)                                    PLOTS.4035
                do 260 k = i-j+1,20                                              PLOTS.4036
                  gstrng(k:k) = ' '                                              PLOTS.4037
260             continue                                                         PLOTS.4038
                call gtreal (gstrng,dumy,error)                                  PLOTS.4039
                if (error) then                                                  PLOTS.4040
                  ermes(1:30)  = 'Map Outline Line Width Input C'                PLOTS.4041
                  ermes(31:60) = 'onversion                     '                PLOTS.4042
                  call errhan ('MAPDRV',0,ermes,errsev)                          PLOTS.4043
                  maplw = 1000                                                   PLOTS.4044
                  error = .false.                                                PLOTS.4045
                else                                                             PLOTS.4046
                  maplw = nint(dumy * 1000)                                      PLOTS.4047
                end if                                                           PLOTS.4048
              else                                                               PLOTS.4049
                call errhan ('MAPDRV',0,q,errsev)                                PLOTS.4050
              end if                                                             PLOTS.4051
            end if                                                               PLOTS.4052
            dtdsp = 0                                                            PLOTS.4053
            if (maplw .lt. 1000) then                                            PLOTS.4054
              ermes(1:38)  = 'Line Widths Of Less Than 1000 Will Be '            PLOTS.4055
              ermes(39:60) = '1000                  '                            PLOTS.4056
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.4057
              maplw = 1000                                                       PLOTS.4058
            end if                                                               PLOTS.4059
            if (maplw .gt. 10000) then                                           PLOTS.4060
              ermes(1:38)  = 'Line Widths Of Greater Than 10000 Will'            PLOTS.4061
              ermes(39:60) = ' Be 10000             '                            PLOTS.4062
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.4063
              maplw = 10000                                                      PLOTS.4064
            end if                                                               PLOTS.4065
          end if                                                                 PLOTS.4066
        else                                                                     PLOTS.4067
          dtdmp      = .false.                                                   PLOTS.4068
          maplw      = 1000                                                      PLOTS.4069
          dtdsp      = 0                                                         PLOTS.4070
        end if                                                                   PLOTS.4071
                                                                                 PLOTS.4072
C  Warn user if errors exist                                                     PLOTS.4073
                                                                                 PLOTS.4074
        if (.not. error) then                                                    PLOTS.4075
          call next (whline,i,error)                                             PLOTS.4076
          if (error) then                                                        PLOTS.4077
            call errhan ('MAPDRV',0,q,errsev)                                    PLOTS.4078
          else                                                                   PLOTS.4079
            call search (whline,i,error)                                         PLOTS.4080
            if (.not. error) then                                                PLOTS.4081
              ermes(1:24)  = 'Too Many Entries On Line'                          PLOTS.4082
              ermes(25:50) = ' - Extras Ignored         '                        PLOTS.4083
              ermes(51:60) = '          '                                        PLOTS.4084
              call errhan ('MAPDRV',0,ermes,errsev)                              PLOTS.4085
            end if                                                               PLOTS.4086
          end if                                                                 PLOTS.4087
        end if                                                                   PLOTS.4088
                                                                                 PLOTS.4089
C  Check for value errors                                                        PLOTS.4090
C  The lat/lon grid interval must be between 0 and 180                           PLOTS.4091
                                                                                 PLOTS.4092
        if ((llint .lt. 0) .or. (llint .gt. 180)) then                           PLOTS.4093
          ermes(1:30)  = 'Lat/Lon Grid Interval Invalid,'                        PLOTS.4094
          ermes(31:60) = ' Default Used                 '                        PLOTS.4095
          call errhan ('MAPDRV',0,ermes,errsev)                                  PLOTS.4096
          llint = 0                                                              PLOTS.4097
        end if                                                                   PLOTS.4098
                                                                                 PLOTS.4099
        goto 70                                                                  PLOTS.4100
      else                                                                       PLOTS.4101
                                                                                 PLOTS.4102
        if (buff .ge. 0) then                                                    PLOTS.4103
                                                                                 PLOTS.4104
C  The table is not there so use the defaults                                    PLOTS.4105
                                                                                 PLOTS.4106
          print *, 'MAPDRV - Defaults Used For Map Details'                      PLOTS.4107
          error      = .false.                                                   PLOTS.4108
          llplc      = 2                                                         PLOTS.4109
          grdsh      = 21845                                                     PLOTS.4110
          llint      = 0                                                         PLOTS.4111
          wlabs      = 2                                                         PLOTS.4112
          lbsiz      = 0.4                                                       PLOTS.4113
          lbqul(1)   = 0                                                         PLOTS.4114
          lbqul(2)   = 0                                                         PLOTS.4115
          tlsiz      = 0.6                                                       PLOTS.4116
          tlqul(1)   = 0                                                         PLOTS.4117
          tlqul(2)   = 0                                                         PLOTS.4118
          wouts(1:2) = 'PS'                                                      PLOTS.4119
          dtdmp      = .false.                                                   PLOTS.4120
          maplw      = 1000                                                      PLOTS.4121
          dtdsp      = 0                                                         PLOTS.4122
        else                                                                     PLOTS.4123
                                                                                 PLOTS.4124
C  The table may or may not be there, but only an area map has been requested    PLOTS.4125
C  so special defaults are used                                                  PLOTS.4126
                                                                                 PLOTS.4127
          print *, 'MAPDRV - Area Map Request Accepted'                          PLOTS.4128
          error      = .false.                                                   PLOTS.4129
          llplc      = 0                                                         PLOTS.4130
          grdsh      = 0                                                         PLOTS.4131
          llint      = 0                                                         PLOTS.4132
          wlabs      = 0                                                         PLOTS.4133
          lbsiz      = 0.0                                                       PLOTS.4134
          lbqul(1)   = 0                                                         PLOTS.4135
          lbqul(2)   = 0                                                         PLOTS.4136
          tlsiz      = 0.0                                                       PLOTS.4137
          tlqul(1)   = 0                                                         PLOTS.4138
          tlqul(2)   = 0                                                         PLOTS.4139
          wouts(1:2) = 'CO'                                                      PLOTS.4140
          dtdmp      = .false.                                                   PLOTS.4141
          maplw      = 1000                                                      PLOTS.4142
          dtdsp      = 0                                                         PLOTS.4143
        end if                                                                   PLOTS.4144
        goto 90                                                                  PLOTS.4145
      end if                                                                     PLOTS.4146
                                                                                 PLOTS.4147
C  Handle mismatch errors                                                        PLOTS.4148
C  First are lat/lon gird interval mismatch errors                               PLOTS.4149
                                                                                 PLOTS.4150
110   ermes(1:37)  = 'Lat/Lon Grid Interval Type Mismatch  '                     PLOTS.4151
      ermes(38:60) = '                       '                                   PLOTS.4152
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4153
      llint      = 0                                                             PLOTS.4154
      wlabs      = 2                                                             PLOTS.4155
      lbsiz      = 0.4                                                           PLOTS.4156
      lbqul(1)   = 0                                                             PLOTS.4157
      lbqul(2)   = 0                                                             PLOTS.4158
      tlsiz      = 0.6                                                           PLOTS.4159
      tlqul(1)   = 0                                                             PLOTS.4160
      tlqul(2)   = 0                                                             PLOTS.4161
      wouts(1:2) = 'PS'                                                          PLOTS.4162
      dtdmp      = .false.                                                       PLOTS.4163
      maplw      = 1000                                                          PLOTS.4164
      dtdsp      = 0                                                             PLOTS.4165
      perm       = .true.                                                        PLOTS.4166
      goto 70                                                                    PLOTS.4167
                                                                                 PLOTS.4168
C  Second is the label size type mismatch                                        PLOTS.4169
                                                                                 PLOTS.4170
120   ermes(1:24)  = 'Label Size Type Mismatch'                                  PLOTS.4171
      ermes(25:60) = '                                    '                      PLOTS.4172
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4173
      lbsiz      = 0.4                                                           PLOTS.4174
      lbqul(1)   = 0                                                             PLOTS.4175
      lbqul(2)   = 0                                                             PLOTS.4176
      tlsiz      = 0.6                                                           PLOTS.4177
      tlqul(1)   = 0                                                             PLOTS.4178
      tlqul(2)   = 0                                                             PLOTS.4179
      wouts(1:2) = 'PS'                                                          PLOTS.4180
      dtdmp      = .false.                                                       PLOTS.4181
      maplw      = 1000                                                          PLOTS.4182
      dtdsp      = 0                                                             PLOTS.4183
      perm       = .true.                                                        PLOTS.4184
      goto 70                                                                    PLOTS.4185
                                                                                 PLOTS.4186
C  Third is label quality mismatch                                               PLOTS.4187
                                                                                 PLOTS.4188
130   ermes(1:27)  = 'Label Quality Type Mismatch'                               PLOTS.4189
      ermes(28:60) = '                                 '                         PLOTS.4190
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4191
      lbqul(1)   = 0                                                             PLOTS.4192
      lbqul(2)   = 0                                                             PLOTS.4193
      tlsiz      = 0.6                                                           PLOTS.4194
      tlqul(1)   = 0                                                             PLOTS.4195
      tlqul(2)   = 0                                                             PLOTS.4196
      wouts(1:2) = 'PS'                                                          PLOTS.4197
      dtdmp      = .false.                                                       PLOTS.4198
      maplw      = 1000                                                          PLOTS.4199
      dtdsp      = 0                                                             PLOTS.4200
      perm       = .true.                                                        PLOTS.4201
      goto 70                                                                    PLOTS.4202
                                                                                 PLOTS.4203
C  Fourth is the title size type mismatch                                        PLOTS.4204
                                                                                 PLOTS.4205
140   ermes(1:24)  = 'Title Size Type Mismatch'                                  PLOTS.4206
      ermes(25:60) = '                                    '                      PLOTS.4207
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4208
      tlsiz      = 0.6                                                           PLOTS.4209
      tlqul(1)   = 0                                                             PLOTS.4210
      tlqul(2)   = 0                                                             PLOTS.4211
      wouts(1:2) = 'PS'                                                          PLOTS.4212
      dtdmp      = .false.                                                       PLOTS.4213
      maplw      = 1000                                                          PLOTS.4214
      dtdsp      = 0                                                             PLOTS.4215
      goto 70                                                                    PLOTS.4216
                                                                                 PLOTS.4217
C  Fifth is the title quality type mismatch                                      PLOTS.4218
                                                                                 PLOTS.4219
150   ermes(1:27)  = 'Title Quality Type Mismatch'                               PLOTS.4220
      ermes(28:60) = '                                 '                         PLOTS.4221
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4222
      tlqul(1)   = 0                                                             PLOTS.4223
      tlqul(2)   = 0                                                             PLOTS.4224
      wouts(1:2) = 'PS'                                                          PLOTS.4225
      dtdmp      = .false.                                                       PLOTS.4226
      maplw      = 1000                                                          PLOTS.4227
      dtdsp      = 0                                                             PLOTS.4228
      goto 70                                                                    PLOTS.4229
                                                                                 PLOTS.4230
C  Sixth is the dot spacing type mismatch                                        PLOTS.4231
                                                                                 PLOTS.4232
160   ermes(1:25)  = 'Dot Spacing Type Mismatch'                                 PLOTS.4233
      ermes(26:60) = '                                   '                       PLOTS.4234
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4235
      dtdsp      = 12                                                            PLOTS.4236
      maplw      = 0                                                             PLOTS.4237
      goto 70                                                                    PLOTS.4238
                                                                                 PLOTS.4239
C  Last is the line width type mismatch                                          PLOTS.4240
                                                                                 PLOTS.4241
170   ermes(1:24)  = 'Line Width Type Mismatch'                                  PLOTS.4242
      ermes(25:60) = '                                    '                      PLOTS.4243
      call errhan ('MAPDRV',1,ermes,errsev)                                      PLOTS.4244
      dtdsp      = 0                                                             PLOTS.4245
      maplw      = 1000                                                          PLOTS.4246
                                                                                 PLOTS.4247
70    print *, 'MAPDRV - Map Details Set Up'                                     PLOTS.4248
90    owlabs = wlabs                                                             PLOTS.4249
      ollplc = llplc                                                             PLOTS.4250
                                                                                 PLOTS.4251
C*****************************  subroutine end  ******************************C  PLOTS.4252
                                                                                 PLOTS.4253
C  Format statements begin ...                                                   PLOTS.4254
                                                                                 PLOTS.4255
30    format (I1)                                                                PLOTS.4256
50    format (I2)                                                                PLOTS.4257
60    format (I4)                                                                PLOTS.4258
                                                                                 PLOTS.4259
C  Format statements end.                                                        PLOTS.4260
                                                                                 PLOTS.4261
250   return                                                                     PLOTS.4262
      end                                                                        PLOTS.4263
      subroutine mrdfil (unum,flmap,errsev,nomap)                                PLOTS.4264
                                                                                 PLOTS.4265
C*****************************************************************************C  PLOTS.4266
C  mrdfil   - This is a MAPDRV routine                                        C  PLOTS.4267
C  Section  - Tables                                                          C  PLOTS.4268
C  Purpose  - To read in the map fill table and assign the map fill colors.   C  PLOTS.4269
C                                                                             C  PLOTS.4270
C  On entry - UNUM  is the unit  number of the table file.   ERRSEV indicates C  PLOTS.4271
C             severity of a error which will cause execution to halt.   NOMAP C  PLOTS.4272
C             is true if a non-correctable  error has  occured and  is  false C  PLOTS.4273
C             otherwise.                                                      C  PLOTS.4274
C                                                                             C  PLOTS.4275
C  On exit  - FLMAP is true if the table  was there,  and is false otherwise. C  PLOTS.4276
C             The color indicies in common blocks FLINFO  and FLWATR have all C  PLOTS.4277
C             been set up correctly.  If a non-correctable error has  occrued C  PLOTS.4278
C             NOMAP is true and is false otherwise.                           C  PLOTS.4279
C                                                                             C  PLOTS.4280
C  Assume   - Nothing.                                                        C  PLOTS.4281
C                                                                             C  PLOTS.4282
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.4283
C             ----------------------------------------------------------------C  PLOTS.4284
C             SEARCH              MAPDRV/CONDRV utility                       C  PLOTS.4285
C             NEXT                MAPDRV/CONDRV utility                       C  PLOTS.4286
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.4287
C             ERRFIL              MAPDRV utility                              C  PLOTS.4288
C             CRDRCI              MAPDRV/CONDRV utility                       C  PLOTS.4289
C             ----------------------------------------------------------------C  PLOTS.4290
C                                                                             C  PLOTS.4291
C  Author   - Jeremy Asbill        Date - May 27, 1990       for the MM4 club C  PLOTS.4292
C*****************************************************************************C  PLOTS.4293
                                                                                 PLOTS.4294
C  Character variables                                                           PLOTS.4295
                                                                                 PLOTS.4296
      character*80     whline            ! line of info. from table     (local)  PLOTS.4297
      character*60     p,                ! error message for SEARCH     (local)  PLOTS.4298
     *                 q,                ! error message for NEXT       (local)  PLOTS.4299
     *                 ermes             ! general error message        (local)  PLOTS.4300
      character*2      wouts             ! for common block MOCDET               PLOTS.4301
                                                                                 PLOTS.4302
C  Integer variables                                                             PLOTS.4303
                                                                                 PLOTS.4304
      integer          unum,             ! unit number of table file       (in)  PLOTS.4305
     *                 errsev            ! error severity indicator        (in)  PLOTS.4306
      integer          fscolr,           ! for common block FLINFO               PLOTS.4307
     *                 secolr,           ! for common block FLINFO               PLOTS.4308
     *                 thcolr,           ! for common block FLINFO               PLOTS.4309
     *                 frcolr,           ! for common block FLINFO               PLOTS.4310
     *                 fvcolr,           ! for common block FLINFO               PLOTS.4311
     *                 sicolr            ! for common block FLINFO               PLOTS.4312
      integer          wacolr            ! for common block FLWATR               PLOTS.4313
      integer          i                 ! loop counter/place keeper    (local)  PLOTS.4314
                                                                                 PLOTS.4315
C  Logical variables                                                             PLOTS.4316
                                                                                 PLOTS.4317
      logical          flmap             ! color fill the map ?           (out)  PLOTS.4318
      logical          nomap,            ! don't draw a map ?           (local)  PLOTS.4319
     *                 error,            ! has an error occured ?       (local)  PLOTS.4320
     *                 found             ! was the table found ?        (local)  PLOTS.4321
                                                                                 PLOTS.4322
C  Common blocks                                                                 PLOTS.4323
                                                                                 PLOTS.4324
      common /flinfo/  fscolr,           ! first color                           PLOTS.4325
     *                 secolr,           ! second color                          PLOTS.4326
     *                 thcolr,           ! third color                           PLOTS.4327
     *                 frcolr,           ! fourth color                          PLOTS.4328
     *                 fvcolr,           ! fifth color                           PLOTS.4329
     *                 sicolr            ! sixth color                           PLOTS.4330
      common /flwatr/  wacolr            ! water color                           PLOTS.4331
      common /mocdet/  wouts             ! geographical outline indicator        PLOTS.4332
                                                                                 PLOTS.4333
C****************************  subroutine begin  *****************************C  PLOTS.4334
                                                                                 PLOTS.4335
C  Check to see if we need to do this                                            PLOTS.4336
                                                                                 PLOTS.4337
      if (nomap) goto 150                                                        PLOTS.4338
                                                                                 PLOTS.4339
C  Initialize the error flag                                                     PLOTS.4340
                                                                                 PLOTS.4341
      error = .false.                                                            PLOTS.4342
                                                                                 PLOTS.4343
C  Try to get the information line from the table                                PLOTS.4344
                                                                                 PLOTS.4345
      call tbllok (unum,'MAP FILL  ',errsev,found,whline,'MAPDRV')               PLOTS.4346
                                                                                 PLOTS.4347
C  Only parse the information if the table was found                             PLOTS.4348
                                                                                 PLOTS.4349
      if (found) then                                                            PLOTS.4350
                                                                                 PLOTS.4351
C  Assume since the table was there that the map will be filled                  PLOTS.4352
                                                                                 PLOTS.4353
        flmap = .true.                                                           PLOTS.4354
                                                                                 PLOTS.4355
C  Set up the SEARCH and NEXT messages                                           PLOTS.4356
                                                                                 PLOTS.4357
        p(1:23)  = 'Reading Details Table, '                                     PLOTS.4358
        p(24:60) = 'Too Few Entries On Line              '                       PLOTS.4359
        q(1:23)  = p(1:23)                                                       PLOTS.4360
        q(24:60) = 'Entry Is Bizarre                     '                       PLOTS.4361
                                                                                 PLOTS.4362
C  Initialize the place keepers                                                  PLOTS.4363
                                                                                 PLOTS.4364
        i = 1                                                                    PLOTS.4365
                                                                                 PLOTS.4366
C  First read in the water color index                                           PLOTS.4367
                                                                                 PLOTS.4368
        call search (whline,i,error)                                             PLOTS.4369
        if (error)                                                               PLOTS.4370
     *    call errhan ('MAPDRV',1,p,errsev)                                      PLOTS.4371
                                                                                 PLOTS.4372
        call crdrci (.true.,error,wacolr,1,whline,i,                             PLOTS.4373
     *               'Water Color Index',17,errsev,                              PLOTS.4374
     *               nomap,'MAPDRV')                                             PLOTS.4375
        if (error) call errfil (7)                                               PLOTS.4376
        if (nomap) goto 150                                                      PLOTS.4377
                                                                                 PLOTS.4378
        if (.not. error) then                                                    PLOTS.4379
          call next (whline,i,error)                                             PLOTS.4380
          if (error) then                                                        PLOTS.4381
            call errhan ('MAPDRV',1,q,errsev)                                    PLOTS.4382
            call errfil (6)                                                      PLOTS.4383
          end if                                                                 PLOTS.4384
        end if                                                                   PLOTS.4385
                                                                                 PLOTS.4386
C  After the water color there are six more color indices to read in             PLOTS.4387
C  1                                                                             PLOTS.4388
                                                                                 PLOTS.4389
        if ((wouts(1:2) .ne. 'NO') .and. (.not. error)) then                     PLOTS.4390
          call search (whline,i,error)                                           PLOTS.4391
          if (error) then                                                        PLOTS.4392
            call errhan ('MAPDRV',1,p,errsev)                                    PLOTS.4393
            call errfil (6)                                                      PLOTS.4394
          end if                                                                 PLOTS.4395
                                                                                 PLOTS.4396
          if (.not. error) then                                                  PLOTS.4397
            call crdrci (.true.,error,fscolr,1,whline,i,                         PLOTS.4398
     *                   'First Color Index',17,errsev,                          PLOTS.4399
     *                   nomap,'MAPDRV')                                         PLOTS.4400
            if (error) call errfil (6)                                           PLOTS.4401
            if (nomap) goto 150                                                  PLOTS.4402
          end if                                                                 PLOTS.4403
                                                                                 PLOTS.4404
          if (.not. error) then                                                  PLOTS.4405
            call next (whline,i,error)                                           PLOTS.4406
            if (error) then                                                      PLOTS.4407
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.4408
              call errfil (5)                                                    PLOTS.4409
            end if                                                               PLOTS.4410
          end if                                                                 PLOTS.4411
                                                                                 PLOTS.4412
C  2                                                                             PLOTS.4413
                                                                                 PLOTS.4414
          if (.not. error) then                                                  PLOTS.4415
            call search (whline,i,error)                                         PLOTS.4416
            if (error) then                                                      PLOTS.4417
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.4418
              call errfil (5)                                                    PLOTS.4419
            end if                                                               PLOTS.4420
          end if                                                                 PLOTS.4421
                                                                                 PLOTS.4422
          if (.not. error) then                                                  PLOTS.4423
            call crdrci (.true.,error,secolr,1,whline,i,                         PLOTS.4424
     *                   'Second Color Index',18,errsev,                         PLOTS.4425
     *                   nomap,'MAPDRV')                                         PLOTS.4426
            if (error) call errfil (5)                                           PLOTS.4427
            if (nomap) goto 150                                                  PLOTS.4428
          end if                                                                 PLOTS.4429
                                                                                 PLOTS.4430
          if (.not. error) then                                                  PLOTS.4431
            call next (whline,i,error)                                           PLOTS.4432
            if (error) then                                                      PLOTS.4433
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.4434
              call errfil (4)                                                    PLOTS.4435
            end if                                                               PLOTS.4436
          end if                                                                 PLOTS.4437
                                                                                 PLOTS.4438
C  3                                                                             PLOTS.4439
                                                                                 PLOTS.4440
          if (.not. error) then                                                  PLOTS.4441
            call search (whline,i,error)                                         PLOTS.4442
            if (error) then                                                      PLOTS.4443
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.4444
              call errfil (4)                                                    PLOTS.4445
            end if                                                               PLOTS.4446
          end if                                                                 PLOTS.4447
                                                                                 PLOTS.4448
          if (.not. error) then                                                  PLOTS.4449
            call crdrci (.true.,error,thcolr,1,whline,i,                         PLOTS.4450
     *                   'Third Color Index',17,errsev,                          PLOTS.4451
     *                   nomap,'MAPDRV')                                         PLOTS.4452
            if (error) call errfil (4)                                           PLOTS.4453
            if (nomap) goto 150                                                  PLOTS.4454
          end if                                                                 PLOTS.4455
                                                                                 PLOTS.4456
          if (.not. error) then                                                  PLOTS.4457
            call next (whline,i,error)                                           PLOTS.4458
            if (error) then                                                      PLOTS.4459
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.4460
              call errfil (3)                                                    PLOTS.4461
            end if                                                               PLOTS.4462
          end if                                                                 PLOTS.4463
                                                                                 PLOTS.4464
C  4                                                                             PLOTS.4465
                                                                                 PLOTS.4466
          if (.not. error) then                                                  PLOTS.4467
            call search (whline,i,error)                                         PLOTS.4468
            if (error) then                                                      PLOTS.4469
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.4470
              call errfil (3)                                                    PLOTS.4471
            end if                                                               PLOTS.4472
          end if                                                                 PLOTS.4473
                                                                                 PLOTS.4474
          if (.not. error) then                                                  PLOTS.4475
            call crdrci (.true.,error,frcolr,1,whline,i,                         PLOTS.4476
     *                   'Fourth Color Index',18,errsev,                         PLOTS.4477
     *                   nomap,'MAPDRV')                                         PLOTS.4478
            if (error) call errfil (3)                                           PLOTS.4479
            if (nomap) goto 150                                                  PLOTS.4480
          end if                                                                 PLOTS.4481
                                                                                 PLOTS.4482
          if (.not. error) then                                                  PLOTS.4483
            call next (whline,i,error)                                           PLOTS.4484
            if (error) then                                                      PLOTS.4485
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.4486
              call errfil (2)                                                    PLOTS.4487
            end if                                                               PLOTS.4488
          end if                                                                 PLOTS.4489
                                                                                 PLOTS.4490
C  5                                                                             PLOTS.4491
                                                                                 PLOTS.4492
          if (.not. error) then                                                  PLOTS.4493
            call search (whline,i,error)                                         PLOTS.4494
            if (error) then                                                      PLOTS.4495
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.4496
              call errfil (2)                                                    PLOTS.4497
            end if                                                               PLOTS.4498
          end if                                                                 PLOTS.4499
                                                                                 PLOTS.4500
          if (.not. error) then                                                  PLOTS.4501
            call crdrci (.true.,error,fvcolr,1,whline,i,                         PLOTS.4502
     *                   'Fifth Color Index',17,errsev,                          PLOTS.4503
     *                   nomap,'MAPDRV')                                         PLOTS.4504
            if (error) call errfil (2)                                           PLOTS.4505
            if (nomap) goto 150                                                  PLOTS.4506
          end if                                                                 PLOTS.4507
                                                                                 PLOTS.4508
          if (.not. error) then                                                  PLOTS.4509
            call next (whline,i,error)                                           PLOTS.4510
            if (error) then                                                      PLOTS.4511
              call errhan ('MAPDRV',1,q,errsev)                                  PLOTS.4512
              call errfil (1)                                                    PLOTS.4513
            end if                                                               PLOTS.4514
          end if                                                                 PLOTS.4515
                                                                                 PLOTS.4516
C  6                                                                             PLOTS.4517
                                                                                 PLOTS.4518
          if (.not. error) then                                                  PLOTS.4519
            call search (whline,i,error)                                         PLOTS.4520
            if (error) then                                                      PLOTS.4521
              call errhan ('MAPDRV',1,p,errsev)                                  PLOTS.4522
              call errfil (1)                                                    PLOTS.4523
            end if                                                               PLOTS.4524
          end if                                                                 PLOTS.4525
                                                                                 PLOTS.4526
          if (.not. error) then                                                  PLOTS.4527
            call crdrci (.true.,error,sicolr,1,whline,i,                         PLOTS.4528
     *                   'Sixth Color Index',17,errsev,                          PLOTS.4529
     *                   nomap,'MAPDRV')                                         PLOTS.4530
            if (error) call errfil (1)                                           PLOTS.4531
            if (nomap) goto 150                                                  PLOTS.4532
          end if                                                                 PLOTS.4533
                                                                                 PLOTS.4534
          if (.not. error) then                                                  PLOTS.4535
            call next (whline,i,error)                                           PLOTS.4536
            if (error) then                                                      PLOTS.4537
              call errhan ('MAPDRV',0,q,errsev)                                  PLOTS.4538
            end if                                                               PLOTS.4539
          end if                                                                 PLOTS.4540
        end if                                                                   PLOTS.4541
                                                                                 PLOTS.4542
C  Check to see if there were too many entries in the table                      PLOTS.4543
                                                                                 PLOTS.4544
        if (.not. error) then                                                    PLOTS.4545
          call search (whline,i,error)                                           PLOTS.4546
          if (.not. error) then                                                  PLOTS.4547
            ermes(1:24)  = 'Too Many Entries On Line'                            PLOTS.4548
            ermes(25:50) = ' - Extras Ignored         '                          PLOTS.4549
            ermes(51:60) = '          '                                          PLOTS.4550
            call errhan ('MAPDRV',0,ermes,errsev)                                PLOTS.4551
          end if                                                                 PLOTS.4552
        end if                                                                   PLOTS.4553
        print *, 'MAPDRV - Map Fill Information Set Up'                          PLOTS.4554
      else                                                                       PLOTS.4555
                                                                                 PLOTS.4556
C  The table was not there, no fill is to be done                                PLOTS.4557
                                                                                 PLOTS.4558
        flmap = .false.                                                          PLOTS.4559
        wacolr = 0                                                               PLOTS.4560
        fscolr = 0                                                               PLOTS.4561
        secolr = 0                                                               PLOTS.4562
        thcolr = 0                                                               PLOTS.4563
        frcolr = 0                                                               PLOTS.4564
        fvcolr = 0                                                               PLOTS.4565
        sicolr = 0                                                               PLOTS.4566
      end if                                                                     PLOTS.4567
                                                                                 PLOTS.4568
C*****************************  subroutine end  ******************************C  PLOTS.4569
                                                                                 PLOTS.4570
C  Format statements begin ...                                                   PLOTS.4571
                                                                                 PLOTS.4572
30    format (I1)                                                                PLOTS.4573
50    format (I2)                                                                PLOTS.4574
                                                                                 PLOTS.4575
C  Format statements end.                                                        PLOTS.4576
                                                                                 PLOTS.4577
150   return                                                                     PLOTS.4578
      end                                                                        PLOTS.4579
      subroutine next (whline,place,error)                                       PLOTS.4580
                                                                                 PLOTS.4581
C*****************************************************************************C  PLOTS.4582
C  next     - This is a CONDRV/MAPDRV routine                                 C  PLOTS.4583
C  Section  - Tables                                                          C  PLOTS.4584
C  Purpose  - To read to the next space or vertical bar in a table.           C  PLOTS.4585
C                                                                             C  PLOTS.4586
C  On entry - WHLINE contains a line (80 Characters) of a table.  PLACE  con- C  PLOTS.4587
C             tains the location in WHLINE to start looking.  ERROR comes  in C  PLOTS.4588
C             false.                                                          C  PLOTS.4589
C                                                                             C  PLOTS.4590
C  On exit  - PLACE contains the location of the the next space  or  vertical C  PLOTS.4591
C             bar in WHLINE and ERROR is true if the  search went  beyond  80 C  PLOTS.4592
C             characters and is false otherwise.                              C  PLOTS.4593
C                                                                             C  PLOTS.4594
C  Assume   - Nothing.                                                        C  PLOTS.4595
C                                                                             C  PLOTS.4596
C  Author   - Jeremy Asbill        Date - June 21, 1990      for the MM4 Club C  PLOTS.4597
C*****************************************************************************C  PLOTS.4598
                                                                                 PLOTS.4599
C  Character variables                                                           PLOTS.4600
                                                                                 PLOTS.4601
      character*80     whline            ! a line from current table       (in)  PLOTS.4602
                                                                                 PLOTS.4603
C  Integer variables                                                             PLOTS.4604
                                                                                 PLOTS.4605
      integer          place             ! start parse here                (in)  PLOTS.4606
      integer          i                 ! place keeper                 (local)  PLOTS.4607
                                                                                 PLOTS.4608
C  Logical variables                                                             PLOTS.4609
                                                                                 PLOTS.4610
      logical          error             ! has an error occured ?          (in)  PLOTS.4611
                                                                                 PLOTS.4612
C****************************  subroutine begin  *****************************C  PLOTS.4613
                                                                                 PLOTS.4614
C  Use I and not PLACE                                                           PLOTS.4615
                                                                                 PLOTS.4616
      i = place                                                                  PLOTS.4617
                                                                                 PLOTS.4618
C  Always increment at least one place in WHLINE                                 PLOTS.4619
                                                                                 PLOTS.4620
      i = i + 1                                                                  PLOTS.4621
                                                                                 PLOTS.4622
C  Test until we find the first space or vertical bar                            PLOTS.4623
                                                                                 PLOTS.4624
10    continue                                                                   PLOTS.4625
      if (i .le. 80) then                                                        PLOTS.4626
        if ((whline(i:i) .ne. ' ') .and. (whline(i:i) .ne. '|')) then            PLOTS.4627
          i = i + 1                                                              PLOTS.4628
          goto 10                                                                PLOTS.4629
        end if                                                                   PLOTS.4630
      end if                                                                     PLOTS.4631
                                                                                 PLOTS.4632
C  If no error occured reassign PLACE and exit                                   PLOTS.4633
                                                                                 PLOTS.4634
      if (i .le. 80) then                                                        PLOTS.4635
        place = i                                                                PLOTS.4636
                                                                                 PLOTS.4637
C  If an error has occured let the calling routine know                          PLOTS.4638
                                                                                 PLOTS.4639
      else                                                                       PLOTS.4640
        error = .true.                                                           PLOTS.4641
      end if                                                                     PLOTS.4642
                                                                                 PLOTS.4643
C*****************************  subroutine end  ******************************C  PLOTS.4644
                                                                                 PLOTS.4645
      return                                                                     PLOTS.4646
      end                                                                        PLOTS.4647
      subroutine prodll (nmgr,cenlon,project)                                    PLOTS.4648
                                                                                 PLOTS.4649
C*****************************************************************************C  PLOTS.4650
C  prodll   - This is a MAPDRV routine                                        C  PLOTS.4651
C  Section  - Lat/Lon Lines                                                   C  PLOTS.4652
C  Purpose  - To make publication style lat/lon patterns on a map.            C  PLOTS.4653
C                                                                             C  PLOTS.4654
C  On entry - NMGR is the grid interval being used. CENLON is the center lon- C  PLOTS.4655
C             longitude of the entire domain, even if this is a subset.       C  PLOTS.4656
C                                                                             C  PLOTS.4657
C  On exit  - The lat/lon grid has been marked with plus signs.               C  PLOTS.4658
C                                                                             C  PLOTS.4659
C  Assume   - GKS is open.                                                    C  PLOTS.4660
C                                                                             C  PLOTS.4661
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.4662
C             ----------------------------------------------------------------C  PLOTS.4663
C             MAPGTI              EZMAP utility*                              C  PLOTS.4664
C             MAPTRN              EZMAP utility*                              C  PLOTS.4665
C             PLCHHQ              PLOTCHAR utility*                           C  PLOTS.4666
C             ----------------------------------------------------------------C  PLOTS.4667
C             * NCAR Graphics routine                                         C  PLOTS.4668
C                                                                             C  PLOTS.4669
C  Author   - Jeremy Asbill       Date - July 23, 1990       for the MM4 club C  PLOTS.4670
C*****************************************************************************C  PLOTS.4671
                                                                                 PLOTS.4672
C  Character variables                                                           PLOTS.4673
                                                                                 PLOTS.4674
      character*2      project           ! projection used in map          (in)  PLOTS.4675
                                                                                 PLOTS.4676
C  Integer variables                                                             PLOTS.4677
                                                                                 PLOTS.4678
      integer          nmgr              ! grid interval to use            (in)  PLOTS.4679
      integer          wlabs,            ! for common block MLBDET               PLOTS.4680
     *                 lbqul(2)          ! for common block MLBDET               PLOTS.4681
      integer          llcolr            ! for common block LLLCOL               PLOTS.4682
      integer          i,j,              ! loop counters/place keepers  (local)  PLOTS.4683
     *                 stri,             ! what lon. to start with      (local)  PLOTS.4684
     *                 strj,             ! what lat. to start with      (local)  PLOTS.4685
     *                 llsv              ! save variable                (local)  PLOTS.4686
                                                                                 PLOTS.4687
C  Real variables                                                                PLOTS.4688
                                                                                 PLOTS.4689
      real             cenlon            ! center longitude                (in)  PLOTS.4690
      real             lbsiz             ! for common block MLBDET               PLOTS.4691
      real             xn,               ! cone factor for projection   (local)  PLOTS.4692
     *                 x,                ! x position in grid of a pt.  (local)  PLOTS.4693
     *                 y,                ! y position in grid of a pt.  (local)  PLOTS.4694
     *                 flsv,             ! save variable                (local)  PLOTS.4695
     *                 frsv,             ! save variable                (local)  PLOTS.4696
     *                 fbsv,             ! save variable                (local)  PLOTS.4697
     *                 ftsv,             ! save variable                (local)  PLOTS.4698
     *                 ulsv,             ! left of map in user coords.  (local)  PLOTS.4699
     *                 ursv,             ! right of map in user coords. (local)  PLOTS.4700
     *                 ubsv,             ! bottom of map in user coords.(local)  PLOTS.4701
     *                 utsv,             ! top of map in user coords.   (local)  PLOTS.4702
     *                 ang               ! angle at which to draw plus  (local)  PLOTS.4703
                                                                                 PLOTS.4704
C  Common blocks                                                                 PLOTS.4705
                                                                                 PLOTS.4706
      common /mlbdet/  wlabs,            ! not used                              PLOTS.4707
     *                 lbsiz,            ! alternate label size                  PLOTS.4708
     *                 lbqul             ! not used                              PLOTS.4709
      common /lllcol/  llcolr            ! color of lat/lon lines                PLOTS.4710
                                                                                 PLOTS.4711
C****************************  subroutine begin  *****************************C  PLOTS.4712
                                                                                 PLOTS.4713
C  Set the user coords. up to mimic the grid                                     PLOTS.4714
                                                                                 PLOTS.4715
      call getset (flsv,frsv,fbsv,ftsv,ulsv,ursv,ubsv,utsv,llsv)                 PLOTS.4716
                                                                                 PLOTS.4717
C  Set up correct color for the ticks                                            PLOTS.4718
C  To understand what the quality of the letters has to do with the color        PLOTS.4719
C  read on page 2-14 in the NCAR Graphics Guide to New Utilities Version 3.00    PLOTS.4720
C  under the heading of PLOTCHAR                                                 PLOTS.4721
                                                                                 PLOTS.4722
      call pcseti ('QU',0)                                                       PLOTS.4723
      call gsplci (llcolr)                                                       PLOTS.4724
                                                                                 PLOTS.4725
C  Determin projection cone factor                                               PLOTS.4726
                                                                                 PLOTS.4727
      if (project(1:2) .eq. 'LC') then                                           PLOTS.4728
        xn = 0.716                                                               PLOTS.4729
      else if (project(1:2) .eq. 'ST') then                                      PLOTS.4730
        xn = 1.0                                                                 PLOTS.4731
      else                                                                       PLOTS.4732
        xn = 0.0                                                                 PLOTS.4733
      end if                                                                     PLOTS.4734
                                                                                 PLOTS.4735
C  Determine which lat/lons to start with                                        PLOTS.4736
                                                                                 PLOTS.4737
      stri = -180 + nmgr                                                         PLOTS.4738
      strj = -90  + nmgr                                                         PLOTS.4739
                                                                                 PLOTS.4740
C  Turn clipping on                                                              PLOTS.4741
                                                                                 PLOTS.4742
      call gsclip (1)                                                            PLOTS.4743
                                                                                 PLOTS.4744
C  Loop through every lat lon combo. with proper grid interval                   PLOTS.4745
                                                                                 PLOTS.4746
      do 10 i = stri,180,nmgr                                                    PLOTS.4747
        do 20 j = strj,90,nmgr                                                   PLOTS.4748
                                                                                 PLOTS.4749
C  Calculate the angle at which to draw the pluses                               PLOTS.4750
                                                                                 PLOTS.4751
          ang = (float(i) - cenlon) * xn                                         PLOTS.4752
                                                                                 PLOTS.4753
C  Change current lat/lon combo. to user coordinates                             PLOTS.4754
                                                                                 PLOTS.4755
          call maptrn (float(j),float(i),x,y)                                    PLOTS.4756
                                                                                 PLOTS.4757
C  Check to see if the point is within the viewport                              PLOTS.4758
                                                                                 PLOTS.4759
          if ((x .ge. ulsv) .and. (x .le. ursv) .and.                            PLOTS.4760
     *        (y .ge. ubsv) .and. (y .le. utsv)) then                            PLOTS.4761
                                                                                 PLOTS.4762
C  Draw a correct plus                                                           PLOTS.4763
                                                                                 PLOTS.4764
            call plchhq (x,y,'+',-lbsiz,ang,0)                                   PLOTS.4765
          end if                                                                 PLOTS.4766
20      continue                                                                 PLOTS.4767
10    continue                                                                   PLOTS.4768
                                                                                 PLOTS.4769
C  Turn clipping off                                                             PLOTS.4770
                                                                                 PLOTS.4771
      call gsclip (0)                                                            PLOTS.4772
                                                                                 PLOTS.4773
C*****************************  subroutine end  ******************************C  PLOTS.4774
                                                                                 PLOTS.4775
      return                                                                     PLOTS.4776
      end                                                                        PLOTS.4777
      subroutine search (whline,place,error)                                     PLOTS.4778
                                                                                 PLOTS.4779
C*****************************************************************************C  PLOTS.4780
C  search   - This is a CONDRV/MAPDRV routine                                 C  PLOTS.4781
C  Section  - Tables                                                          C  PLOTS.4782
C  Purpose  - This is  a tool to  read to the next  meaningful character in a C  PLOTS.4783
C             table.                                                          C  PLOTS.4784
C                                                                             C  PLOTS.4785
C  On entry - WHLINE contains a line of a table. PLACE contains the  position C  PLOTS.4786
C             from where to start looking.                                    C  PLOTS.4787
C                                                                             C  PLOTS.4788
C  On exit  - PLACE contains the  location of the first  meaningful character C  PLOTS.4789
C             within the string.  If no character was found ERROR is true.    C  PLOTS.4790
C                                                                             C  PLOTS.4791
C  Assume   - Nothing.                                                        C  PLOTS.4792
C                                                                             C  PLOTS.4793
C  Author   - Jeremy Asbill        Date - June 11, 1990      for the MM4 club C  PLOTS.4794
C*****************************************************************************C  PLOTS.4795
                                                                                 PLOTS.4796
C  Character Variables                                                           PLOTS.4797
                                                                                 PLOTS.4798
      character*80 whline      ! a line from a table                       (in)  PLOTS.4799
                                                                                 PLOTS.4800
C  Integer Variables                                                             PLOTS.4801
                                                                                 PLOTS.4802
      integer      place       ! position within WHLINE                    (in)  PLOTS.4803
                                                                                 PLOTS.4804
C  Logical Variables                                                             PLOTS.4805
                                                                                 PLOTS.4806
      logical      error       ! was there no character to find           (out)  PLOTS.4807
                                                                                 PLOTS.4808
C****************************  subroutine begin  *****************************C  PLOTS.4809
                                                                                 PLOTS.4810
C  Initialize ERROR                                                              PLOTS.4811
                                                                                 PLOTS.4812
      error = .false.                                                            PLOTS.4813
                                                                                 PLOTS.4814
C  Try to read to the first character                                            PLOTS.4815
                                                                                 PLOTS.4816
10    continue                                                                   PLOTS.4817
      if ((whline(place:place) .eq. ' ') .or.                                    PLOTS.4818
     *     (whline(place:place) .eq. '|')) then                                  PLOTS.4819
        place = place + 1                                                        PLOTS.4820
                                                                                 PLOTS.4821
C  Check to see if there is an error condition                                   PLOTS.4822
                                                                                 PLOTS.4823
        if (place .gt. 80) then                                                  PLOTS.4824
          error = .true.                                                         PLOTS.4825
          goto 20                                                                PLOTS.4826
        end if                                                                   PLOTS.4827
        goto 10                                                                  PLOTS.4828
      end if                                                                     PLOTS.4829
                                                                                 PLOTS.4830
C*****************************  subroutine end  ******************************C  PLOTS.4831
                                                                                 PLOTS.4832
20    return                                                                     PLOTS.4833
      end                                                                        PLOTS.4834
      subroutine setmap (cenlat,cenlon,project,grds,xpa,ypa,xpb,ypb,             PLOTS.4835
     *                   iend,jend)                                              PLOTS.4836
                                                                                 PLOTS.4837
C*****************************************************************************C  PLOTS.4838
C  setmap   - This is a MAPDRV routine                                        C  PLOTS.4839
C  Section  - Design                                                          C  PLOTS.4840
C  Purpose  - To match the grid and the  screen window with the domain on the C  PLOTS.4841
C             globe.                                                          C  PLOTS.4842
C                                                                             C  PLOTS.4843
C  On entry - CENLAT is the center latitude of the whole domain.   CENLON  is C  PLOTS.4844
C             the center longitude of the whole domain.  PROJECT is  the pro- C  PLOTS.4845
C             jection indicator.  GRDS is the grid  distance  in  kilometers. C  PLOTS.4846
C             XPA, YPA  are the lower  left grid point of the map.   XPB, YPB C  PLOTS.4847
C             are the upper right grid point of the map. IEND is the value of C  PLOTS.4848
C             the maximum grid point in the y direction.   JEND is the  value C  PLOTS.4849
C             of the maximum grid point in the x direction.                   C  PLOTS.4850
C                                                                             C  PLOTS.4851
C  On exit  - The domain has been set up with EZMAP.                          C  PLOTS.4852
C                                                                             C  PLOTS.4853
C  Assume   - GKS is open.                                                    C  PLOTS.4854
C                                                                             C  PLOTS.4855
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.4856
C             ----------------------------------------------------------------C  PLOTS.4857
C             MAPSET              EZMAP utility*                              C  PLOTS.4858
C             ----------------------------------------------------------------C  PLOTS.4859
C             * NCAR Graphics routine                                         C  PLOTS.4860
C                                                                             C  PLOTS.4861
C  Author   - Jeremy Asbill       Date - July 14, 1990       for the MM4 club C  PLOTS.4862
C*****************************************************************************C  PLOTS.4863
                                                                                 PLOTS.4864
C  Character varaibles                                                           PLOTS.4865
                                                                                 PLOTS.4866
      character*2      project           ! specifies projection            (in)  PLOTS.4867
                                                                                 PLOTS.4868
C  Integer variables                                                             PLOTS.4869
                                                                                 PLOTS.4870
      integer          iend,             ! max. y value of grids           (in)  PLOTS.4871
     *                 jend              ! max. x value of grids           (in)  PLOTS.4872
      integer          imax,             ! for common block XYLLON               PLOTS.4873
     *                 jmax              ! for common block XYLLON               PLOTS.4874
                                                                                 PLOTS.4875
C  Real variables                                                                PLOTS.4876
                                                                                 PLOTS.4877
      real             cenlat,           ! center latitude                 (in)  PLOTS.4878
     *                 cenlon,           ! center longitude                (in)  PLOTS.4879
     *                 grds,             ! grid distance in kilometers     (in)  PLOTS.4880
     *                 xpa,              ! x of lower left grid pt. in map (in)  PLOTS.4881
     *                 ypa,              ! y of lower left grid pt. in map (in)  PLOTS.4882
     *                 xpb,              ! x of upper right grd pt. in map (in)  PLOTS.4883
     *                 ypb               ! y of upper right grd pt. in map (in)  PLOTS.4884
      real             ds,               ! for common block XYLLON               PLOTS.4885
     *                 xlatc,            ! for common block XYLLON               PLOTS.4886
     *                 xlonc             ! for common block XYLLON               PLOTS.4887
      real             latl,             ! lower left latitude          (local)  PLOTS.4888
     *                 lonl,             ! lower left longitude         (local)  PLOTS.4889
     *                 latu,             ! upper right latitude         (local)  PLOTS.4890
     *                 lonu              ! upper right longitude        (local)  PLOTS.4891
                                                                                 PLOTS.4892
C  Common blocks                                                                 PLOTS.4893
                                                                                 PLOTS.4894
      common /xyllon/  ds,               ! grid distance in kilometers           PLOTS.4895
     *                 xlatc,            ! center latitude                       PLOTS.4896
     *                 xlonc,            ! center longitude                      PLOTS.4897
     *                 imax,             ! maximum vertical gird point           PLOTS.4898
     *                 jmax              ! maximum horizontal grid point         PLOTS.4899
                                                                                 PLOTS.4900
C****************************  subroutine begin  *****************************C  PLOTS.4901
                                                                                 PLOTS.4902
C  Set up to use XYTOLL                                                          PLOTS.4903
                                                                                 PLOTS.4904
      ds    = grds                                                               PLOTS.4905
      xlatc = cenlat                                                             PLOTS.4906
      xlonc = cenlon                                                             PLOTS.4907
      imax  = iend                                                               PLOTS.4908
      jmax  = jend                                                               PLOTS.4909
                                                                                 PLOTS.4910
C  Get the longitude and latitude                                                PLOTS.4911
                                                                                 PLOTS.4912
      call xytoll (xpa,ypa,latl,lonl,project)                                    PLOTS.4913
      call xytoll (xpb,ypb,latu,lonu,project)                                    PLOTS.4914
                                                                                 PLOTS.4915
C  Set up the domain with EZMAP                                                  PLOTS.4916
                                                                                 PLOTS.4917
      call mapset ('CO',latl,lonl,latu,lonu)                                     PLOTS.4918
                                                                                 PLOTS.4919
C*****************************  subroutine end  ******************************C  PLOTS.4920
                                                                                 PLOTS.4921
      return                                                                     PLOTS.4922
      end                                                                        PLOTS.4923
      subroutine setpro (project,cenlat,cenlon)                                  PLOTS.4924
                                                                                 PLOTS.4925
C*****************************************************************************C  PLOTS.4926
C  setpro   - This is a MAPDRV routine                                        C  PLOTS.4927
C  Section  - Design                                                          C  PLOTS.4928
C  Purpose  - To determine and set up the proper projection for the map.      C  PLOTS.4929
C                                                                             C  PLOTS.4930
C  On entry - PROJECT describes what  projection we are to use.   CENLAT  and C  PLOTS.4931
C             CENLON are the central latitude and longitude respectively.     C  PLOTS.4932
C                                                                             C  PLOTS.4933
C  On exit  - The correct projection has been set up.   XN  contains  a calc- C  PLOTS.4934
C             culation value needed by the routine  XYTOLL.                   C  PLOTS.4935
C                                                                             C  PLOTS.4936
C  Assume   - GKS is open.                                                    C  PLOTS.4937
C                                                                             C  PLOTS.4938
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.4939
C             ----------------------------------------------------------------C  PLOTS.4940
C             MAPPROJ             EZMAP utility*                              C  PLOTS.4941
C             ----------------------------------------------------------------C  PLOTS.4942
C             * NCAR Graphics routine                                         C  PLOTS.4943
C                                                                             C  PLOTS.4944
C  Author   - Jeremy Asbill        Date - July 6, 1990       for the MM4 club C  PLOTS.4945
C*****************************************************************************C  PLOTS.4946
                                                                                 PLOTS.4947
C  Character variables                                                           PLOTS.4948
                                                                                 PLOTS.4949
      character*2      project           ! specifies projection to use     (in)  PLOTS.4950
                                                                                 PLOTS.4951
C  Real variables                                                                PLOTS.4952
                                                                                 PLOTS.4953
      real             cenlat,           ! center latitude to use          (in)  PLOTS.4954
     *                 cenlon            ! center longitude to use         (in)  PLOTS.4955
      real             rotan,            ! rotation angle               (local)  PLOTS.4956
     *                 polat             ! polar latitude               (local)  PLOTS.4957
      real             confac,           ! for common block LAMSTF               PLOTS.4958
     *                 fsparl,           ! for common block LAMSTF               PLOTS.4959
     *                 ssparl            ! for common block LAMSTF               PLOTS.4960
                                                                                 PLOTS.4961
C  Common blocks                                                                 PLOTS.4962
                                                                                 PLOTS.4963
      common /lamstf/  confac,           ! not used                              PLOTS.4964
     *                 fsparl,           ! first standard parallel lat.          PLOTS.4965
     *                 ssparl            ! second standard parallel lat.         PLOTS.4966
                                                                                 PLOTS.4967
C****************************  subroutine begin  *****************************C  PLOTS.4968
                                                                                 PLOTS.4969
C  Lambert Conformal Projection - These values are either set to defaults        PLOTS.4970
C  or by the user, determined in INTERR.                                         PLOTS.4971
                                                                                 PLOTS.4972
      if (project .eq. 'LC') then                                                PLOTS.4973
        rotan = fsparl                                                           PLOTS.4974
        polat = ssparl                                                           PLOTS.4975
        print *, 'MAPDRV - Lambert Conformal Projection'                         PLOTS.4976
                                                                                 PLOTS.4977
C  Polar Stereographic Projection - The polar true latitude is either set to     PLOTS.4978
C  the default by the user or determined in INTERR.                              PLOTS.4979
                                                                                 PLOTS.4980
      else if (project .eq. 'ST') then                                           PLOTS.4981
        rotan = 0.0                                                              PLOTS.4982
        if (cenlat .gt. 0.0) then                                                PLOTS.4983
          polat = 90.0                                                           PLOTS.4984
        else                                                                     PLOTS.4985
          polat = -90.0                                                          PLOTS.4986
        end if                                                                   PLOTS.4987
        print *, 'MAPDRV - Polar Stereographic Projection'                       PLOTS.4988
                                                                                 PLOTS.4989
C  Cylindrical Equidistant                                                       PLOTS.4990
                                                                                 PLOTS.4991
      else if (project .eq. 'CE') then                                           PLOTS.4992
        rotan = 0.0                                                              PLOTS.4993
        polat = 0.0                                                              PLOTS.4994
        print *, 'MAPDRV - Cylindrical Equidistant Projection'                   PLOTS.4995
                                                                                 PLOTS.4996
C  MErcator                                                                      PLOTS.4997
                                                                                 PLOTS.4998
      else if (project .eq. 'ME') then                                           PLOTS.4999
        rotan = 0.0                                                              PLOTS.5000
        polat = 0.0                                                              PLOTS.5001
        print *, 'MAPDRV - Mercator Projection'                                  PLOTS.5002
      end if                                                                     PLOTS.5003
                                                                                 PLOTS.5004
C  Set up the projection                                                         PLOTS.5005
                                                                                 PLOTS.5006
      call maproj (project,polat,cenlon,rotan)                                   PLOTS.5007
                                                                                 PLOTS.5008
C*****************************  subroutine end  ******************************C  PLOTS.5009
                                                                                 PLOTS.5010
      return                                                                     PLOTS.5011
      end                                                                        PLOTS.5012
      subroutine setwin (xpa,ypa,xpb,ypb,doset)                                  PLOTS.5013
                                                                                 PLOTS.5014
C*****************************************************************************C  PLOTS.5015
C  setwin   - This is a MAPDRV routine                                        C  PLOTS.5016
C  Section  - Design                                                          C  PLOTS.5017
C  Purpose  - To set the map in a nice window on the screen.  That is the map C  PLOTS.5018
C             must allow room above and below it.                             C  PLOTS.5019
C                                                                             C  PLOTS.5020
C  On entry - XPA, YPA are the lower left hand corners of the map  within the C  PLOTS.5021
C             domain grid.  XPB, YPB are the  upper  right hand corner of the C  PLOTS.5022
C             map within the domain grid.  DOSET  indicates whether to make a C  PLOTS.5023
C             set call here or whether the user did it.                       C  PLOTS.5024
C                                                                             C  PLOTS.5025
C  On exit  - The proper window has been set.                                 C  PLOTS.5026
C                                                                             C  PLOTS.5027
C  Assume   - GKS is open.                                                    C  PLOTS.5028
C                                                                             C  PLOTS.5029
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.5030
C             ----------------------------------------------------------------C  PLOTS.5031
C             MAPPOS              EZMAP utility*                              C  PLOTS.5032
C             GETSET              SPPS*                                       C  PLOTS.5033
C             SET                 SPPS*                                       C  PLOTS.5034
C             ----------------------------------------------------------------C  PLOTS.5035
C             * NCAR Graphics routine                                         C  PLOTS.5036
C                                                                             C  PLOTS.5037
C  Author   - Jeremy Asbill       Date - July 11, 1990       for the MM4 club C  PLOTS.5038
C*****************************************************************************C  PLOTS.5039
                                                                                 PLOTS.5040
C  Integer varaibles                                                             PLOTS.5041
                                                                                 PLOTS.5042
      integer          llsv              ! junk filler                  (local)  PLOTS.5043
                                                                                 PLOTS.5044
C  Logical variables                                                             PLOTS.5045
                                                                                 PLOTS.5046
      logical          doset             ! do a set call here ?            (in)  PLOTS.5047
                                                                                 PLOTS.5048
C  Real variables                                                                PLOTS.5049
                                                                                 PLOTS.5050
      real             xpa,              ! left hand x coord of map        (in)  PLOTS.5051
     *                 ypa,              ! lower y coord of map            (in)  PLOTS.5052
     *                 xpb,              ! right hand x coord of map       (in)  PLOTS.5053
     *                 ypb               ! upper y coord of map            (in)  PLOTS.5054
      real             temp,             ! temporary test variable      (local)  PLOTS.5055
     *                 dumy,             ! dummy test variable          (local)  PLOTS.5056
     *                 test,             ! test variable                (local)  PLOTS.5057
     *                 flsv,             ! left window edge             (local)  PLOTS.5058
     *                 frsv,             ! right window edge            (local)  PLOTS.5059
     *                 fbsv,             ! bottom window edge           (local)  PLOTS.5060
     *                 ftsv,             ! top window edge              (local)  PLOTS.5061
     *                 ulsv,             ! junk filler                  (local)  PLOTS.5062
     *                 ursv,             ! junk filler                  (local)  PLOTS.5063
     *                 ubsv,             ! junk filler                  (local)  PLOTS.5064
     *                 utsv              ! junk filler                  (local)  PLOTS.5065
                                                                                 PLOTS.5066
C****************************  subroutine begin  *****************************C  PLOTS.5067
                                                                                 PLOTS.5068
C  Set up variables to test on                                                   PLOTS.5069
C  TEMP will represent the maps width                                            PLOTS.5070
C  DUMY will represent the maps height                                           PLOTS.5071
                                                                                 PLOTS.5072
      temp = ypb - ypa + 1.0                                                     PLOTS.5073
      dumy = (xpb - xpa + 1.0) * 0.9                                             PLOTS.5074
                                                                                 PLOTS.5075
C  Check to see if we have control over the set call                             PLOTS.5076
                                                                                 PLOTS.5077
      if (doset) then                                                            PLOTS.5078
                                                                                 PLOTS.5079
C  If the map is almost sqare or is taller than it is wide, guarantee at least   PLOTS.5080
C  10% of the scren on the top and bottom.                                       PLOTS.5081
C  Otherwise, guarantee ourselves at least 5% on the top and bottom              PLOTS.5082
                                                                                 PLOTS.5083
        if (temp .ge. dumy) then                                                 PLOTS.5084
          call mappos (0.1,0.9,0.1,0.9)                                          PLOTS.5085
        else                                                                     PLOTS.5086
          call mappos (0.05,0.95,0.05,0.95)                                      PLOTS.5087
        end if                                                                   PLOTS.5088
      else                                                                       PLOTS.5089
                                                                                 PLOTS.5090
C  We don't have control over the set, do it like the user wants                 PLOTS.5091
                                                                                 PLOTS.5092
        call getset (flsv,frsv,fbsv,ftsv,ursv,ulsv,ubsv,utsv,llsv)               PLOTS.5093
                                                                                 PLOTS.5094
C  Adjust to use the proper percentage of the domain by the same tests as        PLOTS.5095
C  we would if a set call had not been made                                      PLOTS.5096
                                                                                 PLOTS.5097
        if (temp .ge. dumy) then                                                 PLOTS.5098
          test = 0.1 * (frsv - flsv)                                             PLOTS.5099
          frsv = frsv - test                                                     PLOTS.5100
          flsv = flsv + test                                                     PLOTS.5101
          test = 0.1 * (ftsv - fbsv)                                             PLOTS.5102
          ftsv = ftsv - test                                                     PLOTS.5103
          fbsv = fbsv + test                                                     PLOTS.5104
        else                                                                     PLOTS.5105
          test = 0.05 * (frsv - flsv)                                            PLOTS.5106
          frsv = frsv - test                                                     PLOTS.5107
          flsv = flsv + test                                                     PLOTS.5108
          test = 0.05 * (ftsv - fbsv)                                            PLOTS.5109
          ftsv = ftsv - test                                                     PLOTS.5110
          fbsv = fbsv + test                                                     PLOTS.5111
        end if                                                                   PLOTS.5112
                                                                                 PLOTS.5113
C  Set up the users set call with EZMAP                                          PLOTS.5114
                                                                                 PLOTS.5115
        call set (0.0,1.0,0.0,1.0,0.0,1.0,0.0,1.0,1)                             PLOTS.5116
        call mappos (flsv,frsv,fbsv,ftsv)                                        PLOTS.5117
      end if                                                                     PLOTS.5118
                                                                                 PLOTS.5119
C*****************************  subroutine end  ******************************C  PLOTS.5120
                                                                                 PLOTS.5121
      return                                                                     PLOTS.5122
      end                                                                        PLOTS.5123
      subroutine tbllok (unum,tabnam,errsev,there,whline,util)                   PLOTS.5124
                                                                                 PLOTS.5125
C*****************************************************************************C  PLOTS.5126
C  tbllok   - This is a MAPDRV/CONDRV routine                                 C  PLOTS.5127
C  Section  - Tables                                                          C  PLOTS.5128
C  Purpose  - To check and see if the requested table is there and place  the C  PLOTS.5129
C             file pointer to the first information line in the table.        C  PLOTS.5130
C                                                                             C  PLOTS.5131
C  On entry - UNUM is the unit number of the table file.  TABNAM cantains the C  PLOTS.5132
C             name of the table to check for.   ERRSEV  is the error severity C  PLOTS.5133
C             indicator.                                                      C  PLOTS.5134
C                                                                             C  PLOTS.5135
C  On exit  - THERE tells the calling routine  whether the table is  there or C  PLOTS.5136
C             is there or not.  WHLINE is the first information line from the C  PLOTS.5137
C             table.                                                          C  PLOTS.5138
C                                                                             C  PLOTS.5139
C  Assume   - Nothing.                                                        C  PLOTS.5140
C                                                                             C  PLOTS.5141
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.5142
C             ----------------------------------------------------------------C  PLOTS.5143
C             ERRHAN              MAPDRV/CONDRV utility                       C  PLOTS.5144
C             ----------------------------------------------------------------C  PLOTS.5145
C             * NCAR Graphics routine                                         C  PLOTS.5146
C                                                                             C  PLOTS.5147
C  Author   - Jeremy Asbill       Date - July 13, 1990       for the MM4 club C  PLOTS.5148
C*****************************************************************************C  PLOTS.5149
                                                                                 PLOTS.5150
C  Character variables                                                           PLOTS.5151
                                                                                 PLOTS.5152
      character*10     tabnam            ! name of the table to look for   (in)  PLOTS.5153
      character*6      util              ! name of utility calling TBLLOK  (in)  PLOTS.5154
      character*80     whline            ! line from the table            (out)  PLOTS.5155
      character*60     ermes             ! error/warning message        (local)  PLOTS.5156
                                                                                 PLOTS.5157
C  Integer variables                                                             PLOTS.5158
                                                                                 PLOTS.5159
      integer          unum,             ! unit number of table file       (in)  PLOTS.5160
     *                 errsev            ! error severity indicator        (in)  PLOTS.5161
      integer          start,            ! char. in ERMES to start      (local)  PLOTS.5162
     *                 i                 ! loop counter/place keeper    (local)  PLOTS.5163
                                                                                 PLOTS.5164
C  Logical variables                                                             PLOTS.5165
                                                                                 PLOTS.5166
      logical          there             ! is the table there ?           (out)  PLOTS.5167
                                                                                 PLOTS.5168
C****************************  subroutine begin  *****************************C  PLOTS.5169
                                                                                 PLOTS.5170
C  Prepare ERMES in case of an error                                             PLOTS.5171
                                                                                 PLOTS.5172
      if (tabnam(1:10) .eq. 'MAP DETAIL') then                                   PLOTS.5173
        ermes(1:23) = 'Reading Details Table, '                                  PLOTS.5174
        start = 24                                                               PLOTS.5175
      else if (tabnam(1:10) .eq. 'MAP FILL  ') then                              PLOTS.5176
        ermes(1:20) = 'Reading Fill Table, '                                     PLOTS.5177
        start = 21                                                               PLOTS.5178
      else if (tabnam(1:10) .eq. 'CON DETAIL') then                              PLOTS.5179
        ermes(1:23) = 'Reading Details Table, '                                  PLOTS.5180
        start = 24                                                               PLOTS.5181
      else                                                                       PLOTS.5182
        ermes(1:21) = 'Reading Color Table, '                                    PLOTS.5183
        start = 22                                                               PLOTS.5184
      end if                                                                     PLOTS.5185
                                                                                 PLOTS.5186
C  If UNUM is negative then it is assumed that the table is not there            PLOTS.5187
                                                                                 PLOTS.5188
      if (unum .lt. 0) then                                                      PLOTS.5189
        there = .false.                                                          PLOTS.5190
      else                                                                       PLOTS.5191
C  It is expected that each table be preceded by three lines:                    PLOTS.5192
C  Line 1 - Anything                                                             PLOTS.5193
C  Line 2 - Table Title                                                          PLOTS.5194
C  Line 3 - Anything                                                             PLOTS.5195
C  Line 4 - Anything                                                             PLOTS.5196
                                                                                 PLOTS.5197
C  Line 1 -                                                                      PLOTS.5198
C  Try to read from the file,                                                    PLOTS.5199
C  if EOF the table is not there                                                 PLOTS.5200
                                                                                 PLOTS.5201
        read (unum,10,end=20,err=30) whline(1:1)                                 PLOTS.5202
                                                                                 PLOTS.5203
C  Line 2 -                                                                      PLOTS.5204
C  if EOF then give a warning                                                    PLOTS.5205
                                                                                 PLOTS.5206
        read (unum,100,end=50,err=30) whline(1:80)                               PLOTS.5207
                                                                                 PLOTS.5208
C  Check if this is the table we are looking for                                 PLOTS.5209
                                                                                 PLOTS.5210
        i = 1                                                                    PLOTS.5211
70      continue                                                                 PLOTS.5212
        if (whline(i:i) .eq. ' ') then                                           PLOTS.5213
          i = i + 1                                                              PLOTS.5214
          if (i .gt. 73) then                                                    PLOTS.5215
                                                                                 PLOTS.5216
C  No title was found on the line where it was expected                          PLOTS.5217
                                                                                 PLOTS.5218
            ermes(start:start+33) = 'Table Title Expected But Not Found'         PLOTS.5219
            do 80 i = start+34,60                                                PLOTS.5220
              ermes(i:i) = ' '                                                   PLOTS.5221
80          continue                                                             PLOTS.5222
            call errhan (util,0,ermes,errsev)                                    PLOTS.5223
            goto 20                                                              PLOTS.5224
          end if                                                                 PLOTS.5225
          goto 70                                                                PLOTS.5226
        end if                                                                   PLOTS.5227
                                                                                 PLOTS.5228
C  A title was found on the line                                                 PLOTS.5229
                                                                                 PLOTS.5230
        if (whline(i:i+9) .ne. tabnam(1:10)) then                                PLOTS.5231
                                                                                 PLOTS.5232
C  The title found was not the one we wanted                                     PLOTS.5233
                                                                                 PLOTS.5234
          backspace (unum)                                                       PLOTS.5235
          backspace (unum)                                                       PLOTS.5236
          goto 20                                                                PLOTS.5237
        end if                                                                   PLOTS.5238
                                                                                 PLOTS.5239
C  Line 3 & 4 -                                                                  PLOTS.5240
C  The title found was the one we wanted, read up to the infformation            PLOTS.5241
                                                                                 PLOTS.5242
        read (unum,10,end=50,err=30) whline(1:1)                                 PLOTS.5243
        read (unum,10,end=50,err=30) whline(1:1)                                 PLOTS.5244
                                                                                 PLOTS.5245
C  Read in the first information line                                            PLOTS.5246
                                                                                 PLOTS.5247
        read (unum,100,end=50,err=30) whline(1:80)                               PLOTS.5248
                                                                                 PLOTS.5249
C  Let the calling routine know the table is there                               PLOTS.5250
                                                                                 PLOTS.5251
        there = .true.                                                           PLOTS.5252
        goto 90                                                                  PLOTS.5253
                                                                                 PLOTS.5254
C  Warnings                                                                      PLOTS.5255
                                                                                 PLOTS.5256
50      ermes(start:start+29) = 'Unexpected End Of File Reached'                 PLOTS.5257
        do 60 i = start+30,60                                                    PLOTS.5258
          ermes(i:i) = ' '                                                       PLOTS.5259
60      continue                                                                 PLOTS.5260
        call errhan (util,0,ermes,errsev)                                        PLOTS.5261
        goto 20                                                                  PLOTS.5262
                                                                                 PLOTS.5263
C  Errors                                                                        PLOTS.5264
                                                                                 PLOTS.5265
30      ermes(start:start+25) = 'Possibly A Bad Unit Number'                     PLOTS.5266
        do 40 i = start+26,60                                                    PLOTS.5267
          ermes(i:i) = ' '                                                       PLOTS.5268
40      continue                                                                 PLOTS.5269
        call errhan (util,1,ermes,errsev)                                        PLOTS.5270
20      there = .false.                                                          PLOTS.5271
      end if                                                                     PLOTS.5272
                                                                                 PLOTS.5273
C*****************************  subroutine end  ******************************C  PLOTS.5274
                                                                                 PLOTS.5275
C  Format statements begin ...                                                   PLOTS.5276
                                                                                 PLOTS.5277
10    format (A1)                                                                PLOTS.5278
100   format (A80)                                                               PLOTS.5279
                                                                                 PLOTS.5280
C  Format statements end.                                                        PLOTS.5281
                                                                                 PLOTS.5282
90    return                                                                     PLOTS.5283
      end                                                                        PLOTS.5284
      subroutine xytoll (j,i,lat,lon,project)                                    PLOTS.5285
                                                                                 PLOTS.5286
C*****************************************************************************C  PLOTS.5287
C  xytoll   - This is a MAPDRV routine                                        C  PLOTS.5288
C  Section  - Labels                                                          C  PLOTS.5289
C  Purpose  - To  transform  mesoscale gird point coordinates into  latitude, C  PLOTS.5290
C             longitude coordinates.                                          C  PLOTS.5291
C                                                                             C  PLOTS.5292
C  On entry - J  and  I are an ordered pair representing a grid point in  the C  PLOTS.5293
C             mesoscale grid.  XYLLON is a common block that contains the in- C  PLOTS.5294
C             formation necessary for describing the domain.                  C  PLOTS.5295
C                                                                             C  PLOTS.5296
C  On exit  - LAT, LON contain  the latitude and longitude respectively  that C  PLOTS.5297
C             resulted from the transformation.                               C  PLOTS.5298
C                                                                             C  PLOTS.5299
C  Assume   - Nothing.                                                        C  PLOTS.5300
C                                                                             C  PLOTS.5301
C  Notes    - The formula's used in this routine were taken from the  PROGRAM C  PLOTS.5302
C             TERRAIN DOCUMENTATION AND USER'S GUIDE.                         C  PLOTS.5303
C                                                                             C  PLOTS.5304
C  Author   - Jeremy Asbill   Date - September 17, 1990      for the MM4 club C  PLOTS.5305
C*****************************************************************************C  PLOTS.5306
                                                                                 PLOTS.5307
C  Parameters                                                                    PLOTS.5308
                                                                                 PLOTS.5309
      parameter       (pi = 3.14159265)  ! you know!  pi = 180 degrees           PLOTS.5310
      parameter       (re = 6370.)       ! the radius of the earth in km         PLOTS.5311
      parameter       (ce = 40029.85315) ! the circumference of the earth in km  PLOTS.5312
                                                                                 PLOTS.5313
C  Character variables                                                           PLOTS.5314
                                                                                 PLOTS.5315
      character*2      project           ! projection indicator            (in)  PLOTS.5316
                                                                                 PLOTS.5317
C  Integer variables                                                             PLOTS.5318
                                                                                 PLOTS.5319
      integer          imax,             ! for common block XYLLON               PLOTS.5320
     *                 jmax              ! for common block XYLLON               PLOTS.5321
                                                                                 PLOTS.5322
C  Real variables                                                                PLOTS.5323
                                                                                 PLOTS.5324
      real             j,                ! x coord. to be changed          (in)  PLOTS.5325
     *                 i                 ! y coord. to be changed          (in)  PLOTS.5326
      real             lat,              ! resulting latitude             (out)  PLOTS.5327
     *                 lon               ! resulting longitude            (out)  PLOTS.5328
      real             grds,             ! for common block XYLLON               PLOTS.5329
     *                 clat,             ! for common block XYLLON               PLOTS.5330
     *                 clon              ! for common block XYLLON               PLOTS.5331
      real             confac,           ! for common block LAMSTF               PLOTS.5332
     *                 fsparl,           ! for common block LAMSTF               PLOTS.5333
     *                 ssparl            ! for common block LAMSTF               PLOTS.5334
      real             rcln,             ! center longitude in radians  (local)  PLOTS.5335
     *                 rclt,             ! center latitude in radians   (local)  PLOTS.5336
     *                 cj,               ! center x coord. for grid     (local)  PLOTS.5337
     *                 ci,               ! center y coord. for grid     (local)  PLOTS.5338
     *                 dj,               ! distance from the central             PLOTS.5339
C                                          meridian to the point        (local)  PLOTS.5340
     *                 di,               ! distance from pole to point  (local)  PLOTS.5341
     *                 bm                ! calculation variable         (local)  PLOTS.5342
                                                                                 PLOTS.5343
C  Common blocks                                                                 PLOTS.5344
                                                                                 PLOTS.5345
      common /xyllon/  grds,             ! grid distance in kilometers           PLOTS.5346
     *                 clat,             ! center latitude                       PLOTS.5347
     *                 clon,             ! center longitude                      PLOTS.5348
     *                 imax,             ! maximum vertical gird point           PLOTS.5349
     *                 jmax              ! maximum horizontal grid point         PLOTS.5350
      common /lamstf/  confac,           ! cone factor to be used                PLOTS.5351
     *                 fsparl,           ! first standard parallel lat.          PLOTS.5352
     *                 ssparl            ! second standard parallel lat.         PLOTS.5353
                                                                                 PLOTS.5354
C****************************  subroutine begin  *****************************C  PLOTS.5355
                                                                                 PLOTS.5356
C  Convert the center latitude and longitude of the domain to radians            PLOTS.5357
                                                                                 PLOTS.5358
      rclt = clat * pi/180.0                                                     PLOTS.5359
      rcln = clon * pi/180.0                                                     PLOTS.5360
                                                                                 PLOTS.5361
C  Find the center values of the grid in mesoscale grid coordinates              PLOTS.5362
                                                                                 PLOTS.5363
      cj = float(jmax + 1) * 0.5                                                 PLOTS.5364
      ci = float(imax + 1) * 0.5                                                 PLOTS.5365
                                                                                 PLOTS.5366
C  Calculate the distance from the vertical axis to (J,I)                        PLOTS.5367
                                                                                 PLOTS.5368
      dj = (j - cj) * grds                                                       PLOTS.5369
                                                                                 PLOTS.5370
C  The rest is figured out differently for each type of projection, so ...       PLOTS.5371
C  If the projection is mercator ('ME') then ...                                 PLOTS.5372
                                                                                 PLOTS.5373
      if (project(1:2) .eq. 'ME') then                                           PLOTS.5374
                                                                                 PLOTS.5375
C  Calculate the distance the point in question is from the pole                 PLOTS.5376
                                                                                 PLOTS.5377
        di = -re * log(cos(rclt)/(1 + sin(rclt))) +                              PLOTS.5378
     *       (i - ci) * grds                                                     PLOTS.5379
                                                                                 PLOTS.5380
C  Calculate the latitude desired in radians                                     PLOTS.5381
                                                                                 PLOTS.5382
        lat = 2.0 * atan(exp(di/re)) - pi * 0.5                                  PLOTS.5383
                                                                                 PLOTS.5384
C  Calculate the longitude desired in radians                                    PLOTS.5385
                                                                                 PLOTS.5386
        lon = rcln + dj/re                                                       PLOTS.5387
                                                                                 PLOTS.5388
C  If the projection is cylindrical equidistant ('CE') then ...                  PLOTS.5389
                                                                                 PLOTS.5390
      else if (project(1:2) .eq. 'CE') then                                      PLOTS.5391
                                                                                 PLOTS.5392
C  Calculate the distance from the horizontal axis to (J,I)                      PLOTS.5393
                                                                                 PLOTS.5394
        di = (i - ci) * grds                                                     PLOTS.5395
                                                                                 PLOTS.5396
C  Determine the shift north-south                                               PLOTS.5397
                                                                                 PLOTS.5398
        lat = rclt + (pi * di/(ce * 0.5))                                        PLOTS.5399
                                                                                 PLOTS.5400
C  Determine the shift east-west                                                 PLOTS.5401
                                                                                 PLOTS.5402
        lon = rcln + (2 * pi * dj/ce)                                            PLOTS.5403
                                                                                 PLOTS.5404
C  If the projection is lambert conic conformal ('LC') then ...                  PLOTS.5405
                                                                                 PLOTS.5406
      else if (project(1:2) .eq. 'LC') then                                      PLOTS.5407
                                                                                 PLOTS.5408
C  Calculate the distance from the pole to J,I                                   PLOTS.5409
                                                                                 PLOTS.5410
        if (clat .ge. 0.0) then                                                  PLOTS.5411
          di = -re/confac * sin(pi * 0.5 - (fsparl * pi/180.0)) *                PLOTS.5412
     *         (tan((pi * 0.5 - rclt) * 0.5) /                                   PLOTS.5413
     *          tan((pi * 0.5 - (fsparl * pi/180.0)) * 0.5))**confac +           PLOTS.5414
     *         (i - ci) * grds                                                   PLOTS.5415
        else                                                                     PLOTS.5416
          di = -re/confac * sin(-pi * 0.5 - (fsparl * pi/180.0)) *               PLOTS.5417
     *         (tan((-pi * 0.5 - rclt) * 0.5) /                                  PLOTS.5418
     *          tan((-pi * 0.5 - (fsparl * pi/180.0)) * 0.5))**confac +          PLOTS.5419
     *         (i - ci) * grds                                                   PLOTS.5420
        end if                                                                   PLOTS.5421
                                                                                 PLOTS.5422
C  Calculate out the Big Messy equation refered to as c1 in the document         PLOTS.5423
C  from which this formula was taken                                             PLOTS.5424
                                                                                 PLOTS.5425
        bm = tan((pi * 0.5 - abs(fsparl * pi/180.0))/2.0) *                      PLOTS.5426
     *       (confac/re * sqrt(dj**2 + di**2) /                                  PLOTS.5427
     *        sin(pi * 0.5 - abs(fsparl * pi/180.0)))**(1.0/confac)              PLOTS.5428
                                                                                 PLOTS.5429
C  Calculate the desired latitude in radians                                     PLOTS.5430
                                                                                 PLOTS.5431
        if (clat .ge. 0.0) then                                                  PLOTS.5432
          lat = pi * 0.5 - 2.0 * atan(bm)                                        PLOTS.5433
        else                                                                     PLOTS.5434
          lat = -pi * 0.5 + 2.0 * atan(bm)                                       PLOTS.5435
        end if                                                                   PLOTS.5436
                                                                                 PLOTS.5437
C  Calculate the desired longitude in radians                                    PLOTS.5438
                                                                                 PLOTS.5439
        if (clat .ge. 0.0) then                                                  PLOTS.5440
          lon = rcln + (1.0/confac) * atan2(dj,-di)                              PLOTS.5441
        else                                                                     PLOTS.5442
          lon = rcln + (1.0/confac) * atan2(dj,di)                               PLOTS.5443
        end if                                                                   PLOTS.5444
                                                                                 PLOTS.5445
C  If the projection is polar stereographic ('ST') then ...                      PLOTS.5446
                                                                                 PLOTS.5447
      else if (project(1:2) .eq. 'ST') then                                      PLOTS.5448
                                                                                 PLOTS.5449
C  Calculate the distance J,I lies from the "true" point                         PLOTS.5450
                                                                                 PLOTS.5451
        if (clat .gt. 0.0) then                                                  PLOTS.5452
          di = -re * sin(pi * 0.5 - rclt) *                                      PLOTS.5453
     *         (1.0 + cos(pi * 0.5 - (fsparl * pi/180.0))) /                     PLOTS.5454
     *         (1.0 + cos(pi * 0.5 - rclt)) +                                    PLOTS.5455
     *         (i - ci) * grds                                                   PLOTS.5456
        else                                                                     PLOTS.5457
          di = -re * sin(-pi * 0.5 - rclt) *                                     PLOTS.5458
     *         (1.0 + cos(-pi * 0.5 - (fsparl * pi/180.0))) /                    PLOTS.5459
     *         (1.0 + cos(-pi * 0.5 - rclt)) +                                   PLOTS.5460
     *         (i - ci) * grds                                                   PLOTS.5461
        end if                                                                   PLOTS.5462
                                                                                 PLOTS.5463
C  Calculate the Big Messy quantity as would be done, for lambert conformal      PLOTS.5464
C  projections.  This quantity is different in value, same in purpose of         PLOTS.5465
C  BM above                                                                      PLOTS.5466
                                                                                 PLOTS.5467
        if (clat .ge. 0.0) then                                                  PLOTS.5468
          bm = (1/re) * sqrt(dj**2 + di**2) /                                    PLOTS.5469
     *         (1.0 + cos(pi * 0.5 - (fsparl * pi/180.0)))                       PLOTS.5470
        else                                                                     PLOTS.5471
          bm = (1/re) * sqrt(dj**2 + di**2) /                                    PLOTS.5472
     *         (1.0 + cos(-pi * 0.5 - (fsparl * pi/180.0)))                      PLOTS.5473
        end if                                                                   PLOTS.5474
                                                                                 PLOTS.5475
C  Calculate the desired latitude in radians                                     PLOTS.5476
                                                                                 PLOTS.5477
        if (clat .ge. 0.0) then                                                  PLOTS.5478
          lat = pi * 0.5 - 2.0 * atan(bm)                                        PLOTS.5479
        else                                                                     PLOTS.5480
          lat = -pi * 0.5 + 2.0 * atan(bm)                                       PLOTS.5481
        end if                                                                   PLOTS.5482
                                                                                 PLOTS.5483
C  Calculate the desired longitude in radians                                    PLOTS.5484
                                                                                 PLOTS.5485
        if (clat .ge. 0.0) then                                                  PLOTS.5486
          lon = rcln + atan2(dj,-di)                                             PLOTS.5487
        else                                                                     PLOTS.5488
          lon = rcln + atan2(dj,di)                                              PLOTS.5489
        end if                                                                   PLOTS.5490
      end if                                                                     PLOTS.5491
                                                                                 PLOTS.5492
C  Convert the calculated lat,lon pair into degrees                              PLOTS.5493
                                                                                 PLOTS.5494
      lat = lat * 180.0/pi                                                       PLOTS.5495
      lon = lon * 180.0/pi                                                       PLOTS.5496
                                                                                 PLOTS.5497
C  Make sure no values are greater than 180 degrees and none                     PLOTS.5498
C  are less than -180 degrees                                                    PLOTS.5499
                                                                                 PLOTS.5500
      if (lon .gt. 180.0)  lon = lon - 360.0                                     PLOTS.5501
      if (lon .lt. -180.0) lon = lon + 360.0                                     PLOTS.5502
                                                                                 PLOTS.5503
C*****************************  Subroutine End  ******************************C  PLOTS.5504
                                                                                 PLOTS.5505
      return                                                                     PLOTS.5506
      end                                                                        PLOTS.5507
      subroutine condrv (indata,xdim,ydim,xstr,ystr,xend,yend,pnum,              PLOTS.5508
     *                   lmeth,levels,zl,mask,scale,title,tsize,unum,            PLOTS.5509
     *                   doset,errsev)                                           PLOTS.5510
                                                                                 PLOTS.5511
C*****************************************************************************C  PLOTS.5512
C  condrv   - Contour Driver                                                  C  PLOTS.5513
C                                                                             C  PLOTS.5514
C  Purpose  - This utility is intended as an interface to the CONPACK utility C  PLOTS.5515
C             in NCAR Graphics.   For reference to that utility look to  NCAR C  PLOTS.5516
C             Graphics Guide to New Utilities in the Contours section.   This C  PLOTS.5517
C             utility will allow the user to access all of the  power  of the C  PLOTS.5518
C             CONPACK utility through one call to this routine.  Data direct- C  PLOTS.5519
C             ives for this routine are passed in as  parameters and graphics C  PLOTS.5520
C             directives are read in from a table file.  This utility  should C  PLOTS.5521
C             be one hundred percent general and completely portable.         C  PLOTS.5522
C                                                                             C  PLOTS.5523
C  On entry - INDATA contains the data to be plotted.   XDIM and YDIM are the C  PLOTS.5524
C             x and y dimensions of  INDATA.   XSTR and  YSTR are the x and y C  PLOTS.5525
C             grid point at which to start plotting (lower left).    XEND and C  PLOTS.5526
C             YEND are the x and y grid point at which to quit plotting  (up- C  PLOTS.5527
C             per right).   PNUM contains the number that denotes which over- C  PLOTS.5528
C             this plot is.  LMETH specifies the method to use when determin- C  PLOTS.5529
C             ing contour levels.  Choices for LMETH are:                     C  PLOTS.5530
C             LMETH = 0  : CONDRV picks everything, defaults.   LEVELS is ig- C  PLOTS.5531
C               nored.                                                        C  PLOTS.5532
C             LMETH = -1 : A contour interval is given to use between a given C  PLOTS.5533
C               contour minimum and a given contour maximum. LEVELS(1) is the C  PLOTS.5534
C               contour  interval.    LEVELS(2)  is the contour  maximum  and C  PLOTS.5535
C               LEVELS(3) is the contour minimum.                             C  PLOTS.5536
C             LMETH = -2 : A contour interval is specified, CONDRV picks  the C  PLOTS.5537
C               contour minimum and maximum.   LEVELS(1) is that contour  in- C  PLOTS.5538
C               terval.                                                       C  PLOTS.5539
C             LMETH > 0  : LMETH is the number of levels the user wants.      C  PLOTS.5540
C               LEVELS is ignored.                                            C  PLOTS.5541
C             LMETH < -2 : ABS(LMETH) - 2 is  the  number of  levels the user C  PLOTS.5542
C               wants.  Each level is specified individually in LEVELS.       C  PLOTS.5543
C             ZL indicates whether a zero line should appear  on the plot  or C  PLOTS.5544
C             not.  SCALE is a scale factor to use when labeling the contours C  PLOTS.5545
C             and  TITLE  is the title string for the picture.   TSIZE is the C  PLOTS.5546
C             number of characters in TITLE.  If  TSIZE  is negative the con- C  PLOTS.5547
C             tour minimum, maximum and interval will be used as a title.  If C  PLOTS.5548
C             TSIZE is zero no title will be drawn.  UNUM is the unit  number C  PLOTS.5549
C             where the information tables may be found if UNUM is  positive. C  PLOTS.5550
C             If UNUM is negative, then no tables are to be used and defaults C  PLOTS.5551
C             are used.  If UNUM is 0 then the settings made by the last read C  PLOTS.5552
C             through tables should be used.  DOSET = 1 if CONDRV should make C  PLOTS.5553
C             the set call for the plot and is 0  if it should use the user's C  PLOTS.5554
C             set call and is -1  if it should make the set call  considering C  PLOTS.5555
C             cross points.   ERRSEV indicates what severity of  error should C  PLOTS.5556
C             halt CONDRV execution.                                          C  PLOTS.5557
C               ERRSEV > 0 means, nothing stops execution                     C  PLOTS.5558
C               ERRSEV = 0 means, errors stop execution, warnings do not      C  PLOTS.5559
C               ERRSEV < 0 means, both errors and warnings stop execution.    C  PLOTS.5560
C             MASK indicates if a map mask is to be made when contouring.  In C  PLOTS.5561
C             other words, if MASK is :                                       C  PLOTS.5562
C               NO - the contouring will be done like normal.                 C  PLOTS.5563
C               LO - contouring will be done over the land only               C  PLOTS.5564
C               LL - contouring will be done over the land and lakes          C  PLOTS.5565
C               OO - contouring will be done over the oceans only             C  PLOTS.5566
C               OL - contouring will be done over all water bodies.           C  PLOTS.5567
C             If MASK is not NO the MAPDRV must be called before CONDRV.      C  PLOTS.5568
C                                                                             C  PLOTS.5569
C  On exit  - A nice contour plot has been drawn to a CGM file including, all C  PLOTS.5570
C             requested labels and a title.                                   C  PLOTS.5571
C                                                                             C  PLOTS.5572
C  Assume   - GKS is open.  A color table has been defined.                   C  PLOTS.5573
C                                                                             C  PLOTS.5574
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.5575
C             ----------------------------------------------------------------C  PLOTS.5576
C             INTERC              CONDRV utility                              C  PLOTS.5577
C             CRDDET              CONDRV utility                              C  PLOTS.5578
C             CRDCLT              CONDRV utility                              C  PLOTS.5579
C             CRDPRT              CONDRV utility                              C  PLOTS.5580
C             CSETWN              CONDRV utility                              C  PLOTS.5581
C             SETCON              CONDRV utility                              C  PLOTS.5582
C             SUBCON              CONDRV utility                              C  PLOTS.5583
C             CSETCL              CONDRV utility                              C  PLOTS.5584
C             CPSETR              CONPACK utility*                            C  PLOTS.5585
C             CONFIL              CONDRV utility                              C  PLOTS.5586
C             CONDRW              CONDRV utility                              C  PLOTS.5587
C             SETLIN              CONDRV utility                              C  PLOTS.5588
C             CONLBL              CONDRV utility                              C  PLOTS.5589
C             ----------------------------------------------------------------C  PLOTS.5590
C             * NCAR Graphics routine                                         C  PLOTS.5591
C                                                                             C  PLOTS.5592
C  Author   - Jeremy Asbill       Date - June 5, 1990       for the MM4 club  C  PLOTS.5593
C*****************************************************************************C  PLOTS.5594
                                                                                 PLOTS.5595
C  Character variables                                                           PLOTS.5596
                                                                                 PLOTS.5597
      character*120    title             ! title string for plot           (in)  PLOTS.5598
      character*2      mask              ! map masking indicator           (in)  PLOTS.5599
      character*2      cmask             ! changeable version of MASK   (local)  PLOTS.5600
                                                                                 PLOTS.5601
C  Integer variables                                                             PLOTS.5602
                                                                                 PLOTS.5603
      integer          xdim,             ! the x dimension of INDATA       (in)  PLOTS.5604
     *                 xend,             ! x coord. of last grid point     (in)  PLOTS.5605
     *                 xstr,             ! x coord. of first grid point    (in)  PLOTS.5606
     *                 ydim,             ! the y dimension of INDATA       (in)  PLOTS.5607
     *                 yend,             ! y coord. of last grid point     (in)  PLOTS.5608
     *                 ystr,             ! y coord. of first grid point    (in)  PLOTS.5609
     *                 pnum,             ! number of overlays current      (in)  PLOTS.5610
     *                 lmeth,            ! method of level specification   (in)  PLOTS.5611
     *                 tsize,            ! # of characters in TITLE        (in)  PLOTS.5612
     *                 unum,             ! unit number of info. files      (in)  PLOTS.5613
     *                 doset,            ! set call indicator              (in)  PLOTS.5614
     *                 errsev            ! error severity comparitor       (in)  PLOTS.5615
      integer          cmeth,            ! coloring method indicator    (local)  PLOTS.5616
     *                 ctsiz             ! changeable version of TSIZE  (local)  PLOTS.5617
                                                                                 PLOTS.5618
C  Logical variables                                                             PLOTS.5619
                                                                                 PLOTS.5620
      logical          zl                ! draw in the zero line ?         (in)  PLOTS.5621
      logical          noplt             ! for common block NOPLOT               PLOTS.5622
      logical          color,            ! is this a color plot ?       (local)  PLOTS.5623
     *                 lover             ! draw lines over the plot ?   (local)  PLOTS.5624
                                                                                 PLOTS.5625
C  Real variables                                                                PLOTS.5626
                                                                                 PLOTS.5627
      real             indata(xdim,ydim),! data array                      (in)  PLOTS.5628
     *                 levels(100),      ! individually specified levels   (in)  PLOTS.5629
     *                 scale             ! scaling factor for labeling     (in)  PLOTS.5630
                                                                                 PLOTS.5631
C  Common blocks                                                                 PLOTS.5632
                                                                                 PLOTS.5633
      common /noplot/  noplt             ! don't draw anything ?                 PLOTS.5634
                                                                                 PLOTS.5635
C****************************  subroutine begin  *****************************C  PLOTS.5636
                                                                                 PLOTS.5637
C  Initialize changeables                                                        PLOTS.5638
                                                                                 PLOTS.5639
      ctsiz      = tsize                                                         PLOTS.5640
      cmask(1:2) = mask(1:2)                                                     PLOTS.5641
                                                                                 PLOTS.5642
C  Check for any errors that may exist before starting                           PLOTS.5643
                                                                                 PLOTS.5644
      call interc (xstr,ystr,xend,yend,xdim,ydim,lmeth,pnum,                     PLOTS.5645
     *             ctsiz,cmask,errsev)                                           PLOTS.5646
                                                                                 PLOTS.5647
C  Set up detail variables                                                       PLOTS.5648
                                                                                 PLOTS.5649
      if (unum .ne. 0) then                                                      PLOTS.5650
        call crddet (unum,errsev,pnum,hfilb,tfilb,lfilb)                         PLOTS.5651
                                                                                 PLOTS.5652
C  Set up color variables with correct color indices                             PLOTS.5653
                                                                                 PLOTS.5654
        call crdclt (unum,errsev,hfilb,tfilb,lfilb,zl,cmeth)                     PLOTS.5655
                                                                                 PLOTS.5656
C  Set up any contouring partitions that might be needed                         PLOTS.5657
                                                                                 PLOTS.5658
        call crdprt (unum,errsev,cmeth,scale)                                    PLOTS.5659
      end if                                                                     PLOTS.5660
                                                                                 PLOTS.5661
C  If an non-correctable error has occurred skip all Design and Draw             PLOTS.5662
C  routines                                                                      PLOTS.5663
                                                                                 PLOTS.5664
      if (.not. noplt) then                                                      PLOTS.5665
                                                                                 PLOTS.5666
C  Set up the window to use when plotting                                        PLOTS.5667
                                                                                 PLOTS.5668
        call csetwn (xstr,ystr,xend,yend,doset)                                  PLOTS.5669
                                                                                 PLOTS.5670
C  Set up contouring method, including setting up the contour levels             PLOTS.5671
                                                                                 PLOTS.5672
        call setcon (lmeth,cmeth,levels,errsev)                                  PLOTS.5673
                                                                                 PLOTS.5674
C  Set up the scaling factor                                                     PLOTS.5675
                                                                                 PLOTS.5676
        call cpsetr ('SFS',scale)                                                PLOTS.5677
                                                                                 PLOTS.5678
C  Set up the correct subset of the data to be plotted                           PLOTS.5679
C  and initialize CONPACK                                                        PLOTS.5680
                                                                                 PLOTS.5681
        call subcon (indata,xdim,ydim,xstr,ystr,xend,yend)                       PLOTS.5682
                                                                                 PLOTS.5683
C  Set up the line width, dash pattern and the zero line                         PLOTS.5684
                                                                                 PLOTS.5685
        call setlin (zl)                                                         PLOTS.5686
      end if                                                                     PLOTS.5687
                                                                                 PLOTS.5688
C  Title will be drawn even if no plot is to be made                             PLOTS.5689
C  Set up colors and labels and title                                            PLOTS.5690
                                                                                 PLOTS.5691
      call csetcl (ctsiz,title,pnum,scale,errsev)                                PLOTS.5692
                                                                                 PLOTS.5693
C  If requested fill the plot (shade or solid fill)                              PLOTS.5694
                                                                                 PLOTS.5695
      if (.not. noplt) then                                                      PLOTS.5696
        call confil (lover,cmask)                                                PLOTS.5697
                                                                                 PLOTS.5698
C  Draw contour lines                                                            PLOTS.5699
                                                                                 PLOTS.5700
        if (lover) call condrw (cmask)                                           PLOTS.5701
                                                                                 PLOTS.5702
C  Draw in the labels                                                            PLOTS.5703
                                                                                 PLOTS.5704
        call conlbl (xstr,ystr,xend,yend)                                        PLOTS.5705
        print *, 'CONDRV - Plot Successfully Completed'                          PLOTS.5706
      end if                                                                     PLOTS.5707
                                                                                 PLOTS.5708
C*****************************  suroutine end  *******************************C  PLOTS.5709
                                                                                 PLOTS.5710
      return                                                                     PLOTS.5711
      end                                                                        PLOTS.5712
      subroutine condrw (mask)                                                   PLOTS.5713
                                                                                 PLOTS.5714
C*****************************************************************************C  PLOTS.5715
C  condrw   - This is a CONDRV routine                                        C  PLOTS.5716
C  Section  - Contour Lines                                                   C  PLOTS.5717
C  Purpose  - To draw contour lines to a plot.                                C  PLOTS.5718
C                                                                             C  PLOTS.5719
C  On entry - Needed information is passed in through common blocks. MASK in- C  PLOTS.5720
C             dicates how to draw the contours with respect to a map.         C  PLOTS.5721
C                                                                             C  PLOTS.5722
C  On exit  - The contour lines have been drawn.                              C  PLOTS.5723
C                                                                             C  PLOTS.5724
C  Assume   - GKS is open and everything is set up with CONPACK.              C  PLOTS.5725
C                                                                             C  PLOTS.5726
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.5727
C             ----------------------------------------------------------------C  PLOTS.5728
C             ARINAM              AREAS utility*                              C  PLOTS.5729
C             CPLBAM              CONPACK utility*                            C  PLOTS.5730
C             CPCLDM              CONPACK utility*                            C  PLOTS.5731
C             CPCLDR              CONPACK utility*                            C  PLOTS.5732
C             ----------------------------------------------------------------C  PLOTS.5733
C             * NCAR Graphics routine                                         C  PLOTS.5734
C                                                                             C  PLOTS.5735
C  Author   - Jeremy Asbill      Date - August 12, 1990     for the MM4 club  C  PLOTS.5736
C*****************************************************************************C  PLOTS.5737
                                                                                 PLOTS.5738
C  Character variables                                                           PLOTS.5739
                                                                                 PLOTS.5740
      character*2      mask              ! map masking indicator           (in)  PLOTS.5741
      character*2      cmask             ! for common block MAPFLI               PLOTS.5742
                                                                                 PLOTS.5743
C  Integer variables                                                             PLOTS.5744
                                                                                 PLOTS.5745
      integer          lputl,            ! for common block QLBDET               PLOTS.5746
     *                 tputl             ! for common block QLBDET               PLOTS.5747
      integer          iwork(1000)       ! for common block DATAKP               PLOTS.5748
      integer          amapl(100000)     ! for common block CLNAMP               PLOTS.5749
      integer          aid(20),          ! area identifiers             (local)  PLOTS.5750
     *                 gid(20)           ! group identifiers            (local)  PLOTS.5751
                                                                                 PLOTS.5752
C  Logical variables                                                             PLOTS.5753
                                                                                 PLOTS.5754
      logical          hputl             ! for common block QLBDET               PLOTS.5755
      logical          hputb             ! for common block HLBDET               PLOTS.5756
                                                                                 PLOTS.5757
C  Real variables                                                                PLOTS.5758
                                                                                 PLOTS.5759
      real             mywork(1000,1000),! for common block DATAKP               PLOTS.5760
     *                 rwork(5000)       ! for common block DATAKP               PLOTS.5761
      real             xscm(2000),       ! work space for AREAS         (local)  PLOTS.5762
     *                 yscm(2000)        ! work space for AREAS         (local)  PLOTS.5763
                                                                                 PLOTS.5764
C  Common block                                                                  PLOTS.5765
                                                                                 PLOTS.5766
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.5767
     *                 lputl,            ! draw in line labels                   PLOTS.5768
     *                 tputl             ! draw in the title                     PLOTS.5769
      common /hlbdet/  hputb             ! draw a box around high/low labels ?   PLOTS.5770
      common /datakp/  mywork,           ! array of data to plot                 PLOTS.5771
     *                 iwork,            ! integer work space for CONPACK        PLOTS.5772
     *                 rwork             ! real work space for CONPACK           PLOTS.5773
      common /clnamp/  amapl             ! area map for line drawing             PLOTS.5774
      common /mapfli/  cmask             ! common block version of MASK          PLOTS.5775
                                                                                 PLOTS.5776
C  External routines                                                             PLOTS.5777
                                                                                 PLOTS.5778
      external         drawcl            ! draws contour lines masked            PLOTS.5779
                                                                                 PLOTS.5780
C****************************  Subroutine Begin  *****************************C  PLOTS.5781
                                                                                 PLOTS.5782
C  Initialize CMASK                                                              PLOTS.5783
                                                                                 PLOTS.5784
      cmask(1:2) = mask(1:2)                                                     PLOTS.5785
                                                                                 PLOTS.5786
C  Initialize the area map                                                       PLOTS.5787
                                                                                 PLOTS.5788
      if ((mask(1:1) .eq. 'N') .or. (mask(1:1) .eq. 'n'))                        PLOTS.5789
     *  call arinam (amapl,100000)                                               PLOTS.5790
                                                                                 PLOTS.5791
C  Put the label boxes in the area map                                           PLOTS.5792
                                                                                 PLOTS.5793
      if ((hputb) .or. (lputl .gt. 0) .or.                                       PLOTS.5794
     *    ((mask(1:1) .ne. 'N') .and. (mask(1:1) .ne. 'n'))) then                PLOTS.5795
        call cplbam (mywork,rwork,iwork,amapl)                                   PLOTS.5796
                                                                                 PLOTS.5797
C  Use area map to mask high/lows in drawing                                     PLOTS.5798
                                                                                 PLOTS.5799
        call cpcldm (mywork,rwork,iwork,amapl,drawcl)                            PLOTS.5800
      else                                                                       PLOTS.5801
                                                                                 PLOTS.5802
C  Do not mask high/lows                                                         PLOTS.5803
                                                                                 PLOTS.5804
        call cpcldr (mywork,rwork,iwork)                                         PLOTS.5805
      end if                                                                     PLOTS.5806
                                                                                 PLOTS.5807
C*****************************  Subroutine End  ******************************C  PLOTS.5808
                                                                                 PLOTS.5809
      return                                                                     PLOTS.5810
      end                                                                        PLOTS.5811
      subroutine confil (lover,mask)                                             PLOTS.5812
                                                                                 PLOTS.5813
C*****************************************************************************C  PLOTS.5814
C  confil   - This is a CONDRV routine                                        C  PLOTS.5815
C  Section  - Fill                                                            C  PLOTS.5816
C  Purpose  - To direct the color and shade fill for the plot.                C  PLOTS.5817
C                                                                             C  PLOTS.5818
C  On entry - The data to be plotted is in common block DATAKP.  The fill in- C  PLOTS.5819
C             formation is in common block FILDET.  MASK indicated how the a- C  PLOTS.5820
C             rea map should be used with respect to a map.                   C  PLOTS.5821
C                                                                             C  PLOTS.5822
C  On exit  - LOVER is true if lines should be drawn over a filled plot  & is C  PLOTS.5823
C             true if the plot was not filled and is false otherwise.         C  PLOTS.5824
C                                                                             C  PLOTS.5825
C  Assume   - GKS is open.                                                    C  PLOTS.5826
C                                                                             C  PLOTS.5827
C  Notes    - Routine             Location of Definition                      C  PLOTS.5828
C             ----------------------------------------------------------------C  PLOTS.5829
C             ARINAM              AREAS utility*                              C  PLOTS.5830
C             CPCLAM              CONPACK utility*                            C  PLOTS.5831
C             CPLBAM              CONPACK utility*                            C  PLOTS.5832
C             SFSETP              SOFTFILL utility*                           C  PLOTS.5833
C             SFSETI              SOFTFILL utility*                           C  PLOTS.5834
C             ARSCAM              AREAS utility*                              C  PLOTS.5835
C             GSFAIS              GKS                                         C  PLOTS.5836
C             MKFCOL              CONDRV utility                              C  PLOTS.5837
C             ----------------------------------------------------------------C  PLOTS.5838
C             * NCAR Graphics Routine                                         C  PLOTS.5839
C                                                                             C  PLOTS.5840
C  Author   - Jeremy Asbill      Date - August 12, 1990     for the MM4 club  C  PLOTS.5841
C*****************************************************************************C  PLOTS.5842
                                                                                 PLOTS.5843
C  Character variables                                                           PLOTS.5844
                                                                                 PLOTS.5845
      character*2      mask              ! map masking indicator           (in)  PLOTS.5846
      character*2      cmask             ! for common block MAPFLI               PLOTS.5847
                                                                                 PLOTS.5848
C  Integer variables                                                             PLOTS.5849
                                                                                 PLOTS.5850
      integer          lputl,            ! for common block QLBDET               PLOTS.5851
     *                 tputl             ! for common block QLBDET               PLOTS.5852
      integer          iwork(1000)       ! for common block DATAKP               PLOTS.5853
      integer          amapf(500000)     ! for common block CSCAMP               PLOTS.5854
      integer          aid(20),          ! area identifiers for AREAS   (local)  PLOTS.5855
     *                 gid(20),          ! group identifiers for AREAS  (local)  PLOTS.5856
     *                 pat(8,8),         ! dot pattern for shading      (local)  PLOTS.5857
     *                 i,j               ! loop counters                (local)  PLOTS.5858
                                                                                 PLOTS.5859
C  Logical variables                                                             PLOTS.5860
                                                                                 PLOTS.5861
      logical          lover             ! should lines be drawn ?        (out)  PLOTS.5862
      logical          fill,             ! for common block FILDET               PLOTS.5863
     *                 lshd,             ! for common block FILDET               PLOTS.5864
     *                 color             ! for common block FILDET               PLOTS.5865
      logical          hputl             ! for common block QLBDET               PLOTS.5866
      logical          hputb             ! for common block HLBDET               PLOTS.5867
                                                                                 PLOTS.5868
C  Real variables                                                                PLOTS.5869
                                                                                 PLOTS.5870
      real             mywork(1000,1000),! for common block DATAKP               PLOTS.5871
     *                 rwork(5000)       ! for common block DATAKP               PLOTS.5872
      real             xscam(200000),    ! work space for ARSCAM        (local)  PLOTS.5873
     *                 yscam(200000)     ! work space for ARSCAM        (local)  PLOTS.5874
                                                                                 PLOTS.5875
C  Common blocks                                                                 PLOTS.5876
                                                                                 PLOTS.5877
      common /fildet/  fill,             ! will the plot be filled ?             PLOTS.5878
     *                 lshd,             ! draw contour lines over a fill ?      PLOTS.5879
     *                 color             ! make the plot in color ?              PLOTS.5880
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.5881
     *                 lputl,            ! draw in line labels                   PLOTS.5882
     *                 tputl             ! draw in the title                     PLOTS.5883
      common /hlbdet/  hputb             ! draw a box around high/low labels ?   PLOTS.5884
      common /datakp/  mywork,           ! array of data to plot                 PLOTS.5885
     *                 iwork,            ! integer work space for CONPACK        PLOTS.5886
     *                 rwork             ! real work space for CONPACK           PLOTS.5887
      common /cscamp/  amapf             ! area map for shade and color          PLOTS.5888
      common /mapfli/  cmask             ! common block version of MASK          PLOTS.5889
                                                                                 PLOTS.5890
C  External routines                                                             PLOTS.5891
                                                                                 PLOTS.5892
      external         shadem            ! does shade filling                    PLOTS.5893
      external         fillem            ! does color filling                    PLOTS.5894
                                                                                 PLOTS.5895
C****************************  Subroutine Begin  *****************************C  PLOTS.5896
                                                                                 PLOTS.5897
C  SOFTFILL internal parameters used in this routine are :                       PLOTS.5898
C  TY  - TYpe of fill                                                            PLOTS.5899
C  DO  - DOtted fill flag                                                        PLOTS.5900
                                                                                 PLOTS.5901
C  If no filling was requested, do nothing                                       PLOTS.5902
                                                                                 PLOTS.5903
      if (fill) then                                                             PLOTS.5904
                                                                                 PLOTS.5905
C  Initialize CMASK                                                              PLOTS.5906
                                                                                 PLOTS.5907
        cmask(1:2) = mask(1:2)                                                   PLOTS.5908
                                                                                 PLOTS.5909
C  Initialize the area map                                                       PLOTS.5910
                                                                                 PLOTS.5911
        if ((mask(1:1) .eq. 'N') .or. (mask(1:1) .eq. 'n'))                      PLOTS.5912
     *    call arinam (amapf,500000)                                             PLOTS.5913
                                                                                 PLOTS.5914
C  And set up the area identifiers                                               PLOTS.5915
                                                                                 PLOTS.5916
        if (color) call mkfcol                                                   PLOTS.5917
                                                                                 PLOTS.5918
C  Put contour lines to the area map                                             PLOTS.5919
                                                                                 PLOTS.5920
        call cpclam (mywork,rwork,iwork,amapf)                                   PLOTS.5921
                                                                                 PLOTS.5922
C  Put the label boxes in the area map                                           PLOTS.5923
                                                                                 PLOTS.5924
        if ((hputb) .or. (lputl .gt. 0))                                         PLOTS.5925
     *    call cplbam (mywork,rwork,iwork,amapf)                                 PLOTS.5926
                                                                                 PLOTS.5927
C  Shade the plot if requested                                                   PLOTS.5928
                                                                                 PLOTS.5929
        if (.not. color) then                                                    PLOTS.5930
                                                                                 PLOTS.5931
C  If a label bar was made all should be set up                                  PLOTS.5932
                                                                                 PLOTS.5933
          if (tputl .ne. 0) then                                                 PLOTS.5934
                                                                                 PLOTS.5935
C  Make the fill a pattern fill                                                  PLOTS.5936
                                                                                 PLOTS.5937
            call gsfais (0)                                                      PLOTS.5938
                                                                                 PLOTS.5939
C  Set up a constant dot pattern                                                 PLOTS.5940
                                                                                 PLOTS.5941
            do 10 i = 1,8                                                        PLOTS.5942
              do 20 j = 1,8                                                      PLOTS.5943
                pat(i,j) = 1                                                     PLOTS.5944
20            continue                                                           PLOTS.5945
10          continue                                                             PLOTS.5946
                                                                                 PLOTS.5947
C  Set up the dot pattern with SOFTFILL                                          PLOTS.5948
                                                                                 PLOTS.5949
            call sfsetp (pat)                                                    PLOTS.5950
                                                                                 PLOTS.5951
C  Tell SOFTFILL to use dots in shading                                          PLOTS.5952
                                                                                 PLOTS.5953
            call sfseti ('TY',1)                                                 PLOTS.5954
            call sfseti ('DO',1)                                                 PLOTS.5955
          end if                                                                 PLOTS.5956
          call arscam (amapf,xscam,yscam,200000,aid,gid,20,shadem)               PLOTS.5957
        end if                                                                   PLOTS.5958
                                                                                 PLOTS.5959
C  Force a solid fill if not shading                                             PLOTS.5960
                                                                                 PLOTS.5961
        if (color) then                                                          PLOTS.5962
          call gsfais (1)                                                        PLOTS.5963
                                                                                 PLOTS.5964
C  Fill the plot if requested                                                    PLOTS.5965
                                                                                 PLOTS.5966
          call arscam (amapf,xscam,yscam,200000,aid,gid,20,fillem)               PLOTS.5967
        end if                                                                   PLOTS.5968
      end if                                                                     PLOTS.5969
                                                                                 PLOTS.5970
C  Determine if lines should be drawn                                            PLOTS.5971
                                                                                 PLOTS.5972
      if ((fill) .and. (lshd)) then                                              PLOTS.5973
        lover = .true.                                                           PLOTS.5974
      else if (.not. fill) then                                                  PLOTS.5975
        lover = .true.                                                           PLOTS.5976
      else                                                                       PLOTS.5977
        lover = .false.                                                          PLOTS.5978
      end if                                                                     PLOTS.5979
                                                                                 PLOTS.5980
C*****************************  Subroutine End  ******************************C  PLOTS.5981
                                                                                 PLOTS.5982
      return                                                                     PLOTS.5983
      end                                                                        PLOTS.5984
      subroutine conlbl (xstr,ystr,xend,yend)                                    PLOTS.5985
                                                                                 PLOTS.5986
C*****************************************************************************C  PLOTS.5987
C  conlbl   - This is a CONDRV routine                                        C  PLOTS.5988
C  Section  - Labels                                                          C  PLOTS.5989
C  Purpose  - To draw in, high/low labels,  line labels,  the title,  and the C  PLOTS.5990
C             perimeter.                                                      C  PLOTS.5991
C                                                                             C  PLOTS.5992
C  On entry - Needed information is passed in through common blocks.   Common C  PLOTS.5993
C             block  PERDET has the flag that indicates if a perimeter should C  PLOTS.5994
C             should be drawn.  XSTR & YSTR represent the first point of  the C  PLOTS.5995
C             grid to be plotted. XEND & YEND represent the last point of the C  PLOTS.5996
C             the grid to be plotted.                                         C  PLOTS.5997
C                                                                             C  PLOTS.5998
C  On exit  - The labels have been drawn.                                     C  PLOTS.5999
C                                                                             C  PLOTS.6000
C  Assume   - GKS is open.  The plot has been completed except for the labels C  PLOTS.6001
C             and they are all set up with CONPACK.                           C  PLOTS.6002
C                                                                             C  PLOTS.6003
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.6004
C             ----------------------------------------------------------------C  PLOTS.6005
C             GSFAIS              GKS                                         C  PLOTS.6006
C             CPLBDR              CONPACK utility*                            C  PLOTS.6007
C             DRWTTL              CONDRV utility                              C  PLOTS.6008
C             ----------------------------------------------------------------C  PLOTS.6009
C             * NCAR Graphics routine                                         C  PLOTS.6010
C                                                                             C  PLOTS.6011
C  Author   - Jeremy Asbill      Date - August 12, 1990     for the MM4 club  C  PLOTS.6012
C*****************************************************************************C  PLOTS.6013
                                                                                 PLOTS.6014
C  Integer variables                                                             PLOTS.6015
                                                                                 PLOTS.6016
      integer          xstr,             ! x coord. of first plotted point (in)  PLOTS.6017
     *                 ystr,             ! y coord. of first plotted point (in)  PLOTS.6018
     *                 xend,             ! x coord. of last plotted point  (in)  PLOTS.6019
     *                 yend              ! y coord. of last plotted point  (in)  PLOTS.6020
      integer          lputl,            ! for common block QLBDET               PLOTS.6021
     *                 tputl             ! for common block QLBDET               PLOTS.6022
      integer          iwork(1000)       ! for common block DATAKP               PLOTS.6023
                                                                                 PLOTS.6024
C  Logical variables                                                             PLOTS.6025
                                                                                 PLOTS.6026
      logical          hputl             ! for common block QLBDET               PLOTS.6027
      logical          prput             ! for common block PERDET               PLOTS.6028
                                                                                 PLOTS.6029
C  Real variables                                                                PLOTS.6030
                                                                                 PLOTS.6031
      real             mywork(1000,1000),! for common block DATAKP               PLOTS.6032
     *                 rwork(5000)       ! for common block DATAKP               PLOTS.6033
                                                                                 PLOTS.6034
C  Common blocks                                                                 PLOTS.6035
                                                                                 PLOTS.6036
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.6037
     *                 lputl,            ! draw in line labels                   PLOTS.6038
     *                 tputl             ! draw in the title                     PLOTS.6039
      common /datakp/  mywork,           ! array of data to plot                 PLOTS.6040
     *                 iwork,            ! integer work space for CONPACK        PLOTS.6041
     *                 rwork             ! real work space for CONPACK           PLOTS.6042
      common /perdet/  prput             ! put in a perimeter ?                  PLOTS.6043
                                                                                 PLOTS.6044
C****************************  Subroutine Begin  *****************************C  PLOTS.6045
                                                                                 PLOTS.6046
C  Force a solid fill here for label box fills                                   PLOTS.6047
                                                                                 PLOTS.6048
      call gsfais (1)                                                            PLOTS.6049
                                                                                 PLOTS.6050
C  If the information label is suppose to be drawn, do so                        PLOTS.6051
                                                                                 PLOTS.6052
      if (tputl .gt. 0) call drwttl                                              PLOTS.6053
                                                                                 PLOTS.6054
C  If no labels are to be drawn do nothing                                       PLOTS.6055
                                                                                 PLOTS.6056
      if ((lputl .gt. 0) .or. (hputl)) then                                      PLOTS.6057
                                                                                 PLOTS.6058
C  Fill in the labels                                                            PLOTS.6059
                                                                                 PLOTS.6060
        call cplbdr (mywork,rwork,iwork)                                         PLOTS.6061
      end if                                                                     PLOTS.6062
                                                                                 PLOTS.6063
C  Draw a perimeter now if one was requested                                     PLOTS.6064
                                                                                 PLOTS.6065
      if (prput) call perim (0,xend-xstr,0,yend-ystr)                            PLOTS.6066
                                                                                 PLOTS.6067
C*****************************  Subroutine End  ******************************C  PLOTS.6068
                                                                                 PLOTS.6069
      return                                                                     PLOTS.6070
      end                                                                        PLOTS.6071
      subroutine connum (value,number,length)                                    PLOTS.6072
                                                                                 PLOTS.6073
C*****************************************************************************C  PLOTS.6074
C  connum   - This is a CONDRV routine                                        C  PLOTS.6075
C  Section  - Design                                                          C  PLOTS.6076
C  Purpose  - To convert real numbers into nice strings for PLOTCHAR use      C  PLOTS.6077
C                                                                             C  PLOTS.6078
C  On entry - VALUE is the number to convert                                  C  PLOTS.6079
C                                                                             C  PLOTS.6080
C  On exit  - NUMBER is the string representing VALUE.  LENGTH is the number  C  PLOTS.6081
C             of characters the conversion used.                              C  PLOTS.6082
C                                                                             C  PLOTS.6083
C  Assume   - Then string is to be for PLOTCHAR.                              C  PLOTS.6084
C                                                                             C  PLOTS.6085
C  Notes    - Routine             Location of Definition                      C  PLOTS.6086
C             ----------------------------------------------------------------C  PLOTS.6087
C             PCGETC              PLOTCHAR utility*                           C  PLOTS.6088
C             ----------------------------------------------------------------C  PLOTS.6089
C             * NCAR Graphics Routine                                         C  PLOTS.6090
C                                                                             C  PLOTS.6091
C  Author   - Jeremy Asbill      Date - October 31, 1990     for the MM4 club C  PLOTS.6092
C*****************************************************************************C  PLOTS.6093
                                                                                 PLOTS.6094
C  Character variables                                                           PLOTS.6095
                                                                                 PLOTS.6096
      character          cchar           ! PLOTCHAR command delimeter   (local)  PLOTS.6097
      character*20       number          ! the converted number           (out)  PLOTS.6098
                                                                                 PLOTS.6099
C  Integer variables                                                             PLOTS.6100
                                                                                 PLOTS.6101
      integer            length          ! the number of characters used  (out)  PLOTS.6102
      integer            adjust,         ! for counting exponents       (local)  PLOTS.6103
     *                   expon,          ! the numbers exponent         (local)  PLOTS.6104
     *                   start,          ! string place keeper          (local)  PLOTS.6105
     *                   i               ! loop counter                 (local)  PLOTS.6106
                                                                                 PLOTS.6107
C  Real variables                                                                PLOTS.6108
                                                                                 PLOTS.6109
      real               value           ! the number to convert           (in)  PLOTS.6110
      real               divis,          ! divisor for finding exponent (local)  PLOTS.6111
     *                   manti,          ! the numbers mantissa         (local)  PLOTS.6112
     *                   test            ! calculation variable         (local)  PLOTS.6113
                                                                                 PLOTS.6114
C****************************  Subroutine Begin  *****************************C  PLOTS.6115
                                                                                 PLOTS.6116
C  The following PLOTCHAR internal parameters are used:                          PLOTS.6117
C  FC  - Function Code delimeter character                                       PLOTS.6118
                                                                                 PLOTS.6119
C  Retrieve the current PLOTCHAR command character                               PLOTS.6120
                                                                                 PLOTS.6121
      call pcgetc ('FC',cchar)                                                   PLOTS.6122
                                                                                 PLOTS.6123
C  Determine the divisor for finding the exponent                                PLOTS.6124
                                                                                 PLOTS.6125
      if ((abs(value) .lt. 1.0) .and. (abs(value) .gt. 0.0)) then                PLOTS.6126
        divis  = 0.1                                                             PLOTS.6127
        adjust = -1                                                              PLOTS.6128
      else                                                                       PLOTS.6129
        divis  = 10.0                                                            PLOTS.6130
        adjust = 1                                                               PLOTS.6131
      end if                                                                     PLOTS.6132
                                                                                 PLOTS.6133
C  Determine the exponent                                                        PLOTS.6134
                                                                                 PLOTS.6135
      expon = 0                                                                  PLOTS.6136
      test  = abs(value)                                                         PLOTS.6137
10    continue                                                                   PLOTS.6138
      if (((test .lt. 1.0) .or. (test .ge. 10.0)) .and.                          PLOTS.6139
     *    (test .ne. 0.0)) then                                                  PLOTS.6140
        test  = test/divis                                                       PLOTS.6141
        expon = expon + adjust                                                   PLOTS.6142
        goto 10                                                                  PLOTS.6143
      end if                                                                     PLOTS.6144
                                                                                 PLOTS.6145
C  Get the mantissa from the previous loop                                       PLOTS.6146
                                                                                 PLOTS.6147
      if (value .lt. 0.0) then                                                   PLOTS.6148
        manti = -1.0 * test                                                      PLOTS.6149
      else                                                                       PLOTS.6150
        manti = test                                                             PLOTS.6151
      end if                                                                     PLOTS.6152
                                                                                 PLOTS.6153
C  Check to see if number should be drawn in exponential format                  PLOTS.6154
                                                                                 PLOTS.6155
      if ((expon .gt. 4) .or. (expon .lt. -3)) then                              PLOTS.6156
                                                                                 PLOTS.6157
C  Write the mantissa into the string                                            PLOTS.6158
                                                                                 PLOTS.6159
        if (manti .lt. 0.0) then                                                 PLOTS.6160
          write (number(1:6),20) manti                                           PLOTS.6161
          start = 7                                                              PLOTS.6162
        else                                                                     PLOTS.6163
          write (number(1:5),30) manti                                           PLOTS.6164
          start = 6                                                              PLOTS.6165
        end if                                                                   PLOTS.6166
                                                                                 PLOTS.6167
C  Clean trailing zeros                                                          PLOTS.6168
                                                                                 PLOTS.6169
        i = start - 1                                                            PLOTS.6170
5       continue                                                                 PLOTS.6171
        if ((number(i:i) .eq. '0') .or. (number(i:i) .eq. ' ') .or.              PLOTS.6172
     *      (number(i:i) .eq. '.')) then                                         PLOTS.6173
          i = i - 1                                                              PLOTS.6174
          goto 5                                                                 PLOTS.6175
        end if                                                                   PLOTS.6176
        start                   = i + 1                                          PLOTS.6177
        number(start:start+4)   = ' x 10'                                        PLOTS.6178
        number(start+5:start+5) = cchar                                          PLOTS.6179
        number(start+6:start+6) = 'S'                                            PLOTS.6180
        start = start + 7                                                        PLOTS.6181
                                                                                 PLOTS.6182
C  Write the exponent into the string                                            PLOTS.6183
                                                                                 PLOTS.6184
        if (expon .lt. 0) then                                                   PLOTS.6185
          if (expon .lt. -9) then                                                PLOTS.6186
            number(start:start)     = '3'                                        PLOTS.6187
            number(start+1:start+1) = cchar                                      PLOTS.6188
            write (number(start+2:start+4),40) expon                             PLOTS.6189
            length = start + 4                                                   PLOTS.6190
          else                                                                   PLOTS.6191
            number(start:start)     = '2'                                        PLOTS.6192
            number(start+1:start+1) = cchar                                      PLOTS.6193
            write (number(start+2:start+3),50) expon                             PLOTS.6194
            length = start + 3                                                   PLOTS.6195
          end if                                                                 PLOTS.6196
        else                                                                     PLOTS.6197
          if (expon .gt. 9) then                                                 PLOTS.6198
            number(start:start)     = '2'                                        PLOTS.6199
            number(start+1:start+1) = cchar                                      PLOTS.6200
            write (number(start+2:start+3),50) expon                             PLOTS.6201
            length = start + 3                                                   PLOTS.6202
          else                                                                   PLOTS.6203
            number(start:start)     = '1'                                        PLOTS.6204
            number(start+1:start+1) = cchar                                      PLOTS.6205
            write (number(start+2:start+2),60) expon                             PLOTS.6206
            length = start + 2                                                   PLOTS.6207
          end if                                                                 PLOTS.6208
        end if                                                                   PLOTS.6209
                                                                                 PLOTS.6210
C  If not exponent format write it normal                                        PLOTS.6211
                                                                                 PLOTS.6212
      else                                                                       PLOTS.6213
        if (value .lt. 0) then                                                   PLOTS.6214
          write (number(1:10),70) value                                          PLOTS.6215
          i = 10                                                                 PLOTS.6216
        else                                                                     PLOTS.6217
          write (number(1:9),80) value                                           PLOTS.6218
          i = 9                                                                  PLOTS.6219
        end if                                                                   PLOTS.6220
                                                                                 PLOTS.6221
C  Clean trailing zeros and spaces                                               PLOTS.6222
                                                                                 PLOTS.6223
15      continue                                                                 PLOTS.6224
        if ((number(i:i) .eq. '0') .or. (number(i:i) .eq. ' ') .or.              PLOTS.6225
     *      (number(i:i) .eq. '.')) then                                         PLOTS.6226
          i = i - 1                                                              PLOTS.6227
          goto 15                                                                PLOTS.6228
        end if                                                                   PLOTS.6229
        length = i                                                               PLOTS.6230
      end if                                                                     PLOTS.6231
                                                                                 PLOTS.6232
C  Clean leading blanks from the string                                          PLOTS.6233
                                                                                 PLOTS.6234
      if (length .eq. 0) then                                                    PLOTS.6235
        number(1:1) = '0'                                                        PLOTS.6236
        length      = 1                                                          PLOTS.6237
      else                                                                       PLOTS.6238
        i = 1                                                                    PLOTS.6239
25      continue                                                                 PLOTS.6240
        if ((number(i:i) .eq. '0') .or. (number(i:i) .eq. ' ')) then             PLOTS.6241
          i = i + 1                                                              PLOTS.6242
          goto 25                                                                PLOTS.6243
        end if                                                                   PLOTS.6244
        number (1:length - i + 1) = number (i:length)                            PLOTS.6245
        length = length - i + 1                                                  PLOTS.6246
      end if                                                                     PLOTS.6247
                                                                                 PLOTS.6248
C*****************************  Subroutine End  ******************************C  PLOTS.6249
                                                                                 PLOTS.6250
C  Format statements begin ...                                                   PLOTS.6251
                                                                                 PLOTS.6252
20    format (F6.3)                                                              PLOTS.6253
30    format (F5.3)                                                              PLOTS.6254
40    format (I3)                                                                PLOTS.6255
50    format (I2)                                                                PLOTS.6256
60    format (I1)                                                                PLOTS.6257
70    format (F10.3)                                                             PLOTS.6258
80    format (F9.3)                                                              PLOTS.6259
                                                                                 PLOTS.6260
C  Format statements end                                                         PLOTS.6261
                                                                                 PLOTS.6262
      return                                                                     PLOTS.6263
      end                                                                        PLOTS.6264
        subroutine cpchhl (flag)                                                 PLOTS.6265
                                                                                 PLOTS.6266
C*****************************************************************************C  PLOTS.6267
C  cpchhl   - This is for CONDRV                                              C  PLOTS.6268
C  Section  - CONPACK change routines                                         C  PLOTS.6269
C  Purpose  - To alter the character quality and the box fill color of the    C  PLOTS.6270
C             high low labels.                                                C  PLOTS.6271
C                                                                             C  PLOTS.6272
C  On entry - HQUAL in the common block HLQDET contains the necessary infor-  C  PLOTS.6273
C             maiton for character quality.  The common block BCOLORS has     C  PLOTS.6274
C             the box fill colors for the high low labels.                    C  PLOTS.6275
C                                                                             C  PLOTS.6276
C  On exit  - The PLOTCHAR internal parameters CD and QU have been set up     C  PLOTS.6277
C             properly.  The PLOTCHAR utility is documented in the NCAR       C  PLOTS.6278
C             Graphics Guide to New Utilities Version 3.00.                   C  PLOTS.6279
C             CD - Use Complex or Duplex characters                           C  PLOTS.6280
C             QU - High Low or Medium Quality                                 C  PLOTS.6281
C             CONPACK internal parameter LBC has been set up to fill high/low C  PLOTS.6282
C             label boxes with the right color.                               C  PLOTS.6283
C                                                                             C  PLOTS.6284
C  Assume   - GKS is open and either CPLBDR or CPLBDM has been called and is  C  PLOTS.6285
C             calling this routine.                                           C  PLOTS.6286
C                                                                             C  PLOTS.6287
C  Notes    - Routine             Location of Definition                      C  PLOTS.6288
C             ----------------------------------------------------------------C  PLOTS.6289
C             PCSETI              PLOTCHAR utility*                           C  PLOTS.6290
C             GSFACI              GKS                                         C  PLOTS.6291
C             ----------------------------------------------------------------C  PLOTS.6292
C             * NCAR Graphics routine                                         C  PLOTS.6293
C                                                                             C  PLOTS.6294
C             This is a CONPACK change routine and is called by the CONPACK   C  PLOTS.6295
C             utility and NOT the CONDRV utility.                             C  PLOTS.6296
C                                                                             C  PLOTS.6297
C  Author   - Jeremy Asbill     Date - June 15, 1990 for the MM4 club.        C  PLOTS.6298
C*****************************************************************************C  PLOTS.6299
                                                                                 PLOTS.6300
C  Integer variables                                                             PLOTS.6301
                                                                                 PLOTS.6302
      integer          flag              ! indicates action in hi/lo draw  (in)  PLOTS.6303
      integer          hqual(2)          ! for common block HLQDET               PLOTS.6304
      integer          hcol(2),          ! for common block HLCOLS               PLOTS.6305
     *                 lcol(2)           ! for common block HLCOLS               PLOTS.6306
                                                                                 PLOTS.6307
C  Common blocks                                                                 PLOTS.6308
                                                                                 PLOTS.6309
      common /hlqdet/  hqual             ! quality of characters                 PLOTS.6310
      common /hlcols/  hcol,             ! high label box fill color             PLOTS.6311
     *                 lcol              ! low label box fill color              PLOTS.6312
                                                                                 PLOTS.6313
C****************************  subroutine begin  *****************************C  PLOTS.6314
                                                                                 PLOTS.6315
C  Test on flag, if flag is:                                                     PLOTS.6316
C       2 then a box for a high is about to be filled                            PLOTS.6317
C       3 then a label for a high is about to be drawn                           PLOTS.6318
C       6 then a box for a low is about to be filled                             PLOTS.6319
C       7 then a label for a low is about to be drawn                            PLOTS.6320
                                                                                 PLOTS.6321
      if ((flag .eq. 3) .or. (flag .eq. 7)) then                                 PLOTS.6322
                                                                                 PLOTS.6323
C  Set the character quality                                                     PLOTS.6324
                                                                                 PLOTS.6325
        call pcseti ('CD',hqual(1))                                              PLOTS.6326
        call pcseti ('QU',hqual(2))                                              PLOTS.6327
      else if (flag .eq. 2) then                                                 PLOTS.6328
                                                                                 PLOTS.6329
C  Set up high label box fill color index                                        PLOTS.6330
                                                                                 PLOTS.6331
        call gsfaci (hcol(2))                                                    PLOTS.6332
      else if (flag .eq. 6) then                                                 PLOTS.6333
                                                                                 PLOTS.6334
C  Set up low label box fill color index                                         PLOTS.6335
                                                                                 PLOTS.6336
        call gsfaci (lcol(2))                                                    PLOTS.6337
      end if                                                                     PLOTS.6338
                                                                                 PLOTS.6339
C*****************************  subroutine end  ******************************C  PLOTS.6340
                                                                                 PLOTS.6341
      return                                                                     PLOTS.6342
      end                                                                        PLOTS.6343
        subroutine cpchll (flag)                                                 PLOTS.6344
                                                                                 PLOTS.6345
C*****************************************************************************C  PLOTS.6346
C  cpchhl   - This is for CONDRV                                              C  PLOTS.6347
C  Section  - CONPACK change routines                                         C  PLOTS.6348
C  Purpose  - To alter the character quality of the line labels.  To properly C  PLOTS.6349
C             color the fills for line labels.                                C  PLOTS.6350
C                                                                             C  PLOTS.6351
C  On entry - LQUAL contains the information as to how the user wants to      C  PLOTS.6352
C             change the labels.  MFCOLOR and ZFCOLOR and MLCOLOR contain     C  PLOTS.6353
C             the indicies to use when coloring the labels.                   C  PLOTS.6354
C                                                                             C  PLOTS.6355
C  On exit  - The PLOTCHAR internal parameters CD and QU have been set up     C  PLOTS.6356
C             properly.  The PLOTCHAR utility is documented in the NCAR       C  PLOTS.6357
C             Graphics Guide to New Utilities Version 3.00.                   C  PLOTS.6358
C             CD - Use Complex or Duplex characters                           C  PLOTS.6359
C             QU - High Low or Medium Quality                                 C  PLOTS.6360
C             The proper indicies have been set up to color the fill boxes.   C  PLOTS.6361
C                                                                             C  PLOTS.6362
C  Assume   - GKS is open and either CPLBDR or CPLBDM has been called and is  C  PLOTS.6363
C             calling this routine.                                           C  PLOTS.6364
C                                                                             C  PLOTS.6365
C  Notes    - Routine             Location of Definition                      C  PLOTS.6366
C             ----------------------------------------------------------------C  PLOTS.6367
C             PCSETI              PLOTCHAR utility*                           C  PLOTS.6368
C             GSFACI              GKS                                         C  PLOTS.6369
C             CPGETR              CONPACK utility*                            C  PLOTS.6370
C             CPSETI              CONPACK utility*                            C  PLOTS.6371
C             ----------------------------------------------------------------C  PLOTS.6372
C             * NCAR Graphics routine                                         C  PLOTS.6373
C                                                                             C  PLOTS.6374
C             This is a CONPACK change routine and is called by the CONPACK   C  PLOTS.6375
C             utility and NOT the CONDRV utility.                             C  PLOTS.6376
C                                                                             C  PLOTS.6377
C  Author   - Jeremy Asbill     Date - June 15, 1990 for the MM4 club.        C  PLOTS.6378
C*****************************************************************************C  PLOTS.6379
                                                                                 PLOTS.6380
C  Parameter                                                                     PLOTS.6381
                                                                                 PLOTS.6382
      parameter       (idcsp = -1)       ! indicates default color specified     PLOTS.6383
                                                                                 PLOTS.6384
C  Integer variables                                                             PLOTS.6385
                                                                                 PLOTS.6386
      integer          flag              ! indicates action label drawing  (in)  PLOTS.6387
      integer          lqual(2)          ! for common block LBQDET               PLOTS.6388
      integer          lbco(3)           ! for common block LBCOLS               PLOTS.6389
      integer          zcol(3)           ! for common block ZLCOLS               PLOTS.6390
      integer          linco             ! contour line color index     (local)  PLOTS.6391
                                                                                 PLOTS.6392
C  Logical variables                                                             PLOTS.6393
                                                                                 PLOTS.6394
      logical          hghlt,            ! for common block LBCOLS               PLOTS.6395
     *                 same,             ! for common block LBCOLS               PLOTS.6396
     *                 revrs             ! for common block LBCOLS               PLOTS.6397
                                                                                 PLOTS.6398
C  Real variables                                                                PLOTS.6399
                                                                                 PLOTS.6400
      real             clev              ! contour level value          (local)  PLOTS.6401
                                                                                 PLOTS.6402
C  Common blocks                                                                 PLOTS.6403
                                                                                 PLOTS.6404
      common /lbqdet/  lqual             ! quality of characters                 PLOTS.6405
      common /lbcols/  hghlt,            ! highlighted labeled lines ?           PLOTS.6406
     *                 same,             ! line same color as label ?            PLOTS.6407
     *                 revrs,            ! text and fill reverse after zero ?    PLOTS.6408
     *                 lbco              ! line label colors                     PLOTS.6409
      common /zrcols/  zcol              ! zero line colors                      PLOTS.6410
                                                                                 PLOTS.6411
                                                                                 PLOTS.6412
C****************************  subroutine begin  *****************************C  PLOTS.6413
                                                                                 PLOTS.6414
C  Test on flag, if flag is:                                                     PLOTS.6415
C       2 then a box is about to be filled                                       PLOTS.6416
C       3 then a label is about to be drawn                                      PLOTS.6417
                                                                                 PLOTS.6418
      if (flag .eq. 3) then                                                      PLOTS.6419
                                                                                 PLOTS.6420
C  Set the character quality                                                     PLOTS.6421
                                                                                 PLOTS.6422
        call pcseti ('CD',lqual(1))                                              PLOTS.6423
        call pcseti ('QU',lqual(2))                                              PLOTS.6424
                                                                                 PLOTS.6425
      else if (flag .eq. 2) then                                                 PLOTS.6426
                                                                                 PLOTS.6427
C  Watch for a box to be filled                                                  PLOTS.6428
                                                                                 PLOTS.6429
        call cpgetr ('CLV',clev)                                                 PLOTS.6430
        if (revrs) then                                                          PLOTS.6431
          if (clev .lt. 0.0) then                                                PLOTS.6432
            call gsfaci (lbco(2))                                                PLOTS.6433
          else if (clev .eq. 0.0) then                                           PLOTS.6434
            call gsfaci (zcol(2))                                                PLOTS.6435
          else if (clev .gt. 0.0) then                                           PLOTS.6436
            call gsfaci (lbco(3))                                                PLOTS.6437
          end if                                                                 PLOTS.6438
        else                                                                     PLOTS.6439
          call gsfaci (lbco(2))                                                  PLOTS.6440
        end if                                                                   PLOTS.6441
      end if                                                                     PLOTS.6442
                                                                                 PLOTS.6443
C*****************************  subroutine end  ******************************C  PLOTS.6444
                                                                                 PLOTS.6445
      return                                                                     PLOTS.6446
      end                                                                        PLOTS.6447
      subroutine cramps                                                          PLOTS.6448
                                                                                 PLOTS.6449
C*****************************************************************************C  PLOTS.6450
C  cramps   - This is a CONDRV routine                                        C  PLOTS.6451
C  Section  - Colors                                                          C  PLOTS.6452
C  Purpose  - To  calculate out ramps of colors.  The ramps change  gradually C  PLOTS.6453
C             from  one  color to another and are specified by the  partition C  PLOTS.6454
C             colors.                                                         C  PLOTS.6455
C                                                                             C  PLOTS.6456
C  On entry - All neccesary information is passed in through  common  blocks. C  PLOTS.6457
C                                                                             C  PLOTS.6458
C  On exit  - The variables NRMPS and  RAMPS have been set up in common block C  PLOTS.6459
C             RAMPSC.  NRMPS is a list of levels/partition. RAMPS is a set of C  PLOTS.6460
C             color ramps to use on the partitions.                           C  PLOTS.6461
C                                                                             C  PLOTS.6462
C  Assume   - GKS is open.  CONPACK has been initialized. Contour levels have C  PLOTS.6463
C             been set up.                                                    C  PLOTS.6464
C                                                                             C  PLOTS.6465
C  Notes    - Routine             Location of Definition                      C  PLOTS.6466
C             ----------------------------------------------------------------C  PLOTS.6467
C             CPGETI              CONPACK utility*                            C  PLOTS.6468
C             CPSETI              CONPACK utility*                            C  PLOTS.6469
C             CPGETR              CONPACK utility*                            C  PLOTS.6470
C             GQCR                GKS                                         C  PLOTS.6471
C             GSCR                GKS                                         C  PLOTS.6472
C             ----------------------------------------------------------------C  PLOTS.6473
C             * NCAR Graphics Routine                                         C  PLOTS.6474
C                                                                             C  PLOTS.6475
C  Author   - Jeremy Asbill       Date - June 8, 1990       for the MM4 club  C  PLOTS.6476
C*****************************************************************************C  PLOTS.6477
                                                                                 PLOTS.6478
C  Parameters                                                                    PLOTS.6479
                                                                                 PLOTS.6480
      parameter       (imin = -1)        ! since before the first contour level  PLOTS.6481
      parameter       (imax = 101)       ! until after the last contour level    PLOTS.6482
                                                                                 PLOTS.6483
C  Integer variables                                                             PLOTS.6484
                                                                                 PLOTS.6485
      integer          pcolor(100,2)     ! for common block PARCOL               PLOTS.6486
      integer          nprt,             ! for common block PARINF               PLOTS.6487
     *                 iprts(100,2)      ! for common block PARINF               PLOTS.6488
      integer          cmeth,            ! for common block COLIND               PLOTS.6489
     *                 bckco,            ! for common block COLIND               PLOTS.6490
     *                 rmeth             ! for common block COLIND               PLOTS.6491
      integer          nrmps(100),       ! for common block RAMPSC               PLOTS.6492
     *                 ramps(100,100)    ! for common block RAMPSC               PLOTS.6493
      integer          nclv,             ! # of contour levels total    (local)  PLOTS.6494
     *                 i,j,              ! loop counters/place keepers  (local)  PLOTS.6495
     *                 dum,temp,         ! temporary dummy values       (local)  PLOTS.6496
     *                 base              ! calculation variable         (local)  PLOTS.6497
                                                                                 PLOTS.6498
C  Logical variables                                                             PLOTS.6499
                                                                                 PLOTS.6500
      logical          ints              ! for common block PARINF               PLOTS.6501
                                                                                 PLOTS.6502
C  Real variables                                                                PLOTS.6503
                                                                                 PLOTS.6504
      real             rprts(100,2)      ! for common block PARINF               PLOTS.6505
      real             clev,             ! temporary contour level value(local)  PLOTS.6506
     *                 rindo,            ! COLONE's red portion         (local)  PLOTS.6507
     *                 rindt,            ! COLTWO's red portion         (local)  PLOTS.6508
     *                 rindn,            ! new color's red portion      (local)  PLOTS.6509
     *                 gindo,            ! COLONE's green portion       (local)  PLOTS.6510
     *                 gindt,            ! COLTWO's grren portion       (local)  PLOTS.6511
     *                 gindn,            ! new color's green portion    (local)  PLOTS.6512
     *                 bindo,            ! COLONE's blue portion        (local)  PLOTS.6513
     *                 bindt,            ! COLTWO's blue portion        (local)  PLOTS.6514
     *                 bindn,            ! new color's blue portion     (local)  PLOTS.6515
     *                 mpy,              ! calculation variable         (local)  PLOTS.6516
     *                 root,             ! calculation variable         (local)  PLOTS.6517
     *                 divn              ! calculation variable         (local)  PLOTS.6518
                                                                                 PLOTS.6519
C  Comon blocks                                                                  PLOTS.6520
                                                                                 PLOTS.6521
      common /colind/  cmeth,            ! method of color plot                  PLOTS.6522
     *                 bckco,            ! not used                              PLOTS.6523
     *                 rmeth             ! method of ramping colors              PLOTS.6524
      common /parinf/  nprt,             ! number of partitions                  PLOTS.6525
     *                 iprts,            ! integer partitions                    PLOTS.6526
     *                 rprts,            ! real partitions                       PLOTS.6527
     *                 ints              ! are the partitions integers ?         PLOTS.6528
      common /parcol/  pcolor            ! colors for each partition             PLOTS.6529
      common /rampsc/  nrmps,            ! # or levels/partition                 PLOTS.6530
     *                 ramps             ! color ramps                           PLOTS.6531
                                                                                 PLOTS.6532
C****************************  subroutine begin  *****************************C  PLOTS.6533
                                                                                 PLOTS.6534
C  CONPACK internal parameters used are:                                         PLOTS.6535
C  NCL - Number of Contour Levels                                                PLOTS.6536
C  PAI - Parameter Array Index                                                   PLOTS.6537
C  CLV - Contour LeVels                                                          PLOTS.6538
                                                                                 PLOTS.6539
C  Get the number of levels that are in the plot                                 PLOTS.6540
                                                                                 PLOTS.6541
      call cpgeti ('NCL',nclv)                                                   PLOTS.6542
                                                                                 PLOTS.6543
C  Ramps only need to be built if the coloring method is 4,5,6 or 7              PLOTS.6544
C  and there are contours                                                        PLOTS.6545
                                                                                 PLOTS.6546
      if ((cmeth .ge. 4) .and. (cmeth .le. 7) .and. (nclv .ne. 0)) then          PLOTS.6547
                                                                                 PLOTS.6548
C  Initialize the BASE of the color ramps                                        PLOTS.6549
                                                                                 PLOTS.6550
        base = 100                                                               PLOTS.6551
                                                                                 PLOTS.6552
C  Initialize partition levels counts                                            PLOTS.6553
                                                                                 PLOTS.6554
        do 10 i = 1,nprt                                                         PLOTS.6555
          nrmps(i) = 0                                                           PLOTS.6556
10      continue                                                                 PLOTS.6557
                                                                                 PLOTS.6558
C  Determine how many of levels exist within each partition                      PLOTS.6559
                                                                                 PLOTS.6560
        if ((.not. ints) .and. (cmeth .lt. 6)) then                              PLOTS.6561
          do 20 i = 1,nclv                                                       PLOTS.6562
            call cpseti ('PAI',i)                                                PLOTS.6563
            call cpgetr ('CLV',clev)                                             PLOTS.6564
            do 30 j = 1,nprt                                                     PLOTS.6565
              if ((clev .ge. rprts(j,1)) .and.                                   PLOTS.6566
     *            (clev .lt. rprts(j,2))) then                                   PLOTS.6567
                nrmps(j) = nrmps(j) + 1                                          PLOTS.6568
              end if                                                             PLOTS.6569
30          continue                                                             PLOTS.6570
20        continue                                                               PLOTS.6571
        else if ((ints) .and. (cmeth .lt. 6)) then                               PLOTS.6572
          do 40 i = 1,nprt                                                       PLOTS.6573
            if (iprts(i,1) .eq. imin) then                                       PLOTS.6574
              temp = 1                                                           PLOTS.6575
            else                                                                 PLOTS.6576
              temp = iprts(i,1)                                                  PLOTS.6577
            end if                                                               PLOTS.6578
            if (iprts(i,2) .eq. imax) then                                       PLOTS.6579
              dum  = nclv + 1                                                    PLOTS.6580
            else                                                                 PLOTS.6581
              dum  = iprts(i,2)                                                  PLOTS.6582
            end if                                                               PLOTS.6583
            nrmps(i) = dum - temp                                                PLOTS.6584
40        continue                                                               PLOTS.6585
        else if (cmeth .eq. 6) then                                              PLOTS.6586
          nprt = 5                                                               PLOTS.6587
          dum  = mod(nclv,5)                                                     PLOTS.6588
          temp = nclv/5                                                          PLOTS.6589
          nrmps(1) = temp                                                        PLOTS.6590
          nrmps(2) = temp                                                        PLOTS.6591
          nrmps(3) = temp                                                        PLOTS.6592
          nrmps(4) = temp                                                        PLOTS.6593
          nrmps(5) = temp                                                        PLOTS.6594
          do 90 i = 1,dum                                                        PLOTS.6595
            nrmps(i) = nrmps(i) + 1                                              PLOTS.6596
90        continue                                                               PLOTS.6597
        else if (cmeth .eq. 7) then                                              PLOTS.6598
          nprt = 5                                                               PLOTS.6599
          nrmps(1) = 20                                                          PLOTS.6600
          nrmps(2) = 20                                                          PLOTS.6601
          nrmps(3) = 20                                                          PLOTS.6602
          nrmps(4) = 20                                                          PLOTS.6603
          nrmps(5) = 20                                                          PLOTS.6604
        end if                                                                   PLOTS.6605
                                                                                 PLOTS.6606
C  Loop through the partitions, building, for each, individual ramps             PLOTS.6607
                                                                                 PLOTS.6608
        do 50 i = 1,nprt                                                         PLOTS.6609
                                                                                 PLOTS.6610
C  Retrieve from GKS the color representations specified                         PLOTS.6611
                                                                                 PLOTS.6612
          if (cmeth .lt. 6) then                                                 PLOTS.6613
            call gqcr (1,pcolor(i,1),0,ier,rindo,gindo,bindo)                    PLOTS.6614
            call gqcr (1,pcolor(i,2),0,ier,rindt,gindt,bindt)                    PLOTS.6615
            ramps(i,1) = pcolor(i,1)                                             PLOTS.6616
          else                                                                   PLOTS.6617
            if (i .eq. 1) then                                                   PLOTS.6618
              call gscr (1,250,0.0,0.0,1.0)                                      PLOTS.6619
              ramps(i,1) = 250                                                   PLOTS.6620
              rindo      = 0.0                                                   PLOTS.6621
              gindo      = 0.0                                                   PLOTS.6622
              bindo      = 1.0                                                   PLOTS.6623
              rindt      = 0.0                                                   PLOTS.6624
              gindt      = 1.0                                                   PLOTS.6625
              bindt      = 1.0                                                   PLOTS.6626
            else if (i .eq. 2) then                                              PLOTS.6627
              call gscr (1,251,0.0,1.0,1.0)                                      PLOTS.6628
              ramps(i,1) = 251                                                   PLOTS.6629
              rindo      = 0.0                                                   PLOTS.6630
              gindo      = 1.0                                                   PLOTS.6631
              bindo      = 1.0                                                   PLOTS.6632
              rindt      = 0.0                                                   PLOTS.6633
              gindt      = 1.0                                                   PLOTS.6634
              bindt      = 0.0                                                   PLOTS.6635
            else if (i .eq. 3) then                                              PLOTS.6636
              call gscr (1,252,0.0,1.0,0.0)                                      PLOTS.6637
              ramps(i,1) = 252                                                   PLOTS.6638
              rindo      = 0.0                                                   PLOTS.6639
              gindo      = 1.0                                                   PLOTS.6640
              bindo      = 0.0                                                   PLOTS.6641
              rindt      = 1.0                                                   PLOTS.6642
              gindt      = 1.0                                                   PLOTS.6643
              bindt      = 0.0                                                   PLOTS.6644
            else if (i .eq. 4) then                                              PLOTS.6645
              call gscr (1,253,1.0,1.0,0.0)                                      PLOTS.6646
              ramps(i,1) = 253                                                   PLOTS.6647
              rindo      = 1.0                                                   PLOTS.6648
              gindo      = 1.0                                                   PLOTS.6649
              bindo      = 0.0                                                   PLOTS.6650
              rindt      = 1.0                                                   PLOTS.6651
              gindt      = 0.5                                                   PLOTS.6652
              bindt      = 0.0                                                   PLOTS.6653
            else                                                                 PLOTS.6654
              call gscr (1,254,1.0,0.5,0.0)                                      PLOTS.6655
              ramps(i,1) = 254                                                   PLOTS.6656
              rindo      = 1.0                                                   PLOTS.6657
              gindo      = 0.5                                                   PLOTS.6658
              bindo      = 0.0                                                   PLOTS.6659
              rindt      = 1.0                                                   PLOTS.6660
              gindt      = 0.0                                                   PLOTS.6661
              bindt      = 0.0                                                   PLOTS.6662
            end if                                                               PLOTS.6663
          end if                                                                 PLOTS.6664
                                                                                 PLOTS.6665
C  Determine the function on which to vary the colors                            PLOTS.6666
                                                                                 PLOTS.6667
          if (rmeth .gt. 0) then                                                 PLOTS.6668
                                                                                 PLOTS.6669
C  RMETH > 0 means use a sine function                                           PLOTS.6670
                                                                                 PLOTS.6671
            divn = 3.14159/(float(nrmps(i)) + 1)                                 PLOTS.6672
            do 60 j = 2,nrmps(i)                                                 PLOTS.6673
              if (mod(i,2) .eq. 0) then                                          PLOTS.6674
                                                                                 PLOTS.6675
C  If the current partition is even go down the ramp instead of up it            PLOTS.6676
                                                                                 PLOTS.6677
                root  = (3.14159 * 0.5) + float(j) * divn                        PLOTS.6678
                mpy   = sin(root)                                                PLOTS.6679
                mpy   = (1.0 - mpy)/2.0                                          PLOTS.6680
              else                                                               PLOTS.6681
                                                                                 PLOTS.6682
C  If the current partition is odd go up the ramp                                PLOTS.6683
                                                                                 PLOTS.6684
                root  = (3.14159 * 3.0/2.0) + float(j) * divn                    PLOTS.6685
                mpy   = sin(root)                                                PLOTS.6686
                mpy   = (mpy + 1.0)/2.0                                          PLOTS.6687
              end if                                                             PLOTS.6688
                                                                                 PLOTS.6689
C  Determine the red, green and blue components of the new color                 PLOTS.6690
                                                                                 PLOTS.6691
              rindn = rindo + (rindt - rindo) * mpy                              PLOTS.6692
              gindn = gindo + (gindt - gindo) * mpy                              PLOTS.6693
              bindn = bindo + (bindt - bindo) * mpy                              PLOTS.6694
                                                                                 PLOTS.6695
C  Define the color in GKS                                                       PLOTS.6696
                                                                                 PLOTS.6697
              call gscr (1,base+j-2,rindn,gindn,bindn)                           PLOTS.6698
                                                                                 PLOTS.6699
C  Add the color to the ramp                                                     PLOTS.6700
                                                                                 PLOTS.6701
              ramps(i,j) = base + j - 2                                          PLOTS.6702
60          continue                                                             PLOTS.6703
          else if (rmeth .lt. 0) then                                            PLOTS.6704
                                                                                 PLOTS.6705
C  RMETH < 0 means use an exponential function                                   PLOTS.6706
                                                                                 PLOTS.6707
            divn = 1.0/(float(nrmps(i)) + 1)                                     PLOTS.6708
            do 70 j = 2,nrmps(i)                                                 PLOTS.6709
              if (mod(i,2) .eq. 0) then                                          PLOTS.6710
                                                                                 PLOTS.6711
C  If the current partition is even go down the ramp instead of up it            PLOTS.6712
                                                                                 PLOTS.6713
                root  = 1.0 - float(j) * divn                                    PLOTS.6714
                mpy   = root**2                                                  PLOTS.6715
                                                                                 PLOTS.6716
C  Calculate the red, green and blue components for the new color                PLOTS.6717
                                                                                 PLOTS.6718
                rindn = rindt + (rindo - rindt) * mpy                            PLOTS.6719
                gindn = gindt + (gindo - gindt) * mpy                            PLOTS.6720
                bindn = bindt + (bindo - bindt) * mpy                            PLOTS.6721
              else                                                               PLOTS.6722
                                                                                 PLOTS.6723
C  If the curent partition is odd go down the ramp instead of up it              PLOTS.6724
                                                                                 PLOTS.6725
                root  = float(j) * divn                                          PLOTS.6726
                mpy   = root**2                                                  PLOTS.6727
                                                                                 PLOTS.6728
C  Calculate the red, green and blue components for the new color                PLOTS.6729
                                                                                 PLOTS.6730
                rindn = rindo + (rindt - rindo) * mpy                            PLOTS.6731
                gindn = gindo + (gindt - gindo) * mpy                            PLOTS.6732
                bindn = bindo + (bindt - bindo) * mpy                            PLOTS.6733
              end if                                                             PLOTS.6734
                                                                                 PLOTS.6735
C  Define the new color with GKS                                                 PLOTS.6736
                                                                                 PLOTS.6737
              call gscr (1,base+j-2,rindn,gindn,bindn)                           PLOTS.6738
                                                                                 PLOTS.6739
C  Add the new color to the ramp                                                 PLOTS.6740
                                                                                 PLOTS.6741
              ramps(i,j) = base + j - 2                                          PLOTS.6742
70          continue                                                             PLOTS.6743
          else                                                                   PLOTS.6744
                                                                                 PLOTS.6745
C  RMETH = 0 means use a linear function                                         PLOTS.6746
                                                                                 PLOTS.6747
            divn = 1.0/(float(nrmps(i)) + 1)                                     PLOTS.6748
            do 80 j = 2,nrmps(i)                                                 PLOTS.6749
              mpy   = float(j) * divn                                            PLOTS.6750
                                                                                 PLOTS.6751
C  Calculate the red, green and blue color components of the new color           PLOTS.6752
                                                                                 PLOTS.6753
              rindn = rindo + (rindt - rindo) * mpy                              PLOTS.6754
              gindn = gindo + (gindt - gindo) * mpy                              PLOTS.6755
              bindn = bindo + (bindt - bindo) * mpy                              PLOTS.6756
                                                                                 PLOTS.6757
C  Define the new color with GKS                                                 PLOTS.6758
                                                                                 PLOTS.6759
              call gscr (1,base+j-2,rindn,gindn,bindn)                           PLOTS.6760
                                                                                 PLOTS.6761
C  Add the new color to the ramps                                                PLOTS.6762
                                                                                 PLOTS.6763
              ramps(i,j) = base + j - 2                                          PLOTS.6764
80          continue                                                             PLOTS.6765
          end if                                                                 PLOTS.6766
                                                                                 PLOTS.6767
C  Increment BASE to be the first free color index after the last one in the     PLOTS.6768
C  last ramp                                                                     PLOTS.6769
                                                                                 PLOTS.6770
          if ((ramps(i,nrmps(i)) .ge. 100) .and.                                 PLOTS.6771
     *        (ramps(i,nrmps(i)) .lt. 200)) base = ramps(i,nrmps(i)) + 1         PLOTS.6772
50      continue                                                                 PLOTS.6773
        print *, 'CONDRV - Color Ramps Created'                                  PLOTS.6774
      end if                                                                     PLOTS.6775
                                                                                 PLOTS.6776
C*****************************  subroutine end  ******************************C  PLOTS.6777
                                                                                 PLOTS.6778
      return                                                                     PLOTS.6779
      end                                                                        PLOTS.6780
      subroutine crdclt (unum,errsev,hfilb,tfilb,lfilb,zl,ometh)                 PLOTS.6781
                                                                                 PLOTS.6782
C*****************************************************************************C  PLOTS.6783
C  crdclt   - This is a CONDRV routine                                        C  PLOTS.6784
C  Section  - Tables                                                          C  PLOTS.6785
C  Purpose  - To read in the proper color indexes to be used in a contour     C  PLOTS.6786
C             plot.                                                           C  PLOTS.6787
C                                                                             C  PLOTS.6788
C  On entry - COLOR indicates whether to look for the CON COLORS table.  UNUM C  PLOTS.6789
C             is the unit number on  which to look for  the table. ERRSEV in- C  PLOTS.6790
C             dicates what severity of error should halt execution.    HFILB, C  PLOTS.6791
C             TFILB  and  LFILB are logicals indicating if the high/low label C  PLOTS.6792
C             boxes, the title boxes and the line  label  boxes  respectively C  PLOTS.6793
C             should be fill.  ZL is true if a zero line will be drawn in the C  PLOTS.6794
C             plot.                                                           C  PLOTS.6795
C                                                                             C  PLOTS.6796
C  On exit  - OMETH  contains the  coloring method to use.   All variables in C  PLOTS.6797
C             common blocks HLCOLS, ZLCOLS, TLCOLS,  LBCOLS and  COLIND  have C  PLOTS.6798
C             been set up accordingly with the table.   See listing of  those C  PLOTS.6799
C             common blocks for more information.                             C  PLOTS.6800
C                                                                             C  PLOTS.6801
C  Assume   - Nothing                                                         C  PLOTS.6802
C                                                                             C  PLOTS.6803
C  Notes    - Routine             Location of Definition                      C  PLOTS.6804
C             ----------------------------------------------------------------C  PLOTS.6805
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.6806
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.6807
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.6808
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.6809
C             TBLLOK              CONDRV/MAPDRV utility                       C  PLOTS.6810
C             CRDRCI              CONDRV/MAPDRV utility                       C  PLOTS.6811
C             ----------------------------------------------------------------C  PLOTS.6812
C                                                                             C  PLOTS.6813
C  Author   - Jeremy Asbill       Date - June 5, 1990       for the MM4 club  C  PLOTS.6814
C*****************************************************************************C  PLOTS.6815
                                                                                 PLOTS.6816
C  Parameters                                                                    PLOTS.6817
                                                                                 PLOTS.6818
      parameter       (idcsp = -1)       ! color index for defaults              PLOTS.6819
                                                                                 PLOTS.6820
C  Character variables                                                           PLOTS.6821
                                                                                 PLOTS.6822
      character*80     whline            ! a whole line from the table  (local)  PLOTS.6823
      character*60     ermes,            ! error message string,general (local)  PLOTS.6824
     *                 p,                ! error message string,SEARCH  (local)  PLOTS.6825
     *                 q                 ! error message string,NEXT    (local)  PLOTS.6826
                                                                                 PLOTS.6827
C  Integer variables                                                             PLOTS.6828
                                                                                 PLOTS.6829
      integer          errsev,           ! error severity comparitor       (in)  PLOTS.6830
     *                 unum              ! unit number of table file       (in)  PLOTS.6831
      integer          ometh             ! out version of CMETH           (out)  PLOTS.6832
      integer          cmeth,            ! for common block COLIND               PLOTS.6833
     *                 bckco,            ! for common block COLIND               PLOTS.6834
     *                 rmeth             ! for common block COLIND               PLOTS.6835
      integer          lputl,            ! for common block QLBDET               PLOTS.6836
     *                 tputl             ! for common block QLBDET               PLOTS.6837
      integer          hcol(2),          ! for common block HLCOLS               PLOTS.6838
     *                 lcol(2)           ! for common block HLCOLS               PLOTS.6839
      integer          zcol(3)           ! for common block ZLCOLS               PLOTS.6840
      integer          tcol(2)           ! for common block TLCOLS               PLOTS.6841
      integer          lbco(3)           ! for common block LBCOLS               PLOTS.6842
      integer          pcol              ! for common block PERCOL               PLOTS.6843
      integer          i                 ! place keeper                 (local)  PLOTS.6844
                                                                                 PLOTS.6845
C  Logical variables                                                             PLOTS.6846
                                                                                 PLOTS.6847
      logical          hfilb,            ! fill high/low label boxes ?     (in)  PLOTS.6848
     *                 tfilb,            ! fill title boxes ?              (in)  PLOTS.6849
     *                 lfilb,            ! fill line label boxes ?         (in)  PLOTS.6850
     *                 zl                ! draw the zero line ?            (in)  PLOTS.6851
      logical          noplt             ! for common block NOPLOT               PLOTS.6852
      logical          hputl             ! for common block QLBDET               PLOTS.6853
      logical          hghlt,            ! for common block LBCOLS               PLOTS.6854
     *                 same,             ! for common block LBCOLS               PLOTS.6855
     *                 revrs             ! for common block LBCOLS               PLOTS.6856
      logical          fill,             ! for common block FILDET               PLOTS.6857
     *                 lshd,             ! for common block FILDET               PLOTS.6858
     *                 color             ! for common block FILDET               PLOTS.6859
      logical          prput             ! for common block PERDET               PLOTS.6860
      logical          error,            ! has an error occured ?       (local)  PLOTS.6861
     *                 found,            ! was the table found ?        (local)  PLOTS.6862
     *                 test              ! is this true ?               (local)  PLOTS.6863
                                                                                 PLOTS.6864
C  Common blocks                                                                 PLOTS.6865
                                                                                 PLOTS.6866
      common /colind/  cmeth,            ! method of color plot                  PLOTS.6867
     *                 bckco,            ! backup color index                    PLOTS.6868
     *                 rmeth             ! method of ramping colors              PLOTS.6869
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.6870
     *                 lputl,            ! draw in line labels                   PLOTS.6871
     *                 tputl             ! draw in the title                     PLOTS.6872
      common /hlcols/  hcol,             ! high label colors                     PLOTS.6873
     *                 lcol              ! low label colors                      PLOTS.6874
      common /zrcols/  zcol              ! zero line colors                      PLOTS.6875
      common /tlcols/  tcol              ! title colors                          PLOTS.6876
      common /lbcols/  hghlt,            ! highlighted labeled lines ?           PLOTS.6877
     *                 same,             ! line same color as label ?            PLOTS.6878
     *                 revrs,            ! text and fill reverse after zero ?    PLOTS.6879
     *                 lbco              ! line label colors                     PLOTS.6880
      common /perdet/  prput             ! put in a perimeter ?                  PLOTS.6881
      common /percol/  pcol              ! color index for perimeter             PLOTS.6882
      common /fildet/  fill,             ! will the plot be filled ?             PLOTS.6883
     *                 lshd,             ! draw contour lines over a fill ?      PLOTS.6884
     *                 color             ! make the plot in color ?              PLOTS.6885
      common /noplot/  noplt             ! has a non-correctable erro occured ?  PLOTS.6886
                                                                                 PLOTS.6887
C****************************  subroutine begin  *****************************C  PLOTS.6888
                                                                                 PLOTS.6889
C  If a non-correctable error has occured, don't bother reading the table        PLOTS.6890
                                                                                 PLOTS.6891
      if (noplt) goto 90                                                         PLOTS.6892
                                                                                 PLOTS.6893
C  Assume the table is not there                                                 PLOTS.6894
                                                                                 PLOTS.6895
      found = .false.                                                            PLOTS.6896
                                                                                 PLOTS.6897
C  The table should only be there if this is a color plot, we should only        PLOTS.6898
C  parse it if this is a color plot                                              PLOTS.6899
                                                                                 PLOTS.6900
      if (color)                                                                 PLOTS.6901
                                                                                 PLOTS.6902
C  Look for the CON COLORS table                                                 PLOTS.6903
                                                                                 PLOTS.6904
     *  call tbllok (unum,'CON COLORS',errsev,found,whline,'CONDRV')             PLOTS.6905
                                                                                 PLOTS.6906
C  Initialize the error flag                                                     PLOTS.6907
                                                                                 PLOTS.6908
      error = .false.                                                            PLOTS.6909
                                                                                 PLOTS.6910
C  If the table was there to be read, parse through it                           PLOTS.6911
                                                                                 PLOTS.6912
      if (found) then                                                            PLOTS.6913
                                                                                 PLOTS.6914
C  Initialize the place keeper                                                   PLOTS.6915
                                                                                 PLOTS.6916
        i = 1                                                                    PLOTS.6917
                                                                                 PLOTS.6918
C  Set up SEARCH and NEXT error message strings                                  PLOTS.6919
                                                                                 PLOTS.6920
        p(1:22)  = 'Reading Colors Table, '                                      PLOTS.6921
        p(23:60) = 'Too Few Entries On Line               '                      PLOTS.6922
        q(1:22)  = p(1:22)                                                       PLOTS.6923
        q(23:60) = 'Entry Is Bizarre                      '                      PLOTS.6924
                                                                                 PLOTS.6925
C  CMETH is the first item in the color table                                    PLOTS.6926
C  0   => Use all the defaults                                                   PLOTS.6927
C  1   => A single color to color all contour lines                              PLOTS.6928
C  2   => User will specify a group of partitions with one color                 PLOTS.6929
C         used per partition; partitions specified by level values               PLOTS.6930
C  3   => User will specify a group of partitions with one color                 PLOTS.6931
C         used per partition; partitions specified by level numbers              PLOTS.6932
C  4   => User will specify a group of partitions; color ramping will            PLOTS.6933
C         be done between two colors for each partition; partitons               PLOTS.6934
C         specified by level value                                               PLOTS.6935
C  5   => User will specify a group of partitions; color ramping will            PLOTS.6936
C         be done between two colors for each partition; partitions              PLOTS.6937
C         specified by level number                                              PLOTS.6938
C  6   => CONDRV chooses four partions and ramp between :                        PLOTS.6939
C         partition 1 : Blue to Cyan                                             PLOTS.6940
C         partition 2 : Cyan to Green                                            PLOTS.6941
C         partition 3 : Green to Yellow                                          PLOTS.6942
C         partition 4 : Yellow to Red                                            PLOTS.6943
C  7   => CONDRV will force 100 contour levels, select four partitions and       PLOTS.6944
C         ramp as above                                                          PLOTS.6945
C  anything else will cause a warning message and CMETH = 1 will be assumed      PLOTS.6946
                                                                                 PLOTS.6947
        call search (whline,i,error)                                             PLOTS.6948
        if (error) then                                                          PLOTS.6949
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.6950
          found = .false.                                                        PLOTS.6951
          cmeth = -1                                                             PLOTS.6952
        end if                                                                   PLOTS.6953
                                                                                 PLOTS.6954
        if (.not. error) then                                                    PLOTS.6955
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then           PLOTS.6956
            cmeth = 1                                                            PLOTS.6957
          else                                                                   PLOTS.6958
            read (whline(i:i),10,err=30) cmeth                                   PLOTS.6959
          end if                                                                 PLOTS.6960
          if ((cmeth .lt. 0) .or. (cmeth .gt. 7)) then                           PLOTS.6961
            ermes(1:30)  = 'Color Method Value Is Invalid,'                      PLOTS.6962
            ermes(31:60) = ' Options Are 0 Thru 7         '                      PLOTS.6963
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.6964
            cmeth = 1                                                            PLOTS.6965
          end if                                                                 PLOTS.6966
                                                                                 PLOTS.6967
C  CMETH = 0 Means all the defaults should be used, FOUND as false and           PLOTS.6968
C  ERROR as true will cause execution to lead right to the defaults assignments  PLOTS.6969
                                                                                 PLOTS.6970
          if (cmeth .eq. 0) then                                                 PLOTS.6971
            found = .false.                                                      PLOTS.6972
            call next (whline,i,error)                                           PLOTS.6973
            if (error) then                                                      PLOTS.6974
              call errhan ('CONDRV',1,q,errsev)                                  PLOTS.6975
            else                                                                 PLOTS.6976
              error = .true.                                                     PLOTS.6977
            end if                                                               PLOTS.6978
          end if                                                                 PLOTS.6979
          goto 35                                                                PLOTS.6980
                                                                                 PLOTS.6981
C  If there was an error during read give an error message                       PLOTS.6982
                                                                                 PLOTS.6983
30        ermes(1:30)  = 'Color Method Value Input Conve'                        PLOTS.6984
          ermes(31:60) = 'rsion                         '                        PLOTS.6985
          call errhan ('CONDRV',1,ermes,errsev)                                  PLOTS.6986
          cmeth = 1                                                              PLOTS.6987
          bckco = 1                                                              PLOTS.6988
                                                                                 PLOTS.6989
          error = .true.                                                         PLOTS.6990
                                                                                 PLOTS.6991
35        if (.not. error) then                                                  PLOTS.6992
            call next (whline,i,error)                                           PLOTS.6993
            if (error) then                                                      PLOTS.6994
              call errhan ('CONDRV',1,q,errsev)                                  PLOTS.6995
              bckco = 1                                                          PLOTS.6996
              rmeth = 0                                                          PLOTS.6997
            end if                                                               PLOTS.6998
          end if                                                                 PLOTS.6999
        end if                                                                   PLOTS.7000
                                                                                 PLOTS.7001
C  Next in line should always be BCKCO, which is the "BACKUP COLOR"              PLOTS.7002
C  BCKCO is used to color all contours when CMETH = 1                            PLOTS.7003
C  It is also used if any colors are accidentally left out of the table          PLOTS.7004
C  and it is used for any place that has a D or a d for the color                PLOTS.7005
                                                                                 PLOTS.7006
        if (.not. error) then                                                    PLOTS.7007
          call search (whline,i,error)                                           PLOTS.7008
          if (error) then                                                        PLOTS.7009
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7010
            bckco = 1                                                            PLOTS.7011
            rmeth = 0                                                            PLOTS.7012
          end if                                                                 PLOTS.7013
        end if                                                                   PLOTS.7014
                                                                                 PLOTS.7015
        call crdrci (.true.,error,bckco,1,whline,i,                              PLOTS.7016
     *               'Backup Color Index',18,errsev,noplt,                       PLOTS.7017
     *               'CONDRV')                                                   PLOTS.7018
        if (error) rmeth = 0                                                     PLOTS.7019
        if (noplt) goto 90                                                       PLOTS.7020
                                                                                 PLOTS.7021
        if (.not. error) then                                                    PLOTS.7022
          call next (whline,i,error)                                             PLOTS.7023
          if (error) then                                                        PLOTS.7024
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7025
            rmeth = 0                                                            PLOTS.7026
          end if                                                                 PLOTS.7027
        end if                                                                   PLOTS.7028
                                                                                 PLOTS.7029
C  Next item will be the ramping method if CMETH was specified as                PLOTS.7030
C  either 4 or 5                                                                 PLOTS.7031
                                                                                 PLOTS.7032
        if (((cmeth .eq. 4) .or. (cmeth .eq. 5)) .and.                           PLOTS.7033
     *      (.not. error)) then                                                  PLOTS.7034
          call search (whline,i,error)                                           PLOTS.7035
          if (error) then                                                        PLOTS.7036
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7037
            rmeth = 0                                                            PLOTS.7038
          end if                                                                 PLOTS.7039
        end if                                                                   PLOTS.7040
                                                                                 PLOTS.7041
C  L         => Linear Ramping                                                   PLOTS.7042
C  E         => Exponential Ramping                                              PLOTS.7043
C  S         => Sine Wavular Ramping Dude                                        PLOTS.7044
C  D         => Linear Ramping                                                   PLOTS.7045
C  anything else results in a warning message and linear ramping                 PLOTS.7046
                                                                                 PLOTS.7047
        if (((cmeth .eq. 4) .or. (cmeth .eq. 5)) .and.                           PLOTS.7048
     *      (.not. error)) then                                                  PLOTS.7049
          if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd') .or.            PLOTS.7050
     *        (whline(i:i) .eq. 'L') .or. (whline(i:i) .eq. 'l')) then           PLOTS.7051
            rmeth = 0                                                            PLOTS.7052
          else if ((whline(i:i) .eq. 'E') .or.                                   PLOTS.7053
     *             (whline(i:i) .eq. 'e')) then                                  PLOTS.7054
            rmeth = -1                                                           PLOTS.7055
          else if ((whline(i:i) .eq. 'S') .or.                                   PLOTS.7056
     *             (whline(i:i) .eq. 's')) then                                  PLOTS.7057
            rmeth = 1                                                            PLOTS.7058
          else                                                                   PLOTS.7059
            ermes(1:30)  = 'Ramping Method Flag Is Inconcl'                      PLOTS.7060
            ermes(31:60) = 'usive, L Assumed              '                      PLOTS.7061
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7062
            rmeth = 0                                                            PLOTS.7063
          end if                                                                 PLOTS.7064
                                                                                 PLOTS.7065
          call next (whline,i,error)                                             PLOTS.7066
          if (error)                                                             PLOTS.7067
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7068
        else                                                                     PLOTS.7069
          rmeth = 0                                                              PLOTS.7070
        end if                                                                   PLOTS.7071
                                                                                 PLOTS.7072
C  High label text and perimeter color is next                                   PLOTS.7073
C  D,d => use color index 1 (white)                                              PLOTS.7074
                                                                                 PLOTS.7075
        if ((hputl) .and. (.not. error)) then                                    PLOTS.7076
          call search (whline,i,error)                                           PLOTS.7077
          if (error)                                                             PLOTS.7078
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7079
        end if                                                                   PLOTS.7080
                                                                                 PLOTS.7081
        call crdrci (hputl,error,hcol(1),1,whline,i,                             PLOTS.7082
     *               'High Label Color Index',22,errsev,noplt,                   PLOTS.7083
     *               'CONDRV')                                                   PLOTS.7084
        if (noplt) goto 90                                                       PLOTS.7085
                                                                                 PLOTS.7086
        if ((hputl) .and. (.not. error)) then                                    PLOTS.7087
          call next (whline,i,error)                                             PLOTS.7088
          if (error)                                                             PLOTS.7089
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7090
        end if                                                                   PLOTS.7091
                                                                                 PLOTS.7092
C  If there was a box requested around the high labels and it is to be filled    PLOTS.7093
C  there should be a high fill color                                             PLOTS.7094
                                                                                 PLOTS.7095
        if ((hfilb) .and. (.not. error)) then                                    PLOTS.7096
          call search (whline,i,error)                                           PLOTS.7097
          if (error)                                                             PLOTS.7098
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7099
        end if                                                                   PLOTS.7100
                                                                                 PLOTS.7101
        call crdrci (hfilb,error,hcol(2),0,whline,i,                             PLOTS.7102
     *               'High Label Box Fill Color Index',32,errsev,                PLOTS.7103
     *               noplt,'CONDRV')                                             PLOTS.7104
        if (noplt) goto 90                                                       PLOTS.7105
                                                                                 PLOTS.7106
        if ((hfilb) .and. (.not. error)) then                                    PLOTS.7107
          call next (whline,i,error)                                             PLOTS.7108
          if (error)                                                             PLOTS.7109
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7110
        end if                                                                   PLOTS.7111
                                                                                 PLOTS.7112
C  Low label text and perimeter color is next                                    PLOTS.7113
C  D,d => use color index 1 (white)                                              PLOTS.7114
                                                                                 PLOTS.7115
        if ((hputl) .and. (.not. error)) then                                    PLOTS.7116
          call search (whline,i,error)                                           PLOTS.7117
          if (error)                                                             PLOTS.7118
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7119
        end if                                                                   PLOTS.7120
                                                                                 PLOTS.7121
        call crdrci (hputl,error,lcol(1),1,whline,i,                             PLOTS.7122
     *               'Low Label Color Index',21,errsev,noplt,                    PLOTS.7123
     *               'CONDRV')                                                   PLOTS.7124
        if (noplt) goto 90                                                       PLOTS.7125
                                                                                 PLOTS.7126
        if ((hputl) .and. (.not. error)) then                                    PLOTS.7127
          call next (whline,i,error)                                             PLOTS.7128
          if (error)                                                             PLOTS.7129
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7130
        end if                                                                   PLOTS.7131
                                                                                 PLOTS.7132
C  If there was a box requested around the low labels and it is to be filled     PLOTS.7133
C  there should be a low fill color                                              PLOTS.7134
                                                                                 PLOTS.7135
        if ((hfilb) .and. (.not. error)) then                                    PLOTS.7136
          call search (whline,i,error)                                           PLOTS.7137
          if (error)                                                             PLOTS.7138
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7139
        end if                                                                   PLOTS.7140
                                                                                 PLOTS.7141
        call crdrci (hfilb,error,lcol(2),0,whline,i,                             PLOTS.7142
     *               'Low Label Box Fill Color Index',31,errsev,                 PLOTS.7143
     *               noplt,'CONDRV')                                             PLOTS.7144
        if (noplt) goto 90                                                       PLOTS.7145
                                                                                 PLOTS.7146
        if ((hfilb) .and. (.not. error)) then                                    PLOTS.7147
          call next (whline,i,error)                                             PLOTS.7148
          if (error)                                                             PLOTS.7149
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7150
        end if                                                                   PLOTS.7151
                                                                                 PLOTS.7152
C  The zero line has three points in question                                    PLOTS.7153
C  First - Zero Line Label text and perimeter color index                        PLOTS.7154
C          D,d  => Use color of zero line                                        PLOTS.7155
                                                                                 PLOTS.7156
        if ((zl) .and. (lputl .eq. 1) .and. (.not. error)) then                  PLOTS.7157
          call search (whline,i,error)                                           PLOTS.7158
          if (error)                                                             PLOTS.7159
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7160
        end if                                                                   PLOTS.7161
                                                                                 PLOTS.7162
        if ((zl) .and. (lputl .eq. 1)) then                                      PLOTS.7163
          test = .true.                                                          PLOTS.7164
        else                                                                     PLOTS.7165
          test = .false.                                                         PLOTS.7166
        end if                                                                   PLOTS.7167
        call crdrci (test,error,zcol(1),idcsp,whline,i,                          PLOTS.7168
     *               'Zero Line Label Color Index',27,errsev,                    PLOTS.7169
     *               noplt,'CONDRV')                                             PLOTS.7170
        if (noplt) goto 90                                                       PLOTS.7171
                                                                                 PLOTS.7172
        if ((zl) .and. (lputl .eq. 1) .and. (.not. error)) then                  PLOTS.7173
          call next (whline,i,error)                                             PLOTS.7174
          if (error)                                                             PLOTS.7175
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7176
        end if                                                                   PLOTS.7177
                                                                                 PLOTS.7178
C  Second - Zero Line Label Box Fill Color index                                 PLOTS.7179
C           D,d  => Use black                                                    PLOTS.7180
                                                                                 PLOTS.7181
        if ((zl) .and. (lfilb) .and. (.not. error)) then                         PLOTS.7182
          call search (whline,i,error)                                           PLOTS.7183
          if (error)                                                             PLOTS.7184
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7185
        end if                                                                   PLOTS.7186
                                                                                 PLOTS.7187
        if ((zl) .and. (lfilb)) then                                             PLOTS.7188
          test = .true.                                                          PLOTS.7189
        else                                                                     PLOTS.7190
          test = .false.                                                         PLOTS.7191
        end if                                                                   PLOTS.7192
        call crdrci (test,error,zcol(2),0,whline,i,                              PLOTS.7193
     *               'Zero Line Label Box Fill Color Index',36,                  PLOTS.7194
     *               errsev,noplt,'CONDRV')                                      PLOTS.7195
        if (noplt) goto 90                                                       PLOTS.7196
                                                                                 PLOTS.7197
        if ((lfilb) .and. (zl) .and. (.not. error)) then                         PLOTS.7198
          call next (whline,i,error)                                             PLOTS.7199
          if (error)                                                             PLOTS.7200
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7201
        end if                                                                   PLOTS.7202
                                                                                 PLOTS.7203
C  Third - Zero Line color index                                                 PLOTS.7204
C          D,d  => Treat the zero line as any other line                         PLOTS.7205
                                                                                 PLOTS.7206
        if ((zl) .and. (.not. error) .and. (((fill) .and. (lshd)) .or.           PLOTS.7207
     *      (.not. fill))) then                                                  PLOTS.7208
          call search (whline,i,error)                                           PLOTS.7209
          if (error)                                                             PLOTS.7210
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7211
        end if                                                                   PLOTS.7212
                                                                                 PLOTS.7213
        if ((zl) .and. (((fill) .and. (lshd)) .or.                               PLOTS.7214
     *      (.not. fill))) then                                                  PLOTS.7215
          test = .true.                                                          PLOTS.7216
        else                                                                     PLOTS.7217
          test = .false.                                                         PLOTS.7218
        end if                                                                   PLOTS.7219
        call crdrci (test,error,zcol(3),idcsp,whline,i,                          PLOTS.7220
     *               'Zero Line Color Index',21,errsev,noplt,                    PLOTS.7221
     *               'CONDRV')                                                   PLOTS.7222
        if (noplt) goto 90                                                       PLOTS.7223
                                                                                 PLOTS.7224
        if ((zl) .and. (.not. error) .and. (((fill) .and. (lshd)) .or.           PLOTS.7225
     *      (.not. fill))) then                                                  PLOTS.7226
          call next (whline,i,error)                                             PLOTS.7227
          if (error)                                                             PLOTS.7228
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7229
        end if                                                                   PLOTS.7230
                                                                                 PLOTS.7231
C  Title text and perimeter color is next                                        PLOTS.7232
C  D,d => use color index 1 (white)                                              PLOTS.7233
                                                                                 PLOTS.7234
        if ((tputl .ge. 0) .and. (.not. error)) then                             PLOTS.7235
          call search (whline,i,error)                                           PLOTS.7236
          if (error)                                                             PLOTS.7237
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7238
        end if                                                                   PLOTS.7239
                                                                                 PLOTS.7240
        if (tputl .ge. 0) then                                                   PLOTS.7241
          test = .true.                                                          PLOTS.7242
        else                                                                     PLOTS.7243
          test = .false.                                                         PLOTS.7244
        end if                                                                   PLOTS.7245
        call crdrci (test,error,tcol(1),1,whline,i,                              PLOTS.7246
     *               'Title Color Index',17,errsev,noplt,                        PLOTS.7247
     *               'CONDRV')                                                   PLOTS.7248
        if (noplt) goto 90                                                       PLOTS.7249
                                                                                 PLOTS.7250
        if ((tputl .ge. 0) .and. (.not. error)) then                             PLOTS.7251
          call next (whline,i,error)                                             PLOTS.7252
          if (error)                                                             PLOTS.7253
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7254
        end if                                                                   PLOTS.7255
                                                                                 PLOTS.7256
C  If there was a box requested around the title and it is to be filled          PLOTS.7257
C  there should be a title fill color                                            PLOTS.7258
                                                                                 PLOTS.7259
        if (((tfilb) .or. (tputl .eq. 0)) .and. (.not. error)) then              PLOTS.7260
          call search (whline,i,error)                                           PLOTS.7261
          if (error)                                                             PLOTS.7262
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7263
        end if                                                                   PLOTS.7264
                                                                                 PLOTS.7265
        if (((tfilb) .or. (tputl .eq. 0)) .and. (.not. error)) then              PLOTS.7266
          test = .true.                                                          PLOTS.7267
        else                                                                     PLOTS.7268
          test = .false.                                                         PLOTS.7269
        end if                                                                   PLOTS.7270
        call crdrci (test,error,tcol(2),0,whline,i,                              PLOTS.7271
     *               'Title Box Fill Color Index',26,errsev,                     PLOTS.7272
     *               noplt,'CONDRV')                                             PLOTS.7273
        if (noplt) goto 90                                                       PLOTS.7274
                                                                                 PLOTS.7275
        if (((tfilb) .or. (tputl .eq. 0)) .and. (.not. error)) then              PLOTS.7276
          call next (whline,i,error)                                             PLOTS.7277
          if (error)                                                             PLOTS.7278
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7279
        end if                                                                   PLOTS.7280
                                                                                 PLOTS.7281
C  Last Group - The Line Label Things                                            PLOTS.7282
C  Initialize variables                                                          PLOTS.7283
                                                                                 PLOTS.7284
        hghlt = .false.                                                          PLOTS.7285
        same  = .false.                                                          PLOTS.7286
        revrs = .false.                                                          PLOTS.7287
                                                                                 PLOTS.7288
C  First - The Line Label Flag, It may be :                                      PLOTS.7289
C  H  => Special Highlighted Lines and Labels, Don't read third                  PLOTS.7290
C  S  => Line color is given by the label color which is given third             PLOTS.7291
C  D  => Label color is the same as the line color which is given third          PLOTS.7292
C  R  => Label Text/Perimeter color and Box Fill color should be flipped         PLOTS.7293
C        at the zero line, lines default and text/perimeter color is given       PLOTS.7294
C        third                                                                   PLOTS.7295
C  #  => the color index for the label text/perimeter                            PLOTS.7296
                                                                                 PLOTS.7297
        if ((lputl .ge. 0) .and. (.not. error)) then                             PLOTS.7298
          call search (whline,i,error)                                           PLOTS.7299
          if (error)                                                             PLOTS.7300
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7301
        end if                                                                   PLOTS.7302
                                                                                 PLOTS.7303
        if ((lputl .ge. 0) .and. (.not. error)) then                             PLOTS.7304
          if ((whline(i:i) .eq. 'H') .or. (whline(i:i) .eq. 'h')) then           PLOTS.7305
            hghlt   = .true.                                                     PLOTS.7306
            lbco(1) = 0                                                          PLOTS.7307
          else if ((whline(i:i) .eq. 'S') .or.                                   PLOTS.7308
     *             (whline(i:i) .eq. 's')) then                                  PLOTS.7309
            same    = .true.                                                     PLOTS.7310
            lbco(1) = 0                                                          PLOTS.7311
          else if ((whline(i:i) .eq. 'R') .or.                                   PLOTS.7312
     *             (whline(i:i) .eq. 'r')) then                                  PLOTS.7313
            revrs   = .true.                                                     PLOTS.7314
            lbco(1) = 0                                                          PLOTS.7315
          else                                                                   PLOTS.7316
            call crdrci (.true.,error,lbco(1),idcsp,whline,i,                    PLOTS.7317
     *                   'Line Label Color',16,errsev,noplt,                     PLOTS.7318
     *                   'CONDRV')                                               PLOTS.7319
            if (noplt) goto 90                                                   PLOTS.7320
          end if                                                                 PLOTS.7321
        else                                                                     PLOTS.7322
          lbco(1) = 0                                                            PLOTS.7323
        end if                                                                   PLOTS.7324
                                                                                 PLOTS.7325
C  If the user requested zero line reversal and conrec style line labels         PLOTS.7326
C  tell then where they are wistling                                             PLOTS.7327
                                                                                 PLOTS.7328
        if ((lputl .eq. 0) .and. (revrs)) then                                   PLOTS.7329
          ermes(1:30)  = 'Zero Line Reversal And Conrec '                        PLOTS.7330
          ermes(31:60) = 'Style Labeling Do Not Mix     '                        PLOTS.7331
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.7332
          revrs = .false.                                                        PLOTS.7333
        end if                                                                   PLOTS.7334
                                                                                 PLOTS.7335
        if ((lputl .ge. 0) .and. (.not. error)) then                             PLOTS.7336
          call next (whline,i,error)                                             PLOTS.7337
          if (error)                                                             PLOTS.7338
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7339
        end if                                                                   PLOTS.7340
                                                                                 PLOTS.7341
C  Second - Line Label Box Fill color index                                      PLOTS.7342
C           D,d  => fill in black                                                PLOTS.7343
                                                                                 PLOTS.7344
        if ((lfilb) .and. (.not. error)) then                                    PLOTS.7345
          call search (whline,i,error)                                           PLOTS.7346
          if (error)                                                             PLOTS.7347
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7348
        end if                                                                   PLOTS.7349
                                                                                 PLOTS.7350
        call crdrci (lfilb,error,lbco(2),0,whline,i,                             PLOTS.7351
     *               'Line Label Fill Color Index',27,errsev,                    PLOTS.7352
     *               noplt,'CONDRV')                                             PLOTS.7353
        if (noplt) goto 90                                                       PLOTS.7354
                                                                                 PLOTS.7355
        if ((lfilb) .and. (.not. error)) then                                    PLOTS.7356
          call next (whline,i,error)                                             PLOTS.7357
          if (error)                                                             PLOTS.7358
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7359
        end if                                                                   PLOTS.7360
                                                                                 PLOTS.7361
C  Third - Labeled Line Color Index                                              PLOTS.7362
C          D,d  => treat it as any other contour line                            PLOTS.7363
                                                                                 PLOTS.7364
        if ((lputl .ge. 0) .and. (.not. hghlt) .and.                             PLOTS.7365
     *      (.not. error)) then                                                  PLOTS.7366
          call search (whline,i,error)                                           PLOTS.7367
          if (error)                                                             PLOTS.7368
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7369
        end if                                                                   PLOTS.7370
                                                                                 PLOTS.7371
        if ((lputl .ge. 0) .and. (.not. hghlt)) then                             PLOTS.7372
          test = .true.                                                          PLOTS.7373
        else                                                                     PLOTS.7374
          test = .false.                                                         PLOTS.7375
        end if                                                                   PLOTS.7376
        call crdrci (test,error,lbco(3),idcsp,whline,i,                          PLOTS.7377
     *               'Labeled Line Color Index',24,errsev,                       PLOTS.7378
     *               noplt,'CONDRV')                                             PLOTS.7379
        if (noplt) goto 90                                                       PLOTS.7380
                                                                                 PLOTS.7381
        if ((lputl .ge. 0) .and. (.not. error)) then                             PLOTS.7382
          call next (whline,i,error)                                             PLOTS.7383
          if (error)                                                             PLOTS.7384
     *      call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7385
        end if                                                                   PLOTS.7386
                                                                                 PLOTS.7387
C  If the user requested two different colors for the label and the line         PLOTS.7388
C  and requested CONREC style labels, tell them it ain't gonna work              PLOTS.7389
                                                                                 PLOTS.7390
        if ((lputl .eq. 0) .and. (lbco(1) .ne. lbco(3)) .and.                    PLOTS.7391
     *      (.not. same) .and. (.not. hghlt)) then                               PLOTS.7392
          ermes(1:30)  = 'Line And Labels Cannot Be Diff'                        PLOTS.7393
          ermes(31:60) = 'erent Colors With CONREC Style'                        PLOTS.7394
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.7395
          lbco(1) = -1                                                           PLOTS.7396
        end if                                                                   PLOTS.7397
                                                                                 PLOTS.7398
C  Perimeter color is next                                                       PLOTS.7399
C  D,d => use color index 1 (white)                                              PLOTS.7400
                                                                                 PLOTS.7401
        if ((prput) .and. (.not. error)) then                                    PLOTS.7402
          call search (whline,i,error)                                           PLOTS.7403
          if (error)                                                             PLOTS.7404
     *      call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7405
        end if                                                                   PLOTS.7406
                                                                                 PLOTS.7407
        call crdrci (prput,error,pcol,1,whline,i,                                PLOTS.7408
     *               'Perimeter Color Index',21,errsev,noplt,                    PLOTS.7409
     *               'CONDRV')                                                   PLOTS.7410
        if (noplt) goto 90                                                       PLOTS.7411
                                                                                 PLOTS.7412
        if ((prput) .and. (.not. error)) then                                    PLOTS.7413
          call next (whline,i,error)                                             PLOTS.7414
          if (error)                                                             PLOTS.7415
     *      call errhan ('CONDRV',0,q,errsev)                                    PLOTS.7416
        end if                                                                   PLOTS.7417
                                                                                 PLOTS.7418
C  Check for extra entries at the end of the line                                PLOTS.7419
                                                                                 PLOTS.7420
        if ((.not. error) .or. ((.not. found) .and.                              PLOTS.7421
     *      (cmeth .eq. 0))) then                                                PLOTS.7422
          call search (whline,i,error)                                           PLOTS.7423
          if (.not. error) then                                                  PLOTS.7424
            ermes(1:30)  = 'Reading Color Table, Too Many '                      PLOTS.7425
            ermes(31:60) = 'Entries On Line               '                      PLOTS.7426
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7427
          end if                                                                 PLOTS.7428
        end if                                                                   PLOTS.7429
                                                                                 PLOTS.7430
C  Inform the user all is at least okay                                          PLOTS.7431
                                                                                 PLOTS.7432
        if (cmeth .ne. 0) print *, 'CONDRV - Contour Colors Set Up'              PLOTS.7433
      end if                                                                     PLOTS.7434
                                                                                 PLOTS.7435
C  If the table was not found, assign the defaults                               PLOTS.7436
                                                                                 PLOTS.7437
      if (.not. found) then                                                      PLOTS.7438
        print *, 'CONDRV - Default Contour Colors Used'                          PLOTS.7439
        cmeth   = 0                                                              PLOTS.7440
        bckco   = 1                                                              PLOTS.7441
        rmeth   = 0                                                              PLOTS.7442
        hcol(1) = 1                                                              PLOTS.7443
        hcol(2) = 0                                                              PLOTS.7444
        lcol(1) = 1                                                              PLOTS.7445
        lcol(2) = 0                                                              PLOTS.7446
        zcol(1) = 1                                                              PLOTS.7447
        zcol(2) = 0                                                              PLOTS.7448
        zcol(3) = 1                                                              PLOTS.7449
        tcol(1) = 1                                                              PLOTS.7450
        tcol(2) = 0                                                              PLOTS.7451
        hghlt   = .false.                                                        PLOTS.7452
        same    = .false.                                                        PLOTS.7453
        revrs   = .false.                                                        PLOTS.7454
        lbco(1) = 1                                                              PLOTS.7455
        lbco(2) = 0                                                              PLOTS.7456
        lbco(3) = 1                                                              PLOTS.7457
        pcol    = 1                                                              PLOTS.7458
      end if                                                                     PLOTS.7459
                                                                                 PLOTS.7460
C  Set up output variable                                                        PLOTS.7461
                                                                                 PLOTS.7462
      ometh = cmeth                                                              PLOTS.7463
                                                                                 PLOTS.7464
C*****************************  subroutine end  ******************************C  PLOTS.7465
                                                                                 PLOTS.7466
C  Format statements begin ...                                                   PLOTS.7467
                                                                                 PLOTS.7468
10    format (I1)                                                                PLOTS.7469
20    format (I2)                                                                PLOTS.7470
                                                                                 PLOTS.7471
C  Format statements end.                                                        PLOTS.7472
                                                                                 PLOTS.7473
90    return                                                                     PLOTS.7474
      end                                                                        PLOTS.7475
                                                                                 PLOTS.7476
      subroutine crddet (unum,errsev,pnum,hfilb,tfilb,lfilb)                     PLOTS.7477
                                                                                 PLOTS.7478
C*****************************************************************************C  PLOTS.7479
C  crddet   - this is a CONDRV routine                                        C  PLOTS.7480
C  Section  - Tables                                                          C  PLOTS.7481
C  Purpose  - To read in the entire details table including:  Color, shading, C  PLOTS.7482
C             line width and dash pattern characteristics; High/Low label in- C  PLOTS.7483
C             formation; Line Label information; and Title details.           C  PLOTS.7484
C                                                                             C  PLOTS.7485
C  On entry - UNUM is the unit number from which to read the table.    ERRSEV C  PLOTS.7486
C             indicates at what severity of error execution should halt. PNUM C  PLOTS.7487
C             is the number of call this was to CONDRV within one frame.      C  PLOTS.7488
C                                                                             C  PLOTS.7489
C  On exit  - All CONDRV variables associated with the aforementioned details C  PLOTS.7490
C             have been set up.  See common blocks in this routine and in the C  PLOTS.7491
C             routines CRDHLO, CRDLAB, CRDTTL for more information. The three C  PLOTS.7492
C             variables, HFILB, TFILB and LFILB indicate whether boxes around C  PLOTS.7493
C             the high/low labels, the title and the line labels respectively C  PLOTS.7494
C             are to be filled.                                               C  PLOTS.7495
C                                                                             C  PLOTS.7496
C  Assume   - Nothing                                                         C  PLOTS.7497
C                                                                             C  PLOTS.7498
C  Notes    - Routine             Location of Definition                      C  PLOTS.7499
C             ----------------------------------------------------------------C  PLOTS.7500
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.7501
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.7502
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.7503
C             CRDHLO              CONDRV utility                              C  PLOTS.7504
C             CRDLAB              CONDRV utility                              C  PLOTS.7505
C             CRDTTL              CONDRV utility                              C  PLOTS.7506
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.7507
C             TBLLOK              CONDRV/MAPDRV utility                       C  PLOTS.7508
C             ----------------------------------------------------------------C  PLOTS.7509
C                                                                             C  PLOTS.7510
C  Author   - Jeremy Asbill      Date - June 6, 1990        for the MM4 club  C  PLOTS.7511
C*****************************************************************************C  PLOTS.7512
                                                                                 PLOTS.7513
C  Parameter                                                                     PLOTS.7514
                                                                                 PLOTS.7515
      parameter       (wltwo = 2.0)      ! line width for even overlays          PLOTS.7516
                                                                                 PLOTS.7517
C  Character variables                                                           PLOTS.7518
                                                                                 PLOTS.7519
      character*80     whline            ! a whole line from the table  (local)  PLOTS.7520
      character*60     ermes,            ! error message string         (local)  PLOTS.7521
     *                 p,                ! error message string, SEARCH (local)  PLOTS.7522
     *                 q                 ! error message string, NEXT   (local)  PLOTS.7523
      character*20     tstrg             ! temporary string             (local)  PLOTS.7524
                                                                                 PLOTS.7525
C  Integer variables                                                             PLOTS.7526
                                                                                 PLOTS.7527
      integer          errsev,           ! error severity comparitor       (in)  PLOTS.7528
     *                 unum,             ! unit number of info. file       (in)  PLOTS.7529
     *                 pnum              ! overlay indicator               (in)  PLOTS.7530
      integer          ddpv(3)           ! for common block LWDPDT               PLOTS.7531
      integer          lputl,            ! for common block QLBDET               PLOTS.7532
     *                 tputl             ! for common block QLBDET               PLOTS.7533
      integer          dlwi,             ! line width partition indic.  (local)  PLOTS.7534
     *                 ddpi,             ! dash pat. partition indic.   (local)  PLOTS.7535
     *                 i,j,k,n           ! loop counter/place keepers   (local)  PLOTS.7536
                                                                                 PLOTS.7537
C  Logical variables                                                             PLOTS.7538
                                                                                 PLOTS.7539
      logical          hfilb,            ! fill high/low label boxes ?    (out)  PLOTS.7540
     *                 lfilb,            ! fill line label boxes ?        (out)  PLOTS.7541
     *                 tfilb             ! fill title box ?               (out)  PLOTS.7542
      logical          noplt             ! for common block NOPLOT               PLOTS.7543
      logical          fshd              ! for common block SHDDIR               PLOTS.7544
      logical          hputl             ! for common block QLBDET               PLOTS.7545
      logical          fill,             ! for common block FILDET               PLOTS.7546
     *                 lshd,             ! for common block FILDET               PLOTS.7547
     *                 color             ! for common block FILDET               PLOTS.7548
      logical          prput             ! for common block PERDET               PLOTS.7549
      logical          error,            ! error reading table ?        (local)  PLOTS.7550
     *                 found,            ! is the table there ?         (local)  PLOTS.7551
     *                 done,             ! loop test flag ?             (local)  PLOTS.7552
     *                 dash              ! has dash pattern been read ? (local)  PLOTS.7553
                                                                                 PLOTS.7554
C  Real variables                                                                PLOTS.7555
                                                                                 PLOTS.7556
      real             dlwv(3)           ! for common block LWDPDT               PLOTS.7557
      real             temp              ! temporary storage            (local)  PLOTS.7558
                                                                                 PLOTS.7559
C  Common blocks                                                                 PLOTS.7560
                                                                                 PLOTS.7561
      common /shddir/  fshd              ! should shading go from low to high ?  PLOTS.7562
      common /fildet/  fill,             ! will the plot be filled ?             PLOTS.7563
     *                 lshd,             ! draw contour lines over a fill ?      PLOTS.7564
     *                 color             ! make the plot in color ?              PLOTS.7565
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.7566
     *                 lputl,            ! draw in line labels                   PLOTS.7567
     *                 tputl             ! draw in the title                     PLOTS.7568
      common /lwdpdt/  dlwv,             ! details line width values             PLOTS.7569
     *                 ddpv              ! details dash pattern values           PLOTS.7570
      common /perdet/  prput             ! put in a perimeter ?                  PLOTS.7571
      common /noplot/  noplt             ! has a non-correctable erro occured ?  PLOTS.7572
                                                                                 PLOTS.7573
C****************************  subroutine begin  *****************************C  PLOTS.7574
                                                                                 PLOTS.7575
C  Check if we need to read in the table at all                                  PLOTS.7576
                                                                                 PLOTS.7577
      if (noplt) goto 130                                                        PLOTS.7578
                                                                                 PLOTS.7579
C  Initialze ERROR and output flags                                              PLOTS.7580
                                                                                 PLOTS.7581
      error = .false.                                                            PLOTS.7582
      lfilb = .false.                                                            PLOTS.7583
      hfilb = .false.                                                            PLOTS.7584
      tfilb = .false.                                                            PLOTS.7585
                                                                                 PLOTS.7586
C  Look for the table                                                            PLOTS.7587
                                                                                 PLOTS.7588
      call tbllok (unum,'CON DETAIL',errsev,found,whline,'CONDRV')               PLOTS.7589
                                                                                 PLOTS.7590
C  If the table was there parse the input                                        PLOTS.7591
                                                                                 PLOTS.7592
      if (found) then                                                            PLOTS.7593
                                                                                 PLOTS.7594
C  Initialize the place keeper                                                   PLOTS.7595
                                                                                 PLOTS.7596
        i = 1                                                                    PLOTS.7597
                                                                                 PLOTS.7598
C  Set up error messages got errors in SEARCH and NEXT                           PLOTS.7599
                                                                                 PLOTS.7600
        p(1:23)  = 'Reading Details Table, '                                     PLOTS.7601
        p(24:60) = 'Too Few Entries On Line              '                       PLOTS.7602
        q(1:23)  = p(1:23)                                                       PLOTS.7603
        q(24:60) = 'Entry Is Bizarre                     '                       PLOTS.7604
                                                                                 PLOTS.7605
C  Parse the line starting with the color flag                                   PLOTS.7606
C  Y             => the plot will be color                                       PLOTS.7607
C  N             => the plot will not be color                                   PLOTS.7608
C  anything else => gives a waring                                               PLOTS.7609
                                                                                 PLOTS.7610
        call search (whline,i,error)                                             PLOTS.7611
        if (error) then                                                          PLOTS.7612
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.7613
          color   = .false.                                                      PLOTS.7614
          fill    = .false.                                                      PLOTS.7615
          hputl   = .true.                                                       PLOTS.7616
          lputl   = 0                                                            PLOTS.7617
          tputl   = 1                                                            PLOTS.7618
          prput   = .false.                                                      PLOTS.7619
        end if                                                                   PLOTS.7620
                                                                                 PLOTS.7621
        if (.not. error) then                                                    PLOTS.7622
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.7623
            color = .true.                                                       PLOTS.7624
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.7625
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.7626
            color = .false.                                                      PLOTS.7627
          else                                                                   PLOTS.7628
            ermes(1:30)  = 'Color Flag Entry Is Inconclusi'                      PLOTS.7629
            ermes(31:60) = 've, N Assumed                 '                      PLOTS.7630
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7631
            color = .false.                                                      PLOTS.7632
          end if                                                                 PLOTS.7633
          call next (whline,i,error)                                             PLOTS.7634
          if (error) then                                                        PLOTS.7635
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7636
            fill    = .false.                                                    PLOTS.7637
            hputl   = .true.                                                     PLOTS.7638
            lputl   = 0                                                          PLOTS.7639
            tputl   = 1                                                          PLOTS.7640
            prput   = .false.                                                    PLOTS.7641
          end if                                                                 PLOTS.7642
        end if                                                                   PLOTS.7643
                                                                                 PLOTS.7644
C  Check to see if the plot will be filled                                       PLOTS.7645
C  Y             => the plot will be filled                                      PLOTS.7646
C  N             => the plot will not be filled                                  PLOTS.7647
C  anything else => gives a warning message                                      PLOTS.7648
                                                                                 PLOTS.7649
        if (.not. error) then                                                    PLOTS.7650
          call search (whline,i,error)                                           PLOTS.7651
          if (error) then                                                        PLOTS.7652
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7653
            fill    = .false.                                                    PLOTS.7654
            hputl   = .true.                                                     PLOTS.7655
            lputl   = 0                                                          PLOTS.7656
            tputl   = 1                                                          PLOTS.7657
            prput   = .false.                                                    PLOTS.7658
          end if                                                                 PLOTS.7659
        end if                                                                   PLOTS.7660
                                                                                 PLOTS.7661
        if (.not. error) then                                                    PLOTS.7662
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.7663
            fill = .true.                                                        PLOTS.7664
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.7665
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.7666
            fill = .false.                                                       PLOTS.7667
          else                                                                   PLOTS.7668
            ermes(1:30)  = 'Fill Flag Entry Is Inconclusiv'                      PLOTS.7669
            ermes(31:60) = 'e, N Assumed                  '                      PLOTS.7670
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7671
            fill = .false.                                                       PLOTS.7672
          end if                                                                 PLOTS.7673
          call next (whline,i,error)                                             PLOTS.7674
          if (error) then                                                        PLOTS.7675
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7676
            hputl   = .true.                                                     PLOTS.7677
            lputl   = 0                                                          PLOTS.7678
            tputl   = 1                                                          PLOTS.7679
            prput   = .false.                                                    PLOTS.7680
          end if                                                                 PLOTS.7681
        end if                                                                   PLOTS.7682
                                                                                 PLOTS.7683
C  If COLOR is false and FILL is true then the plot will be shaded and           PLOTS.7684
C  we will need to know if we should shade from low to high or high to           PLOTS.7685
C  low                                                                           PLOTS.7686
C  This flag is only here if COLOR is false and FILL is true                     PLOTS.7687
C  H             => high gets highest shading intensity                          PLOTS.7688
C  L             => low gets highest shading intensity                           PLOTS.7689
C  anything else => give a warning message                                       PLOTS.7690
                                                                                 PLOTS.7691
        if ((.not. color) .and. (fill) .and. (.not. error)) then                 PLOTS.7692
          call search (whline,i,error)                                           PLOTS.7693
          if (error) then                                                        PLOTS.7694
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7695
            hputl  = .true.                                                      PLOTS.7696
            lputl  = 0                                                           PLOTS.7697
            tputl  = 1                                                           PLOTS.7698
            prput   = .false.                                                    PLOTS.7699
          end if                                                                 PLOTS.7700
        end if                                                                   PLOTS.7701
                                                                                 PLOTS.7702
        if ((.not. color) .and. (fill) .and. (.not. error)) then                 PLOTS.7703
          if ((whline(i:i) .eq. 'H') .or. (whline(i:i) .eq. 'h')) then           PLOTS.7704
            fshd = .false.                                                       PLOTS.7705
          else if ((whline(i:i) .eq. 'L') .or.                                   PLOTS.7706
     *             (whline(i:i) .eq. 'l')) then                                  PLOTS.7707
            fshd = .true.                                                        PLOTS.7708
          else                                                                   PLOTS.7709
            ermes(1:30)  = 'Shading Direction Indicator Is'                      PLOTS.7710
            ermes(31:60) = 'Missing Or Invalid, H Used    '                      PLOTS.7711
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7712
            fshd = .false.                                                       PLOTS.7713
          end if                                                                 PLOTS.7714
          call next (whline,i,error)                                             PLOTS.7715
          if (error) then                                                        PLOTS.7716
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7717
            hputl   = .true.                                                     PLOTS.7718
            lputl   = 0                                                          PLOTS.7719
            tputl   = 1                                                          PLOTS.7720
            prput   = .false.                                                    PLOTS.7721
          end if                                                                 PLOTS.7722
        else                                                                     PLOTS.7723
          fshd = .false.                                                         PLOTS.7724
        end if                                                                   PLOTS.7725
                                                                                 PLOTS.7726
C  If FILL is true then there will be a flag saying whether the lines            PLOTS.7727
C  should be drawn in at all                                                     PLOTS.7728
C  Y             => draw in the lines                                            PLOTS.7729
C  N             => don't draw in the lines                                      PLOTS.7730
C  anything else => give a warning message                                       PLOTS.7731
C  If the plot will be color filled and this flag is Y the backup color will     PLOTS.7732
C  be used to draw the lines                                                     PLOTS.7733
                                                                                 PLOTS.7734
        if ((fill) .and. (.not. error)) then                                     PLOTS.7735
          call search (whline,i,error)                                           PLOTS.7736
          if (error) then                                                        PLOTS.7737
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7738
            hputl   = .true.                                                     PLOTS.7739
            lputl   = 0                                                          PLOTS.7740
            tputl   = 1                                                          PLOTS.7741
            prput   = .false.                                                    PLOTS.7742
          end if                                                                 PLOTS.7743
        end if                                                                   PLOTS.7744
                                                                                 PLOTS.7745
        if ((fill) .and. (.not. error)) then                                     PLOTS.7746
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.7747
            lshd = .true.                                                        PLOTS.7748
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.7749
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.7750
            lshd = .false.                                                       PLOTS.7751
          else                                                                   PLOTS.7752
            ermes(1:30)  = 'Draw Fill Line Flag Is Inconcl'                      PLOTS.7753
            ermes(31:60) = 'usive, N Assumed              '                      PLOTS.7754
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7755
            lshd = .false.                                                       PLOTS.7756
          end if                                                                 PLOTS.7757
          call next (whline,i,error)                                             PLOTS.7758
          if (error) then                                                        PLOTS.7759
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7760
            hputl   = .true.                                                     PLOTS.7761
            lputl   = 0                                                          PLOTS.7762
            tputl   = 1                                                          PLOTS.7763
            prput   = .false.                                                    PLOTS.7764
          end if                                                                 PLOTS.7765
        else                                                                     PLOTS.7766
          lshd = .false.                                                         PLOTS.7767
        end if                                                                   PLOTS.7768
                                                                                 PLOTS.7769
C  Parse through in the high/low label flag                                      PLOTS.7770
C  Y             => include the high/low labels                                  PLOTS.7771
C  N             => don't include the high/low labels                            PLOTS.7772
C  anything else => give a warning message                                       PLOTS.7773
                                                                                 PLOTS.7774
        if (.not. error) then                                                    PLOTS.7775
          call search (whline,i,error)                                           PLOTS.7776
          if (error) then                                                        PLOTS.7777
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7778
            hputl   = .true.                                                     PLOTS.7779
            lputl   = 0                                                          PLOTS.7780
            tputl   = 1                                                          PLOTS.7781
            prput   = .false.                                                    PLOTS.7782
          end if                                                                 PLOTS.7783
        end if                                                                   PLOTS.7784
                                                                                 PLOTS.7785
        if (.not. error) then                                                    PLOTS.7786
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.7787
            hputl = .false.                                                      PLOTS.7788
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.7789
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.7790
            hputl = .true.                                                       PLOTS.7791
          else                                                                   PLOTS.7792
            ermes(1:30)  = 'High/Low Label Flag Is Inconcl'                      PLOTS.7793
            ermes(31:60) = 'usive, Y Assumed              '                      PLOTS.7794
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7795
            hputl = .true.                                                       PLOTS.7796
          end if                                                                 PLOTS.7797
          call next (whline,i,error)                                             PLOTS.7798
          if (error) then                                                        PLOTS.7799
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7800
            lputl   = 0                                                          PLOTS.7801
            tputl   = 1                                                          PLOTS.7802
            prput   = .false.                                                    PLOTS.7803
          end if                                                                 PLOTS.7804
        end if                                                                   PLOTS.7805
                                                                                 PLOTS.7806
C  Parse through in the line label flag                                          PLOTS.7807
C  Y             => include the line labels                                      PLOTS.7808
C  N             => don't include the line labels                                PLOTS.7809
C  anything else => give a warning message                                       PLOTS.7810
                                                                                 PLOTS.7811
        if (.not. error) then                                                    PLOTS.7812
          call search (whline,i,error)                                           PLOTS.7813
          if (error) then                                                        PLOTS.7814
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7815
            lputl   = 0                                                          PLOTS.7816
            tputl   = 1                                                          PLOTS.7817
            prput   = .false.                                                    PLOTS.7818
          end if                                                                 PLOTS.7819
        end if                                                                   PLOTS.7820
                                                                                 PLOTS.7821
        if (.not. error) then                                                    PLOTS.7822
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.7823
            lputl = -1                                                           PLOTS.7824
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.7825
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.7826
            lputl = 1                                                            PLOTS.7827
          else if ((whline(i:i) .eq. 'C') .or.                                   PLOTS.7828
     *             (whline(i:i) .eq. 'c')) then                                  PLOTS.7829
            lputl = 0                                                            PLOTS.7830
          else                                                                   PLOTS.7831
            ermes(1:30)  = 'Line Label Flag Is Inconclusiv'                      PLOTS.7832
            ermes(31:60) = 'e, C Assumed                  '                      PLOTS.7833
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7834
            lputl = 0                                                            PLOTS.7835
          end if                                                                 PLOTS.7836
          call next (whline,i,error)                                             PLOTS.7837
          if (error) then                                                        PLOTS.7838
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7839
            tputl   = 1                                                          PLOTS.7840
            prput   = .false.                                                    PLOTS.7841
          end if                                                                 PLOTS.7842
        end if                                                                   PLOTS.7843
                                                                                 PLOTS.7844
C  Parse through in the title flag                                               PLOTS.7845
C  Y             => include the title                                            PLOTS.7846
C  N             => don't include the title                                      PLOTS.7847
C  anything else => give a warning message                                       PLOTS.7848
                                                                                 PLOTS.7849
        if (.not. error) then                                                    PLOTS.7850
          call search (whline,i,error)                                           PLOTS.7851
          if (error) then                                                        PLOTS.7852
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7853
            tputl   = 1                                                          PLOTS.7854
            prput   = .false.                                                    PLOTS.7855
          end if                                                                 PLOTS.7856
        end if                                                                   PLOTS.7857
                                                                                 PLOTS.7858
        if (.not. error) then                                                    PLOTS.7859
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.7860
            tputl = -1                                                           PLOTS.7861
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.7862
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.7863
            tputl = 1                                                            PLOTS.7864
          else if ((whline(i:i) .eq. 'L') .or.                                   PLOTS.7865
     *             (whline(i:i) .eq. 'l')) then                                  PLOTS.7866
            tputl = 0                                                            PLOTS.7867
          else                                                                   PLOTS.7868
            ermes(1:30)  = 'Title Flag Is Inconclusive, Y '                      PLOTS.7869
            ermes(31:60) = 'Assumed                       '                      PLOTS.7870
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7871
            tputl = 1                                                            PLOTS.7872
          end if                                                                 PLOTS.7873
          call next (whline,i,error)                                             PLOTS.7874
          if (error) then                                                        PLOTS.7875
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7876
            prput = .false.                                                      PLOTS.7877
          end if                                                                 PLOTS.7878
        end if                                                                   PLOTS.7879
                                                                                 PLOTS.7880
C  Parse through in the perimeter flag                                           PLOTS.7881
C  Y             => include the perimeter                                        PLOTS.7882
C  N             => don't include the perimeter                                  PLOTS.7883
C  anything else => give a warning message                                       PLOTS.7884
                                                                                 PLOTS.7885
        if (.not. error) then                                                    PLOTS.7886
          call search (whline,i,error)                                           PLOTS.7887
          if (error) then                                                        PLOTS.7888
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.7889
            prput = .false.                                                      PLOTS.7890
          end if                                                                 PLOTS.7891
        end if                                                                   PLOTS.7892
                                                                                 PLOTS.7893
        if (.not. error) then                                                    PLOTS.7894
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.7895
            prput = .false.                                                      PLOTS.7896
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.7897
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.7898
            prput = .true.                                                       PLOTS.7899
          else                                                                   PLOTS.7900
            ermes(1:30)  = 'Perimeter Flag Is Inconclusive'                      PLOTS.7901
            ermes(31:60) = ', N Assumed                   '                      PLOTS.7902
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.7903
            prput = .false.                                                      PLOTS.7904
          end if                                                                 PLOTS.7905
          call next (whline,i,error)                                             PLOTS.7906
          if (error) then                                                        PLOTS.7907
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.7908
          end if                                                                 PLOTS.7909
        end if                                                                   PLOTS.7910
                                                                                 PLOTS.7911
C  Check to see if the line width or dash pattern is here                        PLOTS.7912
                                                                                 PLOTS.7913
        dlwv(1) = -1.0                                                           PLOTS.7914
        dlwv(2) = -1.0                                                           PLOTS.7915
        dlwv(3) = -1.0                                                           PLOTS.7916
        ddpv(1) = 0                                                              PLOTS.7917
        ddpv(2) = 0                                                              PLOTS.7918
        ddpv(3) = 0                                                              PLOTS.7919
        if ((.not. error) .and. ((lshd) .or. (.not. fill))) then                 PLOTS.7920
          dash    = .false.                                                      PLOTS.7921
50        call search (whline,i,error)                                           PLOTS.7922
          if (.not. error) then                                                  PLOTS.7923
                                                                                 PLOTS.7924
C  One or both of them are here, figure out which                                PLOTS.7925
                                                                                 PLOTS.7926
            if ((whline(i:i) .eq. 'L') .or.                                      PLOTS.7927
     *          (whline(i:i) .eq. 'l')) then                                     PLOTS.7928
                                                                                 PLOTS.7929
C  This is line width                                                            PLOTS.7930
                                                                                 PLOTS.7931
              i = i + 1                                                          PLOTS.7932
              dlwv(1) = 1.0                                                      PLOTS.7933
              dlwv(2) = 1.0                                                      PLOTS.7934
              dlwv(3) = 1.0                                                      PLOTS.7935
              n = 1                                                              PLOTS.7936
              done = .false.                                                     PLOTS.7937
30            continue                                                           PLOTS.7938
                                                                                 PLOTS.7939
C  Get the detail line width indicator                                           PLOTS.7940
C  +             => only positive contours are affected by the following value   PLOTS.7941
C  -             => only negative contours are affected by the following value   PLOTS.7942
C  @             => only the zero line is affected by the following value        PLOTS.7943
C  =             => all contours are affected by the following value             PLOTS.7944
C  D,d           => all contours will be normal line width                       PLOTS.7945
C  anything else => give a warning message                                       PLOTS.7946
                                                                                 PLOTS.7947
                if (whline(i:i) .eq. '+') then                                   PLOTS.7948
                  dlwi = 1                                                       PLOTS.7949
                else if (whline(i:i) .eq. '-') then                              PLOTS.7950
                  dlwi = -1                                                      PLOTS.7951
                else if (whline(i:i) .eq. '@') then                              PLOTS.7952
                  dlwi = 0                                                       PLOTS.7953
                else if (whline(i:i) .eq. '=') then                              PLOTS.7954
                  dlwi = 2                                                       PLOTS.7955
                else if ((whline(i:i) .eq. 'd') .or.                             PLOTS.7956
     *                   (whline(i:i) .eq. 'D')) then                            PLOTS.7957
                  done    = .true.                                               PLOTS.7958
                else                                                             PLOTS.7959
                  ermes(1:30)  = 'Detail Line Width Indicator Is'                PLOTS.7960
                  ermes(31:60) = ' Invalid, Options: +-=@dD     '                PLOTS.7961
                  call errhan ('CONDRV',0,ermes,errsev)                          PLOTS.7962
                  done    = .true.                                               PLOTS.7963
                end if                                                           PLOTS.7964
                                                                                 PLOTS.7965
C  Parse out the line width multiplier                                           PLOTS.7966
C  any multiplier less than 1.0 is ineffective                                   PLOTS.7967
                                                                                 PLOTS.7968
                if (.not. done) then                                             PLOTS.7969
                  j = i                                                          PLOTS.7970
                  i = i + 1                                                      PLOTS.7971
10                j = j + 1                                                      PLOTS.7972
                  if ((whline(j:j) .ne. '+') .and.                               PLOTS.7973
     *                (whline(j:j) .ne. '-') .and.                               PLOTS.7974
     *                (whline(j:j) .ne. '=') .and.                               PLOTS.7975
     *                (whline(j:j) .ne. '@') .and.                               PLOTS.7976
     *                (whline(j:j) .ne. ' ') .and.                               PLOTS.7977
     *                (whline(j:j) .ne. '|') .and.                               PLOTS.7978
     *                (whline(j:j) .ne. 'D') .and.                               PLOTS.7979
     *                (whline(j:j) .ne. 'd'))                                    PLOTS.7980
     *              goto 10                                                      PLOTS.7981
                  tstrg(1:j-i) = whline(i:j-1)                                   PLOTS.7982
                  if ((tstrg(1:j-i) .eq. 'D') .or.                               PLOTS.7983
     *                (tstrg(1:j-i) .eq. 'd')) then                              PLOTS.7984
                    temp = 1.0                                                   PLOTS.7985
                  else                                                           PLOTS.7986
                    do 40 k = j-i+1,20                                           PLOTS.7987
                      tstrg(k:k) = ' '                                           PLOTS.7988
40                  continue                                                     PLOTS.7989
                    call gtreal (tstrg(1:20),temp,error)                         PLOTS.7990
                    if (error) then                                              PLOTS.7991
                      ermes(1:30)  = 'Could Not Convert Line Width M'            PLOTS.7992
                      ermes(31:60) = 'ultiplier To A Real Number    '            PLOTS.7993
                      call errhan ('CONDRV',0,ermes,errsev)                      PLOTS.7994
                      temp = 1.0                                                 PLOTS.7995
                    end if                                                       PLOTS.7996
                                                                                 PLOTS.7997
C  Line width multipliers must be between 1 and 10 inclusive                     PLOTS.7998
                                                                                 PLOTS.7999
                    if (temp .lt. 1.0) then                                      PLOTS.8000
                      ermes(1:30)  = 'Line Width Multipliers Less Th'            PLOTS.8001
                      ermes(31:60) = 'an One, Have No Effect        '            PLOTS.8002
                      call errhan ('CONDRV',0,ermes,errsev)                      PLOTS.8003
                      temp = 1.0                                                 PLOTS.8004
                    end if                                                       PLOTS.8005
                    if (temp .gt. 10.0) then                                     PLOTS.8006
                      ermes(1:30)  = 'Line Width Multipliers Greater'            PLOTS.8007
                      ermes(31:60) = ' Than 10 Are Invalid          '            PLOTS.8008
                      call errhan ('CONDRV',0,ermes,errsev)                      PLOTS.8009
                      temp = 10.0                                                PLOTS.8010
                    end if                                                       PLOTS.8011
                  end if                                                         PLOTS.8012
                  i = j                                                          PLOTS.8013
                  if (dlwi .eq. 1) then                                          PLOTS.8014
                    dlwv(1) = temp                                               PLOTS.8015
                  else if (dlwi .eq. -1) then                                    PLOTS.8016
                    dlwv(3) = temp                                               PLOTS.8017
                  else if (dlwi .eq. 0) then                                     PLOTS.8018
                    dlwv(2) = temp                                               PLOTS.8019
                  else                                                           PLOTS.8020
                    dlwv(1) = temp                                               PLOTS.8021
                    dlwv(2) = temp                                               PLOTS.8022
                    dlwv(3) = temp                                               PLOTS.8023
                    done = .true.                                                PLOTS.8024
                  end if                                                         PLOTS.8025
                end if                                                           PLOTS.8026
                                                                                 PLOTS.8027
C  Determine if the entire line width string has been parsed, if not             PLOTS.8028
C  continue parsing otherwise go on.  There can never be more than three         PLOTS.8029
C  linwe width entries                                                           PLOTS.8030
                                                                                 PLOTS.8031
                if ((whline(i:i) .eq. ' ') .or.                                  PLOTS.8032
     *              (whline(i:i) .eq. '|') .or.                                  PLOTS.8033
     *              (n .eq. 3)) then                                             PLOTS.8034
                  done = .true.                                                  PLOTS.8035
                else                                                             PLOTS.8036
                  n = n + 1                                                      PLOTS.8037
                end if                                                           PLOTS.8038
              if (.not. done) goto 30                                            PLOTS.8039
            else if ((whline(i:i) .eq. 'D') .or.                                 PLOTS.8040
     *               (whline(i:i) .eq. 'd')) then                                PLOTS.8041
              dash = .true.                                                      PLOTS.8042
                                                                                 PLOTS.8043
C  This is dash pattern                                                          PLOTS.8044
                                                                                 PLOTS.8045
              i = i + 1                                                          PLOTS.8046
              ddpv(1) = -1                                                       PLOTS.8047
              ddpv(2) = -1                                                       PLOTS.8048
              ddpv(3) = 21845                                                    PLOTS.8049
              n = 1                                                              PLOTS.8050
              done = .false.                                                     PLOTS.8051
60            continue                                                           PLOTS.8052
                                                                                 PLOTS.8053
C  Get the detail dash pattern indicator                                         PLOTS.8054
C  +             => only positive contours are affected by the following value   PLOTS.8055
C  -             => only negative contours are affected by the following value   PLOTS.8056
C  @             => only the zero line is affected by the following value        PLOTS.8057
C  =             => all contours are affected by the following value             PLOTS.8058
C  D,d           => all contours will be normal line width                       PLOTS.8059
C  anything else => give a warning message                                       PLOTS.8060
                                                                                 PLOTS.8061
                if (whline(i:i) .eq. '+') then                                   PLOTS.8062
                  ddpi = 1                                                       PLOTS.8063
                else if (whline(i:i) .eq. '-') then                              PLOTS.8064
                  ddpi = -1                                                      PLOTS.8065
                else if (whline(i:i) .eq. '@') then                              PLOTS.8066
                  ddpi = 0                                                       PLOTS.8067
                else if (whline(i:i) .eq. '=') then                              PLOTS.8068
                  ddpi = 2                                                       PLOTS.8069
                else if ((whline(i:i) .eq. 'd') .or.                             PLOTS.8070
     *                   (whline(i:i) .eq. 'D')) then                            PLOTS.8071
                  done    = .true.                                               PLOTS.8072
                else                                                             PLOTS.8073
                  ermes(1:30)  = 'Detail Dash Pattern Indicator '                PLOTS.8074
                  ermes(31:60) = 'Is Invalid, Options: +-=@dD   '                PLOTS.8075
                  call errhan ('CONDRV',0,ermes,errsev)                          PLOTS.8076
                  done    = .true.                                               PLOTS.8077
                end if                                                           PLOTS.8078
                                                                                 PLOTS.8079
C  Parse out the dash pattern                                                    PLOTS.8080
C  L  => DDPV = 255   ; or 0000000011111111 ; or Large                           PLOTS.8081
C  M  => DDPV = 3855  ; or 0000111100001111 ; or Medium                          PLOTS.8082
C  SM => DDPV = 13107 ; or 0011001100110011 ; or SMall                           PLOTS.8083
C  T  => DDPV = 21845 ; or 0101010101010101 ; or Tiny                            PLOTS.8084
C  SO => DDPV = -1    ; or 1111111111111111 ; or SOlid                           PLOTS.8085
C  D  => DDPV = -1    ; or 1111111111111111 ; or Default for non negatives       PLOTS.8086
C  D  => DDPV = 21845 ; or 0101010101010101 ; or Default for negatives           PLOTS.8087
                                                                                 PLOTS.8088
                if (.not. done) then                                             PLOTS.8089
                  i = i + 1                                                      PLOTS.8090
                  if ((whline(i:i) .eq. 'L') .or.                                PLOTS.8091
     *                (whline(i:i) .eq. 'l')) then                               PLOTS.8092
                    j = 255                                                      PLOTS.8093
                  else if ((whline(i:i) .eq. 'M') .or.                           PLOTS.8094
     *                     (whline(i:i) .eq. 'm')) then                          PLOTS.8095
                    j = 3855                                                     PLOTS.8096
                  else if ((whline(i:i+1) .eq. 'SM') .or.                        PLOTS.8097
     *                     (whline(i:i+1) .eq. 'Sm') .or.                        PLOTS.8098
     *                     (whline(i:i+1) .eq. 'sM') .or.                        PLOTS.8099
     *                     (whline(i:i+1) .eq. 'sm')) then                       PLOTS.8100
                    j = 13107                                                    PLOTS.8101
                  else if ((whline(i:i) .eq. 'T') .or.                           PLOTS.8102
     *                     (whline(i:i) .eq. 't')) then                          PLOTS.8103
                    j = 21845                                                    PLOTS.8104
                  else if ((whline(i:i+1) .eq. 'SO') .or.                        PLOTS.8105
     *                     (whline(i:i+1) .eq. 'So') .or.                        PLOTS.8106
     *                     (whline(i:i+1) .eq. 'sO') .or.                        PLOTS.8107
     *                     (whline(i:i+1) .eq. 'so')) then                       PLOTS.8108
                    j = -1                                                       PLOTS.8109
                  else if (((whline(i:i) .eq. 'D') .or.                          PLOTS.8110
     *                      (whline(i:i) .eq. 'd')) .and.                        PLOTS.8111
     *                     (ddpi .eq. -1)) then                                  PLOTS.8112
                    j = 21845                                                    PLOTS.8113
                  else if (((whline(i:i) .eq. 'D') .or.                          PLOTS.8114
     *                      (whline(i:i) .eq. 'd')) .and.                        PLOTS.8115
     *                     (ddpi .ne. -1)) then                                  PLOTS.8116
                    j = -1                                                       PLOTS.8117
                  else                                                           PLOTS.8118
                    ermes(1:30)  = 'Dash Pattern Entry Is In Error'              PLOTS.8119
                    ermes(31:60) = ', Options: LG ME SM TI SO D   '              PLOTS.8120
                    call errhan ('CONDRV',0,ermes,errsev)                        PLOTS.8121
                    j = -1                                                       PLOTS.8122
                  end if                                                         PLOTS.8123
                  if (ddpi .eq. 1) then                                          PLOTS.8124
                    ddpv(1) = j                                                  PLOTS.8125
                  else if (ddpi .eq. -1) then                                    PLOTS.8126
                    ddpv(3) = j                                                  PLOTS.8127
                  else if (ddpi .eq. 0) then                                     PLOTS.8128
                    ddpv(2) = j                                                  PLOTS.8129
                  else                                                           PLOTS.8130
                    ddpv(1) = j                                                  PLOTS.8131
                    ddpv(2) = j                                                  PLOTS.8132
                    ddpv(3) = j                                                  PLOTS.8133
                    done = .true.                                                PLOTS.8134
                  end if                                                         PLOTS.8135
                end if                                                           PLOTS.8136
                                                                                 PLOTS.8137
C  Look for the next indicator                                                   PLOTS.8138
                                                                                 PLOTS.8139
70              i = i + 1                                                        PLOTS.8140
                if ((whline(i:i) .ne. '+') .and.                                 PLOTS.8141
     *              (whline(i:i) .ne. '-') .and.                                 PLOTS.8142
     *              (whline(i:i) .ne. '=') .and.                                 PLOTS.8143
     *              (whline(i:i) .ne. '@') .and.                                 PLOTS.8144
     *              (whline(i:i) .ne. ' ') .and.                                 PLOTS.8145
     *              (whline(i:i) .ne. '|') .and.                                 PLOTS.8146
     *              (whline(i:i) .ne. 'D') .and.                                 PLOTS.8147
     *              (whline(i:i) .ne. 'd'))                                      PLOTS.8148
     *            goto 70                                                        PLOTS.8149
                                                                                 PLOTS.8150
C  Determine if the entire dash pattern string has been parsed, if not           PLOTS.8151
C  continue parsing otherwise go on.  There can never be more than three         PLOTS.8152
C  dash pattern entries                                                          PLOTS.8153
                                                                                 PLOTS.8154
                if ((whline(i:i) .eq. ' ') .or.                                  PLOTS.8155
     *              (whline(i:i) .eq. '|') .or.                                  PLOTS.8156
     *              (n .eq. 3)) then                                             PLOTS.8157
                  done = .true.                                                  PLOTS.8158
                else                                                             PLOTS.8159
                  n = n + 1                                                      PLOTS.8160
                end if                                                           PLOTS.8161
              if (.not. done) goto 60                                            PLOTS.8162
            else                                                                 PLOTS.8163
              ermes(1:30)  = 'Expecting Line Width Or Dash P'                    PLOTS.8164
              ermes(31:60) = 'attern Information            '                    PLOTS.8165
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.8166
              dash = .true.                                                      PLOTS.8167
            end if                                                               PLOTS.8168
            call next (whline,i,error)                                           PLOTS.8169
          else                                                                   PLOTS.8170
            dash  = .true.                                                       PLOTS.8171
            error = .false.                                                      PLOTS.8172
            i     = 80                                                           PLOTS.8173
          end if                                                                 PLOTS.8174
          if (error) then                                                        PLOTS.8175
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8176
          else if (.not. dash) then                                              PLOTS.8177
            goto 50                                                              PLOTS.8178
          end if                                                                 PLOTS.8179
        else                                                                     PLOTS.8180
                                                                                 PLOTS.8181
C  No lines are going to be drawn so no line width and dash pattern              PLOTS.8182
C  is necessary                                                                  PLOTS.8183
                                                                                 PLOTS.8184
          ddpv(1) = -1                                                           PLOTS.8185
          ddpv(2) = -1                                                           PLOTS.8186
          ddpv(3) = -1                                                           PLOTS.8187
          dlwv(1) = 1.0                                                          PLOTS.8188
          dlwv(2) = 1.0                                                          PLOTS.8189
          dlwv(3) = 1.0                                                          PLOTS.8190
        end if                                                                   PLOTS.8191
                                                                                 PLOTS.8192
C  Check to see that everything is hunky dory at the end of the line             PLOTS.8193
                                                                                 PLOTS.8194
        call search (whline,i,error)                                             PLOTS.8195
        if (.not. error) then                                                    PLOTS.8196
          ermes(1:30)  = 'Reading First Line Of Details '                        PLOTS.8197
          ermes(31:60) = 'Table, Too Many Entries       '                        PLOTS.8198
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.8199
        end if                                                                   PLOTS.8200
                                                                                 PLOTS.8201
C  If high/low labels were requested read in high/low information from           PLOTS.8202
C  the next line of information in the table                                     PLOTS.8203
                                                                                 PLOTS.8204
        if (hputl) then                                                          PLOTS.8205
          read (unum,90,end=80,err=80) whline(1:1)                               PLOTS.8206
          read (unum,90,end=80,err=80) whline(1:1)                               PLOTS.8207
          read (unum,90,end=80,err=80) whline(1:1)                               PLOTS.8208
          read (unum,100,end=80,err=80) whline(1:80)                             PLOTS.8209
                                                                                 PLOTS.8210
C  Read in all the high/low information                                          PLOTS.8211
                                                                                 PLOTS.8212
          call crdhlo (whline,errsev,hfilb)                                      PLOTS.8213
          goto 85                                                                PLOTS.8214
                                                                                 PLOTS.8215
C  If there was an error in the read, give an error message, then                PLOTS.8216
C  default the high/low label information                                        PLOTS.8217
                                                                                 PLOTS.8218
80        ermes(1:30)   = 'Could Not Read In High/Low Lab'                       PLOTS.8219
          ermes(31:60)  = 'el Information Line           '                       PLOTS.8220
          call errhan ('CONDRV',1,ermes,errsev)                                  PLOTS.8221
          whline(1:40)  = '                                        '             PLOTS.8222
          whline(41:80) = '                                        '             PLOTS.8223
          call crdhlo (whline,errsev,hfilb)                                      PLOTS.8224
85        continue                                                               PLOTS.8225
        end if                                                                   PLOTS.8226
                                                                                 PLOTS.8227
C  If line labels were requested read in the line label information from         PLOTS.8228
C  the next line of information in the table                                     PLOTS.8229
                                                                                 PLOTS.8230
        if (lputl .eq. 1) then                                                   PLOTS.8231
          read (unum,90,end=110,err=110) whline(1:1)                             PLOTS.8232
          read (unum,90,end=110,err=110) whline(1:1)                             PLOTS.8233
          read (unum,90,end=110,err=110) whline(1:1)                             PLOTS.8234
          read (unum,100,end=110,err=110) whline(1:80)                           PLOTS.8235
                                                                                 PLOTS.8236
C  Read in all the label information                                             PLOTS.8237
                                                                                 PLOTS.8238
          call crdlab (whline,errsev,lfilb)                                      PLOTS.8239
          goto 115                                                               PLOTS.8240
                                                                                 PLOTS.8241
C  If there was an error reading in the information, give an error               PLOTS.8242
C  message and default the line label information                                PLOTS.8243
                                                                                 PLOTS.8244
110       ermes(1:30)   = 'Could Not Read In Line Label I'                       PLOTS.8245
          ermes(31:60)  = 'nformation Line               '                       PLOTS.8246
          call errhan ('CONDRV',1,ermes,errsev)                                  PLOTS.8247
          whline(1:40)  = '                                        '             PLOTS.8248
          whline(41:80) = '                                        '             PLOTS.8249
          call crdlab (whline,errsev,lfilb)                                      PLOTS.8250
115       continue                                                               PLOTS.8251
        end if                                                                   PLOTS.8252
                                                                                 PLOTS.8253
C  If a title is to be drawn read the information concerning it from the         PLOTS.8254
C  next line of information in the table                                         PLOTS.8255
                                                                                 PLOTS.8256
        if (tputl .ge. 0) then                                                   PLOTS.8257
          read (unum,90,end=120,err=120) whline(1:1)                             PLOTS.8258
          read (unum,90,end=120,err=120) whline(1:1)                             PLOTS.8259
          read (unum,90,end=120,err=120) whline(1:1)                             PLOTS.8260
          read (unum,100,end=120,err=120) whline(1:80)                           PLOTS.8261
                                                                                 PLOTS.8262
C  Read in all the title information                                             PLOTS.8263
                                                                                 PLOTS.8264
          call crdttl (whline,errsev,tputl,tfilb)                                PLOTS.8265
          goto 125                                                               PLOTS.8266
                                                                                 PLOTS.8267
C  If there was an error in the read, give an error message and default          PLOTS.8268
C  the title information                                                         PLOTS.8269
                                                                                 PLOTS.8270
120       ermes(1:30)   = 'Could Not Read In Title Inform'                       PLOTS.8271
          ermes(31:60)  = 'ation Line                    '                       PLOTS.8272
          call errhan ('CONDRV',1,ermes,errsev)                                  PLOTS.8273
          whline(1:40)  = '                                        '             PLOTS.8274
          whline(41:80) = '                                        '             PLOTS.8275
          call crdttl (whline,errsev,tputl,tfilb)                                PLOTS.8276
125       continue                                                               PLOTS.8277
        end if                                                                   PLOTS.8278
                                                                                 PLOTS.8279
C  Tell the user the details are set up, even if an error occured but            PLOTS.8280
C  didn't stop execution                                                         PLOTS.8281
                                                                                 PLOTS.8282
        print *, 'CONDRV - Contour Details Set Up'                               PLOTS.8283
      else                                                                       PLOTS.8284
                                                                                 PLOTS.8285
C  Assign defaults if the table is not there                                     PLOTS.8286
                                                                                 PLOTS.8287
        print *, 'CONDRV - Default Contour Details Used'                         PLOTS.8288
        color       = .false.                                                    PLOTS.8289
        fill        = .false.                                                    PLOTS.8290
        hputl       = .true.                                                     PLOTS.8291
        lputl       = 0                                                          PLOTS.8292
        lshd        = .false.                                                    PLOTS.8293
        fshd        = .false.                                                    PLOTS.8294
        prput       = .false.                                                    PLOTS.8295
        tputl       = 1                                                          PLOTS.8296
        if (mod(pnum,2) .eq. 0) then                                             PLOTS.8297
          ddpv(1) = -1                                                           PLOTS.8298
          ddpv(2) = -1                                                           PLOTS.8299
          ddpv(3) = -1                                                           PLOTS.8300
          dlwv(1) = wltwo                                                        PLOTS.8301
          dlwv(2) = wltwo                                                        PLOTS.8302
          dlwv(3) = wltwo                                                        PLOTS.8303
        else                                                                     PLOTS.8304
          ddpv(1) = -1                                                           PLOTS.8305
          ddpv(2) = -1                                                           PLOTS.8306
          ddpv(3) = 21845                                                        PLOTS.8307
          dlwv(1) = 1.0                                                          PLOTS.8308
          dlwv(2) = 1.0                                                          PLOTS.8309
          dlwv(3) = 1.0                                                          PLOTS.8310
        end if                                                                   PLOTS.8311
        whline(1:40)  = '                                        '               PLOTS.8312
        whline(41:80) = '                                        '               PLOTS.8313
        call crdhlo (whline,errsev,hfilb)                                        PLOTS.8314
        call crdttl (whline,errsev,tputl,tfilb)                                  PLOTS.8315
      end if                                                                     PLOTS.8316
                                                                                 PLOTS.8317
C*****************************  subroutine end  ******************************C  PLOTS.8318
                                                                                 PLOTS.8319
C  Format statements begin ...                                                   PLOTS.8320
                                                                                 PLOTS.8321
90    format (A1)                                                                PLOTS.8322
100   format (A80)                                                               PLOTS.8323
                                                                                 PLOTS.8324
C  Format statements end.                                                        PLOTS.8325
                                                                                 PLOTS.8326
                                                                                 PLOTS.8327
130   return                                                                     PLOTS.8328
      end                                                                        PLOTS.8329
      subroutine crdhlo (whline,errsev,ofilb)                                    PLOTS.8330
                                                                                 PLOTS.8331
C*****************************************************************************C  PLOTS.8332
C  crdhlo   - this is a CONDRV routine                                        C  PLOTS.8333
C  Section  - Tables                                                          C  PLOTS.8334
C  Purpose  - This routine determines high/low  label information as was des- C  PLOTS.8335
C             scribed by the user in the DETAILS table.                       C  PLOTS.8336
C                                                                             C  PLOTS.8337
C  On entry - WHLINE contains the line of the DETAILS table containing all of C  PLOTS.8338
C             the high/low label information.  ERRSEV indicates at  what sev- C  PLOTS.8339
C             erity or error execution should halt.                           C  PLOTS.8340
C                                                                             C  PLOTS.8341
C  On exit  - All variables in common block HLODET have been properly set up. C  PLOTS.8342
C             The variables in common block HLQDET are set up.  OFILB says if C  PLOTS.8343
C             the high/low label boxes should be filled or not.               C  PLOTS.8344
C                                                                             C  PLOTS.8345
C  Assume   - Nothing.                                                        C  PLOTS.8346
C                                                                             C  PLOTS.8347
C  Notes    - Routine             Location of Definition                      C  PLOTS.8348
C             ----------------------------------------------------------------C  PLOTS.8349
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.8350
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.8351
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.8352
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.8353
C             ----------------------------------------------------------------C  PLOTS.8354
C                                                                             C  PLOTS.8355
C  Author   - Jeremy Asbill       Date - June 11, 1990      for the MM4 club  C  PLOTS.8356
C*****************************************************************************C  PLOTS.8357
                                                                                 PLOTS.8358
C  Character variables                                                           PLOTS.8359
                                                                                 PLOTS.8360
      character*80     whline            ! a line from the table           (in)  PLOTS.8361
      character*60     ermes,            ! error message string,general (local)  PLOTS.8362
     *                 p,                ! error message string,SEARCH  (local)  PLOTS.8363
     *                 q                 ! error message string,NEXT    (local)  PLOTS.8364
      character*20     gstrng            ! temporary string             (local)  PLOTS.8365
                                                                                 PLOTS.8366
C  Integer variables                                                             PLOTS.8367
                                                                                 PLOTS.8368
      integer          errsev            ! error severity comparitor       (in)  PLOTS.8369
      integer          hstyl(2),         ! for common block HLODET               PLOTS.8370
     *                 hsize,            ! for common block HLODET               PLOTS.8371
     *                 hangl             ! for common block HLODET               PLOTS.8372
      integer          hqual(2)          ! for common block HLQDET               PLOTS.8373
      integer          i                 ! loop counter                 (local)  PLOTS.8374
                                                                                 PLOTS.8375
C  Logical variables                                                             PLOTS.8376
                                                                                 PLOTS.8377
      logical          ofilb             ! out version of HFILB           (out)  PLOTS.8378
      logical          hputb             ! for common block HLBDET               PLOTS.8379
      logical          hputp,            ! for common block HLODET               PLOTS.8380
     *                 hfilb,            ! for common block HLODET               PLOTS.8381
     *                 hfilt             ! for common block HLODET               PLOTS.8382
      logical          error             ! has an error been detected ? (local)  PLOTS.8383
                                                                                 PLOTS.8384
C  Real variables                                                                PLOTS.8385
                                                                                 PLOTS.8386
      real             hprlw             ! for common block HLODET               PLOTS.8387
                                                                                 PLOTS.8388
C  Common blocks                                                                 PLOTS.8389
                                                                                 PLOTS.8390
      common /hlbdet/  hputb             ! draw boxes around highs and lows ?    PLOTS.8391
      common /hlodet/  hputp,            ! darw in perimeter on boxes ?          PLOTS.8392
     *                 hfilb,            ! fill in the the box ?                 PLOTS.8393
     *                 hprlw,            ! line width for box perimeter          PLOTS.8394
     *                 hstyl,            ! high/low style indicator              PLOTS.8395
     *                 hsize,            ! character size for highs and lows     PLOTS.8396
     *                 hfilt,            ! use an overlap filter ?               PLOTS.8397
     *                 hangl             ! angle for horiz. to draw highs/lows   PLOTS.8398
      common /hlqdet/  hqual             ! character quality                     PLOTS.8399
                                                                                 PLOTS.8400
C****************************  subroutine begin  *****************************C  PLOTS.8401
                                                                                 PLOTS.8402
C  Set up I to use as a counter                                                  PLOTS.8403
                                                                                 PLOTS.8404
      i = 1                                                                      PLOTS.8405
                                                                                 PLOTS.8406
C  Initialize the error flag                                                     PLOTS.8407
                                                                                 PLOTS.8408
      error = .false.                                                            PLOTS.8409
                                                                                 PLOTS.8410
C  Set up SEARCH and NEXT error strings                                          PLOTS.8411
                                                                                 PLOTS.8412
      p(1:23)  = 'Reading High/Low Inform'                                       PLOTS.8413
      p(24:60) = 'ation Line, Too Few Entries On Line  '                         PLOTS.8414
      q(1:23)  = p(1:23)                                                         PLOTS.8415
      q(24:60) = 'ation Line, Entry Is Bizzare         '                         PLOTS.8416
                                                                                 PLOTS.8417
C  Do we want to draw in boxes                                                   PLOTS.8418
                                                                                 PLOTS.8419
      call search (whline,i,error)                                               PLOTS.8420
      if (error) then                                                            PLOTS.8421
        hputb    = .false.                                                       PLOTS.8422
        hputb    = .false.                                                       PLOTS.8423
        hfilb    = .false.                                                       PLOTS.8424
        hstyl(1) = 13                                                            PLOTS.8425
        hstyl(2) = 13                                                            PLOTS.8426
        hsize    = 12                                                            PLOTS.8427
        hfilt    = .false.                                                       PLOTS.8428
        hangl    = 0                                                             PLOTS.8429
        hqual(1) = 1                                                             PLOTS.8430
        hqual(2) = 1                                                             PLOTS.8431
      end if                                                                     PLOTS.8432
                                                                                 PLOTS.8433
      if (.not. error) then                                                      PLOTS.8434
        if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then             PLOTS.8435
          hputb = .true.                                                         PLOTS.8436
        else if ((whline(i:i) .eq. 'N') .or.                                     PLOTS.8437
     *           (whline(i:i) .eq. 'n')) then                                    PLOTS.8438
          hputb = .false.                                                        PLOTS.8439
        else                                                                     PLOTS.8440
          ermes(1:30)  = 'High/Low Label Box Flag Is Inc'                        PLOTS.8441
          ermes(31:60) = 'conclusive, N Assumed         '                        PLOTS.8442
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.8443
          hputb = .false.                                                        PLOTS.8444
        end if                                                                   PLOTS.8445
        call next (whline,i,error)                                               PLOTS.8446
        if (error) then                                                          PLOTS.8447
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.8448
          hstyl(1) = 13                                                          PLOTS.8449
          hstyl(2) = 13                                                          PLOTS.8450
          hsize    = 12                                                          PLOTS.8451
          hfilt    = .false.                                                     PLOTS.8452
          hangl    = 0                                                           PLOTS.8453
          hqual(1) = 1                                                           PLOTS.8454
          hqual(2) = 1                                                           PLOTS.8455
        end if                                                                   PLOTS.8456
      end if                                                                     PLOTS.8457
                                                                                 PLOTS.8458
C  Do we want to draw in the perimeter on the boxes                              PLOTS.8459
                                                                                 PLOTS.8460
      if ((hputb) .and. (.not. error)) then                                      PLOTS.8461
        call search (whline,i,error)                                             PLOTS.8462
        if (error) then                                                          PLOTS.8463
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8464
          hputp    = .false.                                                     PLOTS.8465
          hfilb    = .false.                                                     PLOTS.8466
          hprlw    = 0.0                                                         PLOTS.8467
          hstyl(1) = 13                                                          PLOTS.8468
          hstyl(2) = 13                                                          PLOTS.8469
          hsize    = 12                                                          PLOTS.8470
          hfilt    = .false.                                                     PLOTS.8471
          hangl    = 0                                                           PLOTS.8472
          hqual(1) = 1                                                           PLOTS.8473
          hqual(2) = 1                                                           PLOTS.8474
        end if                                                                   PLOTS.8475
                                                                                 PLOTS.8476
        if (.not. error) then                                                    PLOTS.8477
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.8478
            hputp = .false.                                                      PLOTS.8479
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.8480
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.8481
            hputp = .true.                                                       PLOTS.8482
          else                                                                   PLOTS.8483
            ermes(1:30)  = 'High/Low Label Box Perimeter F'                      PLOTS.8484
            ermes(31:60) = 'lag Is Inconclusive, Y Assumed'                      PLOTS.8485
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.8486
            hputp = .true.                                                       PLOTS.8487
          end if                                                                 PLOTS.8488
          call next (whline,i,error)                                             PLOTS.8489
          if (error) then                                                        PLOTS.8490
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8491
            hfilb    = .false.                                                   PLOTS.8492
            if (hputp) then                                                      PLOTS.8493
              hprlw  = 1.0                                                       PLOTS.8494
            else                                                                 PLOTS.8495
              hprlw  = 0.0                                                       PLOTS.8496
            end if                                                               PLOTS.8497
            hstyl(1) = 13                                                        PLOTS.8498
            hstyl(2) = 13                                                        PLOTS.8499
            hsize    = 12                                                        PLOTS.8500
            hfilt    = .false.                                                   PLOTS.8501
            hangl    = 0                                                         PLOTS.8502
            hqual(1) = 1                                                         PLOTS.8503
            hqual(2) = 1                                                         PLOTS.8504
          end if                                                                 PLOTS.8505
        end if                                                                   PLOTS.8506
                                                                                 PLOTS.8507
C  Do we want to fill in the boxes                                               PLOTS.8508
                                                                                 PLOTS.8509
        if (.not. error) then                                                    PLOTS.8510
          call search (whline,i,error)                                           PLOTS.8511
          if (error) then                                                        PLOTS.8512
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.8513
            hfilb    = .false.                                                   PLOTS.8514
            if (hputp) then                                                      PLOTS.8515
              hprlw  = 1.0                                                       PLOTS.8516
            else                                                                 PLOTS.8517
              hprlw  = 0.0                                                       PLOTS.8518
            end if                                                               PLOTS.8519
            hstyl(1) = 13                                                        PLOTS.8520
            hstyl(2) = 13                                                        PLOTS.8521
            hsize    = 12                                                        PLOTS.8522
            hfilt    = .false.                                                   PLOTS.8523
            hangl    = 0                                                         PLOTS.8524
            hqual(1) = 1                                                         PLOTS.8525
            hqual(2) = 1                                                         PLOTS.8526
          end if                                                                 PLOTS.8527
        end if                                                                   PLOTS.8528
                                                                                 PLOTS.8529
        if (.not. error) then                                                    PLOTS.8530
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.8531
            hfilb = .true.                                                       PLOTS.8532
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.8533
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.8534
            hfilb = .false.                                                      PLOTS.8535
          else                                                                   PLOTS.8536
            ermes (1:30)  = 'High/Low Label Box Fill Flag I'                     PLOTS.8537
            ermes (1:30)  = 's Inconclusive, N Assumed     '                     PLOTS.8538
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.8539
            hfilb = .false.                                                      PLOTS.8540
          end if                                                                 PLOTS.8541
          call next (whline,i,error)                                             PLOTS.8542
          if (error) then                                                        PLOTS.8543
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8544
            if (hputp) then                                                      PLOTS.8545
              hprlw  = 1.0                                                       PLOTS.8546
            else                                                                 PLOTS.8547
              hprlw  = 0.0                                                       PLOTS.8548
            end if                                                               PLOTS.8549
            hstyl(1) = 13                                                        PLOTS.8550
            hstyl(2) = 13                                                        PLOTS.8551
            hsize    = 12                                                        PLOTS.8552
            hfilt    = .false.                                                   PLOTS.8553
            hangl    = 0                                                         PLOTS.8554
            hqual(1) = 1                                                         PLOTS.8555
            hqual(2) = 1                                                         PLOTS.8556
          end if                                                                 PLOTS.8557
        end if                                                                   PLOTS.8558
                                                                                 PLOTS.8559
C  What line width should the box perimeter have?                                PLOTS.8560
C  "d" indicates lw = 1000                                                       PLOTS.8561
                                                                                 PLOTS.8562
        if ((hputp) .and. (.not. error)) then                                    PLOTS.8563
          call search (whline,i,error)                                           PLOTS.8564
          if (error) then                                                        PLOTS.8565
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.8566
            if (hputp) then                                                      PLOTS.8567
              hprlw  = 1.0                                                       PLOTS.8568
            else                                                                 PLOTS.8569
              hprlw  = 0.0                                                       PLOTS.8570
            end if                                                               PLOTS.8571
            hstyl(1) = 13                                                        PLOTS.8572
            hstyl(2) = 13                                                        PLOTS.8573
            hsize    = 12                                                        PLOTS.8574
            hfilt    = .false.                                                   PLOTS.8575
            hangl    = 0                                                         PLOTS.8576
            hqual(1) = 1                                                         PLOTS.8577
            hqual(2) = 1                                                         PLOTS.8578
          end if                                                                 PLOTS.8579
        end if                                                                   PLOTS.8580
                                                                                 PLOTS.8581
        if ((hputp) .and. (.not. error)) then                                    PLOTS.8582
          if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then           PLOTS.8583
            hprlw = 1.0                                                          PLOTS.8584
            call next (whline,i,error)                                           PLOTS.8585
          else                                                                   PLOTS.8586
            j = i                                                                PLOTS.8587
            call next (whline,i,error)                                           PLOTS.8588
            if (.not. error) then                                                PLOTS.8589
              gstrng(1:i-j) = whline(j:i-1)                                      PLOTS.8590
              do 10 k = i-j+1,20                                                 PLOTS.8591
                gstrng(k:k) = ' '                                                PLOTS.8592
10            continue                                                           PLOTS.8593
              call gtreal (gstrng,hprlw,error)                                   PLOTS.8594
              if (error) then                                                    PLOTS.8595
                ermes(1:30)  = 'Could Not Read High/Low Label '                  PLOTS.8596
                ermes(31:60) = 'Box Perimeter Width, 1.0 Used '                  PLOTS.8597
                call errhan ('CONDRV',0,ermes,errsev)                            PLOTS.8598
                hprlw = 1.0                                                      PLOTS.8599
                error = .false.                                                  PLOTS.8600
              end if                                                             PLOTS.8601
            end if                                                               PLOTS.8602
          end if                                                                 PLOTS.8603
          if (error) then                                                        PLOTS.8604
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8605
            hstyl(1) = 13                                                        PLOTS.8606
            hstyl(2) = 13                                                        PLOTS.8607
            hsize    = 12                                                        PLOTS.8608
            hfilt    = .false.                                                   PLOTS.8609
            hangl    = 0                                                         PLOTS.8610
            hqual(1) = 1                                                         PLOTS.8611
            hqual(2) = 1                                                         PLOTS.8612
          end if                                                                 PLOTS.8613
        end if                                                                   PLOTS.8614
      else                                                                       PLOTS.8615
        hfilb = .false.                                                          PLOTS.8616
        hputp = .false.                                                          PLOTS.8617
        hprlw  = 0.0                                                             PLOTS.8618
      end if                                                                     PLOTS.8619
                                                                                 PLOTS.8620
C  What kind of marker to we want for the highs                                  PLOTS.8621
C  There are 13 options, defined in the routine SETHLO                           PLOTS.8622
C  D,d  => style # 13 is used                                                    PLOTS.8623
                                                                                 PLOTS.8624
      if (.not. error) then                                                      PLOTS.8625
        call search (whline,i,error)                                             PLOTS.8626
        if (error) then                                                          PLOTS.8627
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8628
          hstyl(1) = 13                                                          PLOTS.8629
          hstyl(2) = 13                                                          PLOTS.8630
          hsize    = 12                                                          PLOTS.8631
          hfilt    = .false.                                                     PLOTS.8632
          hangl    = 0                                                           PLOTS.8633
          hqual(1) = 1                                                           PLOTS.8634
          hqual(2) = 1                                                           PLOTS.8635
        end if                                                                   PLOTS.8636
      end if                                                                     PLOTS.8637
                                                                                 PLOTS.8638
      if (.not. error) then                                                      PLOTS.8639
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.8640
          hstyl(1) = 13                                                          PLOTS.8641
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.8642
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.8643
          read  (whline(i:i+1),20,err=40) hstyl(1)                               PLOTS.8644
        else                                                                     PLOTS.8645
          read (whline(i:i),30,err=40) hstyl(1)                                  PLOTS.8646
        end if                                                                   PLOTS.8647
        goto 45                                                                  PLOTS.8648
                                                                                 PLOTS.8649
C  Inform the user of an error in the read in                                    PLOTS.8650
                                                                                 PLOTS.8651
40      ermes(1:30)  = 'High Label Style Number Input '                          PLOTS.8652
        ermes(31:60) = 'Conversion                    '                          PLOTS.8653
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.8654
        hstyl(1) = 13                                                            PLOTS.8655
        hstyl(2) = 13                                                            PLOTS.8656
        hsize    = 12                                                            PLOTS.8657
        hfilt    = .false.                                                       PLOTS.8658
        hangl    = 0                                                             PLOTS.8659
        hqual(1) = 1                                                             PLOTS.8660
        hqual(2) = 1                                                             PLOTS.8661
        error = .true.                                                           PLOTS.8662
                                                                                 PLOTS.8663
45      if (.not. error) then                                                    PLOTS.8664
          call next (whline,i,error)                                             PLOTS.8665
          if (error) then                                                        PLOTS.8666
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8667
            hstyl(2) = 13                                                        PLOTS.8668
            hsize    = 12                                                        PLOTS.8669
            hfilt    = .false.                                                   PLOTS.8670
            hangl    = 0                                                         PLOTS.8671
            hqual(1) = 1                                                         PLOTS.8672
            hqual(2) = 1                                                         PLOTS.8673
          end if                                                                 PLOTS.8674
        end if                                                                   PLOTS.8675
      end if                                                                     PLOTS.8676
                                                                                 PLOTS.8677
C  What kind of marker to we want for the lows                                   PLOTS.8678
C  There are 13 options, defined in the routine SETHLO                           PLOTS.8679
C  D, d  => style # 13 is used                                                   PLOTS.8680
                                                                                 PLOTS.8681
      if (.not. error) then                                                      PLOTS.8682
        call search (whline,i,error)                                             PLOTS.8683
        if (error) then                                                          PLOTS.8684
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8685
          hstyl(2) = 13                                                          PLOTS.8686
          hsize    = 12                                                          PLOTS.8687
          hfilt    = .false.                                                     PLOTS.8688
          hangl    = 0                                                           PLOTS.8689
          hqual(1) = 1                                                           PLOTS.8690
          hqual(2) = 1                                                           PLOTS.8691
        end if                                                                   PLOTS.8692
      end if                                                                     PLOTS.8693
                                                                                 PLOTS.8694
      if (.not. error) then                                                      PLOTS.8695
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.8696
          hstyl(2) = 13                                                          PLOTS.8697
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.8698
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.8699
          read  (whline(i:i+1),20,err=50) hstyl(2)                               PLOTS.8700
        else                                                                     PLOTS.8701
          read (whline(i:i),30,err=50) hstyl(2)                                  PLOTS.8702
        end if                                                                   PLOTS.8703
        goto 55                                                                  PLOTS.8704
                                                                                 PLOTS.8705
C  Inform the user of an error in the read in                                    PLOTS.8706
                                                                                 PLOTS.8707
50      ermes(1:30)  = 'Low Label Style Number Input C'                          PLOTS.8708
        ermes(31:60) = 'onversion                     '                          PLOTS.8709
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.8710
        hstyl(2) = 13                                                            PLOTS.8711
        hsize    = 12                                                            PLOTS.8712
        hfilt    = .false.                                                       PLOTS.8713
        hangl    = 0                                                             PLOTS.8714
        hqual(1) = 1                                                             PLOTS.8715
        hqual(2) = 1                                                             PLOTS.8716
        error = .true.                                                           PLOTS.8717
                                                                                 PLOTS.8718
55      if (.not. error) then                                                    PLOTS.8719
          call next (whline,i,error)                                             PLOTS.8720
          if (error) then                                                        PLOTS.8721
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8722
            hsize    = 12                                                        PLOTS.8723
            hfilt    = .false.                                                   PLOTS.8724
            hangl    = 0                                                         PLOTS.8725
            hqual(1) = 1                                                         PLOTS.8726
            hqual(2) = 1                                                         PLOTS.8727
          end if                                                                 PLOTS.8728
        end if                                                                   PLOTS.8729
      end if                                                                     PLOTS.8730
                                                                                 PLOTS.8731
C  How big should the highs and lows be                                          PLOTS.8732
C  This is specified in plotter coordinates                                      PLOTS.8733
                                                                                 PLOTS.8734
      if (.not. error) then                                                      PLOTS.8735
        call search (whline,i,error)                                             PLOTS.8736
        if (error) then                                                          PLOTS.8737
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8738
          hsize    = 12                                                          PLOTS.8739
          hfilt    = .false.                                                     PLOTS.8740
          hangl    = 0                                                           PLOTS.8741
          hqual(1) = 1                                                           PLOTS.8742
          hqual(2) = 1                                                           PLOTS.8743
        end if                                                                   PLOTS.8744
      end if                                                                     PLOTS.8745
                                                                                 PLOTS.8746
      if (.not. error) then                                                      PLOTS.8747
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.8748
          hsize = 12                                                             PLOTS.8749
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.8750
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.8751
          read  (whline(i:i+1),20,err=60) hsize                                  PLOTS.8752
        else                                                                     PLOTS.8753
          read (whline(i:i),30,err=60) hsize                                     PLOTS.8754
        end if                                                                   PLOTS.8755
        goto 65                                                                  PLOTS.8756
                                                                                 PLOTS.8757
C  Inform the user of an error if here                                           PLOTS.8758
                                                                                 PLOTS.8759
60      ermes(1:30)  = 'High/Low Label Size Input Conv'                          PLOTS.8760
        ermes(31:60) = 'ersion                        '                          PLOTS.8761
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.8762
        hsize    = 12                                                            PLOTS.8763
        hfilt    = .false.                                                       PLOTS.8764
        hangl    = 0                                                             PLOTS.8765
        hqual(1) = 1                                                             PLOTS.8766
        hqual(2) = 1                                                             PLOTS.8767
        error = .true.                                                           PLOTS.8768
                                                                                 PLOTS.8769
65      if (.not. error) then                                                    PLOTS.8770
          call next (whline,i,error)                                             PLOTS.8771
          if (error) then                                                        PLOTS.8772
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8773
            hfilt    = .false.                                                   PLOTS.8774
            hangl    = 0                                                         PLOTS.8775
            hqual(1) = 1                                                         PLOTS.8776
            hqual(2) = 1                                                         PLOTS.8777
          end if                                                                 PLOTS.8778
        end if                                                                   PLOTS.8779
      end if                                                                     PLOTS.8780
                                                                                 PLOTS.8781
C  Check to see if the overlap filter has been requested                         PLOTS.8782
                                                                                 PLOTS.8783
      if (.not. error) then                                                      PLOTS.8784
        call search (whline,i,error)                                             PLOTS.8785
        if (error) then                                                          PLOTS.8786
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8787
          hfilt    = .false.                                                     PLOTS.8788
          hangl    = 0                                                           PLOTS.8789
          hqual(1) = 1                                                           PLOTS.8790
          hqual(2) = 1                                                           PLOTS.8791
        end if                                                                   PLOTS.8792
      end if                                                                     PLOTS.8793
                                                                                 PLOTS.8794
      if (.not. error) then                                                      PLOTS.8795
        if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then             PLOTS.8796
          hfilt = .false.                                                        PLOTS.8797
        else if ((whline(i:i) .eq. 'Y') .or.                                     PLOTS.8798
     *           (whline(i:i) .eq. 'y')) then                                    PLOTS.8799
          hfilt = .true.                                                         PLOTS.8800
        else                                                                     PLOTS.8801
          ermes(1:30)  = 'High/Low Label Overlap Filter '                        PLOTS.8802
          ermes(31:60) = 'Flag Is Inconclusive, Y Used  '                        PLOTS.8803
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.8804
          hfilt = .true.                                                         PLOTS.8805
        end if                                                                   PLOTS.8806
        call next (whline,i,error)                                               PLOTS.8807
        if (error) then                                                          PLOTS.8808
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.8809
          hangl    = 0                                                           PLOTS.8810
          hqual(1) = 1                                                           PLOTS.8811
          hqual(2) = 1                                                           PLOTS.8812
        end if                                                                   PLOTS.8813
      end if                                                                     PLOTS.8814
                                                                                 PLOTS.8815
C  Get the angle from the horizontal of the highs and lows                       PLOTS.8816
                                                                                 PLOTS.8817
      if (.not. error) then                                                      PLOTS.8818
        call search (whline,i,error)                                             PLOTS.8819
        if (error) then                                                          PLOTS.8820
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8821
          hangl    = 0                                                           PLOTS.8822
          hqual(1) = 1                                                           PLOTS.8823
          hqual(2) = 1                                                           PLOTS.8824
        end if                                                                   PLOTS.8825
      end if                                                                     PLOTS.8826
                                                                                 PLOTS.8827
      if (.not. error) then                                                      PLOTS.8828
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.8829
          hangl = 0                                                              PLOTS.8830
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.8831
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.8832
          if ((whline(i+2:i+2) .ne. ' ') .and.                                   PLOTS.8833
     *        (whline(i+2:i+2) .ne. '|')) then                                   PLOTS.8834
            read (whline(i:i+2),80,err=70) hangl                                 PLOTS.8835
          else                                                                   PLOTS.8836
            read  (whline(i:i+1),20,err=70) hangl                                PLOTS.8837
          end if                                                                 PLOTS.8838
        else                                                                     PLOTS.8839
          read (whline(i:i),30,err=70) hangl                                     PLOTS.8840
        end if                                                                   PLOTS.8841
        goto 75                                                                  PLOTS.8842
                                                                                 PLOTS.8843
C  If there was an error in the read inform the user                             PLOTS.8844
                                                                                 PLOTS.8845
70      ermes(1:30)  = 'High/Low Label Angle Input Con'                          PLOTS.8846
        ermes(31:60) = 'version                       '                          PLOTS.8847
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.8848
        hangl    = 0                                                             PLOTS.8849
        hqual(1) = 1                                                             PLOTS.8850
        hqual(2) = 1                                                             PLOTS.8851
        error = .false.                                                          PLOTS.8852
                                                                                 PLOTS.8853
75      if (.not. error) then                                                    PLOTS.8854
          call next (whline,i,error)                                             PLOTS.8855
          if (error) then                                                        PLOTS.8856
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.8857
            hqual(1) = 1                                                         PLOTS.8858
            hqual(2) = 1                                                         PLOTS.8859
          end if                                                                 PLOTS.8860
        end if                                                                   PLOTS.8861
      end if                                                                     PLOTS.8862
                                                                                 PLOTS.8863
C  Read in the letter quality to be used in the high low labels                  PLOTS.8864
                                                                                 PLOTS.8865
      if (.not. error) then                                                      PLOTS.8866
        call search (whline,i,error)                                             PLOTS.8867
        if (error) then                                                          PLOTS.8868
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.8869
          hqual(1) = 1                                                           PLOTS.8870
          hqual(2) = 1                                                           PLOTS.8871
        end if                                                                   PLOTS.8872
      end if                                                                     PLOTS.8873
                                                                                 PLOTS.8874
      if (.not. error) then                                                      PLOTS.8875
        hqual(2) = -1                                                            PLOTS.8876
        if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then             PLOTS.8877
          hqual(1) = 1                                                           PLOTS.8878
          hqual(2) = 1                                                           PLOTS.8879
        else if (whline(i:i) .eq. '0') then                                      PLOTS.8880
          hqual(1) = 0                                                           PLOTS.8881
        else if (whline(i:i) .eq. '1') then                                      PLOTS.8882
          hqual(1) = 1                                                           PLOTS.8883
        else                                                                     PLOTS.8884
          ermes(1:30)  = 'High/Low Label Text Type Is In'                        PLOTS.8885
          ermes(31:60) = 'valid, 1 Used (Duplex)        '                        PLOTS.8886
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.8887
          hqual(1) = 1                                                           PLOTS.8888
        end if                                                                   PLOTS.8889
        if (hqual(2) .eq. -1) then                                               PLOTS.8890
          i = i + 1                                                              PLOTS.8891
          if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then           PLOTS.8892
            hqual(2) = 1                                                         PLOTS.8893
          else if (whline(i:i) .eq. '0') then                                    PLOTS.8894
            hqual(2) = 0                                                         PLOTS.8895
          else if (whline(i:i) .eq. '1') then                                    PLOTS.8896
            hqual(2) = 1                                                         PLOTS.8897
          else if (whline(i:i) .eq. '2') then                                    PLOTS.8898
            hqual(2) = 2                                                         PLOTS.8899
          else                                                                   PLOTS.8900
            ermes(1:30)  = 'High/Low Label Text Quality Is'                      PLOTS.8901
            ermes(31:60) = ' Invalid, 1 Used (Medium)     '                      PLOTS.8902
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.8903
            hqual(2) = 1                                                         PLOTS.8904
          end if                                                                 PLOTS.8905
        end if                                                                   PLOTS.8906
        call next (whline,i,error)                                               PLOTS.8907
        if (error) then                                                          PLOTS.8908
          call errhan ('CONDRV',0,q,errsev)                                      PLOTS.8909
        else                                                                     PLOTS.8910
          call search (whline,i,error)                                           PLOTS.8911
          if (.not. error) then                                                  PLOTS.8912
            ermes(1:30)  = 'Reading High/Low Information L'                      PLOTS.8913
            ermes(31:60) = 'ine, Too Many Entries On Line '                      PLOTS.8914
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.8915
          end if                                                                 PLOTS.8916
        end if                                                                   PLOTS.8917
      end if                                                                     PLOTS.8918
                                                                                 PLOTS.8919
C  Check for value errors in the set up numbers                                  PLOTS.8920
C  Label Box Perimeter Line Width Needs to Be between 1 and 10                   PLOTS.8921
                                                                                 PLOTS.8922
      if (hprlw .gt. 10.0) then                                                  PLOTS.8923
        ermes(1:30)  = 'High/Low Label Box Perimeter L'                          PLOTS.8924
        ermes(31:60) = 'ine Width Is Too Big, 10 Used '                          PLOTS.8925
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8926
        hprlw = 10.0                                                             PLOTS.8927
      end if                                                                     PLOTS.8928
                                                                                 PLOTS.8929
      if ((hprlw .lt. 1.0) .and. (hputp)) then                                   PLOTS.8930
        ermes(1:30)  = 'High/Low Label Box Perimeter L'                          PLOTS.8931
        ermes(31:60) = 'ine Width Is Too Small, 1 Used'                          PLOTS.8932
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8933
        hprlw = 10.0                                                             PLOTS.8934
      end if                                                                     PLOTS.8935
                                                                                 PLOTS.8936
C  Styles range from 1 to 13                                                     PLOTS.8937
                                                                                 PLOTS.8938
      if ((hstyl(1) .lt. 1) .or. (hstyl(1) .gt. 13)) then                        PLOTS.8939
        ermes(1:30)  = 'High Label Style Is Invalid, S'                          PLOTS.8940
        ermes(31:60) = 'tyle 13 Used                  '                          PLOTS.8941
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8942
        hstyl(1) = 13                                                            PLOTS.8943
      end if                                                                     PLOTS.8944
                                                                                 PLOTS.8945
      if ((hstyl(2) .lt. 1) .or. (hstyl(2) .gt. 13)) then                        PLOTS.8946
        ermes(1:30)  = 'Low Label Style Is Invalid, St'                          PLOTS.8947
        ermes(31:60) = 'yle 13 Used                   '                          PLOTS.8948
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8949
        hstyl(2) = 13                                                            PLOTS.8950
      end if                                                                     PLOTS.8951
                                                                                 PLOTS.8952
C  Size can be no less than 1 and no more than 25                                PLOTS.8953
                                                                                 PLOTS.8954
      if (hsize .lt. 1) then                                                     PLOTS.8955
        ermes(1:30)  = 'High/Low Label Size Is Too Sma'                          PLOTS.8956
        ermes(31:60) = 'll, 1 Used                    '                          PLOTS.8957
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8958
        hsize = 1                                                                PLOTS.8959
      end if                                                                     PLOTS.8960
                                                                                 PLOTS.8961
      if (hsize .gt. 25) then                                                    PLOTS.8962
        ermes(1:30)  = 'High/Low Label Size Is Too Big'                          PLOTS.8963
        ermes(31:60) = ', 25 Used                     '                          PLOTS.8964
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8965
        hsize = 25                                                               PLOTS.8966
      end if                                                                     PLOTS.8967
                                                                                 PLOTS.8968
C  Angle can only be given between 0 and 360 degrees inclusive                   PLOTS.8969
                                                                                 PLOTS.8970
      if ((hangl .lt. 0) .or. (hangl .gt. 360)) then                             PLOTS.8971
        ermes(1:30)  = 'High/Low Label Angle Is Invali'                          PLOTS.8972
        ermes(31:60) = 'd, 0 Degrees Used             '                          PLOTS.8973
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8974
        hangl = 0                                                                PLOTS.8975
      end if                                                                     PLOTS.8976
                                                                                 PLOTS.8977
C  Quality, the first number is the type of characters                           PLOTS.8978
C    0 - Complex                                                                 PLOTS.8979
C    1 - Duplex                                                                  PLOTS.8980
C  the second number is the quality of characters                                PLOTS.8981
C    0 - High Quality                                                            PLOTS.8982
C    1 - Medium Quality                                                          PLOTS.8983
C    2 - Low Quality                                                             PLOTS.8984
                                                                                 PLOTS.8985
      if ((hqual(1) .ne. 0) .and. (hqual(1) .ne. 1)) then                        PLOTS.8986
        ermes(1:30)  = 'High/Low Label Text Type Is In'                          PLOTS.8987
        ermes(31:60) = 'valid, 1 Assumed (Duplex)     '                          PLOTS.8988
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8989
        hqual(1) = 1                                                             PLOTS.8990
      end if                                                                     PLOTS.8991
                                                                                 PLOTS.8992
      if ((hqual(2) .gt. 2) .or. (hqual(2) .lt. 0)) then                         PLOTS.8993
        ermes(1:30)  = 'High/Low Label Text Quality Is'                          PLOTS.8994
        ermes(31:60) = ' Invalid, 1 Assumed (Medium)  '                          PLOTS.8995
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.8996
        hqual(2) = 1                                                             PLOTS.8997
      end if                                                                     PLOTS.8998
                                                                                 PLOTS.8999
C  Assign output variable                                                        PLOTS.9000
                                                                                 PLOTS.9001
      ofilb = hfilb                                                              PLOTS.9002
                                                                                 PLOTS.9003
C*****************************  subroutine end  ******************************C  PLOTS.9004
                                                                                 PLOTS.9005
C  Format statements begin ...                                                   PLOTS.9006
                                                                                 PLOTS.9007
20    format (I2)                                                                PLOTS.9008
30    format (I1)                                                                PLOTS.9009
80    format (I3)                                                                PLOTS.9010
                                                                                 PLOTS.9011
C  Format statements end.                                                        PLOTS.9012
                                                                                 PLOTS.9013
      return                                                                     PLOTS.9014
      end                                                                        PLOTS.9015
      subroutine crdlab (whline,errsev,ofilb)                                    PLOTS.9016
                                                                                 PLOTS.9017
C*****************************************************************************C  PLOTS.9018
C  crdlab   - This is a CONDRV routine                                        C  PLOTS.9019
C  Section  - Tables                                                          C  PLOTS.9020
C  Purpose  - To determine line label information as specified by the user in C  PLOTS.9021
C             the CON DETAILS table.                                          C  PLOTS.9022
C                                                                             C  PLOTS.9023
C  On entry - WHLINE  contains  the line from  the table  which holds all the C  PLOTS.9024
C             needed information.  ERRSEV indicates what severity of an error C  PLOTS.9025
C             will cause execution to cease.                                  C  PLOTS.9026
C                                                                             C  PLOTS.9027
C  On exit  - All of the values in common block LABDET have been set up.  The C  PLOTS.9028
C             variables in LBQDET too have been set up correctly.  OFILB says C  PLOTS.9029
C             if the line label boxes will be filled or not.                  C  PLOTS.9030
C                                                                             C  PLOTS.9031
C  Assume   - Nothing.                                                        C  PLOTS.9032
C                                                                             C  PLOTS.9033
C  Notes    - Routine             Location of Definition                      C  PLOTS.9034
C             ----------------------------------------------------------------C  PLOTS.9035
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.9036
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.9037
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.9038
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.9039
C             ----------------------------------------------------------------C  PLOTS.9040
C                                                                             C  PLOTS.9041
C  Author   - Jeremy Asbill       Date - June 11, 1990      for the MM4 club  C  PLOTS.9042
C*****************************************************************************C  PLOTS.9043
                                                                                 PLOTS.9044
C  Character variables                                                           PLOTS.9045
                                                                                 PLOTS.9046
      character*80     whline            ! the line from the table         (in)  PLOTS.9047
      character*60     p,                ! error message string, SEARCH (local)  PLOTS.9048
     *                 q,                ! error message string, NEXT   (local)  PLOTS.9049
     *                 ermes             ! error message string, general(local)  PLOTS.9050
      character*20     gstrng            ! temporary string             (local)  PLOTS.9051
                                                                                 PLOTS.9052
C  Integer variables                                                             PLOTS.9053
                                                                                 PLOTS.9054
      integer          errsev            ! error severity comparitor       (in)  PLOTS.9055
      integer          lqual(2)          ! for common block LBQDET               PLOTS.9056
      integer          lsize,            ! for common block LABDET               PLOTS.9057
     *                 lortn,            ! for common block LABDET               PLOTS.9058
     *                 langl,            ! for common block LABDET               PLOTS.9059
     *                 lintv             ! for common block LABDET               PLOTS.9060
                                                                                 PLOTS.9061
C  Logical varaibles                                                             PLOTS.9062
                                                                                 PLOTS.9063
      logical          ofilb             ! out version of LFILB           (out)  PLOTS.9064
      logical          lputb,            ! for common block LABDET               PLOTS.9065
     *                 lputp,            ! for common block LABDET               PLOTS.9066
     *                 lfilb             ! for common block LABDET               PLOTS.9067
      logical          error             ! has an error occured ?       (local)  PLOTS.9068
                                                                                 PLOTS.9069
C  Real variables                                                                PLOTS.9070
                                                                                 PLOTS.9071
      real             lprlw             ! for common block LABDET               PLOTS.9072
                                                                                 PLOTS.9073
C  Common blocks                                                                 PLOTS.9074
                                                                                 PLOTS.9075
      common /labdet/  lputb,            ! put boxes on the line labels ?        PLOTS.9076
     *                 lputp,            ! put perimeter on label boxes ?        PLOTS.9077
     *                 lfilb,            ! fill label boxes ?                    PLOTS.9078
     *                 lprlw,            ! label box perimeter line width        PLOTS.9079
     *                 lsize,            ! line label character size             PLOTS.9080
     *                 lintv,            ! line label placement per line         PLOTS.9081
     *                 langl,            ! line label angle                      PLOTS.9082
     *                 lortn             ! line label orientation                PLOTS.9083
      common /lbqdet/  lqual             ! line label character quality          PLOTS.9084
                                                                                 PLOTS.9085
C****************************  subroutine begin  *****************************C  PLOTS.9086
                                                                                 PLOTS.9087
C  Set up I to use as a counter                                                  PLOTS.9088
                                                                                 PLOTS.9089
      i = 1                                                                      PLOTS.9090
                                                                                 PLOTS.9091
C  Initialize the error flag                                                     PLOTS.9092
                                                                                 PLOTS.9093
      error = .false.                                                            PLOTS.9094
                                                                                 PLOTS.9095
C  Set up the SEARCH and NEXT error message strings                              PLOTS.9096
                                                                                 PLOTS.9097
      p(1:23)  = 'Reading Line Label Info'                                       PLOTS.9098
      p(24:60) = 'rmation Line, Too Few Entries On Line'                         PLOTS.9099
      q(1:23)  = p(1:23)                                                         PLOTS.9100
      q(24:60) = 'rmation Line, Entry Is Bizarre       '                         PLOTS.9101
                                                                                 PLOTS.9102
C  The first search is erred upon if WHLINE is blank, if this is the case        PLOTS.9103
C  CONDRV does not consider that an error but an instruction to default all      PLOTS.9104
C  line label information                                                        PLOTS.9105
                                                                                 PLOTS.9106
      call search (whline,i,error)                                               PLOTS.9107
      if (error) then                                                            PLOTS.9108
        lputb    = .false.                                                       PLOTS.9109
        lputp    = .false.                                                       PLOTS.9110
        lfilb    = .false.                                                       PLOTS.9111
        lsize    = 8                                                             PLOTS.9112
        lintv    = 4                                                             PLOTS.9113
        langl    = 0                                                             PLOTS.9114
        lortn    = 1                                                             PLOTS.9115
        lqual(1) = 1                                                             PLOTS.9116
        lqual(2) = 1                                                             PLOTS.9117
      end if                                                                     PLOTS.9118
                                                                                 PLOTS.9119
C  Parse out the line label box flag, first                                      PLOTS.9120
C  Y             => Do draw a box around the line labels                         PLOTS.9121
C  N             => Don't draw a box around the line labels                      PLOTS.9122
C  anything else => Give a warning message                                       PLOTS.9123
                                                                                 PLOTS.9124
      if (.not. error) then                                                      PLOTS.9125
        if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then             PLOTS.9126
          lputb = .true.                                                         PLOTS.9127
        else if ((whline(i:i) .eq. 'N') .or.                                     PLOTS.9128
     *           (whline(i:i) .eq. 'n')) then                                    PLOTS.9129
          lputb = .false.                                                        PLOTS.9130
        else                                                                     PLOTS.9131
          ermes(1:30)  = 'Line Label Box Flag Is Inconcl'                        PLOTS.9132
          ermes(31:60) = 'usive, N Assumed              '                        PLOTS.9133
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.9134
          lputb = .false.                                                        PLOTS.9135
        end if                                                                   PLOTS.9136
        call next (whline,i,error)                                               PLOTS.9137
        if (error) then                                                          PLOTS.9138
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.9139
          lsize    = 8                                                           PLOTS.9140
          lintv    = 4                                                           PLOTS.9141
          langl    = 0                                                           PLOTS.9142
          lortn    = 1                                                           PLOTS.9143
          lqual(1) = 1                                                           PLOTS.9144
          lqual(2) = 1                                                           PLOTS.9145
        end if                                                                   PLOTS.9146
      end if                                                                     PLOTS.9147
                                                                                 PLOTS.9148
C  Parse through the label line box detail information if a box has been         PLOTS.9149
C  requested                                                                     PLOTS.9150
                                                                                 PLOTS.9151
      if ((lputb) .and. (.not. error)) then                                      PLOTS.9152
                                                                                 PLOTS.9153
C  First is the box perimeter flag                                               PLOTS.9154
C  Y             => Do draw a perimeter around the line label box                PLOTS.9155
C  N             => Don't draw a perimeter around the line label box             PLOTS.9156
C  anything else => Give a warning message                                       PLOTS.9157
                                                                                 PLOTS.9158
        call search (whline,i,error)                                             PLOTS.9159
        if (error) then                                                          PLOTS.9160
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.9161
          lputp    = .false.                                                     PLOTS.9162
          lfilb    = .false.                                                     PLOTS.9163
          lprlw    = 0.0                                                         PLOTS.9164
          lsize    = 8                                                           PLOTS.9165
          lintv    = 4                                                           PLOTS.9166
          langl    = 0                                                           PLOTS.9167
          lortn    = 1                                                           PLOTS.9168
          lqual(1) = 1                                                           PLOTS.9169
          lqual(2) = 1                                                           PLOTS.9170
        end if                                                                   PLOTS.9171
                                                                                 PLOTS.9172
        if (.not. error) then                                                    PLOTS.9173
          if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then           PLOTS.9174
            lputp = .false.                                                      PLOTS.9175
          else if ((whline(i:i) .eq. 'Y') .or.                                   PLOTS.9176
     *             (whline(i:i) .eq. 'y')) then                                  PLOTS.9177
            lputp = .true.                                                       PLOTS.9178
          else                                                                   PLOTS.9179
            ermes(1:30)  = 'Line Label Box Perimeter Flag '                      PLOTS.9180
            ermes(31:60) = 'Is Inconclusive, N Assumed    '                      PLOTS.9181
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.9182
            lputp = .false.                                                      PLOTS.9183
          end if                                                                 PLOTS.9184
          call next (whline,i,error)                                             PLOTS.9185
          if (error) then                                                        PLOTS.9186
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.9187
            lfilb    = .false.                                                   PLOTS.9188
            if (lputp) then                                                      PLOTS.9189
              lprlw    = 1.0                                                     PLOTS.9190
            else                                                                 PLOTS.9191
              lprlw    = 0.0                                                     PLOTS.9192
            end if                                                               PLOTS.9193
            lsize    = 8                                                         PLOTS.9194
            lintv    = 4                                                         PLOTS.9195
            langl    = 0                                                         PLOTS.9196
            lortn    = 1                                                         PLOTS.9197
            lqual(1) = 1                                                         PLOTS.9198
            lqual(2) = 1                                                         PLOTS.9199
          end if                                                                 PLOTS.9200
        end if                                                                   PLOTS.9201
                                                                                 PLOTS.9202
C  Next is the line label box fill flag                                          PLOTS.9203
C  Y              => Fill the box                                                PLOTS.9204
C  N              => Leave the box hollow                                        PLOTS.9205
C  Anything else  => Give Warning message                                        PLOTS.9206
                                                                                 PLOTS.9207
        if (.not. error) then                                                    PLOTS.9208
          call search (whline,i,error)                                           PLOTS.9209
          if (error) then                                                        PLOTS.9210
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.9211
            lfilb    = .false.                                                   PLOTS.9212
            if (lputp) then                                                      PLOTS.9213
              lprlw    = 1.0                                                     PLOTS.9214
            else                                                                 PLOTS.9215
              lprlw    = 0.0                                                     PLOTS.9216
            end if                                                               PLOTS.9217
            lsize    = 8                                                         PLOTS.9218
            lintv    = 4                                                         PLOTS.9219
            langl    = 0                                                         PLOTS.9220
            lortn    = 1                                                         PLOTS.9221
            lqual(1) = 1                                                         PLOTS.9222
            lqual(2) = 1                                                         PLOTS.9223
          end if                                                                 PLOTS.9224
        end if                                                                   PLOTS.9225
                                                                                 PLOTS.9226
        if (.not. error) then                                                    PLOTS.9227
          if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then           PLOTS.9228
            lfilb = .true.                                                       PLOTS.9229
          else if ((whline(i:i) .eq. 'N') .or.                                   PLOTS.9230
     *             (whline(i:i) .eq. 'n')) then                                  PLOTS.9231
            lfilb = .false.                                                      PLOTS.9232
          else                                                                   PLOTS.9233
            ermes(1:30)  = 'Line Label Box Fill Flag Is In'                      PLOTS.9234
            ermes(31:60) = 'conclusive, N Assumed         '                      PLOTS.9235
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.9236
            lfilb = .false.                                                      PLOTS.9237
          end if                                                                 PLOTS.9238
          call next (whline,i,error)                                             PLOTS.9239
          if (error) then                                                        PLOTS.9240
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.9241
            if (lputp) then                                                      PLOTS.9242
              lprlw    = 1.0                                                     PLOTS.9243
            else                                                                 PLOTS.9244
              lprlw    = 0.0                                                     PLOTS.9245
            end if                                                               PLOTS.9246
            lsize    = 8                                                         PLOTS.9247
            lintv    = 4                                                         PLOTS.9248
            langl    = 0                                                         PLOTS.9249
            lortn    = 1                                                         PLOTS.9250
            lqual(1) = 1                                                         PLOTS.9251
            lqual(2) = 1                                                         PLOTS.9252
          end if                                                                 PLOTS.9253
        end if                                                                   PLOTS.9254
                                                                                 PLOTS.9255
C  What line width should the box perimeter have?  This value is a mulitplier    PLOTS.9256
C  by the normal line width, a "D" or a "d" indicates normal line width          PLOTS.9257
                                                                                 PLOTS.9258
        if ((lputp) .and. (.not. error)) then                                    PLOTS.9259
          call search (whline,i,error)                                           PLOTS.9260
          if (error) then                                                        PLOTS.9261
            call errhan ('CONDRV',1,p,errsev)                                    PLOTS.9262
            if (lputp) then                                                      PLOTS.9263
              lprlw    = 1.0                                                     PLOTS.9264
            else                                                                 PLOTS.9265
              lprlw    = 0.0                                                     PLOTS.9266
            end if                                                               PLOTS.9267
            lsize    = 8                                                         PLOTS.9268
            lintv    = 4                                                         PLOTS.9269
            langl    = 0                                                         PLOTS.9270
            lortn    = 1                                                         PLOTS.9271
            lqual(1) = 1                                                         PLOTS.9272
            lqual(2) = 1                                                         PLOTS.9273
          end if                                                                 PLOTS.9274
        end if                                                                   PLOTS.9275
                                                                                 PLOTS.9276
        if ((lputp) .and. (.not. error)) then                                    PLOTS.9277
          if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then           PLOTS.9278
            lprlw = 1.0                                                          PLOTS.9279
            call next (whline,i,error)                                           PLOTS.9280
          else                                                                   PLOTS.9281
            j = 1                                                                PLOTS.9282
            call next (whline,i,error)                                           PLOTS.9283
            if (.not. error) then                                                PLOTS.9284
              gstrng(1:i-j) = whline(j:i-1)                                      PLOTS.9285
              do 10 k = i-j+1,20                                                 PLOTS.9286
                gstrng(k:k) = ' '                                                PLOTS.9287
10            continue                                                           PLOTS.9288
              call gtreal (gstrng,lprlw,error)                                   PLOTS.9289
              if (error) then                                                    PLOTS.9290
                ermes(1:30)  = 'Could Not Read Line Label Box '                  PLOTS.9291
                ermes(31:60) = 'Perimeter Width, 1.0 Used     '                  PLOTS.9292
                call errhan ('CONDRV',0,ermes,errsev)                            PLOTS.9293
                lprlw = 1.0                                                      PLOTS.9294
                error = .false.                                                  PLOTS.9295
              end if                                                             PLOTS.9296
            end if                                                               PLOTS.9297
          end if                                                                 PLOTS.9298
          if (error) then                                                        PLOTS.9299
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.9300
            lsize    = 8                                                         PLOTS.9301
            lintv    = 4                                                         PLOTS.9302
            langl    = 0                                                         PLOTS.9303
            lortn    = 1                                                         PLOTS.9304
            lqual(1) = 1                                                         PLOTS.9305
            lqual(2) = 1                                                         PLOTS.9306
          end if                                                                 PLOTS.9307
        end if                                                                   PLOTS.9308
      else                                                                       PLOTS.9309
        lfilb = .false.                                                          PLOTS.9310
        lputp = .false.                                                          PLOTS.9311
        lprlw  = 0.0                                                             PLOTS.9312
      end if                                                                     PLOTS.9313
                                                                                 PLOTS.9314
C  Parse out character quality                                                   PLOTS.9315
C  0 In space 1          => Complex Characters will be used                      PLOTS.9316
C  1 In space 1          => Duplex Characters will be used                       PLOTS.9317
C  0 In space 2          => Characters are of high quality                       PLOTS.9318
C  1 In space 2          => Medium Quality                                       PLOTS.9319
C  2 In space 2          => Low Quality                                          PLOTS.9320
C  Anything Else         => Give a Warning Message                               PLOTS.9321
                                                                                 PLOTS.9322
      if (.not. error) then                                                      PLOTS.9323
        call search (whline,i,error)                                             PLOTS.9324
        if (error) then                                                          PLOTS.9325
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.9326
          lsize    = 8                                                           PLOTS.9327
          lintv    = 4                                                           PLOTS.9328
          langl    = 0                                                           PLOTS.9329
          lortn    = 1                                                           PLOTS.9330
          lqual(1) = 1                                                           PLOTS.9331
          lqual(2) = 1                                                           PLOTS.9332
        end if                                                                   PLOTS.9333
      end if                                                                     PLOTS.9334
                                                                                 PLOTS.9335
      if (.not. error) then                                                      PLOTS.9336
        lqual(2) = -1                                                            PLOTS.9337
        if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then             PLOTS.9338
          lqual(1) = 1                                                           PLOTS.9339
          lqual(2) = 1                                                           PLOTS.9340
        else if (whline(i:i) .eq. '0') then                                      PLOTS.9341
          lqual(1) = 0                                                           PLOTS.9342
        else if (whline(i:i) .eq. '1') then                                      PLOTS.9343
          lqual(1) = 1                                                           PLOTS.9344
        else                                                                     PLOTS.9345
          ermes(1:30)  = 'Line Label Text Type Is Invali'                        PLOTS.9346
          ermes(31:60) = 'd, 1 Used (Duplex)            '                        PLOTS.9347
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.9348
          lqual(1) = 1                                                           PLOTS.9349
        end if                                                                   PLOTS.9350
        if (lqual(2) .eq. -1) then                                               PLOTS.9351
          i = i + 1                                                              PLOTS.9352
          if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then           PLOTS.9353
            lqual(2) = 1                                                         PLOTS.9354
          else if (whline(i:i) .eq. '0') then                                    PLOTS.9355
            lqual(2) = 0                                                         PLOTS.9356
          else if (whline(i:i) .eq. '1') then                                    PLOTS.9357
            lqual(2) = 1                                                         PLOTS.9358
          else if (whline(i:i) .eq. '2') then                                    PLOTS.9359
            lqual(2) = 2                                                         PLOTS.9360
          else                                                                   PLOTS.9361
            ermes(1:30)  = 'Line Label Text Quality Is Inv'                      PLOTS.9362
            ermes(31:60) = 'alid, 1 Used (Medium)         '                      PLOTS.9363
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.9364
            lqual(2) = 1                                                         PLOTS.9365
          end if                                                                 PLOTS.9366
        end if                                                                   PLOTS.9367
        call next (whline,i,error)                                               PLOTS.9368
        if (error) then                                                          PLOTS.9369
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.9370
          lsize    = 8                                                           PLOTS.9371
          lintv    = 4                                                           PLOTS.9372
          langl    = 0                                                           PLOTS.9373
          lortn    = 1                                                           PLOTS.9374
        end if                                                                   PLOTS.9375
      end if                                                                     PLOTS.9376
                                                                                 PLOTS.9377
C  How big should line labels be                                                 PLOTS.9378
C  This is specified in plotter coordinates                                      PLOTS.9379
                                                                                 PLOTS.9380
      if (.not. error) then                                                      PLOTS.9381
        call search (whline,i,error)                                             PLOTS.9382
        if (error) then                                                          PLOTS.9383
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.9384
          lsize    = 8                                                           PLOTS.9385
          lintv    = 4                                                           PLOTS.9386
          langl    = 0                                                           PLOTS.9387
          lortn    = 1                                                           PLOTS.9388
        end if                                                                   PLOTS.9389
      end if                                                                     PLOTS.9390
                                                                                 PLOTS.9391
      if (.not. error) then                                                      PLOTS.9392
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.9393
          lsize = 8                                                              PLOTS.9394
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.9395
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.9396
          read  (whline(i:i+1),20,err=40) lsize                                  PLOTS.9397
        else                                                                     PLOTS.9398
          read (whline(i:i),30,err=40) lsize                                     PLOTS.9399
        end if                                                                   PLOTS.9400
        goto 45                                                                  PLOTS.9401
                                                                                 PLOTS.9402
C  Inform the user of an error if here                                           PLOTS.9403
                                                                                 PLOTS.9404
40      ermes(1:30)  = 'Line Label Size Input Conversi'                          PLOTS.9405
        ermes(31:60) = 'on                            '                          PLOTS.9406
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.9407
        lsize    = 8                                                             PLOTS.9408
        langl    = 0                                                             PLOTS.9409
        lintv    = 4                                                             PLOTS.9410
        lortn    = 1                                                             PLOTS.9411
        error = .true.                                                           PLOTS.9412
                                                                                 PLOTS.9413
45      if (.not. error) then                                                    PLOTS.9414
          call next (whline,i,error)                                             PLOTS.9415
          if (error) then                                                        PLOTS.9416
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.9417
            lintv    = 4                                                         PLOTS.9418
            langl    = 0                                                         PLOTS.9419
            lortn    = 1                                                         PLOTS.9420
          end if                                                                 PLOTS.9421
        end if                                                                   PLOTS.9422
      end if                                                                     PLOTS.9423
                                                                                 PLOTS.9424
C  Check to see how the user wants their labels oriented                         PLOTS.9425
C  D,d           => drawn along with line                                        PLOTS.9426
C  360 > x > 0   => rotated x degrees from horizontal                            PLOTS.9427
C  = 0           => horizontal                                                   PLOTS.9428
                                                                                 PLOTS.9429
      if (.not. error) then                                                      PLOTS.9430
        call search (whline,i,error)                                             PLOTS.9431
        if (error) then                                                          PLOTS.9432
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.9433
          lintv    = 4                                                           PLOTS.9434
          langl    = 0                                                           PLOTS.9435
          lortn    = 1                                                           PLOTS.9436
        end if                                                                   PLOTS.9437
      end if                                                                     PLOTS.9438
                                                                                 PLOTS.9439
      if (.not. error) then                                                      PLOTS.9440
        if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then             PLOTS.9441
          lortn = 1                                                              PLOTS.9442
          langl = 0                                                              PLOTS.9443
        else                                                                     PLOTS.9444
          lortn = 0                                                              PLOTS.9445
          if ((whline(i+1:i+1) .ne. ' ') .and.                                   PLOTS.9446
     *        (whline(i+1:i+1) .ne. '|')) then                                   PLOTS.9447
            if ((whline(i+2:i+2) .ne. ' ') .and.                                 PLOTS.9448
     *          (whline(i+2:i+2) .ne. '|')) then                                 PLOTS.9449
              read (whline(i:i+2),60,err=50) langl                               PLOTS.9450
            else                                                                 PLOTS.9451
              read (whline(i:i+1),20,err=50) langl                               PLOTS.9452
            end if                                                               PLOTS.9453
          else                                                                   PLOTS.9454
            read (whline(i:i),30,err=50) langl                                   PLOTS.9455
          end if                                                                 PLOTS.9456
        end if                                                                   PLOTS.9457
        goto 55                                                                  PLOTS.9458
                                                                                 PLOTS.9459
C  Inform user of error if here                                                  PLOTS.9460
                                                                                 PLOTS.9461
50      ermes(1:30)  = 'Line Label Angle Input Convers'                          PLOTS.9462
        ermes(31:60) = 'ion                           '                          PLOTS.9463
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.9464
        langl    = 0                                                             PLOTS.9465
        lintv    = 4                                                             PLOTS.9466
        lortn    = 1                                                             PLOTS.9467
        error = .true.                                                           PLOTS.9468
                                                                                 PLOTS.9469
55      if (.not. error) then                                                    PLOTS.9470
          call next (whline,i,error)                                             PLOTS.9471
          if (error) then                                                        PLOTS.9472
            call errhan ('CONDRV',1,q,errsev)                                    PLOTS.9473
            lintv = 4                                                            PLOTS.9474
          end if                                                                 PLOTS.9475
        end if                                                                   PLOTS.9476
      end if                                                                     PLOTS.9477
                                                                                 PLOTS.9478
C  Get the interval of lines at which to place line labels                       PLOTS.9479
                                                                                 PLOTS.9480
      if (.not. error) then                                                      PLOTS.9481
        call search (whline,i,error)                                             PLOTS.9482
        if (error) then                                                          PLOTS.9483
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.9484
          lintv = 4                                                              PLOTS.9485
        end if                                                                   PLOTS.9486
      end if                                                                     PLOTS.9487
                                                                                 PLOTS.9488
      if (.not. error) then                                                      PLOTS.9489
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.9490
          lintv = 4                                                              PLOTS.9491
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.9492
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.9493
          if ((whline(i+2:i+2) .ne. ' ') .and.                                   PLOTS.9494
     *        (whline(i+2:i+2) .ne. '|')) then                                   PLOTS.9495
            read (whline(i:i+2),60,err=70) lintv                                 PLOTS.9496
          else                                                                   PLOTS.9497
            read (whline(i:i+1),20,err=70) lintv                                 PLOTS.9498
          end if                                                                 PLOTS.9499
        else                                                                     PLOTS.9500
          read (whline(i:i),30,err=70) lintv                                     PLOTS.9501
        end if                                                                   PLOTS.9502
        goto 75                                                                  PLOTS.9503
                                                                                 PLOTS.9504
C  Inform user of an error if here                                               PLOTS.9505
                                                                                 PLOTS.9506
70      ermes(1:30)  = 'Line Label Placement Interval '                          PLOTS.9507
        ermes(31:60) = 'Input Conversion              '                          PLOTS.9508
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.9509
        lintv    = 4                                                             PLOTS.9510
        error = .true.                                                           PLOTS.9511
                                                                                 PLOTS.9512
75      if (.not. error) then                                                    PLOTS.9513
          call next (whline,i,error)                                             PLOTS.9514
          if (error) then                                                        PLOTS.9515
            call errhan ('CONDRV',0,q,errsev)                                    PLOTS.9516
          else                                                                   PLOTS.9517
            call search (whline,i,error)                                         PLOTS.9518
            if (.not. error) then                                                PLOTS.9519
              ermes(1:30)  = 'Reading Line Labels Informatio'                    PLOTS.9520
              ermes(31:60) = 'n, Too Many Entries On Line   '                    PLOTS.9521
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.9522
            end if                                                               PLOTS.9523
          end if                                                                 PLOTS.9524
        end if                                                                   PLOTS.9525
      end if                                                                     PLOTS.9526
                                                                                 PLOTS.9527
                                                                                 PLOTS.9528
C  Check for some value errors                                                   PLOTS.9529
C  LPRLW must be between 1 and 10 inclusive if the perimeter is going to         PLOTS.9530
C  be drawn around boxes                                                         PLOTS.9531
                                                                                 PLOTS.9532
      if ((lputp) .and. (lprlw .lt. 1.0)) then                                   PLOTS.9533
        ermes(1:30)  = 'Line Label Box Perimeter Width'                          PLOTS.9534
        ermes(31:60) = 's Less Than 1 Are Ineffective '                          PLOTS.9535
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9536
        lprlw = 1.0                                                              PLOTS.9537
      end if                                                                     PLOTS.9538
      if ((lputp) .and. (lprlw .gt. 10.0)) then                                  PLOTS.9539
        ermes(1:30)  = 'Line Label Box Perimeter Width'                          PLOTS.9540
        ermes(31:60) = 's Greater Than 10 Are Too Big '                          PLOTS.9541
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9542
        lprlw = 10.0                                                             PLOTS.9543
      end if                                                                     PLOTS.9544
                                                                                 PLOTS.9545
C  Maximum Label Size is 25 and the minimum is 1                                 PLOTS.9546
                                                                                 PLOTS.9547
      if (lsize .lt. 1) then                                                     PLOTS.9548
        ermes(1:30)  = 'Line Label Size Is Too Small, '                          PLOTS.9549
        ermes(31:60) = 'Changed To 1                  '                          PLOTS.9550
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9551
        lsize = 1                                                                PLOTS.9552
      end if                                                                     PLOTS.9553
      if (lsize .gt. 25) then                                                    PLOTS.9554
        ermes(1:30)  = 'Line Label Size Is Too Large, '                          PLOTS.9555
        ermes(31:60) = 'Changed To 25                 '                          PLOTS.9556
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9557
        lsize = 25                                                               PLOTS.9558
      end if                                                                     PLOTS.9559
                                                                                 PLOTS.9560
C  Label angle must be between 0 and 360                                         PLOTS.9561
                                                                                 PLOTS.9562
      if ((langl .lt. 0) .or. (langl .gt. 360)) then                             PLOTS.9563
        ermes(1:30)  = 'Line Label Angle Is Invalid, L'                          PLOTS.9564
        ermes(31:60) = 'abels Will Be Along Lines     '                          PLOTS.9565
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9566
        langl = 0                                                                PLOTS.9567
        lortn = 1                                                                PLOTS.9568
      end if                                                                     PLOTS.9569
                                                                                 PLOTS.9570
C  Label Interval must be at least 1 and at most 100                             PLOTS.9571
                                                                                 PLOTS.9572
      if (lintv .lt. 1) then                                                     PLOTS.9573
        ermes(1:30)  = 'Line Label Placement Interval '                          PLOTS.9574
        ermes(31:60) = 'Too Small, Changed to 1       '                          PLOTS.9575
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9576
        lintv = 1                                                                PLOTS.9577
      end if                                                                     PLOTS.9578
      if (lintv .gt. 100) then                                                   PLOTS.9579
        ermes(1:30)  = 'Line Label Placement Interval '                          PLOTS.9580
        ermes(31:60) = 'Too Large, Changed to 100     '                          PLOTS.9581
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.9582
        lintv = 100                                                              PLOTS.9583
      end if                                                                     PLOTS.9584
                                                                                 PLOTS.9585
C  Assign output variable                                                        PLOTS.9586
                                                                                 PLOTS.9587
      ofilb = lfilb                                                              PLOTS.9588
                                                                                 PLOTS.9589
C*****************************  subroutine end  ******************************C  PLOTS.9590
                                                                                 PLOTS.9591
C  Format statements begin ...                                                   PLOTS.9592
                                                                                 PLOTS.9593
20    format (I2)                                                                PLOTS.9594
30    format (I1)                                                                PLOTS.9595
60    format (I3)                                                                PLOTS.9596
                                                                                 PLOTS.9597
C  Format statements end.                                                        PLOTS.9598
                                                                                 PLOTS.9599
      return                                                                     PLOTS.9600
      end                                                                        PLOTS.9601
      subroutine crdprt (unum,errsev,cmeth,scale)                                PLOTS.9602
                                                                                 PLOTS.9603
C*****************************************************************************C  PLOTS.9604
C  crdprt   - This is a CONDRV routine                                        C  PLOTS.9605
C  Section  - Tables                                                          C  PLOTS.9606
C  Purpose  - To read in contouring partitions indicated by the user.         C  PLOTS.9607
C                                                                             C  PLOTS.9608
C  On entry - UNUM is the unit number of the file containing the  CON  PARTI- C  PLOTS.9609
C             TIONS table.   ERRSEV indicated what  severity of error  should C  PLOTS.9610
C             halt execution.   CMETH is the  coloring  method to be used  in C  PLOTS.9611
C             the  picture.   SCALE is a scaling factor that will be used  in C  PLOTS.9612
C             labeling the plot.                                              C  PLOTS.9613
C                                                                             C  PLOTS.9614
C  On exit  - Variables in common blocks for partitions,  color,  line width, C  PLOTS.9615
C             and dash pattern have been set up.  Remember not  all of  these C  PLOTS.9616
C             need to be set up all the time.                                 C  PLOTS.9617
C                                                                             C  PLOTS.9618
C  Assume   - Nothing                                                         C  PLOTS.9619
C                                                                             C  PLOTS.9620
C  Notes    - Routine             Location of Definition                      C  PLOTS.9621
C             ----------------------------------------------------------------C  PLOTS.9622
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.9623
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.9624
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.9625
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.9626
C             TBLLOK              CONDRV/MAPDRV utility                       C  PLOTS.9627
C             CRDRCI              CONDRV/MAPDRV utility                       C  PLOTS.9628
C             ----------------------------------------------------------------C  PLOTS.9629
C                                                                             C  PLOTS.9630
C  Author   - Jeremy Asbill      Date - August 9, 1990      for the MM4 club  C  PLOTS.9631
C*****************************************************************************C  PLOTS.9632
                                                                                 PLOTS.9633
C  Parameters                                                                    PLOTS.9634
                                                                                 PLOTS.9635
      parameter       (imin = -1)        ! since before the first contour level  PLOTS.9636
      parameter       (imax = 101)       ! until after the last contour level    PLOTS.9637
      parameter       (rmin = -1.0E36)   ! the smallest value in the data        PLOTS.9638
      parameter       (rmax = 1.0E36)    ! the largest value in the data         PLOTS.9639
                                                                                 PLOTS.9640
C  Character variables                                                           PLOTS.9641
                                                                                 PLOTS.9642
      character*80     whline            ! a whole line from the table  (local)  PLOTS.9643
      character*60     ermes,            ! error message string,general (local)  PLOTS.9644
     *                 p,                ! error message string,SEARCH  (local)  PLOTS.9645
     *                 q                 ! error message string,NEXT    (local)  PLOTS.9646
      character*36     cermes            ! color index error message    (local)  PLOTS.9647
      character*20     gstrng            ! string for GTREAL            (local)  PLOTS.9648
                                                                                 PLOTS.9649
C  Integer variables                                                             PLOTS.9650
                                                                                 PLOTS.9651
      integer          errsev,           ! error severity comparitor       (in)  PLOTS.9652
     *                 unum,             ! unit number of table file       (in)  PLOTS.9653
     *                 cmeth             ! coloring method to use          (in)  PLOTS.9654
      integer          ddpv(3)           ! for common block LWDPDT               PLOTS.9655
      integer          nprt,             ! for common block PARINF               PLOTS.9656
     *                 iprts(100,2)      ! for common block PARINF               PLOTS.9657
      integer          pcolor(100,2)     ! for common block PARCOL               PLOTS.9658
      integer          pdpv(100)         ! for common block LWDPPR               PLOTS.9659
      integer          cmln,             ! number of chars in CERMES    (local)  PLOTS.9660
     *                 i,j               ! loop counter/place keeper    (local)  PLOTS.9661
                                                                                 PLOTS.9662
C  Logical variables                                                             PLOTS.9663
                                                                                 PLOTS.9664
      logical          noplt             ! don't make any plot ?           (in)  PLOTS.9665
      logical          ints              ! for common block PARINF               PLOTS.9666
      logical          found,            ! was the table found ?        (local)  PLOTS.9667
     *                 error,            ! has an error occured ?       (local)  PLOTS.9668
     *                 done              ! are all partitions in ?      (local)  PLOTS.9669
                                                                                 PLOTS.9670
C  Real variables                                                                PLOTS.9671
                                                                                 PLOTS.9672
      real             scale             ! scaling factor                  (in)  PLOTS.9673
      real             dlwv(3)           ! for common block LWDPDT               PLOTS.9674
      real             rprts(100,2)      ! for common block PARINF               PLOTS.9675
      real             plwv(100)         ! for common block LWDPPR               PLOTS.9676
                                                                                 PLOTS.9677
C  Common blocks                                                                 PLOTS.9678
                                                                                 PLOTS.9679
      common /lwdpdt/  dlwv,             ! details line width values             PLOTS.9680
     *                 ddpv              ! details dash pattern values           PLOTS.9681
      common /parinf/  nprt,             ! number of partitions                  PLOTS.9682
     *                 iprts,            ! integer partitions                    PLOTS.9683
     *                 rprts,            ! real partitions                       PLOTS.9684
     *                 ints              ! are the partitions integers ?         PLOTS.9685
      common /parcol/  pcolor            ! colors for each partition             PLOTS.9686
      common /lwdppr/  plwv,             ! partition line width values           PLOTS.9687
     *                 pdpv              ! partition dash pattern values         PLOTS.9688
      common /noplot/  noplt             ! don't draw anything ?                 PLOTS.9689
                                                                                 PLOTS.9690
C****************************  Subroutine Begin  *****************************C  PLOTS.9691
                                                                                 PLOTS.9692
C  If no picture will be made don't bother parsing the table                     PLOTS.9693
                                                                                 PLOTS.9694
      if (noplt) goto 110                                                        PLOTS.9695
                                                                                 PLOTS.9696
C  Only read the table if the prior tables indicated that we should do so        PLOTS.9697
C  Those indications are :                                                       PLOTS.9698
C    (1) There was no line width given before (DLWV(x) < 0)                      PLOTS.9699
C    (2) There was no dash pattern given before (DDPV(x) = 0)                    PLOTS.9700
C    (3) The coloring method includes user specified partitions                  PLOTS.9701
C        (CMETH = 2,3,4,5)                                                       PLOTS.9702
                                                                                 PLOTS.9703
      if (((cmeth .ge. 2) .and. (cmeth .le. 5)) .or.                             PLOTS.9704
     *    (dlwv(1) .lt. 0.0) .or. (ddpv(1) .eq. 0)) then                         PLOTS.9705
                                                                                 PLOTS.9706
C  The table should be there, since we are here, try to read in the first line   PLOTS.9707
                                                                                 PLOTS.9708
        call tbllok (unum,'CON PARTIT',errsev,found,whline,'CONDRV')             PLOTS.9709
                                                                                 PLOTS.9710
C  If the table was found, parse it                                              PLOTS.9711
                                                                                 PLOTS.9712
        if (found) then                                                          PLOTS.9713
                                                                                 PLOTS.9714
C  Initialize all parsing tools and place keepers                                PLOTS.9715
                                                                                 PLOTS.9716
          i        = 1                                                           PLOTS.9717
          p(1:23)  = 'Reading Partition Table'                                   PLOTS.9718
          p(24:60) = ', Too Few Entries On Line            '                     PLOTS.9719
          q(1:23)  = p(1:23)                                                     PLOTS.9720
          q(24:60) = ', Entry Is Bizarre                   '                     PLOTS.9721
          error    = .false.                                                     PLOTS.9722
          nprt     = 0                                                           PLOTS.9723
          done     = .false.                                                     PLOTS.9724
                                                                                 PLOTS.9725
C  Get to the first entry in the table                                           PLOTS.9726
                                                                                 PLOTS.9727
          call search (whline,i,error)                                           PLOTS.9728
          if (error) then                                                        PLOTS.9729
            found = .false.                                                      PLOTS.9730
            done  = .true.                                                       PLOTS.9731
          end if                                                                 PLOTS.9732
                                                                                 PLOTS.9733
C  The partition specification should always be there                            PLOTS.9734
C  If CMETH = 3,5 then the specifications will be integers                       PLOTS.9735
C  If CMETH = 2,4 then the specifications will be reals                          PLOTS.9736
C  If CMETH is not in either of those groups assume the partitions are           PLOTS.9737
C    reals                                                                       PLOTS.9738
                                                                                 PLOTS.9739
          if ((cmeth .eq. 3) .or. (cmeth .eq. 5)) then                           PLOTS.9740
            ints = .true.                                                        PLOTS.9741
          else                                                                   PLOTS.9742
            ints = .false.                                                       PLOTS.9743
          end if                                                                 PLOTS.9744
                                                                                 PLOTS.9745
C  This is the begining of the loop that is iterated once per line of the        PLOTS.9746
C  table                                                                         PLOTS.9747
                                                                                 PLOTS.9748
10        nprt = nprt + 1                                                        PLOTS.9749
                                                                                 PLOTS.9750
          if ((ints) .and. (.not. error)) then                                   PLOTS.9751
                                                                                 PLOTS.9752
C  An M,m in the minimum column means that that partition starts with the        PLOTS.9753
C  first level in the plot                                                       PLOTS.9754
                                                                                 PLOTS.9755
            if ((whline(i:i) .eq. 'M') .or.                                      PLOTS.9756
     *          (whline(i:i) .eq. 'm')) then                                     PLOTS.9757
              iprts(nprt,1) = imin                                               PLOTS.9758
            else if ((whline(i+1:i+1) .ne. ' ') .and.                            PLOTS.9759
     *               (whline(i+1:i+1) .ne. '|')) then                            PLOTS.9760
              read (whline(i:i+1),20,err=40) iprts(nprt,1)                       PLOTS.9761
            else                                                                 PLOTS.9762
              read (whline(i:i),30,err=40) iprts(nprt,1)                         PLOTS.9763
            end if                                                               PLOTS.9764
            goto 45                                                              PLOTS.9765
                                                                                 PLOTS.9766
C  If there is an error in reading the value, inform the user here               PLOTS.9767
                                                                                 PLOTS.9768
40          ermes(1:30)  = 'Partition Minimum Boundary Inp'                      PLOTS.9769
            ermes(31:60) = 'ut Conversion                 '                      PLOTS.9770
            call errhan ('CONDRV',1,ermes,errsev)                                PLOTS.9771
            found = .false.                                                      PLOTS.9772
            done  = .true.                                                       PLOTS.9773
            error = .true.                                                       PLOTS.9774
                                                                                 PLOTS.9775
C  Goto maximum column                                                           PLOTS.9776
                                                                                 PLOTS.9777
45          if (.not. error) then                                                PLOTS.9778
              call next (whline,i,error)                                         PLOTS.9779
              if (error) then                                                    PLOTS.9780
                call errhan ('CONDRV',1,q,errsev)                                PLOTS.9781
                found = .false.                                                  PLOTS.9782
                done  = .true.                                                   PLOTS.9783
              end if                                                             PLOTS.9784
            end if                                                               PLOTS.9785
                                                                                 PLOTS.9786
            if (.not. error) then                                                PLOTS.9787
              call search (whline,i,error)                                       PLOTS.9788
              if (error) then                                                    PLOTS.9789
                call errhan ('CONDRV',1,p,errsev)                                PLOTS.9790
                found = .false.                                                  PLOTS.9791
                done  = .true.                                                   PLOTS.9792
              end if                                                             PLOTS.9793
            end if                                                               PLOTS.9794
                                                                                 PLOTS.9795
C  An M,m in the maximum column means that that partition ends with the          PLOTS.9796
C  last level in the plot                                                        PLOTS.9797
                                                                                 PLOTS.9798
            if ((whline(i:i) .eq. 'M') .or.                                      PLOTS.9799
     *          (whline(i:i) .eq. 'm')) then                                     PLOTS.9800
              iprts(nprt,2) = imax                                               PLOTS.9801
              done = .true.                                                      PLOTS.9802
            else if ((whline(i+1:i+1) .ne. ' ') .and.                            PLOTS.9803
     *               (whline(i+1:i+1) .ne. '|')) then                            PLOTS.9804
              read (whline(i:i+1),20,err=60) iprts(nprt,2)                       PLOTS.9805
            else                                                                 PLOTS.9806
              read (whline(i:i),30,err=60) iprts(nprt,2)                         PLOTS.9807
            end if                                                               PLOTS.9808
            goto 65                                                              PLOTS.9809
                                                                                 PLOTS.9810
C  If there is an error in reading the value, inform the user here               PLOTS.9811
                                                                                 PLOTS.9812
60          ermes(1:30)  = 'Partition Maximum Boundary Inp'                      PLOTS.9813
            ermes(31:60) = 'ut Conversion                 '                      PLOTS.9814
            call errhan ('CONDRV',1,ermes,errsev)                                PLOTS.9815
            found = .false.                                                      PLOTS.9816
            done  = .true.                                                       PLOTS.9817
            error = .true.                                                       PLOTS.9818
65          continue                                                             PLOTS.9819
          else if (.not. error) then                                             PLOTS.9820
                                                                                 PLOTS.9821
C  An M,m in the minimum column means that that partition starts with the        PLOTS.9822
C  smallest value in the data                                                    PLOTS.9823
                                                                                 PLOTS.9824
            if ((whline(i:i) .eq. 'M') .or.                                      PLOTS.9825
     *          (whline(i:i) .eq. 'm')) then                                     PLOTS.9826
              rprts(nprt,1) = rmin                                               PLOTS.9827
            else                                                                 PLOTS.9828
              j = i                                                              PLOTS.9829
              call next (whline,i,error)                                         PLOTS.9830
              gstrng(1:i-j) = whline(j:i-1)                                      PLOTS.9831
              do 50 k = i-j+1,20                                                 PLOTS.9832
                gstrng(k:k) = ' '                                                PLOTS.9833
50            continue                                                           PLOTS.9834
              call gtreal (gstrng,rprts(nprt,1),error)                           PLOTS.9835
              if (error) then                                                    PLOTS.9836
                ermes(1:30)  = 'Partition Minimum Boundary Inp'                  PLOTS.9837
                ermes(31:60) = 'ut Conversion                 '                  PLOTS.9838
                call errhan ('CONDRV',1,ermes,errsev)                            PLOTS.9839
                found = .false.                                                  PLOTS.9840
                done  = .true.                                                   PLOTS.9841
              end if                                                             PLOTS.9842
              rprts(nprt,1) = rprts(nprt,1) * scale                              PLOTS.9843
            end if                                                               PLOTS.9844
                                                                                 PLOTS.9845
C  Goto maximum column                                                           PLOTS.9846
                                                                                 PLOTS.9847
            if (.not. error) then                                                PLOTS.9848
              call next (whline,i,error)                                         PLOTS.9849
              if (error) then                                                    PLOTS.9850
                call errhan ('CONDRV',1,q,errsev)                                PLOTS.9851
                found = .false.                                                  PLOTS.9852
                done  = .true.                                                   PLOTS.9853
              end if                                                             PLOTS.9854
            end if                                                               PLOTS.9855
                                                                                 PLOTS.9856
            if (.not. error) then                                                PLOTS.9857
              call search (whline,i,error)                                       PLOTS.9858
              if (error) then                                                    PLOTS.9859
                call errhan ('CONDRV',1,p,errsev)                                PLOTS.9860
                found = .false.                                                  PLOTS.9861
                done  = .true.                                                   PLOTS.9862
              end if                                                             PLOTS.9863
            end if                                                               PLOTS.9864
                                                                                 PLOTS.9865
C  An M,m in the maximum column means that that partition ends with the          PLOTS.9866
C  largest value in the data                                                     PLOTS.9867
                                                                                 PLOTS.9868
            if ((whline(i:i) .eq. 'M') .or.                                      PLOTS.9869
     *          (whline(i:i) .eq. 'm')) then                                     PLOTS.9870
              rprts(nprt,2) = rmax                                               PLOTS.9871
              done = .true.                                                      PLOTS.9872
            else                                                                 PLOTS.9873
              j = i                                                              PLOTS.9874
              call next (whline,i,error)                                         PLOTS.9875
              gstrng(1:i-j) = whline(j:i-1)                                      PLOTS.9876
              do 70 k = i-j+1,20                                                 PLOTS.9877
                gstrng(k:k) = ' '                                                PLOTS.9878
70            continue                                                           PLOTS.9879
              call gtreal (gstrng,rprts(nprt,2),error)                           PLOTS.9880
              if (error) then                                                    PLOTS.9881
                ermes(1:30)  = 'Partition Maximum Boundary Inp'                  PLOTS.9882
                ermes(31:60) = 'ut Conversion                 '                  PLOTS.9883
                call errhan ('CONDRV',1,ermes,errsev)                            PLOTS.9884
                found = .false.                                                  PLOTS.9885
                done  = .true.                                                   PLOTS.9886
              end if                                                             PLOTS.9887
              rprts(nprt,2) = rprts(nprt,2) * scale                              PLOTS.9888
            end if                                                               PLOTS.9889
          end if                                                                 PLOTS.9890
                                                                                 PLOTS.9891
          if (.not. error) then                                                  PLOTS.9892
            call next (whline,i,error)                                           PLOTS.9893
            if (error) then                                                      PLOTS.9894
              call errhan ('CONDRV',1,q,errsev)                                  PLOTS.9895
              found = .false.                                                    PLOTS.9896
              done  = .true.                                                     PLOTS.9897
            end if                                                               PLOTS.9898
          end if                                                                 PLOTS.9899
                                                                                 PLOTS.9900
C  The next column in the table is for COLOR 1.  COLOR 1 is the color to use     PLOTS.9901
C  on the partition if CMETH = 2,3 and is the color to ramp FROM if CMETH = 4,5  PLOTS.9902
                                                                                 PLOTS.9903
          if ((cmeth .ge. 2) .and. (cmeth .le. 5) .and.                          PLOTS.9904
     *        (.not. error)) then                                                PLOTS.9905
            call search (whline,i,error)                                         PLOTS.9906
            if (error) then                                                      PLOTS.9907
              call errhan ('CONDRV',1,p,errsev)                                  PLOTS.9908
              found = .false.                                                    PLOTS.9909
              done  = .true.                                                     PLOTS.9910
            end if                                                               PLOTS.9911
          end if                                                                 PLOTS.9912
                                                                                 PLOTS.9913
          if ((cmeth .ge. 2) .and. (cmeth .le. 5) .and.                          PLOTS.9914
     *        (.not. error)) then                                                PLOTS.9915
            cermes(1:16) = 'Color 1 On Line '                                    PLOTS.9916
            if (nprt .le. 9) then                                                PLOTS.9917
              write (cermes(17:17),30) nprt                                      PLOTS.9918
              cermes (18:36) = ' Of The Partitions'                              PLOTS.9919
              cmln = 35                                                          PLOTS.9920
            else                                                                 PLOTS.9921
              write (cermes(17:18),20) nprt                                      PLOTS.9922
              cermes (19:36) = ' Of The Partitions'                              PLOTS.9923
              cmln = 36                                                          PLOTS.9924
            end if                                                               PLOTS.9925
            call crdrci (.true.,error,pcolor(nprt,1),0,whline,i,                 PLOTS.9926
     *                   cermes,cmln,errsev,noplt,'CONDRV')                      PLOTS.9927
            if (error) then                                                      PLOTS.9928
              found = .false.                                                    PLOTS.9929
              done  = .true.                                                     PLOTS.9930
            end if                                                               PLOTS.9931
            if (noplt) goto 110                                                  PLOTS.9932
                                                                                 PLOTS.9933
            if (.not. error) then                                                PLOTS.9934
              call next (whline,i,error)                                         PLOTS.9935
              if (error) then                                                    PLOTS.9936
                if (((cmeth .eq. 2) .or. (cmeth .eq. 3)) .and.                   PLOTS.9937
     *              (dlwv(1) .ge. 0.0) .and. (ddpv(1) .ne. 0)) then              PLOTS.9938
                  call errhan ('CONDRV',0,q,errsev)                              PLOTS.9939
                else                                                             PLOTS.9940
                  call errhan ('CONDRV',1,q,errsev)                              PLOTS.9941
                  found = .false.                                                PLOTS.9942
                  done  = .true.                                                 PLOTS.9943
                end if                                                           PLOTS.9944
              end if                                                             PLOTS.9945
            end if                                                               PLOTS.9946
          end if                                                                 PLOTS.9947
                                                                                 PLOTS.9948
C  The next column in the table is for COLOR 1.  COLOR 2 is the color to         PLOTS.9949
C  ramp TO if CMETH = 4,5                                                        PLOTS.9950
                                                                                 PLOTS.9951
          if ((cmeth .eq. 4) .or. (cmeth .eq. 5) .and.                           PLOTS.9952
     *        (.not. error)) then                                                PLOTS.9953
            call search (whline,i,error)                                         PLOTS.9954
            if (error) then                                                      PLOTS.9955
              call errhan ('CONDRV',1,p,errsev)                                  PLOTS.9956
              found = .false.                                                    PLOTS.9957
              done  = .true.                                                     PLOTS.9958
            end if                                                               PLOTS.9959
          end if                                                                 PLOTS.9960
                                                                                 PLOTS.9961
          if ((cmeth .eq. 4) .or. (cmeth .eq. 5) .and.                           PLOTS.9962
     *        (.not. error)) then                                                PLOTS.9963
            cermes(1:16) = 'Color 2 On Line '                                    PLOTS.9964
            if (nprt .le. 9) then                                                PLOTS.9965
              write (cermes(17:17),30) nprt                                      PLOTS.9966
              cermes (18:36) = ' Of The Partitions'                              PLOTS.9967
              cmln = 35                                                          PLOTS.9968
            else                                                                 PLOTS.9969
              write (cermes(17:18),20) nprt                                      PLOTS.9970
              cermes (19:36) = ' Of The Partitions'                              PLOTS.9971
              cmln = 36                                                          PLOTS.9972
            end if                                                               PLOTS.9973
            call crdrci (.true.,error,pcolor(nprt,2),1,whline,i,                 PLOTS.9974
     *                   cermes,cmln,errsev,noplt,'CONDRV')                      PLOTS.9975
            if (error) then                                                      PLOTS.9976
              found = .false.                                                    PLOTS.9977
              done  = .true.                                                     PLOTS.9978
            end if                                                               PLOTS.9979
            if (noplt) goto 110                                                  PLOTS.9980
                                                                                 PLOTS.9981
            if (.not. error) then                                                PLOTS.9982
              call next (whline,i,error)                                         PLOTS.9983
              if (error) then                                                    PLOTS.9984
                if ((dlwv(1) .ge. 0.0) .and. (ddpv(1) .ne. 0)) then              PLOTS.9985
                  call errhan ('CONDRV',0,q,errsev)                              PLOTS.9986
                else                                                             PLOTS.9987
                  call errhan ('CONDRV',1,q,errsev)                              PLOTS.9988
                  found = .false.                                                PLOTS.9989
                  done  = .true.                                                 PLOTS.9990
                end if                                                           PLOTS.9991
              end if                                                             PLOTS.9992
            end if                                                               PLOTS.9993
          end if                                                                 PLOTS.9994
                                                                                 PLOTS.9995
C  The next column in the table is for line width if it is needed                PLOTS.9996
                                                                                 PLOTS.9997
          if (dlwv(1) .lt. 0.0) then                                             PLOTS.9998
            call search (whline,i,error)                                         PLOTS.9999
            if (error) then                                                      PLOTS.10000
              call errhan ('CONDRV',1,p,errsev)                                  PLOTS.10001
              found = .false.                                                    PLOTS.10002
              done  = .true.                                                     PLOTS.10003
            end if                                                               PLOTS.10004
          end if                                                                 PLOTS.10005
                                                                                 PLOTS.10006
          if (dlwv(1) .lt. 0.0) then                                             PLOTS.10007
            if ((whline(i:i) .eq. 'D') .or.                                      PLOTS.10008
     *          (whline(i:i) .eq. 'd')) then                                     PLOTS.10009
              plwv(nprt) = 1.0                                                   PLOTS.10010
            else                                                                 PLOTS.10011
              j = i                                                              PLOTS.10012
              call next (whline,i,error)                                         PLOTS.10013
              gstrng(1:i-j) = whline(j:i-1)                                      PLOTS.10014
              do 80 k = i-j+1,20                                                 PLOTS.10015
                gstrng(k:k) = ' '                                                PLOTS.10016
80            continue                                                           PLOTS.10017
              call gtreal (gstrng,plwv(nprt),error)                              PLOTS.10018
              if (error) then                                                    PLOTS.10019
                ermes(1:30)  = 'Line Width Multiplier On Line '                  PLOTS.10020
                if (nprt .le. 9) then                                            PLOTS.10021
                  write (ermes(31:31),30) nprt                                   PLOTS.10022
                  ermes(32:60) = ' Input Conversion            '                 PLOTS.10023
                else                                                             PLOTS.10024
                  write (ermes(31:32),20) nprt                                   PLOTS.10025
                  ermes(33:60) = ' Input Conversion           '                  PLOTS.10026
                end if                                                           PLOTS.10027
                call errhan ('CONDRV',1,ermes,errsev)                            PLOTS.10028
                found = .false.                                                  PLOTS.10029
                done  = .true.                                                   PLOTS.10030
              end if                                                             PLOTS.10031
                                                                                 PLOTS.10032
C  Make sure the given value is within reason                                    PLOTS.10033
                                                                                 PLOTS.10034
              if (plwv(nprt) .lt. 1.0) then                                      PLOTS.10035
                ermes(1:27)  = 'Line Width Entered On Line '                     PLOTS.10036
                if (nprt .le. 9) then                                            PLOTS.10037
                  write (ermes(28:28),30) nprt                                   PLOTS.10038
                  ermes(29:60) = ' Is Too Small, 1 Used           '              PLOTS.10039
                else                                                             PLOTS.10040
                  write (ermes(28:29),20) nprt                                   PLOTS.10041
                  ermes(30:60) = ' Is Too Small, 1 Used          '               PLOTS.10042
                end if                                                           PLOTS.10043
                call errhan ('CONDRV',0,ermes,errsev)                            PLOTS.10044
                plwv(nprt) = 1.0                                                 PLOTS.10045
              else if (plwv(nprt) .gt. 10.0) then                                PLOTS.10046
                ermes(1:27)  = 'Line Width Entered On Line '                     PLOTS.10047
                if (nprt .le. 9) then                                            PLOTS.10048
                  write (ermes(28:28),30) nprt                                   PLOTS.10049
                  ermes(29:60) = ' Is Too Large, 10 Used          '              PLOTS.10050
                else                                                             PLOTS.10051
                  write (ermes(28:29),20) nprt                                   PLOTS.10052
                  ermes(30:60) = ' Is Too Large, 10 Used         '               PLOTS.10053
                end if                                                           PLOTS.10054
                call errhan ('CONDRV',0,ermes,errsev)                            PLOTS.10055
                plwv(nprt) = 10.0                                                PLOTS.10056
              end if                                                             PLOTS.10057
            end if                                                               PLOTS.10058
                                                                                 PLOTS.10059
            if (.not. error) then                                                PLOTS.10060
              call next (whline,i,error)                                         PLOTS.10061
              if (error) then                                                    PLOTS.10062
                if (ddpv(1) .ne. 0) then                                         PLOTS.10063
                  call errhan ('CONDRV',0,q,errsev)                              PLOTS.10064
                else                                                             PLOTS.10065
                  call errhan ('CONDRV',1,q,errsev)                              PLOTS.10066
                  found = .false.                                                PLOTS.10067
                  done  = .true.                                                 PLOTS.10068
                end if                                                           PLOTS.10069
              end if                                                             PLOTS.10070
            end if                                                               PLOTS.10071
          end if                                                                 PLOTS.10072
                                                                                 PLOTS.10073
C  The next column in the table is for dash pattern if it is needed              PLOTS.10074
                                                                                 PLOTS.10075
          if (ddpv(1) .eq. 0) then                                               PLOTS.10076
            call search (whline,i,error)                                         PLOTS.10077
            if (error) then                                                      PLOTS.10078
              call errhan ('CONDRV',1,p,errsev)                                  PLOTS.10079
              found = .false.                                                    PLOTS.10080
              done  = .true.                                                     PLOTS.10081
            end if                                                               PLOTS.10082
          end if                                                                 PLOTS.10083
                                                                                 PLOTS.10084
          if (ddpv(1) .eq. 0) then                                               PLOTS.10085
            if ((whline(i:i) .eq. 'D') .or.                                      PLOTS.10086
     *          (whline(i:i) .eq. 'd') .or.                                      PLOTS.10087
     *          (whline(i:i+1) .eq. 'SO') .or.                                   PLOTS.10088
     *          (whline(i:i+1) .eq. 'So') .or.                                   PLOTS.10089
     *          (whline(i:i+1) .eq. 'so') .or.                                   PLOTS.10090
     *          (whline(i:i+1) .eq. 'sO')) then                                  PLOTS.10091
              pdpv(nprt) = -1                                                    PLOTS.10092
            else if ((whline(i:i) .eq. 'L') .or.                                 PLOTS.10093
     *               (whline(i:i) .eq. 'l')) then                                PLOTS.10094
              pdpv(nprt) = 255                                                   PLOTS.10095
            else if ((whline(i:i) .eq. 'M') .or.                                 PLOTS.10096
     *               (whline(i:i) .eq. 'm')) then                                PLOTS.10097
              pdpv(nprt) = 3855                                                  PLOTS.10098
            else if ((whline(i:i+1) .eq. 'SM') .or.                              PLOTS.10099
     *               (whline(i:i+1) .eq. 'Sm') .or.                              PLOTS.10100
     *               (whline(i:i+1) .eq. 'sM') .or.                              PLOTS.10101
     *               (whline(i:i+1) .eq. 'sm')) then                             PLOTS.10102
              pdpv(nprt) = 13107                                                 PLOTS.10103
            else if ((whline(i:i) .eq. 'T') .or.                                 PLOTS.10104
     *               (whline(i:i) .eq. 't')) then                                PLOTS.10105
              pdpv(nprt) = 21845                                                 PLOTS.10106
            else                                                                 PLOTS.10107
              ermes(1:27)  = 'Dash Pattern Given On Line '                       PLOTS.10108
              if (nprt .le. 9) then                                              PLOTS.10109
                write (ermes(28:28),30) nprt                                     PLOTS.10110
                ermes(29:60) = ' Is Unknown, SO Used            '                PLOTS.10111
              else                                                               PLOTS.10112
                write (ermes(28:29),20) nprt                                     PLOTS.10113
                ermes(30:60) = ' Is Unknown, SO Used           '                 PLOTS.10114
              end if                                                             PLOTS.10115
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.10116
              pdpv(nprt) = -1                                                    PLOTS.10117
            end if                                                               PLOTS.10118
                                                                                 PLOTS.10119
            if (.not. error) then                                                PLOTS.10120
              call next (whline,i,error)                                         PLOTS.10121
              if (error) then                                                    PLOTS.10122
                call errhan ('CONDRV',0,q,errsev)                                PLOTS.10123
              end if                                                             PLOTS.10124
            end if                                                               PLOTS.10125
          end if                                                                 PLOTS.10126
                                                                                 PLOTS.10127
C  Check for extra entries on the line                                           PLOTS.10128
                                                                                 PLOTS.10129
          if (.not. error) then                                                  PLOTS.10130
            call search (whline,i,error)                                         PLOTS.10131
            if (.not. error) then                                                PLOTS.10132
              ermes(1:25)  = 'Too Many Entries On Line '                         PLOTS.10133
              if (nprt .le. 9) then                                              PLOTS.10134
                write (ermes(26:26),30) nprt                                     PLOTS.10135
                ermes(27:60) = ' Of The Partitions Table          '              PLOTS.10136
              else                                                               PLOTS.10137
                write (ermes(26:27),20) nprt                                     PLOTS.10138
                ermes(28:60) = ' Of The Partitions Table         '               PLOTS.10139
              end if                                                             PLOTS.10140
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.10141
            end if                                                               PLOTS.10142
          end if                                                                 PLOTS.10143
                                                                                 PLOTS.10144
C  Go back and read the next line if that was not the last one                   PLOTS.10145
                                                                                 PLOTS.10146
          if (.not. done) then                                                   PLOTS.10147
            read (unum,90,err=100,end=100) whline(1:80)                          PLOTS.10148
            i = 1                                                                PLOTS.10149
            call search (whline,i,error)                                         PLOTS.10150
            if (error) then                                                      PLOTS.10151
              ermes(1:30)  = 'More Lines Expected In Partiti'                    PLOTS.10152
              ermes(31:60) = 'ons Table                     '                    PLOTS.10153
            else                                                                 PLOTS.10154
              goto 10                                                            PLOTS.10155
            end if                                                               PLOTS.10156
            goto 105                                                             PLOTS.10157
100         ermes(1:30)  = 'Could Not All Of The Partition'                      PLOTS.10158
            ermes(31:60) = 's Table                       '                      PLOTS.10159
105         call errhan ('CONDRV',1,ermes,errsev)                                PLOTS.10160
            found = .false.                                                      PLOTS.10161
          else                                                                   PLOTS.10162
            if (found) print *, 'CONDRV - Contour Partitions Set Up'             PLOTS.10163
          end if                                                                 PLOTS.10164
        end if                                                                   PLOTS.10165
                                                                                 PLOTS.10166
C  If the table was not found, deliver an error message                          PLOTS.10167
                                                                                 PLOTS.10168
        if (.not. found) then                                                    PLOTS.10169
          if (nprt .le. 1) then                                                  PLOTS.10170
            ermes(1:30)  = 'Partition Table Expected But N'                      PLOTS.10171
            ermes(31:60) = 'ot Found                      '                      PLOTS.10172
            call errhan ('CONDRV',1,ermes,errsev)                                PLOTS.10173
            nprt        = 1                                                      PLOTS.10174
            iprts(1,1)  = imin                                                   PLOTS.10175
            iprts(1,2)  = imax                                                   PLOTS.10176
            ints        = .true.                                                 PLOTS.10177
            pcolor(1,1) = 0                                                      PLOTS.10178
            pcolor(1,1) = 1                                                      PLOTS.10179
            plwv(1)    = 1.0                                                     PLOTS.10180
            pdpv(1)    = -1                                                      PLOTS.10181
          else                                                                   PLOTS.10182
                                                                                 PLOTS.10183
C  If the table was found bu not complete give a different error message         PLOTS.10184
                                                                                 PLOTS.10185
            ermes(1:30)  = 'Partition Table Not Complete  '                      PLOTS.10186
            ermes(31:60) = '                              '                      PLOTS.10187
            call errhan ('CONDRV',1,ermes,errsev)                                PLOTS.10188
            if (ints) then                                                       PLOTS.10189
              iprts(nprt,1)  = iprts(nprt-1,2)                                   PLOTS.10190
              iprts(nprt,2)  = imax                                              PLOTS.10191
            else                                                                 PLOTS.10192
              rprts(nprt,1)  = rprts(nprt-1,2)                                   PLOTS.10193
              rprts(nprt,2)  = rmax                                              PLOTS.10194
            end if                                                               PLOTS.10195
            pcolor(nprt,1)   = 0                                                 PLOTS.10196
            pcolor(nprt,1)   = 1                                                 PLOTS.10197
            plwv(nprt)      = 1.0                                                PLOTS.10198
            pdpv(nprt)      = -1                                                 PLOTS.10199
          end if                                                                 PLOTS.10200
        end if                                                                   PLOTS.10201
      end if                                                                     PLOTS.10202
                                                                                 PLOTS.10203
C*****************************  Subroutine End  *****************************C   PLOTS.10204
                                                                                 PLOTS.10205
C  Format statements begin ...                                                   PLOTS.10206
                                                                                 PLOTS.10207
20    format (I2)                                                                PLOTS.10208
30    format (I1)                                                                PLOTS.10209
90    format (A80)                                                               PLOTS.10210
                                                                                 PLOTS.10211
C  Format statements end.                                                        PLOTS.10212
                                                                                 PLOTS.10213
110   return                                                                     PLOTS.10214
      end                                                                        PLOTS.10215
      subroutine crdttl (whline,errsev,tputl,ofilb)                              PLOTS.10216
                                                                                 PLOTS.10217
C*****************************************************************************C  PLOTS.10218
C  crdttl   - This is for CONDRV                                              C  PLOTS.10219
C  Section  - Tables                                                          C  PLOTS.10220
C  Purpose  - To parse out  the title  information  given in the  CON DETAILS C  PLOTS.10221
C             table.                                                          C  PLOTS.10222
C                                                                             C  PLOTS.10223
C  On entry - WHLINE contains the line from the table giving all of the title C  PLOTS.10224
C             information.  ERRSEV indicates what severity of error will halt C  PLOTS.10225
C             execution.   TPUTL is 0  if label bar information is to be read C  PLOTS.10226
C             and is 1 if title information is to be read.                    C  PLOTS.10227
C                                                                             C  PLOTS.10228
C  On exit  - All variables in the common block TITDET have been properly set C  PLOTS.10229
C             up.  OFILB is true if the title box will be filled and is false C  PLOTS.10230
C             otherwise.                                                      C  PLOTS.10231
C                                                                             C  PLOTS.10232
C  Assume   - Nothing                                                         C  PLOTS.10233
C                                                                             C  PLOTS.10234
C  Notes    - Routine             Location of Definition                      C  PLOTS.10235
C             ----------------------------------------------------------------C  PLOTS.10236
C             SEARCH              CONDRV/MAPDRV utility                       C  PLOTS.10237
C             NEXT                CONDRV/MAPDRV utility                       C  PLOTS.10238
C             ERRHAN              CONDRV/MAPDRV utility                       C  PLOTS.10239
C             GTREAL              CONDRV/MAPDRV utility                       C  PLOTS.10240
C             ----------------------------------------------------------------C  PLOTS.10241
C                                                                             C  PLOTS.10242
C  Author   - Jeremy Asbill       Date - June 29, 1990      for the MM4 club  C  PLOTS.10243
C*****************************************************************************C  PLOTS.10244
                                                                                 PLOTS.10245
C  Character variables                                                           PLOTS.10246
                                                                                 PLOTS.10247
      character*80     whline            ! a whole line from the table     (in)  PLOTS.10248
      character*60     ermes,            ! error mess. string, general  (local)  PLOTS.10249
     *                 p,                ! error message string, SEARCH (local)  PLOTS.10250
     *                 q                 ! error message string, NEXT   (local)  PLOTS.10251
      character*20     gstrng            ! temporary, skimpy string     (local)  PLOTS.10252
                                                                                 PLOTS.10253
C  Integer variables                                                             PLOTS.10254
                                                                                 PLOTS.10255
      integer          errsev,           ! error severity comparitor       (in)  PLOTS.10256
     *                 tputl             ! label bar/title indicator       (in)  PLOTS.10257
      integer          tsize             ! for common block TITDET               PLOTS.10258
      integer          tqual(2)          ! for common block TIQDET               PLOTS.10259
      integer          i,j,k             ! loop counters/place keepers  (local)  PLOTS.10260
                                                                                 PLOTS.10261
C  Logical variables                                                             PLOTS.10262
                                                                                 PLOTS.10263
      logical          ofilb             ! out version of TFILB           (out)  PLOTS.10264
      logical          tputb,            ! for common block TITDET               PLOTS.10265
     *                 tputp,            ! for common block TITDET               PLOTS.10266
     *                 tfilb             ! for common block TITDET               PLOTS.10267
      logical          error             ! has an error occured ?       (local)  PLOTS.10268
                                                                                 PLOTS.10269
C  Real variables                                                                PLOTS.10270
                                                                                 PLOTS.10271
      real             tprlw             ! for common block TITDET               PLOTS.10272
                                                                                 PLOTS.10273
C  Common blocks                                                                 PLOTS.10274
                                                                                 PLOTS.10275
      common /titdet/  tputb,            ! put a box around the title ?          PLOTS.10276
     *                 tputp,            ! draw the perimeter of the box ?       PLOTS.10277
     *                 tfilb,            ! fill the box ?                        PLOTS.10278
     *                 tprlw,            ! title box perim. line width           PLOTS.10279
     *                 tsize             ! title character size                  PLOTS.10280
      common /tiqdet/  tqual             ! title character quality               PLOTS.10281
                                                                                 PLOTS.10282
C****************************  subroutine begin  *****************************C  PLOTS.10283
                                                                                 PLOTS.10284
C  Set up I to use as a counter                                                  PLOTS.10285
                                                                                 PLOTS.10286
      i = 1                                                                      PLOTS.10287
                                                                                 PLOTS.10288
C  Initialize the error flag                                                     PLOTS.10289
                                                                                 PLOTS.10290
      error = .false.                                                            PLOTS.10291
                                                                                 PLOTS.10292
C  Set up SEARCH and NEXT error strings                                          PLOTS.10293
                                                                                 PLOTS.10294
      p(1:23)  = 'Reading Line Label Info'                                       PLOTS.10295
      p(24:60) = 'rmation Line, Too Few Entries On Line'                         PLOTS.10296
      q(1:23)  = p(1:23)                                                         PLOTS.10297
      q(24:60) = 'rmation Line, Entry Is Bizarre       '                         PLOTS.10298
                                                                                 PLOTS.10299
C  Whline being passed in as blanks is the same as assigning the defaults        PLOTS.10300
                                                                                 PLOTS.10301
      call search (whline,i,error)                                               PLOTS.10302
      if ((error) .and. (tputl .eq. 1)) then                                     PLOTS.10303
        tputb    = .false.                                                       PLOTS.10304
        tputp    = .false.                                                       PLOTS.10305
        tfilb    = .false.                                                       PLOTS.10306
        tsize    = 10                                                            PLOTS.10307
        tqual(1) = 1                                                             PLOTS.10308
        tqual(2) = 1                                                             PLOTS.10309
      else if ((error) .and. (tputl .eq. 0)) then                                PLOTS.10310
        tputb    = .true.                                                        PLOTS.10311
        tsize    = 0                                                             PLOTS.10312
        tqual(1) = 0                                                             PLOTS.10313
        tqual(2) = 0                                                             PLOTS.10314
      end if                                                                     PLOTS.10315
                                                                                 PLOTS.10316
C  The title box flag should be read in whether this is a label bar              PLOTS.10317
C  or a regular title                                                            PLOTS.10318
C  Y & Label Bar => make label bar one big bar                                   PLOTS.10319
C  N & Label Bar => break label bar into individual blocks                       PLOTS.10320
C  Y & Title     => put a box around the title                                   PLOTS.10321
C  N & Title     => title should not be boxed                                    PLOTS.10322
C  anything else => give a warning message                                       PLOTS.10323
                                                                                 PLOTS.10324
      if (.not. error) then                                                      PLOTS.10325
        if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then             PLOTS.10326
          tputb = .true.                                                         PLOTS.10327
        else if ((whline(i:i) .eq. 'N') .or.                                     PLOTS.10328
     *           (whline(i:i) .eq. 'n')) then                                    PLOTS.10329
          tputb = .false.                                                        PLOTS.10330
        else if (tputl .eq. 1) then                                              PLOTS.10331
          ermes(1:30)  = 'Title Box Flag Is Inconclusive'                        PLOTS.10332
          ermes(31:60) = ', N Assumed                   '                        PLOTS.10333
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10334
          tputb = .false.                                                        PLOTS.10335
        else if (tputl .eq. 0) then                                              PLOTS.10336
          ermes(1:30)  = 'Label Bar Box Flag Is Inconclu'                        PLOTS.10337
          ermes(31:60) = 'sive, Y Assumed               '                        PLOTS.10338
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10339
          tputb = .true.                                                         PLOTS.10340
        end if                                                                   PLOTS.10341
        call next (whline,i,error)                                               PLOTS.10342
        if ((error) .and. (tputl .eq. 1)) then                                   PLOTS.10343
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10344
          tsize    = 10                                                          PLOTS.10345
          tqual(1) = 1                                                           PLOTS.10346
          tqual(2) = 1                                                           PLOTS.10347
        else if ((error) .and. (tputl .eq. 0)) then                              PLOTS.10348
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10349
          tsize    = 0                                                           PLOTS.10350
          tqual(1) = 0                                                           PLOTS.10351
          tqual(2) = 0                                                           PLOTS.10352
        end if                                                                   PLOTS.10353
      end if                                                                     PLOTS.10354
                                                                                 PLOTS.10355
C  If TPUTL indicates a title and a box was requested,  parse out the box        PLOTS.10356
C  perimeter flag and the box fill flag                                          PLOTS.10357
                                                                                 PLOTS.10358
      if ((tputb) .and. (tputl .eq. 1) .and. (.not. error)) then                 PLOTS.10359
        call search (whline,i,error)                                             PLOTS.10360
        if (error) then                                                          PLOTS.10361
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10362
          tputp    = .false.                                                     PLOTS.10363
          tsize    = 10                                                          PLOTS.10364
          tqual(1) = 1                                                           PLOTS.10365
          tqual(2) = 1                                                           PLOTS.10366
        end if                                                                   PLOTS.10367
      end if                                                                     PLOTS.10368
                                                                                 PLOTS.10369
      if ((tputb) .and. (tputl .eq. 1) .and. (.not. error)) then                 PLOTS.10370
        if ((whline(i:i) .eq. 'N') .or. (whline(i:i) .eq. 'n')) then             PLOTS.10371
          tputp = .false.                                                        PLOTS.10372
        else if ((whline(i:i) .eq. 'Y') .or.                                     PLOTS.10373
     *           (whline(i:i) .eq. 'y')) then                                    PLOTS.10374
          tputp = .true.                                                         PLOTS.10375
        else                                                                     PLOTS.10376
          ermes(1:30)  = 'Title Box Perimeter Flag Is In'                        PLOTS.10377
          ermes(31:60) = 'conclusive, N Assumed         '                        PLOTS.10378
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10379
          tputp = .false.                                                        PLOTS.10380
        end if                                                                   PLOTS.10381
        call next (whline,i,error)                                               PLOTS.10382
        if (error) then                                                          PLOTS.10383
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10384
          tsize    = 10                                                          PLOTS.10385
          tqual(1) = 1                                                           PLOTS.10386
          tqual(2) = 1                                                           PLOTS.10387
        end if                                                                   PLOTS.10388
      else                                                                       PLOTS.10389
        tputp = .false.                                                          PLOTS.10390
      end if                                                                     PLOTS.10391
                                                                                 PLOTS.10392
C  If TPUTL indicates a title and a box was requested, parse to see if the       PLOTS.10393
C  box should be filled                                                          PLOTS.10394
C  Y             => Fill the box                                                 PLOTS.10395
C  N             => Leave the box hollow                                         PLOTS.10396
C  anything else => give a warning message                                       PLOTS.10397
                                                                                 PLOTS.10398
                                                                                 PLOTS.10399
      if ((tputb) .and. (tputl .eq. 1) .and. (.not. error)) then                 PLOTS.10400
        call search (whline,i,error)                                             PLOTS.10401
        if (error) then                                                          PLOTS.10402
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10403
          tfilb    = .false.                                                     PLOTS.10404
          tsize    = 10                                                          PLOTS.10405
          tqual(1) = 1                                                           PLOTS.10406
          tqual(2) = 1                                                           PLOTS.10407
        end if                                                                   PLOTS.10408
      end if                                                                     PLOTS.10409
                                                                                 PLOTS.10410
      if ((tputb) .and. (tputl .eq. 1) .and. (.not. error)) then                 PLOTS.10411
        if ((whline(i:i) .eq. 'Y') .or. (whline(i:i) .eq. 'y')) then             PLOTS.10412
          tfilb = .true.                                                         PLOTS.10413
        else if ((whline(i:i) .eq. 'N') .or.                                     PLOTS.10414
     *           (whline(i:i) .eq. 'n')) then                                    PLOTS.10415
          tfilb = .false.                                                        PLOTS.10416
        else                                                                     PLOTS.10417
          ermes(1:30)  = 'Title Box Fill Flag Is Inconcl'                        PLOTS.10418
          ermes(31:60) = 'usive, N Assumed              '                        PLOTS.10419
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10420
          tfilb = .false.                                                        PLOTS.10421
        end if                                                                   PLOTS.10422
        call next (whline,i,error)                                               PLOTS.10423
        if (error) then                                                          PLOTS.10424
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10425
          tsize    = 10                                                          PLOTS.10426
          tqual(1) = 1                                                           PLOTS.10427
          tqual(2) = 1                                                           PLOTS.10428
        end if                                                                   PLOTS.10429
      else                                                                       PLOTS.10430
        tfilb = .false.                                                          PLOTS.10431
      end if                                                                     PLOTS.10432
                                                                                 PLOTS.10433
C  Parse the perimeter line with for a label bar or a title                      PLOTS.10434
C  D,d    => use normal line width                                               PLOTS.10435
                                                                                 PLOTS.10436
      if ((((tputb) .and. (tputp)) .or. (tputl .eq. 0)) .and.                    PLOTS.10437
     *    (.not. error)) then                                                    PLOTS.10438
        call search (whline,i,error)                                             PLOTS.10439
        if ((error) .and. (tputl .eq. 1)) then                                   PLOTS.10440
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10441
          tsize    = 10                                                          PLOTS.10442
          tqual(1) = 1                                                           PLOTS.10443
          tqual(2) = 1                                                           PLOTS.10444
        else if ((error) .and. (tputl .eq. 0)) then                              PLOTS.10445
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10446
          tsize    = 0                                                           PLOTS.10447
          tqual(1) = 0                                                           PLOTS.10448
          tqual(2) = 0                                                           PLOTS.10449
        end if                                                                   PLOTS.10450
      end if                                                                     PLOTS.10451
                                                                                 PLOTS.10452
      if ((((tputb) .and. (tputp)) .or. (tputl .eq. 0)) .and.                    PLOTS.10453
     *    (.not. error)) then                                                    PLOTS.10454
        if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then             PLOTS.10455
          tprlw = 1.0                                                            PLOTS.10456
          call next (whline,i,error)                                             PLOTS.10457
        else                                                                     PLOTS.10458
          j = i                                                                  PLOTS.10459
          call next (whline,i,error)                                             PLOTS.10460
          if (.not. error) then                                                  PLOTS.10461
            gstrng(1:i-j) = whline(j:i-1)                                        PLOTS.10462
            do 10 k = i-j+1,20                                                   PLOTS.10463
              gstrng(k:k) = ' '                                                  PLOTS.10464
10          continue                                                             PLOTS.10465
            call gtreal (gstrng,tprlw,error)                                     PLOTS.10466
            if ((error) .and. (tputl .eq. 1)) then                               PLOTS.10467
              ermes(1:30)  = 'Could Not Read Title Box Perim'                    PLOTS.10468
              ermes(31:60) = 'eter Width, 1.0 Used          '                    PLOTS.10469
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.10470
              tprlw = 1.0                                                        PLOTS.10471
              error = .false.                                                    PLOTS.10472
            else if ((error) .and. (tputl .eq. 0)) then                          PLOTS.10473
              ermes(1:30)  = 'Could Not Read Label Bar Perim'                    PLOTS.10474
              ermes(31:60) = 'eter Width, 1.0 Used          '                    PLOTS.10475
              call errhan ('CONDRV',0,ermes,errsev)                              PLOTS.10476
              tprlw = 1.0                                                        PLOTS.10477
              error = .false.                                                    PLOTS.10478
            end if                                                               PLOTS.10479
          end if                                                                 PLOTS.10480
        end if                                                                   PLOTS.10481
        if ((error) .and. (tputl .eq. 1)) then                                   PLOTS.10482
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10483
          tsize    = 10                                                          PLOTS.10484
          tqual(1) = 1                                                           PLOTS.10485
          tqual(2) = 1                                                           PLOTS.10486
        else if ((error) .and. (tputl .eq. 0)) then                              PLOTS.10487
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10488
          tsize    = 0                                                           PLOTS.10489
          tqual(1) = 0                                                           PLOTS.10490
          tqual(2) = 0                                                           PLOTS.10491
        end if                                                                   PLOTS.10492
      else                                                                       PLOTS.10493
        tprlw  = 0.0                                                             PLOTS.10494
      end if                                                                     PLOTS.10495
                                                                                 PLOTS.10496
C  If TPUTL implies a title, then parse character quality                        PLOTS.10497
C  0 in space 1 => complex character set should be used                          PLOTS.10498
C  1 in space 1 => duplex character set should be used                           PLOTS.10499
C  0 in space 2 => high quality characters                                       PLOTS.10500
C  1 in space 2 => medium quality                                                PLOTS.10501
C  1 in space 3 => low quality                                                   PLOTS.10502
                                                                                 PLOTS.10503
      if ((.not. error) .and. (tputl .eq. 1)) then                               PLOTS.10504
        call search (whline,i,error)                                             PLOTS.10505
        if (error) then                                                          PLOTS.10506
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10507
          tsize    = 10                                                          PLOTS.10508
          tqual(1) = 1                                                           PLOTS.10509
          tqual(2) = 1                                                           PLOTS.10510
        end if                                                                   PLOTS.10511
      end if                                                                     PLOTS.10512
                                                                                 PLOTS.10513
      if ((.not. error) .and. (tputl .eq. 1)) then                               PLOTS.10514
        tqual(2) = -1                                                            PLOTS.10515
        if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then             PLOTS.10516
          tqual(1) = 1                                                           PLOTS.10517
          tqual(2) = 1                                                           PLOTS.10518
        else if (whline(i:i) .eq. '0') then                                      PLOTS.10519
          tqual(1) = 0                                                           PLOTS.10520
        else if (whline(i:i) .eq. '1') then                                      PLOTS.10521
          tqual(1) = 1                                                           PLOTS.10522
        else                                                                     PLOTS.10523
          ermes(1:30)  = 'Title Text Type Is Invalid, 1 '                        PLOTS.10524
          ermes(31:60) = 'Used (Duplex)                 '                        PLOTS.10525
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10526
          tqual(1) = 1                                                           PLOTS.10527
        end if                                                                   PLOTS.10528
        if (tqual(2) .eq. -1) then                                               PLOTS.10529
          i = i + 1                                                              PLOTS.10530
          if ((whline(i:i) .eq. 'd') .or. (whline(i:i) .eq. 'D')) then           PLOTS.10531
            tqual(2) = 1                                                         PLOTS.10532
          else if (whline(i:i) .eq. '0') then                                    PLOTS.10533
            tqual(2) = 0                                                         PLOTS.10534
          else if (whline(i:i) .eq. '1') then                                    PLOTS.10535
            tqual(2) = 1                                                         PLOTS.10536
          else if (whline(i:i) .eq. '2') then                                    PLOTS.10537
            tqual(2) = 2                                                         PLOTS.10538
          else                                                                   PLOTS.10539
            ermes(1:30)  = 'Title Text Quality Is Invalid,'                      PLOTS.10540
            ermes(31:60) = ' 1 Used (Medium)              '                      PLOTS.10541
            call errhan ('CONDRV',0,ermes,errsev)                                PLOTS.10542
            tqual(2) = 1                                                         PLOTS.10543
          end if                                                                 PLOTS.10544
        end if                                                                   PLOTS.10545
        call next (whline,i,error)                                               PLOTS.10546
        if (error) then                                                          PLOTS.10547
          call errhan ('CONDRV',1,q,errsev)                                      PLOTS.10548
          tsize    = 10                                                          PLOTS.10549
        end if                                                                   PLOTS.10550
      end if                                                                     PLOTS.10551
                                                                                 PLOTS.10552
C  If TPUTL implies a title, parse out the title character size                  PLOTS.10553
C  This should be specified in plotter coordinates                               PLOTS.10554
                                                                                 PLOTS.10555
      if ((.not. error) .and. (tputl .eq. 1)) then                               PLOTS.10556
        call search (whline,i,error)                                             PLOTS.10557
        if (error) then                                                          PLOTS.10558
          call errhan ('CONDRV',1,p,errsev)                                      PLOTS.10559
          tsize = 10                                                             PLOTS.10560
        end if                                                                   PLOTS.10561
      end if                                                                     PLOTS.10562
                                                                                 PLOTS.10563
      if ((.not. error) .and. (tputl .eq. 1)) then                               PLOTS.10564
        if ((whline(i:i) .eq. 'D') .or. (whline(i:i) .eq. 'd')) then             PLOTS.10565
          tsize = 10                                                             PLOTS.10566
        else if ((whline(i+1:i+1) .ne. ' ') .and.                                PLOTS.10567
     *           (whline(i+1:i+1) .ne. '|')) then                                PLOTS.10568
          read  (whline(i:i+1),20,err=40) tsize                                  PLOTS.10569
        else                                                                     PLOTS.10570
          read (whline(i:i),30,err=40) tsize                                     PLOTS.10571
        end if                                                                   PLOTS.10572
        goto 45                                                                  PLOTS.10573
                                                                                 PLOTS.10574
C  Inform the user of the error if here                                          PLOTS.10575
                                                                                 PLOTS.10576
40      ermes(1:30)  = 'Title Character Size Input Con'                          PLOTS.10577
        ermes(31:60) = 'version                       '                          PLOTS.10578
        call errhan ('CONDRV',1,ermes,errsev)                                    PLOTS.10579
        tsize = 10                                                               PLOTS.10580
        error = .true.                                                           PLOTS.10581
                                                                                 PLOTS.10582
45      if (.not. error) then                                                    PLOTS.10583
          call next (whline,i,error)                                             PLOTS.10584
          if (error)                                                             PLOTS.10585
     *      call errhan ('CONDRV',0,q,errsev)                                    PLOTS.10586
        end if                                                                   PLOTS.10587
      end if                                                                     PLOTS.10588
                                                                                 PLOTS.10589
C  Check for extra entries on the end of the line                                PLOTS.10590
                                                                                 PLOTS.10591
      if (.not. error) then                                                      PLOTS.10592
        call search (whline,i,error)                                             PLOTS.10593
        if ((.not. error) .and. (tputl .eq. 1)) then                             PLOTS.10594
          ermes(1:30)  = 'Reading Title Information Line'                        PLOTS.10595
          ermes(31:60) = ', Too Many Entries On Line    '                        PLOTS.10596
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10597
        else if ((.not. error) .and. (tputl .eq. 0)) then                        PLOTS.10598
          ermes(1:30)  = 'Reading Label Bar Information '                        PLOTS.10599
          ermes(31:60) = 'Line, Too Many Entries On Line'                        PLOTS.10600
          call errhan ('CONDRV',0,ermes,errsev)                                  PLOTS.10601
        end if                                                                   PLOTS.10602
      end if                                                                     PLOTS.10603
                                                                                 PLOTS.10604
C  Check for value errors                                                        PLOTS.10605
C  TPRLW must be between 1.0 and 10.0 inclusive                                  PLOTS.10606
                                                                                 PLOTS.10607
      if ((tprlw .lt. 1.0) .and. ((tputl .eq. 0) .or. (tputp))) then             PLOTS.10608
        if (tputl .eq. 1) then                                                   PLOTS.10609
          ermes(1:30)  = 'Title Box Perimeter Line Width'                        PLOTS.10610
          ermes(1:30)  = 'Is Too Small, 1 Used          '                        PLOTS.10611
        else                                                                     PLOTS.10612
          ermes(1:30)  = 'Label Bar Perimeter Line Width'                        PLOTS.10613
          ermes(1:30)  = 'Is Too Small, 1 Used          '                        PLOTS.10614
        end if                                                                   PLOTS.10615
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.10616
        tprlw = 1.0                                                              PLOTS.10617
      end if                                                                     PLOTS.10618
      if ((tprlw .gt. 10.0) .and. ((tputl .eq. 0) .or. (tputp))) then            PLOTS.10619
        if (tputl .eq. 1) then                                                   PLOTS.10620
          ermes(1:30)  = 'Title Box Perimeter Line Width'                        PLOTS.10621
          ermes(1:30)  = 'Is Too Large, 10 Used         '                        PLOTS.10622
        else                                                                     PLOTS.10623
          ermes(1:30)  = 'Label Bar Perimeter Line Width'                        PLOTS.10624
          ermes(1:30)  = 'Is Too Large, 10 Used         '                        PLOTS.10625
        end if                                                                   PLOTS.10626
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.10627
        tprlw = 10.0                                                             PLOTS.10628
      end if                                                                     PLOTS.10629
                                                                                 PLOTS.10630
C  TSIZE must be between 1 and 25 inclusive                                      PLOTS.10631
                                                                                 PLOTS.10632
      if ((tsize .lt. 1) .and. (tputl .eq. 1)) then                              PLOTS.10633
        ermes(1:30)  = 'Title Character Size Is Too Sm'                          PLOTS.10634
        ermes(1:30)  = 'all, 1 Used                   '                          PLOTS.10635
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.10636
        tsize = 1                                                                PLOTS.10637
      end if                                                                     PLOTS.10638
      if ((tsize .gt. 25) .and. (tputl .eq. 1)) then                             PLOTS.10639
        ermes(1:30)  = 'Title Character Size Is Too La'                          PLOTS.10640
        ermes(1:30)  = 'rge, 1 Used                   '                          PLOTS.10641
        call errhan ('CONDRV',0,ermes,errsev)                                    PLOTS.10642
        tsize = 25                                                               PLOTS.10643
      end if                                                                     PLOTS.10644
                                                                                 PLOTS.10645
C  Assign output variables                                                       PLOTS.10646
                                                                                 PLOTS.10647
      ofilb = tfilb                                                              PLOTS.10648
                                                                                 PLOTS.10649
C*****************************  subroutine end  ******************************C  PLOTS.10650
                                                                                 PLOTS.10651
C  Format statements begin ...                                                   PLOTS.10652
                                                                                 PLOTS.10653
20    format (I2)                                                                PLOTS.10654
30    format (I1)                                                                PLOTS.10655
                                                                                 PLOTS.10656
C  Format statements end.                                                        PLOTS.10657
                                                                                 PLOTS.10658
      return                                                                     PLOTS.10659
      end                                                                        PLOTS.10660
                                                                                 PLOTS.10661
      subroutine csetcl (tsize,title,pnum,scale,errsev)                          PLOTS.10662
                                                                                 PLOTS.10663
C*****************************************************************************C  PLOTS.10664
C  csetcl   - This is a CONDRV routine                                        C  PLOTS.10665
C  Section  - Design                                                          C  PLOTS.10666
C  Purpose  - To set up the color of contour levels,  style and placement  of C  PLOTS.10667
C             line labels, style of high/low labels and the color of the pre- C  PLOTS.10668
C             viously mentioned labels.  To set the color of the perimeter if C  PLOTS.10669
C             one was requested.                                              C  PLOTS.10670
C                                                                             C  PLOTS.10671
C  On entry - TITLE is the title string to draw with the plot.   TSIZE is the C  PLOTS.10672
C             number of characters in TITLE.   PNUM is the number of overlays C  PLOTS.10673
C             done previous to this one plus two.  SCALE is the scale  factor C  PLOTS.10674
C             to  be used when labeling.   ERRSEV indicates at what  severity C  PLOTS.10675
C             or an error, execution should halt.                             C  PLOTS.10676
C                                                                             C  PLOTS.10677
C  On exit  - Color and label information for the entire plot has been set.   C  PLOTS.10678
C                                                                             C  PLOTS.10679
C  Assume   - GKS is open.  CONPACK has been initialized.                     C  PLOTS.10680
C                                                                             C  PLOTS.10681
C  Notes    - Routine             Location of Definition                      C  PLOTS.10682
C             ----------------------------------------------------------------C  PLOTS.10683
C             SETTTL              CONDRV utility                              C  PLOTS.10684
C             CPSETI              CONPACK utility*                            C  PLOTS.10685
C             SETHLO              CONDRV utility                              C  PLOTS.10686
C             CPSETC              CONPACK utility                             C  PLOTS.10687
C             CRAMPS              CONDRV utility                              C  PLOTS.10688
C             SETCOL              CONDRV utility                              C  PLOTS.10689
C             SETLAB              CONDRV utility                              C  PLOTS.10690
C             MKLBAR              CONDRV utility                              C  PLOTS.10691
C             ----------------------------------------------------------------C  PLOTS.10692
C             * NCAR Graphics Routine                                         C  PLOTS.10693
C                                                                             C  PLOTS.10694
C  Author   - Jeremy Asbill     Date - August 10, 1990      for the MM4 club  C  PLOTS.10695
C*****************************************************************************C  PLOTS.10696
                                                                                 PLOTS.10697
C  Character variables                                                           PLOTS.10698
                                                                                 PLOTS.10699
      character*120    title             ! title string                    (in)  PLOTS.10700
                                                                                 PLOTS.10701
C  Integer variables                                                             PLOTS.10702
                                                                                 PLOTS.10703
      integer          tsize,            ! # of chars in TITLE             (in)  PLOTS.10704
     *                 pnum,             ! indicates what overlay this is  (in)  PLOTS.10705
     *                 errsev            ! error severity comparitor       (in)  PLOTS.10706
      integer          lputl,            ! for common block QLBDET               PLOTS.10707
     *                 tputl             ! for common block QLBDET               PLOTS.10708
      integer          pcol              ! for common block PERCOL               PLOTS.10709
                                                                                 PLOTS.10710
C  Logical variables                                                             PLOTS.10711
                                                                                 PLOTS.10712
      logical          hputl             ! for common block QLBDET               PLOTS.10713
      logical          prput             ! for common block PERDET               PLOTS.10714
      logical          noplt             ! for common block NOPLOT               PLOTS.10715
                                                                                 PLOTS.10716
C  Real variables                                                                PLOTS.10717
                                                                                 PLOTS.10718
      real             scale             ! scale factor to use             (in)  PLOTS.10719
                                                                                 PLOTS.10720
C  Common blocks                                                                 PLOTS.10721
                                                                                 PLOTS.10722
      common /qlbdet/  hputl,            ! draw in high/low labels ?             PLOTS.10723
     *                 lputl,            ! draw in line labels                   PLOTS.10724
     *                 tputl             ! draw in the title                     PLOTS.10725
      common /perdet/  prput             ! put in a perimeter ?                  PLOTS.10726
      common /percol/  pcol              ! color index for perimeter             PLOTS.10727
      common /noplot/  noplt             ! has a non-correctable erro occured ?  PLOTS.10728
                                                                                 PLOTS.10729
C****************************  Subroutine Begin  *****************************C  PLOTS.10730
                                                                                 PLOTS.10731
C  CONPACK internal parameters used in this routine are :                        PLOTS.10732
C  LBC - Label Box fill Color index                                              PLOTS.10733
C  HLT - High/Low label Text                                                     PLOTS.10734
C  LLP - Line Label Positioning flag                                             PLOTS.10735
C  ILT - Information Label Text                                                  PLOTS.10736
                                                                                 PLOTS.10737
C  Set up the title information, if no plot will be drawn or a title is          PLOTS.10738
C  requested                                                                     PLOTS.10739
                                                                                 PLOTS.10740
      if ((noplt) .or. ((tputl .eq. 1) .and. (tsize .ne. 0))) then               PLOTS.10741
        call setttl (tsize,title,pnum,scale)                                     PLOTS.10742
      else                                                                       PLOTS.10743
        call cpsetc ('ILT',' ')                                                  PLOTS.10744
      end if                                                                     PLOTS.10745
                                                                                 PLOTS.10746
C  If there should be no plot drawn, don't bother with setting up the colors     PLOTS.10747
                                                                                 PLOTS.10748
      if (.not. noplt) then                                                      PLOTS.10749
                                                                                 PLOTS.10750
C  Tell CONPACK to use the current fill color index to fill all types            PLOTS.10751
C  of label boxes                                                                PLOTS.10752
                                                                                 PLOTS.10753
        call cpseti ('LBC',-1)                                                   PLOTS.10754
                                                                                 PLOTS.10755
C  Set up the high/low information, if a plot will be drawn and they             PLOTS.10756
C  are requested                                                                 PLOTS.10757
                                                                                 PLOTS.10758
        if (hputl) then                                                          PLOTS.10759
          call sethlo                                                            PLOTS.10760
        else                                                                     PLOTS.10761
          call cpsetc ('HLT',' '' ')                                             PLOTS.10762
        end if                                                                   PLOTS.10763
                                                                                 PLOTS.10764
C  Set up the color ramps requested by the user                                  PLOTS.10765
                                                                                 PLOTS.10766
        call cramps                                                              PLOTS.10767
                                                                                 PLOTS.10768
C  Set up the colors as they relate to individual lines                          PLOTS.10769
                                                                                 PLOTS.10770
        call setcol                                                              PLOTS.10771
                                                                                 PLOTS.10772
C  Set the color of the perimeter if a perimeter was requested                   PLOTS.10773
                                                                                 PLOTS.10774
        if (prput) call gacolr (pcol,pcol,pcol,pcol)                             PLOTS.10775
                                                                                 PLOTS.10776
C  Set up all the line label information, if line labels were requested          PLOTS.10777
                                                                                 PLOTS.10778
        if (lputl .ge. 0) then                                                   PLOTS.10779
          call setlab (lputl,errsev)                                             PLOTS.10780
        else                                                                     PLOTS.10781
          call cpseti ('LLP',0)                                                  PLOTS.10782
        end if                                                                   PLOTS.10783
      end if                                                                     PLOTS.10784
                                                                                 PLOTS.10785
C  If a label bar was requested, make it here                                    PLOTS.10786
                                                                                 PLOTS.10787
      if ((.not. noplt) .and. (tputl .eq. 0)) call mklbar                        PLOTS.10788
                                                                                 PLOTS.10789
C*****************************  Subroutine End  ******************************C  PLOTS.10790
                                                                                 PLOTS.10791
      return                                                                     PLOTS.10792
      end                                                                        PLOTS.10793
      subroutine csetwn (xstr,ystr,xend,yend,doset)                              PLOTS.10794
                                                                                 PLOTS.10795
C*****************************************************************************C  PLOTS.10796
C  csetwn   - This is a CONDRV routine                                        C  PLOTS.10797
C  Section  - Design                                                          C  PLOTS.10798
C  Purpose  - To set up the proper viewport in which to draw the contours.    C  PLOTS.10799
C                                                                             C  PLOTS.10800
C  On entry - XSTR, YSTR are the first point in the grid to be plotted.  XEND C  PLOTS.10801
C             and YEND are the last point in the  grid to be plotted.   These C  PLOTS.10802
C             two points should correspond to the lower left and  upper right C  PLOTS.10803
C             respecitvely, of a map on which the picture is overlayed. DOSET C  PLOTS.10804
C             is 1 if CONDRV should make a standard  set call and is 0 if  it C  PLOTS.10805
C             should use the users last call to the SPPS routine SET.  If DO- C  PLOTS.10806
C             set is negative CONDRV  makes the set call  considering a cross C  PLOTS.10807
C             point grid.                                                     C  PLOTS.10808
C                                                                             C  PLOTS.10809
C  On exit  - The proper window has been set.                                 C  PLOTS.10810
C                                                                             C  PLOTS.10811
C  Assume   - GKS is open                                                     C  PLOTS.10812
C                                                                             C  PLOTS.10813
C  Notes    - Routine Name        Location of Definition                      C  PLOTS.10814
C             ----------------------------------------------------------------C  PLOTS.10815
C             CPSETR              CONPACK utility*                            C  PLOTS.10816
C             CPSETI              CONPACK utility*                            C  PLOTS.10817
C             GETSET              SPPS*                                       C  PLOTS.10818
C             SET                 SPPS*                                       C  PLOTS.10819
C             ----------------------------------------------------------------C  PLOTS.10820
C             * NCAR Graphics routine                                         C  PLOTS.10821
C                                                                             C  PLOTS.10822
C  Author   - Jeremy Asbill      Date - August 9, 1990      for the MM4 club  C  PLOTS.10823
C*****************************************************************************C  PLOTS.10824
                                                                                 PLOTS.10825
C  Integer variables                                                             PLOTS.10826
                                                                                 PLOTS.10827
      integer          xstr,             ! x coord. of first grid point    (in)  PLOTS.10828
     *                 ystr,             ! y coord. of first grid point    (in)  PLOTS.10829
     *                 xend,             ! x coord. of last grid point     (in)  PLOTS.10830
     *                 yend,             ! y coord. of last grid point     (in)  PLOTS.10831
     *                 doset             ! set call type indicator         (in)  PLOTS.10832
      integer          lltp              ! junk filler                  (local)  PLOTS.10833
                                                                                 PLOTS.10834
C  Real variables                                                                PLOTS.10835
                                                                                 PLOTS.10836
      real             temp,             ! temporary test variable      (local)  PLOTS.10837
     *                 dumy,             ! dummy test variable          (local)  PLOTS.10838
     *                 right,            ! right side of view port      (local)  PLOTS.10839
     *                 left,             ! left side of view port       (local)  PLOTS.10840
     *                 top,              ! top of view port             (local)  PLOTS.10841
     *                 bottom,           ! bottom of view port          (local)  PLOTS.10842
     *                 test,             ! calculation variable         (local)  PLOTS.10843
     *                 junk,             ! calculation variable         (local)  PLOTS.10844
     *                 ultp,urtp,        ! junk filler                  (local)  PLOTS.10845
     *                 ubtp,uttp         ! junk filler                  (local)  PLOTS.10846
                                                                                 PLOTS.10847
C****************************  Subroutine Begin  *****************************C  PLOTS.10848
                                                                                 PLOTS.10849
C  CONPACK internal parameters used in this routine are:                         PLOTS.10850
C  VPB - View Port Bottom                                                        PLOTS.10851
C  VPT - View Port Top                                                           PLOTS.10852
C  VPL - View Port Left                                                          PLOTS.10853
C  VPR - View Port Right                                                         PLOTS.10854
C  SET - do-SET-call flag                                                        PLOTS.10855
                                                                                 PLOTS.10856
C  Se