      SUBROUTINE PRCPH2O(Q,PS,SIGMA,I1,J1,K1,PRH2O)                              PRCPH2O.1
C                                                                                PRCPH2O.2
C     SECTION  DIAGNOSTICS                                                       PRCPH2O.3
C     PURPOSE  COMPUTE THE AMOUNT OF AVAILABLE PRECIPTABLE                       PRCPH2O.4
C              WATER FROM THE MIXING RATIO                                       PRCPH2O.5
C                                                                                PRCPH2O.6
C                        P*    /                                                 PRCPH2O.7
C              PRH2O=  ------- | (QV DSIGMA )                                    PRCPH2O.8
C                      RHO * G /                                                 PRCPH2O.9
C                                                                                PRCPH2O.10
      DIMENSION Q(I1,J1,K1),  PS(I1,J1),  SIGMA(K1)                              PRCPH2O.11
      DIMENSION PRH2O(I1,J1)                                                     PRCPH2O.12
C                                                                                PRCPH2O.13
C     ... GET INTG(P* QV  DSIGMA) IN MB KG/KG                                    PRCPH2O.14
C                                                                                PRCPH2O.15
      CALL INTEGRAT(Q,I1,J1,K1,SIGMA,1,PRH2O)                                    PRCPH2O.16
      CALL COUPLE(PRH2O,PS,I1,J1, 1,1)                                           PRCPH2O.17
C                                                                                PRCPH2O.18
C     ... GET THE CONVERSION FACTORS FOR CM                                      PRCPH2O.19
C                                                                                PRCPH2O.20
      RHO=1000.      ! KG/M**3                                                   PRCPH2O.21
      G=9.8          ! M/S**2                                                    PRCPH2O.22
      PFACT=100.     ! 1 MB= 100 PA                                              PRCPH2O.23
      CMFACT=100.    ! 1 M=100 CM                                                PRCPH2O.24
      ALL=PFACT*CMFACT/(RHO*G)                                                   PRCPH2O.25
C                                                                                PRCPH2O.26
C     ... TURN KG OF H2O INTO CM                                                 PRCPH2O.27
C                                                                                PRCPH2O.28
      CALL SCALE(PRH2O,'MULT',ALL,I1,J1, 1,I1,J1,1)                              PRCPH2O.29
      RETURN                                                                     PRCPH2O.30
      END                                                                        PRCPH2O.31
