      SUBROUTINE PRESTEND(P1,P2,IMX,JMX,PTEND,ICRSDOT)                           PRESTEND.1
C                                                                                PRESTEND.2
C     SECTION  DIAGNOSTIC                                                        PRESTEND.3
C     PURPOSE  COMPUTES THE PRESSURE TENDENCY FROM THE INPUT                     PRESTEND.4
C              TWO 2D PRESSURE FIELDS                                            PRESTEND.5
C                                                                                PRESTEND.6
C     INPUT       P1       PRESSURE AT TIME 1         CROSS    2D                PRESTEND.7
C                 P2       PRESSURE AT TIME 2         CROSS    2D                PRESTEND.8
C                 IMX      DOT POINT DIMENSION N-S                               PRESTEND.9
C                 JMX      DOT POINT DIMENSION E-W                               PRESTEND.10
C                                                                                PRESTEND.11
C     OUTPUT      PTEND    DIFFERENCE P2-P1           CROSS    2D                PRESTEND.12
C                                                                                PRESTEND.13
      DIMENSION P1(IMX,JMX) ,P2(IMX,JMX)                                         PRESTEND.14
      DIMENSION PTEND(IMX,JMX)                                                   PRESTEND.15
C                                                                                PRESTEND.16
      DO 600 J=1,JMX-ICRSDOT                                                     PRESTEND.17
      DO 600 I=1,IMX-ICRSDOT                                                     PRESTEND.18
         PTEND(I,J)=P2(I,J)-P1(I,J)                                              PRESTEND.19
600   CONTINUE                                                                   PRESTEND.20
C                                                                                PRESTEND.21
      RETURN                                                                     PRESTEND.22
      END                                                                        PRESTEND.23
