      SUBROUTINE PVP( U,V,T,DMF,XMF,F,P,DS,I1,J1,K1,PV)                          PVP.1
C                                                                                PVP.2
#     include <scratch.incl>                                                     PVP.3
C                                                                                PVP.4
      INEED = 6*I1*J1 + I1*J1*(K1)                                               PVP.5
C                                                                                PVP.6
      IN1 = NTEMP                                                                PVP.7
      IN2 = IN1+I1*J1                                                            PVP.8
      IN3 = IN2+I1*J1                                                            PVP.9
      IN4 = IN3+I1*J1                                                            PVP.10
      IN5 = IN4+I1*J1                                                            PVP.11
      IN6 = IN5+I1*J1                                                            PVP.12
      IN7 = IN6+I1*J1                                                            PVP.13
C                                                                                PVP.14
      NTEMP = NTEMP+INEED                                                        PVP.15
      IF(NTEMP .GT. I_SCRATCH) CALL SPACE_STOP('PVP')                            PVP.16
      IF(VERBOSE) WRITE(6,*) ' CALLING PVP ',INEED,IN1,NTEMP                     PVP.17
        CALL PVP_0( U,V,T,DMF,XMF,F,P,DS,I1,J1,K1,PV,                            PVP.18
     *   SCR(IN1),SCR(IN2),SCR(IN3),SCR(IN4),SCR(IN5),                           PVP.19
     *   SCR(IN6),SCR(IN7) )                                                     PVP.20
C                                                                                PVP.21
      NTEMP = NTEMP - INEED                                                      PVP.22
      IF(VERBOSE) WRITE(6,*) ' RET FROM PVP ',NTEMP                              PVP.23
      RETURN                                                                     PVP.24
      END                                                                        PVP.25
C                                                                                PVP.26
C                                                                                PVP.27
      SUBROUTINE PVP_0( U,V,T,DMF,XMF,F,P,DS,I1,J1,K1,PV,                        PVP.28
     *                VOR,DUDP,DVDP,DTDX,DTDY,DTDP,PVHOLD )                      PVP.29
C                                                                                PVP.30
      DIMENSION U(I1,J1,K1), V(I1,J1,K1), T(I1,J1,K1),                           PVP.31
     *          DMF(I1,J1), XMF(I1,J1), F(I1,J1),                                PVP.32
     *          P(K1),                                                           PVP.33
     *          PV(I1,J1,K1)                                                     PVP.34
      DIMENSION VOR (I1,J1),                                                     PVP.35
     *          DUDP(I1,J1), DVDP(I1,J1),                                        PVP.36
     *          DTDX(I1,J1), DTDY(I1,J1),                                        PVP.37
     *          DTDP(I1,J1),                                                     PVP.38
     *          PVHOLD(I1,J1,K1)                                                 PVP.39
C                                                                                PVP.40
C     ... EVERYTHING IS BY SLABS                                                 PVP.41
C                                                                                PVP.42
      G=9.81                                                                     PVP.43
      SCALE=-1.E6                                                                PVP.44
C                                                                                PVP.45
      DO 5000 K=1,K1                                                             PVP.46
C                                                                                PVP.47
C        ... COMPUTE VERTICAL DERIVATIVES: DU/DP, DV/DP, DTHETA/DP               PVP.48
C                                                                                PVP.49
         IF(K.EQ.1) THEN                                                         PVP.50
            K0=K                                                                 PVP.51
            K2=K+1                                                               PVP.52
         ELSE IF(K.EQ.K1) THEN                                                   PVP.53
            K0=K-1                                                               PVP.54
            K2=K                                                                 PVP.55
         ELSE                                                                    PVP.56
            K0=K-1                                                               PVP.57
            K2=K+1                                                               PVP.58
         ENDIF                                                                   PVP.59
         DO 100 J=1,J1-1                                                         PVP.60
         DO 100 I=1,I1-1                                                         PVP.61
            DUDP(I,J)=(U(I+1,J+1,K0)-U(I+1,J+1,K2)  +                            PVP.62
     *                 U(I+1,J  ,K0)-U(I+1,J  ,K2)  +                            PVP.63
     *                 U(I  ,J+1,K0)-U(I  ,J+1,K2)  +                            PVP.64
     *                 U(I  ,J  ,K0)-U(I  ,J  ,K2)) *                            PVP.65
     *                 0.25 / (P(K0)-P(K2)) * XMF(I,J)                           PVP.66
            DVDP(I,J)=(V(I+1,J+1,K0)-V(I+1,J+1,K2)  +                            PVP.67
     *                 V(I+1,J  ,K0)-V(I+1,J  ,K2)  +                            PVP.68
     *                 V(I  ,J+1,K0)-V(I  ,J+1,K2)  +                            PVP.69
     *                 V(I  ,J  ,K0)-V(I  ,J  ,K2)) *                            PVP.70
     *                 0.25 / (P(K0)-P(K2)) * XMF(I,J)                           PVP.71
100      CONTINUE                                                                PVP.72
         DO 110 J=1,J1-1                                                         PVP.73
         DO 110 I=1,I1-1                                                         PVP.74
            T1=T(I,J,K0)*(1000./P(K0))**0.286                                    PVP.75
            T2=T(I,J,K2)*(1000./P(K2))**0.286                                    PVP.76
            DTDP(I,J)=(T1-T2)/(P(K0)-P(K2))                                      PVP.77
110      CONTINUE                                                                PVP.78
C                                                                                PVP.79
C        ... COMPUTE HORIZONTAL DERIVATIVES: DTHETA/DX, DTHETA/DY                PVP.80
C                                                                                PVP.81
         DS2R=1./(DS * 2.)                                                       PVP.82
         DO 400 J=2,J1-2                                                         PVP.83
         DO 400 I=2,I1-2                                                         PVP.84
            T1=T(I+1,J  ,K)*(1000./P(K))**0.286                                  PVP.85
            T2=T(I-1,J  ,K)*(1000./P(K))**0.286                                  PVP.86
            T3=T(I  ,J+1,K)*(1000./P(K))**0.286                                  PVP.87
            T4=T(I  ,J-1,K)*(1000./P(K))**0.286                                  PVP.88
            DTDY(I,J)=(T1 - T2)*DS2R                                             PVP.89
            DTDX(I,J)=(T3 - T4)*DS2R                                             PVP.90
400      CONTINUE                                                                PVP.91
         CALL FILLIT(DTDX,I1,J1,1,I1,J1,2,I1-2,2,J1-2)                           PVP.92
         CALL FILLIT(DTDY,I1,J1,1,I1,J1,2,I1-2,2,J1-2)                           PVP.93
C                                                                                PVP.94
C        ... COMPUTE SLAB ABSOLUTE VORTICITY                                     PVP.95
C                                                                                PVP.96
         DO 500 J=1,J1-1                                                         PVP.97
         DO 500 I=1,I1-1                                                         PVP.98
            U1=U(I  ,J  ,K)/DMF(I  ,J  )                                         PVP.99
            U2=U(I+1,J  ,K)/DMF(I+1,J  )                                         PVP.100
            U3=U(I  ,J+1,K)/DMF(I  ,J+1)                                         PVP.101
            U4=U(I+1,J+1,K)/DMF(I+1,J+1)                                         PVP.102
            V1=V(I  ,J  ,K)/DMF(I  ,J  )                                         PVP.103
            V2=V(I+1,J  ,K)/DMF(I+1,J  )                                         PVP.104
            V3=V(I  ,J+1,K)/DMF(I  ,J+1)                                         PVP.105
            V4=V(I+1,J+1,K)/DMF(I+1,J+1)                                         PVP.106
            FX=(F(I,J)+F(I+1,J)+F(I,J+1)+F(I+1,J+1))*0.25                        PVP.107
            VOR(I,J)=XMF(I,J)**2 * DS2R*((V4-V2+V3-V1)-(U2-U1+U4-U3))            PVP.108
     *               + FX                                                        PVP.109
500      CONTINUE                                                                PVP.110
C                                                                                PVP.111
C        ... GROUP TERMS                                                         PVP.112
C                                                                                PVP.113
         DO 600 J=1,J1-1                                                         PVP.114
         DO 600 I=1,I1-1                                                         PVP.115
            PVHOLD(I,J,K)=G * SCALE /  100. *                                    PVP.116
     *       (  VOR (I,J) * DTDP(I,J) -                                          PVP.117
     *          DVDP(I,J) * DTDX(I,J) + DUDP(I,J) * DTDY(I,J)  )                 PVP.118
600      CONTINUE                                                                PVP.119
5000  CONTINUE                                                                   PVP.120
C                                                                                PVP.121
      DO 5100 K=1,K1                                                             PVP.122
      DO 5100 J=1,J1-1                                                           PVP.123
      DO 5100 I=1,I1-1                                                           PVP.124
         PV(I,J,K)=PVHOLD(I,J,K)                                                 PVP.125
5100  CONTINUE                                                                   PVP.126
C                                                                                PVP.127
      RETURN                                                                     PVP.128
      END                                                                        PVP.129
