      SUBROUTINE PVS( U,V,T,PP,DMF,XMF,F,PS,SIGMA,PTOP,DS,I1,J1,K1,PV)           PVS.1
C                                                                                PVS.2
#     include <scratch.incl>                                                     PVS.3
C                                                                                PVS.4
      INEED = 6*I1*J1 + I1*J1*(K1)                                               PVS.5
C                                                                                PVS.6
      IN1 = NTEMP                                                                PVS.7
      IN2 = IN1+I1*J1                                                            PVS.8
      IN3 = IN2+I1*J1                                                            PVS.9
      IN4 = IN3+I1*J1                                                            PVS.10
      IN5 = IN4+I1*J1                                                            PVS.11
      IN6 = IN5+I1*J1                                                            PVS.12
      IN7 = IN6+I1*J1                                                            PVS.13
C                                                                                PVS.14
      NTEMP = NTEMP+INEED                                                        PVS.15
      IF(NTEMP .GT. I_SCRATCH) CALL SPACE_STOP('PVS')                            PVS.16
      IF(VERBOSE) WRITE(6,*) ' CALLING PVS ',INEED,IN1,NTEMP                     PVS.17
        CALL PVS_0( U,V,T,PP,DMF,XMF,F,PS,SIGMA,PTOP,DS,I1,J1,K1,PV,             PVS.18
     *   SCR(IN1),SCR(IN2),SCR(IN3),SCR(IN4),SCR(IN5),                           PVS.19
     *   SCR(IN6),SCR(IN7) )                                                     PVS.20
C                                                                                PVS.21
      NTEMP = NTEMP - INEED                                                      PVS.22
      IF(VERBOSE) WRITE(6,*) ' RET FROM PVS ',NTEMP                              PVS.23
      RETURN                                                                     PVS.24
      END                                                                        PVS.25
C                                                                                PVS.26
      SUBROUTINE PVS_0( U,V,T,PP,DMF,XMF,F,PS,SIGMA,PTOP,                        PVS.27
     *                DS,I1,J1,K1,PV,                                            PVS.28
     *                VOR,DUDS,DVDS,DTDX,DTDY,DTDS,PVHOLD )                      PVS.29
C                                                                                PVS.30
      DIMENSION U(I1,J1,K1), V(I1,J1,K1), T(I1,J1,K1),                           PVS.31
     *          DMF(I1,J1), XMF(I1,J1), F(I1,J1), PS(I1,J1),                     PVS.32
     *          SIGMA(K1),PP(I1,J1,K1),                                          PVS.33
     *          PV(I1,J1,K1)                                                     PVS.34
      DIMENSION VOR (I1,J1),                                                     PVS.35
     *          DUDS(I1,J1), DVDS(I1,J1),                                        PVS.36
     *          DTDX(I1,J1), DTDY(I1,J1),                                        PVS.37
     *          DTDS(I1,J1),                                                     PVS.38
     *          PVHOLD(I1,J1,K1)                                                 PVS.39
C                                                                                PVS.40
C     ... EVERYTHING IS BY SLABS                                                 PVS.41
C                                                                                PVS.42
      G=9.81                                                                     PVS.43
      SCALE=-1.E6                                                                PVS.44
C                                                                                PVS.45
      DO 5000 K=1,K1                                                             PVS.46
C                                                                                PVS.47
C        ... COMPUTE VERTICAL DERIVATIVES: DU/DS, DV/DS, DTHETA/DS               PVS.48
C                                                                                PVS.49
         IF(K.EQ.1) THEN                                                         PVS.50
            K0=K                                                                 PVS.51
            K2=K+1                                                               PVS.52
         ELSE IF(K.EQ.K1) THEN                                                   PVS.53
            K0=K-1                                                               PVS.54
            K2=K                                                                 PVS.55
         ELSE                                                                    PVS.56
            K0=K-1                                                               PVS.57
            K2=K+1                                                               PVS.58
         ENDIF                                                                   PVS.59
         DO 100 J=1,J1-1                                                         PVS.60
         DO 100 I=1,I1-1                                                         PVS.61
            DPR=PS(I,J)*(SIGMA(K0)-SIGMA(K2))+(PP(I,J,K0)-PP(I,J,K2))            PVS.62
            DUDS(I,J)=(U(I+1,J+1,K0)-U(I+1,J+1,K2)  +                            PVS.63
     *                 U(I+1,J  ,K0)-U(I+1,J  ,K2)  +                            PVS.64
     *                 U(I  ,J+1,K0)-U(I  ,J+1,K2)  +                            PVS.65
     *                 U(I  ,J  ,K0)-U(I  ,J  ,K2)) *                            PVS.66
     *               0.25 / DPR * XMF(I,J)                                       PVS.67
            DVDS(I,J)=(V(I+1,J+1,K0)-V(I+1,J+1,K2)  +                            PVS.68
     *                 V(I+1,J  ,K0)-V(I+1,J  ,K2)  +                            PVS.69
     *                 V(I  ,J+1,K0)-V(I  ,J+1,K2)  +                            PVS.70
     *                 V(I  ,J  ,K0)-V(I  ,J  ,K2)) *                            PVS.71
     *               0.25 / DPR * XMF(I,J)                                       PVS.72
100      CONTINUE                                                                PVS.73
         DO 110 J=1,J1-1                                                         PVS.74
         DO 110 I=1,I1-1                                                         PVS.75
            T1=T(I,J,K0)                                                         PVS.76
            T2=T(I,J,K2)                                                         PVS.77
            DPR=PS(I,J)*(SIGMA(K0)-SIGMA(K2))+(PP(I,J,K0)-PP(I,J,K2))            PVS.78
            DTDS(I,J)=(T1-T2)/DPR                                                PVS.79
110      CONTINUE                                                                PVS.80
C                                                                                PVS.81
C        ... COMPUTE HORIZONTAL DERIVATIVES: DTHETA/DX, DTHETA/DY                PVS.82
C                                                                                PVS.83
         DS2R=1./(DS * 2.)                                                       PVS.84
         DO 400 J=2,J1-2                                                         PVS.85
         DO 400 I=2,I1-2                                                         PVS.86
            T1=T(I+1,J  ,K)                                                      PVS.87
            T2=T(I-1,J  ,K)                                                      PVS.88
            T3=T(I  ,J+1,K)                                                      PVS.89
            T4=T(I  ,J-1,K)                                                      PVS.90
            DTDY(I,J)=(T1 - T2)*DS2R                                             PVS.91
            DTDX(I,J)=(T3 - T4)*DS2R                                             PVS.92
400      CONTINUE                                                                PVS.93
         CALL FILLIT(DTDX,I1,J1,1,I1,J1,2,I1-2,2,J1-2)                           PVS.94
         CALL FILLIT(DTDY,I1,J1,1,I1,J1,2,I1-2,2,J1-2)                           PVS.95
C                                                                                PVS.96
C        ... COMPUTE SLAB ABSOLUTE VORTICITY                                     PVS.97
C                                                                                PVS.98
         DO 500 J=1,J1-1                                                         PVS.99
         DO 500 I=1,I1-1                                                         PVS.100
            U1=U(I  ,J  ,K)/DMF(I  ,J  )                                         PVS.101
            U2=U(I+1,J  ,K)/DMF(I+1,J  )                                         PVS.102
            U3=U(I  ,J+1,K)/DMF(I  ,J+1)                                         PVS.103
            U4=U(I+1,J+1,K)/DMF(I+1,J+1)                                         PVS.104
            V1=V(I  ,J  ,K)/DMF(I  ,J  )                                         PVS.105
            V2=V(I+1,J  ,K)/DMF(I+1,J  )                                         PVS.106
            V3=V(I  ,J+1,K)/DMF(I  ,J+1)                                         PVS.107
            V4=V(I+1,J+1,K)/DMF(I+1,J+1)                                         PVS.108
            FX=(F(I,J)+F(I+1,J)+F(I,J+1)+F(I+1,J+1))*0.25                        PVS.109
            VOR(I,J)=XMF(I,J)**2 * DS2R*((V4-V2+V3-V1)-(U2-U1+U4-U3))            PVS.110
     *               + FX                                                        PVS.111
500      CONTINUE                                                                PVS.112
C                                                                                PVS.113
C        ... GROUP TERMS                                                         PVS.114
C                                                                                PVS.115
         DO 600 J=1,J1-1                                                         PVS.116
         DO 600 I=1,I1-1                                                         PVS.117
            PVHOLD(I,J,K)=G * SCALE / 100. *                                     PVS.118
     *       (  VOR (I,J) * DTDS(I,J) -                                          PVS.119
     *          DVDS(I,J) * DTDX(I,J) + DUDS(I,J) * DTDY(I,J)  )                 PVS.120
600      CONTINUE                                                                PVS.121
5000  CONTINUE                                                                   PVS.122
C                                                                                PVS.123
      DO 5100 K=1,K1                                                             PVS.124
      DO 5100 J=1,J1-1                                                           PVS.125
      DO 5100 I=1,I1-1                                                           PVS.126
         PV(I,J,K)=PVHOLD(I,J,K)                                                 PVS.127
5100  CONTINUE                                                                   PVS.128
C                                                                                PVS.129
      RETURN                                                                     PVS.130
      END                                                                        PVS.131
