      SUBROUTINE QTORH(Q,T,PP,SIGH,PS,PTOP,IMX,JMX,KX,                           QTORH.1
     *                 RH)                                                       QTORH.2
C                                                                                QTORH.3
C     SECTION  DIAGNOSTIC                                                        QTORH.4
C     PURPOSE  COMPUTES THE RELATIVE HUMIDITY FROM THE 3D TEMPERATURE,           QTORH.5
C              MIXING RATIO, SIGMA LEVEL AND P STAR.                             QTORH.6
C              THIS IS COMPUTED ON SIGMA SURFACES                                QTORH.7
C                                                                                QTORH.8
C     INPUT       Q        MIXING RATIO               CROSS    3D                QTORH.9
C                 T        T                          CROSS    3D                QTORH.10
C                 PP       P PERTURBATION              CROSS     3D              QTORH.11
C                 SIGH     SIGMA LEVELS                        1D                QTORH.12
C                 PS       P SURFACE - P TOP          CROSS    2D                QTORH.13
C                 PTOP     PRESSURE AT MODEL TOP                                 QTORH.14
C                 IMX      DOT POINT DIMENSION N-S                               QTORH.15
C                 JMX      DOT POINT DIMENSION E-W                               QTORH.16
C                 KX       NUMBER OF VERTICAL LEVELS                             QTORH.17
C                                                                                QTORH.18
C     OUTPUT      RH       RELATIVE HUMIDITY          CROSS    3D                QTORH.19
C                                                                                QTORH.20
      DIMENSION Q(IMX,JMX,KX) ,T(IMX,JMX,KX) ,SIGH(KX),                          QTORH.21
     *          PP(IMX,JMX,KX),PS(IMX,JMX)                                       QTORH.22
      DIMENSION RH(IMX,JMX,KX)                                                   QTORH.23
C                                                                                QTORH.24
      PARAMETER (eps         =     0.622 )                                       05DEC01.129
      PARAMETER (svp1        =     0.6112 )                                      05DEC01.130
      PARAMETER (svp2        =    17.67 )                                        05DEC01.131
      PARAMETER (svp3        =    29.65 )                                        05DEC01.132
      PARAMETER (svpt0       =   273.15 )                                        05DEC01.133
      CONST1 = (18.016*2.5E10)/(8.3144E7*273.16)                                 QTORH.25
      CONST2 = (18.016*2.5E10)/ 8.3144E7                                         QTORH.26
C                                                                                QTORH.27
C     ... RELATIVE HUMIDITY ON SIGMA SURFACES                                    QTORH.28
C                                                                                QTORH.29
      DO 600 K=1,KX                                                              QTORH.30
      DO 600 J=1,JMX-1                                                           QTORH.31
      DO 600 I=1,IMX-1                                                           QTORH.32
!        ES=6.11*EXP(CONST1-CONST2/T(I,J,K))                                     05DEC01.134
!        QS=0.622*ES/(SIGH(K)*PS(I,J)+PTOP+PP(I,J,K)-ES)                         05DEC01.135
!        RH(I,J,K)=100.*Q(I,J,K)/QS                                              05DEC01.136
         es = svp1*10.*EXP(svp2*(t(i,j,k)-svpt0)/(t(i,j,k)-svp3))                05DEC01.137
         qs=eps*es/(sigh(k)*ps(i,j)+ptop+pp(i,j,k)-(1.-eps)*es)                  05DEC01.138
         rh(i,j,k) = MIN ( 100. , MAX ( 100.*q(i,j,k)/qs , 10. ) )               05DEC01.139
600   CONTINUE                                                                   QTORH.36
      RETURN                                                                     QTORH.37
      END                                                                        QTORH.38
