      SUBROUTINE QVECTR(H,F,XMF,DMF,P,I1,J1,K1,DS,U,V)                           QVECTR.1
C                                                                                QVECTR.2
C SUBROUTINE TO CALCULATE Q VECTORS ON A GIVEN PRESSURE SURFACE                  QVECTR.3
C                                                                                QVECTR.4
      REAL KAPPA                                                                 QVECTR.5
      PARAMETER (G = 9.806, KAPPA = 287.054/1004.)                               QVECTR.6
      DIMENSION H(I1,J1,K1), U(I1,J1,K1), V(I1,J1,K1),                           QVECTR.7
     &  F(I1,J1), XMF(I1,J1), DMF(I1,J1), P(K1)                                  QVECTR.8
C SEARCH FOR THE PRESSURE FIELD TO PLOT                                          QVECTR.9
      DO 5 K = 2, K1                                                             QVECTR.10
C FILTER THE GEOPOTENTIAL HEIGHT FIELD                                           QVECTR.11
        DO 11 J = 3, J1-3                                                        QVECTR.12
          DO 11 I = 3, I1-3                                                      QVECTR.13
          XMF(I,J) = H(I,J,K) + 0.125*(H(I+1,J,K)+H(I-1,J,K)+H(I,J+1,K)          QVECTR.14
     &           +H(I,J-1,K) - 4.*H(I,J,K))+(1./16.)*(H(I-1,J-1,K)               QVECTR.15
     &           +H(I-1,J+1,K)+H(I+1,J-1,K)+H(I+1,J+1,K)-4.*H(I,J,K))            QVECTR.16
     &           +(1./64.)*(H(I-2,J,K)+H(I+2,J,K)+H(I,J-2,K)+H(I,J+2,K)          QVECTR.17
     &           -4.*H(I,J,K))                                                   QVECTR.18
   11   CONTINUE                                                                 QVECTR.19
C STORE THE SMOOTHED GEOPOTENTIAL HEIGHT FIELD BACK IN ARRAY LEVEL K             QVECTR.20
        DO 12 J = 3, J1-3                                                        QVECTR.21
          DO 12 I = 3, I1-3                                                      QVECTR.22
            H(I,J,K) = XMF(I,J)                                                  QVECTR.23
   12   CONTINUE                                                                 QVECTR.24
C GET THE POTENTIAL TEMPERATURE, FILTER IT AND PUT IN XMF                        QVECTR.25
        DO 15 J = 1, J1-1                                                        QVECTR.26
          DO 15 I = 1, I1-1                                                      QVECTR.27
            U(I,J,K1) = V(I,J,K) *(1000./P(K))**KAPPA                            QVECTR.28
   15   CONTINUE                                                                 QVECTR.29
        DO 16 J = 3, J1-3                                                        QVECTR.30
          DO 16 I = 3, I1-3                                                      QVECTR.31
            XMF(I,J) = U(I,J,K1) +                                               QVECTR.32
     &               0.125*(U(I+1,J,K1)+U(I-1,J,K1)+U(I,J+1,K1)                  QVECTR.33
     &       +U(I,J-1,K1) -4.*U(I,J,K1))+(1./16.)*(U(I-1,J-1,K1)                 QVECTR.34
     &       +U(I-1,J+1,K1)+U(I+1,J-1,K1)+U(I+1,J+1,K1)-4.*U(I,J,K1))            QVECTR.35
     &       +(1./64.)*(U(I-2,J,K1)+U(I+2,J,K1)+U(I,J-2,K1)+U(I,J+2,K1)          QVECTR.36
     &       -4.*U(I,J,K1))                                                      QVECTR.37
   16   CONTINUE                                                                 QVECTR.38
        DO 17 I = 3, I1-1                                                        QVECTR.39
          XMF(I,1) = U(I,1,K1)                                                   QVECTR.40
          XMF(I,2) = U(I,2,K1)                                                   QVECTR.41
          XMF(I,J1-2) = U(I,J1-2,K1)                                             QVECTR.42
          XMF(I,J1-1) = U(I,J1-1,K1)                                             QVECTR.43
   17   CONTINUE                                                                 QVECTR.44
        DO 18 J = 1, J1-1                                                        QVECTR.45
          XMF(1,J) = U(1,J,K1)                                                   QVECTR.46
          XMF(2,J) = U(2,J,K1)                                                   QVECTR.47
          XMF(I1-2,J) = U(I1-2,J,K1)                                             QVECTR.48
          XMF(I1-1,J) = U(I1-1,J,K1)                                             QVECTR.49
   18   CONTINUE                                                                 QVECTR.50
C GET THE GEOSTROPHIC WIND ON THE DOT POINTS                                     QVECTR.51
        IF(DS.LT.1000.) THEN                                                     QVECTR.52
           DS2R=1./(2.*DS*1000.)                                                 QVECTR.53
        ELSE                                                                     QVECTR.54
           DS2R=1./(2.*DS)                                                       QVECTR.55
        END IF                                                                   QVECTR.56
        DO 20 J=2,J1-1                                                           QVECTR.57
          DO 20 I=2,I1-1                                                         QVECTR.58
            H1=H(I-1,J-1,K)                                                      QVECTR.59
            H2=H(I  ,J-1,K)                                                      QVECTR.60
            H3=H(I-1,J  ,K)                                                      QVECTR.61
            H4=H(I  ,J  ,K)                                                      QVECTR.62
            U(I,J,K)= -1.*G*DMF(I,J)/F(I,J)*DS2R*(H4-H3+H2-H1)                   QVECTR.63
            V(I,J,K)=     G*DMF(I,J)/F(I,J)*DS2R*(H4-H2+H3-H1)                   QVECTR.64
   20   CONTINUE                                                                 QVECTR.65
C                                                                                QVECTR.66
        CALL FILLIT(U,I1,J1,K,I1,J1,2,I1-1,2,J1-1)                               QVECTR.67
        CALL FILLIT(V,I1,J1,K,I1,J1,2,I1-1,2,J1-1)                               QVECTR.68
C CALCULATE THE Q VECTOR COMPONENTS AND STORE IN THE SURFACE LOCATION            QVECTR.69
C OF THE U AND V ARRAYS                                                          QVECTR.70
        DO 30 J = 2, J1-2                                                        QVECTR.71
          DO 30 I = 2, I1-2                                                      QVECTR.72
            T1 = XMF(I-1,J-1)                                                    QVECTR.73
            T2 = XMF(I  ,J-1)                                                    QVECTR.74
            T3 = XMF(I-1,J  )                                                    QVECTR.75
            T4 = XMF(I  ,J  )                                                    QVECTR.76
            U(I,J,1) = -1.*((U(I,J+1,K)-U(I,J-1,K))*DS2R)*                       QVECTR.77
C    &               ((XMF(I,J+1)-XMF(I,J-1))*DS2R)                              QVECTR.78
     &               ((T4-T2+T3-T1)*DS2R)                                        QVECTR.79
     &              -(((V(I,J+1,K)-V(I,J-1,K))*DS2R)*                            QVECTR.80
C    &               ((XMF(I-1,J)-XMF(I+1,J))*DS2R))                             QVECTR.81
     &               ((T4-T3+T2-T1)*DS2R))                                       QVECTR.82
            V(I,J,1) = -1.*((U(I+1,J,K)-U(I-1,J,K))*DS2R)*                       QVECTR.83
C    &               ((XMF(I,J+1)-XMF(I,J-1))*DS2R)                              QVECTR.84
     &               ((T4-T2+T3-T1)*DS2R)                                        QVECTR.85
     &              -(((V(I+1,J,K)-V(I-1,J,K))*DS2R)*                            QVECTR.86
C    &               ((XMF(I-1,J)-XMF(I+1,J))*DS2R))                             QVECTR.87
     &               ((T4-T3+T2-T1)*DS2R))                                       QVECTR.88
   30   CONTINUE                                                                 QVECTR.89
        CALL FILLIT(U,I1,J1,1,I1,J1,2,I1-2,2,J1-2)                               QVECTR.90
        CALL FILLIT(V,I1,J1,1,I1,J1,2,I1-2,2,J1-2)                               QVECTR.91
C NOW PUT THE COMPONENTS BACK INTO THEIR RIGHTFUL PLACE                          QVECTR.92
        DO 40 J = 1, J1                                                          QVECTR.93
          DO 40 I = 1, I1                                                        QVECTR.94
            U(I,J,K) = U(I,J,1)                                                  QVECTR.95
            V(I,J,K) = V(I,J,1)                                                  QVECTR.96
   40   CONTINUE                                                                 QVECTR.97
    5 CONTINUE                                                                   QVECTR.98
C PUT ZEROS IN THE SURFACE LOCATION                                              QVECTR.99
      DO 50 J = 1, J1                                                            QVECTR.100
        DO 50 I = 1, I1                                                          QVECTR.101
          U(I,J,1) = 0.                                                          QVECTR.102
          V(I,J,1) = 0.                                                          QVECTR.103
   50 CONTINUE                                                                   QVECTR.104
      RETURN                                                                     QVECTR.105
      END                                                                        QVECTR.106
