        SUBROUTINE SCALER (XPA,YPA,XPB,YPB,DS,PTOP,                              SCALER.1
     *  IJDIM,KDIM,UV,OMG,XMAXUV,XMAXOMG)                                        SCALER.2
C                                                                                SCALER.3
C THIS SUBROUTINE RECTIFIES AND NORMALIZES WIND VECTOR MAGNITUDES AND FI         SCALER.4
C  THE HORIZONTAL AND VERTICAL MAXIMUMS.                                         SCALER.5
C                                                                                SCALER.6
        REAL UV(IJDIM, KDIM), OMG(IJDIM, KDIM)                                   SCALER.7
                                                                                 SCALER.8
C                                                                                SCALER.9
C DETERMINE GRID AND ADJUST VERTICAL SCALE TO ACCOUNT FOR VERICAL STRETC         SCALER.10
C  ADJUST VERTICAL SCALE TO ACCOUNT FOR INCONSISTENT UNITS; MB/S VS M/S.         SCALER.11
C THE CORRESPONDING PRESSURE DIFFERENCE IS 1000MB-PTOPMB.                        SCALER.12
C                                                                                SCALER.13
        GRID = SQRT((XPB-XPA)**2 + (YPB-YPA)**2)                                 SCALER.14
        VSCALE = (GRID*DS)/(1000-PTOP)                                           SCALER.15
                                                                                 SCALER.16
C                                                                                SCALER.17
C ADJUST HORIZONTAL SCALE TO ACCOUNT FOR 6IN X 6.5IN RECTANGULAR DOMAIN.         SCALER.18
C                                                                                SCALER.19
        HSCALE = 5./4.75                                                         SCALER.20
C                                                                                SCALER.21
C DETERMINE THE LARGEST WIND VELOCITIES IN BOTH THE VERTICAL AND HORIZON         SCALER.22
C  DIRECTIONS.                                                                   SCALER.23
C                                                                                SCALER.24
        XMAXUV = 0.                                                              SCALER.25
        XMAXOMG = 0.                                                             SCALER.26
        DO 30 I=1,IJDIM                                                          SCALER.27
        DO 30 J=1,KDIM                                                           SCALER.28
           XMAXOMG=AMAX1(XMAXOMG,ABS(OMG(I,J)))                                  SCALER.29
           XMAXUV =AMAX1(XMAXUV ,ABS(UV (I,J)))                                  SCALER.30
   30   CONTINUE                                                                 SCALER.31
C                                                                                SCALER.32
C MULTIPLY HORIZONTAL AND VERTICAL WIND VELOCITY MAGNITUDES BY THE APPRO         SCALER.33
C  SCALING FACTORS.                                                              SCALER.34
C                                                                                SCALER.35
        DO 20 I=1,IJDIM                                                          SCALER.36
        DO 20 J=1,KDIM                                                           SCALER.37
           UV (I,J) = UV (I,J)*HSCALE                                            SCALER.38
           OMG(I,J) = OMG(I,J)*VSCALE                                            SCALER.39
   20   CONTINUE                                                                 SCALER.40
C                                                                                SCALER.41
        RETURN                                                                   SCALER.42
        END                                                                      SCALER.43
