      SUBROUTINE SCALERS(XPA,YPA,XPB,YPB,DS,PTOP,VSCALE0,                        SCALERS.1
     *  IJDIM,KDIM,UV,W,XMAXUV,XMAXW)                                            SCALERS.2
C                                                                                SCALERS.3
C THIS SUBROUTINE RECTIFIES AND NORMALIZES WIND VECTOR MAGNITUDES AND FI         SCALERS.4
C  THE HORIZONTAL AND VERTICAL MAXIMUMS.                                         SCALERS.5
C                                                                                SCALERS.6
        REAL UV(IJDIM, KDIM), W(IJDIM, KDIM)                                     SCALERS.7
                                                                                 SCALERS.8
C                                                                                SCALERS.9
C DETERMINE GRID AND ADJUST VERTICAL SCALE TO ACCOUNT FOR VERICAL STRETC         SCALERS.10
C THE CORRESPONDING PRESSURE DIFFERENCE IS 1000MB-PTOPMB.                        SCALERS.11
C                                                                                SCALERS.12
        GRID = SQRT((XPB-XPA)**2 + (YPB-YPA)**2)                                 SCALERS.13
        HEIGHT=45300. - 6341. * ALOG(PTOP)                                       SCALERS.14
        VSCALE = (GRID*DS)/HEIGHT                                                SCALERS.15
                                                                                 SCALERS.16
C                                                                                SCALERS.17
C ADJUST HORIZONTAL SCALE TO ACCOUNT FOR RECTANGULAR DOMAIN.                     SCALERS.18
C                                                                                SCALERS.19
        HSCALE = 5./4.75                                                         SCALERS.20
C                                                                                SCALERS.21
C DETERMINE THE LARGEST WIND VELOCITIES IN BOTH THE VERTICAL AND HORIZON         SCALERS.22
C  DIRECTIONS.                                                                   SCALERS.23
C                                                                                SCALERS.24
        XMAXUV = 0.                                                              SCALERS.25
        XMAXW = 0.                                                               SCALERS.26
        DO 30 I=1,IJDIM                                                          SCALERS.27
        DO 30 J=1,KDIM                                                           SCALERS.28
           XMAXW=AMAX1(XMAXW,ABS(W(I,J)))                                        SCALERS.29
           XMAXUV =AMAX1(XMAXUV ,ABS(UV (I,J)))                                  SCALERS.30
   30   CONTINUE                                                                 SCALERS.31
C  .. IN CASE OF VERTICAL MOTION TOO WEAK OR HRIZONTAL  DISTANCE                 SCALERS.32
C     TOO SHORT, SET A DEFAULT VALUE OF VSCALE TO ENLARGE THE                    SCALERS.33
C     VERTICAL CIRCULATION PLOTS.                                                SCALERS.34
         IF (VSCALE.LT.VSCALE0) VSCALE=VSCALE0                                   SCALERS.35
C                                                                                SCALERS.36
C MULTIPLY HORIZONTAL AND VERTICAL WIND VELOCITY MAGNITUDES BY THE APPRO         SCALERS.37
C  SCALING FACTORS.                                                              SCALERS.38
C                                                                                SCALERS.39
        DO 20 I=1,IJDIM                                                          SCALERS.40
        DO 20 J=1,KDIM                                                           SCALERS.41
           UV (I,J) = UV (I,J)*HSCALE                                            SCALERS.42
           W(I,J) = W(I,J)*VSCALE                                                SCALERS.43
   20   CONTINUE                                                                 SCALERS.44
C                                                                                SCALERS.45
        RETURN                                                                   SCALERS.46
        END                                                                      SCALERS.47
