      SUBROUTINE SEAPRS(T,PP,TER,PS,SFP,SIG,IMX,JMX,KX,PTOP,                     SEAPRS.1
     * SLP )                                                                     SEAPRS.2
C                                                                                SEAPRS.3
#     include <scratch.incl>                                                     SEAPRS.4
C                                                                                SEAPRS.5
      INEED = 4*IMX*JMX                                                          SEAPRS.6
C                                                                                SEAPRS.7
      IN1 = NTEMP                                                                SEAPRS.8
      IN2 = IN1+IMX*JMX                                                          SEAPRS.9
      IN3 = IN2+IMX*JMX                                                          SEAPRS.10
      IN4 = IN3+IMX*JMX                                                          SEAPRS.11
C                                                                                SEAPRS.12
      NTEMP = NTEMP+INEED                                                        SEAPRS.13
      IF(NTEMP .GT. I_SCRATCH) CALL SPACE_STOP('SEAPRS')                         SEAPRS.14
      IF(VERBOSE) WRITE(6,*) ' CALLING SEAPRS ',INEED,IN1,NTEMP                  SEAPRS.15
        CALL SEAPRS_0( T,PP,TER,PS,SFP,SIG,IMX,JMX,KX,PTOP,                      SEAPRS.16
     *                 SLP,                                                      SEAPRS.17
     *                 SCR(IN1),SCR(IN2),SCR(IN3),SCR(IN4)  )                    SEAPRS.18
C                                                                                SEAPRS.19
      NTEMP = NTEMP - INEED                                                      SEAPRS.20
      IF(VERBOSE) WRITE(6,*) ' RET FROM SEAPRS ',NTEMP                           SEAPRS.21
      RETURN                                                                     SEAPRS.22
      END                                                                        SEAPRS.23
C                                                                                SEAPRS.24
      SUBROUTINE SEAPRS_0(T,PP,TER,PS,SFP,SIG,IMX,JMX,KX,PTOP,                   SEAPRS.25
     * SLP, PL,T0,TS,XKLEV )                                                     SEAPRS.26
C                                                                                SEAPRS.27
C     SECTION  DIAGNOSTIC                                                        SEAPRS.28
C     PURPOSE  COMPUTES SEA LEVEL PRESSURE FROM THE RULE                         SEAPRS.29
C              T1/T2=(P1/P2)**(GAMMA*R/G).                                       SEAPRS.30
C                                                                                SEAPRS.31
C     INPUT       T        TEMPERATURE                CROSS    3D                SEAPRS.32
C                 TER      TERRAIN                    CROSS    2D                SEAPRS.33
C                 PS       P STAR = PSFC-PTOP         CROSS    2D                SEAPRS.34
C                 SFP      SURFACE PRESSURE           CROSS    2D                SEAPRS.35
C                 SIG      HALF SIGMA LEVELS                   1D                SEAPRS.36
C                 IMX      DOT POINT DIMENSION N-S                               SEAPRS.37
C                 JMX      DOT POINT DIMENSION E-W                               SEAPRS.38
C                 KX       NUMBER OF VERTICAL LEVELS                             SEAPRS.39
C                 PTOP     PRESSURE AT TOP OF MODEL                              SEAPRS.40
C                                                                                SEAPRS.41
C     OUTPUT      SLP      SEA LEVEL PRESSURE         CROSS    2D                SEAPRS.42
C                                                                                SEAPRS.43
      DIMENSION T(IMX,JMX,KX), PP(IMX,JMX,KX),                                   SEAPRS.44
     *          PS(IMX,JMX)  ,SFP(IMX,JMX) ,                                     SEAPRS.45
     *          TER(IMX,JMX) ,SIG(KX)                                            SEAPRS.46
      DIMENSION PL(IMX,JMX),T0(IMX,JMX),TS(IMX,JMX),                             SEAPRS.47
     *          XKLEV(IMX,JMX)                                                   SEAPRS.48
      DIMENSION SLP(IMX,JMX)                                                     SEAPRS.49
      PARAMETER (R=287.04,G=9.8,GAMMA=6.5E-3)                                    SEAPRS.50
      PARAMETER (TC=273.16+17.5) ! T CRITICAL IN PSFC/PSLV                       SEAPRS.51
      PARAMETER (PCONST=100.)                                                    SEAPRS.52
C                                                                                SEAPRS.53
      LOGICAL L1,L2,L3,L4                                                        SEAPRS.54
C                                                                                SEAPRS.55
#     include <cray_vector_func.incl>                                            SEAPRS.56
C                                                                                SEAPRS.57
C                                                                                SEAPRS.58
C     ... SEA LEVEL PRESSURE                                                     SEAPRS.59
C                                                                                SEAPRS.60
      XTERM=GAMMA*R/G                                                            SEAPRS.61
C                                                                                SEAPRS.62
C     ... COMPUTE PRESSURE AT PCONST MB ABOVE SURFACE (PL)                       SEAPRS.63
C                                                                                SEAPRS.64
      KUPTO=KX/2                                                                 SEAPRS.65
99    CONTINUE                                                                   SEAPRS.66
      DO 100 J=1,JMX-1                                                           SEAPRS.67
      DO 100 I=1,IMX-1                                                           SEAPRS.68
         PL(I,J)=SFP(I,J)-PCONST                                                 SEAPRS.69
         XKLEV(I,J)=0.                                                           SEAPRS.70
100   CONTINUE                                                                   SEAPRS.71
C                                                                                SEAPRS.72
C     ... FIND 2 LEVELS ON SIGMA SURFACES SURROUNDING PL AT EACH I,J             SEAPRS.73
C                                                                                SEAPRS.74
      DO 150 J=1,JMX-1                                                           SEAPRS.75
      DO 150 I=1,IMX-1                                                           SEAPRS.76
         DO 125 K=KX-1,KUPTO,-1                                                  SEAPRS.77
            XK=FLOAT(K)                                                          SEAPRS.78
            XKHOLD=XKLEV(I,J)                                                    SEAPRS.79
            XKLEV(I,J)=CVMGT(XK,XKHOLD,                                          SEAPRS.80
     *         (((SIG(K  )*PS(I,J)+PTOP+PP(I,J,K)).LT.PL(I,J)) .AND.             SEAPRS.81
     *          ((SIG(K+1)*PS(I,J)+PTOP+PP(I,J,K+1)).GE.PL(I,J))))               SEAPRS.82
125      CONTINUE                                                                SEAPRS.83
         IF(XKLEV(I,J).LT.1.) THEN                                               SEAPRS.84
            PRINT *,'ERROR FINDING PRESSURE LEVEL ',PCONST,' MB ',               SEAPRS.85
     *              'ABOVE THE SURFACE'                                          SEAPRS.86
            PRINT *,'LAST K LEVEL =',KUPTO                                       SEAPRS.87
            IF(KUPTO.NE.1) THEN                                                  SEAPRS.88
               PRINT *,'TRYING AGAIN WITH KUPTO=1'                               SEAPRS.89
               KUPTO=1                                                           SEAPRS.90
               GOTO 99                                                           SEAPRS.91
            ELSE                                                                 SEAPRS.92
               PRINT *,'I,J=',I,J                                                SEAPRS.93
               PRINT *,'PL=',PL(I,J)                                             SEAPRS.94
               PRINT *,'PSFC=',SFP(I,J)                                          SEAPRS.95
               CALL ABORT                                                        SEAPRS.96
            END IF                                                               SEAPRS.97
         END IF                                                                  SEAPRS.98
150   CONTINUE                                                                   SEAPRS.99
C                                                                                SEAPRS.100
C     ... GET TEMPERATURE AT PL (TL), EXTRAPOLATE T AT SURFACE (TS)              SEAPRS.101
C         AND T AT SEA LEVEL (T0) WITH 6.5 K/KM LAPSE RATE                       SEAPRS.102
C                                                                                SEAPRS.103
      DO 200 J=1,JMX-1                                                           SEAPRS.104
      DO 200 I=1,IMX-1                                                           SEAPRS.105
         KLO=NINT(XKLEV(I,J))+1                                                  SEAPRS.106
         KHI=NINT(XKLEV(I,J))                                                    SEAPRS.107
         PLO=SIG(KLO)*PS(I,J)+PTOP+PP(I,J,KLO)                                   SEAPRS.108
         PHI=SIG(KHI)*PS(I,J)+PTOP+PP(I,J,KHI)                                   SEAPRS.109
         TLO=T(I,J,KLO)                                                          SEAPRS.110
         THI=T(I,J,KHI)                                                          SEAPRS.111
         TL=THI-(THI-TLO)*ALOG(PL(I,J)/PHI)/ALOG(PLO/PHI)                        SEAPRS.112
         TS(I,J)=TL*(SFP(I,J)/PL(I,J))**XTERM                                    SEAPRS.113
         TBAR=(TS(I,J)+TL)*0.5                                                   SEAPRS.114
         HL=TER(I,J)-R/G*ALOG(PL(I,J)/SFP(I,J))*TBAR                             SEAPRS.115
         T0(I,J)=TL+GAMMA*HL                                                     SEAPRS.116
200   CONTINUE                                                                   SEAPRS.117
C                                                                                SEAPRS.118
C     ... CORRECT SEA LEVEL TEMPERATURE IF TOO HOT                               SEAPRS.119
C                                                                                SEAPRS.120
      DO 400 J=1,JMX-1                                                           SEAPRS.121
      DO 400 I=1,IMX-1                                                           SEAPRS.122
         L1=T0(I,J).LT.TC                                                        SEAPRS.123
         L2=TS(I,J).LE.TC                                                        SEAPRS.124
         L3=.NOT.L1                                                              SEAPRS.125
         T0HOLD=T0(I,J)                                                          SEAPRS.126
         T0(I,J)=CVMGT(T0HOLD,                                                   SEAPRS.127
     *      CVMGT(TC,TC-0.005*(TS(I,J)-TC)**2,L2.AND.L3),                        SEAPRS.128
     *      L1.AND.L2)                                                           SEAPRS.129
400   CONTINUE                                                                   SEAPRS.130
C                                                                                SEAPRS.131
C     ... COMPUTE SEA LEVEL PRESSURE                                             SEAPRS.132
C                                                                                SEAPRS.133
      DO 600 J=1,JMX-1                                                           SEAPRS.134
      DO 600 I=1,IMX-1                                                           SEAPRS.135
         SLP(I,J)=SFP(I,J)*EXP(2.*G*TER(I,J)/(R*(TS(I,J)+T0(I,J))))              SEAPRS.136
600   CONTINUE                                                                   SEAPRS.137
      RETURN                                                                     SEAPRS.138
      END                                                                        SEAPRS.139
