      SUBROUTINE SEAPRS2(PP,TER,TSFC,PS,SLP,                                     SEAPRS2.1
     *   THETA,F1,F2,F3,PI,                                                      SEAPRS2.2
     *   F,UG,VG,WORK,SIG,IMX,JMX,KX,PTOP,DS)                                    SEAPRS2.3
C                                                                                SEAPRS2.4
C     SECTION  DIAGNOSTICS                                                       SEAPRS2.5
C     PURPOSE  COMPUTE SEA LEVEL PRESSURE WITH SURFACE GEOSTROPHIC               SEAPRS2.6
C              WINDS, ASSUMING SURFACE GEOS WINDS ARE EQUAL TO                   SEAPRS2.7
C              SEA LEVEL GEOS WINDS.  NCAR DIRECT POISSON SOLVER                 SEAPRS2.8
C              USING BLOCK CYCLIC REDUCTION ON THE TRIDIAGONAL MATRIX            SEAPRS2.9
C              (HWSCRT) IS USED.  DATA IS ASSUMED ON SIGMA COORDINATES,          SEAPRS2.10
C              AND INCOMING T IS TV AT LOWEST SIGMA LEVEL.  ALL                  SEAPRS2.11
C              PRESSURES AS INPUT ARE IN MB.                                     SEAPRS2.12
C                                                                                SEAPRS2.13
C     INPUT       TSFC     VIRTUAL TEMP AT LOWEST LVL CROSS    2D                SEAPRS2.14
C                 TER      TERRAIN                    CROSS    2D                SEAPRS2.15
C                 PS       P STAR = PSFC-PTOP         CROSS    2D                SEAPRS2.16
C                 SLP      SEA LEVEL PRESSURE         CROSS    2D                SEAPRS2.17
C                 SIG      HALF SIGMA LEVELS                   1D                SEAPRS2.18
C                 IMX      DOT POINT DIMENSION N-S                               SEAPRS2.19
C                 JMX      DOT POINT DIMENSION E-W                               SEAPRS2.20
C                 KX       NUMBER OF VERTICAL LEVELS                             SEAPRS2.21
C                 PTOP     PRESSURE AT TOP OF MODEL                              SEAPRS2.22
C                 DS       GRID DISTANCE                                         SEAPRS2.23
C                                                                                SEAPRS2.24
C     SPACE       THETA    SFC POTENTIAL TEMP         CROSS    2D                SEAPRS2.25
C                 F1       FORCING TERM 1             CROSS    2D                SEAPRS2.26
C                 F2       FORCING TERM 2             CROSS    2D                SEAPRS2.27
C                 F3       FORCING TERM 3             CROSS    2D                SEAPRS2.28
C                 PI       SCALED SURFACE PRESSURE    CROSS    2D                SEAPRS2.29
C                 F        INPUT TO HWSCRT            CROSS    2D                SEAPRS2.30
C                 UG       U COMPONENT SFC GEOS WIND  CROSS    2D                SEAPRS2.31
C                 VG       V COMPONENT SFC GEOS WIND  CROSS    2D                SEAPRS2.32
C                 WORK     SPACE ARRAY FOR HWSCRT              1D                SEAPRS2.33
C                                                                                SEAPRS2.34
C     OUTPUT      SLP      SEA LEVEL PRESSURE         CROSS    2D                SEAPRS2.35
C                                                                                SEAPRS2.36
      PARAMETER (R=287.04,G=9.81,CP=1004.)                                       05DEC01.141
      PARAMETER (CPOR=CP/R,ROCP=R/CP)                                            SEAPRS2.38
#     include <scratch.incl>                                                     SEAPRS2.39
      DIMENSION THETA(IMX,JMX),  F1(IMX,JMX),  F2(IMX,JMX),                      SEAPRS2.40
     *          F3(IMX,JMX),     PI(IMX,JMX),  TER(IMX,JMX),                     SEAPRS2.41
     *          TSFC(IMX,JMX),   PS(IMX,JMX),  F(JMX-1,IMX-1),                   SEAPRS2.42
     *          UG(IMX,JMX),     VG(IMX,JMX),  WORK(10000),                      SEAPRS2.43
     *          SIG(KX), PP(IMX,JMX,KX)                                          SEAPRS2.44
      DIMENSION BDA(IJ_MAX),       BDB(IJ_MAX),    BDC(IJ_MAX),                  SEAPRS2.45
     *          BDD(IJ_MAX)                                                      SEAPRS2.46
      DIMENSION SLP(IMX,JMX)                                                     SEAPRS2.47
C                                                                                SEAPRS2.48
#     include <cray_vector_func.incl>                                            SEAPRS2.49
C                                                                                SEAPRS2.50
C                                                                                SEAPRS2.51
C     ... GRID DISTANCE, GET IT IN METERS                                        SEAPRS2.52
C                                                                                SEAPRS2.53
      DSM = CVMGT(DS*1000.,DS,DS.LT.1000.)                                       SEAPRS2.54
      DSM2 = 2.*DSM                                                              SEAPRS2.55
      DSM2R = 1./(2.*DSM)                                                        SEAPRS2.56
      SIGLO=SIG(KX)                                                              SEAPRS2.57
C                                                                                SEAPRS2.58
C     ... SCALED PRESSURE, THETA                                                 SEAPRS2.59
C                                                                                SEAPRS2.60
      DO 10 J = 1,JMX-1                                                          SEAPRS2.61
      DO 10 I = 1,IMX-1                                                          SEAPRS2.62
         PI(I,J) = CP*((PS(I,J) + PTOP+PP(I,J,KX))/1000.)**ROCP                  SEAPRS2.63
         THETA(I,J)=TSFC(I,J)*                                                   SEAPRS2.64
     *              (1000./(SIGLO*PS(I,J)+PTOP+PP(I,J,KX)))**ROCP                SEAPRS2.65
10    CONTINUE                                                                   SEAPRS2.66
C                                                                                SEAPRS2.67
C     ... SURFACE GEOSTROPHIC WINDS -- CROSS POINTS                              SEAPRS2.68
C                                                                                SEAPRS2.69
      DO 150 J = 2,JMX-2                                                         SEAPRS2.70
      DO 150 I = 2,IMX-2                                                         SEAPRS2.71
         VG1 = THETA(I,J) * (PI(I,J+1)-PI(I,J-1))                                SEAPRS2.72
         VG2 = G * (TER(I,J+1)-TER(I,J-1))                                       SEAPRS2.73
         VG(I,J) = (VG1 + VG2)*DSM2R                                             SEAPRS2.74
         UG1 = THETA(I,J) * (PI(I+1,J)-PI(I-1,J))                                SEAPRS2.75
         UG2 = G * (TER(I+1,J)-TER(I-1,J))                                       SEAPRS2.76
         UG(I,J) = -(UG1 + UG2)*DSM2R                                            SEAPRS2.77
150   CONTINUE                                                                   SEAPRS2.78
C                                                                                SEAPRS2.79
      CALL FILLIT(UG,IMX,JMX,1,IMX,JMX,2,IMX-2,2,JMX-2)                          SEAPRS2.80
      CALL FILLIT(VG,IMX,JMX,1,IMX,JMX,2,IMX-2,2,JMX-2)                          SEAPRS2.81
C                                                                                SEAPRS2.82
C     ... FORCING TERMS FOR POISSON EQN                                          SEAPRS2.83
C                                                                                SEAPRS2.84
      DO 210 I = 1,IMX-1                                                         SEAPRS2.85
      DO 210 J = 1,JMX-1                                                         SEAPRS2.86
         F1(I,J) = VG(I,J)/THETA(I,J)                                            SEAPRS2.87
         F2(I,J) = UG(I,J)/THETA(I,J)                                            SEAPRS2.88
210   CONTINUE                                                                   SEAPRS2.89
      DO 230 I = 2,IMX-2                                                         SEAPRS2.90
      DO 230 J = 2,JMX-2                                                         SEAPRS2.91
         F3(I,J) = (F1(I,J+1)-F1(I,J-1)-F2(I+1,J)+F2(I-1,J))*DSM2R               SEAPRS2.92
230   CONTINUE                                                                   SEAPRS2.93
C                                                                                SEAPRS2.94
C     ... BOUNDARY VALUES FOR DIRICHLET CONDITIONS                               SEAPRS2.95
C                                                                                SEAPRS2.96
      DO 380 J = 1,JMX-1                                                         SEAPRS2.97
         F3(1,J) = CP * (SLP(1,J)/1000.) ** ROCP                                 SEAPRS2.98
         F3(IMX-1,J) = CP * (SLP(IMX-1,J)/1000.) ** ROCP                         SEAPRS2.99
380   CONTINUE                                                                   SEAPRS2.100
C                                                                                SEAPRS2.101
      DO 390 I=1,IMX-1                                                           SEAPRS2.102
         F3(I,1) = CP * (SLP(I,1)/1000.) ** ROCP                                 SEAPRS2.103
         F3(I,JMX-1) = CP * (SLP(I,JMX-1)/1000.) ** ROCP                         SEAPRS2.104
390   CONTINUE                                                                   SEAPRS2.105
C                                                                                SEAPRS2.106
      DO 500 J=1,JMX-1                                                           SEAPRS2.107
      DO 500 I=1,IMX-1                                                           SEAPRS2.108
         F(J,I)=F3(I,J)                                                          SEAPRS2.109
500   CONTINUE                                                                   SEAPRS2.110
C                                                                                SEAPRS2.111
C     ... SET UP CALL TO NCAR POISSON SOLVER                                     SEAPRS2.112
C                                                                                SEAPRS2.113
      M = JMX - 2            ! NUMBER OF PANELS                                  SEAPRS2.114
      N = IMX - 2                                                                SEAPRS2.115
      A = 0.                ! DISTANCES FOR FINITE DIFFERENCES                   SEAPRS2.116
      B = DSM*FLOAT(M)                                                           SEAPRS2.117
      C = 0.                                                                     SEAPRS2.118
      D = DSM*FLOAT(N)                                                           SEAPRS2.119
      MBDCND = 1            ! DIRICHLET BC ON ALL 4 SIDES                        SEAPRS2.120
      NBDCND = 1                                                                 SEAPRS2.121
      ELAMBDA = 0.          ! THIS IS A POISSON EQN, NOT HELMHOLZ                SEAPRS2.122
      IDIMF = JMX-1          ! SIZE OF FIRST DIMENSION OF FORCING TERM           SEAPRS2.123
C                                                                                SEAPRS2.124
      CALL HWSCRT(A,B,M,MBDCND,BDA,BDB,                                          SEAPRS2.125
     *            C,D,N,NBDCND,BDC,BDD,                                          SEAPRS2.126
     *            ELAMBDA,F,IDIMF,PERTRB,IERROR,WORK)                            SEAPRS2.127
C                                                                                SEAPRS2.128
      IF (IERROR.NE.0) THEN                                                      SEAPRS2.129
         PRINT *,'IERROR = ',IERROR                                              SEAPRS2.130
         PRINT *,'FATAL ERROR IN HWSCRT, PROGRAM IS ABORTING'                    SEAPRS2.131
         CALL ABORT                                                              SEAPRS2.132
      END IF                                                                     SEAPRS2.133
C                                                                                SEAPRS2.134
C     ... NEW SLP                                                                SEAPRS2.135
C                                                                                SEAPRS2.136
      DO 550 J = 1,JMX-1                                                         SEAPRS2.137
      DO 550 I = 1,IMX-1                                                         SEAPRS2.138
         SLP(I,J) = 1000. * (F(J,I)/CP) ** CPOR                                  SEAPRS2.139
550   CONTINUE                                                                   SEAPRS2.140
C                                                                                SEAPRS2.141
      RETURN                                                                     SEAPRS2.142
      END                                                                        SEAPRS2.143
C                                                                                SEAPRS2.144
c     file hwscrt.f                                                              05DEC01.142
c                                                                                05DEC01.143
c  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .               05DEC01.144
c  .                                                             .               05DEC01.145
c  .                  copyright (c) 1999 by UCAR                 .               05DEC01.146
c  .                                                             .               05DEC01.147
c  .       UNIVERSITY CORPORATION for ATMOSPHERIC RESEARCH       .               05DEC01.148
c  .                                                             .               05DEC01.149
c  .                      all rights reserved                    .               05DEC01.150
c  .                                                             .               05DEC01.151
c  .                                                             .               05DEC01.152
c  .                      FISHPACK version 4.0                   .               05DEC01.153
c  .                                                             .               05DEC01.154
c  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .               05DEC01.155
c                                                                                05DEC01.156
      SUBROUTINE HWSCRT (A,B,M,MBDCND,BDA,BDB,C,D,N,NBDCND,BDC,BDD,              05DEC01.157
     1                   ELMBDA,F,IDIMF,PERTRB,IERROR,W)                         05DEC01.158
C                                                                                05DEC01.159
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *          05DEC01.160
C     *                                                               *          05DEC01.161
C     *                        F I S H P A C K                        *          05DEC01.162
C     *                                                               *          05DEC01.163
C     *                                                               *          05DEC01.164
C     *     A PACKAGE OF FORTRAN SUBPROGRAMS FOR THE SOLUTION OF      *          05DEC01.165
C     *                                                               *          05DEC01.166
C     *      SEPARABLE ELLIPTIC PARTIAL DIFFERENTIAL EQUATIONS        *          05DEC01.167
C     *                                                               *          05DEC01.168
C     *                  (VERSION 4.0 , JUNE 1999)                    *          05DEC01.169
C     *                                                               *          05DEC01.170
C     *                             BY                                *          05DEC01.171
C     *                                                               *          05DEC01.172
C     *        JOHN ADAMS, PAUL SWARZTRAUBER AND ROLAND SWEET         *          05DEC01.173
C     *                                                               *          05DEC01.174
C     *                             OF                                *          05DEC01.175
C     *                                                               *          05DEC01.176
C     *         THE NATIONAL CENTER FOR ATMOSPHERIC RESEARCH          *          05DEC01.177
C     *                                                               *          05DEC01.178
C     *                BOULDER, COLORADO  (80307)  U.S.A.             *          05DEC01.179
C     *                                                               *          05DEC01.180
C     *                   WHICH IS SPONSORED BY                       *          05DEC01.181
C     *                                                               *          05DEC01.182
C     *              THE NATIONAL SCIENCE FOUNDATION                  *          05DEC01.183
C     *                                                               *          05DEC01.184
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *          05DEC01.185
C                                                                                05DEC01.186
C                                                                                05DEC01.187
C                                                                                05DEC01.188
C DIMENSION OF           BDA(N),      BDB(N),   BDC(M),BDD(M),                   05DEC01.189
C ARGUMENTS              F(IDIMF,N),  W(SEE ARGUMENT LIST)                       05DEC01.190
C                                                                                05DEC01.191
C LATEST REVISION        NOVEMBER 1988                                           05DEC01.192
C                                                                                05DEC01.193
C PURPOSE                SOLVES THE STANDARD FIVE-POINT FINITE                   05DEC01.194
C                        DIFFERENCE APPROXIMATION TO THE HELMHOLTZ               05DEC01.195
C                        EQUATION IN CARTESIAN COORDINATES.  THIS                05DEC01.196
C                        EQUATION IS                                             05DEC01.197
C                                                                                05DEC01.198
C                          (D/DX)(DU/DX) + (D/DY)(DU/DY)                         05DEC01.199
C                          + LAMBDA*U = F(X,Y).                                  05DEC01.200
C                                                                                05DEC01.201
C USAGE                  CALL HWSCRT (A,B,M,MBDCND,BDA,BDB,C,D,N,                05DEC01.202
C                                     NBDCND,BDC,BDD,ELMBDA,F,IDIMF,             05DEC01.203
C                                     PERTRB,IERROR,W)                           05DEC01.204
C                                                                                05DEC01.205
C ARGUMENTS                                                                      05DEC01.206
C ON INPUT               A,B                                                     05DEC01.207
C                                                                                05DEC01.208
C                          THE RANGE OF X, I.E., A .LE. X .LE. B.                05DEC01.209
C                          A MUST BE LESS THAN B.                                05DEC01.210
C                                                                                05DEC01.211
C                        M                                                       05DEC01.212
C                          THE NUMBER OF PANELS INTO WHICH THE                   05DEC01.213
C                          INTERVAL (A,B) IS SUBDIVIDED.                         05DEC01.214
C                          HENCE, THERE WILL BE M+1 GRID POINTS                  05DEC01.215
C                          IN THE X-DIRECTION GIVEN BY                           05DEC01.216
C                          X(I) = A+(I-1)DX FOR I = 1,2,...,M+1,                 05DEC01.217
C                          WHERE DX = (B-A)/M IS THE PANEL WIDTH.                05DEC01.218
C                          M MUST BE GREATER THAN 3.                             05DEC01.219
C                                                                                05DEC01.220
C                        MBDCND                                                  05DEC01.221
C                          INDICATES THE TYPE OF BOUNDARY CONDITIONS             05DEC01.222
C                          AT X = A AND X = B.                                   05DEC01.223
C                                                                                05DEC01.224
C                          = 0  IF THE SOLUTION IS PERIODIC IN X,                05DEC01.225
C                               I.E., U(I,J) = U(M+I,J).                         05DEC01.226
C                          = 1  IF THE SOLUTION IS SPECIFIED AT                  05DEC01.227
C                               X = A AND X = B.                                 05DEC01.228
C                          = 2  IF THE SOLUTION IS SPECIFIED AT                  05DEC01.229
C                               X = A AND THE DERIVATIVE OF THE                  05DEC01.230
C                               SOLUTION WITH RESPECT TO X IS                    05DEC01.231
C                               SPECIFIED AT X = B.                              05DEC01.232
C                          = 3  IF THE DERIVATIVE OF THE SOLUTION                05DEC01.233
C                               WITH RESPECT TO X IS SPECIFIED AT                05DEC01.234
C                               AT X = A AND X = B.                              05DEC01.235
C                          = 4  IF THE DERIVATIVE OF THE SOLUTION                05DEC01.236
C                               WITH RESPECT TO X IS SPECIFIED AT                05DEC01.237
C                               X = A AND THE SOLUTION IS SPECIFIED              05DEC01.238
C                               AT X = B.                                        05DEC01.239
C                                                                                05DEC01.240
C                        BDA                                                     05DEC01.241
C                          A ONE-DIMENSIONAL ARRAY OF LENGTH N+1 THAT            05DEC01.242
C                          SPECIFIES THE VALUES OF THE DERIVATIVE                05DEC01.243
C                          OF THE SOLUTION WITH RESPECT TO X AT X = A.           05DEC01.244
C                                                                                05DEC01.245
C                          WHEN MBDCND = 3 OR 4,                                 05DEC01.246
C                                                                                05DEC01.247
C                            BDA(J) = (D/DX)U(A,Y(J)), J = 1,2,...,N+1.          05DEC01.248
C                                                                                05DEC01.249
C                          WHEN MBDCND HAS ANY OTHER VALUE, BDA IS               05DEC01.250
C                          A DUMMY VARIABLE.                                     05DEC01.251
C                                                                                05DEC01.252
C                        BDB                                                     05DEC01.253
C                          A ONE-DIMENSIONAL ARRAY OF LENGTH N+1                 05DEC01.254
C                          THAT SPECIFIES THE VALUES OF THE DERIVATIVE           05DEC01.255
C                          OF THE SOLUTION WITH RESPECT TO X AT X = B.           05DEC01.256
C                                                                                05DEC01.257
C                          WHEN MBDCND = 2 OR 3,                                 05DEC01.258
C                                                                                05DEC01.259
C                            BDB(J) = (D/DX)U(B,Y(J)), J = 1,2,...,N+1           05DEC01.260
C                                                                                05DEC01.261
C                          WHEN MBDCND HAS ANY OTHER VALUE BDB IS A              05DEC01.262
C                          DUMMY VARIABLE.                                       05DEC01.263
C                                                                                05DEC01.264
C                        C,D                                                     05DEC01.265
C                          THE RANGE OF Y, I.E., C .LE. Y .LE. D.                05DEC01.266
C                          C MUST BE LESS THAN D.                                05DEC01.267
C                                                                                05DEC01.268
C                        N                                                       05DEC01.269
C                          THE NUMBER OF PANELS INTO WHICH THE                   05DEC01.270
C                          INTERVAL (C,D) IS SUBDIVIDED.  HENCE,                 05DEC01.271
C                          THERE WILL BE N+1 GRID POINTS IN THE                  05DEC01.272
C                          Y-DIRECTION GIVEN BY Y(J) = C+(J-1)DY                 05DEC01.273
C                          FOR J = 1,2,...,N+1, WHERE                            05DEC01.274
C                          DY = (D-C)/N IS THE PANEL WIDTH.                      05DEC01.275
C                          N MUST BE GREATER THAN 3.                             05DEC01.276
C                                                                                05DEC01.277
C                        NBDCND                                                  05DEC01.278
C                          INDICATES THE TYPE OF BOUNDARY CONDITIONS AT          05DEC01.279
C                          Y = C AND Y = D.                                      05DEC01.280
C                                                                                05DEC01.281
C                          = 0  IF THE SOLUTION IS PERIODIC IN Y,                05DEC01.282
C                               I.E., U(I,J) = U(I,N+J).                         05DEC01.283
C                          = 1  IF THE SOLUTION IS SPECIFIED AT                  05DEC01.284
C                               Y = C AND Y = D.                                 05DEC01.285
C                          = 2  IF THE SOLUTION IS SPECIFIED AT                  05DEC01.286
C                               Y = C AND THE DERIVATIVE OF THE                  05DEC01.287
C                               SOLUTION WITH RESPECT TO Y IS                    05DEC01.288
C                               SPECIFIED AT Y = D.                              05DEC01.289
C                          = 3  IF THE DERIVATIVE OF THE SOLUTION                05DEC01.290
C                               WITH RESPECT TO Y IS SPECIFIED AT                05DEC01.291
C                               Y = C AND Y = D.                                 05DEC01.292
C                          = 4  IF THE DERIVATIVE OF THE SOLUTION                05DEC01.293
C                               WITH RESPECT TO Y IS SPECIFIED AT                05DEC01.294
C                               Y = C AND THE SOLUTION IS SPECIFIED              05DEC01.295
C                               AT Y = D.                                        05DEC01.296
C                                                                                05DEC01.297
C                        BDC                                                     05DEC01.298
C                          A ONE-DIMENSIONAL ARRAY OF LENGTH M+1 THAT            05DEC01.299
C                          SPECIFIES THE VALUES OF THE DERIVATIVE                05DEC01.300
C                          OF THE SOLUTION WITH RESPECT TO Y AT Y = C.           05DEC01.301
C                                                                                05DEC01.302
C                          WHEN NBDCND = 3 OR 4,                                 05DEC01.303
C                                                                                05DEC01.304
C                            BDC(I) = (D/DY)U(X(I),C), I = 1,2,...,M+1           05DEC01.305
C                                                                                05DEC01.306
C                          WHEN NBDCND HAS ANY OTHER VALUE, BDC IS               05DEC01.307
C                          A DUMMY VARIABLE.                                     05DEC01.308
C                                                                                05DEC01.309
C                        BDD                                                     05DEC01.310
C                          A ONE-DIMENSIONAL ARRAY OF LENGTH M+1 THAT            05DEC01.311
C                          SPECIFIES THE VALUES OF THE DERIVATIVE                05DEC01.312
C                          OF THE SOLUTION WITH RESPECT TO Y AT Y = D.           05DEC01.313
C                                                                                05DEC01.314
C                          WHEN NBDCND = 2 OR 3,                                 05DEC01.315
C                                                                                05DEC01.316
C                            BDD(I) = (D/DY)U(X(I),D), I = 1,2,...,M+1           05DEC01.317
C                                                                                05DEC01.318
C                          WHEN NBDCND HAS ANY OTHER VALUE, BDD IS               05DEC01.319
C                          A DUMMY VARIABLE.                                     05DEC01.320
C                                                                                05DEC01.321
C                        ELMBDA                                                  05DEC01.322
C                          THE CONSTANT LAMBDA IN THE HELMHOLTZ                  05DEC01.323
C                          EQUATION.  IF LAMBDA .GT. 0, A SOLUTION               05DEC01.324
C                          MAY NOT EXIST.  HOWEVER, HWSCRT WILL                  05DEC01.325
C                          ATTEMPT TO FIND A SOLUTION.                           05DEC01.326
C                                                                                05DEC01.327
C                        F                                                       05DEC01.328
C                          A TWO-DIMENSIONAL ARRAY, OF DIMENSION AT              05DEC01.329
C                          LEAST (M+1)*(N+1), SPECIFYING VALUES OF THE           05DEC01.330
C                          RIGHT SIDE OF THE HELMHOLTZ  EQUATION AND             05DEC01.331
C                          BOUNDARY VALUES (IF ANY).                             05DEC01.332
C                                                                                05DEC01.333
C                          ON THE INTERIOR, F IS DEFINED AS FOLLOWS:             05DEC01.334
C                          FOR I = 2,3,...,M AND J = 2,3,...,N                   05DEC01.335
C                          F(I,J) = F(X(I),Y(J)).                                05DEC01.336
C                                                                                05DEC01.337
C                          ON THE BOUNDARIES, F IS DEFINED AS FOLLOWS:           05DEC01.338
C                          FOR J=1,2,...,N+1,  I=1,2,...,M+1,                    05DEC01.339
C                                                                                05DEC01.340
C                          MBDCND     F(1,J)        F(M+1,J)                     05DEC01.341
C                          ------     ---------     --------                     05DEC01.342
C                                                                                05DEC01.343
C                            0        F(A,Y(J))     F(A,Y(J))                    05DEC01.344
C                            1        U(A,Y(J))     U(B,Y(J))                    05DEC01.345
C                            2        U(A,Y(J))     F(B,Y(J))                    05DEC01.346
C                            3        F(A,Y(J))     F(B,Y(J))                    05DEC01.347
C                            4        F(A,Y(J))     U(B,Y(J))                    05DEC01.348
C                                                                                05DEC01.349
C                                                                                05DEC01.350
C                          NBDCND     F(I,1)        F(I,N+1)                     05DEC01.351
C                          ------     ---------     --------                     05DEC01.352
C                                                                                05DEC01.353
C                            0        F(X(I),C)     F(X(I),C)                    05DEC01.354
C                            1        U(X(I),C)     U(X(I),D)                    05DEC01.355
C                            2        U(X(I),C)     F(X(I),D)                    05DEC01.356
C                            3        F(X(I),C)     F(X(I),D)                    05DEC01.357
C                            4        F(X(I),C)     U(X(I),D)                    05DEC01.358
C                                                                                05DEC01.359
C                          NOTE:                                                 05DEC01.360
C                          IF THE TABLE CALLS FOR BOTH THE SOLUTION U            05DEC01.361
C                          AND THE RIGHT SIDE F AT A CORNER THEN THE             05DEC01.362
C                          SOLUTION MUST BE SPECIFIED.                           05DEC01.363
C                                                                                05DEC01.364
C                        IDIMF                                                   05DEC01.365
C                          THE ROW (OR FIRST) DIMENSION OF THE ARRAY             05DEC01.366
C                          F AS IT APPEARS IN THE PROGRAM CALLING                05DEC01.367
C                          HWSCRT.  THIS PARAMETER IS USED TO SPECIFY            05DEC01.368
C                          THE VARIABLE DIMENSION OF F.  IDIMF MUST              05DEC01.369
C                          BE AT LEAST M+1  .                                    05DEC01.370
C                                                                                05DEC01.371
C                        W                                                       05DEC01.372
C                          A ONE-DIMENSIONAL ARRAY THAT MUST BE                  05DEC01.373
C                          PROVIDED BY THE USER FOR WORK SPACE.                  05DEC01.374
C                          W MAY REQUIRE UP TO 4*(N+1) +                         05DEC01.375
C                          (13 + INT(LOG2(N+1)))*(M+1) LOCATIONS.                05DEC01.376
C                          THE ACTUAL NUMBER OF LOCATIONS USED IS                05DEC01.377
C                          COMPUTED BY HWSCRT AND IS RETURNED IN                 05DEC01.378
C                          LOCATION W(1).                                        05DEC01.379
C                                                                                05DEC01.380
C                                                                                05DEC01.381
C ON OUTPUT              F                                                       05DEC01.382
C                          CONTAINS THE SOLUTION U(I,J) OF THE FINITE            05DEC01.383
C                          DIFFERENCE APPROXIMATION FOR THE GRID POINT           05DEC01.384
C                          (X(I),Y(J)), I = 1,2,...,M+1,                         05DEC01.385
C                          J = 1,2,...,N+1  .                                    05DEC01.386
C                                                                                05DEC01.387
C                        PERTRB                                                  05DEC01.388
C                          IF A COMBINATION OF PERIODIC OR DERIVATIVE            05DEC01.389
C                          BOUNDARY CONDITIONS IS SPECIFIED FOR A                05DEC01.390
C                          POISSON EQUATION (LAMBDA = 0), A SOLUTION             05DEC01.391
C                          MAY NOT EXIST.  PERTRB IS A CONSTANT,                 05DEC01.392
C                          CALCULATED AND SUBTRACTED FROM F, WHICH               05DEC01.393
C                          ENSURES THAT A SOLUTION EXISTS.  HWSCRT               05DEC01.394
C                          THEN COMPUTES THIS SOLUTION, WHICH IS A               05DEC01.395
C                          LEAST SQUARES SOLUTION TO THE ORIGINAL                05DEC01.396
C                          APPROXIMATION.  THIS SOLUTION PLUS ANY                05DEC01.397
C                          CONSTANT IS ALSO A SOLUTION.  HENCE, THE              05DEC01.398
C                          SOLUTION IS NOT UNIQUE.  THE VALUE OF                 05DEC01.399
C                          PERTRB SHOULD BE SMALL COMPARED TO THE                05DEC01.400
C                          RIGHT SIDE F.  OTHERWISE, A SOLUTION IS               05DEC01.401
C                          OBTAINED TO AN ESSENTIALLY DIFFERENT                  05DEC01.402
C                          PROBLEM. THIS COMPARISON SHOULD ALWAYS                05DEC01.403
C                          BE MADE TO INSURE THAT A MEANINGFUL                   05DEC01.404
C                          SOLUTION HAS BEEN OBTAINED.                           05DEC01.405
C                                                                                05DEC01.406
C                        IERROR                                                  05DEC01.407
C                          AN ERROR FLAG THAT INDICATES INVALID INPUT            05DEC01.408
C                          PARAMETERS.  EXCEPT FOR NUMBERS 0 AND 6,              05DEC01.409
C                          A SOLUTION IS NOT ATTEMPTED.                          05DEC01.410
C                                                                                05DEC01.411
C                          = 0  NO ERROR                                         05DEC01.412
C                          = 1  A .GE. B                                         05DEC01.413
C                          = 2  MBDCND .LT. 0 OR MBDCND .GT. 4                   05DEC01.414
C                          = 3  C .GE. D                                         05DEC01.415
C                          = 4  N .LE. 3                                         05DEC01.416
C                          = 5  NBDCND .LT. 0 OR NBDCND .GT. 4                   05DEC01.417
C                          = 6  LAMBDA .GT. 0                                    05DEC01.418
C                          = 7  IDIMF .LT. M+1                                   05DEC01.419
C                          = 8  M .LE. 3                                         05DEC01.420
C                                                                                05DEC01.421
C                          SINCE THIS IS THE ONLY MEANS OF INDICATING            05DEC01.422
C                          A POSSIBLY INCORRECT CALL TO HWSCRT, THE              05DEC01.423
C                          USER SHOULD TEST IERROR AFTER THE CALL.               05DEC01.424
C                                                                                05DEC01.425
C                        W                                                       05DEC01.426
C                          W(1) CONTAINS THE REQUIRED LENGTH OF W.               05DEC01.427
C                                                                                05DEC01.428
C SPECIAL CONDITIONS     NONE                                                    05DEC01.429
C                                                                                05DEC01.430
C I/O                    NONE                                                    05DEC01.431
C                                                                                05DEC01.432
C PRECISION              SINGLE                                                  05DEC01.433
C                                                                                05DEC01.434
C REQUIRED LIBRARY       GENBUN, GNBNAUX, AND COMF                               05DEC01.435
C FILES                  FROM FISHPACK                                           05DEC01.436
C                                                                                05DEC01.437
C LANGUAGE               FORTRAN                                                 05DEC01.438
C                                                                                05DEC01.439
C HISTORY                WRITTEN BY ROLAND SWEET AT NCAR IN THE LATE             05DEC01.440
C                        1970'S.  RELEASED ON NCAR'S PUBLIC SOFTWARE             05DEC01.441
C                        LIBRARIES IN JANUARY 1980.                              05DEC01.442
C                                                                                05DEC01.443
C PORTABILITY            FORTRAN 77                                              05DEC01.444
C                                                                                05DEC01.445
C ALGORITHM              THE ROUTINE DEFINES THE FINITE DIFFERENCE               05DEC01.446
C                        EQUATIONS, INCORPORATES BOUNDARY DATA, AND              05DEC01.447
C                        ADJUSTS THE RIGHT SIDE OF SINGULAR SYSTEMS              05DEC01.448
C                        AND THEN CALLS GENBUN TO SOLVE THE SYSTEM.              05DEC01.449
C                                                                                05DEC01.450
C TIMING                 FOR LARGE  M AND N, THE OPERATION COUNT                 05DEC01.451
C                        IS ROUGHLY PROPORTIONAL TO                              05DEC01.452
C                          M*N*(LOG2(N)                                          05DEC01.453
C                        BUT ALSO DEPENDS ON INPUT PARAMETERS NBDCND             05DEC01.454
C                        AND MBDCND.                                             05DEC01.455
C                                                                                05DEC01.456
C ACCURACY               THE SOLUTION PROCESS EMPLOYED RESULTS IN A LOSS         05DEC01.457
C                        OF NO MORE THAN THREE SIGNIFICANT DIGITS FOR N          05DEC01.458
C                        AND M AS LARGE AS 64.  MORE DETAILS ABOUT               05DEC01.459
C                        ACCURACY CAN BE FOUND IN THE DOCUMENTATION FOR          05DEC01.460
C                        SUBROUTINE GENBUN WHICH IS THE ROUTINE THAT             05DEC01.461
C                        SOLVES THE FINITE DIFFERENCE EQUATIONS.                 05DEC01.462
C                                                                                05DEC01.463
C REFERENCES             SWARZTRAUBER,P. AND R. SWEET, "EFFICIENT                05DEC01.464
C                        FORTRAN SUBPROGRAMS FOR THE SOLUTION OF                 05DEC01.465
C                        ELLIPTIC EQUATIONS"                                     05DEC01.466
C                          NCAR TN/IA-109, JULY, 1975, 138 PP.                   05DEC01.467
C***********************************************************************         05DEC01.468
      DIMENSION       F(IDIMF,1)                                                 05DEC01.469
      DIMENSION       BDA(*)     ,BDB(*)     ,BDC(*)     ,BDD(*)     ,           05DEC01.470
     1                W(*)                                                       05DEC01.471
C                                                                                05DEC01.472
C     CHECK FOR INVALID PARAMETERS.                                              05DEC01.473
C                                                                                05DEC01.474
      IERROR = 0                                                                 05DEC01.475
      IF (A .GE. B) IERROR = 1                                                   05DEC01.476
      IF (MBDCND.LT.0 .OR. MBDCND.GT.4) IERROR = 2                               05DEC01.477
      IF (C .GE. D) IERROR = 3                                                   05DEC01.478
      IF (N .LE. 3) IERROR = 4                                                   05DEC01.479
      IF (NBDCND.LT.0 .OR. NBDCND.GT.4) IERROR = 5                               05DEC01.480
      IF (IDIMF .LT. M+1) IERROR = 7                                             05DEC01.481
      IF (M .LE. 3) IERROR = 8                                                   05DEC01.482
      IF (IERROR .NE. 0) RETURN                                                  05DEC01.483
      NPEROD = NBDCND                                                            05DEC01.484
      MPEROD = 0                                                                 05DEC01.485
      IF (MBDCND .GT. 0) MPEROD = 1                                              05DEC01.486
      DELTAX = (B-A)/FLOAT(M)                                                    05DEC01.487
      TWDELX = 2./DELTAX                                                         05DEC01.488
      DELXSQ = 1./DELTAX**2                                                      05DEC01.489
      DELTAY = (D-C)/FLOAT(N)                                                    05DEC01.490
      TWDELY = 2./DELTAY                                                         05DEC01.491
      DELYSQ = 1./DELTAY**2                                                      05DEC01.492
      NP = NBDCND+1                                                              05DEC01.493
      NP1 = N+1                                                                  05DEC01.494
      MP = MBDCND+1                                                              05DEC01.495
      MP1 = M+1                                                                  05DEC01.496
      NSTART = 1                                                                 05DEC01.497
      NSTOP = N                                                                  05DEC01.498
      NSKIP = 1                                                                  05DEC01.499
      GO TO (104,101,102,103,104),NP                                             05DEC01.500
  101 NSTART = 2                                                                 05DEC01.501
      GO TO 104                                                                  05DEC01.502
  102 NSTART = 2                                                                 05DEC01.503
  103 NSTOP = NP1                                                                05DEC01.504
      NSKIP = 2                                                                  05DEC01.505
  104 NUNK = NSTOP-NSTART+1                                                      05DEC01.506
C                                                                                05DEC01.507
C     ENTER BOUNDARY DATA FOR X-BOUNDARIES.                                      05DEC01.508
C                                                                                05DEC01.509
      MSTART = 1                                                                 05DEC01.510
      MSTOP = M                                                                  05DEC01.511
      MSKIP = 1                                                                  05DEC01.512
      GO TO (117,105,106,109,110),MP                                             05DEC01.513
  105 MSTART = 2                                                                 05DEC01.514
      GO TO 107                                                                  05DEC01.515
  106 MSTART = 2                                                                 05DEC01.516
      MSTOP = MP1                                                                05DEC01.517
      MSKIP = 2                                                                  05DEC01.518
  107 DO 108 J=NSTART,NSTOP                                                      05DEC01.519
         F(2,J) = F(2,J)-F(1,J)*DELXSQ                                           05DEC01.520
  108 CONTINUE                                                                   05DEC01.521
      GO TO 112                                                                  05DEC01.522
  109 MSTOP = MP1                                                                05DEC01.523
      MSKIP = 2                                                                  05DEC01.524
  110 DO 111 J=NSTART,NSTOP                                                      05DEC01.525
         F(1,J) = F(1,J)+BDA(J)*TWDELX                                           05DEC01.526
  111 CONTINUE                                                                   05DEC01.527
  112 GO TO (113,115),MSKIP                                                      05DEC01.528
  113 DO 114 J=NSTART,NSTOP                                                      05DEC01.529
         F(M,J) = F(M,J)-F(MP1,J)*DELXSQ                                         05DEC01.530
  114 CONTINUE                                                                   05DEC01.531
      GO TO 117                                                                  05DEC01.532
  115 DO 116 J=NSTART,NSTOP                                                      05DEC01.533
         F(MP1,J) = F(MP1,J)-BDB(J)*TWDELX                                       05DEC01.534
  116 CONTINUE                                                                   05DEC01.535
  117 MUNK = MSTOP-MSTART+1                                                      05DEC01.536
C                                                                                05DEC01.537
C     ENTER BOUNDARY DATA FOR Y-BOUNDARIES.                                      05DEC01.538
C                                                                                05DEC01.539
      GO TO (127,118,118,120,120),NP                                             05DEC01.540
  118 DO 119 I=MSTART,MSTOP                                                      05DEC01.541
         F(I,2) = F(I,2)-F(I,1)*DELYSQ                                           05DEC01.542
  119 CONTINUE                                                                   05DEC01.543
      GO TO 122                                                                  05DEC01.544
  120 DO 121 I=MSTART,MSTOP                                                      05DEC01.545
         F(I,1) = F(I,1)+BDC(I)*TWDELY                                           05DEC01.546
  121 CONTINUE                                                                   05DEC01.547
  122 GO TO (123,125),NSKIP                                                      05DEC01.548
  123 DO 124 I=MSTART,MSTOP                                                      05DEC01.549
         F(I,N) = F(I,N)-F(I,NP1)*DELYSQ                                         05DEC01.550
  124 CONTINUE                                                                   05DEC01.551
      GO TO 127                                                                  05DEC01.552
  125 DO 126 I=MSTART,MSTOP                                                      05DEC01.553
         F(I,NP1) = F(I,NP1)-BDD(I)*TWDELY                                       05DEC01.554
  126 CONTINUE                                                                   05DEC01.555
C                                                                                05DEC01.556
C    MULTIPLY RIGHT SIDE BY DELTAY**2.                                           05DEC01.557
C                                                                                05DEC01.558
  127 DELYSQ = DELTAY*DELTAY                                                     05DEC01.559
      DO 129 I=MSTART,MSTOP                                                      05DEC01.560
         DO 128 J=NSTART,NSTOP                                                   05DEC01.561
            F(I,J) = F(I,J)*DELYSQ                                               05DEC01.562
  128    CONTINUE                                                                05DEC01.563
  129 CONTINUE                                                                   05DEC01.564
C                                                                                05DEC01.565
C     DEFINE THE A,B,C COEFFICIENTS IN W-ARRAY.                                  05DEC01.566
C                                                                                05DEC01.567
      ID2 = MUNK                                                                 05DEC01.568
      ID3 = ID2+MUNK                                                             05DEC01.569
      ID4 = ID3+MUNK                                                             05DEC01.570
      S = DELYSQ*DELXSQ                                                          05DEC01.571
      ST2 = 2.*S                                                                 05DEC01.572
      DO 130 I=1,MUNK                                                            05DEC01.573
         W(I) = S                                                                05DEC01.574
         J = ID2+I                                                               05DEC01.575
         W(J) = -ST2+ELMBDA*DELYSQ                                               05DEC01.576
         J = ID3+I                                                               05DEC01.577
         W(J) = S                                                                05DEC01.578
  130 CONTINUE                                                                   05DEC01.579
      IF (MP .EQ. 1) GO TO 131                                                   05DEC01.580
      W(1) = 0.                                                                  05DEC01.581
      W(ID4) = 0.                                                                05DEC01.582
  131 CONTINUE                                                                   05DEC01.583
      GO TO (135,135,132,133,134),MP                                             05DEC01.584
  132 W(ID2) = ST2                                                               05DEC01.585
      GO TO 135                                                                  05DEC01.586
  133 W(ID2) = ST2                                                               05DEC01.587
  134 W(ID3+1) = ST2                                                             05DEC01.588
  135 CONTINUE                                                                   05DEC01.589
      PERTRB = 0.                                                                05DEC01.590
      IF (ELMBDA) 144,137,136                                                    05DEC01.591
  136 IERROR = 6                                                                 05DEC01.592
      GO TO 144                                                                  05DEC01.593
  137 IF ((NBDCND.EQ.0 .OR. NBDCND.EQ.3) .AND.                                   05DEC01.594
     1    (MBDCND.EQ.0 .OR. MBDCND.EQ.3)) GO TO 138                              05DEC01.595
      GO TO 144                                                                  05DEC01.596
C                                                                                05DEC01.597
C     FOR SINGULAR PROBLEMS MUST ADJUST DATA TO INSURE THAT A SOLUTION           05DEC01.598
C     WILL EXIST.                                                                05DEC01.599
C                                                                                05DEC01.600
  138 A1 = 1.                                                                    05DEC01.601
      A2 = 1.                                                                    05DEC01.602
      IF (NBDCND .EQ. 3) A2 = 2.                                                 05DEC01.603
      IF (MBDCND .EQ. 3) A1 = 2.                                                 05DEC01.604
      S1 = 0.                                                                    05DEC01.605
      MSP1 = MSTART+1                                                            05DEC01.606
      MSTM1 = MSTOP-1                                                            05DEC01.607
      NSP1 = NSTART+1                                                            05DEC01.608
      NSTM1 = NSTOP-1                                                            05DEC01.609
      DO 140 J=NSP1,NSTM1                                                        05DEC01.610
         S = 0.                                                                  05DEC01.611
         DO 139 I=MSP1,MSTM1                                                     05DEC01.612
            S = S+F(I,J)                                                         05DEC01.613
  139    CONTINUE                                                                05DEC01.614
         S1 = S1+S*A1+F(MSTART,J)+F(MSTOP,J)                                     05DEC01.615
  140 CONTINUE                                                                   05DEC01.616
      S1 = A2*S1                                                                 05DEC01.617
      S = 0.                                                                     05DEC01.618
      DO 141 I=MSP1,MSTM1                                                        05DEC01.619
         S = S+F(I,NSTART)+F(I,NSTOP)                                            05DEC01.620
  141 CONTINUE                                                                   05DEC01.621
      S1 = S1+S*A1+F(MSTART,NSTART)+F(MSTART,NSTOP)+F(MSTOP,NSTART)+             05DEC01.622
     1     F(MSTOP,NSTOP)                                                        05DEC01.623
      S = (2.+FLOAT(NUNK-2)*A2)*(2.+FLOAT(MUNK-2)*A1)                            05DEC01.624
      PERTRB = S1/S                                                              05DEC01.625
      DO 143 J=NSTART,NSTOP                                                      05DEC01.626
         DO 142 I=MSTART,MSTOP                                                   05DEC01.627
            F(I,J) = F(I,J)-PERTRB                                               05DEC01.628
  142    CONTINUE                                                                05DEC01.629
  143 CONTINUE                                                                   05DEC01.630
      PERTRB = PERTRB/DELYSQ                                                     05DEC01.631
C                                                                                05DEC01.632
C     SOLVE THE EQUATION.                                                        05DEC01.633
C                                                                                05DEC01.634
  144 CALL GENBUN (NPEROD,NUNK,MPEROD,MUNK,W(1),W(ID2+1),W(ID3+1),               05DEC01.635
     1             IDIMF,F(MSTART,NSTART),IERR1,W(ID4+1))                        05DEC01.636
      W(1) = W(ID4+1)+3.*FLOAT(MUNK)                                             05DEC01.637
C                                                                                05DEC01.638
C     FILL IN IDENTICAL VALUES WHEN HAVE PERIODIC BOUNDARY CONDITIONS.           05DEC01.639
C                                                                                05DEC01.640
      IF (NBDCND .NE. 0) GO TO 146                                               05DEC01.641
      DO 145 I=MSTART,MSTOP                                                      05DEC01.642
         F(I,NP1) = F(I,1)                                                       05DEC01.643
  145 CONTINUE                                                                   05DEC01.644
  146 IF (MBDCND .NE. 0) GO TO 148                                               05DEC01.645
      DO 147 J=NSTART,NSTOP                                                      05DEC01.646
         F(MP1,J) = F(1,J)                                                       05DEC01.647
  147 CONTINUE                                                                   05DEC01.648
      IF (NBDCND .EQ. 0) F(MP1,NP1) = F(1,NP1)                                   05DEC01.649
  148 CONTINUE                                                                   05DEC01.650
      RETURN                                                                     05DEC01.651
C                                                                                05DEC01.652
C REVISION HISTORY---                                                            05DEC01.653
C                                                                                05DEC01.654
C SEPTEMBER 1973    VERSION 1                                                    05DEC01.655
C APRIL     1976    VERSION 2                                                    05DEC01.656
C JANUARY   1978    VERSION 3                                                    05DEC01.657
C DECEMBER  1979    VERSION 3.1                                                  05DEC01.658
C FEBRUARY  1985    DOCUMENTATION UPGRADE                                        05DEC01.659
C NOVEMBER  1988    VERSION 3.2, FORTRAN 77 CHANGES                              05DEC01.660
C-----------------------------------------------------------------------         05DEC01.661
      END                                                                        05DEC01.662
c                                                                                05DEC01.663
c     file genbun.f                                                              05DEC01.664
c                                                                                05DEC01.665
c  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .               05DEC01.666
c  .                                                             .               05DEC01.667
c  .                  copyright (c) 1999 by UCAR                 .               05DEC01.668
c  .                                                             .               05DEC01.669
c  .       UNIVERSITY CORPORATION for ATMOSPHERIC RESEARCH       .               05DEC01.670
c  .                                                             .               05DEC01.671
c  .                      all rights reserved                    .               05DEC01.672
c  .                                                             .               05DEC01.673
c  .                                                             .               05DEC01.674
c  .                      FISHPACK version 4.0                   .               05DEC01.675
c  .                                                             .               05DEC01.676
c  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .               05DEC01.677
c                                                                                05DEC01.678
c                                                                                05DEC01.679
      SUBROUTINE GENBUN (NPEROD,N,MPEROD,M,A,B,C,IDIMY,Y,IERROR,W)               05DEC01.680
C                                                                                05DEC01.681
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *          05DEC01.682
C     *                                                               *          05DEC01.683
C     *                        F I S H P A C K                        *          05DEC01.684
C     *                                                               *          05DEC01.685
C     *                                                               *          05DEC01.686
C     *     A PACKAGE OF FORTRAN SUBPROGRAMS FOR THE SOLUTION OF      *          05DEC01.687
C     *                                                               *          05DEC01.688
C     *      SEPARABLE ELLIPTIC PARTIAL DIFFERENTIAL EQUATIONS        *          05DEC01.689
C     *                                                               *          05DEC01.690
C     *                  (VERSION 4.0 , JUNE 1999)                    *          05DEC01.691
C     *                                                               *          05DEC01.692
C     *                             BY                                *          05DEC01.693
C     *                                                               *          05DEC01.694
C     *        JOHN ADAMS, PAUL SWARZTRAUBER AND ROLAND SWEET         *          05DEC01.695
C     *                                                               *          05DEC01.696
C     *                             OF                                *          05DEC01.697
C     *                                                               *          05DEC01.698
C     *         THE NATIONAL CENTER FOR ATMOSPHERIC RESEARCH          *          05DEC01.699
C     *                                                               *          05DEC01.700
C     *                BOULDER, COLORADO  (80307)  U.S.A.             *          05DEC01.701
C     *                                                               *          05DEC01.702
C     *                   WHICH IS SPONSORED BY                       *          05DEC01.703
C     *                                                               *          05DEC01.704
C     *              THE NATIONAL SCIENCE FOUNDATION                  *          05DEC01.705
C     *                                                               *          05DEC01.706
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *          05DEC01.707
C                                                                                05DEC01.708
C                                                                                05DEC01.709
C                                                                                05DEC01.710
C DIMENSION OF           A(M),B(M),C(M),Y(IDIMY,N),                              05DEC01.711
C                        W(SEE PARAMETER LIST)                                   05DEC01.712
C ARGUMENTS                                                                      05DEC01.713
C                                                                                05DEC01.714
C LATEST REVISION        NOVEMBER 1988                                           05DEC01.715
C                                                                                05DEC01.716
C PURPOSE                THE NAME OF THIS PACKAGE IS A MNEMONIC FOR THE          05DEC01.717
C                        GENERALIZED BUNEMAN ALGORITHM.                          05DEC01.718
C                                                                                05DEC01.719
C                        IT SOLVES THE REAL LINEAR SYSTEM OF EQUATIONS           05DEC01.720
C                                                                                05DEC01.721
C                        A(I)*X(I-1,J) + B(I)*X(I,J) + C(I)*X(I+1,J)             05DEC01.722
C                        + X(I,J-1) - 2.*X(I,J) + X(I,J+1) = Y(I,J)              05DEC01.723
C                                                                                05DEC01.724
C                        FOR I = 1,2,...,M  AND  J = 1,2,...,N.                  05DEC01.725
C                                                                                05DEC01.726
C                        INDICES I+1 AND I-1 ARE EVALUATED MODULO M,             05DEC01.727
C                        I.E., X(0,J) = X(M,J) AND X(M+1,J) = X(1,J),            05DEC01.728
C                        AND X(I,0) MAY EQUAL 0, X(I,2), OR X(I,N),              05DEC01.729
C                        AND X(I,N+1) MAY EQUAL 0, X(I,N-1), OR X(I,1)           05DEC01.730
C                        DEPENDING ON AN INPUT PARAMETER.                        05DEC01.731
C                                                                                05DEC01.732
C USAGE                  CALL GENBUN (NPEROD,N,MPEROD,M,A,B,C,IDIMY,Y,           05DEC01.733
C                                     IERROR,W)                                  05DEC01.734
C                                                                                05DEC01.735
C ARGUMENTS                                                                      05DEC01.736
C                                                                                05DEC01.737
C ON INPUT               NPEROD                                                  05DEC01.738
C                                                                                05DEC01.739
C                          INDICATES THE VALUES THAT X(I,0) AND                  05DEC01.740
C                          X(I,N+1) ARE ASSUMED TO HAVE.                         05DEC01.741
C                                                                                05DEC01.742
C                          = 0  IF X(I,0) = X(I,N) AND X(I,N+1) =                05DEC01.743
C                               X(I,1).                                          05DEC01.744
C                          = 1  IF X(I,0) = X(I,N+1) = 0  .                      05DEC01.745
C                          = 2  IF X(I,0) = 0 AND X(I,N+1) = X(I,N-1).           05DEC01.746
C                          = 3  IF X(I,0) = X(I,2) AND X(I,N+1) =                05DEC01.747
C                               X(I,N-1).                                        05DEC01.748
C                          = 4  IF X(I,0) = X(I,2) AND X(I,N+1) = 0.             05DEC01.749
C                                                                                05DEC01.750
C                        N                                                       05DEC01.751
C                          THE NUMBER OF UNKNOWNS IN THE J-DIRECTION.            05DEC01.752
C                          N MUST BE GREATER THAN 2.                             05DEC01.753
C                                                                                05DEC01.754
C                        MPEROD                                                  05DEC01.755
C                          = 0 IF A(1) AND C(M) ARE NOT ZERO                     05DEC01.756
C                          = 1 IF A(1) = C(M) = 0                                05DEC01.757
C                                                                                05DEC01.758
C                        M                                                       05DEC01.759
C                          THE NUMBER OF UNKNOWNS IN THE I-DIRECTION.            05DEC01.760
C                          N MUST BE GREATER THAN 2.                             05DEC01.761
C                                                                                05DEC01.762
C                        A,B,C                                                   05DEC01.763
C                          ONE-DIMENSIONAL ARRAYS OF LENGTH M THAT               05DEC01.764
C                          SPECIFY THE COEFFICIENTS IN THE LINEAR                05DEC01.765
C                          EQUATIONS GIVEN ABOVE.  IF MPEROD = 0                 05DEC01.766
C                          THE ARRAY ELEMENTS MUST NOT DEPEND UPON               05DEC01.767
C                          THE INDEX I, BUT MUST BE CONSTANT.                    05DEC01.768
C                          SPECIFICALLY, THE SUBROUTINE CHECKS THE               05DEC01.769
C                          FOLLOWING CONDITION .                                 05DEC01.770
C                                                                                05DEC01.771
C                            A(I) = C(1)                                         05DEC01.772
C                            C(I) = C(1)                                         05DEC01.773
C                            B(I) = B(1)                                         05DEC01.774
C                                                                                05DEC01.775
C                          FOR I=1,2,...,M.                                      05DEC01.776
C                                                                                05DEC01.777
C                        IDIMY                                                   05DEC01.778
C                          THE ROW (OR FIRST) DIMENSION OF THE                   05DEC01.779
C                          TWO-DIMENSIONAL ARRAY Y AS IT APPEARS                 05DEC01.780
C                          IN THE PROGRAM CALLING GENBUN.                        05DEC01.781
C                          THIS PARAMETER IS USED TO SPECIFY THE                 05DEC01.782
C                          VARIABLE DIMENSION OF Y.                              05DEC01.783
C                          IDIMY MUST BE AT LEAST M.                             05DEC01.784
C                                                                                05DEC01.785
C                        Y                                                       05DEC01.786
C                          A TWO-DIMENSIONAL COMPLEX ARRAY THAT                  05DEC01.787
C                          SPECIFIES THE VALUES OF THE RIGHT SIDE                05DEC01.788
C                          OF THE LINEAR SYSTEM OF EQUATIONS GIVEN               05DEC01.789
C                          ABOVE.                                                05DEC01.790
C                          Y MUST BE DIMENSIONED AT LEAST M*N.                   05DEC01.791
C                                                                                05DEC01.792
C                        W                                                       05DEC01.793
C                          A ONE-DIMENSIONAL ARRAY THAT MUST                     05DEC01.794
C                          BE PROVIDED BY THE USER FOR WORK                      05DEC01.795
C                          SPACE.  W MAY REQUIRE UP TO 4*N +                     05DEC01.796
C                          (10 + INT(LOG2(N)))*M LOCATIONS.                      05DEC01.797
C                          THE ACTUAL NUMBER OF LOCATIONS USED IS                05DEC01.798
C                          COMPUTED BY GENBUN AND IS RETURNED IN                 05DEC01.799
C                          LOCATION W(1).                                        05DEC01.800
C                                                                                05DEC01.801
C                                                                                05DEC01.802
C  ON OUTPUT             Y                                                       05DEC01.803
C                                                                                05DEC01.804
C                          CONTAINS THE SOLUTION X.                              05DEC01.805
C                                                                                05DEC01.806
C                        IERROR                                                  05DEC01.807
C                          AN ERROR FLAG WHICH INDICATES INVALID                 05DEC01.808
C                          INPUT PARAMETERS  EXCEPT FOR NUMBER                   05DEC01.809
C                          ZERO, A SOLUTION IS NOT ATTEMPTED.                    05DEC01.810
C                                                                                05DEC01.811
C                          = 0  NO ERROR.                                        05DEC01.812
C                          = 1  M .LE. 2  .                                      05DEC01.813
C                          = 2  N .LE. 2                                         05DEC01.814
C                          = 3  IDIMY .LT. M                                     05DEC01.815
C                          = 4  NPEROD .LT. 0 OR NPEROD .GT. 4                   05DEC01.816
C                          = 5  MPEROD .LT. 0 OR MPEROD .GT. 1                   05DEC01.817
C                          = 6  A(I) .NE. C(1) OR C(I) .NE. C(1) OR              05DEC01.818
C                               B(I) .NE. B(1) FOR                               05DEC01.819
C                               SOME I=1,2,...,M.                                05DEC01.820
C                          = 7  A(1) .NE. 0 OR C(M) .NE. 0 AND                   05DEC01.821
C                                 MPEROD = 1                                     05DEC01.822
C                                                                                05DEC01.823
C                        W                                                       05DEC01.824
C                          W(1) CONTAINS THE REQUIRED LENGTH OF W.               05DEC01.825
C                                                                                05DEC01.826
C SPECIAL CONDITONS      NONE                                                    05DEC01.827
C                                                                                05DEC01.828
C I/O                    NONE                                                    05DEC01.829
C                                                                                05DEC01.830
C PRECISION              SINGLE                                                  05DEC01.831
C                                                                                05DEC01.832
C REQUIRED LIBRARY       COMF AND GNBNAUX FROM FISHPACK                          05DEC01.833
C FILES                                                                          05DEC01.834
C                                                                                05DEC01.835
C LANGUAGE               FORTRAN                                                 05DEC01.836
C                                                                                05DEC01.837
C HISTORY                WRITTEN IN 1979 BY ROLAND SWEET OF NCAR'S               05DEC01.838
C                        SCIENTIFIC COMPUTING DIVISION.  MADE AVAILABLE          05DEC01.839
C                        ON NCAR'S PUBLIC LIBRARIES IN JANUARY, 1980.            05DEC01.840
C                                                                                05DEC01.841
C ALGORITHM              THE LINEAR SYSTEM IS SOLVED BY A CYCLIC                 05DEC01.842
C                        REDUCTION ALGORITHM DESCRIBED IN THE                    05DEC01.843
C                        REFERENCE.                                              05DEC01.844
C                                                                                05DEC01.845
C PORTABILITY            FORTRAN 77 --                                           05DEC01.846
C                        THE MACHINE DEPENDENT CONSTANT PI IS                    05DEC01.847
C                        DEFINED IN FUNCTION PIMACH.                             05DEC01.848
C                                                                                05DEC01.849
C REFERENCES             SWEET, R., "A CYCLIC REDUCTION ALGORITHM FOR            05DEC01.850
C                        SOLVING BLOCK TRIDIAGONAL SYSTEMS OF ARBITRARY          05DEC01.851
C                        DIMENSIONS," SIAM J. ON NUMER. ANAL., 14 (1977)         05DEC01.852
C                        PP. 706-720.                                            05DEC01.853
C                                                                                05DEC01.854
C ACCURACY               THIS TEST WAS PERFORMED ON A CDC 7600:                  05DEC01.855
C                                                                                05DEC01.856
C                        A UNIFORM RANDOM NUMBER GENERATOR WAS USED              05DEC01.857
C                        TO CREATE A SOLUTION ARRAY X FOR THE SYSTEM             05DEC01.858
C                        GIVEN IN THE 'PURPOSE' DESCRIPTION ABOVE                05DEC01.859
C                        WITH                                                    05DEC01.860
C                          A(I) = C(I) = -0.5*B(I) = 1, I=1,2,...,M              05DEC01.861
C                                                                                05DEC01.862
C                        AND, WHEN MPEROD = 1                                    05DEC01.863
C                                                                                05DEC01.864
C                          A(1) = C(M) = 0                                       05DEC01.865
C                          A(M) = C(1) = 2.                                      05DEC01.866
C                                                                                05DEC01.867
C                        THE SOLUTION X WAS SUBSTITUTED INTO THE                 05DEC01.868
C                        GIVEN SYSTEM  AND, USING DOUBLE PRECISION               05DEC01.869
C                        A RIGHT SIDE Y WAS COMPUTED.                            05DEC01.870
C                        USING THIS ARRAY Y, SUBROUTINE GENBUN                   05DEC01.871
C                        WAS CALLED TO PRODUCE APPROXIMATE                       05DEC01.872
C                        SOLUTION Z.  THEN RELATIVE ERROR                        05DEC01.873
C                          E = MAX(ABS(Z(I,J)-X(I,J)))/                          05DEC01.874
C                              MAX(ABS(X(I,J)))                                  05DEC01.875
C                        WAS COMPUTED, WHERE THE TWO MAXIMA ARE TAKEN            05DEC01.876
C                        OVER I=1,2,...,M AND J=1,...,N.                         05DEC01.877
C                                                                                05DEC01.878
C                        THE VALUE OF E IS GIVEN IN THE TABLE                    05DEC01.879
C                        BELOW FOR SOME TYPICAL VALUES OF M AND N.               05DEC01.880
C                                                                                05DEC01.881
C                   M (=N)    MPEROD    NPEROD    T(MSECS)    E                  05DEC01.882
C                   ------    ------    ------    --------  ------               05DEC01.883
C                                                                                05DEC01.884
C                     31        0         0          36     6.E-14               05DEC01.885
C                     31        1         1          21     4.E-13               05DEC01.886
C                     31        1         3          41     3.E-13               05DEC01.887
C                     32        0         0          29     9.E-14               05DEC01.888
C                     32        1         1          32     3.E-13               05DEC01.889
C                     32        1         3          48     1.E-13               05DEC01.890
C                     33        0         0          36     9.E-14               05DEC01.891
C                     33        1         1          30     4.E-13               05DEC01.892
C                     33        1         3          34     1.E-13               05DEC01.893
C                     63        0         0         150     1.E-13               05DEC01.894
C                     63        1         1          91     1.E-12               05DEC01.895
C                     63        1         3         173     2.E-13               05DEC01.896
C                     64        0         0         122     1.E-13               05DEC01.897
C                     64        1         1         128     1.E-12               05DEC01.898
C                     64        1         3         199     6.E-13               05DEC01.899
C                     65        0         0         143     2.E-13               05DEC01.900
C                     65        1         1         120     1.E-12               05DEC01.901
C                     65        1         3         138     4.E-13               05DEC01.902
C * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *              05DEC01.903
      DIMENSION       Y(IDIMY,1)                                                 05DEC01.904
      DIMENSION       W(*)       ,B(*)       ,A(*)       ,C(*)                   05DEC01.905
C                                                                                05DEC01.906
      IERROR = 0                                                                 05DEC01.907
      IF (M .LE. 2) IERROR = 1                                                   05DEC01.908
      IF (N .LE. 2) IERROR = 2                                                   05DEC01.909
      IF (IDIMY .LT. M) IERROR = 3                                               05DEC01.910
      IF (NPEROD.LT.0 .OR. NPEROD.GT.4) IERROR = 4                               05DEC01.911
      IF (MPEROD.LT.0 .OR. MPEROD.GT.1) IERROR = 5                               05DEC01.912
      IF (MPEROD .EQ. 1) GO TO 102                                               05DEC01.913
      DO 101 I=2,M                                                               05DEC01.914
         IF (A(I) .NE. C(1)) GO TO 103                                           05DEC01.915
         IF (C(I) .NE. C(1)) GO TO 103                                           05DEC01.916
         IF (B(I) .NE. B(1)) GO TO 103                                           05DEC01.917
  101 CONTINUE                                                                   05DEC01.918
      GO TO 104                                                                  05DEC01.919
  102 IF (A(1).NE.0. .OR. C(M).NE.0.) IERROR = 7                                 05DEC01.920
      GO TO 104                                                                  05DEC01.921
  103 IERROR = 6                                                                 05DEC01.922
  104 IF (IERROR .NE. 0) RETURN                                                  05DEC01.923
      MP1 = M+1                                                                  05DEC01.924
      IWBA = MP1                                                                 05DEC01.925
      IWBB = IWBA+M                                                              05DEC01.926
      IWBC = IWBB+M                                                              05DEC01.927
      IWB2 = IWBC+M                                                              05DEC01.928
      IWB3 = IWB2+M                                                              05DEC01.929
      IWW1 = IWB3+M                                                              05DEC01.930
      IWW2 = IWW1+M                                                              05DEC01.931
      IWW3 = IWW2+M                                                              05DEC01.932
      IWD = IWW3+M                                                               05DEC01.933
      IWTCOS = IWD+M                                                             05DEC01.934
      IWP = IWTCOS+4*N                                                           05DEC01.935
      DO 106 I=1,M                                                               05DEC01.936
         K = IWBA+I-1                                                            05DEC01.937
         W(K) = -A(I)                                                            05DEC01.938
         K = IWBC+I-1                                                            05DEC01.939
         W(K) = -C(I)                                                            05DEC01.940
         K = IWBB+I-1                                                            05DEC01.941
         W(K) = 2.-B(I)                                                          05DEC01.942
         DO 105 J=1,N                                                            05DEC01.943
            Y(I,J) = -Y(I,J)                                                     05DEC01.944
  105    CONTINUE                                                                05DEC01.945
  106 CONTINUE                                                                   05DEC01.946
      MP = MPEROD+1                                                              05DEC01.947
      NP = NPEROD+1                                                              05DEC01.948
      GO TO (114,107),MP                                                         05DEC01.949
  107 GO TO (108,109,110,111,123),NP                                             05DEC01.950
  108 CALL POISP2 (M,N,W(IWBA),W(IWBB),W(IWBC),Y,IDIMY,W,W(IWB2),                05DEC01.951
     1             W(IWB3),W(IWW1),W(IWW2),W(IWW3),W(IWD),W(IWTCOS),             05DEC01.952
     2             W(IWP))                                                       05DEC01.953
      GO TO 112                                                                  05DEC01.954
  109 CALL POISD2 (M,N,1,W(IWBA),W(IWBB),W(IWBC),Y,IDIMY,W,W(IWW1),              05DEC01.955
     1             W(IWD),W(IWTCOS),W(IWP))                                      05DEC01.956
      GO TO 112                                                                  05DEC01.957
  110 CALL POISN2 (M,N,1,2,W(IWBA),W(IWBB),W(IWBC),Y,IDIMY,W,W(IWB2),            05DEC01.958
     1             W(IWB3),W(IWW1),W(IWW2),W(IWW3),W(IWD),W(IWTCOS),             05DEC01.959
     2             W(IWP))                                                       05DEC01.960
      GO TO 112                                                                  05DEC01.961
  111 CALL POISN2 (M,N,1,1,W(IWBA),W(IWBB),W(IWBC),Y,IDIMY,W,W(IWB2),            05DEC01.962
     1             W(IWB3),W(IWW1),W(IWW2),W(IWW3),W(IWD),W(IWTCOS),             05DEC01.963
     2             W(IWP))                                                       05DEC01.964
  112 IPSTOR = W(IWW1)                                                           05DEC01.965
      IREV = 2                                                                   05DEC01.966
      IF (NPEROD .EQ. 4) GO TO 124                                               05DEC01.967
  113 GO TO (127,133),MP                                                         05DEC01.968
  114 CONTINUE                                                                   05DEC01.969
C                                                                                05DEC01.970
C     REORDER UNKNOWNS WHEN MP =0                                                05DEC01.971
C                                                                                05DEC01.972
      MH = (M+1)/2                                                               05DEC01.973
      MHM1 = MH-1                                                                05DEC01.974
      MODD = 1                                                                   05DEC01.975
      IF (MH*2 .EQ. M) MODD = 2                                                  05DEC01.976
      DO 119 J=1,N                                                               05DEC01.977
         DO 115 I=1,MHM1                                                         05DEC01.978
            MHPI = MH+I                                                          05DEC01.979
            MHMI = MH-I                                                          05DEC01.980
            W(I) = Y(MHMI,J)-Y(MHPI,J)                                           05DEC01.981
            W(MHPI) = Y(MHMI,J)+Y(MHPI,J)                                        05DEC01.982
  115    CONTINUE                                                                05DEC01.983
         W(MH) = 2.*Y(MH,J)                                                      05DEC01.984
         GO TO (117,116),MODD                                                    05DEC01.985
  116    W(M) = 2.*Y(M,J)                                                        05DEC01.986
  117    CONTINUE                                                                05DEC01.987
         DO 118 I=1,M                                                            05DEC01.988
            Y(I,J) = W(I)                                                        05DEC01.989
  118    CONTINUE                                                                05DEC01.990
  119 CONTINUE                                                                   05DEC01.991
      K = IWBC+MHM1-1                                                            05DEC01.992
      I = IWBA+MHM1                                                              05DEC01.993
      W(K) = 0.                                                                  05DEC01.994
      W(I) = 0.                                                                  05DEC01.995
      W(K+1) = 2.*W(K+1)                                                         05DEC01.996
      GO TO (120,121),MODD                                                       05DEC01.997
  120 CONTINUE                                                                   05DEC01.998
      K = IWBB+MHM1-1                                                            05DEC01.999
      W(K) = W(K)-W(I-1)                                                         05DEC01.1000
      W(IWBC-1) = W(IWBC-1)+W(IWBB-1)                                            05DEC01.1001
      GO TO 122                                                                  05DEC01.1002
  121 W(IWBB-1) = W(K+1)                                                         05DEC01.1003
  122 CONTINUE                                                                   05DEC01.1004
      GO TO 107                                                                  05DEC01.1005
C                                                                                05DEC01.1006
C     REVERSE COLUMNS WHEN NPEROD = 4.                                           05DEC01.1007
C                                                                                05DEC01.1008
  123 IREV = 1                                                                   05DEC01.1009
      NBY2 = N/2                                                                 05DEC01.1010
  124 DO 126 J=1,NBY2                                                            05DEC01.1011
         MSKIP = N+1-J                                                           05DEC01.1012
         DO 125 I=1,M                                                            05DEC01.1013
            A1 = Y(I,J)                                                          05DEC01.1014
            Y(I,J) = Y(I,MSKIP)                                                  05DEC01.1015
            Y(I,MSKIP) = A1                                                      05DEC01.1016
  125    CONTINUE                                                                05DEC01.1017
  126 CONTINUE                                                                   05DEC01.1018
      GO TO (110,113),IREV                                                       05DEC01.1019
  127 CONTINUE                                                                   05DEC01.1020
      DO 132 J=1,N                                                               05DEC01.1021
         DO 128 I=1,MHM1                                                         05DEC01.1022
            MHMI = MH-I                                                          05DEC01.1023
            MHPI = MH+I                                                          05DEC01.1024
            W(MHMI) = .5*(Y(MHPI,J)+Y(I,J))                                      05DEC01.1025
            W(MHPI) = .5*(Y(MHPI,J)-Y(I,J))                                      05DEC01.1026
  128    CONTINUE                                                                05DEC01.1027
         W(MH) = .5*Y(MH,J)                                                      05DEC01.1028
         GO TO (130,129),MODD                                                    05DEC01.1029
  129    W(M) = .5*Y(M,J)                                                        05DEC01.1030
  130    CONTINUE                                                                05DEC01.1031
         DO 131 I=1,M                                                            05DEC01.1032
            Y(I,J) = W(I)                                                        05DEC01.1033
  131    CONTINUE                                                                05DEC01.1034
  132 CONTINUE                                                                   05DEC01.1035
  133 CONTINUE                                                                   05DEC01.1036
C                                                                                05DEC01.1037
C     RETURN STORAGE REQUIREMENTS FOR W ARRAY.                                   05DEC01.1038
C                                                                                05DEC01.1039
      W(1) = IPSTOR+IWP-1                                                        05DEC01.1040
      RETURN                                                                     05DEC01.1041
      END                                                                        05DEC01.1042
      SUBROUTINE POISD2 (MR,NR,ISTAG,BA,BB,BC,Q,IDIMQ,B,W,D,TCOS,P)              05DEC01.1043
C                                                                                05DEC01.1044
C     SUBROUTINE TO SOLVE POISSON'S EQUATION FOR DIRICHLET BOUNDARY              05DEC01.1045
C     CONDITIONS.                                                                05DEC01.1046
C                                                                                05DEC01.1047
C     ISTAG = 1 IF THE LAST DIAGONAL BLOCK IS THE MATRIX A.                      05DEC01.1048
C     ISTAG = 2 IF THE LAST DIAGONAL BLOCK IS THE MATRIX A+I.                    05DEC01.1049
C                                                                                05DEC01.1050
      DIMENSION       Q(IDIMQ,1) ,BA(*)      ,BB(*)      ,BC(*)      ,           05DEC01.1051
     1                TCOS(*)    ,B(*)       ,D(*)       ,W(*)       ,           05DEC01.1052
     2                P(*)                                                       05DEC01.1053
      M = MR                                                                     05DEC01.1054
      N = NR                                                                     05DEC01.1055
      JSH = 0                                                                    05DEC01.1056
      FI = 1./FLOAT(ISTAG)                                                       05DEC01.1057
      IP = -M                                                                    05DEC01.1058
      IPSTOR = 0                                                                 05DEC01.1059
      GO TO (101,102),ISTAG                                                      05DEC01.1060
  101 KR = 0                                                                     05DEC01.1061
      IRREG = 1                                                                  05DEC01.1062
      IF (N .GT. 1) GO TO 106                                                    05DEC01.1063
      TCOS(1) = 0.                                                               05DEC01.1064
      GO TO 103                                                                  05DEC01.1065
  102 KR = 1                                                                     05DEC01.1066
      JSTSAV = 1                                                                 05DEC01.1067
      IRREG = 2                                                                  05DEC01.1068
      IF (N .GT. 1) GO TO 106                                                    05DEC01.1069
      TCOS(1) = -1.                                                              05DEC01.1070
  103 DO 104 I=1,M                                                               05DEC01.1071
         B(I) = Q(I,1)                                                           05DEC01.1072
  104 CONTINUE                                                                   05DEC01.1073
      CALL TRIX (1,0,M,BA,BB,BC,B,TCOS,D,W)                                      05DEC01.1074
      DO 105 I=1,M                                                               05DEC01.1075
         Q(I,1) = B(I)                                                           05DEC01.1076
  105 CONTINUE                                                                   05DEC01.1077
      GO TO 183                                                                  05DEC01.1078
  106 LR = 0                                                                     05DEC01.1079
      DO 107 I=1,M                                                               05DEC01.1080
         P(I) = 0.                                                               05DEC01.1081
  107 CONTINUE                                                                   05DEC01.1082
      NUN = N                                                                    05DEC01.1083
      JST = 1                                                                    05DEC01.1084
      JSP = N                                                                    05DEC01.1085
C                                                                                05DEC01.1086
C     IRREG = 1 WHEN NO IRREGULARITIES HAVE OCCURRED, OTHERWISE IT IS 2.         05DEC01.1087
C                                                                                05DEC01.1088
  108 L = 2*JST                                                                  05DEC01.1089
      NODD = 2-2*((NUN+1)/2)+NUN                                                 05DEC01.1090
C                                                                                05DEC01.1091
C     NODD = 1 WHEN NUN IS ODD, OTHERWISE IT IS 2.                               05DEC01.1092
C                                                                                05DEC01.1093
      GO TO (110,109),NODD                                                       05DEC01.1094
  109 JSP = JSP-L                                                                05DEC01.1095
      GO TO 111                                                                  05DEC01.1096
  110 JSP = JSP-JST                                                              05DEC01.1097
      IF (IRREG .NE. 1) JSP = JSP-L                                              05DEC01.1098
  111 CONTINUE                                                                   05DEC01.1099
C                                                                                05DEC01.1100
C     REGULAR REDUCTION                                                          05DEC01.1101
C                                                                                05DEC01.1102
      CALL COSGEN (JST,1,0.5,0.0,TCOS)                                           05DEC01.1103
      IF (L .GT. JSP) GO TO 118                                                  05DEC01.1104
      DO 117 J=L,JSP,L                                                           05DEC01.1105
         JM1 = J-JSH                                                             05DEC01.1106
         JP1 = J+JSH                                                             05DEC01.1107
         JM2 = J-JST                                                             05DEC01.1108
         JP2 = J+JST                                                             05DEC01.1109
         JM3 = JM2-JSH                                                           05DEC01.1110
         JP3 = JP2+JSH                                                           05DEC01.1111
         IF (JST .NE. 1) GO TO 113                                               05DEC01.1112
         DO 112 I=1,M                                                            05DEC01.1113
            B(I) = 2.*Q(I,J)                                                     05DEC01.1114
            Q(I,J) = Q(I,JM2)+Q(I,JP2)                                           05DEC01.1115
  112    CONTINUE                                                                05DEC01.1116
         GO TO 115                                                               05DEC01.1117
  113    DO 114 I=1,M                                                            05DEC01.1118
            T = Q(I,J)-Q(I,JM1)-Q(I,JP1)+Q(I,JM2)+Q(I,JP2)                       05DEC01.1119
            B(I) = T+Q(I,J)-Q(I,JM3)-Q(I,JP3)                                    05DEC01.1120
            Q(I,J) = T                                                           05DEC01.1121
  114    CONTINUE                                                                05DEC01.1122
  115    CONTINUE                                                                05DEC01.1123
         CALL TRIX (JST,0,M,BA,BB,BC,B,TCOS,D,W)                                 05DEC01.1124
         DO 116 I=1,M                                                            05DEC01.1125
            Q(I,J) = Q(I,J)+B(I)                                                 05DEC01.1126
  116    CONTINUE                                                                05DEC01.1127
  117 CONTINUE                                                                   05DEC01.1128
C                                                                                05DEC01.1129
C     REDUCTION FOR LAST UNKNOWN                                                 05DEC01.1130
C                                                                                05DEC01.1131
  118 GO TO (119,136),NODD                                                       05DEC01.1132
  119 GO TO (152,120),IRREG                                                      05DEC01.1133
C                                                                                05DEC01.1134
C     ODD NUMBER OF UNKNOWNS                                                     05DEC01.1135
C                                                                                05DEC01.1136
  120 JSP = JSP+L                                                                05DEC01.1137
      J = JSP                                                                    05DEC01.1138
      JM1 = J-JSH                                                                05DEC01.1139
      JP1 = J+JSH                                                                05DEC01.1140
      JM2 = J-JST                                                                05DEC01.1141
      JP2 = J+JST                                                                05DEC01.1142
      JM3 = JM2-JSH                                                              05DEC01.1143
      GO TO (123,121),ISTAG                                                      05DEC01.1144
  121 CONTINUE                                                                   05DEC01.1145
      IF (JST .NE. 1) GO TO 123                                                  05DEC01.1146
      DO 122 I=1,M                                                               05DEC01.1147
         B(I) = Q(I,J)                                                           05DEC01.1148
         Q(I,J) = 0.                                                             05DEC01.1149
  122 CONTINUE                                                                   05DEC01.1150
      GO TO 130                                                                  05DEC01.1151
  123 GO TO (124,126),NODDPR                                                     05DEC01.1152
  124 DO 125 I=1,M                                                               05DEC01.1153
         IP1 = IP+I                                                              05DEC01.1154
         B(I) = .5*(Q(I,JM2)-Q(I,JM1)-Q(I,JM3))+P(IP1)+Q(I,J)                    05DEC01.1155
  125 CONTINUE                                                                   05DEC01.1156
      GO TO 128                                                                  05DEC01.1157
  126 DO 127 I=1,M                                                               05DEC01.1158
         B(I) = .5*(Q(I,JM2)-Q(I,JM1)-Q(I,JM3))+Q(I,JP2)-Q(I,JP1)+Q(I,J)         05DEC01.1159
  127 CONTINUE                                                                   05DEC01.1160
  128 DO 129 I=1,M                                                               05DEC01.1161
         Q(I,J) = .5*(Q(I,J)-Q(I,JM1)-Q(I,JP1))                                  05DEC01.1162
  129 CONTINUE                                                                   05DEC01.1163
  130 CALL TRIX (JST,0,M,BA,BB,BC,B,TCOS,D,W)                                    05DEC01.1164
      IP = IP+M                                                                  05DEC01.1165
      IPSTOR = MAX0(IPSTOR,IP+M)                                                 05DEC01.1166
      DO 131 I=1,M                                                               05DEC01.1167
         IP1 = IP+I                                                              05DEC01.1168
         P(IP1) = Q(I,J)+B(I)                                                    05DEC01.1169
         B(I) = Q(I,JP2)+P(IP1)                                                  05DEC01.1170
  131 CONTINUE                                                                   05DEC01.1171
      IF (LR .NE. 0) GO TO 133                                                   05DEC01.1172
      DO 132 I=1,JST                                                             05DEC01.1173
         KRPI = KR+I                                                             05DEC01.1174
         TCOS(KRPI) = TCOS(I)                                                    05DEC01.1175
  132 CONTINUE                                                                   05DEC01.1176
      GO TO 134                                                                  05DEC01.1177
  133 CONTINUE                                                                   05DEC01.1178
      CALL COSGEN (LR,JSTSAV,0.,FI,TCOS(JST+1))                                  05DEC01.1179
      CALL MERGE (TCOS,0,JST,JST,LR,KR)                                          05DEC01.1180
  134 CONTINUE                                                                   05DEC01.1181
      CALL COSGEN (KR,JSTSAV,0.0,FI,TCOS)                                        05DEC01.1182
      CALL TRIX (KR,KR,M,BA,BB,BC,B,TCOS,D,W)                                    05DEC01.1183
      DO 135 I=1,M                                                               05DEC01.1184
         IP1 = IP+I                                                              05DEC01.1185
         Q(I,J) = Q(I,JM2)+B(I)+P(IP1)                                           05DEC01.1186
  135 CONTINUE                                                                   05DEC01.1187
      LR = KR                                                                    05DEC01.1188
      KR = KR+L                                                                  05DEC01.1189
      GO TO 152                                                                  05DEC01.1190
C                                                                                05DEC01.1191
C     EVEN NUMBER OF UNKNOWNS                                                    05DEC01.1192
C                                                                                05DEC01.1193
  136 JSP = JSP+L                                                                05DEC01.1194
      J = JSP                                                                    05DEC01.1195
      JM1 = J-JSH                                                                05DEC01.1196
      JP1 = J+JSH                                                                05DEC01.1197
      JM2 = J-JST                                                                05DEC01.1198
      JP2 = J+JST                                                                05DEC01.1199
      JM3 = JM2-JSH                                                              05DEC01.1200
      GO TO (137,138),IRREG                                                      05DEC01.1201
  137 CONTINUE                                                                   05DEC01.1202
      JSTSAV = JST                                                               05DEC01.1203
      IDEG = JST                                                                 05DEC01.1204
      KR = L                                                                     05DEC01.1205
      GO TO 139                                                                  05DEC01.1206
  138 CALL COSGEN (KR,JSTSAV,0.0,FI,TCOS)                                        05DEC01.1207
      CALL COSGEN (LR,JSTSAV,0.0,FI,TCOS(KR+1))                                  05DEC01.1208
      IDEG = KR                                                                  05DEC01.1209
      KR = KR+JST                                                                05DEC01.1210
  139 IF (JST .NE. 1) GO TO 141                                                  05DEC01.1211
      IRREG = 2                                                                  05DEC01.1212
      DO 140 I=1,M                                                               05DEC01.1213
         B(I) = Q(I,J)                                                           05DEC01.1214
         Q(I,J) = Q(I,JM2)                                                       05DEC01.1215
  140 CONTINUE                                                                   05DEC01.1216
      GO TO 150                                                                  05DEC01.1217
  141 DO 142 I=1,M                                                               05DEC01.1218
         B(I) = Q(I,J)+.5*(Q(I,JM2)-Q(I,JM1)-Q(I,JM3))                           05DEC01.1219
  142 CONTINUE                                                                   05DEC01.1220
      GO TO (143,145),IRREG                                                      05DEC01.1221
  143 DO 144 I=1,M                                                               05DEC01.1222
         Q(I,J) = Q(I,JM2)+.5*(Q(I,J)-Q(I,JM1)-Q(I,JP1))                         05DEC01.1223
  144 CONTINUE                                                                   05DEC01.1224
      IRREG = 2                                                                  05DEC01.1225
      GO TO 150                                                                  05DEC01.1226
  145 CONTINUE                                                                   05DEC01.1227
      GO TO (146,148),NODDPR                                                     05DEC01.1228
  146 DO 147 I=1,M                                                               05DEC01.1229
         IP1 = IP+I                                                              05DEC01.1230
         Q(I,J) = Q(I,JM2)+P(IP1)                                                05DEC01.1231
  147 CONTINUE                                                                   05DEC01.1232
      IP = IP-M                                                                  05DEC01.1233
      GO TO 150                                                                  05DEC01.1234
  148 DO 149 I=1,M                                                               05DEC01.1235
         Q(I,J) = Q(I,JM2)+Q(I,J)-Q(I,JM1)                                       05DEC01.1236
  149 CONTINUE                                                                   05DEC01.1237
  150 CALL TRIX (IDEG,LR,M,BA,BB,BC,B,TCOS,D,W)                                  05DEC01.1238
      DO 151 I=1,M                                                               05DEC01.1239
         Q(I,J) = Q(I,J)+B(I)                                                    05DEC01.1240
  151 CONTINUE                                                                   05DEC01.1241
  152 NUN = NUN/2                                                                05DEC01.1242
      NODDPR = NODD                                                              05DEC01.1243
      JSH = JST                                                                  05DEC01.1244
      JST = 2*JST                                                                05DEC01.1245
      IF (NUN .GE. 2) GO TO 108                                                  05DEC01.1246
C                                                                                05DEC01.1247
C     START SOLUTION.                                                            05DEC01.1248
C                                                                                05DEC01.1249
      J = JSP                                                                    05DEC01.1250
      DO 153 I=1,M                                                               05DEC01.1251
         B(I) = Q(I,J)                                                           05DEC01.1252
  153 CONTINUE                                                                   05DEC01.1253
      GO TO (154,155),IRREG                                                      05DEC01.1254
  154 CONTINUE                                                                   05DEC01.1255
      CALL COSGEN (JST,1,0.5,0.0,TCOS)                                           05DEC01.1256
      IDEG = JST                                                                 05DEC01.1257
      GO TO 156                                                                  05DEC01.1258
  155 KR = LR+JST                                                                05DEC01.1259
      CALL COSGEN (KR,JSTSAV,0.0,FI,TCOS)                                        05DEC01.1260
      CALL COSGEN (LR,JSTSAV,0.0,FI,TCOS(KR+1))                                  05DEC01.1261
      IDEG = KR                                                                  05DEC01.1262
  156 CONTINUE                                                                   05DEC01.1263
      CALL TRIX (IDEG,LR,M,BA,BB,BC,B,TCOS,D,W)                                  05DEC01.1264
      JM1 = J-JSH                                                                05DEC01.1265
      JP1 = J+JSH                                                                05DEC01.1266
      GO TO (157,159),IRREG                                                      05DEC01.1267
  157 DO 158 I=1,M                                                               05DEC01.1268
         Q(I,J) = .5*(Q(I,J)-Q(I,JM1)-Q(I,JP1))+B(I)                             05DEC01.1269
  158 CONTINUE                                                                   05DEC01.1270
      GO TO 164                                                                  05DEC01.1271
  159 GO TO (160,162),NODDPR                                                     05DEC01.1272
  160 DO 161 I=1,M                                                               05DEC01.1273
         IP1 = IP+I                                                              05DEC01.1274
         Q(I,J) = P(IP1)+B(I)                                                    05DEC01.1275
  161 CONTINUE                                                                   05DEC01.1276
      IP = IP-M                                                                  05DEC01.1277
      GO TO 164                                                                  05DEC01.1278
  162 DO 163 I=1,M                                                               05DEC01.1279
         Q(I,J) = Q(I,J)-Q(I,JM1)+B(I)                                           05DEC01.1280
  163 CONTINUE                                                                   05DEC01.1281
  164 CONTINUE                                                                   05DEC01.1282
C                                                                                05DEC01.1283
C     START BACK SUBSTITUTION.                                                   05DEC01.1284
C                                                                                05DEC01.1285
      JST = JST/2                                                                05DEC01.1286
      JSH = JST/2                                                                05DEC01.1287
      NUN = 2*NUN                                                                05DEC01.1288
      IF (NUN .GT. N) GO TO 183                                                  05DEC01.1289
      DO 182 J=JST,N,L                                                           05DEC01.1290
         JM1 = J-JSH                                                             05DEC01.1291
         JP1 = J+JSH                                                             05DEC01.1292
         JM2 = J-JST                                                             05DEC01.1293
         JP2 = J+JST                                                             05DEC01.1294
         IF (J .GT. JST) GO TO 166                                               05DEC01.1295
         DO 165 I=1,M                                                            05DEC01.1296
            B(I) = Q(I,J)+Q(I,JP2)                                               05DEC01.1297
  165    CONTINUE                                                                05DEC01.1298
         GO TO 170                                                               05DEC01.1299
  166    IF (JP2 .LE. N) GO TO 168                                               05DEC01.1300
         DO 167 I=1,M                                                            05DEC01.1301
            B(I) = Q(I,J)+Q(I,JM2)                                               05DEC01.1302
  167    CONTINUE                                                                05DEC01.1303
         IF (JST .LT. JSTSAV) IRREG = 1                                          05DEC01.1304
         GO TO (170,171),IRREG                                                   05DEC01.1305
  168    DO 169 I=1,M                                                            05DEC01.1306
            B(I) = Q(I,J)+Q(I,JM2)+Q(I,JP2)                                      05DEC01.1307
  169    CONTINUE                                                                05DEC01.1308
  170    CONTINUE                                                                05DEC01.1309
         CALL COSGEN (JST,1,0.5,0.0,TCOS)                                        05DEC01.1310
         IDEG = JST                                                              05DEC01.1311
         JDEG = 0                                                                05DEC01.1312
         GO TO 172                                                               05DEC01.1313
  171    IF (J+L .GT. N) LR = LR-JST                                             05DEC01.1314
         KR = JST+LR                                                             05DEC01.1315
         CALL COSGEN (KR,JSTSAV,0.0,FI,TCOS)                                     05DEC01.1316
         CALL COSGEN (LR,JSTSAV,0.0,FI,TCOS(KR+1))                               05DEC01.1317
         IDEG = KR                                                               05DEC01.1318
         JDEG = LR                                                               05DEC01.1319
  172    CONTINUE                                                                05DEC01.1320
         CALL TRIX (IDEG,JDEG,M,BA,BB,BC,B,TCOS,D,W)                             05DEC01.1321
         IF (JST .GT. 1) GO TO 174                                               05DEC01.1322
         DO 173 I=1,M                                                            05DEC01.1323
            Q(I,J) = B(I)                                                        05DEC01.1324
  173    CONTINUE                                                                05DEC01.1325
         GO TO 182                                                               05DEC01.1326
  174    IF (JP2 .GT. N) GO TO 177                                               05DEC01.1327
  175    DO 176 I=1,M                                                            05DEC01.1328
            Q(I,J) = .5*(Q(I,J)-Q(I,JM1)-Q(I,JP1))+B(I)                          05DEC01.1329
  176    CONTINUE                                                                05DEC01.1330
         GO TO 182                                                               05DEC01.1331
  177    GO TO (175,178),IRREG                                                   05DEC01.1332
  178    IF (J+JSH .GT. N) GO TO 180                                             05DEC01.1333
         DO 179 I=1,M                                                            05DEC01.1334
            IP1 = IP+I                                                           05DEC01.1335
            Q(I,J) = B(I)+P(IP1)                                                 05DEC01.1336
  179    CONTINUE                                                                05DEC01.1337
         IP = IP-M                                                               05DEC01.1338
         GO TO 182                                                               05DEC01.1339
  180    DO 181 I=1,M                                                            05DEC01.1340
            Q(I,J) = B(I)+Q(I,J)-Q(I,JM1)                                        05DEC01.1341
  181    CONTINUE                                                                05DEC01.1342
  182 CONTINUE                                                                   05DEC01.1343
      L = L/2                                                                    05DEC01.1344
      GO TO 164                                                                  05DEC01.1345
  183 CONTINUE                                                                   05DEC01.1346
C                                                                                05DEC01.1347
C     RETURN STORAGE REQUIREMENTS FOR P VECTORS.                                 05DEC01.1348
C                                                                                05DEC01.1349
      W(1) = IPSTOR                                                              05DEC01.1350
      RETURN                                                                     05DEC01.1351
      END                                                                        05DEC01.1352
      SUBROUTINE POISN2 (M,N,ISTAG,MIXBND,A,BB,C,Q,IDIMQ,B,B2,B3,W,W2,           05DEC01.1353
     1                   W3,D,TCOS,P)                                            05DEC01.1354
C                                                                                05DEC01.1355
C     SUBROUTINE TO SOLVE POISSON'S EQUATION WITH NEUMANN BOUNDARY               05DEC01.1356
C     CONDITIONS.                                                                05DEC01.1357
C                                                                                05DEC01.1358
C     ISTAG = 1 IF THE LAST DIAGONAL BLOCK IS A.                                 05DEC01.1359
C     ISTAG = 2 IF THE LAST DIAGONAL BLOCK IS A-I.                               05DEC01.1360
C     MIXBND = 1 IF HAVE NEUMANN BOUNDARY CONDITIONS AT BOTH BOUNDARIES.         05DEC01.1361
C     MIXBND = 2 IF HAVE NEUMANN BOUNDARY CONDITIONS AT BOTTOM AND               05DEC01.1362
C     DIRICHLET CONDITION AT TOP.  (FOR THIS CASE, MUST HAVE ISTAG = 1.)         05DEC01.1363
C                                                                                05DEC01.1364
      DIMENSION       A(*)       ,BB(*)      ,C(*)       ,Q(IDIMQ,1) ,           05DEC01.1365
     1                B(*)       ,B2(*)      ,B3(*)      ,W(*)       ,           05DEC01.1366
     2                W2(*)      ,W3(*)      ,D(*)       ,TCOS(*)    ,           05DEC01.1367
     3                K(4)       ,P(*)                                           05DEC01.1368
      EQUIVALENCE     (K(1),K1)  ,(K(2),K2)  ,(K(3),K3)  ,(K(4),K4)              05DEC01.1369
      FISTAG = 3-ISTAG                                                           05DEC01.1370
      FNUM = 1./FLOAT(ISTAG)                                                     05DEC01.1371
      FDEN = 0.5*FLOAT(ISTAG-1)                                                  05DEC01.1372
      MR = M                                                                     05DEC01.1373
      IP = -MR                                                                   05DEC01.1374
      IPSTOR = 0                                                                 05DEC01.1375
      I2R = 1                                                                    05DEC01.1376
      JR = 2                                                                     05DEC01.1377
      NR = N                                                                     05DEC01.1378
      NLAST = N                                                                  05DEC01.1379
      KR = 1                                                                     05DEC01.1380
      LR = 0                                                                     05DEC01.1381
      GO TO (101,103),ISTAG                                                      05DEC01.1382
  101 CONTINUE                                                                   05DEC01.1383
      DO 102 I=1,MR                                                              05DEC01.1384
         Q(I,N) = .5*Q(I,N)                                                      05DEC01.1385
  102 CONTINUE                                                                   05DEC01.1386
      GO TO (103,104),MIXBND                                                     05DEC01.1387
  103 IF (N .LE. 3) GO TO 155                                                    05DEC01.1388
  104 CONTINUE                                                                   05DEC01.1389
      JR = 2*I2R                                                                 05DEC01.1390
      NROD = 1                                                                   05DEC01.1391
      IF ((NR/2)*2 .EQ. NR) NROD = 0                                             05DEC01.1392
      GO TO (105,106),MIXBND                                                     05DEC01.1393
  105 JSTART = 1                                                                 05DEC01.1394
      GO TO 107                                                                  05DEC01.1395
  106 JSTART = JR                                                                05DEC01.1396
      NROD = 1-NROD                                                              05DEC01.1397
  107 CONTINUE                                                                   05DEC01.1398
      JSTOP = NLAST-JR                                                           05DEC01.1399
      IF (NROD .EQ. 0) JSTOP = JSTOP-I2R                                         05DEC01.1400
      CALL COSGEN (I2R,1,0.5,0.0,TCOS)                                           05DEC01.1401
      I2RBY2 = I2R/2                                                             05DEC01.1402
      IF (JSTOP .GE. JSTART) GO TO 108                                           05DEC01.1403
      J = JR                                                                     05DEC01.1404
      GO TO 116                                                                  05DEC01.1405
  108 CONTINUE                                                                   05DEC01.1406
C                                                                                05DEC01.1407
C     REGULAR REDUCTION.                                                         05DEC01.1408
C                                                                                05DEC01.1409
      DO 115 J=JSTART,JSTOP,JR                                                   05DEC01.1410
         JP1 = J+I2RBY2                                                          05DEC01.1411
         JP2 = J+I2R                                                             05DEC01.1412
         JP3 = JP2+I2RBY2                                                        05DEC01.1413
         JM1 = J-I2RBY2                                                          05DEC01.1414
         JM2 = J-I2R                                                             05DEC01.1415
         JM3 = JM2-I2RBY2                                                        05DEC01.1416
         IF (J .NE. 1) GO TO 109                                                 05DEC01.1417
         JM1 = JP1                                                               05DEC01.1418
         JM2 = JP2                                                               05DEC01.1419
         JM3 = JP3                                                               05DEC01.1420
  109    CONTINUE                                                                05DEC01.1421
         IF (I2R .NE. 1) GO TO 111                                               05DEC01.1422
         IF (J .EQ. 1) JM2 = JP2                                                 05DEC01.1423
         DO 110 I=1,MR                                                           05DEC01.1424
            B(I) = 2.*Q(I,J)                                                     05DEC01.1425
            Q(I,J) = Q(I,JM2)+Q(I,JP2)                                           05DEC01.1426
  110    CONTINUE                                                                05DEC01.1427
         GO TO 113                                                               05DEC01.1428
  111    CONTINUE                                                                05DEC01.1429
         DO 112 I=1,MR                                                           05DEC01.1430
            FI = Q(I,J)                                                          05DEC01.1431
            Q(I,J) = Q(I,J)-Q(I,JM1)-Q(I,JP1)+Q(I,JM2)+Q(I,JP2)                  05DEC01.1432
            B(I) = FI+Q(I,J)-Q(I,JM3)-Q(I,JP3)                                   05DEC01.1433
  112    CONTINUE                                                                05DEC01.1434
  113    CONTINUE                                                                05DEC01.1435
         CALL TRIX (I2R,0,MR,A,BB,C,B,TCOS,D,W)                                  05DEC01.1436
         DO 114 I=1,MR                                                           05DEC01.1437
            Q(I,J) = Q(I,J)+B(I)                                                 05DEC01.1438
  114    CONTINUE                                                                05DEC01.1439
C                                                                                05DEC01.1440
C     END OF REDUCTION FOR REGULAR UNKNOWNS.                                     05DEC01.1441
C                                                                                05DEC01.1442
  115 CONTINUE                                                                   05DEC01.1443
C                                                                                05DEC01.1444
C     BEGIN SPECIAL REDUCTION FOR LAST UNKNOWN.                                  05DEC01.1445
C                                                                                05DEC01.1446
      J = JSTOP+JR                                                               05DEC01.1447
  116 NLAST = J                                                                  05DEC01.1448
      JM1 = J-I2RBY2                                                             05DEC01.1449
      JM2 = J-I2R                                                                05DEC01.1450
      JM3 = JM2-I2RBY2                                                           05DEC01.1451
      IF (NROD .EQ. 0) GO TO 128                                                 05DEC01.1452
C                                                                                05DEC01.1453
C     ODD NUMBER OF UNKNOWNS                                                     05DEC01.1454
C                                                                                05DEC01.1455
      IF (I2R .NE. 1) GO TO 118                                                  05DEC01.1456
      DO 117 I=1,MR                                                              05DEC01.1457
         B(I) = FISTAG*Q(I,J)                                                    05DEC01.1458
         Q(I,J) = Q(I,JM2)                                                       05DEC01.1459
  117 CONTINUE                                                                   05DEC01.1460
      GO TO 126                                                                  05DEC01.1461
  118 DO 119 I=1,MR                                                              05DEC01.1462
         B(I) = Q(I,J)+.5*(Q(I,JM2)-Q(I,JM1)-Q(I,JM3))                           05DEC01.1463
  119 CONTINUE                                                                   05DEC01.1464
      IF (NRODPR .NE. 0) GO TO 121                                               05DEC01.1465
      DO 120 I=1,MR                                                              05DEC01.1466
         II = IP+I                                                               05DEC01.1467
         Q(I,J) = Q(I,JM2)+P(II)                                                 05DEC01.1468
  120 CONTINUE                                                                   05DEC01.1469
      IP = IP-MR                                                                 05DEC01.1470
      GO TO 123                                                                  05DEC01.1471
  121 CONTINUE                                                                   05DEC01.1472
      DO 122 I=1,MR                                                              05DEC01.1473
         Q(I,J) = Q(I,J)-Q(I,JM1)+Q(I,JM2)                                       05DEC01.1474
  122 CONTINUE                                                                   05DEC01.1475
  123 IF (LR .EQ. 0) GO TO 124                                                   05DEC01.1476
      CALL COSGEN (LR,1,0.5,FDEN,TCOS(KR+1))                                     05DEC01.1477
      GO TO 126                                                                  05DEC01.1478
  124 CONTINUE                                                                   05DEC01.1479
      DO 125 I=1,MR                                                              05DEC01.1480
         B(I) = FISTAG*B(I)                                                      05DEC01.1481
  125 CONTINUE                                                                   05DEC01.1482
  126 CONTINUE                                                                   05DEC01.1483
      CALL COSGEN (KR,1,0.5,FDEN,TCOS)                                           05DEC01.1484
      CALL TRIX (KR,LR,MR,A,BB,C,B,TCOS,D,W)                                     05DEC01.1485
      DO 127 I=1,MR                                                              05DEC01.1486
         Q(I,J) = Q(I,J)+B(I)                                                    05DEC01.1487
  127 CONTINUE                                                                   05DEC01.1488
      KR = KR+I2R                                                                05DEC01.1489
      GO TO 151                                                                  05DEC01.1490
  128 CONTINUE                                                                   05DEC01.1491
C                                                                                05DEC01.1492
C     EVEN NUMBER OF UNKNOWNS                                                    05DEC01.1493
C                                                                                05DEC01.1494
      JP1 = J+I2RBY2                                                             05DEC01.1495
      JP2 = J+I2R                                                                05DEC01.1496
      IF (I2R .NE. 1) GO TO 135                                                  05DEC01.1497
      DO 129 I=1,MR                                                              05DEC01.1498
         B(I) = Q(I,J)                                                           05DEC01.1499
  129 CONTINUE                                                                   05DEC01.1500
      CALL TRIX (1,0,MR,A,BB,C,B,TCOS,D,W)                                       05DEC01.1501
      IP = 0                                                                     05DEC01.1502
      IPSTOR = MR                                                                05DEC01.1503
      GO TO (133,130),ISTAG                                                      05DEC01.1504
  130 DO 131 I=1,MR                                                              05DEC01.1505
         P(I) = B(I)                                                             05DEC01.1506
         B(I) = B(I)+Q(I,N)                                                      05DEC01.1507
  131 CONTINUE                                                                   05DEC01.1508
      TCOS(1) = 1.                                                               05DEC01.1509
      TCOS(2) = 0.                                                               05DEC01.1510
      CALL TRIX (1,1,MR,A,BB,C,B,TCOS,D,W)                                       05DEC01.1511
      DO 132 I=1,MR                                                              05DEC01.1512
         Q(I,J) = Q(I,JM2)+P(I)+B(I)                                             05DEC01.1513
  132 CONTINUE                                                                   05DEC01.1514
      GO TO 150                                                                  05DEC01.1515
  133 CONTINUE                                                                   05DEC01.1516
      DO 134 I=1,MR                                                              05DEC01.1517
         P(I) = B(I)                                                             05DEC01.1518
         Q(I,J) = Q(I,JM2)+2.*Q(I,JP2)+3.*B(I)                                   05DEC01.1519
  134 CONTINUE                                                                   05DEC01.1520
      GO TO 150                                                                  05DEC01.1521
  135 CONTINUE                                                                   05DEC01.1522
      DO 136 I=1,MR                                                              05DEC01.1523
         B(I) = Q(I,J)+.5*(Q(I,JM2)-Q(I,JM1)-Q(I,JM3))                           05DEC01.1524
  136 CONTINUE                                                                   05DEC01.1525
      IF (NRODPR .NE. 0) GO TO 138                                               05DEC01.1526
      DO 137 I=1,MR                                                              05DEC01.1527
         II = IP+I                                                               05DEC01.1528
         B(I) = B(I)+P(II)                                                       05DEC01.1529
  137 CONTINUE                                                                   05DEC01.1530
      GO TO 140                                                                  05DEC01.1531
  138 CONTINUE                                                                   05DEC01.1532
      DO 139 I=1,MR                                                              05DEC01.1533
         B(I) = B(I)+Q(I,JP2)-Q(I,JP1)                                           05DEC01.1534
  139 CONTINUE                                                                   05DEC01.1535
  140 CONTINUE                                                                   05DEC01.1536
      CALL TRIX (I2R,0,MR,A,BB,C,B,TCOS,D,W)                                     05DEC01.1537
      IP = IP+MR                                                                 05DEC01.1538
      IPSTOR = MAX0(IPSTOR,IP+MR)                                                05DEC01.1539
      DO 141 I=1,MR                                                              05DEC01.1540
         II = IP+I                                                               05DEC01.1541
         P(II) = B(I)+.5*(Q(I,J)-Q(I,JM1)-Q(I,JP1))                              05DEC01.1542
         B(I) = P(II)+Q(I,JP2)                                                   05DEC01.1543
  141 CONTINUE                                                                   05DEC01.1544
      IF (LR .EQ. 0) GO TO 142                                                   05DEC01.1545
      CALL COSGEN (LR,1,0.5,FDEN,TCOS(I2R+1))                                    05DEC01.1546
      CALL MERGE (TCOS,0,I2R,I2R,LR,KR)                                          05DEC01.1547
      GO TO 144                                                                  05DEC01.1548
  142 DO 143 I=1,I2R                                                             05DEC01.1549
         II = KR+I                                                               05DEC01.1550
         TCOS(II) = TCOS(I)                                                      05DEC01.1551
  143 CONTINUE                                                                   05DEC01.1552
  144 CALL COSGEN (KR,1,0.5,FDEN,TCOS)                                           05DEC01.1553
      IF (LR .NE. 0) GO TO 145                                                   05DEC01.1554
      GO TO (146,145),ISTAG                                                      05DEC01.1555
  145 CONTINUE                                                                   05DEC01.1556
      CALL TRIX (KR,KR,MR,A,BB,C,B,TCOS,D,W)                                     05DEC01.1557
      GO TO 148                                                                  05DEC01.1558
  146 CONTINUE                                                                   05DEC01.1559
      DO 147 I=1,MR                                                              05DEC01.1560
         B(I) = FISTAG*B(I)                                                      05DEC01.1561
  147 CONTINUE                                                                   05DEC01.1562
  148 CONTINUE                                                                   05DEC01.1563
      DO 149 I=1,MR                                                              05DEC01.1564
         II = IP+I                                                               05DEC01.1565
         Q(I,J) = Q(I,JM2)+P(II)+B(I)                                            05DEC01.1566
  149 CONTINUE                                                                   05DEC01.1567
  150 CONTINUE                                                                   05DEC01.1568
      LR = KR                                                                    05DEC01.1569
      KR = KR+JR                                                                 05DEC01.1570
  151 CONTINUE                                                                   05DEC01.1571
      GO TO (152,153),MIXBND                                                     05DEC01.1572
  152 NR = (NLAST-1)/JR+1                                                        05DEC01.1573
      IF (NR .LE. 3) GO TO 155                                                   05DEC01.1574
      GO TO 154                                                                  05DEC01.1575
  153 NR = NLAST/JR                                                              05DEC01.1576
      IF (NR .LE. 1) GO TO 192                                                   05DEC01.1577
  154 I2R = JR                                                                   05DEC01.1578
      NRODPR = NROD                                                              05DEC01.1579
      GO TO 104                                                                  05DEC01.1580
  155 CONTINUE                                                                   05DEC01.1581
C                                                                                05DEC01.1582
C      BEGIN SOLUTION                                                            05DEC01.1583
C                                                                                05DEC01.1584
      J = 1+JR                                                                   05DEC01.1585
      JM1 = J-I2R                                                                05DEC01.1586
      JP1 = J+I2R                                                                05DEC01.1587
      JM2 = NLAST-I2R                                                            05DEC01.1588
      IF (NR .EQ. 2) GO TO 184                                                   05DEC01.1589
      IF (LR .NE. 0) GO TO 170                                                   05DEC01.1590
      IF (N .NE. 3) GO TO 161                                                    05DEC01.1591
C                                                                                05DEC01.1592
C     CASE N = 3.                                                                05DEC01.1593
C                                                                                05DEC01.1594
      GO TO (156,168),ISTAG                                                      05DEC01.1595
  156 CONTINUE                                                                   05DEC01.1596
      DO 157 I=1,MR                                                              05DEC01.1597
         B(I) = Q(I,2)                                                           05DEC01.1598
  157 CONTINUE                                                                   05DEC01.1599
      TCOS(1) = 0.                                                               05DEC01.1600
      CALL TRIX (1,0,MR,A,BB,C,B,TCOS,D,W)                                       05DEC01.1601
      DO 158 I=1,MR                                                              05DEC01.1602
         Q(I,2) = B(I)                                                           05DEC01.1603
         B(I) = 4.*B(I)+Q(I,1)+2.*Q(I,3)                                         05DEC01.1604
  158 CONTINUE                                                                   05DEC01.1605
      TCOS(1) = -2.                                                              05DEC01.1606
      TCOS(2) = 2.                                                               05DEC01.1607
      I1 = 2                                                                     05DEC01.1608
      I2 = 0                                                                     05DEC01.1609
      CALL TRIX (I1,I2,MR,A,BB,C,B,TCOS,D,W)                                     05DEC01.1610
      DO 159 I=1,MR                                                              05DEC01.1611
         Q(I,2) = Q(I,2)+B(I)                                                    05DEC01.1612
         B(I) = Q(I,1)+2.*Q(I,2)                                                 05DEC01.1613
  159 CONTINUE                                                                   05DEC01.1614
      TCOS(1) = 0.                                                               05DEC01.1615
      CALL TRIX (1,0,MR,A,BB,C,B,TCOS,D,W)                                       05DEC01.1616
      DO 160 I=1,MR                                                              05DEC01.1617
         Q(I,1) = B(I)                                                           05DEC01.1618
  160 CONTINUE                                                                   05DEC01.1619
      JR = 1                                                                     05DEC01.1620
      I2R = 0                                                                    05DEC01.1621
      GO TO 194                                                                  05DEC01.1622
C                                                                                05DEC01.1623
C     CASE N = 2**P+1                                                            05DEC01.1624
C                                                                                05DEC01.1625
  161 CONTINUE                                                                   05DEC01.1626
      GO TO (162,170),ISTAG                                                      05DEC01.1627
  162 CONTINUE                                                                   05DEC01.1628
      DO 163 I=1,MR                                                              05DEC01.1629
         B(I) = Q(I,J)+.5*Q(I,1)-Q(I,JM1)+Q(I,NLAST)-Q(I,JM2)                    05DEC01.1630
  163 CONTINUE                                                                   05DEC01.1631
      CALL COSGEN (JR,1,0.5,0.0,TCOS)                                            05DEC01.1632
      CALL TRIX (JR,0,MR,A,BB,C,B,TCOS,D,W)                                      05DEC01.1633
      DO 164 I=1,MR                                                              05DEC01.1634
         Q(I,J) = .5*(Q(I,J)-Q(I,JM1)-Q(I,JP1))+B(I)                             05DEC01.1635
         B(I) = Q(I,1)+2.*Q(I,NLAST)+4.*Q(I,J)                                   05DEC01.1636
  164 CONTINUE                                                                   05DEC01.1637
      JR2 = 2*JR                                                                 05DEC01.1638
      CALL COSGEN (JR,1,0.0,0.0,TCOS)                                            05DEC01.1639
      DO 165 I=1,JR                                                              05DEC01.1640
         I1 = JR+I                                                               05DEC01.1641
         I2 = JR+1-I                                                             05DEC01.1642
         TCOS(I1) = -TCOS(I2)                                                    05DEC01.1643
  165 CONTINUE                                                                   05DEC01.1644
      CALL TRIX (JR2,0,MR,A,BB,C,B,TCOS,D,W)                                     05DEC01.1645
      DO 166 I=1,MR                                                              05DEC01.1646
         Q(I,J) = Q(I,J)+B(I)                                                    05DEC01.1647
         B(I) = Q(I,1)+2.*Q(I,J)                                                 05DEC01.1648
  166 CONTINUE                                                                   05DEC01.1649
      CALL COSGEN (JR,1,0.5,0.0,TCOS)                                            05DEC01.1650
      CALL TRIX (JR,0,MR,A,BB,C,B,TCOS,D,W)                                      05DEC01.1651
      DO 167 I=1,MR                                                              05DEC01.1652
         Q(I,1) = .5*Q(I,1)-Q(I,JM1)+B(I)                                        05DEC01.1653
  167 CONTINUE                                                                   05DEC01.1654
      GO TO 194                                                                  05DEC01.1655
C                                                                                05DEC01.1656
C     CASE OF GENERAL N WITH NR = 3 .                                            05DEC01.1657
C                                                                                05DEC01.1658
  168 DO 169 I=1,MR                                                              05DEC01.1659
         B(I) = Q(I,2)                                                           05DEC01.1660
         Q(I,2) = 0.                                                             05DEC01.1661
         B2(I) = Q(I,3)                                                          05DEC01.1662
         B3(I) = Q(I,1)                                                          05DEC01.1663
  169 CONTINUE                                                                   05DEC01.1664
      JR = 1                                                                     05DEC01.1665
      I2R = 0                                                                    05DEC01.1666
      J = 2                                                                      05DEC01.1667
      GO TO 177                                                                  05DEC01.1668
  170 CONTINUE                                                                   05DEC01.1669
      DO 171 I=1,MR                                                              05DEC01.1670
         B(I) = .5*Q(I,1)-Q(I,JM1)+Q(I,J)                                        05DEC01.1671
  171 CONTINUE                                                                   05DEC01.1672
      IF (NROD .NE. 0) GO TO 173                                                 05DEC01.1673
      DO 172 I=1,MR                                                              05DEC01.1674
         II = IP+I                                                               05DEC01.1675
         B(I) = B(I)+P(II)                                                       05DEC01.1676
  172 CONTINUE                                                                   05DEC01.1677
      GO TO 175                                                                  05DEC01.1678
  173 DO 174 I=1,MR                                                              05DEC01.1679
         B(I) = B(I)+Q(I,NLAST)-Q(I,JM2)                                         05DEC01.1680
  174 CONTINUE                                                                   05DEC01.1681
  175 CONTINUE                                                                   05DEC01.1682
      DO 176 I=1,MR                                                              05DEC01.1683
         T = .5*(Q(I,J)-Q(I,JM1)-Q(I,JP1))                                       05DEC01.1684
         Q(I,J) = T                                                              05DEC01.1685
         B2(I) = Q(I,NLAST)+T                                                    05DEC01.1686
         B3(I) = Q(I,1)+2.*T                                                     05DEC01.1687
  176 CONTINUE                                                                   05DEC01.1688
  177 CONTINUE                                                                   05DEC01.1689
      K1 = KR+2*JR-1                                                             05DEC01.1690
      K2 = KR+JR                                                                 05DEC01.1691
      TCOS(K1+1) = -2.                                                           05DEC01.1692
      K4 = K1+3-ISTAG                                                            05DEC01.1693
      CALL COSGEN (K2+ISTAG-2,1,0.0,FNUM,TCOS(K4))                               05DEC01.1694
      K4 = K1+K2+1                                                               05DEC01.1695
      CALL COSGEN (JR-1,1,0.0,1.0,TCOS(K4))                                      05DEC01.1696
      CALL MERGE (TCOS,K1,K2,K1+K2,JR-1,0)                                       05DEC01.1697
      K3 = K1+K2+LR                                                              05DEC01.1698
      CALL COSGEN (JR,1,0.5,0.0,TCOS(K3+1))                                      05DEC01.1699
      K4 = K3+JR+1                                                               05DEC01.1700
      CALL COSGEN (KR,1,0.5,FDEN,TCOS(K4))                                       05DEC01.1701
      CALL MERGE (TCOS,K3,JR,K3+JR,KR,K1)                                        05DEC01.1702
      IF (LR .EQ. 0) GO TO 178                                                   05DEC01.1703
      CALL COSGEN (LR,1,0.5,FDEN,TCOS(K4))                                       05DEC01.1704
      CALL MERGE (TCOS,K3,JR,K3+JR,LR,K3-LR)                                     05DEC01.1705
      CALL COSGEN (KR,1,0.5,FDEN,TCOS(K4))                                       05DEC01.1706
  178 K3 = KR                                                                    05DEC01.1707
      K4 = KR                                                                    05DEC01.1708
      CALL TRI3 (MR,A,BB,C,K,B,B2,B3,TCOS,D,W,W2,W3)                             05DEC01.1709
      DO 179 I=1,MR                                                              05DEC01.1710
         B(I) = B(I)+B2(I)+B3(I)                                                 05DEC01.1711
  179 CONTINUE                                                                   05DEC01.1712
      TCOS(1) = 2.                                                               05DEC01.1713
      CALL TRIX (1,0,MR,A,BB,C,B,TCOS,D,W)                                       05DEC01.1714
      DO 180 I=1,MR                                                              05DEC01.1715
         Q(I,J) = Q(I,J)+B(I)                                                    05DEC01.1716
         B(I) = Q(I,1)+2.*Q(I,J)                                                 05DEC01.1717
  180 CONTINUE                                                                   05DEC01.1718
      CALL COSGEN (JR,1,0.5,0.0,TCOS)                                            05DEC01.1719
      CALL TRIX (JR,0,MR,A,BB,C,B,TCOS,D,W)                                      05DEC01.1720
      IF (JR .NE. 1) GO TO 182                                                   05DEC01.1721
      DO 181 I=1,MR                                                              05DEC01.1722
         Q(I,1) = B(I)                                                           05DEC01.1723
  181 CONTINUE                                                                   05DEC01.1724
      GO TO 194                                                                  05DEC01.1725
  182 CONTINUE                                                                   05DEC01.1726
      DO 183 I=1,MR                                                              05DEC01.1727
         Q(I,1) = .5*Q(I,1)-Q(I,JM1)+B(I)                                        05DEC01.1728
  183 CONTINUE                                                                   05DEC01.1729
      GO TO 194                                                                  05DEC01.1730
  184 CONTINUE                                                                   05DEC01.1731
      IF (N .NE. 2) GO TO 188                                                    05DEC01.1732
C                                                                                05DEC01.1733
C     CASE  N = 2                                                                05DEC01.1734
C                                                                                05DEC01.1735
      DO 185 I=1,MR                                                              05DEC01.1736
         B(I) = Q(I,1)                                                           05DEC01.1737
  185 CONTINUE                                                                   05DEC01.1738
      TCOS(1) = 0.                                                               05DEC01.1739
      CALL TRIX (1,0,MR,A,BB,C,B,TCOS,D,W)                                       05DEC01.1740
      DO 186 I=1,MR                                                              05DEC01.1741
         Q(I,1) = B(I)                                                           05DEC01.1742
         B(I) = 2.*(Q(I,2)+B(I))*FISTAG                                          05DEC01.1743
  186 CONTINUE                                                                   05DEC01.1744
      TCOS(1) = -FISTAG                                                          05DEC01.1745
      TCOS(2) = 2.                                                               05DEC01.1746
      CALL TRIX (2,0,MR,A,BB,C,B,TCOS,D,W)                                       05DEC01.1747
      DO 187 I=1,MR                                                              05DEC01.1748
         Q(I,1) = Q(I,1)+B(I)                                                    05DEC01.1749
  187 CONTINUE                                                                   05DEC01.1750
      JR = 1                                                                     05DEC01.1751
      I2R = 0                                                                    05DEC01.1752
      GO TO 194                                                                  05DEC01.1753
  188 CONTINUE                                                                   05DEC01.1754
C                                                                                05DEC01.1755
C     CASE OF GENERAL N AND NR = 2 .                                             05DEC01.1756
C                                                                                05DEC01.1757
      DO 189 I=1,MR                                                              05DEC01.1758
         II = IP+I                                                               05DEC01.1759
         B3(I) = 0.                                                              05DEC01.1760
         B(I) = Q(I,1)+2.*P(II)                                                  05DEC01.1761
         Q(I,1) = .5*Q(I,1)-Q(I,JM1)                                             05DEC01.1762
         B2(I) = 2.*(Q(I,1)+Q(I,NLAST))                                          05DEC01.1763
  189 CONTINUE                                                                   05DEC01.1764
      K1 = KR+JR-1                                                               05DEC01.1765
      TCOS(K1+1) = -2.                                                           05DEC01.1766
      K4 = K1+3-ISTAG                                                            05DEC01.1767
      CALL COSGEN (KR+ISTAG-2,1,0.0,FNUM,TCOS(K4))                               05DEC01.1768
      K4 = K1+KR+1                                                               05DEC01.1769
      CALL COSGEN (JR-1,1,0.0,1.0,TCOS(K4))                                      05DEC01.1770
      CALL MERGE (TCOS,K1,KR,K1+KR,JR-1,0)                                       05DEC01.1771
      CALL COSGEN (KR,1,0.5,FDEN,TCOS(K1+1))                                     05DEC01.1772
      K2 = KR                                                                    05DEC01.1773
      K4 = K1+K2+1                                                               05DEC01.1774
      CALL COSGEN (LR,1,0.5,FDEN,TCOS(K4))                                       05DEC01.1775
      K3 = LR                                                                    05DEC01.1776
      K4 = 0                                                                     05DEC01.1777
      CALL TRI3 (MR,A,BB,C,K,B,B2,B3,TCOS,D,W,W2,W3)                             05DEC01.1778
      DO 190 I=1,MR                                                              05DEC01.1779
         B(I) = B(I)+B2(I)                                                       05DEC01.1780
  190 CONTINUE                                                                   05DEC01.1781
      TCOS(1) = 2.                                                               05DEC01.1782
      CALL TRIX (1,0,MR,A,BB,C,B,TCOS,D,W)                                       05DEC01.1783
      DO 191 I=1,MR                                                              05DEC01.1784
         Q(I,1) = Q(I,1)+B(I)                                                    05DEC01.1785
  191 CONTINUE                                                                   05DEC01.1786
      GO TO 194                                                                  05DEC01.1787
  192 DO 193 I=1,MR                                                              05DEC01.1788
         B(I) = Q(I,NLAST)                                                       05DEC01.1789
  193 CONTINUE                                                                   05DEC01.1790
      GO TO 196                                                                  05DEC01.1791
  194 CONTINUE                                                                   05DEC01.1792
C                                                                                05DEC01.1793
C     START BACK SUBSTITUTION.                                                   05DEC01.1794
C                                                                                05DEC01.1795
      J = NLAST-JR                                                               05DEC01.1796
      DO 195 I=1,MR                                                              05DEC01.1797
         B(I) = Q(I,NLAST)+Q(I,J)                                                05DEC01.1798
  195 CONTINUE                                                                   05DEC01.1799
  196 JM2 = NLAST-I2R                                                            05DEC01.1800
      IF (JR .NE. 1) GO TO 198                                                   05DEC01.1801
      DO 197 I=1,MR                                                              05DEC01.1802
         Q(I,NLAST) = 0.                                                         05DEC01.1803
  197 CONTINUE                                                                   05DEC01.1804
      GO TO 202                                                                  05DEC01.1805
  198 CONTINUE                                                                   05DEC01.1806
      IF (NROD .NE. 0) GO TO 200                                                 05DEC01.1807
      DO 199 I=1,MR                                                              05DEC01.1808
         II = IP+I                                                               05DEC01.1809
         Q(I,NLAST) = P(II)                                                      05DEC01.1810
  199 CONTINUE                                                                   05DEC01.1811
      IP = IP-MR                                                                 05DEC01.1812
      GO TO 202                                                                  05DEC01.1813
  200 DO 201 I=1,MR                                                              05DEC01.1814
         Q(I,NLAST) = Q(I,NLAST)-Q(I,JM2)                                        05DEC01.1815
  201 CONTINUE                                                                   05DEC01.1816
  202 CONTINUE                                                                   05DEC01.1817
      CALL COSGEN (KR,1,0.5,FDEN,TCOS)                                           05DEC01.1818
      CALL COSGEN (LR,1,0.5,FDEN,TCOS(KR+1))                                     05DEC01.1819
      IF (LR .NE. 0) GO TO 204                                                   05DEC01.1820
      DO 203 I=1,MR                                                              05DEC01.1821
         B(I) = FISTAG*B(I)                                                      05DEC01.1822
  203 CONTINUE                                                                   05DEC01.1823
  204 CONTINUE                                                                   05DEC01.1824
      CALL TRIX (KR,LR,MR,A,BB,C,B,TCOS,D,W)                                     05DEC01.1825
      DO 205 I=1,MR                                                              05DEC01.1826
         Q(I,NLAST) = Q(I,NLAST)+B(I)                                            05DEC01.1827
  205 CONTINUE                                                                   05DEC01.1828
      NLASTP = NLAST                                                             05DEC01.1829
  206 CONTINUE                                                                   05DEC01.1830
      JSTEP = JR                                                                 05DEC01.1831
      JR = I2R                                                                   05DEC01.1832
      I2R = I2R/2                                                                05DEC01.1833
      IF (JR .EQ. 0) GO TO 222                                                   05DEC01.1834
      GO TO (207,208),MIXBND                                                     05DEC01.1835
  207 JSTART = 1+JR                                                              05DEC01.1836
      GO TO 209                                                                  05DEC01.1837
  208 JSTART = JR                                                                05DEC01.1838
  209 CONTINUE                                                                   05DEC01.1839
      KR = KR-JR                                                                 05DEC01.1840
      IF (NLAST+JR .GT. N) GO TO 210                                             05DEC01.1841
      KR = KR-JR                                                                 05DEC01.1842
      NLAST = NLAST+JR                                                           05DEC01.1843
      JSTOP = NLAST-JSTEP                                                        05DEC01.1844
      GO TO 211                                                                  05DEC01.1845
  210 CONTINUE                                                                   05DEC01.1846
      JSTOP = NLAST-JR                                                           05DEC01.1847
  211 CONTINUE                                                                   05DEC01.1848
      LR = KR-JR                                                                 05DEC01.1849
      CALL COSGEN (JR,1,0.5,0.0,TCOS)                                            05DEC01.1850
      DO 221 J=JSTART,JSTOP,JSTEP                                                05DEC01.1851
         JM2 = J-JR                                                              05DEC01.1852
         JP2 = J+JR                                                              05DEC01.1853
         IF (J .NE. JR) GO TO 213                                                05DEC01.1854
         DO 212 I=1,MR                                                           05DEC01.1855
            B(I) = Q(I,J)+Q(I,JP2)                                               05DEC01.1856
  212    CONTINUE                                                                05DEC01.1857
         GO TO 215                                                               05DEC01.1858
  213    CONTINUE                                                                05DEC01.1859
         DO 214 I=1,MR                                                           05DEC01.1860
            B(I) = Q(I,J)+Q(I,JM2)+Q(I,JP2)                                      05DEC01.1861
  214    CONTINUE                                                                05DEC01.1862
  215    CONTINUE                                                                05DEC01.1863
         IF (JR .NE. 1) GO TO 217                                                05DEC01.1864
         DO 216 I=1,MR                                                           05DEC01.1865
            Q(I,J) = 0.                                                          05DEC01.1866
  216    CONTINUE                                                                05DEC01.1867
         GO TO 219                                                               05DEC01.1868
  217    CONTINUE                                                                05DEC01.1869
         JM1 = J-I2R                                                             05DEC01.1870
         JP1 = J+I2R                                                             05DEC01.1871
         DO 218 I=1,MR                                                           05DEC01.1872
            Q(I,J) = .5*(Q(I,J)-Q(I,JM1)-Q(I,JP1))                               05DEC01.1873
  218    CONTINUE                                                                05DEC01.1874
  219    CONTINUE                                                                05DEC01.1875
         CALL TRIX (JR,0,MR,A,BB,C,B,TCOS,D,W)                                   05DEC01.1876
         DO 220 I=1,MR                                                           05DEC01.1877
            Q(I,J) = Q(I,J)+B(I)                                                 05DEC01.1878
  220    CONTINUE                                                                05DEC01.1879
  221 CONTINUE                                                                   05DEC01.1880
      NROD = 1                                                                   05DEC01.1881
      IF (NLAST+I2R .LE. N) NROD = 0                                             05DEC01.1882
      IF (NLASTP .NE. NLAST) GO TO 194                                           05DEC01.1883
      GO TO 206                                                                  05DEC01.1884
  222 CONTINUE                                                                   05DEC01.1885
C                                                                                05DEC01.1886
C     RETURN STORAGE REQUIREMENTS FOR P VECTORS.                                 05DEC01.1887
C                                                                                05DEC01.1888
      W(1) = IPSTOR                                                              05DEC01.1889
      RETURN                                                                     05DEC01.1890
      END                                                                        05DEC01.1891
      SUBROUTINE POISP2 (M,N,A,BB,C,Q,IDIMQ,B,B2,B3,W,W2,W3,D,TCOS,P)            05DEC01.1892
C                                                                                05DEC01.1893
C     SUBROUTINE TO SOLVE POISSON EQUATION WITH PERIODIC BOUNDARY                05DEC01.1894
C     CONDITIONS.                                                                05DEC01.1895
C                                                                                05DEC01.1896
      DIMENSION       A(*)       ,BB(*)      ,C(*)       ,Q(IDIMQ,1) ,           05DEC01.1897
     1                B(*)       ,B2(*)      ,B3(*)      ,W(*)       ,           05DEC01.1898
     2                W2(*)      ,W3(*)      ,D(*)       ,TCOS(*)    ,           05DEC01.1899
     3                P(*)                                                       05DEC01.1900
      MR = M                                                                     05DEC01.1901
      NR = (N+1)/2                                                               05DEC01.1902
      NRM1 = NR-1                                                                05DEC01.1903
      IF (2*NR .NE. N) GO TO 107                                                 05DEC01.1904
C                                                                                05DEC01.1905
C     EVEN NUMBER OF UNKNOWNS                                                    05DEC01.1906
C                                                                                05DEC01.1907
      DO 102 J=1,NRM1                                                            05DEC01.1908
         NRMJ = NR-J                                                             05DEC01.1909
         NRPJ = NR+J                                                             05DEC01.1910
         DO 101 I=1,MR                                                           05DEC01.1911
            S = Q(I,NRMJ)-Q(I,NRPJ)                                              05DEC01.1912
            T = Q(I,NRMJ)+Q(I,NRPJ)                                              05DEC01.1913
            Q(I,NRMJ) = S                                                        05DEC01.1914
            Q(I,NRPJ) = T                                                        05DEC01.1915
  101    CONTINUE                                                                05DEC01.1916
  102 CONTINUE                                                                   05DEC01.1917
      DO 103 I=1,MR                                                              05DEC01.1918
         Q(I,NR) = 2.*Q(I,NR)                                                    05DEC01.1919
         Q(I,N) = 2.*Q(I,N)                                                      05DEC01.1920
  103 CONTINUE                                                                   05DEC01.1921
      CALL POISD2 (MR,NRM1,1,A,BB,C,Q,IDIMQ,B,W,D,TCOS,P)                        05DEC01.1922
      IPSTOR = W(1)                                                              05DEC01.1923
      CALL POISN2 (MR,NR+1,1,1,A,BB,C,Q(1,NR),IDIMQ,B,B2,B3,W,W2,W3,D,           05DEC01.1924
     1             TCOS,P)                                                       05DEC01.1925
      IPSTOR = MAX0(IPSTOR,INT(W(1)))                                            05DEC01.1926
      DO 105 J=1,NRM1                                                            05DEC01.1927
         NRMJ = NR-J                                                             05DEC01.1928
         NRPJ = NR+J                                                             05DEC01.1929
         DO 104 I=1,MR                                                           05DEC01.1930
            S = .5*(Q(I,NRPJ)+Q(I,NRMJ))                                         05DEC01.1931
            T = .5*(Q(I,NRPJ)-Q(I,NRMJ))                                         05DEC01.1932
            Q(I,NRMJ) = S                                                        05DEC01.1933
            Q(I,NRPJ) = T                                                        05DEC01.1934
  104    CONTINUE                                                                05DEC01.1935
  105 CONTINUE                                                                   05DEC01.1936
      DO 106 I=1,MR                                                              05DEC01.1937
         Q(I,NR) = .5*Q(I,NR)                                                    05DEC01.1938
         Q(I,N) = .5*Q(I,N)                                                      05DEC01.1939
  106 CONTINUE                                                                   05DEC01.1940
      GO TO 118                                                                  05DEC01.1941
  107 CONTINUE                                                                   05DEC01.1942
C                                                                                05DEC01.1943
C     ODD  NUMBER OF UNKNOWNS                                                    05DEC01.1944
C                                                                                05DEC01.1945
      DO 109 J=1,NRM1                                                            05DEC01.1946
         NRPJ = N+1-J                                                            05DEC01.1947
         DO 108 I=1,MR                                                           05DEC01.1948
            S = Q(I,J)-Q(I,NRPJ)                                                 05DEC01.1949
            T = Q(I,J)+Q(I,NRPJ)                                                 05DEC01.1950
            Q(I,J) = S                                                           05DEC01.1951
            Q(I,NRPJ) = T                                                        05DEC01.1952
  108    CONTINUE                                                                05DEC01.1953
  109 CONTINUE                                                                   05DEC01.1954
      DO 110 I=1,MR                                                              05DEC01.1955
         Q(I,NR) = 2.*Q(I,NR)                                                    05DEC01.1956
  110 CONTINUE                                                                   05DEC01.1957
      LH = NRM1/2                                                                05DEC01.1958
      DO 112 J=1,LH                                                              05DEC01.1959
         NRMJ = NR-J                                                             05DEC01.1960
         DO 111 I=1,MR                                                           05DEC01.1961
            S = Q(I,J)                                                           05DEC01.1962
            Q(I,J) = Q(I,NRMJ)                                                   05DEC01.1963
            Q(I,NRMJ) = S                                                        05DEC01.1964
  111    CONTINUE                                                                05DEC01.1965
  112 CONTINUE                                                                   05DEC01.1966
      CALL POISD2 (MR,NRM1,2,A,BB,C,Q,IDIMQ,B,W,D,TCOS,P)                        05DEC01.1967
      IPSTOR = W(1)                                                              05DEC01.1968
      CALL POISN2 (MR,NR,2,1,A,BB,C,Q(1,NR),IDIMQ,B,B2,B3,W,W2,W3,D,             05DEC01.1969
     1             TCOS,P)                                                       05DEC01.1970
      IPSTOR = MAX0(IPSTOR,INT(W(1)))                                            05DEC01.1971
      DO 114 J=1,NRM1                                                            05DEC01.1972
         NRPJ = NR+J                                                             05DEC01.1973
         DO 113 I=1,MR                                                           05DEC01.1974
            S = .5*(Q(I,NRPJ)+Q(I,J))                                            05DEC01.1975
            T = .5*(Q(I,NRPJ)-Q(I,J))                                            05DEC01.1976
            Q(I,NRPJ) = T                                                        05DEC01.1977
            Q(I,J) = S                                                           05DEC01.1978
  113    CONTINUE                                                                05DEC01.1979
  114 CONTINUE                                                                   05DEC01.1980
      DO 115 I=1,MR                                                              05DEC01.1981
         Q(I,NR) = .5*Q(I,NR)                                                    05DEC01.1982
  115 CONTINUE                                                                   05DEC01.1983
      DO 117 J=1,LH                                                              05DEC01.1984
         NRMJ = NR-J                                                             05DEC01.1985
         DO 116 I=1,MR                                                           05DEC01.1986
            S = Q(I,J)                                                           05DEC01.1987
            Q(I,J) = Q(I,NRMJ)                                                   05DEC01.1988
            Q(I,NRMJ) = S                                                        05DEC01.1989
  116    CONTINUE                                                                05DEC01.1990
  117 CONTINUE                                                                   05DEC01.1991
  118 CONTINUE                                                                   05DEC01.1992
C                                                                                05DEC01.1993
C     RETURN STORAGE REQUIREMENTS FOR P VECTORS.                                 05DEC01.1994
C                                                                                05DEC01.1995
      W(1) = IPSTOR                                                              05DEC01.1996
      RETURN                                                                     05DEC01.1997
C                                                                                05DEC01.1998
C REVISION HISTORY---                                                            05DEC01.1999
C                                                                                05DEC01.2000
C SEPTEMBER 1973    VERSION 1                                                    05DEC01.2001
C APRIL     1976    VERSION 2                                                    05DEC01.2002
C JANUARY   1978    VERSION 3                                                    05DEC01.2003
C DECEMBER  1979    VERSION 3.1                                                  05DEC01.2004
C FEBRUARY  1985    DOCUMENTATION UPGRADE                                        05DEC01.2005
C NOVEMBER  1988    VERSION 3.2, FORTRAN 77 CHANGES                              05DEC01.2006
C-----------------------------------------------------------------------         05DEC01.2007
      END                                                                        05DEC01.2008
c                                                                                05DEC01.2009
c     file comf.f                                                                05DEC01.2010
c                                                                                05DEC01.2011
c  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .               05DEC01.2012
c  .                                                             .               05DEC01.2013
c  .                  copyright (c) 1999 by UCAR                 .               05DEC01.2014
c  .                                                             .               05DEC01.2015
c  .       UNIVERSITY CORPORATION for ATMOSPHERIC RESEARCH       .               05DEC01.2016
c  .                                                             .               05DEC01.2017
c  .                      all rights reserved                    .               05DEC01.2018
c  .                                                             .               05DEC01.2019
c  .                                                             .               05DEC01.2020
c  .                      FISHPACK version 4.0                   .               05DEC01.2021
c  .                                                             .               05DEC01.2022
c  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .               05DEC01.2023
c                                                                                05DEC01.2024
c                                                                                05DEC01.2025
C                                                                                05DEC01.2026
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *          05DEC01.2027
C     *                                                               *          05DEC01.2028
C     *                        F I S H P A C K                        *          05DEC01.2029
C     *                                                               *          05DEC01.2030
C     *                                                               *          05DEC01.2031
C     *     A PACKAGE OF FORTRAN SUBPROGRAMS FOR THE SOLUTION OF      *          05DEC01.2032
C     *                                                               *          05DEC01.2033
C     *      SEPARABLE ELLIPTIC PARTIAL DIFFERENTIAL EQUATIONS        *          05DEC01.2034
C     *                                                               *          05DEC01.2035
C     *                  (VERSION 4.0 , JUNE 1999)                    *          05DEC01.2036
C     *                                                               *          05DEC01.2037
C     *                             BY                                *          05DEC01.2038
C     *                                                               *          05DEC01.2039
C     *        JOHN ADAMS, PAUL SWARZTRAUBER AND ROLAND SWEET         *          05DEC01.2040
C     *                                                               *          05DEC01.2041
C     *                             OF                                *          05DEC01.2042
C     *                                                               *          05DEC01.2043
C     *         THE NATIONAL CENTER FOR ATMOSPHERIC RESEARCH          *          05DEC01.2044
C     *                                                               *          05DEC01.2045
C     *                BOULDER, COLORADO  (80307)  U.S.A.             *          05DEC01.2046
C     *                                                               *          05DEC01.2047
C     *                   WHICH IS SPONSORED BY                       *          05DEC01.2048
C     *                                                               *          05DEC01.2049
C     *              THE NATIONAL SCIENCE FOUNDATION                  *          05DEC01.2050
C     *                                                               *          05DEC01.2051
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *          05DEC01.2052
C                                                                                05DEC01.2053
C                                                                                05DEC01.2054
C PACKAGE COMF           THE ENTRIES IN THIS PACKAGE ARE LOWLEVEL                05DEC01.2055
C                        ENTRIES, SUPPORTING FISHPACK ENTRIES BLKTRI             05DEC01.2056
C                        AND CBLKTRI. THAT IS, THESE ROUTINES ARE                05DEC01.2057
C                        NOT CALLED DIRECTLY BY USERS, BUT RATHER                05DEC01.2058
C                        BY ENTRIES WITHIN BLKTRI AND CBLKTRI.                   05DEC01.2059
C                        DESCRIPTION OF ENTRIES EPMACH AND PIMACH                05DEC01.2060
C                        FOLLOW BELOW.                                           05DEC01.2061
C                                                                                05DEC01.2062
C LATEST REVISION        NOVEMBER 1988                                           05DEC01.2063
C                                                                                05DEC01.2064
C SPECIAL CONDITIONS     NONE                                                    05DEC01.2065
C                                                                                05DEC01.2066
C I/O                    NONE                                                    05DEC01.2067
C                                                                                05DEC01.2068
C PRECISION              SINGLE                                                  05DEC01.2069
C                                                                                05DEC01.2070
C REQUIRED LIBRARY       NONE                                                    05DEC01.2071
C FILES                                                                          05DEC01.2072
C                                                                                05DEC01.2073
C LANGUAGE               FORTRAN                                                 05DEC01.2074
C ********************************************************************           05DEC01.2075
C                                                                                05DEC01.2076
C FUNCTION EPMACH (DUM)                                                          05DEC01.2077
C                                                                                05DEC01.2078
C PURPOSE                TO COMPUTE AN APPROXIMATE MACHINE ACCURACY              05DEC01.2079
C                        EPSILON ACCORDING TO THE FOLLOWING DEFINITION:          05DEC01.2080
C                        EPSILON IS THE SMALLEST NUMBER SUCH THAT                05DEC01.2081
C                        (1.+EPSILON).GT.1.)                                     05DEC01.2082
C                                                                                05DEC01.2083
C USAGE                  EPS = EPMACH (DUM)                                      05DEC01.2084
C                                                                                05DEC01.2085
C ARGUMENTS                                                                      05DEC01.2086
C ON INPUT               DUM                                                     05DEC01.2087
C                          DUMMY VALUE                                           05DEC01.2088
C                                                                                05DEC01.2089
C ARGUMENTS                                                                      05DEC01.2090
C ON OUTPUT              NONE                                                    05DEC01.2091
C                                                                                05DEC01.2092
C HISTORY                THE ORIGINAL VERSION, WRITTEN WHEN THE                  05DEC01.2093
C                        BLKTRI PACKAGE WAS CONVERTED FROM THE                   05DEC01.2094
C                        CDC 7600 TO RUN ON THE CRAY-1, CALCULATED               05DEC01.2095
C                        MACHINE ACCURACY BY SUCCESSIVE DIVISIONS                05DEC01.2096
C                        BY 10.  USE OF THIS CONSTANT CAUSED BLKTRI              05DEC01.2097
C                        TO COMPUTE SOLUTIONS ON THE CRAY-1 WITH FOUR            05DEC01.2098
C                        FEWER PLACES OF ACCURACY THAN THE VERSION               05DEC01.2099
C                        ON THE 7600.  IT WAS FOUND THAT COMPUTING               05DEC01.2100
C                        MACHINE ACCURACY BY SUCCESSIVE DIVISIONS                05DEC01.2101
C                        OF 2 PRODUCED A MACHINE ACCURACY 29% LESS               05DEC01.2102
C                        THAN THE VALUE GENERATED BY SUCCESSIVE                  05DEC01.2103
C                        DIVISIONS BY 10, AND THAT USE OF THIS                   05DEC01.2104
C                        MACHINE CONSTANT IN THE BLKTRI PACKAGE                  05DEC01.2105
C                        RECOVERED THE ACCURACY THAT APPEARED TO                 05DEC01.2106
C                        BE LOST ON CONVERSION.                                  05DEC01.2107
C                                                                                05DEC01.2108
C ALGORITHM              COMPUTES MACHINE ACCURACY BY SUCCESSIVE                 05DEC01.2109
C                        DIVISIONS OF TWO.                                       05DEC01.2110
C                                                                                05DEC01.2111
C PORTABILITY            THIS CODE WILL EXECUTE ON MACHINES OTHER                05DEC01.2112
C                        THAN THE CRAY1, BUT THE RETURNED VALUE MAY              05DEC01.2113
C                        BE UNSATISFACTORY.  SEE HISTORY ABOVE.                  05DEC01.2114
C ********************************************************************           05DEC01.2115
C                                                                                05DEC01.2116
C FUNCTION PIMACH (DUM)                                                          05DEC01.2117
C                                                                                05DEC01.2118
C PURPOSE                TO SUPPLY THE VALUE OF THE CONSTANT PI                  05DEC01.2119
C                        CORRECT TO MACHINE PRECISION WHERE                      05DEC01.2120
C                        PI=3.141592653589793238462643383279502884197            05DEC01.2121
C                             1693993751058209749446                             05DEC01.2122
C                                                                                05DEC01.2123
C USAGE                  PI = PIMACH (DUM)                                       05DEC01.2124
C                                                                                05DEC01.2125
C ARGUMENTS                                                                      05DEC01.2126
C ON INPUT               DUM                                                     05DEC01.2127
C                          DUMMY VALUE                                           05DEC01.2128
C                                                                                05DEC01.2129
C ARGUMENTS                                                                      05DEC01.2130
C ON OUTPUT              NONE                                                    05DEC01.2131
C                                                                                05DEC01.2132
C ALGORITHM              THE VALUE OF PI IS SET TO 4.*ATAN(1.0)                  05DEC01.2133
C                                                                                05DEC01.2134
C PORTABILITY            THIS ENTRY IS PORTABLE, BUT USERS SHOULD                05DEC01.2135
C                        CHECK TO SEE WHETHER GREATER ACCURACY IS                05DEC01.2136
C                        REQUIRED.                                               05DEC01.2137
C                                                                                05DEC01.2138
C***********************************************************************         05DEC01.2139
      FUNCTION EPMACH (DUM)                                                      05DEC01.2140
      COMMON /VALUE/  V                                                          05DEC01.2141
      EPS = 1.                                                                   05DEC01.2142
  101 EPS = EPS/2.                                                               05DEC01.2143
      CALL STRWRD (EPS+1.)                                                       05DEC01.2144
      IF (V-1.) 102,102,101                                                      05DEC01.2145
  102 EPMACH = 100.*EPS                                                          05DEC01.2146
      RETURN                                                                     05DEC01.2147
      END                                                                        05DEC01.2148
      SUBROUTINE STRWRD (X)                                                      05DEC01.2149
      COMMON /VALUE/  V                                                          05DEC01.2150
      V = X                                                                      05DEC01.2151
      RETURN                                                                     05DEC01.2152
      END                                                                        05DEC01.2153
      FUNCTION PIMACH (DUM)                                                      05DEC01.2154
C     PI=3.1415926535897932384626433832795028841971693993751058209749446         05DEC01.2155
C                                                                                05DEC01.2156
      PIMACH = 4.*ATAN(1.0)                                                      05DEC01.2157
      RETURN                                                                     05DEC01.2158
      END                                                                        05DEC01.2159
      FUNCTION PPSGF (X,IZ,C,A,BH)                                               05DEC01.2160
      DIMENSION       A(*)       ,C(*)       ,BH(*)                              05DEC01.2161
      SUM = 0.                                                                   05DEC01.2162
      DO 101 J=1,IZ                                                              05DEC01.2163
         SUM = SUM-1./(X-BH(J))**2                                               05DEC01.2164
  101 CONTINUE                                                                   05DEC01.2165
      PPSGF = SUM                                                                05DEC01.2166
      RETURN                                                                     05DEC01.2167
      END                                                                        05DEC01.2168
      FUNCTION PPSPF (X,IZ,C,A,BH)                                               05DEC01.2169
      DIMENSION       A(*)       ,C(*)       ,BH(*)                              05DEC01.2170
      SUM = 0.                                                                   05DEC01.2171
      DO 101 J=1,IZ                                                              05DEC01.2172
         SUM = SUM+1./(X-BH(J))                                                  05DEC01.2173
  101 CONTINUE                                                                   05DEC01.2174
      PPSPF = SUM                                                                05DEC01.2175
      RETURN                                                                     05DEC01.2176
      END                                                                        05DEC01.2177
      FUNCTION PSGF (X,IZ,C,A,BH)                                                05DEC01.2178
      DIMENSION       A(*)       ,C(*)       ,BH(*)                              05DEC01.2179
      FSG = 1.                                                                   05DEC01.2180
      HSG = 1.                                                                   05DEC01.2181
      DO 101 J=1,IZ                                                              05DEC01.2182
         DD = 1./(X-BH(J))                                                       05DEC01.2183
         FSG = FSG*A(J)*DD                                                       05DEC01.2184
         HSG = HSG*C(J)*DD                                                       05DEC01.2185
  101 CONTINUE                                                                   05DEC01.2186
      IF (MOD(IZ,2)) 103,102,103                                                 05DEC01.2187
  102 PSGF = 1.-FSG-HSG                                                          05DEC01.2188
      RETURN                                                                     05DEC01.2189
  103 PSGF = 1.+FSG+HSG                                                          05DEC01.2190
      RETURN                                                                     05DEC01.2191
C                                                                                05DEC01.2192
C REVISION HISTORY---                                                            05DEC01.2193
C                                                                                05DEC01.2194
C SEPTEMBER 1973    VERSION 1                                                    05DEC01.2195
C APRIL     1976    VERSION 2                                                    05DEC01.2196
C JANUARY   1978    VERSION 3                                                    05DEC01.2197
C DECEMBER  1979    VERSION 3.1                                                  05DEC01.2198
C FEBRUARY  1985    DOCUMENTATION UPGRADE                                        05DEC01.2199
C NOVEMBER  1988    VERSION 3.2, FORTRAN 77 CHANGES                              05DEC01.2200
C-----------------------------------------------------------------------         05DEC01.2201
      END                                                                        05DEC01.2202
c                                                                                05DEC01.2203
c     file gnbnaux.f                                                             05DEC01.2204
c                                                                                05DEC01.2205
c  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .               05DEC01.2206
c  .                                                             .               05DEC01.2207
c  .                  copyright (c) 1999 by UCAR                 .               05DEC01.2208
c  .                                                             .               05DEC01.2209
c  .       UNIVERSITY CORPORATION for ATMOSPHERIC RESEARCH       .               05DEC01.2210
c  .                                                             .               05DEC01.2211
c  .                      all rights reserved                    .               05DEC01.2212
c  .                                                             .               05DEC01.2213
c  .                                                             .               05DEC01.2214
c  .                      FISHPACK version 4.0                   .               05DEC01.2215
c  .                                                             .               05DEC01.2216
c  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .               05DEC01.2217
c                                                                                05DEC01.2218
c                                                                                05DEC01.2219
C                                                                                05DEC01.2220
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *          05DEC01.2221
C     *                                                               *          05DEC01.2222
C     *                        F I S H P A C K                        *          05DEC01.2223
C     *                                                               *          05DEC01.2224
C     *                                                               *          05DEC01.2225
C     *     A PACKAGE OF FORTRAN SUBPROGRAMS FOR THE SOLUTION OF      *          05DEC01.2226
C     *                                                               *          05DEC01.2227
C     *      SEPARABLE ELLIPTIC PARTIAL DIFFERENTIAL EQUATIONS        *          05DEC01.2228
C     *                                                               *          05DEC01.2229
C     *                  (VERSION 4.0 , JUNE 1999)                    *          05DEC01.2230
C     *                                                               *          05DEC01.2231
C     *                             BY                                *          05DEC01.2232
C     *                                                               *          05DEC01.2233
C     *        JOHN ADAMS, PAUL SWARZTRAUBER AND ROLAND SWEET         *          05DEC01.2234
C     *                                                               *          05DEC01.2235
C     *                             OF                                *          05DEC01.2236
C     *                                                               *          05DEC01.2237
C     *         THE NATIONAL CENTER FOR ATMOSPHERIC RESEARCH          *          05DEC01.2238
C     *                                                               *          05DEC01.2239
C     *                BOULDER, COLORADO  (80307)  U.S.A.             *          05DEC01.2240
C     *                                                               *          05DEC01.2241
C     *                   WHICH IS SPONSORED BY                       *          05DEC01.2242
C     *                                                               *          05DEC01.2243
C     *              THE NATIONAL SCIENCE FOUNDATION                  *          05DEC01.2244
C     *                                                               *          05DEC01.2245
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *          05DEC01.2246
C                                                                                05DEC01.2247
C                                                                                05DEC01.2248
C PACKAGE GNBNAUX                                                                05DEC01.2249
C                                                                                05DEC01.2250
C LATEST REVISION        NOVEMBER 1988                                           05DEC01.2251
C                                                                                05DEC01.2252
C PURPOSE                TO PROVIDE AUXILIARY ROUTINES FOR FISHPACK              05DEC01.2253
C                        ENTRIES GENBUN AND POISTG.                              05DEC01.2254
C                                                                                05DEC01.2255
C USAGE                  THERE ARE NO USER ENTRIES IN THIS PACKAGE.              05DEC01.2256
C                        THE ROUTINES IN THIS PACKAGE ARE NOT INTENDED           05DEC01.2257
C                        TO BE CALLED BY USERS, BUT RATHER BY ROUTINES           05DEC01.2258
C                        IN PACKAGES GENBUN AND POISTG.                          05DEC01.2259
C                                                                                05DEC01.2260
C SPECIAL CONDITIONS     NONE                                                    05DEC01.2261
C                                                                                05DEC01.2262
C I/O                    NONE                                                    05DEC01.2263
C                                                                                05DEC01.2264
C PRECISION              SINGLE                                                  05DEC01.2265
C                                                                                05DEC01.2266
C REQUIRED LIBRARY       COMF FROM FISHPACK                                      05DEC01.2267
C FILES                                                                          05DEC01.2268
C                                                                                05DEC01.2269
C LANGUAGE               FORTRAN                                                 05DEC01.2270
C                                                                                05DEC01.2271
C HISTORY                WRITTEN IN 1979 BY ROLAND SWEET OF NCAR'S               05DEC01.2272
C                        SCIENTIFIC COMPUTING DIVISION.  MADE AVAILABLE          05DEC01.2273
C                        ON NCAR'S PUBLIC LIBRARIES IN JANUARY, 1980.            05DEC01.2274
C                                                                                05DEC01.2275
C PORTABILITY            FORTRAN 77                                              05DEC01.2276
C ********************************************************************           05DEC01.2277
      SUBROUTINE COSGEN (N,IJUMP,FNUM,FDEN,A)                                    05DEC01.2278
      DIMENSION       A(*)                                                       05DEC01.2279
C                                                                                05DEC01.2280
C                                                                                05DEC01.2281
C     THIS SUBROUTINE COMPUTES REQUIRED COSINE VALUES IN ASCENDING               05DEC01.2282
C     ORDER.  WHEN IJUMP .GT. 1 THE ROUTINE COMPUTES VALUES                      05DEC01.2283
C                                                                                05DEC01.2284
C        2*COS(J*PI/L) , J=1,2,...,L AND J .NE. 0(MOD N/IJUMP+1)                 05DEC01.2285
C                                                                                05DEC01.2286
C     WHERE L = IJUMP*(N/IJUMP+1).                                               05DEC01.2287
C                                                                                05DEC01.2288
C                                                                                05DEC01.2289
C     WHEN IJUMP = 1 IT COMPUTES                                                 05DEC01.2290
C                                                                                05DEC01.2291
C            2*COS((J-FNUM)*PI/(N+FDEN)) ,  J=1, 2, ... ,N                       05DEC01.2292
C                                                                                05DEC01.2293
C     WHERE                                                                      05DEC01.2294
C        FNUM = 0.5, FDEN = 0.0,  FOR REGULAR REDUCTION VALUES                   05DEC01.2295
C        FNUM = 0.0, FDEN = 1.0, FOR B-R AND C-R WHEN ISTAG = 1                  05DEC01.2296
C        FNUM = 0.0, FDEN = 0.5, FOR B-R AND C-R WHEN ISTAG = 2                  05DEC01.2297
C        FNUM = 0.5, FDEN = 0.5, FOR B-R AND C-R WHEN ISTAG = 2                  05DEC01.2298
C                                IN POISN2 ONLY.                                 05DEC01.2299
C                                                                                05DEC01.2300
C                                                                                05DEC01.2301
      PI = PIMACH(DUM)                                                           05DEC01.2302
      IF (N .EQ. 0) GO TO 105                                                    05DEC01.2303
      IF (IJUMP .EQ. 1) GO TO 103                                                05DEC01.2304
      K3 = N/IJUMP+1                                                             05DEC01.2305
      K4 = K3-1                                                                  05DEC01.2306
      PIBYN = PI/FLOAT(N+IJUMP)                                                  05DEC01.2307
      DO 102 K=1,IJUMP                                                           05DEC01.2308
         K1 = (K-1)*K3                                                           05DEC01.2309
         K5 = (K-1)*K4                                                           05DEC01.2310
         DO 101 I=1,K4                                                           05DEC01.2311
            X = K1+I                                                             05DEC01.2312
            K2 = K5+I                                                            05DEC01.2313
            A(K2) = -2.*COS(X*PIBYN)                                             05DEC01.2314
  101    CONTINUE                                                                05DEC01.2315
  102 CONTINUE                                                                   05DEC01.2316
      GO TO 105                                                                  05DEC01.2317
  103 CONTINUE                                                                   05DEC01.2318
      NP1 = N+1                                                                  05DEC01.2319
      Y = PI/(FLOAT(N)+FDEN)                                                     05DEC01.2320
      DO 104 I=1,N                                                               05DEC01.2321
         X = FLOAT(NP1-I)-FNUM                                                   05DEC01.2322
         A(I) = 2.*COS(X*Y)                                                      05DEC01.2323
  104 CONTINUE                                                                   05DEC01.2324
  105 CONTINUE                                                                   05DEC01.2325
      RETURN                                                                     05DEC01.2326
      END                                                                        05DEC01.2327
      SUBROUTINE MERGE (TCOS,I1,M1,I2,M2,I3)                                     05DEC01.2328
      DIMENSION       TCOS(*)                                                    05DEC01.2329
C                                                                                05DEC01.2330
C     THIS SUBROUTINE MERGES TWO ASCENDING STRINGS OF NUMBERS IN THE             05DEC01.2331
C     ARRAY TCOS.  THE FIRST STRING IS OF LENGTH M1 AND STARTS AT                05DEC01.2332
C     TCOS(I1+1).  THE SECOND STRING IS OF LENGTH M2 AND STARTS AT               05DEC01.2333
C     TCOS(I2+1).  THE MERGED STRING GOES INTO TCOS(I3+1).                       05DEC01.2334
C                                                                                05DEC01.2335
C                                                                                05DEC01.2336
      J1 = 1                                                                     05DEC01.2337
      J2 = 1                                                                     05DEC01.2338
      J = I3                                                                     05DEC01.2339
      IF (M1 .EQ. 0) GO TO 107                                                   05DEC01.2340
      IF (M2 .EQ. 0) GO TO 104                                                   05DEC01.2341
  101 J = J+1                                                                    05DEC01.2342
      L = J1+I1                                                                  05DEC01.2343
      X = TCOS(L)                                                                05DEC01.2344
      L = J2+I2                                                                  05DEC01.2345
      Y = TCOS(L)                                                                05DEC01.2346
      IF (X-Y) 102,102,103                                                       05DEC01.2347
  102 TCOS(J) = X                                                                05DEC01.2348
      J1 = J1+1                                                                  05DEC01.2349
      IF (J1 .GT. M1) GO TO 106                                                  05DEC01.2350
      GO TO 101                                                                  05DEC01.2351
  103 TCOS(J) = Y                                                                05DEC01.2352
      J2 = J2+1                                                                  05DEC01.2353
      IF (J2 .LE. M2) GO TO 101                                                  05DEC01.2354
      IF (J1 .GT. M1) GO TO 109                                                  05DEC01.2355
  104 K = J-J1+1                                                                 05DEC01.2356
      DO 105 J=J1,M1                                                             05DEC01.2357
         M = K+J                                                                 05DEC01.2358
         L = J+I1                                                                05DEC01.2359
         TCOS(M) = TCOS(L)                                                       05DEC01.2360
  105 CONTINUE                                                                   05DEC01.2361
      GO TO 109                                                                  05DEC01.2362
  106 CONTINUE                                                                   05DEC01.2363
      IF (J2 .GT. M2) GO TO 109                                                  05DEC01.2364
  107 K = J-J2+1                                                                 05DEC01.2365
      DO 108 J=J2,M2                                                             05DEC01.2366
         M = K+J                                                                 05DEC01.2367
         L = J+I2                                                                05DEC01.2368
         TCOS(M) = TCOS(L)                                                       05DEC01.2369
  108 CONTINUE                                                                   05DEC01.2370
  109 CONTINUE                                                                   05DEC01.2371
      RETURN                                                                     05DEC01.2372
      END                                                                        05DEC01.2373
      SUBROUTINE TRIX (IDEGBR,IDEGCR,M,A,B,C,Y,TCOS,D,W)                         05DEC01.2374
C                                                                                05DEC01.2375
C     SUBROUTINE TO SOLVE A SYSTEM OF LINEAR EQUATIONS WHERE THE                 05DEC01.2376
C     COEFFICIENT MATRIX IS A RATIONAL FUNCTION IN THE MATRIX GIVEN BY           05DEC01.2377
C     TRIDIAGONAL  ( . . . , A(I), B(I), C(I), . . . ).                          05DEC01.2378
C                                                                                05DEC01.2379
      DIMENSION       A(*)       ,B(*)       ,C(*)       ,Y(*)       ,           05DEC01.2380
     1                TCOS(*)    ,D(*)       ,W(*)                               05DEC01.2381
      MM1 = M-1                                                                  05DEC01.2382
      IFB = IDEGBR+1                                                             05DEC01.2383
      IFC = IDEGCR+1                                                             05DEC01.2384
      L = IFB/IFC                                                                05DEC01.2385
      LINT = 1                                                                   05DEC01.2386
      DO 108 K=1,IDEGBR                                                          05DEC01.2387
         X = TCOS(K)                                                             05DEC01.2388
         IF (K .NE. L) GO TO 102                                                 05DEC01.2389
         I = IDEGBR+LINT                                                         05DEC01.2390
         XX = X-TCOS(I)                                                          05DEC01.2391
         DO 101 I=1,M                                                            05DEC01.2392
            W(I) = Y(I)                                                          05DEC01.2393
            Y(I) = XX*Y(I)                                                       05DEC01.2394
  101    CONTINUE                                                                05DEC01.2395
  102    CONTINUE                                                                05DEC01.2396
         Z = 1./(B(1)-X)                                                         05DEC01.2397
         D(1) = C(1)*Z                                                           05DEC01.2398
         Y(1) = Y(1)*Z                                                           05DEC01.2399
         DO 103 I=2,MM1                                                          05DEC01.2400
            Z = 1./(B(I)-X-A(I)*D(I-1))                                          05DEC01.2401
            D(I) = C(I)*Z                                                        05DEC01.2402
            Y(I) = (Y(I)-A(I)*Y(I-1))*Z                                          05DEC01.2403
  103    CONTINUE                                                                05DEC01.2404
         Z = B(M)-X-A(M)*D(MM1)                                                  05DEC01.2405
         IF (Z .NE. 0.) GO TO 104                                                05DEC01.2406
         Y(M) = 0.                                                               05DEC01.2407
         GO TO 105                                                               05DEC01.2408
  104    Y(M) = (Y(M)-A(M)*Y(MM1))/Z                                             05DEC01.2409
  105    CONTINUE                                                                05DEC01.2410
         DO 106 IP=1,MM1                                                         05DEC01.2411
            I = M-IP                                                             05DEC01.2412
            Y(I) = Y(I)-D(I)*Y(I+1)                                              05DEC01.2413
  106    CONTINUE                                                                05DEC01.2414
         IF (K .NE. L) GO TO 108                                                 05DEC01.2415
         DO 107 I=1,M                                                            05DEC01.2416
            Y(I) = Y(I)+W(I)                                                     05DEC01.2417
  107    CONTINUE                                                                05DEC01.2418
         LINT = LINT+1                                                           05DEC01.2419
         L = (LINT*IFB)/IFC                                                      05DEC01.2420
  108 CONTINUE                                                                   05DEC01.2421
      RETURN                                                                     05DEC01.2422
      END                                                                        05DEC01.2423
      SUBROUTINE TRI3 (M,A,B,C,K,Y1,Y2,Y3,TCOS,D,W1,W2,W3)                       05DEC01.2424
      DIMENSION       A(*)       ,B(*)       ,C(*)       ,K(4)       ,           05DEC01.2425
     1                TCOS(*)    ,Y1(*)      ,Y2(*)      ,Y3(*)      ,           05DEC01.2426
     2                D(*)       ,W1(*)      ,W2(*)      ,W3(*)                  05DEC01.2427
C                                                                                05DEC01.2428
C     SUBROUTINE TO SOLVE THREE LINEAR SYSTEMS WHOSE COMMON COEFFICIENT          05DEC01.2429
C     MATRIX IS A RATIONAL FUNCTION IN THE MATRIX GIVEN BY                       05DEC01.2430
C                                                                                05DEC01.2431
C                  TRIDIAGONAL (...,A(I),B(I),C(I),...)                          05DEC01.2432
C                                                                                05DEC01.2433
      MM1 = M-1                                                                  05DEC01.2434
      K1 = K(1)                                                                  05DEC01.2435
      K2 = K(2)                                                                  05DEC01.2436
      K3 = K(3)                                                                  05DEC01.2437
      K4 = K(4)                                                                  05DEC01.2438
      IF1 = K1+1                                                                 05DEC01.2439
      IF2 = K2+1                                                                 05DEC01.2440
      IF3 = K3+1                                                                 05DEC01.2441
      IF4 = K4+1                                                                 05DEC01.2442
      K2K3K4 = K2+K3+K4                                                          05DEC01.2443
      IF (K2K3K4 .EQ. 0) GO TO 101                                               05DEC01.2444
      L1 = IF1/IF2                                                               05DEC01.2445
      L2 = IF1/IF3                                                               05DEC01.2446
      L3 = IF1/IF4                                                               05DEC01.2447
      LINT1 = 1                                                                  05DEC01.2448
      LINT2 = 1                                                                  05DEC01.2449
      LINT3 = 1                                                                  05DEC01.2450
      KINT1 = K1                                                                 05DEC01.2451
      KINT2 = KINT1+K2                                                           05DEC01.2452
      KINT3 = KINT2+K3                                                           05DEC01.2453
  101 CONTINUE                                                                   05DEC01.2454
      DO 115 N=1,K1                                                              05DEC01.2455
         X = TCOS(N)                                                             05DEC01.2456
         IF (K2K3K4 .EQ. 0) GO TO 107                                            05DEC01.2457
         IF (N .NE. L1) GO TO 103                                                05DEC01.2458
         DO 102 I=1,M                                                            05DEC01.2459
            W1(I) = Y1(I)                                                        05DEC01.2460
  102    CONTINUE                                                                05DEC01.2461
  103    IF (N .NE. L2) GO TO 105                                                05DEC01.2462
         DO 104 I=1,M                                                            05DEC01.2463
            W2(I) = Y2(I)                                                        05DEC01.2464
  104    CONTINUE                                                                05DEC01.2465
  105    IF (N .NE. L3) GO TO 107                                                05DEC01.2466
         DO 106 I=1,M                                                            05DEC01.2467
            W3(I) = Y3(I)                                                        05DEC01.2468
  106    CONTINUE                                                                05DEC01.2469
  107    CONTINUE                                                                05DEC01.2470
         Z = 1./(B(1)-X)                                                         05DEC01.2471
         D(1) = C(1)*Z                                                           05DEC01.2472
         Y1(1) = Y1(1)*Z                                                         05DEC01.2473
         Y2(1) = Y2(1)*Z                                                         05DEC01.2474
         Y3(1) = Y3(1)*Z                                                         05DEC01.2475
         DO 108 I=2,M                                                            05DEC01.2476
            Z = 1./(B(I)-X-A(I)*D(I-1))                                          05DEC01.2477
            D(I) = C(I)*Z                                                        05DEC01.2478
            Y1(I) = (Y1(I)-A(I)*Y1(I-1))*Z                                       05DEC01.2479
            Y2(I) = (Y2(I)-A(I)*Y2(I-1))*Z                                       05DEC01.2480
            Y3(I) = (Y3(I)-A(I)*Y3(I-1))*Z                                       05DEC01.2481
  108    CONTINUE                                                                05DEC01.2482
         DO 109 IP=1,MM1                                                         05DEC01.2483
            I = M-IP                                                             05DEC01.2484
            Y1(I) = Y1(I)-D(I)*Y1(I+1)                                           05DEC01.2485
            Y2(I) = Y2(I)-D(I)*Y2(I+1)                                           05DEC01.2486
            Y3(I) = Y3(I)-D(I)*Y3(I+1)                                           05DEC01.2487
  109    CONTINUE                                                                05DEC01.2488
         IF (K2K3K4 .EQ. 0) GO TO 115                                            05DEC01.2489
         IF (N .NE. L1) GO TO 111                                                05DEC01.2490
         I = LINT1+KINT1                                                         05DEC01.2491
         XX = X-TCOS(I)                                                          05DEC01.2492
         DO 110 I=1,M                                                            05DEC01.2493
            Y1(I) = XX*Y1(I)+W1(I)                                               05DEC01.2494
  110    CONTINUE                                                                05DEC01.2495
         LINT1 = LINT1+1                                                         05DEC01.2496
         L1 = (LINT1*IF1)/IF2                                                    05DEC01.2497
  111    IF (N .NE. L2) GO TO 113                                                05DEC01.2498
         I = LINT2+KINT2                                                         05DEC01.2499
         XX = X-TCOS(I)                                                          05DEC01.2500
         DO 112 I=1,M                                                            05DEC01.2501
            Y2(I) = XX*Y2(I)+W2(I)                                               05DEC01.2502
  112    CONTINUE                                                                05DEC01.2503
         LINT2 = LINT2+1                                                         05DEC01.2504
         L2 = (LINT2*IF1)/IF3                                                    05DEC01.2505
  113    IF (N .NE. L3) GO TO 115                                                05DEC01.2506
         I = LINT3+KINT3                                                         05DEC01.2507
         XX = X-TCOS(I)                                                          05DEC01.2508
         DO 114 I=1,M                                                            05DEC01.2509
            Y3(I) = XX*Y3(I)+W3(I)                                               05DEC01.2510
  114    CONTINUE                                                                05DEC01.2511
         LINT3 = LINT3+1                                                         05DEC01.2512
         L3 = (LINT3*IF1)/IF4                                                    05DEC01.2513
  115 CONTINUE                                                                   05DEC01.2514
      RETURN                                                                     05DEC01.2515
C                                                                                05DEC01.2516
C REVISION HISTORY---                                                            05DEC01.2517
C                                                                                05DEC01.2518
C SEPTEMBER 1973    VERSION 1                                                    05DEC01.2519
C APRIL     1976    VERSION 2                                                    05DEC01.2520
C JANUARY   1978    VERSION 3                                                    05DEC01.2521
C DECEMBER  1979    VERSION 3.1                                                  05DEC01.2522
C OCTOBER   1980    CHANGED SEVERAL DIVIDES OF FLOATING INTEGERS                 05DEC01.2523
C                   TO INTEGER DIVIDES TO ACCOMODATE CRAY-1 ARITHMETIC.          05DEC01.2524
C FEBRUARY  1985    DOCUMENTATION UPGRADE                                        05DEC01.2525
C NOVEMBER  1988    VERSION 3.2, FORTRAN 77 CHANGES                              05DEC01.2526
C-----------------------------------------------------------------------         05DEC01.2527
      END                                                                        05DEC01.2528
