       SUBROUTINE SEAPRS3(PSC,T,PP,TER,IX,JX,KX,PTOP,SIG,SLP)                    SEAPRS3.1
C                                                                                SEAPRS3.2
C      *** DIAGNOSTIC PROGRAM TO BE USED IN CONJUNCTION WITH ANALYSIS            SEAPRS3.3
C      *** PROGRAM WITH MODAS DATA                                               SEAPRS3.4
C      *** USES FILES PSC,T,TER TO COMPUTE SEALEVEL PRESSURE                     SEAPRS3.5
C      *** RULE USED T1/T2 = (P1/P2)**(GAMMA*R/G)                                SEAPRS3.6
C                                                                                SEAPRS3.7
C      *** (NAMING CONVENTION MATCHES DATFLO CONVENTION OF MODEL)                SEAPRS3.8
C                                                                                SEAPRS3.9
       REAL T(IX,JX,KX),SLP(IX,JX),PSC(IX,JX),SIG(KX),                           SEAPRS3.10
     +      TER(IX,JX), PP(IX,JX,KX)                                             SEAPRS3.11
C                                                                                SEAPRS3.12
       GAMMA = 6.5E-3                                                            SEAPRS3.13
       G = 9.8                                                                   SEAPRS3.14
       R = 287.04                                                                SEAPRS3.15
       TSLC = 298.16                                                             SEAPRS3.16
       XTERM = GAMMA*R/G                                                         SEAPRS3.17
       DO 100 J=1,JX-1                                                           SEAPRS3.18
       DO 100  I=1,IX-1                                                          SEAPRS3.19
C                                                                                SEAPRS3.20
C            *** COMPUTE PRESSURE AT FIRST SIGMA LEVEL                           SEAPRS3.21
C                                                                                SEAPRS3.22
              PL = (SIG(KX)*PSC(I,J))+PTOP+PP(I,J,KX)                            SEAPRS3.23
              SFP=          PSC(I,J) +PTOP+PP(I,J,KX)                            SEAPRS3.24
C                                                                                SEAPRS3.25
C            *** COMPUTE MEAN SURFACE TEMPERATURE USING                          SEAPRS3.26
C            *** TEMP AT SIGMA ONE                                               SEAPRS3.27
C                                                                                SEAPRS3.28
             TSFC = T(I,J,KX)*(SFP/PL)**XTERM                                    SEAPRS3.29
             TBAR = 0.5 * (T(I,J,KX)+TSFC)                                       SEAPRS3.30
C                                                                                SEAPRS3.31
C            *** COMPUTE HEIGHT OF SIGMA ONE                                     SEAPRS3.32
C                                                                                SEAPRS3.33
             HL = TER(I,J)- R/G * ALOG(PL/SFP) * TBAR                            SEAPRS3.34
C                                                                                SEAPRS3.35
C            *** ESTIMATE TEMPERATURE AT SEALEVEL                                SEAPRS3.36
C            *** TSL: TEMP AT SEA LEVEL                                          SEAPRS3.37
C                                                                                SEAPRS3.38
             TSL = T(I,J,KX) + GAMMA*HL                                          SEAPRS3.39
C                                                                                SEAPRS3.40
C            *** TEST IF TEMP AT SEALEVEL IS OUT OF BOUNDS THEN                  SEAPRS3.41
C            *** REPLACE IT                                                      SEAPRS3.42
C                                                                                SEAPRS3.43
C            *** CALCULATE SURFACE TEMP                                          SEAPRS3.44
C            *** TSFCX: TEMP AT SURFACE, CROSS POINTS                            SEAPRS3.45
C                                                                                SEAPRS3.46
             IF (TSL.GE.TSLC) THEN                                               SEAPRS3.47
                TSL = TSLC                                                       SEAPRS3.48
                IF (TSFC .GT. TSLC)                                              SEAPRS3.49
     +             TSL = TSL-0.005 * (TSFC-TSLC)**2.                             SEAPRS3.50
             END IF                                                              SEAPRS3.51
C                                                                                SEAPRS3.52
C            *** NOW SET SEA LEVEL PRESSURE                                      SEAPRS3.53
C                                                                                SEAPRS3.54
             SLP(I,J) = PL * EXP(HL*G/(R*.5*(T(I,J,KX)+TSL)))                    SEAPRS3.55
100   CONTINUE                                                                   SEAPRS3.56
      RETURN                                                                     SEAPRS3.57
      END                                                                        SEAPRS3.58
