      SUBROUTINE SFCPRS(T,Q,HEIGHT,PSLV,TER,P,I1,J1,K1,                          SFCPRS.1
     *                  PSFC,TSFC,PROG)                                          SFCPRS.2
C                                                                                SFCPRS.3
#     include <scratch.incl>                                                     SFCPRS.4
C                                                                                SFCPRS.5
      INEED = 10*I1*J1 + 2*I1*J1*(K1+1) + K1                                     SFCPRS.6
C                                                                                SFCPRS.7
      IN1 = NTEMP                                                                SFCPRS.8
      IN2 = IN1+I1*J1                                                            SFCPRS.9
      IN3 = IN2+I1*J1                                                            SFCPRS.10
      IN4 = IN3+I1*J1                                                            SFCPRS.11
      IN5 = IN4+I1*J1                                                            SFCPRS.12
      IN6 = IN5+I1*J1                                                            SFCPRS.13
      IN7 = IN6+I1*J1                                                            SFCPRS.14
      IN8 = IN7+I1*J1                                                            SFCPRS.15
      IN9 = IN8+I1*J1                                                            SFCPRS.16
      IN10 = IN9+I1*J1                                                           SFCPRS.17
                                                                                 SFCPRS.18
C                                                                                SFCPRS.19
      NTEMP = NTEMP+INEED                                                        SFCPRS.20
      IF(NTEMP .GT. I_SCRATCH) CALL SPACE_STOP('SFCPRS')                         SFCPRS.21
      IF(VERBOSE) WRITE(6,*) ' CALLING SFCPRS ',INEED,IN1,NTEMP                  SFCPRS.22
        CALL SFCPRS_0(T,Q,HEIGHT,PSLV,TER,P,I1,J1,K1,                            SFCPRS.23
     *                    PSFC,TSFC,PROG,                                        SFCPRS.24
     *   SCR(IN1),SCR(IN2),SCR(IN3),SCR(IN4),SCR(IN5),                           SFCPRS.25
     *   SCR(IN6),SCR(IN7),SCR(IN8),SCR(IN9),SCR(IN10) )                         SFCPRS.26
C                                                                                SFCPRS.27
      NTEMP = NTEMP - INEED                                                      SFCPRS.28
      IF(VERBOSE) WRITE(6,*) ' RET FROM SFCPRS ',NTEMP                           SFCPRS.29
      RETURN                                                                     SFCPRS.30
      END                                                                        SFCPRS.31
C                                                                                SFCPRS.32
      SUBROUTINE SFCPRS_0(T,Q,HEIGHT,PSLV,TER,P,IMX,JMX,KX,                      SFCPRS.33
     *                  PSFC,TSFC,PROG,                                          SFCPRS.34
     *                  HT,TSLV,P1,T1,TFIXED,T850,T700,T500,                     SFCPRS.35
     *                  GAMMA78,GAMMA57                      )                   SFCPRS.36
C                                                                                SFCPRS.37
C     SECTION  DIAGNOSTIC                                                        SFCPRS.38
C     PURPOSE  COMPUTES THE SURFACE PRESSURE USING THE INPUT HEIGHT,             SFCPRS.39
C              TEMPERATURE AND Q (ALREADY COMPUTED FROM RELATIVE                 SFCPRS.40
C              HUMIDITY) ON P SURFACES.  SEA LEVEL PRESSURE IS USED              SFCPRS.41
C              TO EXTRAPOLATE A FIRST GUESS.                                     SFCPRS.42
C                                                                                SFCPRS.43
C     INPUT       T        ANALYZED TEMPERATURE       CROSS    3D                SFCPRS.44
C                 Q        DIAGNOSED MIXXING RATIO    CROSS    3D                SFCPRS.45
C                 HEIGHT   ANALYZED HEIGHT            DOT      3D                SFCPRS.46
C                 PSLV     SEA LEVEL PRESSURE         CROSS    2D                SFCPRS.47
C                 TER      TERRAIN                    CROSS    2D                SFCPRS.48
C                 P        VALUES OF PRESSURE SURFACES         1D                SFCPRS.49
C                 IMX      DOT POINT DIMENSION N-S                               SFCPRS.50
C                 JMX      DOT POINT DIMENSION E-W                               SFCPRS.51
C                 KX       NUMBER OF VERTICAL LEVELS                             SFCPRS.52
C                 PROG     CHARACTER *6 PROGRAM NAME                             SFCPRS.53
C                                                                                SFCPRS.54
C     STACK       HT       INTERP HEIGHT              CROSS    2D                SFCPRS.55
C                 TSLV     SEA LEVEL TEMP             CROSS    2D                SFCPRS.56
C                 P1       DUMMY PRESSURE ARRAY       CROSS    2D                SFCPRS.57
C                 T1       DUMMY TEMPERATUE ARRAY     CROSS    2D                SFCPRS.58
C                 TFIXED   EMPIRICAL TEMPERATURE      CROSS    2D                SFCPRS.59
C                 T850     MANDATORY TEMP AT 850      CROSS    2D                SFCPRS.60
C                 T700     MANDATORY TEMP AT 700      CROSS    2D                SFCPRS.61
C                 T500     MANDATORY TEMP AT 500      CROSS    2D                SFCPRS.62
C                 GAMMA78  LOCAL LAPSE RATE 850-700   CROSS    2D                SFCPRS.63
C                 GAMMA57  LOCAL LAPSE RATE 700-500   CROSS    2D                SFCPRS.64
C                                                                                SFCPRS.65
C     OUTPUT      PSFC     SURFACE PRESSURE           CROSS    2D                SFCPRS.66
C                 TSFC     SURFACE TEMPERATURE        CROSS    2D                SFCPRS.67
      CHARACTER *6 PROG                                                          SFCPRS.68
      PARAMETER (R=287.04,G=9.8)                                                 SFCPRS.69
      PARAMETER (TC=273.16+17.5) ! T CRITICAL IN PSFC/PSLV                       SFCPRS.70
      PARAMETER (PCONST=100.)                                                    SFCPRS.71
C                                                                                SFCPRS.72
      LOGICAL L1,L2,L3                                                           SFCPRS.73
C                                                                                SFCPRS.74
      DIMENSION T(IMX,JMX,KX)   ,Q(IMX,JMX,KX)  ,HEIGHT(IMX,JMX,KX) ,            SFCPRS.75
     *          PSLV(IMX,JMX)   ,TER(IMX,JMX)   ,                                SFCPRS.76
     *          P(KX)                                                            SFCPRS.77
      DIMENSION HT(IMX,JMX)   ,TSLV(IMX,JMX)   ,                                 SFCPRS.78
     *          P1(IMX,JMX)   ,T1(IMX,JMX)  ,TFIXED(IMX,JMX) ,                   SFCPRS.79
     *          T850(IMX,JMX) ,T700(IMX,JMX),T500(IMX,JMX)   ,                   SFCPRS.80
     *          GAMMA78(IMX,JMX)              ,GAMMA57(IMX,JMX)                  SFCPRS.81
      DIMENSION PSFC(IMX,JMX)   ,TSFC(IMX,JMX)                                   SFCPRS.82
C                                                                                SFCPRS.83
#     include <cray_vector_func.incl>                                            SFCPRS.84
C                                                                                SFCPRS.85
C                                                                                SFCPRS.86
C     ... GET INITIAL SURFACE PRESSURE, ABOVE DIURNAL EFFECTS                    SFCPRS.87
C                                                                                SFCPRS.88
      K850=0  ! FIND K AT: P=850, P=700, P=500                                   SFCPRS.89
      K700=0                                                                     SFCPRS.90
      K500=0                                                                     SFCPRS.91
      DO 150 K=1,KX                                                              SFCPRS.92
         IF(ABS(P(K)-850.) .LT. 0.0001) THEN                                     SFCPRS.93
            K850=K                                                               SFCPRS.94
         ELSE IF(ABS(P(K)-700.) .LT. 0.0001) THEN                                SFCPRS.95
            K700=K                                                               SFCPRS.96
         ELSE IF(ABS(P(K)-500.) .LT. 0.0001) THEN                                SFCPRS.97
            K500=K                                                               SFCPRS.98
         END IF                                                                  SFCPRS.99
150   CONTINUE                                                                   SFCPRS.100
      IF( (K850.EQ.0).OR.(K700.EQ.0).OR.(K500.EQ.0) ) THEN                       SFCPRS.101
         PRINT *,'ERROR IN FINDING P LEVEL'                                      SFCPRS.102
         DO 180 K=1,KX                                                           SFCPRS.103
            PRINT *,'K=',K,'  PRESSURE=',P(K)                                    SFCPRS.104
180      CONTINUE                                                                SFCPRS.105
         CALL ABORT                                                              SFCPRS.106
      END IF                                                                     SFCPRS.107
C                                                                                SFCPRS.108
      IF((PROG(1:6).EQ.'RAWINS') .OR.                                            SFCPRS.109
     *   (PROG(1:6).EQ.'REGRID')) THEN                                           SFCPRS.110
         DO 200 J=1,JMX                                                          SFCPRS.111
         DO 200 I=1,IMX                                                          SFCPRS.112
            HT(I,J)=HEIGHT(I,J,K850)                                             SFCPRS.113
200      CONTINUE                                                                SFCPRS.114
         CALL DOT2CRS(HT,IMX,JMX,1,IMX,JMX)                                      SFCPRS.115
      ELSE IF((PROG(1:6).EQ.'MMOUTP').OR.(PROG(1:6).EQ.'MZIGPR')) THEN           SFCPRS.116
         DO 220 J=1,JMX-1                                                        SFCPRS.117
         DO 220 I=1,IMX-1                                                        SFCPRS.118
            HT(I,J)=HEIGHT(I,J,K850)                                             SFCPRS.119
220      CONTINUE                                                                SFCPRS.120
      ELSE                                                                       SFCPRS.121
         PRINT *,'... AND WHAT PROGRAM IS THIS?'                                 SFCPRS.122
         PRINT *,'DATA IS INPUT FROM PROGRAM ',PROG(1:6)                         SFCPRS.123
         PRINT *,'CONTINUING'                                                    SFCPRS.124
         DO 230 J=1,JMX-1                                                        SFCPRS.125
         DO 230 I=1,IMX-1                                                        SFCPRS.126
            HT(I,J)=HEIGHT(I,J,K850)                                             SFCPRS.127
230      CONTINUE                                                                SFCPRS.128
      END IF                                                                     SFCPRS.129
                                                                                 SFCPRS.130
      DO 250 J=1,JMX-1                                                           SFCPRS.131
      DO 250 I=1,IMX-1                                                           SFCPRS.132
         HT(I,J)=-TER(I,J)/HT(I,J)                                               SFCPRS.133
250   CONTINUE                                                                   SFCPRS.134
C                                                                                SFCPRS.135
C     ... SMOOTH THE SEA LEVEL PRESSURE A LOT, IF FROM RAWINS                    SFCPRS.136
C                                                                                SFCPRS.137
      IF(PROG(1:6).EQ.'RAWINS') CALL SMTHER(PSLV,PSFC,IMX,JMX,1,5,1)             SFCPRS.138
      DO 300 J=1,JMX-1 ! DUMMY VALUE -------------^                              SFCPRS.139
      DO 300 I=1,IMX-1                                                           SFCPRS.140
         PSFC(I,J)=PSLV(I,J) * (PSLV(I,J)/850.)**HT(I,J)                         SFCPRS.141
300   CONTINUE                                                                   SFCPRS.142
C                                                                                SFCPRS.143
C     ... FIRST GUESS AT SEA LEVEL TEMP                                          SFCPRS.144
C                                                                                SFCPRS.145
      DO 400 J=1,JMX-1      ! IF 950 <= PSFC       THEN P1=850                   SFCPRS.146
      DO 400 I=1,IMX-1      ! IF 700 <= PSFC < 950 THEN P1=PSFC-100              SFCPRS.147
         P1(I,J)=           ! IF        PSFC < 700 THEN P1=500                   SFCPRS.148
     *   CVMGP(850.,                                                             SFCPRS.149
     *      CVMGP(PSFC(I,J)-100.,500.,PSFC(I,J)-700.),                           SFCPRS.150
     *   PSFC(I,J)-950.)                                                         SFCPRS.151
400   CONTINUE                                                                   SFCPRS.152
      GAMMA=6.5E-3                                                               SFCPRS.153
      CALL TVIRT(T(1,1,K850),Q(1,1,K850),IMX,JMX,1,T850,IMX,JMX)                 SFCPRS.154
      CALL TVIRT(T(1,1,K700),Q(1,1,K700),IMX,JMX,1,T700,IMX,JMX)                 SFCPRS.155
      CALL TVIRT(T(1,1,K500),Q(1,1,K500),IMX,JMX,1,T500,IMX,JMX)                 SFCPRS.156
      P78=1./ALOG(850./700.)                                                     SFCPRS.157
      P57=1./ALOG(700./500.)                                                     SFCPRS.158
      DO 450 J=1,JMX-1  ! COMPUTE LAPSE RATES FOR 2 TERRAIN HEIGHTS              SFCPRS.159
      DO 450 I=1,IMX-1                                                           SFCPRS.160
         GAMMA78(I,J)=ALOG(T850(I,J)/T700(I,J))*P78                              SFCPRS.161
         GAMMA57(I,J)=ALOG(T700(I,J)/T500(I,J))*P57                              SFCPRS.162
450   CONTINUE                                                                   SFCPRS.163
      DO 500 J=1,JMX-1  ! IF 950 <= PSFC       THEN T1=T(850)                    SFCPRS.164
      DO 500 I=1,IMX-1  ! IF 850 <= PSFC < 950 THEN T1=T(700) * STUFF            SFCPRS.165
         T1(I,J)=       ! IF 700 <= PSFC < 850 THEN T1=T(500) * STUFF            SFCPRS.166
     *   CVMGP(T850(I,J), ! IF      PSFC < 700 THEN T1=T(500)                    SFCPRS.167
     *      CVMGP(T700(I,J)*(P1(I,J)/700.)**GAMMA78(I,J),                        SFCPRS.168
     *         CVMGP(T500(I,J)*(P1(I,J)/500.)**GAMMA57(I,J),                     SFCPRS.169
     *            T500(I,J),                                                     SFCPRS.170
     *         PSFC(I,J)-700.),                                                  SFCPRS.171
     *      PSFC(I,J)-850.),                                                     SFCPRS.172
     *   PSFC(I,J)-950.)                                                         SFCPRS.173
500   CONTINUE                                                                   SFCPRS.174
      GAMMARG=GAMMA*R/G                                                          SFCPRS.175
      DO 700 J=1,JMX-1   ! SEA LEVEL TEMPERATURE CORRECTED P1, T1                SFCPRS.176
      DO 700 I=1,IMX-1                                                           SFCPRS.177
         TSLV(I,J)=T1(I,J)*(PSLV(I,J)/P1(I,J))**(GAMMARG)                        SFCPRS.178
700   CONTINUE                                                                   SFCPRS.179
C                                                                                SFCPRS.180
C     ... GUESS SURFACE TEMPERATURE WITH NEW SEA LEVEL TEMPERATURE               SFCPRS.181
C                                                                                SFCPRS.182
      DO 1000 J=1,JMX-1                                                          SFCPRS.183
      DO 1000 I=1,IMX-1                                                          SFCPRS.184
         TSFC(I,J)=TSLV(I,J)-GAMMA*TER(I,J)                                      SFCPRS.185
1000  CONTINUE                                                                   SFCPRS.186
C                                                                                SFCPRS.187
C     ... SECOND GUESS AT SEA LEVEL TEMPERATURE                                  SFCPRS.188
C                                                                                SFCPRS.189
      DO 1100 J=1,JMX-1  ! CORRECTION USING T CRITICAL                           SFCPRS.190
      DO 1100 I=1,IMX-1                                                          SFCPRS.191
         TFIXED(I,J)=TC-0.005*(TSFC(I,J)-TC)**2                                  SFCPRS.192
1100  CONTINUE                                                                   SFCPRS.193
      DO 1200 J=1,JMX-1  ! IF TSFC > TC, FIX SEA LEVEL TEMP                      SFCPRS.194
      DO 1200 I=1,IMX-1                                                          SFCPRS.195
         L1=TSLV(I,J).LT.TC                                                      SFCPRS.196
         L2=TSFC(I,J).LE.TC                                                      SFCPRS.197
         L3=.NOT.L1                                                              SFCPRS.198
         TSLV(I,J)=                                                              SFCPRS.199
     *   CVMGT(TSLV(I,J),                                                        SFCPRS.200
     *      CVMGT(TC,TFIXED(I,J),L2.AND.L3),                                     SFCPRS.201
     *   L1)                                                                     SFCPRS.202
1200  CONTINUE                                                                   SFCPRS.203
C                                                                                SFCPRS.204
C     ... DIAGNOSE SURFACE PRESSURE                                              SFCPRS.205
C                                                                                SFCPRS.206
      ROV2=R/2.                                                                  SFCPRS.207
      DO 1500 J=1,JMX-1                                                          SFCPRS.208
      DO 1500 I=1,IMX-1                                                          SFCPRS.209
         P1(I,J)=(-TER(I,J)*G) / (ROV2 * (TSFC(I,J)+TSLV(I,J)))                  SFCPRS.210
         PSFC(I,J)=PSLV(I,J) * EXP(P1(I,J))                                      SFCPRS.211
1500  CONTINUE                                                                   SFCPRS.212
C                                                                                SFCPRS.213
C     ... SURFACE PRES = SEA LEVEL PRES OVER OCEAN                               SFCPRS.214
C                                                                                SFCPRS.215
      DO 1700 J=1,JMX-1                                                          SFCPRS.216
      DO 1700 I=1,IMX-1                                                          SFCPRS.217
         PSFC(I,J)=CVMGP(PSFC(I,J),PSLV(I,J),TER(I,J))                           SFCPRS.218
1700  CONTINUE                                                                   SFCPRS.219
C                                                                                SFCPRS.220
C     ... FIND NUMBER OF LEVELS UNDERGROUND, THESE ARE INTERPOLATED              SFCPRS.221
C                                                                                SFCPRS.222
      CALL CLEAR(P1,IMX,JMX,1)                                                   SFCPRS.223
      DO 2000 K=2,KX                                                             SFCPRS.224
      DO 2000 J=1,JMX-1                                                          SFCPRS.225
      DO 2000 I=1,IMX-1                                                          SFCPRS.226
         P1(I,J)=P1(I,J)+CVMGT(1.,0.,P(K).GT.PSFC(I,J))                          SFCPRS.227
2000  CONTINUE                                                                   SFCPRS.228
C                                                                                19DEC02.48
C     ... MAKE TEMPERATURE THAT OF A VIRTUAL NATURE.                             19DEC02.49
C                                                                                19DEC02.50
      DO 2101 K=2,KX                                                             19DEC02.51
      DO 2101 J=1,JMX-1                                                          19DEC02.52
      DO 2101 I=1,IMX-1                                                          19DEC02.53
         T(I,J,K)=T(I,J,K)*(1.+0.608*Q(I,J,K))                                   19DEC02.54
2101  CONTINUE                                                                   19DEC02.55
C                                                                                SFCPRS.229
C     ... INTERPOLATE HEIGHT UNDERGROUND                                         SFCPRS.230
C                                                                                SFCPRS.231
      DO 2300 J=1,JMX-1                                                          SFCPRS.232
      DO 2300 I=1,IMX-1                                                          SFCPRS.233
         KINTERP=NINT(P1(I,J))                                                   SFCPRS.234
         IF(ABS(PSLV(I,J)-PSFC(I,J)).GT.0.001) THEN
            DO 2100 K=2,KINTERP+1                                                SFCPRS.236
               HEIGHT(I,J,K)=TER(I,J)*                                           SFCPRS.237
     *            (PSLV(I,J)**0.1902632-P(K)**0.1902632)/                        SFCPRS.238
     *            (PSLV(I,J)**0.1902632-PSFC(I,J)**0.1902632)                    SFCPRS.239
2100        CONTINUE                                                             SFCPRS.240
         ELSE                                                                    SFCPRS.241
            DO 2200 K=2,KINTERP+1                                                SFCPRS.242
               TBAR=(T(I,J,K)*ALOG(P(K))+TSLV(I,J)*ALOG(PSLV(I,J)))/             SFCPRS.243
     *            ALOG(P(K)*PSLV(I,J))                                           SFCPRS.244
               HEIGHT(I,J,K)=-R/G * TBAR * ALOG(P(K)/PSLV(I,J))                  SFCPRS.245
2200        CONTINUE                                                             SFCPRS.246
         END IF                                                                  SFCPRS.247
2300  CONTINUE                                                                   SFCPRS.248
C                                                                                SFCPRS.249
C     ... GET LOWEST LEVEL IF NOT INTERPOLATED                                   SFCPRS.250
C                                                                                SFCPRS.251
      DO 2400 J=1,JMX-1                                                          SFCPRS.252
      DO 2400 I=1,IMX-1                                                          SFCPRS.253
         K=2                                                                     SFCPRS.254
         KINTERP=NINT(P1(I,J))                                                   SFCPRS.255
         IF((KINTERP.EQ.0).AND.(P(K).EQ.PSFC(I,J))) THEN                         SFCPRS.256
            HEIGHT(I,J,2)=TER(I,J)                                               SFCPRS.257
            P1(I,J)=1.                                                           SFCPRS.258
         ELSE IF((KINTERP.EQ.0).AND.(P(K).EQ.PSLV(I,J))) THEN                    SFCPRS.259
            HEIGHT(I,J,2)=0.                                                     SFCPRS.260
            P1(I,J)=1.                                                           SFCPRS.261
         ELSE IF((KINTERP.EQ.0).AND.(P(K).LT.PSFC(I,J))) THEN                    SFCPRS.262
            TBAR=(T(I,J,K)*ALOG(P(K))+TSLV(I,J)*ALOG(PSLV(I,J)))/                SFCPRS.263
     *         ALOG(P(K)*PSLV(I,J))                                              SFCPRS.264
            HEIGHT(I,J,K)=-R/G * TBAR * ALOG(P(K)/PSLV(I,J))                     SFCPRS.265
            P1(I,J)=1.                                                           SFCPRS.266
         END IF                                                                  SFCPRS.267
2400  CONTINUE                                                                   SFCPRS.268
C                                                                                SFCPRS.269
C     ... INTEGRATE HEIGHT ABOVE SURFACE                                         SFCPRS.270
C                                                                                SFCPRS.271
      DO 2600 J=1,JMX-1                                                          SFCPRS.272
      DO 2600 I=1,IMX-1                                                          SFCPRS.273
         KINTERP=NINT(P1(I,J))                                                   SFCPRS.274
         DO 2500 K=KINTERP+2,KX                                                  SFCPRS.275
            TBAR=(T(I,J,K)*ALOG(P(K))+T(I,J,K-1)*ALOG(P(K-1)))/                  SFCPRS.276
     *         ALOG(P(K)*P(K-1))                                                 SFCPRS.277
            HEIGHT(I,J,K)=HEIGHT(I,J,K-1)+R/G*TBAR*ALOG(P(K-1)/P(K))             SFCPRS.278
2500     CONTINUE                                                                SFCPRS.279
2600  CONTINUE                                                                   SFCPRS.280
      RETURN                                                                     SFCPRS.281
      END                                                                        SFCPRS.282
