      SUBROUTINE SKEWT (PRES,TEMP,DWPT,SPD,DIR,NN,TITLINE,                       SKEWT.1
     &   CDATENOW,CDATE,XTIME,ISTAT,XLOC,YLOC,YLAT,YLON,BADVAL)                  SKEWT.2
C                                                                                SKEWT.3
C     SKEWT- PLOTS SOUNDINGS ON A SKEWT, LOG P THERMODYNAMIC DIAGRAM             SKEWT.4
C                                                                                SKEWT.5
C     PRES- PRESSURE ARRAY FOR THERMODYNAMIC DATA (MB)                           SKEWT.6
C     TEMP- TEMPERATURE ARRAY (CELSIUS)                                          SKEWT.7
C     DWPT- DEW POINT ARRAY (CELSIUS)                                            SKEWT.8
C     SPD- WIND SPEED ARRAY (M/S)                                                SKEWT.9
C     DIR- WIND DIRECTION ARRAY (DEGREES-0 IS NORTH)                             SKEWT.10
C     NN- NUMBER OF DATA LEVELS                                                  SKEWT.11
C     MDATE - CURRENT MODEL TIME YYMMDDHH                                        SKEWT.12
C     MDATEBEG - MODEL INITIAL TIME YYMMDDHH                                     SKEWT.13
C     XTIME - FORECAST TIME                                                      SKEWT.14
C     ISTAT- STRING CONTAINING STATION NAME (80 CHAR.)                           SKEWT.15
C     BADVAL- VALUE ASSIGNED TO MISSING DATA  --TEMP,DWPT TRACES ARE             SKEWT.16
C                   TERMINATED AS SOON AS THIS NUMBER IS ENCOUNTERED.            SKEWT.17
C                                                                                SKEWT.18
C        OUTPUT PARAMETERS.....                                                  SKEWT.19
C     ALL INPUT PARAMETERS REMAIN UNCHANGED BY THIS ROUTINE.                     SKEWT.20
C                                                                                SKEWT.21
      DIMENSION PRES(1),TEMP(1),DWPT(1),SPD(1),DIR(1)                            SKEWT.22
      CHARACTER LAB*120, ISTAT*80                                                SKEWT.23
C                                                                                SKEWT.24
      CHARACTER *80    TITLINE                                                   SKEWT.25
      INTEGER          ITSTRT,                                                   SKEWT.26
     *                 ITITLEN,                                                  SKEWT.27
     *                 LCNTR                                                     SKEWT.28
      COMMON /MAPSTUFF/ XLONC,PHIC,XLAT1,XLON1,XLAT2,XLON2,                      SKEWT.29
     *   ISTART,IEND,JSTART,JEND,                                                SKEWT.30
     *   IMAPMAX,IMAPST,IMAPEND,JMAPMAX,JMAPST,JMAPEND,                          SKEWT.31
     *   XPA,XPB,YPA,YPB,                                                        SKEWT.32
     *   DS,OVERLAY,IFRAME,INSIDE,IFORM,NUMFRAME                                 SKEWT.33
      LOGICAL OVERLAY                                                            SKEWT.34
      COMMON /SKWDRW/ ISKDRW                                                     SKEWT.35
      CHARACTER *2 ISPOPT                                                        SKEWT.36
      CHARACTER *19 CDATE, CDATENOW                                              SKEWT.37
      CHARACTER *13 CDATEB                                                       SKEWT.38
C                                                                                SKEWT.39
C  DEGREES TO RADIANS                                                            SKEWT.40
      PARAMETER (DTR = 0.0174532925)                                             SKEWT.41
C  WIND BARB DATA                                                                SKEWT.42
      PARAMETER (XM = 24.2)                                                      SKEWT.43
C                                                                                SKEWT.44
C  LINE WIDTH VARIABLES                                                          SKEWT.45
C                                                                                SKEWT.46
      DATA ISPOPT / 'LW' /                                                       SKEWT.47
      DATA ISWIDE / 2000 /                                                       SKEWT.48
C                                                                                SKEWT.49
C  MAPPINGS FROM (P,T) TO CM ON SKEWT                                            SKEWT.50
C                                                                                SKEWT.51
      FY(P) = 132.182 - 44.061 * ALOG10(P)                                       SKEWT.52
      FX(T,Y) = 0.54 * T + 0.90692 * Y                                           SKEWT.53
C                                                                                SKEWT.54
C  TEST TO SEE IF A BACKGROUND HAS BEEN DRAWN, IF NOT CALL SKWTBKG               SKEWT.55
C                                                                                SKEWT.56
            CALL GSPLCI (1 )                                                     SKEWT.57
            CALL GSPMCI (1 )                                                     SKEWT.58
            CALL GSTXCI (1 )                                                     SKEWT.59
      IF (ISKDRW .EQ. 0) THEN                                                    SKEWT.60
        CALL SKWTBKG                                                             SKEWT.61
        ISKDRW = 1                                                               SKEWT.62
      END IF                                                                     SKEWT.63
            CALL GSPLCI (9 )                                                     SKEWT.64
            CALL GSPMCI (9 )                                                     SKEWT.65
            CALL GSTXCI (9 )                                                     SKEWT.66
C                                                                                SKEWT.67
C  SKEWT BACKGROUND HAS BEEN GENERATED-- PLOT THE SOUNDING                       SKEWT.68
C                                                                                SKEWT.69
      CALL GFLAS3 (1)                                                            SKEWT.70
      CALL SET(.05,.95,.05,.95,-19.0,27.1,-.9346217,44.061,1)                    SKEWT.71
C                                                                                SKEWT.72
C  PUT ON TITLE                                                                  SKEWT.73
C                                                                                SKEWT.74
      CDATEB = CDATE(1:13)                                                       SKEWT.75
      ITSTRT = INDEX(TITLINE,':')                                                SKEWT.76
      IF (ITSTRT .NE. 0) THEN                                                    SKEWT.77
        DO 80 LCNTR=1,80-ITSTRT+1                                                SKEWT.78
          TITLINE(LCNTR:LCNTR) = TITLINE(LCNTR+ITSTRT:LCNTR+ITSTRT)              SKEWT.79
80      CONTINUE                                                                 SKEWT.80
        DO 90 LCNTR=80-ITSTRT+2,80                                               SKEWT.81
          TITLINE(LCNTR:LCNTR)=' '                                               SKEWT.82
90      CONTINUE                                                                 SKEWT.83
        ITITLEN = 80                                                             SKEWT.84
        DO 100 LCNTR=80,1,-1                                                     SKEWT.85
          IF (TITLINE(LCNTR:LCNTR) .NE. ' ') THEN                                SKEWT.86
            ITITLEN = LCNTR                                                      SKEWT.87
            GOTO 110                                                             SKEWT.88
          END IF                                                                 SKEWT.89
100     CONTINUE                                                                 SKEWT.90
110     CONTINUE                                                                 SKEWT.91
      ELSE                                                                       SKEWT.92
         ITITLEN=LEN(TITLINE)                                                    SKEWT.93
      END IF                                                                     SKEWT.94
      CALL WTSTR (4.05,-2.4,TITLINE(1:ITITLEN),12,0,0)                           SKEWT.95
      IF (XTIME .LT. -50.) THEN                                                  SKEWT.96
         WRITE(LAB,106) ISTAT, CDATENOW, XLOC, YLOC,                             SKEWT.97
     &      YLAT, YLON                                                           SKEWT.98
      ICHRLEN = 100                                                              SKEWT.99
      ELSE IF (XTIME .GT. -50.) THEN                                             SKEWT.100
        WRITE(LAB,107) ISTAT, CDATENOW, CDATEB, XTIME, XLOC,                     SKEWT.101
     &      YLOC, YLAT, YLON                                                     SKEWT.102
      ICHRLEN =117                                                               SKEWT.103
      ENDIF                                                                      SKEWT.104
      CALL WTSTR (-19.5,-1.4,LAB(1:ICHRLEN),8,0,-1)                              SKEWT.105
  106 FORMAT(1X,A40,1X,A19,' X=',F6.2,' Y=',F6.2,                                SKEWT.106
     &   2X,F7.2,2X,F7.2)                                                        SKEWT.107
  107 FORMAT(1X,A30,1X,A19,' = ',A13,'+',F6.2,'H  X=',F6.2,' Y=',F6.2,           SKEWT.108
     &   2X,F7.2,2X,F7.2)                                                        SKEWT.109
            CALL GSPLCI (1 )                                                     SKEWT.110
            CALL GSPMCI (1 )                                                     SKEWT.111
            CALL GSTXCI (1 )                                                     SKEWT.112
      IF(NN.GT.0) CALL LINE(XM,-.9346217,XM,44.061)                              SKEWT.113
C                                                                                SKEWT.114
C  SOLID DASH PATTERN, INCREASED SPOT SIZE (DEFAULT=8)                           SKEWT.115
C                                                                                SKEWT.116
      CALL DASHDB (65535)                                                        SKEWT.117
      CALL GETUSV (ISPOPT,ISNORM)                                                SKEWT.118
      ISWIDE = ISWIDE + 3000                                                     SKEWT.119
      CALL SETUSV (ISPOPT,ISWIDE)                                                SKEWT.120
      ISWIDE = ISWIDE - 3000                                                     SKEWT.121
C                                                                                SKEWT.122
            CALL SETUSV('LW',6000)                                               SKEWT.123
            CALL GSPLCI (16)                                                     SKEWT.124
            CALL GSPMCI (16)                                                     SKEWT.125
            CALL GSTXCI (16)                                                     SKEWT.126
      DO 60 I=1,NN                                                               SKEWT.127
        IF(TEMP(I).EQ.BADVAL)GO TO 61                                            SKEWT.128
          Y=FY(PRES(I))                                                          SKEWT.129
          X=FX(TEMP(I),Y)                                                        SKEWT.130
          IF (I.EQ.1) CALL FRSTPT(X,Y)                                           SKEWT.131
          CALL VECTOR(X,Y)                                                       SKEWT.132
   60 CONTINUE                                                                   SKEWT.133
   61 CONTINUE                                                                   SKEWT.134
            CALL SETUSV('LW',4000)                                               SKEWT.135
            CALL GSPLCI (12)                                                     SKEWT.136
            CALL GSPMCI (12)                                                     SKEWT.137
            CALL GSTXCI (12)                                                     SKEWT.138
      DO 70 I=1,NN                                                               SKEWT.139
         IF(DWPT(I).EQ.BADVAL)GO TO 71                                           SKEWT.140
            Y=FY(PRES(I))                                                        SKEWT.141
            X=FX(DWPT(I),Y)                                                      SKEWT.142
            IF(I.EQ.1)CALL FRSTPT(X,Y)                                           SKEWT.143
            CALL VECTOR(X,Y)                                                     SKEWT.144
   70 CONTINUE                                                                   SKEWT.145
   71 CONTINUE                                                                   SKEWT.146
            CALL SETUSV('LW',2000)                                               SKEWT.147
            CALL GSPLCI (8 )                                                     SKEWT.148
            CALL GSPMCI (8 )                                                     SKEWT.149
            CALL GSTXCI (8 )                                                     SKEWT.150
C                                                                                SKEWT.151
C         PLOT WIND VECTORS                                                      SKEWT.152
C                                                                                SKEWT.153
      IF (NN.LE.0) GO TO 76                                                      SKEWT.154
C                                                                                SKEWT.155
      CALL SETUSV (ISPOPT,ISWIDE)                                                SKEWT.156
      DO 75 I=1,NN                                                               SKEWT.157
      IF (DIR(I) .GT. 360.) GO TO 75                                             SKEWT.158
          ANG=DIR(I)*DTR                                                         SKEWT.159
          U = -SPD(I)*SIN(ANG)                                                   SKEWT.160
          V = -SPD(I)*COS(ANG)                                                   SKEWT.161
          Y1=FY(PRES(I))                                                         SKEWT.162
      CALL WNDBARB (XM,Y1,U,V)                                                   SKEWT.163
   75 CONTINUE                                                                   SKEWT.164
   76 CONTINUE                                                                   SKEWT.165
            CALL GSPLCI (1 )                                                     SKEWT.166
            CALL GSPMCI (1 )                                                     SKEWT.167
            CALL GSTXCI (1 )                                                     SKEWT.168
C                                                                                SKEWT.169
C  RESET TO NORMAL SPOT SIZE AND EXIT                                            SKEWT.170
C                                                                                SKEWT.171
      CALL SETUSV (ISPOPT,ISNORM)                                                SKEWT.172
C                                                                                SKEWT.173
      NUMFRAME=NUMFRAME+1                                                        SKEWT.174
      CALL FRAME                                                                 SKEWT.175
C                                                                                SKEWT.176
      RETURN                                                                     SKEWT.177
      END                                                                        SKEWT.178
