      SUBROUTINE SKWTBKG                                                         SKWTBKG.1
C                                                                                SKWTBKG.2
C  SKWTBKG- PLOTS BACKGROUND FOR A SKEWT, LOG P THERMODYNAMIC DIAGRAM            SKWTBKG.3
C                                                                                SKWTBKG.4
      COMMON /SKWDRW/ ISKDRW                                                     SKWTBKG.5
C                                                                                SKWTBKG.6
C  ENCODE BUFFER                                                                 SKWTBKG.7
C                                                                                SKWTBKG.8
      CHARACTER*4 ITIT                                                           SKWTBKG.9
C                                                                                SKWTBKG.10
C  SKEWT BORDER                                                                  SKWTBKG.11
C                                                                                SKWTBKG.12
      DIMENSION XB(7),YB(7)                                                      SKWTBKG.13
      DATA XB/-19.,27.1,27.1,18.6,18.6,-19.,-19./                                SKWTBKG.14
      DATA YB/-.9346217,-.9346217,9.,17.53,44.061,44.061,-.9346217/              SKWTBKG.15
C                                                                                SKWTBKG.16
C  PRESSURE LINE SPECS                                                           SKWTBKG.17
C                                                                                SKWTBKG.18
      DIMENSION PLV(11),PLN(11,2)                                                SKWTBKG.19
      DATA PLV/100.,200.,300.,400.,500.,600.,700.,800.,900.,                     SKWTBKG.20
     &         1000.,1050./                                                      SKWTBKG.21
      DATA PLN/11*-19.,4*18.6,22.83,26.306,5*27.1/                               SKWTBKG.22
C                                                                                SKWTBKG.23
C  TEMPERATURE LINE SPECS                                                        SKWTBKG.24
C                                                                                SKWTBKG.25
      DIMENSION TP(15,2)                                                         SKWTBKG.26
      DATA TP/8*1050.,855.,625.,459.,337.,247.,181.,132.,730.,580.,500.,         SKWTBKG.27
     &   430.,342.,251.,185.,135.,7*100./                                        SKWTBKG.28
C                                                                                SKWTBKG.29
C  MIXING RATIO SPECS                                                            SKWTBKG.30
C                                                                                SKWTBKG.31
      REAL        RAT(8)                                                         SKWTBKG.32
      CHARACTER*2 LRAT(8)                                                        SKWTBKG.33
      DATA RAT/20.,12.,8.,5.,3.,2.,1.,0.4/                                       SKWTBKG.34
      DATA LRAT/'20','12',' 8',' 5',' 3',' 2',' 1','.4'/                         SKWTBKG.35
C                                                                                SKWTBKG.36
C  DRY/SATURATED ADAIBAT BUFFERS                                                 SKWTBKG.37
C                                                                                SKWTBKG.38
      DIMENSION SX(162),SY(162),Y45(162)                                         SKWTBKG.39
C                                                                                SKWTBKG.40
C  DEGREES TO RADIANS, ABSOLUTE ZERO                                             SKWTBKG.41
C                                                                                SKWTBKG.42
      PARAMETER (ABZ = 273.16)                                                   SKWTBKG.43
C                                                                                SKWTBKG.44
C  MAPPINGS FROM (P,T) TO CM ON SKEWT                                            SKWTBKG.45
C                                                                                SKWTBKG.46
      FY(P)=132.182-44.061*ALOG10(P)                                             SKWTBKG.47
      FX(T,Y)=0.54*T+0.90692*Y                                                   SKWTBKG.48
C                                                                                SKWTBKG.49
C  DRAW SKEWT BORDER                                                             SKWTBKG.50
C                                                                                SKWTBKG.51
      CALL GFLAS1 (1)                                                            SKWTBKG.52
      CALL SET(.05,.95,.05,.95,-19.0,27.1,-.9346217,44.061,1)                    SKWTBKG.53
      CALL CURVE(XB,YB,7)                                                        SKWTBKG.54
C                                                                                SKWTBKG.55
C  DRAW THE PRESSURE LINES                                                       SKWTBKG.56
C                                                                                SKWTBKG.57
      DO 10 K=1,11                                                               SKWTBKG.58
         Y1=FY(PLV(K))                                                           SKWTBKG.59
         IF(K.NE.1.AND.K.NE.11) CALL LINE(PLN(K,1),Y1,PLN(K,2),Y1)               SKWTBKG.60
         ITS=NINT(PLV(K))                                                        SKWTBKG.61
      WRITE (ITIT,101) ITS                                                       SKWTBKG.62
  101    FORMAT(I4)                                                              SKWTBKG.63
C        CALL PWRY(-20.9,Y1,ITIT,4,1.9,0,0)                                      SKWTBKG.64
      CALL WTSTR (-19.2,Y1,ITIT,11,0,1)                                          SKWTBKG.65
   10 CONTINUE                                                                   SKWTBKG.66
C                                                                                SKWTBKG.67
C  DRAW TEMPERATURE LINES                                                        SKWTBKG.68
C                                                                                SKWTBKG.69
      T=40.                                                                      SKWTBKG.70
      DO 20 I=1,15                                                               SKWTBKG.71
         Y1=FY(TP(I,1))                                                          SKWTBKG.72
         Y2=FY(TP(I,2))                                                          SKWTBKG.73
         X1=FX(T,Y1)                                                             SKWTBKG.74
         X2=FX(T,Y2)                                                             SKWTBKG.75
         CALL LINE(X1,Y1,X2,Y2)                                                  SKWTBKG.76
         ITS=NINT(T)                                                             SKWTBKG.77
         IF(ITS.EQ.20) GO TO 19                                                  SKWTBKG.78
            X2=X2+0.4                                                            SKWTBKG.79
            Y2=Y2+0.441                                                          SKWTBKG.80
      WRITE (ITIT,101) ITS                                                       SKWTBKG.81
C           CALL PWRY(X2,Y2,ITIT,4,12,.83422,0)                                  SKWTBKG.82
      CALL WTSTR (X2,Y2,ITIT,12,47,-1)                                           SKWTBKG.83
   19    T=T-10.                                                                 SKWTBKG.84
   20 CONTINUE                                                                   SKWTBKG.85
C                                                                                SKWTBKG.86
C  TICK MARKS AT 500 MB                                                          SKWTBKG.87
C                                                                                SKWTBKG.88
      Y1=13.2627                                                                 SKWTBKG.89
      Y2=13.75                                                                   SKWTBKG.90
      T=-52.                                                                     SKWTBKG.91
      DO 25 I=1,31                                                               SKWTBKG.92
         T=T+2.                                                                  SKWTBKG.93
         IF(AMOD(T,10.).EQ.0.)GO TO 25                                           SKWTBKG.94
         X1=FX(T,Y1)                                                             SKWTBKG.95
         X2=FX(T,Y2)                                                             SKWTBKG.96
         CALL LINE(X1,Y1,X2,Y2)                                                  SKWTBKG.97
   25 CONTINUE                                                                   SKWTBKG.98
C                                                                                SKWTBKG.99
C  DRAW MIXING RATIO LINES                                                       SKWTBKG.100
C                                                                                SKWTBKG.101
      CALL DASHDB (3855)      ! PATTERN = 0000111100001111                       SKWTBKG.102
      Y1=FY(1050.)                                                               SKWTBKG.103
      Y2=FY(700.)                                                                SKWTBKG.104
      DO 30 I=1,8                                                                SKWTBKG.105
         X1=FX(TMR(RAT(I),1050.)-ABZ,Y1)                                         SKWTBKG.106
         X2=FX(TMR(RAT(I), 700.)-ABZ,Y2)                                         SKWTBKG.107
         CALL LINED(X1,Y1,X2,Y2)                                                 SKWTBKG.108
C        CALL PWRY(X2,Y2+0.6,LRAT(I),2,10,0,1)                                   SKWTBKG.109
      CALL WTSTR (X2,Y2+0.6,LRAT(I),10,0,0)                                      SKWTBKG.110
   30 CONTINUE                                                                   SKWTBKG.111
C                                                                                SKWTBKG.112
C  DRAW SATURATED ADIABATS                                                       SKWTBKG.113
C                                                                                SKWTBKG.114
      CALL DASHDB (31710)     ! PATTERN = 0111101111011110                       SKWTBKG.115
      TS=32.                                                                     SKWTBKG.116
      DO 40 I=1,14                                                               SKWTBKG.117
         K=0                                                                     SKWTBKG.118
         P=1060.                                                                 SKWTBKG.119
         TK=TS+ABZ                                                               SKWTBKG.120
         AOS=OS(TK,1000.)                                                        SKWTBKG.121
         DO 35 J=1,86                                                            SKWTBKG.122
            P=P-10.                                                              SKWTBKG.123
            ATSA=TSA(AOS,P)-ABZ                                                  SKWTBKG.124
            YPD = FY(P)                                                          SKWTBKG.125
            XPD = FX(ATSA,YPD)                                                   SKWTBKG.126
            IF (XPD .LT. -19.0) GO TO 36                                         SKWTBKG.127
            K = K + 1                                                            SKWTBKG.128
            SY(K) = YPD                                                          SKWTBKG.129
            SX(K) = XPD                                                          SKWTBKG.130
   35    CONTINUE                                                                SKWTBKG.131
   36    CALL CURVED(SX,SY,K)                                                    SKWTBKG.132
         ITS=NINT(TS)                                                            SKWTBKG.133
         WRITE (ITIT,102) ITS                                                    SKWTBKG.134
  102    FORMAT(I2)                                                              SKWTBKG.135
C        CALL PWRY(SX(86),SY(86)+0.6,ITIT,2,10,0,1)                              SKWTBKG.136
         X = SX(K)                                                               SKWTBKG.137
         Y = SY(K)                                                               SKWTBKG.138
         IF (ITS .GT. -10) CALL WTSTR(X,Y+0.6,ITIT(1:2),10,0,0)                  SKWTBKG.139
         TS=TS-4.0                                                               SKWTBKG.140
   40 CONTINUE                                                                   SKWTBKG.141
C                                                                                SKWTBKG.142
C  DRAW DRY ADIABAT LINES                                                        SKWTBKG.143
C                                                                                SKWTBKG.144
      CALL DASHDB (21845)     ! PATTERN = 0101010101010101                       SKWTBKG.145
C     CALL DASHD(4444B)                                                          SKWTBKG.146
      T=51.                                                                      SKWTBKG.147
      DO 45 I=1,162                                                              SKWTBKG.148
         Y45(I)=66.67*(5.7625544-ALOG(T+ABZ))                                    SKWTBKG.149
         T=T-1.0                                                                 SKWTBKG.150
   45 CONTINUE                                                                   SKWTBKG.151
      T=450.                                                                     SKWTBKG.152
      TD=52.                                                                     SKWTBKG.153
      DO 55 I=1,20                                                               SKWTBKG.154
         T=T-10.                                                                 SKWTBKG.155
         K=0                                                                     SKWTBKG.156
         YD=66.67*(ALOG(T)-5.7625544)                                            SKWTBKG.157
         DO 50 J=1,162                                                           SKWTBKG.158
            YPD=Y45(J)+YD                                                        SKWTBKG.159
            TX=TD-FLOAT(J)                                                       SKWTBKG.160
            IF(YPD.GT.44.061) GO TO 54                                           SKWTBKG.161
            IF(YPD.LT.-.9346217) GO TO 50                                        SKWTBKG.162
            XPD=FX(TX,YPD)                                                       SKWTBKG.163
            IF(XPD.LT.-19.0)GO TO 54                                             SKWTBKG.164
            IF(XPD.GT.27.1)GO TO 50                                              SKWTBKG.165
            IF(XPD.GT.18.6.AND.T.GT.350.0)GO TO 50                               SKWTBKG.166
               K=K+1                                                             SKWTBKG.167
               SX(K)=XPD                                                         SKWTBKG.168
               SY(K)=YPD                                                         SKWTBKG.169
   50    CONTINUE                                                                SKWTBKG.170
C                                                                                SKWTBKG.171
   54    CALL CURVED(SX,SY,K)                                                    SKWTBKG.172
         ITS=NINT(T)                                                             SKWTBKG.173
      WRITE (ITIT,103) ITS                                                       SKWTBKG.174
  103    FORMAT(I3)                                                              SKWTBKG.175
C        IF(ITS .GE. 320) THEN                                                   SKWTBKG.176
C           CALL PWRY(SX(K-3),43.0,ITIT,3,10,0,1)                                SKWTBKG.177
C           ELSE                                                                 SKWTBKG.178
C           CALL PWRY(-18.0,SY(K-3),ITIT,3,10,0,1)                               SKWTBKG.179
C        END IF                                                                  SKWTBKG.180
         X=SX(K-3)                                                               SKWTBKG.181
         Y=SY(K-3)                                                               SKWTBKG.182
         IF(X.LT.-15.0) X = -17.95                                               SKWTBKG.183
         IF(Y.GT.40.0)  Y = 42.9                                                 SKWTBKG.184
      CALL WTSTR (X,Y,ITIT(1:3),10,0,0)                                          SKWTBKG.185
   55 CONTINUE                                                                   SKWTBKG.186
C                                                                                SKWTBKG.187
      CALL GFLAS2                                                                SKWTBKG.188
      ISKDRW = 1                                                                 SKWTBKG.189
      RETURN                                                                     SKWTBKG.190
      END                                                                        SKWTBKG.191
