C                                                                                STARDR.1
      SUBROUTINE STARDR(XUS,YUS,XND,YND,TA,IAM,STUMSL,IST)                       STARDR.2
C                                                                                STARDR.3
C THIS ROUTINE DRAWS THE ARROW. CALCULATIONS ARE IN FRACTIONAL                   STARDR.4
C COORDINATES TO ENSURE UNIFORM ARROWS IRRESPECTIVE OF THE                       STARDR.5
C MAPPING IN EFFECT.                                                             STARDR.6
C A SMALL FRACTION OF THE DIFFERENTIAL CHANGE IS USED TO FIND THE                STARDR.7
C TANGENT ANGLE AT THE CURRENT POSITION. ONCE THE ANGLE IS KNOWN THE             STARDR.8
C ARROW CAN BE DRAWN AT A FIXED SIZE INDEPENDENT OF THE MAPPING                  STARDR.9
C ROUTINE CURRENTLY EMPLOYED.                                                    STARDR.10
C                                                                                STARDR.11
C INPUT PARAMETERS:                                                              STARDR.12
C                                                                                STARDR.13
C XUS,YUS - CURRENT POSITION IN USER SPACE                                       STARDR.14
C XND,YND - CURRENT POSITION IN NDC SPACE                                        STARDR.15
C TA    - ANGLE IN NDC                                                           STARDR.16
C IAM   - AREA MASK ARRAY                                                        STARDR.17
C STUMSL - USER DEFINED MASKED STREAMLINE DRAWING ROUTINE                        STARDR.18
C                                                                                STARDR.19
C OUTPUT PARAMETERS:                                                             STARDR.20
C                                                                                STARDR.21
C IST - STATUS CODE, INDICATES SUCCESS OR FAILURE                                STARDR.22
C                                                                                STARDR.23
      DIMENSION  IAM(*)                                                          STARDR.24
      EXTERNAL STUMSL                                                            STARDR.25
C                                                                                STARDR.26
C ---------------------------------------------------------------------          STARDR.27
C                                                                                STARDR.28
C NOTE:                                                                          STARDR.29
C SINCE IMPLICIT TYPING IS USED FOR ALL REAL AND INTEGER VARIABLES               STARDR.30
C A CONSISTENT LENGTH CONVENTION HAS BEEN ADOPTED TO HELP CLARIFY THE            STARDR.31
C SIGNIFICANCE OF THE VARIABLES ENCOUNTERED IN THE CODE FOR THIS                 STARDR.32
C UTILITY. ALL LOCAL VARIABLE AND SUBROUTINE PARAMETER IDENTIFIERS               STARDR.33
C ARE LIMITED TO 1,2,OR 3 CHARACTERS. FOUR CHARACTER NAMES IDENTIFY              STARDR.34
C MEMBERS OF COMMON BLOCKS. FIVE AND 6 CHARACTER VARIABLE NAMES                  STARDR.35
C DENOTE PARAMETER CONSTANTS OR SUBROUTINE OR FUNCTION NAMES.                    STARDR.36
C                                                                                STARDR.37
C DECLARE THE ST COMMON BLOCKS.                                                  STARDR.38
C                                                                                STARDR.39
      PARAMETER (IPLVLS = 64)                                                    STARDR.40
C                                                                                STARDR.41
C INTEGER AND REAL COMMON BLOCK VARIABLES                                        STARDR.42
C                                                                                STARDR.43
C                                                                                STARDR.44
      COMMON / STPAR /                                                           STARDR.45
     +                IUD1       ,IVD1       ,IPD1       ,                       STARDR.46
     +                IXD1       ,IXDM       ,IYD1       ,IYDN       ,           STARDR.47
     +                IXM1       ,IYM1       ,IXM2       ,IYM2       ,           STARDR.48
     +                IWKD       ,IWKU       ,ISET       ,IERR       ,           STARDR.49
     +	              IXIN       ,IYIN       ,IMSK       ,ICPM       ,            STARDR.50
     +                NLVL       ,IPAI       ,ICTV       ,WDLV       ,           STARDR.51
     +                UVMN       ,UVMX       ,PMIN       ,PMAX       ,           STARDR.52
     +                ITHN       ,IPLR       ,ISST       ,                       STARDR.53
     +                ICLR(IPLVLS)           ,TVLU(IPLVLS)                       STARDR.54
C                                                                                STARDR.55
      COMMON / STTRAN /                                                          STARDR.56
     +                UVPS       ,                                               STARDR.57
     +                UVPL       ,UVPR       ,UVPB       ,UVPT       ,           STARDR.58
     +                UWDL       ,UWDR       ,UWDB       ,UWDT       ,           STARDR.59
     +                UXC1       ,UXCM       ,UYC1       ,UYCN                   STARDR.60
C                                                                                STARDR.61
C STREAM ALGORITHM PARAMETERS                                                    STARDR.62
C                                                                                STARDR.63
      COMMON / STSTRM /                                                          STARDR.64
     +                ISGD       ,IAGD       ,RARL       ,ICKP       ,           STARDR.65
     +                ICKX       ,ITRP       ,ICYK       ,RVNL       ,           STARDR.66
     +                ISVF       ,RUSV       ,RVSV       ,RNDA       ,           STARDR.67
     +                ISPC       ,RPSV       ,RCDS       ,RSSP       ,           STARDR.68
     +                RDFM                                                       STARDR.69
C                                                                                STARDR.70
C TEXT RELATED PARAMETERS                                                        STARDR.71
C NOTE: GRAPHICAL TEXT OUTPUT IS NOT YET IMPLEMENTED FOR THE                     STARDR.72
C       STREAMLINE UTILITY.                                                      STARDR.73
C                                                                                STARDR.74
      COMMON / STTXP /                                                           STARDR.75
     +                FCWM    ,ICSZ    ,                                         STARDR.76
     +                FMNS    ,FMNX    ,FMNY    ,IMNP    ,IMNC  ,                STARDR.77
     +                FMXS    ,FMXX    ,FMXY    ,IMXP    ,IMXC  ,                STARDR.78
     +                FZFS    ,FZFX    ,FZFY    ,IZFP    ,IZFC  ,                STARDR.79
     +                FILS    ,FILX    ,FILY    ,IILP    ,IILC                   STARDR.80
C                                                                                STARDR.81
C CHARACTER VARIABLE DECLARTIONS                                                 STARDR.82
C                                                                                STARDR.83
      CHARACTER*160 CSTR                                                         STARDR.84
      PARAMETER (IPCHSZ=80)                                                      STARDR.85
      CHARACTER*(IPCHSZ)  CMNT,CMXT,CZFT,CILT                                    STARDR.86
C                                                                                STARDR.87
C TEXT STRING PARAMETERS                                                         STARDR.88
C                                                                                STARDR.89
      COMMON / STCHAR / CSTR,CMNT,CMXT,CZFT,CILT                                 STARDR.90
C                                                                                STARDR.91
      SAVE /STPAR/, /STTRAN/, /STSTRM/, /STTXP/, /STCHAR/                        STARDR.92
C                                                                                STARDR.93
C INTERNAL BUFFER LENGTHS                                                        STARDR.94
C                                                                                STARDR.95
C IPNPTS - NUMBER OF POINTS IN THE POINT BUFFER -- NOT LESS THAN 3               STARDR.96
C IPLSTL - STREAMLINE-CROSSOVER-CHECK CIRCULAR LIST LENGTH                       STARDR.97
C IPGRCT - NUMBER OF GROUPS SUPPORTED FOR AREA MASKING                           STARDR.98
C                                                                                STARDR.99
      PARAMETER (IPNPTS = 10, IPLSTL = 750, IPGRCT = 64)                         STARDR.100
C                                                                                STARDR.101
C THE MAPPING COMMON BLOCK: MADE AVAILABLE TO USER MAPPING ROUTINES              STARDR.102
C                                                                                STARDR.103
      COMMON /STMAP/                                                             STARDR.104
     +                IMAP       ,LNLG       ,INVX       ,INVY       ,           STARDR.105
     +                XLOV       ,XHIV       ,YLOV       ,YHIV       ,           STARDR.106
     +                WXMN       ,WXMX       ,WYMN       ,WYMX       ,           STARDR.107
     +                XVPL       ,XVPR       ,YVPB       ,YVPT       ,           STARDR.108
     +                XGDS       ,YGDS       ,NXCT       ,NYCT       ,           STARDR.109
     +                ITRT       ,FW2W       ,FH2H       ,                       STARDR.110
     +                DFMG       ,VNML       ,RBIG       ,IBIG                   STARDR.111
C                                                                                STARDR.112
      SAVE /STMAP/                                                               STARDR.113
C                                                                                STARDR.114
C MATH CONSTANTS                                                                 STARDR.115
C                                                                                STARDR.116
      PARAMETER (PDTOR  = 0.017453292519943,                                     STARDR.117
     +           PRTOD  = 57.2957795130823,                                      STARDR.118
     +           P1XPI  = 3.14159265358979,                                      STARDR.119
     +           P2XPI  = 6.28318530717959,                                      STARDR.120
     +           P1D2PI = 1.57079632679489,                                      STARDR.121
     +           P5D2PI = 7.85398163397448)                                      STARDR.122
C                                                                                STARDR.123
C --------------------------------------------------------------------           STARDR.124
C                                                                                STARDR.125
C                                                                                STARDR.126
C POINT BUFFERS                                                                  STARDR.127
C                                                                                STARDR.128
      DIMENSION AX(3), AY(3)                                                     STARDR.129
C                                                                                STARDR.130
C LOCAL VARIABLES                                                                STARDR.131
C                                                                                STARDR.132
C AX, AY   - ARROW HEAD POINT BUFFERS                                            STARDR.133
C DXW, DYW - CHANGE IN X,Y IN WINDOW COORDINATES                                 STARDR.134
C XF, YF   - ARROW HEAD POSITION IN THE FRACTIONAL SYSTEM                        STARDR.135
C DXF,DYF  - INCREMENTAL CHANGE IN THE FRACTIONAL SYSTEM                         STARDR.136
C PHI      - TANGENT ANGLE                                                       STARDR.137
C K        - LOOP INDEX AND SIGN FACTOR FOR EACH EDGE OF THE ARROW               STARDR.138
C KK       - INDEX FOR THE ARROW HEAD ARRAY, WITHIN THE LOOP                     STARDR.139
C D30      - HALF THE ANGLE OF THE POINT OF THE ARROW HEAD (ABOUT 30 O)          STARDR.140
C XX,YY    - ENDS OF THE ARROW IN WINDOW COORDINATES                             STARDR.141
C                                                                                STARDR.142
C PARAMETERS:                                                                    STARDR.143
C                                                                                STARDR.144
C PHFANG - HALF THE ANGLE OF THE ARROW HEAD (0.5 IN RADIANS IS                   STARDR.145
C          APPROXIMATELY EQUIVALENT TO 30 DEGREES)                               STARDR.146
C PLWFCT - LINEWIDTH FACTOR, ARROW SIZE IS INCREASED BY THIS                     STARDR.147
C          MUCH WHEN THE LINEWIDTH IS GREATER THAN 1.0                           STARDR.148
                                                                                 STARDR.149
      PARAMETER (PHFANG=0.5, PLWFCT=0.15)                                        STARDR.150
C                                                                                STARDR.151
C ---------------------------------------------------------------------          STARDR.152
C                                                                                STARDR.153
      IST=0                                                                      STARDR.154
C                                                                                STARDR.155
      AX(2) = XUS                                                                STARDR.156
      AY(2) = YUS                                                                STARDR.157
      FLW = 1.0 + PLWFCT*MAX(0.0,WDLV-1.0)                                       STARDR.158
C                                                                                STARDR.159
      DO 10 K = -1,1,2                                                           STARDR.160
C                                                                                STARDR.161
C K SERVES AS A SIGN DETERMINING FACTOR; KK INDEXES THE POINT ARRAY.             STARDR.162
C                                                                                STARDR.163
         KK=K+2                                                                  STARDR.164
         D30 = -(P1D2PI-TA)+FLOAT(K)*PHFANG                                      STARDR.165
         XX = +RNDA*FLW*SIN(D30)+XND                                             STARDR.166
         YY = -RNDA*FLW*COS(D30)+YND                                             STARDR.167
         AX(KK) = CFUX(XX)                                                       STARDR.168
         AY(KK) = CFUY(YY)                                                       STARDR.169
C                                                                                STARDR.170
 10   CONTINUE                                                                   STARDR.171
C                                                                                STARDR.172
      CALL STLNSG(AX,AY,3,IAM,STUMSL)                                            STARDR.173
C                                                                                STARDR.174
C DONE                                                                           STARDR.175
C                                                                                STARDR.176
      RETURN                                                                     STARDR.177
      END                                                                        STARDR.178
