C                                                                                STDATA.1
C	$ID: STDATA.F,V 2.0 1997/01/11 20:33:31 MESOUSER EXP $                         STDATA.2
C                                                                                STDATA.3
      BLOCK DATA STDATA                                                          STDATA.4
C                                                                                STDATA.5
C THIS ROUTINE DEFINES THE DEFAULT VALUES OF THE STREAMLINE PARAMETERS.          STDATA.6
C                                                                                STDATA.7
C ---------------------------------------------------------------------          STDATA.8
C                                                                                STDATA.9
C NOTE:                                                                          STDATA.10
C SINCE IMPLICIT TYPING IS USED FOR ALL REAL AND INTEGER VARIABLES               STDATA.11
C A CONSISTENT LENGTH CONVENTION HAS BEEN ADOPTED TO HELP CLARIFY THE            STDATA.12
C SIGNIFICANCE OF THE VARIABLES ENCOUNTERED IN THE CODE FOR THIS                 STDATA.13
C UTILITY. ALL LOCAL VARIABLE AND SUBROUTINE PARAMETER IDENTIFIERS               STDATA.14
C ARE LIMITED TO 1,2,OR 3 CHARACTERS. FOUR CHARACTER NAMES IDENTIFY              STDATA.15
C MEMBERS OF COMMON BLOCKS. FIVE AND 6 CHARACTER VARIABLE NAMES                  STDATA.16
C DENOTE PARAMETER CONSTANTS OR SUBROUTINE OR FUNCTION NAMES.                    STDATA.17
C                                                                                STDATA.18
C DECLARE THE ST COMMON BLOCKS.                                                  STDATA.19
C                                                                                STDATA.20
      PARAMETER (IPLVLS = 64)                                                    STDATA.21
C                                                                                STDATA.22
C INTEGER AND REAL COMMON BLOCK VARIABLES                                        STDATA.23
C                                                                                STDATA.24
C                                                                                STDATA.25
      COMMON / STPAR /                                                           STDATA.26
     +                IUD1       ,IVD1       ,IPD1       ,                       STDATA.27
     +                IXD1       ,IXDM       ,IYD1       ,IYDN       ,           STDATA.28
     +                IXM1       ,IYM1       ,IXM2       ,IYM2       ,           STDATA.29
     +                IWKD       ,IWKU       ,ISET       ,IERR       ,           STDATA.30
     +	              IXIN       ,IYIN       ,IMSK       ,ICPM       ,            STDATA.31
     +                NLVL       ,IPAI       ,ICTV       ,WDLV       ,           STDATA.32
     +                UVMN       ,UVMX       ,PMIN       ,PMAX       ,           STDATA.33
     +                ITHN       ,IPLR       ,ISST       ,                       STDATA.34
     +                ICLR(IPLVLS)           ,TVLU(IPLVLS)                       STDATA.35
C                                                                                STDATA.36
      COMMON / STTRAN /                                                          STDATA.37
     +                UVPS       ,                                               STDATA.38
     +                UVPL       ,UVPR       ,UVPB       ,UVPT       ,           STDATA.39
     +                UWDL       ,UWDR       ,UWDB       ,UWDT       ,           STDATA.40
     +                UXC1       ,UXCM       ,UYC1       ,UYCN                   STDATA.41
C                                                                                STDATA.42
C STREAM ALGORITHM PARAMETERS                                                    STDATA.43
C                                                                                STDATA.44
      COMMON / STSTRM /                                                          STDATA.45
     +                ISGD       ,IAGD       ,RARL       ,ICKP       ,           STDATA.46
     +                ICKX       ,ITRP       ,ICYK       ,RVNL       ,           STDATA.47
     +                ISVF       ,RUSV       ,RVSV       ,RNDA       ,           STDATA.48
     +                ISPC       ,RPSV       ,RCDS       ,RSSP       ,           STDATA.49
     +                RDFM                                                       STDATA.50
C                                                                                STDATA.51
C TEXT RELATED PARAMETERS                                                        STDATA.52
C NOTE: GRAPHICAL TEXT OUTPUT IS NOT YET IMPLEMENTED FOR THE                     STDATA.53
C       STREAMLINE UTILITY.                                                      STDATA.54
C                                                                                STDATA.55
      COMMON / STTXP /                                                           STDATA.56
     +                FCWM    ,ICSZ    ,                                         STDATA.57
     +                FMNS    ,FMNX    ,FMNY    ,IMNP    ,IMNC  ,                STDATA.58
     +                FMXS    ,FMXX    ,FMXY    ,IMXP    ,IMXC  ,                STDATA.59
     +                FZFS    ,FZFX    ,FZFY    ,IZFP    ,IZFC  ,                STDATA.60
     +                FILS    ,FILX    ,FILY    ,IILP    ,IILC                   STDATA.61
C                                                                                STDATA.62
C CHARACTER VARIABLE DECLARTIONS                                                 STDATA.63
C                                                                                STDATA.64
      CHARACTER*160 CSTR                                                         STDATA.65
      PARAMETER (IPCHSZ=80)                                                      STDATA.66
      CHARACTER*(IPCHSZ)  CMNT,CMXT,CZFT,CILT                                    STDATA.67
C                                                                                STDATA.68
C TEXT STRING PARAMETERS                                                         STDATA.69
C                                                                                STDATA.70
      COMMON / STCHAR / CSTR,CMNT,CMXT,CZFT,CILT                                 STDATA.71
C                                                                                STDATA.72
      SAVE /STPAR/, /STTRAN/, /STSTRM/, /STTXP/, /STCHAR/                        STDATA.73
C                                                                                STDATA.74
C INTERNAL BUFFER LENGTHS                                                        STDATA.75
C                                                                                STDATA.76
C IPNPTS - NUMBER OF POINTS IN THE POINT BUFFER -- NOT LESS THAN 3               STDATA.77
C IPLSTL - STREAMLINE-CROSSOVER-CHECK CIRCULAR LIST LENGTH                       STDATA.78
C IPGRCT - NUMBER OF GROUPS SUPPORTED FOR AREA MASKING                           STDATA.79
C                                                                                STDATA.80
      PARAMETER (IPNPTS = 10, IPLSTL = 750, IPGRCT = 64)                         STDATA.81
C                                                                                STDATA.82
C THE MAPPING COMMON BLOCK: MADE AVAILABLE TO USER MAPPING ROUTINES              STDATA.83
C                                                                                STDATA.84
      COMMON /STMAP/                                                             STDATA.85
     +                IMAP       ,LNLG       ,INVX       ,INVY       ,           STDATA.86
     +                XLOV       ,XHIV       ,YLOV       ,YHIV       ,           STDATA.87
     +                WXMN       ,WXMX       ,WYMN       ,WYMX       ,           STDATA.88
     +                XVPL       ,XVPR       ,YVPB       ,YVPT       ,           STDATA.89
     +                XGDS       ,YGDS       ,NXCT       ,NYCT       ,           STDATA.90
     +                ITRT       ,FW2W       ,FH2H       ,                       STDATA.91
     +                DFMG       ,VNML       ,RBIG       ,IBIG                   STDATA.92
C                                                                                STDATA.93
      SAVE /STMAP/                                                               STDATA.94
C                                                                                STDATA.95
C MATH CONSTANTS                                                                 STDATA.96
C                                                                                STDATA.97
      PARAMETER (PDTOR  = 0.017453292519943,                                     STDATA.98
     +           PRTOD  = 57.2957795130823,                                      STDATA.99
     +           P1XPI  = 3.14159265358979,                                      STDATA.100
     +           P2XPI  = 6.28318530717959,                                      STDATA.101
     +           P1D2PI = 1.57079632679489,                                      STDATA.102
     +           P5D2PI = 7.85398163397448)                                      STDATA.103
C                                                                                STDATA.104
C --------------------------------------------------------------------           STDATA.105
C *********************************************************************          STDATA.106
C                                                                                STDATA.107
C INITIALIZATION OF STPAR                                                        STDATA.108
C                                                                                STDATA.109
C IUD1 -- 'UD1' -- FIRST DIMENSION OF U                                          STDATA.110
C                                                                                STDATA.111
      DATA     IUD1 / -1 /                                                       STDATA.112
C                                                                                STDATA.113
C IVD1 -- 'VD1' -- FIRST DIMENSION OF V                                          STDATA.114
C                                                                                STDATA.115
      DATA     IVD1 / -1 /                                                       STDATA.116
C                                                                                STDATA.117
C IPD1 -- 'PD1' -- FIRST DIMENSION OF P                                          STDATA.118
C                                                                                STDATA.119
      DATA     IPD1 / -1 /                                                       STDATA.120
C                                                                                STDATA.121
C IXD1 -- 'XD1' -- ARRAY INDEX FOR START OF DATA, FIRST DIMENSION                STDATA.122
C                                                                                STDATA.123
      DATA     IXD1 / 1 /                                                        STDATA.124
C                                                                                STDATA.125
C IXDM -- 'XDM' -- ARRAY INDEX FOR END OF DATA, FIRST DIMENSION                  STDATA.126
C                                                                                STDATA.127
      DATA     IXDM / -1 /                                                       STDATA.128
C                                                                                STDATA.129
C IYD1 -- 'YD1' -- ARRAY INDEX FOR START OF DATA, SECOND DIMENSION               STDATA.130
C                                                                                STDATA.131
      DATA     IYD1 / 1 /                                                        STDATA.132
C                                                                                STDATA.133
C IYDN -- 'YDN' -- ARRAY INDEX FOR END OF DATA, SECOND DIMENSION                 STDATA.134
C                                                                                STDATA.135
      DATA     IYDN / -1 /                                                       STDATA.136
C                                                                                STDATA.137
C IWKD -- 'WKD' -- DIMENSION OF WORK ARRAY                                       STDATA.138
C                                                                                STDATA.139
      DATA     IWKD / -1 /                                                       STDATA.140
C                                                                                STDATA.141
C IWKU -- 'WKU' -- AMOUNT OF WORK ARRAY ACTUALLY USED (READ-ONLY)                STDATA.142
C                                                                                STDATA.143
      DATA     IWKU / 0 /                                                        STDATA.144
C                                                                                STDATA.145
C ISET -- 'SET' -- THE SET CALL FLAG - OLD NSET PARAMETER                        STDATA.146
C                                                                                STDATA.147
      DATA     ISET / 1 /                                                        STDATA.148
C                                                                                STDATA.149
C IERR -- 'ERR' -- ERROR CODE SET BY STRMLN (READ-ONLY)                          STDATA.150
C                  -101 - CYCLIC FLAG SET FOR NON-CYCLIC DATA                    STDATA.151
C                                                                                STDATA.152
      DATA     IERR / 0 /                                                        STDATA.153
C                                                                                STDATA.154
C                                                                                STDATA.155
C IXIN -- 'XIN' -- THE X AXIS GRID INCREMENT, MUST BE > 0                        STDATA.156
C IYIN -- 'YIN' -- THE Y AXIS GRID INCREMENT, MUST BE > 0                        STDATA.157
C                                                                                STDATA.158
      DATA IXIN / 1 /                                                            STDATA.159
      DATA IYIN / 1 /                                                            STDATA.160
C                                                                                STDATA.161
C IXM1 -- (IXDM - 1) (NOT USER ACCESSIBLE)                                       STDATA.162
C IXM2 -- (IXDM - 2) (NOT USER ACCESSIBLE)                                       STDATA.163
C IYM1 -- (IYDN - 1) (NOT USER ACCESSIBLE)                                       STDATA.164
C IYM2 -- (IYDN - 2) (NOT USER ACCESSIBLE)                                       STDATA.165
C                                                                                STDATA.166
C IMSK -- 'MSK' -- MASK STREAMLINES TO AN AREA MAP: <1 -- NO MAPPING,            STDATA.167
C                  >=1 - MAPPING;                                                STDATA.168
C                                                                                STDATA.169
      DATA IMSK / 0 /                                                            STDATA.170
C                                                                                STDATA.171
C ICPM -- 'CPM' -- THE COMPATIBILITY MODE. IF >0 THE FX,FY,                      STDATA.172
C                  FUNCTIONS ARE USED. ADDITIONALLY, WHEN                        STDATA.173
C                  USED IN CONJUNCTION WITH THE STRMLN ROUTINE,                  STDATA.174
C                  HAS A MEANINGFUL RANGE FROM -4 TO +4 INCLUSIVE,               STDATA.175
C                  WHERE VARIOUS COMBINATIONS ARE ALLOWED TO USE OR              STDATA.176
C                  IGNORE 1) THE OPTIONAL INPUT PARAMETERS TO                    STDATA.177
C                  VELVCT, 2) THE DATA IN STR01,STR02,STR03,STR04                STDATA.178
C                  COMMON, 3) FX, ETC ROUTINES, AS FOLLOWS:                      STDATA.179
C                                                                                STDATA.180
C                  -4: NO FX, IGNORE PARAMS, IGNORE OLD COMMON DATA              STDATA.181
C                  -3: NO FX, IGNORE PARAMS, USE OLD COMMON DATA                 STDATA.182
C                  -2: NO FX, USE PARAMS, IGNORE OLD COMMON DATA                 STDATA.183
C                  -1: NO FX, USE PARAMS, USE OLD COMMON DATA                    STDATA.184
C                   0: DEFAULT, SAME AS -4 IF STINIT,STREAM CALLED,              STDATA.185
C                      SAME AS +1 IF STRMLN OR EZSTRM CALLED                     STDATA.186
C                  +1: FX, USE PARAMS, USE OLD COMMON DATA                       STDATA.187
C                  +2: FX, USE PARAMS, IGNORE OLD COMMON DATA                    STDATA.188
C                  +3: FX, IGNORE PARAMS, USE OLD COMMON DATA                    STDATA.189
C                  +4: FX, IGNORE PARAMS, IGNORE OLD COMMON DATA                 STDATA.190
C                                                                                STDATA.191
C                  FX MEANS USING FX,FY                                          STDATA.192
C                  WHEN PARAMETERS AND COMMON BLOCK VALUES ARE                   STDATA.193
C                  USED THEY OVERRIDE ANY VALUES SET USING THE                   STDATA.194
C                  STSETX ROUTINES                                               STDATA.195
C                                                                                STDATA.196
      DATA ICPM / 0 /                                                            STDATA.197
C                                                                                STDATA.198
C NLVL -- 'NLV' -- NUMBER OF DISTINCT COLORS TO USE FOR THE                      STDATA.199
C                    INDEPENDENT VARIABLE MAPPING -- CANNOT EXCEED               STDATA.200
C                    IPLVLS -- DEFAULT: 16                                       STDATA.201
C                                                                                STDATA.202
      DATA  NLVL /  0 /                                                          STDATA.203
C                                                                                STDATA.204
C IPAI -- 'PAI' -- THE CURRENT LEVEL -- MUST BE SET BEFORE                       STDATA.205
C                   MODIFYING AN INTERNAL LEVEL ARRAY VALUE                      STDATA.206
C                                                                                STDATA.207
      DATA   IPAI /   1     /                                                    STDATA.208
C                                                                                STDATA.209
C ICTV -- 'CTV' -- COMPUTE THRESHOLDS FLAG:                                      STDATA.210
C                  0 -- NO VECTOR COLORING                                       STDATA.211
C                  < 0: COLOR VECTORS BY MAGNITUDE                               STDATA.212
C                  > 0: COLOR VECTORS BY CONTENTS OF SCALAR ARRAY P              STDATA.213
C                  +-1: NUMBER OF LEVELS AND THRESHOLD VALUES ALREADY            STDATA.214
C                       SET                                                      STDATA.215
C                  >1,<1: USE CTV EQUALLY SPACED LEVELS                          STDATA.216
C                                                                                STDATA.217
      DATA  ICTV /   0     /                                                     STDATA.218
C                                                                                STDATA.219
C WDLV -- 'LWD' -- THE WIDTH OF A STREAMLINE                                     STDATA.220
C                                                                                STDATA.221
      DATA  WDLV /   1.0   /                                                     STDATA.222
C                                                                                STDATA.223
C UVMN -- 'VMN' -- THE MINIMUM DISPLAYED VECTOR MAGNITUDE, READ-ONLY             STDATA.224
C UVMX -- 'VMX' -- THE MAXIMUM DISPLAYED VECTOR MAGNITUDE, READ-ONLY             STDATA.225
C PMIN -- 'PMN' -- THE MINIMUM SCALAR ARRAY VALUE, READ-ONLY                     STDATA.226
C PMAX -- 'PMX' -- THE MAXIMUM SCALAR ARRAY VALUE, READ-ONLY                     STDATA.227
C                                                                                STDATA.228
      DATA UVMN / 0.0 /                                                          STDATA.229
      DATA UVMX / 0.0 /                                                          STDATA.230
      DATA PMIN / 0.0 /                                                          STDATA.231
      DATA PMAX / 0.0 /                                                          STDATA.232
C                                                                                STDATA.233
C ITHN -- 'THN' -- STREAMLINE THINNING FLAG                                      STDATA.234
C                                                                                STDATA.235
      DATA ITHN / 0 /                                                            STDATA.236
C                                                                                STDATA.237
C IPLR -- 'PLR' -- POLAR COORDINATES FOR UV ARRAY FLAG                           STDATA.238
C                                                                                STDATA.239
      DATA IPLR / 0 /                                                            STDATA.240
C                                                                                STDATA.241
C ISST -- 'SST' -- STREAMLINE STATISTICS FLAG                                    STDATA.242
C                                                                                STDATA.243
      DATA ISST / 0 /                                                            STDATA.244
C                                                                                STDATA.245
C ICLR -- 'CLR' -- THE GKS COLOR INDEX VALUE                                     STDATA.246
C                                                                                STDATA.247
      DATA  ICLR / IPLVLS * 1 /                                                  STDATA.248
C                                                                                STDATA.249
C TVLU -- 'TVL' -- THE LIST OF THRESHOLD VALUES                                  STDATA.250
C                                                                                STDATA.251
      DATA  TVLU / IPLVLS * 0.0 /                                                STDATA.252
C                                                                                STDATA.253
C END OF STPAR INTIALIZATION                                                     STDATA.254
C                                                                                STDATA.255
C --------------------------------------------------------------------           STDATA.256
C                                                                                STDATA.257
C STTRAN INITIALIZATION                                                          STDATA.258
C                                                                                STDATA.259
C USER COORDINATE SYSTEM TO VIEWPORT, UV ARRAY TO USER COORDINATES               STDATA.260
C                                                                                STDATA.261
C UVPS -- 'VPS' -- THE VIEWPORT MODE                                             STDATA.262
C                                                                                STDATA.263
      DATA UVPS / 0.25 /                                                         STDATA.264
C                                                                                STDATA.265
C UVPL -- 'VPL' -- VIEWPORT LEFT                                                 STDATA.266
C                                                                                STDATA.267
      DATA UVPL / 0.05 /                                                         STDATA.268
C                                                                                STDATA.269
C UVPR -- 'VPR' -- VIEWPORT RIGHT                                                STDATA.270
C                                                                                STDATA.271
      DATA UVPR / 0.95 /                                                         STDATA.272
C                                                                                STDATA.273
C UVPB -- 'VPB' -- VIEWPORT BOTTOM                                               STDATA.274
C                                                                                STDATA.275
      DATA UVPB / 0.05 /                                                         STDATA.276
C                                                                                STDATA.277
C UVPT -- 'VPT' -- VIEWPORT TOP                                                  STDATA.278
C                                                                                STDATA.279
      DATA UVPT / 0.95 /                                                         STDATA.280
C                                                                                STDATA.281
C UWDL -- 'WDL' -- WINDOW LEFT                                                   STDATA.282
C                                                                                STDATA.283
      DATA UWDL / 0.0 /                                                          STDATA.284
C                                                                                STDATA.285
C UWDR -- 'WDR' -- WINDOW RIGHT                                                  STDATA.286
C                                                                                STDATA.287
      DATA UWDR / 0.0 /                                                          STDATA.288
C                                                                                STDATA.289
C UWDB -- 'WDB' -- WINDOW BOTTOM                                                 STDATA.290
C                                                                                STDATA.291
      DATA UWDB / 0.0 /                                                          STDATA.292
C                                                                                STDATA.293
C UWDT -- 'WDT' -- WINDOW TOP                                                    STDATA.294
C                                                                                STDATA.295
      DATA UWDT / 0.0 /                                                          STDATA.296
C                                                                                STDATA.297
C UXC1 -- 'XC1' -- MINIMUM X COORD                                               STDATA.298
C                                                                                STDATA.299
      DATA UXC1 / 0.0 /                                                          STDATA.300
C                                                                                STDATA.301
C UXCM -- 'XCM' -- MAXIMUM Y COORD                                               STDATA.302
C                                                                                STDATA.303
      DATA UXCM / 0.0 /                                                          STDATA.304
C                                                                                STDATA.305
C UYC1 -- 'YC1' -- MINIMUM Y COORD                                               STDATA.306
C                                                                                STDATA.307
      DATA UYC1 / 0.0 /                                                          STDATA.308
C                                                                                STDATA.309
C UYCN -- 'YCN' -- MAXIMUM Y COORD                                               STDATA.310
C                                                                                STDATA.311
      DATA UYCN / 0.0 /                                                          STDATA.312
C                                                                                STDATA.313
C END OF STTRAN                                                                  STDATA.314
C ----------------------------------------------------------------------         STDATA.315
C                                                                                STDATA.316
C STSTRM - PARAMETERS AFFECTING THE STREAM PROCESSING ALGORITHM                  STDATA.317
C                                                                                STDATA.318
C ISGD -- 'SGD' - STREAM STARTING GRID INCREMENT (INITA)                         STDATA.319
C                                                                                STDATA.320
      DATA ISGD / 2 /                                                            STDATA.321
C                                                                                STDATA.322
C IAGD -- 'AGD' - ARROW PLACEMENT GRID INCREMENT (INITB)                         STDATA.323
C                                                                                STDATA.324
      DATA IAGD / 2 /                                                            STDATA.325
C                                                                                STDATA.326
C RARL -- 'ARL' - LENGTH OF ONE SIDE OF ARROW AS FRACTION                        STDATA.327
C                 OF THE VIEWPORT WIDTH (REPLACES AROWL)                         STDATA.328
C                                                                                STDATA.329
      DATA RARL / 0.012 /                                                        STDATA.330
C                                                                                STDATA.331
C ICKP -- 'CKP' - CHECK PROGRESS AFTER THIS MANY ITERATIONS (ITERP)              STDATA.332
C                                                                                STDATA.333
      DATA ICKP / 35 /                                                           STDATA.334
C                                                                                STDATA.335
C ICKX -- 'CKX' - CHECK STREAMLINE CROSSOVER AFTER THIS MANY                     STDATA.336
C                 ITERATIONS (ITERC). (IF NEGATIVE CROSSOVER IS                  STDATA.337
C                 CHECKED AT EACH ENTRANCE TO A NEW GRID CELL)                   STDATA.338
C                                                                                STDATA.339
      DATA ICKX / -99 /                                                          STDATA.340
C                                                                                STDATA.341
C ITRP -- 'TRP' - INTERPOLATON METHOD (IGFLG)                                    STDATA.342
C                 0 - USE 16 POINT BESSEL WHERE POSSIBLE                         STDATA.343
C                 NON 0 - USE BI-LINEAR INTERPOLATION EVERYWHERE                 STDATA.344
C                                                                                STDATA.345
      DATA ITRP / 0 /                                                            STDATA.346
C                                                                                STDATA.347
C ICYK -- 'CYK' - CYCLICAL DATA FLAG (ICYC) IF NON-ZERO, INSTRUCTS               STDATA.348
C                 THE UTILITY TO USE CYCLIC INTERPOLATION FORMULAS.              STDATA.349
C                 IF SET AND DATA IS NON-CYCLIC THE ERROR FLAG IS SET.           STDATA.350
C                                                                                STDATA.351
      DATA ICYK / 0 /                                                            STDATA.352
C                                                                                STDATA.353
C RVNL -- 'VNL' - NORMALIZATION FACTOR FOR THE DIFFERENTIAL MAGNITUDE.           STDATA.354
C                 THIS CONTROLS NUMBER OF STEPS IN COMPATIBILITY MODE            STDATA.355
C                 ONLY WHEN THE FX,FY MAPPING ROUTINES ARE USED. SEE             STDATA.356
C                 PARAMETER 'DFM' FOR STEP CONTROL WHEN STMPXY AND               STDATA.357
C                 ASSOCIATED ROUTINES ARE USED                                   STDATA.358
C                                                                                STDATA.359
      DATA RVNL / 0.33 /                                                         STDATA.360
C                                                                                STDATA.361
C ISVF -- 'SVF' - SPECIAL VALUE FLAG  (IMSG)                                     STDATA.362
C                 0 - NO SPECIAL VALUES                                          STDATA.363
C                 NON 0 - THERE MAY BE SPECIAL VALUES, USE ONLY                  STDATA.364
C                         BI-LINEAR INTERPOLATION                                STDATA.365
      DATA ISVF / 0 /                                                            STDATA.366
C                                                                                STDATA.367
C RUSV -- 'USV' -- THE U ARRAY SPECIAL VALUE (UVMSG)                             STDATA.368
C                                                                                STDATA.369
      DATA RUSV / 1.0E12 /                                                       STDATA.370
C                                                                                STDATA.371
C RVSV -- 'VSV' -- THE V ARRAY SPECIAL VALUE (UVMSG)                             STDATA.372
C                                                                                STDATA.373
      DATA RVSV / 1.0E12 /                                                       STDATA.374
C                                                                                STDATA.375
C RNDA -- ASSIGNED THE NDC VALUE OF THE ARROW SIZE.                              STDATA.376
C                                                                                STDATA.377
C ISPC -- 'SPC' -- SPECIAL COLOR --                                              STDATA.378
C                      < 0: NO P SPECIAL VALUE                                   STDATA.379
C                      = 0: DON'T DRAW STREAMLINE THAT HAS A P SPEC VAL          STDATA.380
C                      > 0: DRAW P SPECIAL VALUES USING COLOR SPC                STDATA.381
C                                                                                STDATA.382
      DATA ISPC / -1 /                                                           STDATA.383
C                                                                                STDATA.384
C RPSV -- 'PSV' -- THE P ARRAY SPECIAL VALUE                                     STDATA.385
C                                                                                STDATA.386
      DATA RPSV / 1.0E12 /                                                       STDATA.387
C                                                                                STDATA.388
C RCDS -- 'CDS' - THE CRITICAL DISPLACEMENT AS A MULTIPLE OF 'DFM'.              STDATA.389
C                 REPLACES DISPC. IF THE STREAMLINE HAS NOT MOVED                STDATA.390
C                 CDS*DFM UNITS IN NDC SPACE AFTER ICKP ITERATIONS,              STDATA.391
C                 THE STREAMLINE IS TERMINATED                                   STDATA.392
C                                                                                STDATA.393
      DATA RCDS / 2.0 /                                                          STDATA.394
C                                                                                STDATA.395
C RSSP -- 'SSP' - STREAM SPACING VALUE AS A FRACTION OF THE VIEWPORT             STDATA.396
C                 WIDTH; REPLACES CSTOP. CHECKED WHEN A NEW GRID BOX IS          STDATA.397
C                 ENTERED.                                                       STDATA.398
C                                                                                STDATA.399
      DATA RSSP / 0.015 /                                                        STDATA.400
C                                                                                STDATA.401
C RDFM -- 'DFM' - DIFFERENTIAL MAGNITUDE AS A FRACTION OF THE VIEWPORT           STDATA.402
C                 WIDTH. SMALLER VALUES RESULT IN MORE STEPS AND A MORE          STDATA.403
C                 ACCURATE APPROXIMATION OF THE STREAMLINE.                      STDATA.404
C                                                                                STDATA.405
      DATA RDFM / 0.02 /                                                         STDATA.406
C                                                                                STDATA.407
C END OF STSTRM                                                                  STDATA.408
C --------------------------------------------------------------------           STDATA.409
C                                                                                STDATA.410
C STTXP - TEXT PARAMETERS                                                        STDATA.411
C                                                                                STDATA.412
C FCWM -- 'CWM' -- CHARACTER WIDTH MULTIPLE, SCALE FACTOR FOR ALL                STDATA.413
C                  TEXT PUT OUT BY THE STREAMLINE UTILITY                        STDATA.414
C                                                                                STDATA.415
      DATA FCWM / 1.0 /                                                          STDATA.416
C                                                                                STDATA.417
C ICCM -- INTERNAL - MAXIMUM LENGTH OF CHARACTER STRINGS                         STDATA.418
C                                                                                STDATA.419
      DATA ICSZ / IPCHSZ /                                                       STDATA.420
C                                                                                STDATA.421
C FMNS -- 'MNS' -- SIZE OF TEXT FOR MINIMUM VECTOR STRING AS FVPW                STDATA.422
C FMNX -- 'MNX' -- X POSITION OF MINIMUM VECTOR STRING AS FVPW                   STDATA.423
C FMNY -- 'MNY' -- Y POSITION OF MINIMUM VECTOR STRING AS FVPW                   STDATA.424
C IMNP -- 'MNP' -- MINIMUM VECTOR STRING POSITION FLAG                           STDATA.425
C IMNC -- 'MNC' -- COLOR OF TEXT FOR MINIMUM VECTOR LABEL                        STDATA.426
C                                                                                STDATA.427
      DATA FMNS / 0.0075 /                                                       STDATA.428
      DATA FMNX / 0.475 /                                                        STDATA.429
      DATA FMNY / -0.01 /                                                        STDATA.430
      DATA IMNP / 4 /                                                            STDATA.431
      DATA IMNC / -1 /                                                           STDATA.432
C                                                                                STDATA.433
C FMXS -- 'MXS' -- SIZE OF TEXT FOR MAXIMUM VECTOR STRING AS FVPW                STDATA.434
C FMXX -- 'MXX' -- X POSITION OF MAXIMUM VECTOR STRING AS FVPW                   STDATA.435
C FMXY -- 'MXY' -- Y POSITION OF MAXIMUM VECTOR STRING AS FVPW                   STDATA.436
C IMXP -- 'MXP' -- MAXIMUM VECTOR STRING POSITION FLAG                           STDATA.437
C IMXC -- 'MXC' -- COLOR OF TEXT FOR MAXIMUM VECTOR LABEL                        STDATA.438
C                                                                                STDATA.439
      DATA FMXS / 0.0075 /                                                       STDATA.440
      DATA FMXX / 0.525 /                                                        STDATA.441
      DATA FMXY / -0.01 /                                                        STDATA.442
      DATA IMXP / 2 /                                                            STDATA.443
      DATA IMXC / -1 /                                                           STDATA.444
C                                                                                STDATA.445
C FZFS -- 'ZFS' -- SIZE OF TEXT FOR ZERO FIELD STRING AS FVPW                    STDATA.446
C FZFX -- 'ZFX' -- X POSITION OF ZERO FIELD STRING AS FVPW                       STDATA.447
C FZFY -- 'ZFY' -- Y POSITION OF ZERO FIELD STRING AS FVPW                       STDATA.448
C IZFP -- 'ZFP' -- ZERO FIELD STRING POSITION FLAG                               STDATA.449
C IZFC -- 'ZFC' -- COLOR OF TEXT FOR ZERO FIELD LABEL                            STDATA.450
C                                                                                STDATA.451
      DATA FZFS / 0.033 /                                                        STDATA.452
      DATA FZFX / 0.5 /                                                          STDATA.453
      DATA FZFY / 0.5 /                                                          STDATA.454
      DATA IZFP / 0 /                                                            STDATA.455
      DATA IZFC / -1 /                                                           STDATA.456
C                                                                                STDATA.457
C THE INFORMATIONAL LABEL HAS NOT YET BEEN IMPLEMENTED                           STDATA.458
C FILS -- 'ILS' -- SIZE OF TEXT FOR INFORMATIONAL LABEL STRING AS FVPW           STDATA.459
C FILX -- 'ILX' -- X POSITION OF INFORMATIONAL LABEL STRING AS FVPW              STDATA.460
C FILY -- 'ILY' -- Y POSITION OF INFORMATIONAL LABEL STRING AS FVPW              STDATA.461
C IILP -- 'ILP' -- INFORMATIONAL LABEL STRING POSITION FLAG                      STDATA.462
C IILC -- 'ILC' -- COLOR OF TEXT FOR INFORMATIONAL LABEL                         STDATA.463
C                                                                                STDATA.464
      DATA FILS / 0.05 /                                                         STDATA.465
      DATA FILX / 0.0 /                                                          STDATA.466
      DATA FILY / 0.0 /                                                          STDATA.467
      DATA IILP / 0 /                                                            STDATA.468
      DATA IILC / -1 /                                                           STDATA.469
C                                                                                STDATA.470
C ---------------------------------------------------------------------          STDATA.471
C                                                                                STDATA.472
C BEGINNING OF STCHAR INITIALIZATION                                             STDATA.473
C                                                                                STDATA.474
      DATA CMNT / 'MINIMUM SPEED' /                                              STDATA.475
      DATA CMXT / 'MAXIMUM SPEED' /                                              STDATA.476
      DATA CZFT / 'ZERO FIELD' /                                                 STDATA.477
      DATA CILT / 'STREAMLINES' /                                                STDATA.478
C                                                                                STDATA.479
C END OF STCHAR INITIALIZATION                                                   STDATA.480
C                                                                                STDATA.481
C *********************************************************************          STDATA.482
C                                                                                STDATA.483
C STMAP INITIALIZATION                                                           STDATA.484
C                                                                                STDATA.485
C IMAP -- 'MAP' -- THE MAPPING TRANSFORMATION TO USE                             STDATA.486
C                                                                                STDATA.487
      DATA  IMAP / 0 /                                                           STDATA.488
C                                                                                STDATA.489
C ITRT -- 'TRT' -- TRANSFORM TYPE FLAG:                                          STDATA.490
C                      0  - TRANSFORM POSITION ONLY                              STDATA.491
C                      1  - TRANSFORM POSITION AND ANGLE                         STDATA.492
C                     -1  - TRANSFORM POSITION, ANGLE, AND MAGNITUDE             STDATA.493
C                                                                                STDATA.494
      DATA ITRT / 1 /                                                            STDATA.495
C                                                                                STDATA.496
C XVPL,XVPT,YVPB,YVPT -- THE VIEWPORT VALUES (NDC BOUNDARIES)                    STDATA.497
C                                                                                STDATA.498
C WXMN,WXMX,WYMN,WYMX -- THE WINDOW MINIMUM AND MAXIMUM VALUES                   STDATA.499
C                        (USER COORDINATE SPACE)                                 STDATA.500
C                                                                                STDATA.501
C XLOV,XHIV,YLOV,YHIV -- THE MAPPED ARRAY ENDPOINT VALUES                        STDATA.502
C                        (DATA COORDINATE SPACE)                                 STDATA.503
C                                                                                STDATA.504
C XGDS,YGDS -- SIZE IN DATA COORDINATES OF A GRID BOX                            STDATA.505
C                                                                                STDATA.506
C NXCT,NYCT -- NUMBER OF POINTS IN X AND Y USED FOR THE PLOT                     STDATA.507
C                                                                                STDATA.508
C DFMG -- THE MAGNITUDE OF THE DIFFENTIAL INCREMENT IN NDC SPACE                 STDATA.509
C                                                                                STDATA.510
C LNLG -- THE LOG SCALE MAPPING FLAG FROM SET CALL                               STDATA.511
C                                                                                STDATA.512
C INVX,INVY -- INVERSE FLAGS FOR THE WINDOW BOUNDARIES                           STDATA.513
C                                                                                STDATA.514
C IWCT - UNUSED                                                                  STDATA.515
C                                                                                STDATA.516
C FW2W,FH2H -- FRACTION OF VIEWPORT TO FRACTION OF VIEWSPACE                     STDATA.517
C                                                                                STDATA.518
C RBIG,IBIG -- MAXIMUM EXPRESSIBLE REAL AND INTEGER VALUES                       STDATA.519
C                                                                                STDATA.520
C *********************************************************************          STDATA.521
C                                                                                STDATA.522
C REVISION HISTORY ----------------------------------------------------          STDATA.523
C                                                                                STDATA.524
C FEBRUARY, 1979   ADDED REVISION HISTORY                                        STDATA.525
C                  MODIFIED CODE TO CONFORM TO FORTRAN 66 STANDARD               STDATA.526
C                                                                                STDATA.527
C JULY, 1979       FIXED HI VECTOR TRAP AND MESSAGE INDICATING                   STDATA.528
C                  MAXIMUM VECTOR PLOTTED.                                       STDATA.529
C                                                                                STDATA.530
C DECEMBER, 1979   CHANGED THE STATISTICS CALL FROM CRAYLIB TO NSSL              STDATA.531
C                                                                                STDATA.532
C MARCH, 1981      FIXED SOME FRINGE-CASE ERRORS, CHANGED THE CODE TO            STDATA.533
C                  USE FL2INTT AND PLOTIT INSTEAD OF MXMY, FRSTPT, AND           STDATA.534
C                  VECTOR, AND MADE THE ARROWHEADS NARROWER (45 DEGREES          STDATA.535
C                  APART, RATHER THAN 60 DEGREES APART)                          STDATA.536
C                                                                                STDATA.537
C FEBRUARY, 1984   PROVIDED A DIMENSION STATEMENT FOR A VARIABLE INTO            STDATA.538
C                  WHICH A TEN-CHARACTER STRING WAS BEING ENCODED.  ON           STDATA.539
C                  THE CRAY, WHEN THE ENCODE WAS DONE, A WORD FOLLOWING          STDATA.540
C                  THE VARIABLE WAS CLOBBERED, BUT THIS APPARENTLY MADE          STDATA.541
C                  NO DIFFERENCE.  ON AT LEAST ONE OTHER MACHINE, THE            STDATA.542
C                  CODE BLEW UP.  (ERROR REPORTED BY GREG WOODS)                 STDATA.543
C                                                                                STDATA.544
C JULY, 1984       CONVERTED TO FORTRAN77 AND GKS.                               STDATA.545
C                                                                                STDATA.546
C MARCH, 1990      CORRECTED THE USE OF SET CALLS.                               STDATA.547
C                                                                                STDATA.548
C ---------------------------------------------------------------------          STDATA.549
      END                                                                        STDATA.550
