C                                                                                STDRAW.1
C	$ID: STDRAW.F,V 2.0 1997/01/11 20:33:33 MESOUSER EXP $                         STDRAW.2
C                                                                                STDRAW.3
      SUBROUTINE STDRAW  (U,V,UX,VY,IAM,STUMSL)                                  STDRAW.4
C                                                                                STDRAW.5
C THIS ROUTINE DRAWS THE STREAMLINES.                                            STDRAW.6
C                                                                                STDRAW.7
      DIMENSION  U(IUD1,*)             ,V(IVD1,*)                                STDRAW.8
      DIMENSION  UX(IXDM,IYDN)         ,VY(IXDM,IYDN)                            STDRAW.9
      DIMENSION  IAM(*)                                                          STDRAW.10
      EXTERNAL STUMSL                                                            STDRAW.11
C                                                                                STDRAW.12
C INPUT PARAMETERS:                                                              STDRAW.13
C                                                                                STDRAW.14
C U,V    - VECTOR COMPONENT ARRAYS                                               STDRAW.15
C UX,UY  - WORK ARRAYS                                                           STDRAW.16
C IAM    - MASK ARRAY                                                            STDRAW.17
C STUMSL - USER-DEFINED MASKED STREAMLINE DRAWING ROUTINE                        STDRAW.18
C                                                                                STDRAW.19
C THE WORK ARRAY HAS BEEN BROKEN UP INTO TWO ARRAYS FOR CLARITY.  THE            STDRAW.20
C TOP HALF OF WORK (CALLED UX) WILL HAVE THE NORMALIZED (AND                     STDRAW.21
C POSSIBLY TRANSFORMED) U COMPONENTS AND WILL BE USED FOR BOOK                   STDRAW.22
C KEEPING.  THE LOWER HALF OF THE WORK ARRAY (CALLED VY) WILL                    STDRAW.23
C CONTAIN THE NORMALIZED (AND POSSIBLY TRANSFORMED) V COMPONENTS.                STDRAW.24
C                                                                                STDRAW.25
C ---------------------------------------------------------------------          STDRAW.26
C                                                                                STDRAW.27
C NOTE:                                                                          STDRAW.28
C SINCE IMPLICIT TYPING IS USED FOR ALL REAL AND INTEGER VARIABLES               STDRAW.29
C A CONSISTENT LENGTH CONVENTION HAS BEEN ADOPTED TO HELP CLARIFY THE            STDRAW.30
C SIGNIFICANCE OF THE VARIABLES ENCOUNTERED IN THE CODE FOR THIS                 STDRAW.31
C UTILITY. ALL LOCAL VARIABLE AND SUBROUTINE PARAMETER IDENTIFIERS               STDRAW.32
C ARE LIMITED TO 1,2,OR 3 CHARACTERS. FOUR CHARACTER NAMES IDENTIFY              STDRAW.33
C MEMBERS OF COMMON BLOCKS. FIVE AND 6 CHARACTER VARIABLE NAMES                  STDRAW.34
C DENOTE PARAMETER CONSTANTS OR SUBROUTINE OR FUNCTION NAMES.                    STDRAW.35
C                                                                                STDRAW.36
C DECLARE THE ST COMMON BLOCKS.                                                  STDRAW.37
C                                                                                STDRAW.38
      PARAMETER (IPLVLS = 64)                                                    STDRAW.39
C                                                                                STDRAW.40
C INTEGER AND REAL COMMON BLOCK VARIABLES                                        STDRAW.41
C                                                                                STDRAW.42
C                                                                                STDRAW.43
      COMMON / STPAR /                                                           STDRAW.44
     +                IUD1       ,IVD1       ,IPD1       ,                       STDRAW.45
     +                IXD1       ,IXDM       ,IYD1       ,IYDN       ,           STDRAW.46
     +                IXM1       ,IYM1       ,IXM2       ,IYM2       ,           STDRAW.47
     +                IWKD       ,IWKU       ,ISET       ,IERR       ,           STDRAW.48
     +	              IXIN       ,IYIN       ,IMSK       ,ICPM       ,            STDRAW.49
     +                NLVL       ,IPAI       ,ICTV       ,WDLV       ,           STDRAW.50
     +                UVMN       ,UVMX       ,PMIN       ,PMAX       ,           STDRAW.51
     +                ITHN       ,IPLR       ,ISST       ,                       STDRAW.52
     +                ICLR(IPLVLS)           ,TVLU(IPLVLS)                       STDRAW.53
C                                                                                STDRAW.54
      COMMON / STTRAN /                                                          STDRAW.55
     +                UVPS       ,                                               STDRAW.56
     +                UVPL       ,UVPR       ,UVPB       ,UVPT       ,           STDRAW.57
     +                UWDL       ,UWDR       ,UWDB       ,UWDT       ,           STDRAW.58
     +                UXC1       ,UXCM       ,UYC1       ,UYCN                   STDRAW.59
C                                                                                STDRAW.60
C STREAM ALGORITHM PARAMETERS                                                    STDRAW.61
C                                                                                STDRAW.62
      COMMON / STSTRM /                                                          STDRAW.63
     +                ISGD       ,IAGD       ,RARL       ,ICKP       ,           STDRAW.64
     +                ICKX       ,ITRP       ,ICYK       ,RVNL       ,           STDRAW.65
     +                ISVF       ,RUSV       ,RVSV       ,RNDA       ,           STDRAW.66
     +                ISPC       ,RPSV       ,RCDS       ,RSSP       ,           STDRAW.67
     +                RDFM                                                       STDRAW.68
C                                                                                STDRAW.69
C TEXT RELATED PARAMETERS                                                        STDRAW.70
C NOTE: GRAPHICAL TEXT OUTPUT IS NOT YET IMPLEMENTED FOR THE                     STDRAW.71
C       STREAMLINE UTILITY.                                                      STDRAW.72
C                                                                                STDRAW.73
      COMMON / STTXP /                                                           STDRAW.74
     +                FCWM    ,ICSZ    ,                                         STDRAW.75
     +                FMNS    ,FMNX    ,FMNY    ,IMNP    ,IMNC  ,                STDRAW.76
     +                FMXS    ,FMXX    ,FMXY    ,IMXP    ,IMXC  ,                STDRAW.77
     +                FZFS    ,FZFX    ,FZFY    ,IZFP    ,IZFC  ,                STDRAW.78
     +                FILS    ,FILX    ,FILY    ,IILP    ,IILC                   STDRAW.79
C                                                                                STDRAW.80
C CHARACTER VARIABLE DECLARTIONS                                                 STDRAW.81
C                                                                                STDRAW.82
      CHARACTER*160 CSTR                                                         STDRAW.83
      PARAMETER (IPCHSZ=80)                                                      STDRAW.84
      CHARACTER*(IPCHSZ)  CMNT,CMXT,CZFT,CILT                                    STDRAW.85
C                                                                                STDRAW.86
C TEXT STRING PARAMETERS                                                         STDRAW.87
C                                                                                STDRAW.88
      COMMON / STCHAR / CSTR,CMNT,CMXT,CZFT,CILT                                 STDRAW.89
C                                                                                STDRAW.90
      SAVE /STPAR/, /STTRAN/, /STSTRM/, /STTXP/, /STCHAR/                        STDRAW.91
C                                                                                STDRAW.92
C INTERNAL BUFFER LENGTHS                                                        STDRAW.93
C                                                                                STDRAW.94
C IPNPTS - NUMBER OF POINTS IN THE POINT BUFFER -- NOT LESS THAN 3               STDRAW.95
C IPLSTL - STREAMLINE-CROSSOVER-CHECK CIRCULAR LIST LENGTH                       STDRAW.96
C IPGRCT - NUMBER OF GROUPS SUPPORTED FOR AREA MASKING                           STDRAW.97
C                                                                                STDRAW.98
      PARAMETER (IPNPTS = 10, IPLSTL = 750, IPGRCT = 64)                         STDRAW.99
C                                                                                STDRAW.100
C THE MAPPING COMMON BLOCK: MADE AVAILABLE TO USER MAPPING ROUTINES              STDRAW.101
C                                                                                STDRAW.102
      COMMON /STMAP/                                                             STDRAW.103
     +                IMAP       ,LNLG       ,INVX       ,INVY       ,           STDRAW.104
     +                XLOV       ,XHIV       ,YLOV       ,YHIV       ,           STDRAW.105
     +                WXMN       ,WXMX       ,WYMN       ,WYMX       ,           STDRAW.106
     +                XVPL       ,XVPR       ,YVPB       ,YVPT       ,           STDRAW.107
     +                XGDS       ,YGDS       ,NXCT       ,NYCT       ,           STDRAW.108
     +                ITRT       ,FW2W       ,FH2H       ,                       STDRAW.109
     +                DFMG       ,VNML       ,RBIG       ,IBIG                   STDRAW.110
C                                                                                STDRAW.111
      SAVE /STMAP/                                                               STDRAW.112
C                                                                                STDRAW.113
C MATH CONSTANTS                                                                 STDRAW.114
C                                                                                STDRAW.115
      PARAMETER (PDTOR  = 0.017453292519943,                                     STDRAW.116
     +           PRTOD  = 57.2957795130823,                                      STDRAW.117
     +           P1XPI  = 3.14159265358979,                                      STDRAW.118
     +           P2XPI  = 6.28318530717959,                                      STDRAW.119
     +           P1D2PI = 1.57079632679489,                                      STDRAW.120
     +           P5D2PI = 7.85398163397448)                                      STDRAW.121
C                                                                                STDRAW.122
C --------------------------------------------------------------------           STDRAW.123
C                                                                                STDRAW.124
C LOCAL DECLARATIONS                                                             STDRAW.125
C                                                                                STDRAW.126
C POINT AND LIST BUFFERS                                                         STDRAW.127
C                                                                                STDRAW.128
C THE XLS AND YLS ARRAYS SERVE AS A CIRCULAR LIST. THEY                          STDRAW.129
C ARE USED TO PREVENT LINES FROM CROSSING ONE ANOTHER.                           STDRAW.130
C                                                                                STDRAW.131
      DIMENSION PX(IPNPTS), PY(IPNPTS)                                           STDRAW.132
      DIMENSION XLS(IPLSTL), YLS(IPLSTL)                                         STDRAW.133
C                                                                                STDRAW.134
C PARAMETERS:                                                                    STDRAW.135
C                                                                                STDRAW.136
C IPZERO, IPONE, IPTWO - THE NUMBERS 0,1,2                                       STDRAW.137
C PRZERO - THE NUMBER 0.0                                                        STDRAW.138
C PTHREE - THE NUMBER 3.0                                                        STDRAW.139
C PSMALL - A SMALL FLOATING POINT NUMBER, LARGE ENOUGH TO BE                     STDRAW.140
C          DETECTABLE BY ANY STANDARD PROCESSOR                                  STDRAW.141
C                                                                                STDRAW.142
      PARAMETER (IPZERO=0, IPONE=1, IPTWO=2, PRZERO=0.0, PTHREE=3.0)             STDRAW.143
      PARAMETER (PSMALL=0.000001)                                                STDRAW.144
C                                                                                STDRAW.145
C LOCAL VARIABLES                                                                STDRAW.146
C                                                                                STDRAW.147
C VSM      - A SMALL VALUE IN COMPARISON TO THE NORMALIZED VECTOR MAG.           STDRAW.148
C ISK      - NUMBER OF BITS TO SKIP IN BIT ROUTINES                              STDRAW.149
C IS1      - ISK + 1                                                             STDRAW.150
C SSP      - STREAM SPACING VALUE IN FRACTIONAL (ND) COORDINATES                 STDRAW.151
C CDS      - CRITICAL DISPLACEMENT IN FRACTIONAL (ND) COORDINATES                STDRAW.152
C LCT      - COUNT OF STREAMLINES DRAWN                                          STDRAW.153
C ITO      - TOTAL NUMBER OF POINTS USED TO DRAW ALL THE STREAMLINES             STDRAW.154
C LCU      - AMOUNT OF LIST CURRENTLY IN USE                                     STDRAW.155
C LCK      - CURRENT LIST INDEX                                                  STDRAW.156
C IDR      - DRAWING DIRECTION 0 + DIRECTION 1 - DIRECTION                       STDRAW.157
C SGN      - MULTIPLIER TO CHANGE SIGN BASED ON DRAWING DIRECTION                STDRAW.158
C IPC      - NUMBER OF POINTS CURRENTLY IN THE POINT BUFFER                      STDRAW.159
C ICT      - COUNT OF ITERATIONS IN CURRENT STREAMLINE                           STDRAW.160
C I,J      - GRID INDICES                                                        STDRAW.161
C UIJ,VIJ  - INDIVIDUAL VECTOR COMPONENTS                                        STDRAW.162
C CVF      - COMPONENT-WISE VECTOR NORMALIZING FACTOR                            STDRAW.163
C LST      - FLAG INDICATING THE LAST POINT IN A STREAMLINE                      STDRAW.164
C IUX      - INTEGER STORAGE FOR RETRIEVED BITS                                  STDRAW.165
C ISV, JSV - SAVED GRID INDICES WHERE STREAM STARTS IN + DIRECTION               STDRAW.166
C NBX      - COUNT OF GRID BOXES FOR CURRENT STREAMLINE                          STDRAW.167
C LBC      - BOX CHECKING VARIABLE                                               STDRAW.168
C X, Y     - CURRENT X,Y COORDINATES (GRID COORDINATES                           STDRAW.169
C DU, DV   - CURRENT NORMALIZED INTERPOLATED VECTOR COMPONENTS                   STDRAW.170
C XDA, YDA - CURRENT POSITION IN DATA COORDINATES                                STDRAW.171
C XUS, YUS - CURRENT POSITION IN USER COORDINATES                                STDRAW.172
C XND, YND - CURRENT POSITION IN NDC SPACE                                       STDRAW.173
C XNS, YNS - VALUE OF XND AND YND SAVED AT THE START OF THE STREAMLINE           STDRAW.174
C                           AND AFTER EACH PROGRESS CHECK                        STDRAW.175
C XN1, YN1 - PREVIOUS POSITION IN NDC SPACE                                      STDRAW.176
C TA       - THE TANGENT ANGLE IN NDC SPACE                                      STDRAW.177
C DUV      - THE DIFFERENTIAL NORMALIZED INTERPOLATED VECTOR MAGNITUDE           STDRAW.178
C CSA,SNA  - COSINE AND SINE OF THE TANGENT ANGLE                                STDRAW.179
C XN2,YN2  - THE PREVIOUS PREVIOUS POSITION IN NDC SPACE                         STDRAW.180
C TMG      - TEMPORARY MAGNITUDE                                                 STDRAW.181
C LI       - INDEX INTO CIRCULAR CROSSOVER CHECKING LIST                         STDRAW.182
C                                                                                STDRAW.183
C --------------------------------------------------------------------           STDRAW.184
C INITIALIZE LOCAL VARIABLES.                                                    STDRAW.185
C IF NOT USING THE FX,FY ROUTINES, THEN THE VECTOR NORMALIZATION                 STDRAW.186
C VALUE IS FIXED.                                                                STDRAW.187
C                                                                                STDRAW.188
      IF (ICPM.LT.1) THEN                                                        STDRAW.189
         VNML=1.0/PTHREE                                                         STDRAW.190
      ELSE                                                                       STDRAW.191
         VNML=RVNL                                                               STDRAW.192
      END IF                                                                     STDRAW.193
      VSM = R1MACH(3)*VNML                                                       STDRAW.194
C                                                                                STDRAW.195
      ISK = I1MACH(5) - 2                                                        STDRAW.196
      IS1 = ISK + 1                                                              STDRAW.197
      DFMG=RDFM*FW2W                                                             STDRAW.198
      SSP=RSSP*FW2W                                                              STDRAW.199
      CDS=RCDS*DFMG                                                              STDRAW.200
      LCT=0                                                                      STDRAW.201
      ITO=0                                                                      STDRAW.202
C                                                                                STDRAW.203
      LCU = 1                                                                    STDRAW.204
      LCK = 1                                                                    STDRAW.205
      XLS(1) = 0.                                                                STDRAW.206
      YLS(1) = 0.                                                                STDRAW.207
      IDR = 0                                                                    STDRAW.208
      SGN = 1.                                                                   STDRAW.209
      IPC = 0                                                                    STDRAW.210
      ICT = 0                                                                    STDRAW.211
C                                                                                STDRAW.212
C                                                                                STDRAW.213
C COMPUTE THE X AND Y NORMALIZED (AND POSSIBLY TRANSFORMED)                      STDRAW.214
C DISPLACEMENT COMPONENTS (UX AND VY).                                           STDRAW.215
C                                                                                STDRAW.216
      DO  40 J=IYD1,IYDN                                                         STDRAW.217
         DO  30 I=IXD1,IXDM                                                      STDRAW.218
C                                                                                STDRAW.219
            CALL STMPUV(U(I,J),V(I,J),UIJ,VIJ,IST)                               STDRAW.220
            IF (UIJ.NE.0. .OR. VIJ.NE.0.) THEN                                   STDRAW.221
               CVF = VNML/SQRT(UIJ*UIJ + VIJ*VIJ)                                STDRAW.222
               UIJ = CVF*UIJ                                                     STDRAW.223
               VIJ = CVF*VIJ                                                     STDRAW.224
            END IF                                                               STDRAW.225
C                                                                                STDRAW.226
C BOOKKEEPING IS DONE IN THE LEAST SIGNIFICANT BITS OF THE UX ARRAY.             STDRAW.227
C WHEN UIJ IS EXACTLY ZERO THIS CAN PRESENT SOME PROBLEMS.                       STDRAW.228
C TO GET AROUND THIS PROBLEM, SET IT TO A RELATIVELY SMALL NUMBER.               STDRAW.229
C                                                                                STDRAW.230
            IF (UIJ.EQ.0.0) UIJ = VSM                                            STDRAW.231
C                                                                                STDRAW.232
C MASK OUT THE LEAST SIGNIFICANT TWO BITS AS FLAGS FOR EACH GRID BOX             STDRAW.233
C A GRID BOX IS ANY REGION SURROUNDED BY FOUR GRID POINTS.                       STDRAW.234
C FLAG 1 INDICATES WHETHER ANY STREAMLINE HAS PREVIOUSLY PASSED                  STDRAW.235
C THROUGH THIS BOX.                                                              STDRAW.236
C FLAG 2 INDICATES WHETHER ANY DIRECTIONAL ARROW HAS ALREADY                     STDRAW.237
C APPEARED IN THIS BOX.                                                          STDRAW.238
C JUDICIOUS USE OF THESE FLAGS PREVENTS OVERCROWDING OF                          STDRAW.239
C STREAMLINES AND DIRECTIONAL ARROWS.                                            STDRAW.240
C                                                                                STDRAW.241
            CALL SBYTES(UIJ,IPZERO,ISK,2,0,1)                                    STDRAW.242
C                                                                                STDRAW.243
            IF (MOD(I,ISGD).NE.0 .OR. MOD(J,ISGD).NE.0) THEN                     STDRAW.244
               CALL SBYTES(UIJ,IPONE,IS1,1,0,1)                                  STDRAW.245
            END IF                                                               STDRAW.246
            IF (MOD(I,IAGD).NE.0 .OR. MOD(J,IAGD).NE.0) THEN                     STDRAW.247
               CALL SBYTES(UIJ,IPONE,ISK,1,0,1)                                  STDRAW.248
            END IF                                                               STDRAW.249
C                                                                                STDRAW.250
            UX(I,J) = UIJ                                                        STDRAW.251
            VY(I,J) = VIJ                                                        STDRAW.252
C                                                                                STDRAW.253
 30      CONTINUE                                                                STDRAW.254
 40   CONTINUE                                                                   STDRAW.255
C                                                                                STDRAW.256
C                                                                                STDRAW.257
C START A STREAMLINE. EXPERIENCE HAS SHOWN THAT A PLEASING PICTURE               STDRAW.258
C WILL BE PRODUCED IF NEW STREAMLINES ARE STARTED ONLY IN GRID                   STDRAW.259
C BOXES THAT PREVIOUSLY HAVE NOT HAD OTHER STREAMLINES PASS THROUGH              STDRAW.260
C THEM. AS LONG AS A REASONABLY DENSE PATTERN OF AVAILABLE BOXES                 STDRAW.261
C IS INITIALLY PRESCRIBED, THE ORDER OF SCANNING THE GRID PTS. FOR               STDRAW.262
C AVAILABLE BOXES IS IMMATERIAL.                                                 STDRAW.263
C                                                                                STDRAW.264
 50   CONTINUE                                                                   STDRAW.265
C                                                                                STDRAW.266
      LCT=LCT+1                                                                  STDRAW.267
      LST=0                                                                      STDRAW.268
C                                                                                STDRAW.269
C FIRST ENSURE THAT THE POINT BUFFER IS CLEAR                                    STDRAW.270
C                                                                                STDRAW.271
      IF (IPC .GT. 1) CALL STLNSG(PX,PY,IPC,IAM,STUMSL)                          STDRAW.272
C                                                                                STDRAW.273
C FIND AN AVAILABLE BOX FOR STARTING A STREAMLINE.                               STDRAW.274
C                                                                                STDRAW.275
      IF (IDR .EQ. 0) THEN                                                       STDRAW.276
C                                                                                STDRAW.277
         DO  70 J=IYD1,IYM1                                                      STDRAW.278
            DO  60 I=IXD1,IXM1                                                   STDRAW.279
               CALL GBYTES(UX(I,J),IUX,ISK,2,0,1)                                STDRAW.280
               IF (IAND(IUX,IPONE) .EQ. IPZERO) GO TO 80                         STDRAW.281
 60         CONTINUE                                                             STDRAW.282
 70      CONTINUE                                                                STDRAW.283
C                                                                                STDRAW.284
C MUST BE NO AVAILABLE BOXES FOR STARTING A STREAMLINE.                          STDRAW.285
C THIS IS THE FINAL EXIT FROM THE STREAMLINE DRAWING LOOP                        STDRAW.286
C                                                                                STDRAW.287
         GO TO 190                                                               STDRAW.288
C                                                                                STDRAW.289
 80      CONTINUE                                                                STDRAW.290
C                                                                                STDRAW.291
C INITIALIZE PARAMETERS FOR STARTING A STREAMLINE.                               STDRAW.292
C TURN THE BOX OFF FOR STARTING A STREAMLINE.                                    STDRAW.293
C IF THE SPECIAL VALUE PARAMETER IS TURNED ON, CHECK TO SEE IF                   STDRAW.294
C THIS BOX HAS MISSING DATA. IF SO, FIND A NEW STARTING BOX.                     STDRAW.295
C                                                                                STDRAW.296
         CALL SBYTES(UX(I,J),IPONE,IS1,1,0,1)                                    STDRAW.297
         IF (ISVF .NE. 0) THEN                                                   STDRAW.298
            CALL STSVCK(U,V,I,J,IST)                                             STDRAW.299
            IF (IST .NE. 0) GO TO 50                                             STDRAW.300
         END IF                                                                  STDRAW.301
C                                                                                STDRAW.302
         ISV = I                                                                 STDRAW.303
         JSV = J                                                                 STDRAW.304
         IDR = 1                                                                 STDRAW.305
         SGN = +1.0                                                              STDRAW.306
C                                                                                STDRAW.307
      ELSE                                                                       STDRAW.308
C                                                                                STDRAW.309
C COME TO HERE TO DRAW IN THE OPPOSITE DIRECTION                                 STDRAW.310
C                                                                                STDRAW.311
         IDR = 0                                                                 STDRAW.312
         SGN = -1.                                                               STDRAW.313
         I = ISV                                                                 STDRAW.314
         J = JSV                                                                 STDRAW.315
      END IF                                                                     STDRAW.316
C                                                                                STDRAW.317
C INITIATE THE DRAWING SEQUENCE, RESETTING COUNTERS.                             STDRAW.318
C START ALL STREAMLINES IN THE CENTER OF A BOX.                                  STDRAW.319
C FIND THE INITIAL NORMALIZED INTERPOLATED VECTOR COMPONENTS.                    STDRAW.320
C                                                                                STDRAW.321
      NBX = 0                                                                    STDRAW.322
      ITO = ITO+ICT                                                              STDRAW.323
      ICT = 0                                                                    STDRAW.324
      IF (IDR.NE.0) LBC = LCK+1                                                  STDRAW.325
      IF (LBC.GT.IPLSTL) LBC = 1                                                 STDRAW.326
      X = FLOAT(I)+0.5                                                           STDRAW.327
      Y = FLOAT(J)+0.5                                                           STDRAW.328
      CALL  STDUDV(UX,VY,I,J,X,Y,DU,DV)                                          STDRAW.329
      XDA=XLOV+(X-1.0)*XGDS                                                      STDRAW.330
      YDA=YLOV+(Y-1.0)*YGDS                                                      STDRAW.331
      DU=DU*SGN                                                                  STDRAW.332
      DV=DV*SGN                                                                  STDRAW.333
C                                                                                STDRAW.334
C GET INITIAL POINT IN THE VARIOUS COORDINATE SYSTEMS                            STDRAW.335
C AND THE TANGENT ANGLE OF THE STREAM. IF THE COMPATIBILITY FLAG                 STDRAW.336
C IS POSITIVE THE FX,FY ROUTINES MUST BE USED.                                   STDRAW.337
C                                                                                STDRAW.338
      IF (ICPM.LE.0) THEN                                                        STDRAW.339
C                                                                                STDRAW.340
         XDA=XLOV+(X-1.0)*XGDS                                                   STDRAW.341
         YDA=YLOV+(Y-1.0)*YGDS                                                   STDRAW.342
         CALL STMPXY(XDA,YDA,XUS,YUS,IST)                                        STDRAW.343
         IF (IST .LT. 0) GO TO 50                                                STDRAW.344
         XND=CUFX(XUS)                                                           STDRAW.345
         YND=CUFY(YUS)                                                           STDRAW.346
         XNS=XND                                                                 STDRAW.347
         YNS=YND                                                                 STDRAW.348
         XN1=XND                                                                 STDRAW.349
         YN1=YND                                                                 STDRAW.350
         CALL STMPTA(XDA,YDA,XUS,YUS,XND,YND,DU,DV,TA,IST)                       STDRAW.351
         IF (IST .LT. 0) GO TO 50                                                STDRAW.352
C                                                                                STDRAW.353
      ELSE                                                                       STDRAW.354
C                                                                                STDRAW.355
         XUS=FX(X,Y)                                                             STDRAW.356
         IF (XUS.LT.WXMN .OR. XUS.GT.WXMX) GO TO 50                              STDRAW.357
         YUS=FY(X,Y)                                                             STDRAW.358
         IF (YUS.LT.WYMN .OR. YUS.GT.WYMX) GO TO 50                              STDRAW.359
         XND=CUFX(XUS)                                                           STDRAW.360
         YND=CUFY(YUS)                                                           STDRAW.361
         TA=ATAN2(DV,DU)                                                         STDRAW.362
C                                                                                STDRAW.363
      END IF                                                                     STDRAW.364
C                                                                                STDRAW.365
      IPC=1                                                                      STDRAW.366
      PX(IPC)=XUS                                                                STDRAW.367
      PY(IPC)=YUS                                                                STDRAW.368
C                                                                                STDRAW.369
C CHECK GRID BOX DIRECTIONAL ARROW ELIGIBILITY                                   STDRAW.370
C                                                                                STDRAW.371
      CALL GBYTES(UX(I,J),IUX,ISK,2,0,1)                                         STDRAW.372
C                                                                                STDRAW.373
      IF (IDR.NE.0 .AND. IAND(IUX,IPTWO).EQ.0) THEN                              STDRAW.374
         CALL STARDR(XUS,YUS,XND,YND,TA,IAM,STUMSL,IST)                          STDRAW.375
         IF (IST.EQ.0) THEN                                                      STDRAW.376
            CALL SBYTES(UX(I,J),IPONE,ISK,1,0,1)                                 STDRAW.377
         END IF                                                                  STDRAW.378
C                                                                                STDRAW.379
      END IF                                                                     STDRAW.380
C                                                                                STDRAW.381
C LOOP TO THIS POINT UNTIL STREAMLINE ENDS                                       STDRAW.382
C                                                                                STDRAW.383
 110  CONTINUE                                                                   STDRAW.384
C                                                                                STDRAW.385
C CHECK TO SEE IF THE STREAMLINE HAS ENTERED A NEW GRID BOX.                     STDRAW.386
C                                                                                STDRAW.387
      IF (I.EQ.IFIX(X) .AND. J.EQ.IFIX(Y)) THEN                                  STDRAW.388
C                                                                                STDRAW.389
C MUST BE IN SAME BOX --  CLEAR THE POINT BUFFER IF REQUIRED                     STDRAW.390
C                                                                                STDRAW.391
         IF (IPC .EQ. IPNPTS) THEN                                               STDRAW.392
            CALL STLNSG(PX,PY,IPNPTS,IAM,STUMSL)                                 STDRAW.393
            PX(1)=PX(IPNPTS)                                                     STDRAW.394
            PY(1)=PY(IPNPTS)                                                     STDRAW.395
            IPC=1                                                                STDRAW.396
         ENDIF                                                                   STDRAW.397
C                                                                                STDRAW.398
C DETERMINE THE INTERPOLATED NORMALIZED VECTOR AT THIS POINT                     STDRAW.399
C                                                                                STDRAW.400
         CALL STDUDV (UX,VY,I,J,X,Y,DU,DV)                                       STDRAW.401
         IF (DU.EQ.0.0 .AND. DV.EQ.0.0) GO TO 50                                 STDRAW.402
C                                                                                STDRAW.403
C PROCESSING DIVERGES DEPENDING ON THE COMPATIBILITY MODE                        STDRAW.404
C                                                                                STDRAW.405
         IF (ICPM .LE. 0) THEN                                                   STDRAW.406
C                                                                                STDRAW.407
C GET THE TANGENT ANGLE OF THE STREAMLINE AT THE CURRENT POINT                   STDRAW.408
C IN NDC SPACE                                                                   STDRAW.409
C                                                                                STDRAW.410
            CALL STMPTA(XDA,YDA,XUS,YUS,XND,YND,DU,DV,TA,IST)                    STDRAW.411
            IF (IST.NE.0) GO TO 50                                               STDRAW.412
C                                                                                STDRAW.413
         ELSE                                                                    STDRAW.414
C                                                                                STDRAW.415
C A NEW POINT IS FOUND IN GRID SPACE, THEN TRANSFORMED INTO                      STDRAW.416
C USER AND NDC SPACE. THERE IS NO TRANSFORMATION OF THE TANGENT                  STDRAW.417
C ANGLE.                                                                         STDRAW.418
            X=X+SGN*DU                                                           STDRAW.419
            Y=Y+SGN*DV                                                           STDRAW.420
            XUS=FX(X,Y)                                                          STDRAW.421
            IF (XUS.LT.WXMN .OR. XUS.GT.WXMX) GO TO 50                           STDRAW.422
            YUS=FY(X,Y)                                                          STDRAW.423
            IF (YUS.LT.WYMN .OR. YUS.GT.WYMX) GO TO 50                           STDRAW.424
            XND=CUFX(XUS)                                                        STDRAW.425
            YND=CUFY(YUS)                                                        STDRAW.426
            TA=ATAN2(DV,DU)                                                      STDRAW.427
C                                                                                STDRAW.428
         END IF                                                                  STDRAW.429
C                                                                                STDRAW.430
C COUNT THE POINT AND ADD IT TO THE POINT BUFFER                                 STDRAW.431
C                                                                                STDRAW.432
         ICT=ICT+1                                                               STDRAW.433
         IPC=IPC+1                                                               STDRAW.434
         PX(IPC)=XUS                                                             STDRAW.435
         PY(IPC)=YUS                                                             STDRAW.436
C                                                                                STDRAW.437
         IF (ICPM.LT.1) THEN                                                     STDRAW.438
C                                                                                STDRAW.439
            IF (LST .EQ. 1) GO TO 50                                             STDRAW.440
C                                                                                STDRAW.441
C THE INCREMENT IN NDC SPACE NEEDS TO BE PROPORTIONAL TO THE                     STDRAW.442
C MAGNITUDE OF THE INTERPOLATED VECTOR, IN ORDER TO ENSURE THAT                  STDRAW.443
C PROGRESS CHECKING WORKS AT POINTS OF CONVERGENCE OR DIVERGENCE.                STDRAW.444
C THE SQUARE ENHANCES THE EFFECTIVENESS OF THE TECHNIQUE.                        STDRAW.445
C                                                                                STDRAW.446
            DUV=(DU*DU+DV*DV)/(VNML*VNML)                                        STDRAW.447
            CSA=COS(TA)*SGN                                                      STDRAW.448
            SNA=SIN(TA)*SGN                                                      STDRAW.449
C                                                                                STDRAW.450
C THE CURRENT POINT IS ADJUSTED ONE THIRD OF THE DISTANCE BACK TO                STDRAW.451
C THE PREVIOUS POINT. EMPIRICALLY, IN MOST CASES, THIS SEEMS TO                  STDRAW.452
C DECREASE THE INACCURACY RESULTING FROM THE USE OF A FINITE VALUED              STDRAW.453
C DIFFERENTIAL STEP.                                                             STDRAW.454
C                                                                                STDRAW.455
            XN2=XN1                                                              STDRAW.456
            YN2=YN1                                                              STDRAW.457
            XN1=XND                                                              STDRAW.458
            YN1=YND                                                              STDRAW.459
            XN1=XN1+(XN2-XN1)/PTHREE                                             STDRAW.460
            YN1=YN1+(YN2-YN1)/PTHREE                                             STDRAW.461
            XND=XN1+CSA*DFMG*DUV                                                 STDRAW.462
            YND=YN1+SNA*DFMG*DUV                                                 STDRAW.463
C                                                                                STDRAW.464
C IF THE INCREMENT TAKES THE LINE OUTSIDE THE VIEWPORT, FIND AN                  STDRAW.465
C INTERPOLATED POINT ON THE GRID EDGE. SET A FLAG INDICATING                     STDRAW.466
C THE END OF THE STREAM                                                          STDRAW.467
C                                                                                STDRAW.468
            IF (XND .LT. XVPL) THEN                                              STDRAW.469
               XND = XVPL                                                        STDRAW.470
               IF (ABS(CSA).GT.0.1) THEN                                         STDRAW.471
                  TMG = (XND-XN1)/CSA                                            STDRAW.472
                  YND = YN1+SNA*TMG                                              STDRAW.473
               ENDIF                                                             STDRAW.474
               LST = 1                                                           STDRAW.475
            ELSE IF (XND .GT. XVPR) THEN                                         STDRAW.476
               XND = XVPR                                                        STDRAW.477
               IF (ABS(CSA).GT.0.1) THEN                                         STDRAW.478
                  TMG = (XND-XN1)/CSA                                            STDRAW.479
                  YND = YN1+SNA*TMG                                              STDRAW.480
               ENDIF                                                             STDRAW.481
               LST = 1                                                           STDRAW.482
            ELSE IF (YND .LT. YVPB) THEN                                         STDRAW.483
               YND = YVPB                                                        STDRAW.484
               IF (ABS(SNA).GT.0.1) THEN                                         STDRAW.485
                  TMG = (YND-YN1)/SNA                                            STDRAW.486
                  XND = XN1+CSA*TMG                                              STDRAW.487
               END IF                                                            STDRAW.488
               LST = 1                                                           STDRAW.489
            ELSE IF (YND .GT. YVPT) THEN                                         STDRAW.490
               YND = YVPT                                                        STDRAW.491
               IF (ABS(SNA).GT.0.1) THEN                                         STDRAW.492
                  TMG = (YND-YN1)/SNA                                            STDRAW.493
                  XND = XN1+CSA*TMG                                              STDRAW.494
               END IF                                                            STDRAW.495
               LST = 1                                                           STDRAW.496
            END IF                                                               STDRAW.497
C                                                                                STDRAW.498
C NOW THAT THE NEW POINT HAS BEEN FOUND IN NDC SPACE, FIND ITS                   STDRAW.499
C COORDINATES IN USER, DATA, AND GRID SPACE.                                     STDRAW.500
C                                                                                STDRAW.501
            XUS=CFUX(XND)                                                        STDRAW.502
            YUS=CFUY(YND)                                                        STDRAW.503
C                                                                                STDRAW.504
            CALL STIMXY(XUS,YUS,XDA,YDA,IST)                                     STDRAW.505
            IF (IST.NE.0) GO TO 50                                               STDRAW.506
C                                                                                STDRAW.507
            X=(XDA-XLOV)/XGDS+1.0                                                STDRAW.508
            Y=(YDA-YLOV)/YGDS+1.0                                                STDRAW.509
C                                                                                STDRAW.510
C IF ON THE TOP OR RIGHT EDGE OF THE GRID SPACE, DECREASE THE X AND/OR           STDRAW.511
C Y VALUE BY A SMALL AMOUNT SO THE INTERPOLATION ROUTINE STILL WORKS.            STDRAW.512
C                                                                                STDRAW.513
            IF (IFIX(X).GE.IXDM) X=FLOAT(IXDM)-PSMALL                            STDRAW.514
            IF (IFIX(Y).GE.IYDN) Y=FLOAT(IYDN)-PSMALL                            STDRAW.515
C                                                                                STDRAW.516
         END IF                                                                  STDRAW.517
C                                                                                STDRAW.518
C CHECK STREAMLINE PROGRESS EVERY 'ICKP' ITERATIONS.                             STDRAW.519
C                                                                                STDRAW.520
         IF (MOD(ICT,ICKP).EQ.0) THEN                                            STDRAW.521
            IF (ABS(XND-XNS).LT.CDS                                              STDRAW.522
     +           .AND. ABS(YND-YNS).LT.CDS) THEN                                 STDRAW.523
               GO TO 50                                                          STDRAW.524
            END IF                                                               STDRAW.525
            XNS=XND                                                              STDRAW.526
            YNS=YND                                                              STDRAW.527
            GO TO 110                                                            STDRAW.528
         END IF                                                                  STDRAW.529
C                                                                                STDRAW.530
C IF THE CIRCULAR LIST DOES NOT NEED TO BE CHECKED FOR                           STDRAW.531
C STREAMLINE CROSSOVER, RETURN TO THE TOP OF THE MAIN LOOP.                      STDRAW.532
C                                                                                STDRAW.533
         IF (ICKX.LT.0 .OR. MOD(ICT,ICKX).NE.0) GO TO 110                        STDRAW.534
C                                                                                STDRAW.535
      ELSE                                                                       STDRAW.536
C                                                                                STDRAW.537
C MUST HAVE ENTERED A NEW GRID BOX  CHECK FOR THE FOLLOWING :                    STDRAW.538
C (1) ARE THE NEW POINTS ON THE GRID?                                            STDRAW.539
C (2) CHECK FOR MISSING DATA IF MSG DATA FLAG (ISVF) HAS BEEN SET.               STDRAW.540
C (3) IS THIS BOX ELIGIBLE FOR A DIRECTIONAL ARROW?                              STDRAW.541
C (4) LOCATION OF THIS ENTRY VERSUS OTHER STREAMLINE ENTRIES                     STDRAW.542
C                                                                                STDRAW.543
         I = IFIX(X)                                                             STDRAW.544
         J = IFIX(Y)                                                             STDRAW.545
         NBX = NBX+1                                                             STDRAW.546
C                                                                                STDRAW.547
C CHECK (1) (ONLY PERFORMED IN COMPATIBILITY MODE)                               STDRAW.548
C                                                                                STDRAW.549
         IF (ICPM.GT.0) THEN                                                     STDRAW.550
            IF (I.LT.IXD1 .OR. I.GT.IXM1                                         STDRAW.551
     +           .OR. J.LT.IYD1 .OR. J.GT.IYM1) THEN                             STDRAW.552
               GO TO  50                                                         STDRAW.553
            END IF                                                               STDRAW.554
         END IF                                                                  STDRAW.555
C                                                                                STDRAW.556
C CHECK (2)                                                                      STDRAW.557
C                                                                                STDRAW.558
         IF (ISVF.NE.0) THEN                                                     STDRAW.559
            CALL STSVCK(U,V,I,J,IST)                                             STDRAW.560
            IF (IST .NE. 0) GO TO 50                                             STDRAW.561
         END IF                                                                  STDRAW.562
C                                                                                STDRAW.563
C CHECK (3)                                                                      STDRAW.564
C                                                                                STDRAW.565
         CALL GBYTES(UX(I,J),IUX,ISK,2,0,1)                                      STDRAW.566
         IF (IAND(IUX,IPTWO) .EQ. 0) THEN                                        STDRAW.567
            CALL STARDR(XUS,YUS,XND,YND,TA,IAM,STUMSL,IST)                       STDRAW.568
            IF (IST .EQ. 0) THEN                                                 STDRAW.569
               CALL SBYTES(UX(I,J),IPONE,ISK,1,0,1)                              STDRAW.570
            END IF                                                               STDRAW.571
         END IF                                                                  STDRAW.572
C                                                                                STDRAW.573
      END IF                                                                     STDRAW.574
C                                                                                STDRAW.575
C CHECK (4) (PERFORMED ANY TIME STREAMLINE CROSSOVER IS CHECKED)                 STDRAW.576
C                                                                                STDRAW.577
      DO 140 LI=1,LCU                                                            STDRAW.578
         IF (ABS(XND-XLS(LI)) .LE. SSP .AND.                                     STDRAW.579
     +        ABS(YND-YLS(LI)) .LE. SSP) THEN                                    STDRAW.580
            IF (LBC.LE.LCK .AND.                                                 STDRAW.581
     +           (LI.LT.LBC .OR. LI.GT.LCK)) THEN                                STDRAW.582
               GO TO 50                                                          STDRAW.583
            ELSE IF (LBC.GT.LCK .AND.                                            STDRAW.584
     +              (LI.LT.LBC .AND. LI.GT.LCK)) THEN                            STDRAW.585
               GO TO 50                                                          STDRAW.586
            END IF                                                               STDRAW.587
         END IF                                                                  STDRAW.588
 140  CONTINUE                                                                   STDRAW.589
C                                                                                STDRAW.590
      LCU = MIN0(LCU+1,IPLSTL)                                                   STDRAW.591
      LCK = LCK+1                                                                STDRAW.592
      IF (LCK.GT.IPLSTL) LCK = 1                                                 STDRAW.593
      XLS(LCK) = XND                                                             STDRAW.594
      YLS(LCK) = YND                                                             STDRAW.595
      CALL SBYTES(UX(I,J),IPONE,IS1,1,0,1)                                       STDRAW.596
      IF (NBX.GE.5) THEN                                                         STDRAW.597
         LBC = LBC+1                                                             STDRAW.598
         IF (LBC.GT.IPLSTL) LBC = 1                                              STDRAW.599
      END IF                                                                     STDRAW.600
C                                                                                STDRAW.601
C RETURN TO TOP OF DRAWING LOOP                                                  STDRAW.602
C                                                                                STDRAW.603
      GO TO 110                                                                  STDRAW.604
C                                                                                STDRAW.605
C                                                                                STDRAW.606
C FINAL EXIT                                                                     STDRAW.607
C                                                                                STDRAW.608
  190 CONTINUE                                                                   STDRAW.609
C                                                                                STDRAW.610
C PLOT STATISTICS                                                                STDRAW.611
C                                                                                STDRAW.612
      IF (ISST.EQ.1) THEN                                                        STDRAW.613
         LUN=I1MACH(2)                                                           STDRAW.614
         WRITE(LUN,*) 'STREAM STATISTICS'                                        STDRAW.615
         WRITE(LUN,*) '                STREAMLINES PLOTTED:',LCT                 STDRAW.616
         WRITE(LUN,*) '      TOTAL DIFFERENTIAL STEP COUNT:',ITO                 STDRAW.617
         WRITE(LUN,*) ' '                                                        STDRAW.618
      END IF                                                                     STDRAW.619
C                                                                                STDRAW.620
C SET THE WORKSPACE USED PARAMETER                                               STDRAW.621
C                                                                                STDRAW.622
      IWKU = 2*IXDM*IYDN                                                         STDRAW.623
C                                                                                STDRAW.624
      RETURN                                                                     STDRAW.625
      END                                                                        STDRAW.626
