C                                                                                STDUDV.1
C	$ID: STDUDV.F,V 2.0 1997/01/11 20:33:34 MESOUSER EXP $                         STDUDV.2
C                                                                                STDUDV.3
      SUBROUTINE STDUDV (UX,VY,I,J,X,Y,DU,DV)                                    STDUDV.4
C                                                                                STDUDV.5
C INPUT PARAMETERS:                                                              STDUDV.6
C                                                                                STDUDV.7
C UX,VY  - THE ARRAYS CONTAINING NORMALIZED VECTOR FIELD DATA                    STDUDV.8
C I,J    - THE CURRENT GRID INDICES                                              STDUDV.9
C X,Y    - THE X,Y POSITION RELATIVE TO THE GRID                                 STDUDV.10
C                                                                                STDUDV.11
C OUTPUT PARAMETERS:                                                             STDUDV.12
C                                                                                STDUDV.13
C DU,DV  - INTERPOLATED VALUE OF THE VECTOR FIELD COMPONENTS                     STDUDV.14
C          AT THE SPECIFIED POINT                                                STDUDV.15
C                                                                                STDUDV.16
C INTERPOLATION ROUTINE TO CALCULATE THE DISPLACEMANT COMPONENTS.                STDUDV.17
C THE PHILOSPHY HERE IS TO UTILIZE AS MANY POINTS AS POSSIBLE                    STDUDV.18
C (WITHIN REASON) IN ORDER TO OBTAIN A PLEASING AND ACCURATE PLOT.               STDUDV.19
C INTERPOLATION SCHEMES DESIRED BY OTHER USERS MAY EASILY BE                     STDUDV.20
C SUBSTITUTED IF DESIRED.                                                        STDUDV.21
C                                                                                STDUDV.22
      DIMENSION UX(IXDM,*), VY(IXDM,*)                                           STDUDV.23
C                                                                                STDUDV.24
C ---------------------------------------------------------------------          STDUDV.25
C                                                                                STDUDV.26
C NOTE:                                                                          STDUDV.27
C SINCE IMPLICIT TYPING IS USED FOR ALL REAL AND INTEGER VARIABLES               STDUDV.28
C A CONSISTENT LENGTH CONVENTION HAS BEEN ADOPTED TO HELP CLARIFY THE            STDUDV.29
C SIGNIFICANCE OF THE VARIABLES ENCOUNTERED IN THE CODE FOR THIS                 STDUDV.30
C UTILITY. ALL LOCAL VARIABLE AND SUBROUTINE PARAMETER IDENTIFIERS               STDUDV.31
C ARE LIMITED TO 1,2,OR 3 CHARACTERS. FOUR CHARACTER NAMES IDENTIFY              STDUDV.32
C MEMBERS OF COMMON BLOCKS. FIVE AND 6 CHARACTER VARIABLE NAMES                  STDUDV.33
C DENOTE PARAMETER CONSTANTS OR SUBROUTINE OR FUNCTION NAMES.                    STDUDV.34
C                                                                                STDUDV.35
C DECLARE THE ST COMMON BLOCKS.                                                  STDUDV.36
C                                                                                STDUDV.37
      PARAMETER (IPLVLS = 64)                                                    STDUDV.38
C                                                                                STDUDV.39
C INTEGER AND REAL COMMON BLOCK VARIABLES                                        STDUDV.40
C                                                                                STDUDV.41
C                                                                                STDUDV.42
      COMMON / STPAR /                                                           STDUDV.43
     +                IUD1       ,IVD1       ,IPD1       ,                       STDUDV.44
     +                IXD1       ,IXDM       ,IYD1       ,IYDN       ,           STDUDV.45
     +                IXM1       ,IYM1       ,IXM2       ,IYM2       ,           STDUDV.46
     +                IWKD       ,IWKU       ,ISET       ,IERR       ,           STDUDV.47
     +	              IXIN       ,IYIN       ,IMSK       ,ICPM       ,            STDUDV.48
     +                NLVL       ,IPAI       ,ICTV       ,WDLV       ,           STDUDV.49
     +                UVMN       ,UVMX       ,PMIN       ,PMAX       ,           STDUDV.50
     +                ITHN       ,IPLR       ,ISST       ,                       STDUDV.51
     +                ICLR(IPLVLS)           ,TVLU(IPLVLS)                       STDUDV.52
C                                                                                STDUDV.53
      COMMON / STTRAN /                                                          STDUDV.54
     +                UVPS       ,                                               STDUDV.55
     +                UVPL       ,UVPR       ,UVPB       ,UVPT       ,           STDUDV.56
     +                UWDL       ,UWDR       ,UWDB       ,UWDT       ,           STDUDV.57
     +                UXC1       ,UXCM       ,UYC1       ,UYCN                   STDUDV.58
C                                                                                STDUDV.59
C STREAM ALGORITHM PARAMETERS                                                    STDUDV.60
C                                                                                STDUDV.61
      COMMON / STSTRM /                                                          STDUDV.62
     +                ISGD       ,IAGD       ,RARL       ,ICKP       ,           STDUDV.63
     +                ICKX       ,ITRP       ,ICYK       ,RVNL       ,           STDUDV.64
     +                ISVF       ,RUSV       ,RVSV       ,RNDA       ,           STDUDV.65
     +                ISPC       ,RPSV       ,RCDS       ,RSSP       ,           STDUDV.66
     +                RDFM                                                       STDUDV.67
C                                                                                STDUDV.68
C TEXT RELATED PARAMETERS                                                        STDUDV.69
C NOTE: GRAPHICAL TEXT OUTPUT IS NOT YET IMPLEMENTED FOR THE                     STDUDV.70
C       STREAMLINE UTILITY.                                                      STDUDV.71
C                                                                                STDUDV.72
      COMMON / STTXP /                                                           STDUDV.73
     +                FCWM    ,ICSZ    ,                                         STDUDV.74
     +                FMNS    ,FMNX    ,FMNY    ,IMNP    ,IMNC  ,                STDUDV.75
     +                FMXS    ,FMXX    ,FMXY    ,IMXP    ,IMXC  ,                STDUDV.76
     +                FZFS    ,FZFX    ,FZFY    ,IZFP    ,IZFC  ,                STDUDV.77
     +                FILS    ,FILX    ,FILY    ,IILP    ,IILC                   STDUDV.78
C                                                                                STDUDV.79
C CHARACTER VARIABLE DECLARTIONS                                                 STDUDV.80
C                                                                                STDUDV.81
      CHARACTER*160 CSTR                                                         STDUDV.82
      PARAMETER (IPCHSZ=80)                                                      STDUDV.83
      CHARACTER*(IPCHSZ)  CMNT,CMXT,CZFT,CILT                                    STDUDV.84
C                                                                                STDUDV.85
C TEXT STRING PARAMETERS                                                         STDUDV.86
C                                                                                STDUDV.87
      COMMON / STCHAR / CSTR,CMNT,CMXT,CZFT,CILT                                 STDUDV.88
C                                                                                STDUDV.89
      SAVE /STPAR/, /STTRAN/, /STSTRM/, /STTXP/, /STCHAR/                        STDUDV.90
C                                                                                STDUDV.91
C INTERNAL BUFFER LENGTHS                                                        STDUDV.92
C                                                                                STDUDV.93
C IPNPTS - NUMBER OF POINTS IN THE POINT BUFFER -- NOT LESS THAN 3               STDUDV.94
C IPLSTL - STREAMLINE-CROSSOVER-CHECK CIRCULAR LIST LENGTH                       STDUDV.95
C IPGRCT - NUMBER OF GROUPS SUPPORTED FOR AREA MASKING                           STDUDV.96
C                                                                                STDUDV.97
      PARAMETER (IPNPTS = 10, IPLSTL = 750, IPGRCT = 64)                         STDUDV.98
C                                                                                STDUDV.99
C FDLI  - DOUBLE LINEAR INTERPOLATION FORMULA                                    STDUDV.100
C FBESL - BESSEL 16 PT INTERPOLATION FORMULA ( MOST USED FORMULA )               STDUDV.101
C FQUAD - QUADRATIC INTERPOLATION FORMULA                                        STDUDV.102
C                                                                                STDUDV.103
      FDLI(Z,Z1,Z2,Z3,DX,DY) = (1.-DX)*((1.-DY)*Z +DY*Z1)                        STDUDV.104
     +                         +     DX *((1.-DY)*Z2+DY*Z3)                      STDUDV.105
      FBESL(Z,ZP1,ZP2,ZM1,DZ)=Z+DZ*(ZP1-Z+0.25*(DZ-1.)*((ZP2-ZP1-Z+ZM1)          STDUDV.106
     +                        +0.666667*(DZ-0.5)*(ZP2-3.*ZP1+3.*Z-ZM1)))         STDUDV.107
      FQUAD(Z,ZP1,ZM1,DZ)=Z+0.5*DZ*(ZP1-ZM1+DZ*(ZP1-2.*Z+ZM1))                   STDUDV.108
C                                                                                STDUDV.109
C ---------------------------------------------------------------------          STDUDV.110
C                                                                                STDUDV.111
      DX = X-AINT(X)                                                             STDUDV.112
      DY = Y-AINT(Y)                                                             STDUDV.113
      ITF = 1                                                                    STDUDV.114
      IM1 = I-1                                                                  STDUDV.115
      IP2 = I+2                                                                  STDUDV.116
C                                                                                STDUDV.117
C DETERMINE WHICH INTERPOLATION FORMULA TO USE                                   STDUDV.118
C DEPENDING ON I,J LOCATION OR THE SPECIAL FLAGS                                 STDUDV.119
C                                                                                STDUDV.120
      IF (I.GE.IXDM .OR. J.GE.IYDN) THEN                                         STDUDV.121
C                                                                                STDUDV.122
C THIS BRANCH SHOULD NEVER BE TAKEN IF STDRAW IS CORRECT, BUT IS                 STDUDV.123
C INCLUDED FOR SAFETY                                                            STDUDV.124
C                                                                                STDUDV.125
         RETURN                                                                  STDUDV.126
C                                                                                STDUDV.127
      ELSE IF(ISVF.NE.0 .OR. ITRP.NE.0) THEN                                     STDUDV.128
         ITF = 1                                                                 STDUDV.129
      ELSE IF (J.GT.IYD1 .AND. J.LT.IYM1                                         STDUDV.130
     +        .AND. I.GT.IXD1 .AND. I.LT.IXM1) THEN                              STDUDV.131
         ITF = 2                                                                 STDUDV.132
      ELSE IF (J.EQ.IYM1 .AND. I.GT.IXD1 .AND. I.LT.IXM1) THEN                   STDUDV.133
         ITF = 3                                                                 STDUDV.134
      ELSE IF (J.EQ.IYD1) THEN                                                   STDUDV.135
         ITF = 1                                                                 STDUDV.136
      ELSE IF (ICYK.NE.1) THEN                                                   STDUDV.137
         IF (I.EQ.IXD1) THEN                                                     STDUDV.138
            ITF = 1                                                              STDUDV.139
         ELSE IF (I.EQ.IXM1) THEN                                                STDUDV.140
            ITF = 4                                                              STDUDV.141
         END IF                                                                  STDUDV.142
      ELSE IF (I.EQ.IXD1 .AND. J.LT.IYM1) THEN                                   STDUDV.143
         IM1 = IXM1                                                              STDUDV.144
         ITF = 2                                                                 STDUDV.145
      ELSE IF (I.EQ.IXM1 .AND. J.LT.IYM1) THEN                                   STDUDV.146
         IP2 = IXD1+1                                                            STDUDV.147
         ITF = 2                                                                 STDUDV.148
      ELSE IF (J.EQ.IYM1 .AND. I.EQ.IXD1) THEN                                   STDUDV.149
         IM1 = IXM1                                                              STDUDV.150
         ITF = 3                                                                 STDUDV.151
      ELSE IF (J.EQ.IYM1 .AND. I.EQ.IXM1) THEN                                   STDUDV.152
         IP2 = IXD1+1                                                            STDUDV.153
         ITF = 3                                                                 STDUDV.154
      END IF                                                                     STDUDV.155
C                                                                                STDUDV.156
      IF (ITF .EQ. 1) THEN                                                       STDUDV.157
C                                                                                STDUDV.158
C DOUBLE LINEAR INTERPOLATION FORMULA. THIS SCHEME WORKS AT ALL POINTS           STDUDV.159
C BUT THE RESULTING STREAMLINES ARE NOT AS PLEASING AS THOSE DRAWN               STDUDV.160
C BY FBESL OR FQUAD. CURRENTLY THIS IS UTILIZED                                  STDUDV.161
C ONLY AT CERTAIN BOUNDARY POINTS OR IF ITRP IS NOT EQUAL TO ZERO,               STDUDV.162
C OR IF SPECIAL VALUE PROCESSING IS TURNED ON.                                   STDUDV.163
C                                                                                STDUDV.164
         DU = FDLI(UX(I,J),UX(I,J+1),UX(I+1,J),UX(I+1,J+1),DX,DY)                STDUDV.165
         DV = FDLI(VY(I,J),VY(I,J+1),VY(I+1,J),VY(I+1,J+1),DX,DY)                STDUDV.166
C                                                                                STDUDV.167
      ELSE IF (ITF .EQ. 2) THEN                                                  STDUDV.168
C                                                                                STDUDV.169
C 16 POINT BESSEL INTERPOLATION SCHEME.                                          STDUDV.170
C                                                                                STDUDV.171
         UJM1 = FBESL(UX(I,J-1),UX(I+1,J-1),UX(IP2,J-1),UX(IM1,J-1),DX)          STDUDV.172
         UJ   = FBESL(UX(I,J),UX(I+1,J),UX(IP2,J),UX(IM1,J),DX)                  STDUDV.173
         UJP1 = FBESL(UX(I,J+1),UX(I+1,J+1),UX(IP2,J+1),UX(IM1,J+1),DX)          STDUDV.174
         UJP2 = FBESL(UX(I,J+2),UX(I+1,J+2),UX(IP2,J+2),UX(IM1,J+2),DX)          STDUDV.175
         DU   = FBESL(UJ,UJP1,UJP2,UJM1,DY)                                      STDUDV.176
         VJM1 = FBESL(VY(I,J-1),VY(I+1,J-1),VY(IP2,J-1),VY(IM1,J-1),DX)          STDUDV.177
         VJ   = FBESL(VY(I,J),VY(I+1,J),VY(IP2,J),VY(IM1,J),DX)                  STDUDV.178
         VJP1 = FBESL(VY(I,J+1),VY(I+1,J+1),VY(IP2,J+1),VY(IM1,J+1),DX)          STDUDV.179
         VJP2 = FBESL(VY(I,J+2),VY(I+1,J+2),VY(IP2,J+2),VY(IM1,J+2),DX)          STDUDV.180
         DV   = FBESL(VJ,VJP1,VJP2,VJM1,DY)                                      STDUDV.181
C                                                                                STDUDV.182
      ELSE IF (ITF .EQ. 3) THEN                                                  STDUDV.183
C                                                                                STDUDV.184
C 12 POINT INTERPOLATION SCHEME APPLICABLE TO ONE ROW FROM TOP BOUNDARY          STDUDV.185
C                                                                                STDUDV.186
         UJM1 = FBESL(UX(I,J-1),UX(I+1,J-1),UX(IP2,J-1),UX(IM1,J-1),DX)          STDUDV.187
         UJ   = FBESL(UX(I,J),UX(I+1,J),UX(IP2,J),UX(IM1,J),DX)                  STDUDV.188
         UJP1 = FBESL(UX(I,J+1),UX(I+1,J+1),UX(IP2,J+1),UX(IM1,J+1),DX)          STDUDV.189
         DU   = FQUAD(UJ,UJP1,UJM1,DY)                                           STDUDV.190
         VJM1 = FBESL(VY(I,J-1),VY(I+1,J-1),VY(IP2,J-1),VY(IM1,J-1),DX)          STDUDV.191
         VJ   = FBESL(VY(I,J),VY(I+1,J),VY(IP2,J),VY(IM1,J),DX)                  STDUDV.192
         VJP1 = FBESL(VY(I,J+1),VY(I+1,J+1),VY(IP2,J+1),VY(IM1,J+1),DX)          STDUDV.193
         DV   = FQUAD(VJ,VJP1,VJM1,DY)                                           STDUDV.194
C                                                                                STDUDV.195
      ELSE IF (ITF .EQ. 4) THEN                                                  STDUDV.196
C                                                                                STDUDV.197
C 9 POINT INTERPOLATION SCHEME FOR USE IN THE NON-CYCLIC CASE                    STDUDV.198
C AT I=IXM1; J > IYD1 AND J <= IYM1                                              STDUDV.199
C                                                                                STDUDV.200
         UJP1 = FQUAD(UX(I,J+1),UX(I+1,J+1),UX(IM1,J+1),DX)                      STDUDV.201
         UJ   = FQUAD(UX(I,J),UX(I+1,J),UX(IM1,J),DX)                            STDUDV.202
         UJM1 = FQUAD(UX(I,J-1),UX(I+1,J-1),UX(IM1,J-1),DX)                      STDUDV.203
         DU   = FQUAD(UJ,UJP1,UJM1,DY)                                           STDUDV.204
         VJP1 = FQUAD(VY(I,J+1),VY(I+1,J+1),VY(IM1,J+1),DX)                      STDUDV.205
         VJ   = FQUAD(VY(I,J),VY(I+1,J),VY(IM1,J),DX)                            STDUDV.206
         VJM1 = FQUAD(VY(I,J-1),VY(I+1,J-1),VY(IM1,J-1),DX)                      STDUDV.207
         DV   = FQUAD(VJ,VJP1,VJM1,DY)                                           STDUDV.208
C                                                                                STDUDV.209
      END IF                                                                     STDUDV.210
C                                                                                STDUDV.211
C DONE                                                                           STDUDV.212
C                                                                                STDUDV.213
      RETURN                                                                     STDUDV.214
      END                                                                        STDUDV.215
