C                                                                                STIMXY.1
      SUBROUTINE STIMXY(XUS,YUS,XDA,YDA,IST)                                     STIMXY.2
C                                                                                STIMXY.3
C INVERSELY TRANSFORM A POINT IN USER COORDINATE SPACE TO DATA SPACE             STIMXY.4
C                                                                                STIMXY.5
C INPUT PARAMETERS:                                                              STIMXY.6
C                                                                                STIMXY.7
C XUS,YUS - POINT IN USER COORDINATE SPACE                                       STIMXY.8
C                                                                                STIMXY.9
C OUTPUT PARAMETERS:                                                             STIMXY.10
C                                                                                STIMXY.11
C XDA,YDA - POINT IN DATA COORDINATE SPACE                                       STIMXY.12
C IST     - STATUS CODE INDICATING SUCCESS OR FAILURE                            STIMXY.13
C                                                                                STIMXY.14
C                                                                                STIMXY.15
C THE MAPPING COMMON BLOCK: MADE AVAILABLE TO USER MAPPING ROUTINES              STIMXY.16
C                                                                                STIMXY.17
      COMMON /STMAP/                                                             STIMXY.18
     +                IMAP       ,LNLG       ,INVX       ,INVY       ,           STIMXY.19
     +                XLOV       ,XHIV       ,YLOV       ,YHIV       ,           STIMXY.20
     +                WXMN       ,WXMX       ,WYMN       ,WYMX       ,           STIMXY.21
     +                XVPL       ,XVPR       ,YVPB       ,YVPT       ,           STIMXY.22
     +                XGDS       ,YGDS       ,NXCT       ,NYCT       ,           STIMXY.23
     +                ITRT       ,FW2W       ,FH2H       ,                       STIMXY.24
     +                DFMG       ,VNML       ,RBIG       ,IBIG                   STIMXY.25
C                                                                                STIMXY.26
      SAVE /STMAP/                                                               STIMXY.27
C                                                                                STIMXY.28
C MATH CONSTANTS                                                                 STIMXY.29
C                                                                                STIMXY.30
      PARAMETER (PDTOR  = 0.017453292519943,                                     STIMXY.31
     +           PRTOD  = 57.2957795130823,                                      STIMXY.32
     +           P1XPI  = 3.14159265358979,                                      STIMXY.33
     +           P2XPI  = 6.28318530717959,                                      STIMXY.34
     +           P1D2PI = 1.57079632679489,                                      STIMXY.35
     +           P5D2PI = 7.85398163397448)                                      STIMXY.36
C                                                                                STIMXY.37
C --------------------------------------------------------------------           STIMXY.38
C                                                                                STIMXY.39
C ---------------------------------------------------------------------          STIMXY.40
C                                                                                STIMXY.41
      IST=0                                                                      STIMXY.42
      IF (IMAP .EQ. 0) THEN                                                      STIMXY.43
         XDA=XUS                                                                 STIMXY.44
         YDA=YUS                                                                 STIMXY.45
      ELSE IF (IMAP .EQ. 1) THEN                                                 STIMXY.46
         CALL MAPTRI(XUS,YUS,YDA,XDA)                                            STIMXY.47
      ELSE IF (IMAP .EQ. 2) THEN                                                 STIMXY.48
         XDA=SQRT(XUS*XUS+YUS*YUS)                                               STIMXY.49
         YDA=PRTOD*ATAN2(YUS,XUS)                                                STIMXY.50
C                                                                                STIMXY.51
C POLAR MAPPING HAS SPECIAL BOUNDS CHECKING REQUIREMENTS.                        STIMXY.52
C IF YDA IS LESS THAN YLOV, IT IS POSSIBLE THE USER INTENDS                      STIMXY.53
C TO TREAT SOME OR ALL OF QUANDRANT 3 AND 4 AS POSITIVE ANGLES                   STIMXY.54
C (UNLIKE ATAN2). ADD 360 IN THIS CASE.                                          STIMXY.55
C                                                                                STIMXY.56
         IF (YDA.LT.YLOV) YDA=YDA+360.0                                          STIMXY.57
C                                                                                STIMXY.58
      ELSE                                                                       STIMXY.59
         CALL STUIXY(XUS,YUS,XDA,YDA,IST)                                        STIMXY.60
      END IF                                                                     STIMXY.61
C                                                                                STIMXY.62
      IF (XDA.LT.XLOV .OR. XDA.GT.XHIV                                           STIMXY.63
     +     .OR. YDA.LT.YLOV .OR. YDA.GT.YHIV) THEN                               STIMXY.64
         IST=-1                                                                  STIMXY.65
      END IF                                                                     STIMXY.66
C                                                                                STIMXY.67
C DONE                                                                           STIMXY.68
C                                                                                STIMXY.69
      RETURN                                                                     STIMXY.70
      END                                                                        STIMXY.71
