C                                                                                STINIT.1
C --------------------------------------------------------------------           STINIT.2
C ORIGINAL DISUCUSSION OF THE STRMLN ALGORITHM FOLLOWS:                          STINIT.3
C                                                                                STINIT.4
C HISTORY                WRITTEN AND STANDARDIZED IN NOVEMBER 1973.              STINIT.5
C                                                                                STINIT.6
C                        CONVERTED TO FORTRAN 77 AND GKS IN JUNE, 1984.          STINIT.7
C                                                                                STINIT.8
C                                                                                STINIT.9
C PORTABILITY            FORTRAN 77                                              STINIT.10
C                                                                                STINIT.11
C ALGORITHM              WIND COMPONENTS ARE NORMALIZED TO THE VALUE             STINIT.12
C                        OF DISPL. THE LEAST SIGNIFICANT TWO                     STINIT.13
C                        BITS OF THE WORK ARRAY ARE                              STINIT.14
C                        UTILIZED AS FLAGS FOR EACH GRID BOX. FLAG 1             STINIT.15
C                        INDICATES WHETHER ANY STREAMLINE HAS                    STINIT.16
C                        PREVIOUSLY PASSED THROUGH THIS BOX.  FLAG 2             STINIT.17
C                        INDICATES WHETHER A DIRECTIONAL ARROW HAS               STINIT.18
C                        ALREADY APPEARED IN A BOX. JUDICIOUS USE                STINIT.19
C                        OF THESE FLAGS PREVENTS OVERCROWDING OF                 STINIT.20
C                        STREAMLINES AND DIRECTIONAL ARROWS.                     STINIT.21
C                        EXPERIENCE INDICATES THAT A FINAL PLEASING              STINIT.22
C                        PICTURE IS PRODUCED WHEN STREAMLINES ARE                STINIT.23
C                        INITIATED IN THE CENTER OF A GRID BOX. THE              STINIT.24
C                        STREAMLINES ARE DRAWN IN ONE DIRECTION THEN             STINIT.25
C                        IN THE OPPOSITE DIRECTION.                              STINIT.26
C                                                                                STINIT.27
C REFERENCE              THE TECHNIQUES UTILIZED HERE ARE DESCRIBED              STINIT.28
C                        IN AN ARTICLE BY THOMAS WHITTAKER (U. OF                STINIT.29
C                        WISCONSIN) WHICH APPEARED IN THE NOTES AND              STINIT.30
C                        CORRESPONDENCE SECTION OF MONTHLY WEATHER               STINIT.31
C                        REVIEW, JUNE 1977.                                      STINIT.32
C                                                                                STINIT.33
C TIMING                 HIGHLY VARIABLE                                         STINIT.34
C                          IT DEPENDS ON THE COMPLEXITY OF THE                   STINIT.35
C                          FLOW FIELD AND THE PARAMETERS:  DISPL,                STINIT.36
C                          DISPC , CSTOP , INITA , INITB , ITERC ,               STINIT.37
C                          AND IGFLG. (SEE BELOW FOR A DISCUSSION                STINIT.38
C                          OF THESE PARAMETERS.) IF ALL VALUES                   STINIT.39
C                          ARE DEFAULT, THEN A SIMPLE LINEAR                     STINIT.40
C                          FLOW FIELD FOR A 40 X 40 GRID WILL                    STINIT.41
C                          TAKE ABOUT 0.4 SECONDS ON THE CRAY1-A;                STINIT.42
C                          A FAIRLY COMPLEX FLOW FIELD WILL TAKE ABOUT           STINIT.43
C                          1.5 SECONDS ON THE CRAY1-A.                           STINIT.44
C                                                                                STINIT.45
C                                                                                STINIT.46
C INTERNAL PARAMETERS                                                            STINIT.47
C                                                                                STINIT.48
C                        NAME     DEFAULT         FUNCTION                       STINIT.49
C                        ----     -------         --------                       STINIT.50
C                                                                                STINIT.51
C                        EXT       0.25   LENGTHS OF THE SIDES OF THE            STINIT.52
C                                         PLOT ARE PROPORTIONAL TO               STINIT.53
C                                         IPTSX AND JPTSY EXCEPT IN              STINIT.54
C                                         THE CASE WHEN MIN(IPTSX,JPT)           STINIT.55
C                                         / MAX(IPTSX,JPTSY) .LT. EXT;           STINIT.56
C                                         IN THAT CASE A SQUARE                  STINIT.57
C                                         GRAPH IS PLOTTED.                      STINIT.58
C                                                                                STINIT.59
C                        SIDE      0.90   LENGTH OF LONGER EDGE OF               STINIT.60
C                                         PLOT. (SEE ALSO EXT.)                  STINIT.61
C                                                                                STINIT.62
C                        XLT       0.05   LEFT HAND EDGE OF THE PLOT.            STINIT.63
C                                         (0.0 = LEFT EDGE OF FRAME)             STINIT.64
C                                         (1.0 = RIGHT EDGE OF FRAME)            STINIT.65
C                                                                                STINIT.66
C                        YBT       0.05   BOTTOM EDGE OF THE PLOT.               STINIT.67
C                                         (0.0 = BOTTOM ; 1.0 = TOP)             STINIT.68
C                                                                                STINIT.69
C                                         (YBT+SIDE AND XLT+SIDE MUST            STINIT.70
C                                         BE .LE. 1. )                           STINIT.71
C                                                                                STINIT.72
C                        INITA     2      USED TO PRECONDITION GRID              STINIT.73
C                                         BOXES TO BE ELIGIBLE TO                STINIT.74
C                                         START A STREAMLINE.                    STINIT.75
C                                         FOR EXAMPLE, A VALUE OF 4              STINIT.76
C                                         MEANS THAT EVERY FOURTH                STINIT.77
C                                         GRID BOX IS ELIGIBLE ; A               STINIT.78
C                                         VALUE OF 2 MEANS THAT EVERY            STINIT.79
C                                         OTHER GRID BOX IS ELIGIBLE.            STINIT.80
C                                         (SEE INITB)                            STINIT.81
C                                                                                STINIT.82
C                        INITB     2      USED TO PRECONDITION GRID              STINIT.83
C                                         BOXES TO BE ELIGIBLE FOR               STINIT.84
C                                         DIRECTION ARROWS.                      STINIT.85
C                                         IF THE USER CHANGES THE                STINIT.86
C                                         DEFAULT VALUES OF INITA                STINIT.87
C                                         AND/OR INITB, IT SHOULD                STINIT.88
C                                         BE DONE SUCH THAT                      STINIT.89
C                                         MOD(INITA,INITB) = 0 .                 STINIT.90
C                                         FOR A DENSE GRID TRY                   STINIT.91
C                                         INITA=4 AND INITB=2 TO                 STINIT.92
C                                         REDUCE THE CPU TIME.                   STINIT.93
C                                                                                STINIT.94
C                        AROWL     0.33   LENGTH OF DIRECTION ARROW.             STINIT.95
C                                         FOR EXAMPLE, 0.33 MEANS                STINIT.96
C                                         EACH DIRECTIONAL ARROW WILL            STINIT.97
C                                         TAKE UP A THIRD OF A GRID              STINIT.98
C                                         BOX.                                   STINIT.99
C                                                                                STINIT.100
C                        ITERP     35     EVERY 'ITERP' ITERATIONS               STINIT.101
C                                         THE STREAMLINE PROGRESS                STINIT.102
C                                         IS CHECKED.                            STINIT.103
C                                                                                STINIT.104
C                        ITERC     -99    THE DEFAULT VALUE OF THIS              STINIT.105
C                                         PARAMETER IS SUCH THAT                 STINIT.106
C                                         IT HAS NO EFFECT ON THE                STINIT.107
C                                         CODE. WHEN SET TO SOME                 STINIT.108
C                                         POSITIVE VALUE, THE PROGRAM            STINIT.109
C                                         WILL CHECK FOR STREAMLINE              STINIT.110
C                                         CROSSOVER EVERY 'ITERC'                STINIT.111
C                                         ITERATIONS. (THE ROUTINE               STINIT.112
C                                         CURRENTLY DOES THIS EVERY              STINIT.113
C                                         TIME IT ENTERS A NEW GRID              STINIT.114
C                                         BOX.)                                  STINIT.115
C                                         CAUTION:  WHEN THIS                    STINIT.116
C                                         PARAMETER IS ACTIVATED,                STINIT.117
C                                         CPU TIME WILL INCREASE.                STINIT.118
C                                                                                STINIT.119
C                        IGFLG     0      A VALUE OF ZERO MEANS THAT             STINIT.120
C                                         THE SIXTEEN POINT BESSEL               STINIT.121
C                                         INTERPOLATION FORMULA WILL             STINIT.122
C                                         BE UTILIZED WHERE POSSIBLE;            STINIT.123
C                                         WHEN NEAR THE GRID EDGES,              STINIT.124
C                                         QUADRATIC AND BI-LINEAR                STINIT.125
C                                         INTERPOLATION  WILL BE                 STINIT.126
C                                         USED. THIS MIXING OF                   STINIT.127
C                                         INTERPOLATION SCHEMES CAN              STINIT.128
C                                         SOMETIMES CAUSE SLIGHT                 STINIT.129
C                                         RAGGEDNESS NEAR THE EDGES              STINIT.130
C                                         OF THE PLOT.  IF IGFLG.NE.0,           STINIT.131
C                                         THEN ONLY THE BILINEAR                 STINIT.132
C                                         INTERPOLATION FORMULA                  STINIT.133
C                                         IS USED; THIS WILL GENERALLY           STINIT.134
C                                         RESULT IN SLIGHTLY FASTER              STINIT.135
C                                         PLOT TIMES BUT A LESS                  STINIT.136
C                                         PLEASING PLOT.                         STINIT.137
C                                                                                STINIT.138
C                        IMSG      0      IF ZERO, THEN NO MISSING               STINIT.139
C                                         U AND V COMPONENTS ARE                 STINIT.140
C                                         PRESENT.                               STINIT.141
C                                         IF .NE. 0, STRMLN WILL                 STINIT.142
C                                         UTILIZE THE                            STINIT.143
C                                         BI-LINEAR INTERPOLATION                STINIT.144
C                                         SCHEME AND TERMINATE IF                STINIT.145
C                                         ANY DATA POINTS ARE MISSING.           STINIT.146
C                                                                                STINIT.147
C                        UVMSG     1.E+36 VALUE ASSIGNED TO A MISSING            STINIT.148
C                                         POINT.                                 STINIT.149
C                                                                                STINIT.150
C                        ICYC      0      ZERO MEANS THE DATA ARE                STINIT.151
C                                         NON-CYCLIC IN THE X                    STINIT.152
C                                         DIRECTION.                             STINIT.153
C                                         IF .NE 0, THE                          STINIT.154
C                                         CYCLIC INTERPOLATION                   STINIT.155
C                                         FORMULAS WILL BE USED.                 STINIT.156
C                                         (NOTE:  EVEN IF THE DATA               STINIT.157
C                                         ARE CYCLIC IN X, LEAVING               STINIT.158
C                                         ICYC = 0 WILL DO NO HARM.)             STINIT.159
C                                                                                STINIT.160
C                        DISPL     0.33   THE WIND SPEED IS                      STINIT.161
C                                         NORMALIZED TO THIS VALUE.              STINIT.162
C                                         (SEE THE DISCUSSION BELOW.)            STINIT.163
C                                                                                STINIT.164
C                        DISPC     0.67   THE CRITICAL DISPLACEMENT.             STINIT.165
C                                         IF AFTER 'ITERP' ITERATIONS            STINIT.166
C                                         THE STREAMLINE HAS NOT                 STINIT.167
C                                         MOVED THIS DISTANCE, THE               STINIT.168
C                                         STREAMLINE WILL BE                     STINIT.169
C                                         TERMINATED.                            STINIT.170
C                                                                                STINIT.171
C                        CSTOP     0.50   THIS PARAMETER CONTROLS                STINIT.172
C                                         THE SPACING BETWEEN                    STINIT.173
C                                         STREAMLINES.  THE CHECKING             STINIT.174
C                                         IS DONE WHEN A NEW GRID                STINIT.175
C                                         BOX IS ENTERED.                        STINIT.176
C                                                                                STINIT.177
C DISCUSSION OF          ASSUME A VALUE OF 0.33 FOR DISPL.  THIS                 STINIT.178
C DISPL,DISPC            MEANS THAT IT WILL TAKE THREE STEPS TO MOVE             STINIT.179
C AND CSTOP              ACROSS ONE GRID BOX IF THE FLOW WAS ALL IN THE          STINIT.180
C                        X DIRECTION. IF THE FLOW IS ZONAL, THEN A               STINIT.181
C                        LARGER VALUE OF DISPL IS IN ORDER.                      STINIT.182
C                        IF THE FLOW IS HIGHLY TURBULENT, THEN                   STINIT.183
C                        A SMALLER VALUE IS IN ORDER.  THE SMALLER               STINIT.184
C                        DISPL, THE MORE THE CPU TIME.  A VALUE                  STINIT.185
C                        OF 2 TO 4 TIMES DISPL IS A REASONABLE VALUE             STINIT.186
C                        FOR DISPC.  DISPC SHOULD ALWAYS BE GREATER              STINIT.187
C                        THAN DISPL. A VALUE OF 0.33 FOR CSTOP WOULD             STINIT.188
C                        MEAN THAT A MAXIMUM OF THREE STREAM-                    STINIT.189
C                        LINES WILL BE DRAWN PER GRID BOX. THIS MAX              STINIT.190
C                        WILL NORMALLY ONLY OCCUR IN AREAS OF SINGULAR           STINIT.191
C                        POINTS.                                                 STINIT.192
C                                                                                STINIT.193
C                                            ***************************         STINIT.194
C                                            ANY OR ALL OF THE ABOVE             STINIT.195
C                                            PARAMETERS MAY BE CHANGED           STINIT.196
C                                            BY UTILIZING COMMON BLOCKS          STINIT.197
C                                            STR02 AND/OR STR03                  STINIT.198
C                                            ***************************         STINIT.199
C                                                                                STINIT.200
C                        UXSML               A NUMBER WHICH IS SMALL             STINIT.201
C                                            COMPARED TO THE AVERAGE             STINIT.202
C                                            NORMALIZED U COMPONENT.             STINIT.203
C                                            SET AUTOMATICALLY.                  STINIT.204
C                                                                                STINIT.205
C                        NCHK      750       THIS PARAMETER IS LOCATED           STINIT.206
C                                            IN STDRAW. IT SPECIFIES THE         STINIT.207
C                                            LENGTH OF THE CIRCULAR              STINIT.208
C                                            LISTS  USED FOR CHECKING            STINIT.209
C                                            FOR STRMLN CROSSOVERS.              STINIT.210
C                                            FOR MOST PLOTS THIS NUMBER          STINIT.211
C                                            MAY BE REDUCED TO 500               STINIT.212
C                                            OR LESS AND THE PLOTS WILL          STINIT.213
C                                            NOT BE ALTERED.                     STINIT.214
C                                                                                STINIT.215
C                        ISKIP               NUMBER OF BITS TO BE                STINIT.216
C                                            SKIPPED TO GET TO THE               STINIT.217
C                                            LEAST TWO SIGNIFICANT BITS          STINIT.218
C                                            IN A FLOATING POINT NUMBER.         STINIT.219
C                                            THE DEFAULT VALUE IS SET TO         STINIT.220
C                                            I1MACH(5) - 2 . THIS VALUE          STINIT.221
C                                            MAY HAVE TO BE CHANGED              STINIT.222
C                                            DEPENDING ON THE TARGET             STINIT.223
C                                            COMPUTER; SEE SUBROUTINE            STINIT.224
C                                            STDRAW.                             STINIT.225
C                                                                                STINIT.226
C --------------------------------------------------------------------           STINIT.227
C                                                                                STINIT.228
C	$ID: STINIT.F,V 2.0 1997/01/11 20:33:39 MESOUSER EXP $                         STINIT.229
C                                                                                STINIT.230
C-----------------------------------------------------------------------         STINIT.231
C                                                                                STINIT.232
      SUBROUTINE STINIT (U,LU,V,LV,P,LP,M,N,WRK,LW)                              STINIT.233
C                                                                                STINIT.234
C ARGUMENT DIMENSIONS.                                                           STINIT.235
C                                                                                STINIT.236
      DIMENSION       U(LU,N)    ,V(LV,N)    ,P(LP,N)                            STINIT.237
      DIMENSION       WRK(LW)                                                    STINIT.238
C                                                                                STINIT.239
C INPUT PARAMETERS                                                               STINIT.240
C                                                                                STINIT.241
C U,V   - 2-D ARRAYS HOLDING THE COMPONENT VALUES OF A VECTOR FIELD              STINIT.242
C LU,LV - THE FIRST DIMENSIONS OF THE U AND V ARRAYS, RESPECTIVELY               STINIT.243
C ----------------                                                               STINIT.244
C P     - A 2-D ARRAY CONTAINING A SCALAR DATA FIELD. THE CONTENTS               STINIT.245
C         OF THIS ARRAY MAY BE USED TO COLOR THE STREAMLINES.                    STINIT.246
C LP    - THE FIRST DIMENSION OF THE P ARRAY                                     STINIT.247
C NOTE:                                                                          STINIT.248
C COLORING BY MEANS OF THE P SCALAR DATA FIELD IS NOT YET                        STINIT.249
C IMPLEMENTED                                                                    STINIT.250
C ----------------                                                               STINIT.251
C M     - THE FIRST DATA DIMENSION (MUST BE LESS THAN OR EQUAL TO                STINIT.252
C         MIN(LU,LV) (OR MIN(LU,LV,LP) IF THE P ARRAY IS USED                    STINIT.253
C WRK   - AN INTERNALLY USED WORK ARRAY                                          STINIT.254
C LW    - DIMENSION OF THE WORK ARRAY (MUST BE AT LEAST 2*M*N)                   STINIT.255
C                                                                                STINIT.256
C OUTPUT PARAMETERS:                                                             STINIT.257
C                                                                                STINIT.258
C NONE                                                                           STINIT.259
C                                                                                STINIT.260
C ---------------------------------------------------------------------          STINIT.261
C                                                                                STINIT.262
C NOTE:                                                                          STINIT.263
C SINCE IMPLICIT TYPING IS USED FOR ALL REAL AND INTEGER VARIABLES               STINIT.264
C A CONSISTENT LENGTH CONVENTION HAS BEEN ADOPTED TO HELP CLARIFY THE            STINIT.265
C SIGNIFICANCE OF THE VARIABLES ENCOUNTERED IN THE CODE FOR THIS                 STINIT.266
C UTILITY. ALL LOCAL VARIABLE AND SUBROUTINE PARAMETER IDENTIFIERS               STINIT.267
C ARE LIMITED TO 1,2,OR 3 CHARACTERS. FOUR CHARACTER NAMES IDENTIFY              STINIT.268
C MEMBERS OF COMMON BLOCKS. FIVE AND 6 CHARACTER VARIABLE NAMES                  STINIT.269
C DENOTE PARAMETER CONSTANTS OR SUBROUTINE OR FUNCTION NAMES.                    STINIT.270
C                                                                                STINIT.271
C DECLARE THE ST COMMON BLOCKS.                                                  STINIT.272
C                                                                                STINIT.273
      PARAMETER (IPLVLS = 64)                                                    STINIT.274
C                                                                                STINIT.275
C INTEGER AND REAL COMMON BLOCK VARIABLES                                        STINIT.276
C                                                                                STINIT.277
C                                                                                STINIT.278
      COMMON / STPAR /                                                           STINIT.279
     +                IUD1       ,IVD1       ,IPD1       ,                       STINIT.280
     +                IXD1       ,IXDM       ,IYD1       ,IYDN       ,           STINIT.281
     +                IXM1       ,IYM1       ,IXM2       ,IYM2       ,           STINIT.282
     +                IWKD       ,IWKU       ,ISET       ,IERR       ,           STINIT.283
     +	              IXIN       ,IYIN       ,IMSK       ,ICPM       ,            STINIT.284
     +                NLVL       ,IPAI       ,ICTV       ,WDLV       ,           STINIT.285
     +                UVMN       ,UVMX       ,PMIN       ,PMAX       ,           STINIT.286
     +                ITHN       ,IPLR       ,ISST       ,                       STINIT.287
     +                ICLR(IPLVLS)           ,TVLU(IPLVLS)                       STINIT.288
C                                                                                STINIT.289
      COMMON / STTRAN /                                                          STINIT.290
     +                UVPS       ,                                               STINIT.291
     +                UVPL       ,UVPR       ,UVPB       ,UVPT       ,           STINIT.292
     +                UWDL       ,UWDR       ,UWDB       ,UWDT       ,           STINIT.293
     +                UXC1       ,UXCM       ,UYC1       ,UYCN                   STINIT.294
C                                                                                STINIT.295
C STREAM ALGORITHM PARAMETERS                                                    STINIT.296
C                                                                                STINIT.297
      COMMON / STSTRM /                                                          STINIT.298
     +                ISGD       ,IAGD       ,RARL       ,ICKP       ,           STINIT.299
     +                ICKX       ,ITRP       ,ICYK       ,RVNL       ,           STINIT.300
     +                ISVF       ,RUSV       ,RVSV       ,RNDA       ,           STINIT.301
     +                ISPC       ,RPSV       ,RCDS       ,RSSP       ,           STINIT.302
     +                RDFM                                                       STINIT.303
C                                                                                STINIT.304
C TEXT RELATED PARAMETERS                                                        STINIT.305
C NOTE: GRAPHICAL TEXT OUTPUT IS NOT YET IMPLEMENTED FOR THE                     STINIT.306
C       STREAMLINE UTILITY.                                                      STINIT.307
C                                                                                STINIT.308
      COMMON / STTXP /                                                           STINIT.309
     +                FCWM    ,ICSZ    ,                                         STINIT.310
     +                FMNS    ,FMNX    ,FMNY    ,IMNP    ,IMNC  ,                STINIT.311
     +                FMXS    ,FMXX    ,FMXY    ,IMXP    ,IMXC  ,                STINIT.312
     +                FZFS    ,FZFX    ,FZFY    ,IZFP    ,IZFC  ,                STINIT.313
     +                FILS    ,FILX    ,FILY    ,IILP    ,IILC                   STINIT.314
C                                                                                STINIT.315
C CHARACTER VARIABLE DECLARTIONS                                                 STINIT.316
C                                                                                STINIT.317
      CHARACTER*160 CSTR                                                         STINIT.318
      PARAMETER (IPCHSZ=80)                                                      STINIT.319
      CHARACTER*(IPCHSZ)  CMNT,CMXT,CZFT,CILT                                    STINIT.320
C                                                                                STINIT.321
C TEXT STRING PARAMETERS                                                         STINIT.322
C                                                                                STINIT.323
      COMMON / STCHAR / CSTR,CMNT,CMXT,CZFT,CILT                                 STINIT.324
C                                                                                STINIT.325
      SAVE /STPAR/, /STTRAN/, /STSTRM/, /STTXP/, /STCHAR/                        STINIT.326
C                                                                                STINIT.327
C INTERNAL BUFFER LENGTHS                                                        STINIT.328
C                                                                                STINIT.329
C IPNPTS - NUMBER OF POINTS IN THE POINT BUFFER -- NOT LESS THAN 3               STINIT.330
C IPLSTL - STREAMLINE-CROSSOVER-CHECK CIRCULAR LIST LENGTH                       STINIT.331
C IPGRCT - NUMBER OF GROUPS SUPPORTED FOR AREA MASKING                           STINIT.332
C                                                                                STINIT.333
      PARAMETER (IPNPTS = 10, IPLSTL = 750, IPGRCT = 64)                         STINIT.334
C                                                                                STINIT.335
C THE MAPPING COMMON BLOCK: MADE AVAILABLE TO USER MAPPING ROUTINES              STINIT.336
C                                                                                STINIT.337
      COMMON /STMAP/                                                             STINIT.338
     +                IMAP       ,LNLG       ,INVX       ,INVY       ,           STINIT.339
     +                XLOV       ,XHIV       ,YLOV       ,YHIV       ,           STINIT.340
     +                WXMN       ,WXMX       ,WYMN       ,WYMX       ,           STINIT.341
     +                XVPL       ,XVPR       ,YVPB       ,YVPT       ,           STINIT.342
     +                XGDS       ,YGDS       ,NXCT       ,NYCT       ,           STINIT.343
     +                ITRT       ,FW2W       ,FH2H       ,                       STINIT.344
     +                DFMG       ,VNML       ,RBIG       ,IBIG                   STINIT.345
C                                                                                STINIT.346
      SAVE /STMAP/                                                               STINIT.347
C                                                                                STINIT.348
C MATH CONSTANTS                                                                 STINIT.349
C                                                                                STINIT.350
      PARAMETER (PDTOR  = 0.017453292519943,                                     STINIT.351
     +           PRTOD  = 57.2957795130823,                                      STINIT.352
     +           P1XPI  = 3.14159265358979,                                      STINIT.353
     +           P2XPI  = 6.28318530717959,                                      STINIT.354
     +           P1D2PI = 1.57079632679489,                                      STINIT.355
     +           P5D2PI = 7.85398163397448)                                      STINIT.356
C                                                                                STINIT.357
C --------------------------------------------------------------------           STINIT.358
C                                                                                STINIT.359
C FORCE THE BLOCK DATA ROUTINE, WHICH SETS DEFAULT VARIABLES, TO LOAD.           STINIT.360
C                                                                                STINIT.361
      EXTERNAL STDATA                                                            STINIT.362
C                                                                                STINIT.363
C ---------------------------------------------------------------------          STINIT.364
C                                                                                STINIT.365
C WRITE THE ARRAY SIZES INTO THE COMMON BLOCK                                    STINIT.366
C                                                                                STINIT.367
      IUD1=LU                                                                    STINIT.368
      IVD1=LV                                                                    STINIT.369
      IPD1=LP                                                                    STINIT.370
      IWKD=LW                                                                    STINIT.371
C                                                                                STINIT.372
C ERROR IF M > LU OR M > LV?                                                     STINIT.373
C                                                                                STINIT.374
      IF (LU.LT.M .OR. LV.LT.M) THEN                                             STINIT.375
         CSTR(1:45)='STINIT - U AND/OR V ARRAY DIMENSIONS EXCEEDED'              STINIT.376
         CALL SETER (CSTR(1:45),1,2)                                             STINIT.377
         STOP                                                                    STINIT.378
      END IF                                                                     STINIT.379
      IXDM=MIN(M,LU,LV)                                                          STINIT.380
      IYDN=N                                                                     STINIT.381
      IXD1=1                                                                     STINIT.382
      IYD1=1                                                                     STINIT.383
      IXM1=IXDM-1                                                                STINIT.384
      IXM2=IXDM-2                                                                STINIT.385
      IYM1=IYDN-1                                                                STINIT.386
      IYM2=IYDN-2                                                                STINIT.387
      IF (LW .LT. 2*IXDM*IYDN) THEN                                              STINIT.388
         CSTR(1:37)='STINIT - WRK ARRAY DIMENSION EXCEEDED'                      STINIT.389
         CALL SETER (CSTR(1:37),2,2)                                             STINIT.390
         STOP                                                                    STINIT.391
      END IF                                                                     STINIT.392
C                                                                                STINIT.393
C INITIALIZE AND TRANSFER SOME ARGUMENTS TO LOCAL VARIABLES.                     STINIT.394
C                                                                                STINIT.395
      IBIG = I1MACH(9)                                                           STINIT.396
      RBIG = R1MACH(2)                                                           STINIT.397
C                                                                                STINIT.398
C DECIDE WHAT THE RANGE OF VALUES IN X AND Y SHOULD BE.                          STINIT.399
C                                                                                STINIT.400
      IF (UXC1.EQ.UXCM) THEN                                                     STINIT.401
        XLOV=1.                                                                  STINIT.402
        XHIV=REAL(IXDM)                                                          STINIT.403
      ELSE                                                                       STINIT.404
        XLOV=UXC1                                                                STINIT.405
        XHIV=UXCM                                                                STINIT.406
      END IF                                                                     STINIT.407
C                                                                                STINIT.408
      IF (UYC1.EQ.UYCN) THEN                                                     STINIT.409
        YLOV=1.                                                                  STINIT.410
        YHIV=REAL(IYDN)                                                          STINIT.411
      ELSE                                                                       STINIT.412
        YLOV=UYC1                                                                STINIT.413
        YHIV=UYCN                                                                STINIT.414
      END IF                                                                     STINIT.415
C                                                                                STINIT.416
      IXIN = MAX(IXIN,1)                                                         STINIT.417
      IYIN = MAX(IYIN,1)                                                         STINIT.418
C                                                                                STINIT.419
      NXCT = IXDM/IXIN                                                           STINIT.420
      NYCT = IYDN/IYIN                                                           STINIT.421
C                                                                                STINIT.422
C IF THE USER HAS DONE A SET CALL, RETRIEVE THE ARGUMENTS; IF HE HASN'T          STINIT.423
C DONE A SET CALL, DO IT FOR HIM.                                                STINIT.424
C                                                                                STINIT.425
      IF (ISET .EQ .0) THEN                                                      STINIT.426
C                                                                                STINIT.427
        CALL GETSET (XVPL,XVPR,YVPB,YVPT,WXMN,WXMX,WYMN,WYMX,LNLG)               STINIT.428
C                                                                                STINIT.429
      ELSE                                                                       STINIT.430
C                                                                                STINIT.431
        LNLG=1                                                                   STINIT.432
C                                                                                STINIT.433
        IF (UWDL.EQ.UWDR) THEN                                                   STINIT.434
          WXMN=XLOV                                                              STINIT.435
          WXMX=XHIV                                                              STINIT.436
        ELSE                                                                     STINIT.437
          WXMN=UWDL                                                              STINIT.438
          WXMX=UWDR                                                              STINIT.439
        END IF                                                                   STINIT.440
C                                                                                STINIT.441
        IF (UWDB.EQ.UWDT) THEN                                                   STINIT.442
          WYMN=YLOV                                                              STINIT.443
          WYMX=YHIV                                                              STINIT.444
        ELSE                                                                     STINIT.445
          WYMN=UWDB                                                              STINIT.446
          WYMX=UWDT                                                              STINIT.447
        END IF                                                                   STINIT.448
C                                                                                STINIT.449
C DETERMINE THE VIEWPORT BASED ON THE SETTING OF THE VIEWPORT                    STINIT.450
C SHAPE AND VIEWPORT EXTENT PARAMETERS                                           STINIT.451
C                                                                                STINIT.452
        IF (UVPS.LT.0.) THEN                                                     STINIT.453
          AR=ABS(UVPS)                                                           STINIT.454
        ELSE IF (UVPS.EQ.0.) THEN                                                STINIT.455
          AR=(UVPR-UVPL)/(UVPT-UVPB)                                             STINIT.456
        ELSE IF (UVPS.LE.1.) THEN                                                STINIT.457
          AR=ABS((WXMX-WXMN)/(WYMX-WYMN))                                        STINIT.458
          IF (MIN(AR,1./AR).LT.UVPS) AR=(UVPR-UVPL)/(UVPT-UVPB)                  STINIT.459
        ELSE                                                                     STINIT.460
          AR=ABS((WXMX-WXMN)/(WYMX-WYMN))                                        STINIT.461
          IF (MAX(AR,1./AR).GT.UVPS) AR=1.                                       STINIT.462
        END IF                                                                   STINIT.463
C                                                                                STINIT.464
        IF (AR.LT.(UVPR-UVPL)/(UVPT-UVPB)) THEN                                  STINIT.465
          XVPL=.5*(UVPL+UVPR)-.5*(UVPT-UVPB)*AR                                  STINIT.466
          XVPR=.5*(UVPL+UVPR)+.5*(UVPT-UVPB)*AR                                  STINIT.467
          YVPB=UVPB                                                              STINIT.468
          YVPT=UVPT                                                              STINIT.469
        ELSE                                                                     STINIT.470
          XVPL=UVPL                                                              STINIT.471
          XVPR=UVPR                                                              STINIT.472
          YVPB=.5*(UVPB+UVPT)-.5*(UVPR-UVPL)/AR                                  STINIT.473
          YVPT=.5*(UVPB+UVPT)+.5*(UVPR-UVPL)/AR                                  STINIT.474
        END IF                                                                   STINIT.475
C                                                                                STINIT.476
        CALL SET (XVPL,XVPR,YVPB,YVPT,WXMN,WXMX,WYMN,WYMX,LNLG)                  STINIT.477
C                                                                                STINIT.478
      END IF                                                                     STINIT.479
C                                                                                STINIT.480
C CALCULATE FRACTION OF VP WIDTH TO FRACTIONAL SIZE FACTOR.                      STINIT.481
C CALCULATE FRACTION OF VP HEIGHT TO FRACTIONAL SIZE FACTOR.                     STINIT.482
C THESE ARE FOR CONVENIENCE.                                                     STINIT.483
C                                                                                STINIT.484
      FW2W = XVPR - XVPL                                                         STINIT.485
      FH2H = YVPT - YVPB                                                         STINIT.486
C                                                                                STINIT.487
C SWAP WINDOW RECTANGLE IF IT IS INVERTED, BUT KEEP TRACK                        STINIT.488
C THIS MAKES IT EASIER TO EXCLUDE OUT-OF-BOUNDS POINTS IN THE                    STINIT.489
C PROJECTION MAPPING ROUTINES                                                    STINIT.490
C                                                                                STINIT.491
      INVX=0                                                                     STINIT.492
      INVY=0                                                                     STINIT.493
      IF (WXMN .GT. WXMX) THEN                                                   STINIT.494
         T=WXMN                                                                  STINIT.495
         WXMN=WXMX                                                               STINIT.496
         WXMX=T                                                                  STINIT.497
         INVX=1                                                                  STINIT.498
      END IF                                                                     STINIT.499
      IF (WYMN .GT. WYMX) THEN                                                   STINIT.500
         T=WYMN                                                                  STINIT.501
         WYMN=WYMX                                                               STINIT.502
         WYMX=T                                                                  STINIT.503
         INVY=1                                                                  STINIT.504
      END IF                                                                     STINIT.505
C                                                                                STINIT.506
C IF CYCLIC DATA SPECIFIED CHECK TO ENSURE THE CYCLIC CONDITION EXISTS.          STINIT.507
C THE ERROR FLAG IS SET IF NECESSARY WITHIN STCYCL                               STINIT.508
C                                                                                STINIT.509
      IF (ICYK.NE.0) CALL STCYCL(U,V)                                            STINIT.510
C                                                                                STINIT.511
C CALCULATE THE GRID SIZE AND A THE NDC ARROW LENGTH                             STINIT.512
C FROM THE FRACTION OF VIEWPORT ARROW SIZE PARAMETER                             STINIT.513
C                                                                                STINIT.514
      XGDS=(XHIV-XLOV)/(REAL(NXCT)-1.0)                                          STINIT.515
      YGDS=(YHIV-YLOV)/(REAL(NYCT)-1.0)                                          STINIT.516
      RNDA=FW2W*RARL                                                             STINIT.517
C                                                                                STINIT.518
C DONE.                                                                          STINIT.519
C                                                                                STINIT.520
      RETURN                                                                     STINIT.521
C                                                                                STINIT.522
      END                                                                        STINIT.523
