C                                                                                STMPTA.1
      SUBROUTINE STMPTA(XDA,YDA,XUS,YUS,XND,YND,DU,DV,TA,IST)                    STMPTA.2
C                                                                                STMPTA.3
C MAP TANGENT ANGLE TO NORMALIZED DEVICE COORDINATE SPACE.                       STMPTA.4
C                                                                                STMPTA.5
C INPUT PARAMETERS:                                                              STMPTA.6
C                                                                                STMPTA.7
C XDA,YDA - POINT IN DATA COORDINATE SPACE                                       STMPTA.8
C XUS,YUS - POINT IN USER COORDINATE SPACE                                       STMPTA.9
C XND,YND - POINT IN NDC SPACE                                                   STMPTA.10
C DU,DV   - DIFFERENTIAL VECTOR COMPONENTS IN DATA SPACE                         STMPTA.11
C                                                                                STMPTA.12
C OUTPUT PARAMETERS:                                                             STMPTA.13
C                                                                                STMPTA.14
C TA      - STREAMLINE TANGENT ANGLE IN NDC SPACE                                STMPTA.15
C IST     - STATUS CODE INDICATING SUCCESS OR FAILURE                            STMPTA.16
C                                                                                STMPTA.17
C IN GENERAL THE DISTANCE OVER WHICH THE ANGLE IS MEASURED IS                    STMPTA.18
C ITERATIVELY ADJUSTED UNTIL IT IS BECOMES A SMALL (BUT NOT TOO SMALL)           STMPTA.19
C FRACTION OF THE FIXED (IN NDC SPACE) INCREMENT DISTANCE.                       STMPTA.20
C THE TRANSFORMATION TYPE PARAMETER IS IMPLEMENTED FOR THE POLAR                 STMPTA.21
C MAPPING ONLY.                                                                  STMPTA.22
C                                                                                STMPTA.23
C                                                                                STMPTA.24
C THE MAPPING COMMON BLOCK: MADE AVAILABLE TO USER MAPPING ROUTINES              STMPTA.25
C                                                                                STMPTA.26
      COMMON /STMAP/                                                             STMPTA.27
     +                IMAP       ,LNLG       ,INVX       ,INVY       ,           STMPTA.28
     +                XLOV       ,XHIV       ,YLOV       ,YHIV       ,           STMPTA.29
     +                WXMN       ,WXMX       ,WYMN       ,WYMX       ,           STMPTA.30
     +                XVPL       ,XVPR       ,YVPB       ,YVPT       ,           STMPTA.31
     +                XGDS       ,YGDS       ,NXCT       ,NYCT       ,           STMPTA.32
     +                ITRT       ,FW2W       ,FH2H       ,                       STMPTA.33
     +                DFMG       ,VNML       ,RBIG       ,IBIG                   STMPTA.34
C                                                                                STMPTA.35
      SAVE /STMAP/                                                               STMPTA.36
C                                                                                STMPTA.37
C MATH CONSTANTS                                                                 STMPTA.38
C                                                                                STMPTA.39
      PARAMETER (PDTOR  = 0.017453292519943,                                     STMPTA.40
     +           PRTOD  = 57.2957795130823,                                      STMPTA.41
     +           P1XPI  = 3.14159265358979,                                      STMPTA.42
     +           P2XPI  = 6.28318530717959,                                      STMPTA.43
     +           P1D2PI = 1.57079632679489,                                      STMPTA.44
     +           P5D2PI = 7.85398163397448)                                      STMPTA.45
C                                                                                STMPTA.46
C --------------------------------------------------------------------           STMPTA.47
C                                                                                STMPTA.48
C ---------------------------------------------------------------------          STMPTA.49
C                                                                                STMPTA.50
C LOCAL PARAMETERS:                                                              STMPTA.51
C                                                                                STMPTA.52
C PRCFAC - PRECISION FACTOR USED TO RESOLVE FLOAT EQUALITY WITHIN                STMPTA.53
C            THE PRECISION OF A 4 BYTE REAL                                      STMPTA.54
C PVFRAC - INITIAL FRACTION OF THE VECTOR MAGNITUDE USED TO                      STMPTA.55
C            DETERMINE THE DIFFERENTIAL INCREMENT                                STMPTA.56
C IPMXCT - NUMBER OF TIMES TO ALLOW THE DIFFERENTIAL TO INCREASE                 STMPTA.57
C PDUVML - MULTIPLIER WHEN THE DIFFERENTIAL IS INCREASED                         STMPTA.58
C PCSTST - TEST VALUE FOR CLOSENESS TO 90 DEGREE LATITUDE                        STMPTA.59
C                                                                                STMPTA.60
      PARAMETER (PRCFAC=1E5,                                                     STMPTA.61
     +           PVFRAC=0.1,                                                     STMPTA.62
     +           IPMXCT=40,                                                      STMPTA.63
     +           PDUVML=2.0,                                                     STMPTA.64
     +           PCSTST=PRCFAC*90.0)                                             STMPTA.65
C                                                                                STMPTA.66
C LOCAL VARIABLES:                                                               STMPTA.67
C                                                                                STMPTA.68
C XE,YE   - CURRENT END OF THE TEMPORARY VECTOR                                  STMPTA.69
C DV1     - FIRST VECTOR MAGNITUDE                                               STMPTA.70
C SGN     - SIGN FACTOR APPLIED TO DIFFERENTIAL                                  STMPTA.71
C DUV     - INCREMENTAL MAGNITUDE MULTIPLIER                                     STMPTA.72
C ICT     - COUNT OF ITERATIONS                                                  STMPTA.73
C XT,YT   - TEMPORARY X,Y COORDINATES (USER SPACE)                               STMPTA.74
C XTF,YTF - TEMPORARY X,Y COORDINATES (NDC SPACE)                                STMPTA.75
C DV2     - SECOND VECTOR MAGNITUDE                                              STMPTA.76
C CLT     - COSINE OF THE LATITUDE                                               STMPTA.77
C DTX,DTY - DIFFENTIAL VALUES AFTER ACCOUNTING FOR THE LATITUDE                  STMPTA.78
C DNX,DNY - TRIAL INCREMENTAL VALUES                                             STMPTA.79
C TH      - ANGLE THETA                                                          STMPTA.80
C                                                                                STMPTA.81
C ---------------------------------------------------------------------          STMPTA.82
C                                                                                STMPTA.83
      IST=0                                                                      STMPTA.84
C                                                                                STMPTA.85
      IF (IMAP .EQ. 0) THEN                                                      STMPTA.86
C                                                                                STMPTA.87
         XE=XND+DU                                                               STMPTA.88
         YE=YND+DV                                                               STMPTA.89
C                                                                                STMPTA.90
C IF SPACE MAPPING THEN MORE CODE IS REQUIRED                                    STMPTA.91
C                                                                                STMPTA.92
         IF (ITRT.GE.1) THEN                                                     STMPTA.93
C                                                                                STMPTA.94
            DV1=SQRT((XE-XND)*(XE-XND)+(YE-YND)*(YE-YND))                        STMPTA.95
C                                                                                STMPTA.96
C SET UP AN INITIAL INCREMENT FACTOR                                             STMPTA.97
C                                                                                STMPTA.98
            DUV=PVFRAC/VNML                                                      STMPTA.99
            SGN=1.0                                                              STMPTA.100
            ICT=0                                                                STMPTA.101
C                                                                                STMPTA.102
 10         CONTINUE                                                             STMPTA.103
C                                                                                STMPTA.104
C BAIL OUT IF IT'S NOT WORKING                                                   STMPTA.105
C                                                                                STMPTA.106
            IF (ICT .GT. IPMXCT) THEN                                            STMPTA.107
               IST = -3                                                          STMPTA.108
               RETURN                                                            STMPTA.109
            END IF                                                               STMPTA.110
C                                                                                STMPTA.111
C CALCULATE THE INCREMENTAL END POINTS, THEN CHECK TO SEE IF                     STMPTA.112
C THEY TAKE US OUT OF THE USER COORDINATE BOUNDARIES. IF THEY                    STMPTA.113
C DO, TRY INCREMENTING IN THE OTHER DIRECTION                                    STMPTA.114
C                                                                                STMPTA.115
            XT=XUS+SGN*DU*DUV                                                    STMPTA.116
            YT=YUS+SGN*DV*DUV                                                    STMPTA.117
            IF (XT .LT. WXMN .OR. XT .GT. WXMX .OR.                              STMPTA.118
     +           YT .LT. WYMN .OR. YT .GT. WYMX) THEN                            STMPTA.119
               IF (SGN.EQ.1.0) THEN                                              STMPTA.120
                  SGN = -1.0                                                     STMPTA.121
                  GO TO 10                                                       STMPTA.122
               ELSE                                                              STMPTA.123
                  IST=-4                                                         STMPTA.124
                  RETURN                                                         STMPTA.125
               ENDIF                                                             STMPTA.126
            END IF                                                               STMPTA.127
C                                                                                STMPTA.128
C CONVERT TO FRACTIONAL COORDINATES AND FIND THE INCREMENTAL                     STMPTA.129
C DISTANCE IN THE FRACTIONAL SYSTEM. TO ENSURE THAT THIS DISTANCE                STMPTA.130
C IS MEANINGFUL, WE REQUIRE THAT IT BE BETWEEN 1E3 AND 1E4                       STMPTA.131
C TIMES SMALLER THAN THE MAXIMUM VECTOR LENGTH.                                  STMPTA.132
C                                                                                STMPTA.133
            XTF=CUFX(XT)                                                         STMPTA.134
            YTF=CUFY(YT)                                                         STMPTA.135
            DV2=SQRT((XTF-XND)*(XTF-XND)+(YTF-YND)*(YTF-YND))                    STMPTA.136
            IF (DV2*1E1 .GT. DFMG) THEN                                          STMPTA.137
               ICT=ICT+1                                                         STMPTA.138
               DUV=DUV/PDUVML                                                    STMPTA.139
               GO TO 10                                                          STMPTA.140
            ELSE IF (DV2*1E2 .LT. DFMG) THEN                                     STMPTA.141
               ICT=ICT+1                                                         STMPTA.142
               DUV=DUV*PDUVML                                                    STMPTA.143
               GO TO 10                                                          STMPTA.144
            END IF                                                               STMPTA.145
C                                                                                STMPTA.146
C THE ACTUAL ENDPOINTS ARE FOUND USING THE RATIO OF THE INCREMENTAL              STMPTA.147
C DISTANCE TO THE ACTUAL DISTANCE TIMES THE FRACTIONAL COMPONENT                 STMPTA.148
C LENGTH                                                                         STMPTA.149
            XE=XND+SGN*(XTF-XND)*DV1/DV2                                         STMPTA.150
            YE=YND+SGN*(YTF-YND)*DV1/DV2                                         STMPTA.151
C                                                                                STMPTA.152
         END IF                                                                  STMPTA.153
C                                                                                STMPTA.154
C CALCULATE THE ANGLE                                                            STMPTA.155
C                                                                                STMPTA.156
         TA=ATAN2((YE-YND),(XE-XND))                                             STMPTA.157
C                                                                                STMPTA.158
C EZMAP OVERLAY                                                                  STMPTA.159
C                                                                                STMPTA.160
      ELSE IF (IMAP .EQ. 1) THEN                                                 STMPTA.161
C                                                                                STMPTA.162
C X IS LONGITUDE, Y IS LATITUDE                                                  STMPTA.163
C IF Y IS 90 DEGREES, CAN'T COMPUTE A DIRECTION                                  STMPTA.164
C                                                                                STMPTA.165
         IF (IFIX(ABS(YDA)*PRCFAC+0.5) .GE. IFIX(PCSTST)) THEN                   STMPTA.166
            IST=-1                                                               STMPTA.167
            RETURN                                                               STMPTA.168
         END IF                                                                  STMPTA.169
C                                                                                STMPTA.170
         SGN=1.0                                                                 STMPTA.171
         DUV=PVFRAC/VNML                                                         STMPTA.172
         CLT=COS(YDA*PDTOR)                                                      STMPTA.173
         DTX=DU/CLT                                                              STMPTA.174
         DTY=DV                                                                  STMPTA.175
         ICT=0                                                                   STMPTA.176
C                                                                                STMPTA.177
 20      CONTINUE                                                                STMPTA.178
C                                                                                STMPTA.179
         DNX=DTX*DUV                                                             STMPTA.180
         DNY=DTY*DUV                                                             STMPTA.181
C                                                                                STMPTA.182
C BAIL OUT IF IT'S NOT WORKING                                                   STMPTA.183
C                                                                                STMPTA.184
         IF (ICT .GT. IPMXCT) THEN                                               STMPTA.185
            IST = -3                                                             STMPTA.186
            RETURN                                                               STMPTA.187
         END IF                                                                  STMPTA.188
C                                                                                STMPTA.189
C CALCULATE THE INCREMENTAL END POINTS, THEN CHECK TO SEE IF                     STMPTA.190
C THEY TAKE US OUT OF THE USER COORDINATE BOUNDARIES. IF THEY                    STMPTA.191
C DO, TRY INCREMENTING IN THE OTHER DIRECTION                                    STMPTA.192
C                                                                                STMPTA.193
         CALL MAPTRA(YDA+SGN*DNY,XDA+SGN*DNX,XT,YT)                              STMPTA.194
C                                                                                STMPTA.195
         IF (XT .LT. WXMN .OR. XT .GT. WXMX .OR.                                 STMPTA.196
     +        YT .LT. WYMN .OR. YT .GT. WYMX) THEN                               STMPTA.197
            IF (SGN .EQ. 1) THEN                                                 STMPTA.198
               SGN=-1.0                                                          STMPTA.199
               GO TO 20                                                          STMPTA.200
            ELSE                                                                 STMPTA.201
               IST=-4                                                            STMPTA.202
               RETURN                                                            STMPTA.203
            ENDIF                                                                STMPTA.204
         END IF                                                                  STMPTA.205
C                                                                                STMPTA.206
C CONVERT TO FRACTIONAL COORDINATES AND FIND THE INCREMENTAL                     STMPTA.207
C DISTANCE IN THE FRACTIONAL SYSTEM. TO ENSURE THAT THIS DISTANCE                STMPTA.208
C IS MEANINGFUL, WE REQUIRE THAT IT BE BETWEEN 1E3 AND 1E4                       STMPTA.209
C TIMES SMALLER THAN THE MAXIMUM VECTOR LENGTH.                                  STMPTA.210
C                                                                                STMPTA.211
         XTF=CUFX(XT)                                                            STMPTA.212
         YTF=CUFY(YT)                                                            STMPTA.213
         DV2=SQRT((XTF-XND)*(XTF-XND)+(YTF-YND)*(YTF-YND))                       STMPTA.214
         IF (DV2*1E1 .GT. DFMG) THEN                                             STMPTA.215
            ICT=ICT+1                                                            STMPTA.216
            DUV=DUV/PDUVML                                                       STMPTA.217
            GO TO 20                                                             STMPTA.218
         ELSE IF (DV2*1E2 .LT. DFMG) THEN                                        STMPTA.219
            ICT=ICT+1                                                            STMPTA.220
            DUV=DUV*PDUVML                                                       STMPTA.221
            GO TO 20                                                             STMPTA.222
         END IF                                                                  STMPTA.223
C                                                                                STMPTA.224
         TA=ATAN2((SGN*YTF-YND),(SGN*XTF-XND))                                   STMPTA.225
C                                                                                STMPTA.226
      ELSE IF (IMAP .EQ. 2) THEN                                                 STMPTA.227
C                                                                                STMPTA.228
C ... THE POLAR COORDINATE CASE ...                                              STMPTA.229
C                                                                                STMPTA.230
         TA=ATAN2(DV,DU)                                                         STMPTA.231
C                                                                                STMPTA.232
         IF (ITRT.GE.1) THEN                                                     STMPTA.233
            TH=PDTOR*YDA                                                         STMPTA.234
            TA=TH+TA                                                             STMPTA.235
         END IF                                                                  STMPTA.236
C                                                                                STMPTA.237
C ... AND EVERYTHING ELSE.                                                       STMPTA.238
C                                                                                STMPTA.239
      ELSE                                                                       STMPTA.240
C                                                                                STMPTA.241
         CALL STUMTA(XDA,YDA,XUS,YUS,XND,YND,DU,DV,TA,IST)                       STMPTA.242
C                                                                                STMPTA.243
      END IF                                                                     STMPTA.244
C                                                                                STMPTA.245
C DONE.                                                                          STMPTA.246
C                                                                                STMPTA.247
      RETURN                                                                     STMPTA.248
C                                                                                STMPTA.249
      END                                                                        STMPTA.250
