C                                                                                STMPUV.1
      SUBROUTINE STMPUV(UI,VI,UO,VO,IST)                                         STMPUV.2
C                                                                                STMPUV.3
C MAPS THE U,V VECTOR COMPONENT VALUES                                           STMPUV.4
C                                                                                STMPUV.5
C INPUT PARAMETERS:                                                              STMPUV.6
C                                                                                STMPUV.7
C UI,VI  - INPUT VALUES OF U,V                                                   STMPUV.8
C                                                                                STMPUV.9
C OUTPUT PARAMETERS:                                                             STMPUV.10
C                                                                                STMPUV.11
C UO,VO  - OUTPUT MAPPED COMPONENT VALUES                                        STMPUV.12
C IST    - STATUS VALUE                                                          STMPUV.13
C                                                                                STMPUV.14
C ---------------------------------------------------------------------          STMPUV.15
C                                                                                STMPUV.16
C NOTE:                                                                          STMPUV.17
C SINCE IMPLICIT TYPING IS USED FOR ALL REAL AND INTEGER VARIABLES               STMPUV.18
C A CONSISTENT LENGTH CONVENTION HAS BEEN ADOPTED TO HELP CLARIFY THE            STMPUV.19
C SIGNIFICANCE OF THE VARIABLES ENCOUNTERED IN THE CODE FOR THIS                 STMPUV.20
C UTILITY. ALL LOCAL VARIABLE AND SUBROUTINE PARAMETER IDENTIFIERS               STMPUV.21
C ARE LIMITED TO 1,2,OR 3 CHARACTERS. FOUR CHARACTER NAMES IDENTIFY              STMPUV.22
C MEMBERS OF COMMON BLOCKS. FIVE AND 6 CHARACTER VARIABLE NAMES                  STMPUV.23
C DENOTE PARAMETER CONSTANTS OR SUBROUTINE OR FUNCTION NAMES.                    STMPUV.24
C                                                                                STMPUV.25
C DECLARE THE ST COMMON BLOCKS.                                                  STMPUV.26
C                                                                                STMPUV.27
      PARAMETER (IPLVLS = 64)                                                    STMPUV.28
C                                                                                STMPUV.29
C INTEGER AND REAL COMMON BLOCK VARIABLES                                        STMPUV.30
C                                                                                STMPUV.31
C                                                                                STMPUV.32
      COMMON / STPAR /                                                           STMPUV.33
     +                IUD1       ,IVD1       ,IPD1       ,                       STMPUV.34
     +                IXD1       ,IXDM       ,IYD1       ,IYDN       ,           STMPUV.35
     +                IXM1       ,IYM1       ,IXM2       ,IYM2       ,           STMPUV.36
     +                IWKD       ,IWKU       ,ISET       ,IERR       ,           STMPUV.37
     +	              IXIN       ,IYIN       ,IMSK       ,ICPM       ,            STMPUV.38
     +                NLVL       ,IPAI       ,ICTV       ,WDLV       ,           STMPUV.39
     +                UVMN       ,UVMX       ,PMIN       ,PMAX       ,           STMPUV.40
     +                ITHN       ,IPLR       ,ISST       ,                       STMPUV.41
     +                ICLR(IPLVLS)           ,TVLU(IPLVLS)                       STMPUV.42
C                                                                                STMPUV.43
      COMMON / STTRAN /                                                          STMPUV.44
     +                UVPS       ,                                               STMPUV.45
     +                UVPL       ,UVPR       ,UVPB       ,UVPT       ,           STMPUV.46
     +                UWDL       ,UWDR       ,UWDB       ,UWDT       ,           STMPUV.47
     +                UXC1       ,UXCM       ,UYC1       ,UYCN                   STMPUV.48
C                                                                                STMPUV.49
C STREAM ALGORITHM PARAMETERS                                                    STMPUV.50
C                                                                                STMPUV.51
      COMMON / STSTRM /                                                          STMPUV.52
     +                ISGD       ,IAGD       ,RARL       ,ICKP       ,           STMPUV.53
     +                ICKX       ,ITRP       ,ICYK       ,RVNL       ,           STMPUV.54
     +                ISVF       ,RUSV       ,RVSV       ,RNDA       ,           STMPUV.55
     +                ISPC       ,RPSV       ,RCDS       ,RSSP       ,           STMPUV.56
     +                RDFM                                                       STMPUV.57
C                                                                                STMPUV.58
C TEXT RELATED PARAMETERS                                                        STMPUV.59
C NOTE: GRAPHICAL TEXT OUTPUT IS NOT YET IMPLEMENTED FOR THE                     STMPUV.60
C       STREAMLINE UTILITY.                                                      STMPUV.61
C                                                                                STMPUV.62
      COMMON / STTXP /                                                           STMPUV.63
     +                FCWM    ,ICSZ    ,                                         STMPUV.64
     +                FMNS    ,FMNX    ,FMNY    ,IMNP    ,IMNC  ,                STMPUV.65
     +                FMXS    ,FMXX    ,FMXY    ,IMXP    ,IMXC  ,                STMPUV.66
     +                FZFS    ,FZFX    ,FZFY    ,IZFP    ,IZFC  ,                STMPUV.67
     +                FILS    ,FILX    ,FILY    ,IILP    ,IILC                   STMPUV.68
C                                                                                STMPUV.69
C CHARACTER VARIABLE DECLARTIONS                                                 STMPUV.70
C                                                                                STMPUV.71
      CHARACTER*160 CSTR                                                         STMPUV.72
      PARAMETER (IPCHSZ=80)                                                      STMPUV.73
      CHARACTER*(IPCHSZ)  CMNT,CMXT,CZFT,CILT                                    STMPUV.74
C                                                                                STMPUV.75
C TEXT STRING PARAMETERS                                                         STMPUV.76
C                                                                                STMPUV.77
      COMMON / STCHAR / CSTR,CMNT,CMXT,CZFT,CILT                                 STMPUV.78
C                                                                                STMPUV.79
      SAVE /STPAR/, /STTRAN/, /STSTRM/, /STTXP/, /STCHAR/                        STMPUV.80
C                                                                                STMPUV.81
C INTERNAL BUFFER LENGTHS                                                        STMPUV.82
C                                                                                STMPUV.83
C IPNPTS - NUMBER OF POINTS IN THE POINT BUFFER -- NOT LESS THAN 3               STMPUV.84
C IPLSTL - STREAMLINE-CROSSOVER-CHECK CIRCULAR LIST LENGTH                       STMPUV.85
C IPGRCT - NUMBER OF GROUPS SUPPORTED FOR AREA MASKING                           STMPUV.86
C                                                                                STMPUV.87
      PARAMETER (IPNPTS = 10, IPLSTL = 750, IPGRCT = 64)                         STMPUV.88
C                                                                                STMPUV.89
C THE MAPPING COMMON BLOCK: MADE AVAILABLE TO USER MAPPING ROUTINES              STMPUV.90
C                                                                                STMPUV.91
      COMMON /STMAP/                                                             STMPUV.92
     +                IMAP       ,LNLG       ,INVX       ,INVY       ,           STMPUV.93
     +                XLOV       ,XHIV       ,YLOV       ,YHIV       ,           STMPUV.94
     +                WXMN       ,WXMX       ,WYMN       ,WYMX       ,           STMPUV.95
     +                XVPL       ,XVPR       ,YVPB       ,YVPT       ,           STMPUV.96
     +                XGDS       ,YGDS       ,NXCT       ,NYCT       ,           STMPUV.97
     +                ITRT       ,FW2W       ,FH2H       ,                       STMPUV.98
     +                DFMG       ,VNML       ,RBIG       ,IBIG                   STMPUV.99
C                                                                                STMPUV.100
      SAVE /STMAP/                                                               STMPUV.101
C                                                                                STMPUV.102
C MATH CONSTANTS                                                                 STMPUV.103
C                                                                                STMPUV.104
      PARAMETER (PDTOR  = 0.017453292519943,                                     STMPUV.105
     +           PRTOD  = 57.2957795130823,                                      STMPUV.106
     +           P1XPI  = 3.14159265358979,                                      STMPUV.107
     +           P2XPI  = 6.28318530717959,                                      STMPUV.108
     +           P1D2PI = 1.57079632679489,                                      STMPUV.109
     +           P5D2PI = 7.85398163397448)                                      STMPUV.110
C                                                                                STMPUV.111
C --------------------------------------------------------------------           STMPUV.112
C                                                                                STMPUV.113
C STATEMENT FUNCTIONS FOR FIELD TRANFORMATIONS                                   STMPUV.114
C                                                                                STMPUV.115
      FU(X,Y) = X                                                                STMPUV.116
      FV(X,Y) = Y                                                                STMPUV.117
C                                                                                STMPUV.118
C ---------------------------------------------------------------------          STMPUV.119
C                                                                                STMPUV.120
      IST = 0                                                                    STMPUV.121
C                                                                                STMPUV.122
C INPUT ARRAY POLAR MODE                                                         STMPUV.123
C                                                                                STMPUV.124
      IF (IPLR .LT. 1) THEN                                                      STMPUV.125
         UT=UI                                                                   STMPUV.126
         VT=VI                                                                   STMPUV.127
      ELSE IF (IPLR .EQ. 1) THEN                                                 STMPUV.128
         UT = UI*COS(PDTOR*VI)                                                   STMPUV.129
         VT = UI*SIN(PDTOR*VI)                                                   STMPUV.130
      ELSE IF (IPLR .GT. 1) THEN                                                 STMPUV.131
         UT = UI*COS(VI)                                                         STMPUV.132
         VT = UI*SIN(VI)                                                         STMPUV.133
      END IF                                                                     STMPUV.134
C                                                                                STMPUV.135
C ALLOW MAPPING USING FU,FV FUNCTIONS                                            STMPUV.136
C                                                                                STMPUV.137
      UO = FU(UT,VT)                                                             STMPUV.138
      VO = FV(UT,VT)                                                             STMPUV.139
C                                                                                STMPUV.140
C DONE                                                                           STMPUV.141
C                                                                                STMPUV.142
      RETURN                                                                     STMPUV.143
      END                                                                        STMPUV.144
