C	$ID: STRMLN.F,V 2.0 1997/01/11 20:33:48 MESOUSER EXP $                         STRMLN.1
C                                                                                STRMLN.2
      SUBROUTINE STRMLN (U,V,WORK,IMAX,IPTSX,JPTSY,NSET,IER)                     STRMLN.3
C                                                                                STRMLN.4
C THIS IS THE OLD FORM OF THE MAIN STREAMLINE ENTRY POINT                        STRMLN.5
C                                                                                STRMLN.6
C                                                                                STRMLN.7
C SUBROUTINE STRMLN (U,V,WORK,IMAX,IPTSX,JPTSY,NSET,IER)                         STRMLN.8
C                                                                                STRMLN.9
C DIMENSION OF           U(IMAX,JPTSY) , V(IMAX,JPTSY) ,                         STRMLN.10
C ARGUMENTS              WORK(2*IMAX*JPTSY)                                      STRMLN.11
C                                                                                STRMLN.12
C PURPOSE                STRMLN DRAWS A STREAMLINE REPRESENTATION OF             STRMLN.13
C                        THE FLOW FIELD. THE REPRESENTATION IS                   STRMLN.14
C                        INDEPENDENT OF THE FLOW SPEED.                          STRMLN.15
C                                                                                STRMLN.16
C USAGE                  IF THE FOLLOWING ASSUMPTIONS ARE MET, USE               STRMLN.17
C                                                                                STRMLN.18
C                            CALL EZSTRM  (U,V,WORK,IMAX,JMAX)                   STRMLN.19
C                                                                                STRMLN.20
C                          ASSUMPTIONS:                                          STRMLN.21
C                            --THE WHOLE ARRAY IS TO BE PROCESSED.               STRMLN.22
C                            --THE ARRAYS ARE DIMENSIONED                        STRMLN.23
C                              U(IMAX,JMAX) , V(IMAX,JMAX) AND                   STRMLN.24
C                              WORK(2*IMAX*JMAX).                                STRMLN.25
C                            --WINDOW AND VIEWPORT ARE TO BE CHOSEN              STRMLN.26
C                              BY STRMLN.                                        STRMLN.27
C                            --PERIM IS TO BE CALLED.                            STRMLN.28
C                                                                                STRMLN.29
C                        IF THESE ASSUMPTIONS ARE NOT MET, USE                   STRMLN.30
C                                                                                STRMLN.31
C                            CALL STRMLN (U,V,WORK,IMAX,IPTSX,JPTSY,             STRMLN.32
C                                         NSET,IER)                              STRMLN.33
C                                                                                STRMLN.34
C                        THE USER MUST CALL FRAME IN THE CALLING                 STRMLN.35
C                        ROUTINE.                                                STRMLN.36
C                                                                                STRMLN.37
C                        THE USER MAY CHANGE VARIOUS INTERNAL                    STRMLN.38
C                        PARAMETERS VIA COMMON BLOCKS. SEE BELOW.                STRMLN.39
C                                                                                STRMLN.40
C ARGUMENTS                                                                      STRMLN.41
C                                                                                STRMLN.42
C ON INPUT               U, V                                                    STRMLN.43
C                          TWO DIMENSIONAL ARRAYS CONTAINING THE                 STRMLN.44
C                          VELOCITY FIELDS TO BE PLOTTED.                        STRMLN.45
C                                                                                STRMLN.46
C                          NOTE:  IF THE U AND V COMPONENTS                      STRMLN.47
C                          ARE, FOR EXAMPLE, DEFINED IN CARTESIAN                STRMLN.48
C                          COORDINATES AND THE USER WISHES TO PLOT THEM          STRMLN.49
C                          ON A DIFFERENT PROJECTION (I.E., STEREO-              STRMLN.50
C                          GRAPHIC), THEN THE APPROPRIATE                        STRMLN.51
C                          TRANSFORMATION MUST BE MADE TO THE U AND V            STRMLN.52
C                          COMPONENTS VIA THE FUNCTIONS FU AND FV                STRMLN.53
C                          (LOCATED IN STDRAW).                                  STRMLN.54
C                                                                                STRMLN.55
C                        WORK                                                    STRMLN.56
C                          USER PROVIDED WORK ARRAY.  THE DIMENSION              STRMLN.57
C                          OF THIS ARRAY MUST BE .GE. 2*IMAX*JPTSY.              STRMLN.58
C                                                                                STRMLN.59
C                          CAUTION:  THIS ROUTINE DOES NOT CHECK THE             STRMLN.60
C                          SIZE OF THE WORK ARRAY.                               STRMLN.61
C                                                                                STRMLN.62
C                        IMAX                                                    STRMLN.63
C                          THE FIRST DIMENSION OF U AND V IN THE                 STRMLN.64
C                          CALLING PROGRAM. (X-DIRECTION)                        STRMLN.65
C                                                                                STRMLN.66
C                        IPTSX                                                   STRMLN.67
C                          THE NUMBER OF POINTS TO BE PLOTTED IN THE             STRMLN.68
C                          FIRST SUBSCRIPT DIRECTION.  (X-DIRECTION)             STRMLN.69
C                                                                                STRMLN.70
C                        JPTSY                                                   STRMLN.71
C                          THE NUMBER OF POINTS TO BE PLOTTED IN THE             STRMLN.72
C                          SECOND SUBSCRIPT DIRECTION. (Y-DIRECTION)             STRMLN.73
C                                                                                STRMLN.74
C                        NSET                                                    STRMLN.75
C                          FLAG TO CONTROL SCALING                               STRMLN.76
C                          > 0  STRMLN ASSUMES THAT THE WINDOW                   STRMLN.77
C                               AND VIEWPORT HAVE BEEN SET BY THE                STRMLN.78
C                               USER IN SUCH A WAY AS TO PROPERLY                STRMLN.79
C                               SCALE THE PLOTTING INSTRUCTIONS                  STRMLN.80
C                               GENERATED BY STRMLN. PERIM IS NOT                STRMLN.81
C                               CALLED.                                          STRMLN.82
C                          = 0  STRMLN WILL ESTABLISH THE WINDOW AND             STRMLN.83
C                               VIEWPORT TO PROPERLY SCALE THE                   STRMLN.84
C                               PLOTTING INSTRUCTIONS TO THE STANDARD            STRMLN.85
C                               CONFIGURATION. PERIM IS CALLED TO DRAW           STRMLN.86
C                               THE BORDER.                                      STRMLN.87
C                          < 0  STRMLN ESTABLISHES THE WINDOW                    STRMLN.88
C                               AND VIEWPORT SO AS TO PLACE THE                  STRMLN.89
C                               STREAMLINES WITHIN THE LIMITS                    STRMLN.90
C                               OF THE USER'S WINDOW.  PERIM IS                  STRMLN.91
C                               NOT CALLED.                                      STRMLN.92
C                                                                                STRMLN.93
C ON OUTPUT              ONLY THE IER ARGUMENT MAY BE CHANGED. ALL               STRMLN.94
C                        OTHER ARGUMENTS ARE UNCHANGED.                          STRMLN.95
C                                                                                STRMLN.96
C                                                                                STRMLN.97
C                        IER                                                     STRMLN.98
C                          =  0 WHEN NO ERRORS ARE DETECTED                      STRMLN.99
C                          = -1 WHEN THE ROUTINE IS CALLED WITH ICYC             STRMLN.100
C                               .NE. 0  AND THE DATA ARE NOT CYCLIC              STRMLN.101
C                               (ICYC IS AN INTERNAL PARAMETER                   STRMLN.102
C                               DESCRIBED BELOW); IN THIS CASE THE               STRMLN.103
C                               ROUTINE WILL DRAW THE                            STRMLN.104
C                               STREAMLINES WITH THE NON-CYCLIC                  STRMLN.105
C                               INTERPOLATION FORMULAS.                          STRMLN.106
C                                                                                STRMLN.107
C ENTRY POINTS           STRMLN, STDRAW, EZSTRM, STNEWP, STCYCL                  STRMLN.108
C                                                                                STRMLN.109
C COMMON BLOCKS          STR01, STR02, STR03, STR04                              STRMLN.110
C                                                                                STRMLN.111
C REQUIRED LIBRARY       GRIDAL, GBYTES, AND THE SPPS                            STRMLN.112
C ROUTINES                                                                       STRMLN.113
C                                                                                STRMLN.114
C REQUIRED GKS LEVEL     0A                                                      STRMLN.115
C                                                                                STRMLN.116
C I/O                    NONE                                                    STRMLN.117
C                                                                                STRMLN.118
C PRECISION              SINGLE                                                  STRMLN.119
C                                                                                STRMLN.120
C LANGUAGE               FORTRAN 77                                              STRMLN.121
C                                                                                STRMLN.122
C THE REMAINDER OF THE ORIGINAL STRMLN DISCUSSION FOLLOWS THE CODE               STRMLN.123
C                                                                                STRMLN.124
C                                                                                STRMLN.125
C ---------------------------------------------------------------------          STRMLN.126
C                                                                                STRMLN.127
C NOTE:                                                                          STRMLN.128
C SINCE IMPLICIT TYPING IS USED FOR ALL REAL AND INTEGER VARIABLES               STRMLN.129
C A CONSISTENT LENGTH CONVENTION HAS BEEN ADOPTED TO HELP CLARIFY THE            STRMLN.130
C SIGNIFICANCE OF THE VARIABLES ENCOUNTERED IN THE CODE FOR THIS                 STRMLN.131
C UTILITY. ALL LOCAL VARIABLE AND SUBROUTINE PARAMETER IDENTIFIERS               STRMLN.132
C ARE LIMITED TO 1,2,OR 3 CHARACTERS. FOUR CHARACTER NAMES IDENTIFY              STRMLN.133
C MEMBERS OF COMMON BLOCKS. FIVE AND 6 CHARACTER VARIABLE NAMES                  STRMLN.134
C DENOTE PARAMETER CONSTANTS OR SUBROUTINE OR FUNCTION NAMES.                    STRMLN.135
C                                                                                STRMLN.136
C DECLARE THE ST COMMON BLOCKS.                                                  STRMLN.137
C                                                                                STRMLN.138
      PARAMETER (IPLVLS = 64)                                                    STRMLN.139
C                                                                                STRMLN.140
C INTEGER AND REAL COMMON BLOCK VARIABLES                                        STRMLN.141
C                                                                                STRMLN.142
C                                                                                STRMLN.143
      COMMON / STPAR /                                                           STRMLN.144
     +                IUD1       ,IVD1       ,IPD1       ,                       STRMLN.145
     +                IXD1       ,IXDM       ,IYD1       ,IYDN       ,           STRMLN.146
     +                IXM1       ,IYM1       ,IXM2       ,IYM2       ,           STRMLN.147
     +                IWKD       ,IWKU       ,ISET       ,IERR       ,           STRMLN.148
     +	              IXIN       ,IYIN       ,IMSK       ,ICPM       ,            STRMLN.149
     +                NLVL       ,IPAI       ,ICTV       ,WDLV       ,           STRMLN.150
     +                UVMN       ,UVMX       ,PMIN       ,PMAX       ,           STRMLN.151
     +                ITHN       ,IPLR       ,ISST       ,                       STRMLN.152
     +                ICLR(IPLVLS)           ,TVLU(IPLVLS)                       STRMLN.153
C                                                                                STRMLN.154
      COMMON / STTRAN /                                                          STRMLN.155
     +                UVPS       ,                                               STRMLN.156
     +                UVPL       ,UVPR       ,UVPB       ,UVPT       ,           STRMLN.157
     +                UWDL       ,UWDR       ,UWDB       ,UWDT       ,           STRMLN.158
     +                UXC1       ,UXCM       ,UYC1       ,UYCN                   STRMLN.159
C                                                                                STRMLN.160
C STREAM ALGORITHM PARAMETERS                                                    STRMLN.161
C                                                                                STRMLN.162
      COMMON / STSTRM /                                                          STRMLN.163
     +                ISGD       ,IAGD       ,RARL       ,ICKP       ,           STRMLN.164
     +                ICKX       ,ITRP       ,ICYK       ,RVNL       ,           STRMLN.165
     +                ISVF       ,RUSV       ,RVSV       ,RNDA       ,           STRMLN.166
     +                ISPC       ,RPSV       ,RCDS       ,RSSP       ,           STRMLN.167
     +                RDFM                                                       STRMLN.168
C                                                                                STRMLN.169
C TEXT RELATED PARAMETERS                                                        STRMLN.170
C NOTE: GRAPHICAL TEXT OUTPUT IS NOT YET IMPLEMENTED FOR THE                     STRMLN.171
C       STREAMLINE UTILITY.                                                      STRMLN.172
C                                                                                STRMLN.173
      COMMON / STTXP /                                                           STRMLN.174
     +                FCWM    ,ICSZ    ,                                         STRMLN.175
     +                FMNS    ,FMNX    ,FMNY    ,IMNP    ,IMNC  ,                STRMLN.176
     +                FMXS    ,FMXX    ,FMXY    ,IMXP    ,IMXC  ,                STRMLN.177
     +                FZFS    ,FZFX    ,FZFY    ,IZFP    ,IZFC  ,                STRMLN.178
     +                FILS    ,FILX    ,FILY    ,IILP    ,IILC                   STRMLN.179
C                                                                                STRMLN.180
C CHARACTER VARIABLE DECLARTIONS                                                 STRMLN.181
C                                                                                STRMLN.182
      CHARACTER*160 CSTR                                                         STRMLN.183
      PARAMETER (IPCHSZ=80)                                                      STRMLN.184
      CHARACTER*(IPCHSZ)  CMNT,CMXT,CZFT,CILT                                    STRMLN.185
C                                                                                STRMLN.186
C TEXT STRING PARAMETERS                                                         STRMLN.187
C                                                                                STRMLN.188
      COMMON / STCHAR / CSTR,CMNT,CMXT,CZFT,CILT                                 STRMLN.189
C                                                                                STRMLN.190
      SAVE /STPAR/, /STTRAN/, /STSTRM/, /STTXP/, /STCHAR/                        STRMLN.191
C                                                                                STRMLN.192
C INTERNAL BUFFER LENGTHS                                                        STRMLN.193
C                                                                                STRMLN.194
C IPNPTS - NUMBER OF POINTS IN THE POINT BUFFER -- NOT LESS THAN 3               STRMLN.195
C IPLSTL - STREAMLINE-CROSSOVER-CHECK CIRCULAR LIST LENGTH                       STRMLN.196
C IPGRCT - NUMBER OF GROUPS SUPPORTED FOR AREA MASKING                           STRMLN.197
C                                                                                STRMLN.198
      PARAMETER (IPNPTS = 10, IPLSTL = 750, IPGRCT = 64)                         STRMLN.199
C                                                                                STRMLN.200
C THE MAPPING COMMON BLOCK: MADE AVAILABLE TO USER MAPPING ROUTINES              STRMLN.201
C                                                                                STRMLN.202
      COMMON /STMAP/                                                             STRMLN.203
     +                IMAP       ,LNLG       ,INVX       ,INVY       ,           STRMLN.204
     +                XLOV       ,XHIV       ,YLOV       ,YHIV       ,           STRMLN.205
     +                WXMN       ,WXMX       ,WYMN       ,WYMX       ,           STRMLN.206
     +                XVPL       ,XVPR       ,YVPB       ,YVPT       ,           STRMLN.207
     +                XGDS       ,YGDS       ,NXCT       ,NYCT       ,           STRMLN.208
     +                ITRT       ,FW2W       ,FH2H       ,                       STRMLN.209
     +                DFMG       ,VNML       ,RBIG       ,IBIG                   STRMLN.210
C                                                                                STRMLN.211
      SAVE /STMAP/                                                               STRMLN.212
C                                                                                STRMLN.213
C MATH CONSTANTS                                                                 STRMLN.214
C                                                                                STRMLN.215
      PARAMETER (PDTOR  = 0.017453292519943,                                     STRMLN.216
     +           PRTOD  = 57.2957795130823,                                      STRMLN.217
     +           P1XPI  = 3.14159265358979,                                      STRMLN.218
     +           P2XPI  = 6.28318530717959,                                      STRMLN.219
     +           P1D2PI = 1.57079632679489,                                      STRMLN.220
     +           P5D2PI = 7.85398163397448)                                      STRMLN.221
C                                                                                STRMLN.222
C --------------------------------------------------------------------           STRMLN.223
C                                                                                STRMLN.224
C ------------------------------------------------------------------             STRMLN.225
C                                                                                STRMLN.226
C THE OLD STRMLN COMMON BLOCKS                                                   STRMLN.227
C (NOW ISOLATED TO THIS COMPATIBILITY ROUTINE)                                   STRMLN.228
C NOTE THAT STR01 AND STR04 HAVE BEEN COMPLETELY ELIMINATED                      STRMLN.229
C                                                                                STRMLN.230
      COMMON /STR02/  EXT , SIDE , XLT , YBT                                     STRMLN.231
C                                                                                STRMLN.232
      COMMON /STR03/  INITA , INITB , AROWL , ITERP , ITERC , IGFLG              STRMLN.233
     +             ,  IMSG , UVMSG , ICYC , DISPL , DISPC , CSTOP                STRMLN.234
C                                                                                STRMLN.235
      SAVE  /STR02/, /STR03/                                                     STRMLN.236
C                                                                                STRMLN.237
C LOCAL VARIABLES:                                                               STRMLN.238
C                                                                                STRMLN.239
C SAVED VALUES OF COMMON BLOCK VARIABLES:                                        STRMLN.240
C (THESE VIOLATE THE GENERAL RULE OF USING ONLY 1-3 CHARS FOR A                  STRMLN.241
C  LOCAL VARIABLE)                                                               STRMLN.242
C                                                                                STRMLN.243
C ISSGD, ISAGD, SARL, ISCKP,                                                     STRMLN.244
C ISCKX, ISTRP, ISCYK, SVNL,                                                     STRMLN.245
C ISSVF, SUSV, SVSV, SDFM, SCDS, SSSP                                            STRMLN.246
C                                                                                STRMLN.247
C IPM             - PARAMETER USE FLAG                                           STRMLN.248
C ICB             - COMMON BLOCKS USE FLAG                                       STRMLN.249
C VXL,VXR,VYB,VYT - SAVED VIEWPORT BOUNDARY                                      STRMLN.250
C WXL,WXR,WYB,WYT - SAVED WINDOW BOUNDARY                                        STRMLN.251
C X1,X2,Y1,Y2     - TEMPORARY VIEWPORT BOUNDARY                                  STRMLN.252
C X3,Y3,X4,Y4     - TEMPORARY WINDOW BOUNDARY                                    STRMLN.253
C LEN             - MAXIMUM VECTOR SIZE IN METACODE COORDS                       STRMLN.254
C IDM             - INTEGER DUMMY VARIABLE                                       STRMLN.255
C                                                                                STRMLN.256
      DATA IDM / 0 /                                                             STRMLN.257
C                                                                                STRMLN.258
C ---------------------------------------------------------------------          STRMLN.259
C                                                                                STRMLN.260
C INITIALIZATION OF STR02, STR03 COMMON BLOCK MEMBERS                            STRMLN.261
C                                                                                STRMLN.262
      EXT       = 0.25                                                           STRMLN.263
      SIDE      = 0.90                                                           STRMLN.264
      XLT       = 0.05                                                           STRMLN.265
      YBT       = 0.05                                                           STRMLN.266
C                                                                                STRMLN.267
C     INITA     = 2                                                              STRMLN.268
C     INITB     = 2                                                              STRMLN.269
      AROWL     = 0.33                                                           STRMLN.270
      ITERP     = 35                                                             STRMLN.271
      ITERC     = -99                                                            STRMLN.272
      IGFLG     = 0                                                              STRMLN.273
      ICYC      = 0                                                              STRMLN.274
      IMSG      = 0                                                              STRMLN.275
      UVMSG     = 1.E+36                                                         STRMLN.276
      DISPL     = 0.33                                                           STRMLN.277
      DISPC     = 0.67                                                           STRMLN.278
      CSTOP     = 0.50                                                           STRMLN.279
C                                                                                STRMLN.280
C THE FOLLOWING CALL IS FOR GATHERING STATISTICS ON LIBRARY USE AT NCAR.         STRMLN.281
C                                                                                STRMLN.282
      CALL Q8QST4 ('CRAYLIB','STRMLN','STRMLN','VERSION  4')                     STRMLN.283
C                                                                                STRMLN.284
C SAVE THE VALUES OF ALL PARAMETERS THAT MAY GET CHANGED                         STRMLN.285
C                                                                                STRMLN.286
      CALL STGETI('SET - DO SET CALL FLAG', ISSET)                               STRMLN.287
      CALL STGETI('SGD - STREAM START GRID INCREMENT', ISSGD)                    STRMLN.288
      CALL STGETI('AGD - ARROW PLACEMENT GRID INCREMENT', ISAGD)                 STRMLN.289
      CALL STGETR('ARL - ARROW LENGTH, FRACTION OF GRID', SARL)                  STRMLN.290
      CALL STGETI('CKP - CHECK PROGRESS AT ITERATION MOD', ISCKP)                STRMLN.291
      CALL STGETI('CKX - CHECK STREAMLINE CROSSOVER MOD', ISCKX)                 STRMLN.292
      CALL STGETI('TRP - INTERPOLATION METHOD', ISTRP)                           STRMLN.293
      CALL STGETI('CYK - CYCLICAL DATA FLAG', ISCYK)                             STRMLN.294
      CALL STGETR('VNL - NORMALIZED VECTOR MAGNITUDE', SVNL)                     STRMLN.295
      CALL STGETI('SVF - SPECIAL VALUE FLAG', ISSVF)                             STRMLN.296
      CALL STGETR('USV - U ARRAY SPECIAL VALUE', SUSV)                           STRMLN.297
      CALL STGETR('VSV - V ARRAY SPECIAL VALUE', SVSV)                           STRMLN.298
      CALL STGETR('DFM - DIFFERENTIAL MAGNITUDE', SDFM)                          STRMLN.299
      CALL STGETR('CDS - CRITICAL DISPLACEMENT', SCDS)                           STRMLN.300
      CALL STGETR('SSP - STREAMLINE SPACING', SSSP)                              STRMLN.301
C                                                                                STRMLN.302
C LOAD THE COMMUNICATION COMMON BLOCK WITH PARAMETERS                            STRMLN.303
C                                                                                STRMLN.304
C                                                                                STRMLN.305
      IF (IPTSX.LE.1 .OR. JPTSY.LE.1 .OR. IMAX.LT.IPTSX) THEN                    STRMLN.306
         CSTR(1:26)='STRMLN - INVALID ARGUMENTS'                                 STRMLN.307
         CALL SETER (CSTR(1:26),1,2)                                             STRMLN.308
         STOP                                                                    STRMLN.309
      END IF                                                                     STRMLN.310
      LU=IMAX                                                                    STRMLN.311
      LV=IMAX                                                                    STRMLN.312
      M=IPTSX                                                                    STRMLN.313
      N=JPTSY                                                                    STRMLN.314
      LW=2*LU*N                                                                  STRMLN.315
      IS = 1                                                                     STRMLN.316
      IEND = IPTSX                                                               STRMLN.317
      JS = 1                                                                     STRMLN.318
      JEND = JPTSY                                                               STRMLN.319
C                                                                                STRMLN.320
C SET UP THE SCALING OF THE PLOT.                                                STRMLN.321
C                                                                                STRMLN.322
      CALL GETSET (VXL,VXR,VYB,VYT,WXL,WXR,WYB,WYT,LL)                           STRMLN.323
C                                                                                STRMLN.324
      X1=VXL                                                                     STRMLN.325
      X2=VXR                                                                     STRMLN.326
      Y1=VYB                                                                     STRMLN.327
      Y2=VYT                                                                     STRMLN.328
C                                                                                STRMLN.329
C SET THE PARAMETER AND COMMON BLOCK USE FLAGS                                   STRMLN.330
C NOTE THAT THE VALUE OF ICPM IS TEMPORARILY MODIFIED IF IT                      STRMLN.331
C IS EQUAL TO THE DEFAULT VALUE. IT WILL BE RESTORED AS SOON AS                  STRMLN.332
C THE STREAMLINES ARE DRAWN                                                      STRMLN.333
C                                                                                STRMLN.334
      IPM = 0                                                                    STRMLN.335
      IF (ICPM.GE.-2 .AND. ICPM.LE.2) IPM = 1                                    STRMLN.336
      ICB = 0                                                                    STRMLN.337
      IF (ABS(ICPM).EQ.1 .OR. ABS(ICPM).EQ.3 .OR. ICPM.EQ.0) ICB = 1             STRMLN.338
      IF (ICPM .EQ. 0) ICPM = 99                                                 STRMLN.339
C                                                                                STRMLN.340
      IF (IPM .EQ. 1) THEN                                                       STRMLN.341
C                                                                                STRMLN.342
         ILL = 1                                                                 STRMLN.343
         IF (NSET .LT. 0) THEN                                                   STRMLN.344
C                                                                                STRMLN.345
            X3 = FLOAT(IS)                                                       STRMLN.346
            X4 = FLOAT(IEND)                                                     STRMLN.347
            Y3 = FLOAT(JS)                                                       STRMLN.348
            Y4 = FLOAT(JEND)                                                     STRMLN.349
            CALL SET(X1,X2,Y1,Y2,X3,X4,Y3,Y4,ILL)                                STRMLN.350
C                                                                                STRMLN.351
         ELSE IF (NSET .EQ. 0) THEN                                              STRMLN.352
C                                                                                STRMLN.353
            X1 = XLT                                                             STRMLN.354
            X2 = XLT+SIDE                                                        STRMLN.355
            Y1 = YBT                                                             STRMLN.356
            Y2 = YBT+SIDE                                                        STRMLN.357
            X3 = FLOAT(IS)                                                       STRMLN.358
            X4 = FLOAT(IEND)                                                     STRMLN.359
            Y3 = FLOAT(JS)                                                       STRMLN.360
            Y4 = FLOAT(JEND)                                                     STRMLN.361
            IF (AMIN1(X4,Y4)/AMAX1(X4,Y4).GE.EXT) THEN                           STRMLN.362
               IF (X4.GT.Y4)  THEN                                               STRMLN.363
                  Y2=SIDE*(Y4/X4)+YBT                                            STRMLN.364
               ELSE IF (Y4.GT.X4) THEN                                           STRMLN.365
                  X2=SIDE*(X4/Y4)+XLT                                            STRMLN.366
               END IF                                                            STRMLN.367
            END IF                                                               STRMLN.368
C                                                                                STRMLN.369
C CENTER THE PLOT                                                                STRMLN.370
C                                                                                STRMLN.371
            DX = 0.25*( 1. - (X2-X1) )                                           STRMLN.372
            DY = 0.25*( 1. - (Y2-Y1) )                                           STRMLN.373
            X1 = (XLT+DX)                                                        STRMLN.374
            X2 = (X2+DX )                                                        STRMLN.375
            Y1 = (YBT+DY)                                                        STRMLN.376
            Y2 = (Y2+DY )                                                        STRMLN.377
C                                                                                STRMLN.378
            CALL SET(X1,X2,Y1,Y2,X3,X4,Y3,Y4,ITYPE)                              STRMLN.379
C                                                                                STRMLN.380
            CALL PERIM (1,0,1,0)                                                 STRMLN.381
C                                                                                STRMLN.382
         END IF                                                                  STRMLN.383
C                                                                                STRMLN.384
C SINCE THE SET CALL HAS BEEN HANDLED STINIT SHOULD NOT DO A SET                 STRMLN.385
C                                                                                STRMLN.386
         CALL STSETI('SET - DO SET CALL FLAG', 0)                                STRMLN.387
C                                                                                STRMLN.388
      END IF                                                                     STRMLN.389
C                                                                                STRMLN.390
C COMMON BLOCK VALUES (STR03) (SAVE THEM FIRST)                                  STRMLN.391
C                                                                                STRMLN.392
      IF (ICB .EQ. 1) THEN                                                       STRMLN.393
C                                                                                STRMLN.394
         CALL STSETI('SGD - STREAM START GRID INCREMENT', INITA)                 STRMLN.395
         CALL STSETI('AGD - ARROW PLACEMENT GRID INCREMENT', INITB)              STRMLN.396
         CALL STSETI('CKP - CHECK PROGRESS AT ITERATION MOD', ITERP)             STRMLN.397
         CALL STSETI('CKX - CHECK STREAMLINE CROSSOVER MOD', ITERC)              STRMLN.398
         CALL STSETI('TRP - INTERPOLATION METHOD', IGFLG)                        STRMLN.399
         CALL STSETI('CYK - CYCLICAL DATA FLAG', ICYC)                           STRMLN.400
         CALL STSETI('SVF - SPECIAL VALUE FLAG', IMSG)                           STRMLN.401
         CALL STSETR('USV - U ARRAY SPECIAL VALUE', UVMSG)                       STRMLN.402
         CALL STSETR('VSV - V ARRAY SPECIAL VALUE', UVMSG)                       STRMLN.403
         CALL STSETR('VNL - NORMALIZED VECTOR MAGNITUDE', DISPL)                 STRMLN.404
C                                                                                STRMLN.405
C THESE PARAMETERS ARE ROUGHLY MAPPED TO THE NEW METHOD OF                       STRMLN.406
C USING VIEWPORT FRACTION RATHER THAN GRID FRACTION.                             STRMLN.407
C                                                                                STRMLN.408
         CALL STSETR('ARL - ARROW LENGTH, VIEWPORT FRACTION',                    STRMLN.409
     +        AROWL/FLOAT(M))                                                    STRMLN.410
         CALL STSETR('SSP - STREAMLINE SPACING, VP FRACTION',                    STRMLN.411
     +        CSTOP/FLOAT(M))                                                    STRMLN.412
         CALL STSETR('DFM - DIFFERENTIAL MAGNITUDE, VP FRACTION',                STRMLN.413
     +        DISPL/FLOAT(M))                                                    STRMLN.414
         CALL STSETR('CDS - CRITICAL DISPLACEMENT MULTIPLIER',                   STRMLN.415
     +        DISPC/DISPL)                                                       STRMLN.416
C                                                                                STRMLN.417
      END IF                                                                     STRMLN.418
C                                                                                STRMLN.419
C INITIALIZE THE STREAM PLOTTING ROUTINE AND DRAW THE STREAMLINES                STRMLN.420
C                                                                                STRMLN.421
      CALL STINIT(U,LU,V,LV,IDM,IDM,M,N,WORK,LW)                                 STRMLN.422
C                                                                                STRMLN.423
      CALL STREAM(U,V,IDM,IDM,IDM,WORK)                                          STRMLN.424
C                                                                                STRMLN.425
C FETCH THE ERROR VALUE INTO THE OUTPUT PARAMETER, IER                           STRMLN.426
C                                                                                STRMLN.427
      CALL STGETI('ERR - ERROR IDENTIFIER', IER)                                 STRMLN.428
C                                                                                STRMLN.429
C RESTORE ORIGINAL SET VALUES, IF REQUIRED.                                      STRMLN.430
C                                                                                STRMLN.431
      IF (NSET .LE. 0) THEN                                                      STRMLN.432
         CALL SET (VXL,VXR,VYB,VYT,WXL,WXR,WYB,WYT,LL)                           STRMLN.433
      END IF                                                                     STRMLN.434
C                                                                                STRMLN.435
      CALL STSETI('SET - DO SET CALL FLAG', ISSET)                               STRMLN.436
      CALL STSETI('SGD - STREAM START GRID INCREMENT', ISSGD)                    STRMLN.437
      CALL STSETI('AGD - ARROW PLACEMENT GRID INCREMENT', ISAGD)                 STRMLN.438
      CALL STSETR('ARL - ARROW LENGTH, FRACTION OF GRID', SARL)                  STRMLN.439
      CALL STSETI('CKP - CHECK PROGRESS AT ITERATION MOD', ISCKP)                STRMLN.440
      CALL STSETI('CKX - CHECK STREAMLINE CROSSOVER MOD', ISCKX)                 STRMLN.441
      CALL STSETI('TRP - INTERPOLATION METHOD', ISTRP)                           STRMLN.442
      CALL STSETI('CYK - CYCLICAL DATA FLAG', ISCYK)                             STRMLN.443
      CALL STSETR('VNL - NORMALIZED VECTOR MAGNITUDE', SVNL)                     STRMLN.444
      CALL STSETI('SVF - SPECIAL VALUE FLAG', ISSVF)                             STRMLN.445
      CALL STSETR('USV - U ARRAY SPECIAL VALUE', SUSV)                           STRMLN.446
      CALL STSETR('VSV - V ARRAY SPECIAL VALUE', SVSV)                           STRMLN.447
      CALL STSETR('DFM - DIFFERENTIAL MAGNITUDE', SDFM)                          STRMLN.448
      CALL STSETR('CDS - CRITICAL DISPLACEMENT', SCDS)                           STRMLN.449
      CALL STSETR('SSP - STREAMLINE SPACING', SSSP)                              STRMLN.450
C                                                                                STRMLN.451
C                                                                                STRMLN.452
C RESTORE THE COMPATIBILITY FLAG VALUE IF NECESSARY                              STRMLN.453
C                                                                                STRMLN.454
      IF (ICPM .EQ. 99) ICPM = 0                                                 STRMLN.455
C                                                                                STRMLN.456
      RETURN                                                                     STRMLN.457
      END                                                                        STRMLN.458
