      SUBROUTINE THCKNS (H,IMX,JMX,KX,THK,ICRSDOT,FIELD,P)                       THCKNS.1
C                                                                                THCKNS.2
C  SECTION DIAGNOSTIC                                                            THCKNS.3
C  PUPOSE  COMPUTES THE THICKNESS BETWEEN TWO PRESSURE LEVELS                    THCKNS.4
C   INPUT H IS A 3-D GEOPOTENTIAL HEIGHT FIELD                                   THCKNS.5
C         FIELD IS THE FIELD TO BE PLOTTED (TO GET THE TWO LEVELS)               THCKNS.6
C         IL IS THE LOWER LEVEL SUBSCRIPT                                        THCKNS.7
C         IU IS THE UPPER LEVEL SUBSCRIPT                                        THCKNS.8
C                                                                                THCKNS.9
      DIMENSION H(IMX,JMX,KX), THK(IMX,JMX), P(100)                              THCKNS.10
      CHARACTER FIELD*(*)                                                        THCKNS.11
      PARAMETER (SMALLDIF=0.01)                                                  THCKNS.12
      IALREADY=0                                                                 THCKNS.13
C                                                                                THCKNS.14
C     ... GET LOWER LEVEL                                                        THCKNS.15
C                                                                                THCKNS.16
20    CONTINUE                                                                   THCKNS.17
      READ(FIELD(4:4),'(I1)') IP                                                 THCKNS.18
      IF (IP .EQ. 1) THEN                                                        THCKNS.19
         PL = 1000.                                                              THCKNS.20
      ELSE IF(IP .EQ. 8) THEN                                                    THCKNS.21
         PL = 850.                                                               THCKNS.22
      ELSE                                                                       THCKNS.23
         PL = IP * 100.                                                          THCKNS.24
      ENDIF                                                                      THCKNS.25
C                                                                                THCKNS.26
C     ... GET UPPER LEVEL                                                        THCKNS.27
C                                                                                THCKNS.28
      READ(FIELD(5:5),'(I1)') IP                                                 THCKNS.29
      IF(IP .EQ. 8) THEN                                                         THCKNS.30
         PU = 850.                                                               THCKNS.31
      ELSE                                                                       THCKNS.32
         PU = IP * 100.                                                          THCKNS.33
      ENDIF                                                                      THCKNS.34
      PU = IP * 100.                                                             THCKNS.35
C                                                                                THCKNS.36
C     ... FIND LOCATIONS IN PRESSURE ARRAY                                       THCKNS.37
C                                                                                THCKNS.38
      IL=-1                                                                      THCKNS.39
      IU=-1                                                                      THCKNS.40
      DO 50 K = 1, KX                                                            THCKNS.41
         IF (ABS(P(K)-PL).LT.SMALLDIF) THEN                                      THCKNS.42
            IL = K                                                               THCKNS.43
         ELSE IF (ABS(P(K)-PU).LT.SMALLDIF) THEN                                 THCKNS.44
            IU = K                                                               THCKNS.45
         ENDIF                                                                   THCKNS.46
   50 CONTINUE                                                                   THCKNS.47
      IF((IL.EQ.-1).OR.(IU.EQ.-1)) THEN                                          THCKNS.48
         IF(IALREADY.EQ.1) THEN                                                  THCKNS.49
            PRINT *,'TROUBLES WITH THICKNESS, AGAIN'                             THCKNS.50
            CALL CLEAR(THK,IMX,JMX,1)                                            THCKNS.51
            RETURN                                                               THCKNS.52
         END IF                                                                  THCKNS.53
         PRINT *,'TROUBLES WITH THICKNESS'                                       THCKNS.54
         PRINT *,'FIELD=',FIELD(1:5)                                             THCKNS.55
         PRINT *,'GOING TO TRY TO PROCESS 1000 - 500 MB THICKNESS'               THCKNS.56
         FIELD(4:5)='15'                                                         THCKNS.57
         IALREADY=1                                                              THCKNS.58
         GOTO 20                                                                 THCKNS.59
      END IF                                                                     THCKNS.60
C                                                                                THCKNS.61
C     ... DIFFERENCE 2 HEIGHT SLABS                                              THCKNS.62
C                                                                                THCKNS.63
      DO 100 J = 1, JMX-ICRSDOT                                                  THCKNS.64
      DO 100 I = 1, IMX-ICRSDOT                                                  THCKNS.65
        THK(I,J) = H(I,J,IU) - H(I,J,IL)                                         THCKNS.66
  100 CONTINUE                                                                   THCKNS.67
      RETURN                                                                     THCKNS.68
      END                                                                        THCKNS.69
