      SUBROUTINE TVIRT(T,Q,IMX,JMX,KX,                                           TVIRT.1
     *                 TV,IMAX,JMAX)                                             TVIRT.2
C                                                                                TVIRT.3
C     SECTION  DIAGNOSTIC                                                        TVIRT.4
C     PURPOSE  COMPUTES THE VIRTUAL TEMPERATURE FROM INPUT T AND                 TVIRT.5
C              MIXING RATIO.  VALID ON EITHER SIGMA OR P SURFACES.               TVIRT.6
C                                                                                TVIRT.7
C     INPUT       T        TEMPERATURE                CROSS    3D                TVIRT.8
C                 Q        MIXING RATIO               CROSS    3D                TVIRT.9
C                 IMX      DOT POINT DIMENSION N-S                               TVIRT.10
C                 JMX      DOT POINT DIMENSION E-W                               TVIRT.11
C                 KX       NUMBER OF VERTICAL LAYERS                             TVIRT.12
C                                                                                TVIRT.13
C     OUTPUT      TV       VIRTUAL TEMPERATURE        CROSS    3D                TVIRT.14
C                                                                                TVIRT.15
      DIMENSION T(IMX,JMX,KX)  ,Q(IMX,JMX,KX)                                    TVIRT.16
      DIMENSION TV(IMAX,JMAX,KX)                                                 TVIRT.17
C                                                                                TVIRT.18
C     ... COMPUTE VIRT TEMP FROM TEMPERATURE AND MIXING RATIO                    TVIRT.19
C                                                                                TVIRT.20
      DO 500 K=1,KX                                                              TVIRT.21
      DO 500 J=1,JMX-1                                                           TVIRT.22
      DO 500 I=1,IMX-1                                                           TVIRT.23
         TV(I,J,K)=T(I,J,K)*(1.+0.61*Q(I,J,K))                                   TVIRT.24
500   CONTINUE                                                                   TVIRT.25
      RETURN                                                                     TVIRT.26
      END                                                                        TVIRT.27
