      SUBROUTINE UNDRGRN2(UNDER,PSFC,P,I1,J1,K1,KZERO,                           UNDRGRN2.1
     *                    XUNDER,XABOVE)                                         UNDRGRN2.2
C                                                                                UNDRGRN2.3
C     SECTION  DIAGNOSTIC                                                        UNDRGRN2.4
C     PURPOSE  FROM INPUT SURFACE PRESSURE AND THE PRESSURE P(I,J,K),            UNDRGRN2.5
C              RETURN A 3D ARRAY FILLED WITH XUNDER AND XABOVE.                  UNDRGRN2.6
C              XUNDER SIGNIFIES LOCATIONS WHERE P(K) > SURFACE                   UNDRGRN2.7
C              PRESSURE (UNDER GROUND).  XABOVE SIGNIFIES LOCATIONS              UNDRGRN2.8
C              WHERE P(K) <= SURFACE PRESSURE (ABOVE OR AT GROUND LEVEL)         UNDRGRN2.9
C                                                                                UNDRGRN2.10
      DIMENSION UNDER(I1,J1,K1), PSFC(I1,J1), P(I1,J1,K1)                        UNDRGRN2.11
C                                                                                UNDRGRN2.12
C     ... MAKE ALL ABOVE INITIALLY                                               UNDRGRN2.13
C                                                                                UNDRGRN2.14
      DO 10 K=2,KZERO                                                            UNDRGRN2.15
      DO 10 J=1,J1                                                               UNDRGRN2.16
      DO 10 I=1,I1                                                               UNDRGRN2.17
         UNDER(I,J,K)=XABOVE                                                     UNDRGRN2.18
10    CONTINUE                                                                   UNDRGRN2.19
C                                                                                UNDRGRN2.20
C     ... FIND MINIMUM SURFACE PRESSURE                                          UNDRGRN2.21
C                                                                                UNDRGRN2.22
      SFCMIN=1300.                                                               UNDRGRN2.23
      DO 100 J=1,J1-1                                                            UNDRGRN2.24
      DO 100 I=1,I1-1                                                            UNDRGRN2.25
         SFCMIN=AMIN1(SFCMIN,PSFC(I,J))                                          UNDRGRN2.26
100   CONTINUE                                                                   UNDRGRN2.27
C                                                                                UNDRGRN2.28
C     ... FIND MAXIMUM PRESSURE UNDER GROUND                                     UNDRGRN2.29
C                                                                                UNDRGRN2.30
      PMAX=100.                                                                  UNDRGRN2.31
      DO 110 J=1,J1-1                                                            UNDRGRN2.32
      DO 110 I=1,I1-1                                                            UNDRGRN2.33
         IF(P(I,J,2).GT.PMAX) THEN                                               UNDRGRN2.34
            PMAX=P(I,J,2)                                                        UNDRGRN2.35
            IMIN=I                                                               UNDRGRN2.36
            JMIN=J                                                               UNDRGRN2.37
         END IF                                                                  UNDRGRN2.38
110   CONTINUE                                                                   UNDRGRN2.39
C                                                                                UNDRGRN2.40
C     ... FIND LEVEL OF P WHERE ALWAYS ABOVE GROUND AT MIN PSFC                  UNDRGRN2.41
C                                                                                UNDRGRN2.42
      DO 200 K=2,K1                                                              UNDRGRN2.43
         IF(P(IMIN,JMIN,K).LE.SFCMIN) THEN                                       UNDRGRN2.44
            KTRY=K                                                               UNDRGRN2.45
            GOTO 201                                                             UNDRGRN2.46
         END IF                                                                  UNDRGRN2.47
200   CONTINUE                                                                   UNDRGRN2.48
      PRINT *,'COULD NOT FIND A PRESSURE THAT WAS ABOVE GROUND'                  UNDRGRN2.49
      PRINT *,'PRESSURES=',P                                                     UNDRGRN2.50
      PRINT *,'MINIMUM SURFACE PRESSURE=',SFCMIN                                 UNDRGRN2.51
      KSAFE=K1+1                                                                 UNDRGRN2.52
      GOTO 225                                                                   UNDRGRN2.53
201   CONTINUE                                                                   UNDRGRN2.54
C                                                                                UNDRGRN2.55
C     ... STARTING AT KTRY, FIND K WHERE P(I,J,K) < PSFC(I,J)                    UNDRGRN2.56
C                                                                                UNDRGRN2.57
      DO 215 K=KTRY,K1                                                           UNDRGRN2.58
         DO 205 J=1,J1-1                                                         UNDRGRN2.59
         DO 205 I=1,I1-1                                                         UNDRGRN2.60
            IF(P(I,J,K).GT.PSFC(I,J)) GOTO 214                                   UNDRGRN2.61
205      CONTINUE                                                                UNDRGRN2.62
         GOTO 220                                                                UNDRGRN2.63
214      CONTINUE                                                                UNDRGRN2.64
215   CONTINUE                                                                   UNDRGRN2.65
      PRINT *,'COULD NOT FIND A PRESSURE THAT WAS ABOVE GROUND'                  UNDRGRN2.66
      PRINT *,'MINIMUM SURFACE PRESSURE=',SFCMIN                                 UNDRGRN2.67
      KSAFE=K1+1                                                                 UNDRGRN2.68
      GOTO 225                                                                   UNDRGRN2.69
220   CONTINUE                                                                   UNDRGRN2.70
      KSAFE=K                                                                    UNDRGRN2.71
225   CONTINUE                                                                   UNDRGRN2.72
C                                                                                UNDRGRN2.73
C     ... IF UNDER GROUND: XUNDER.  IF ABOVE GROUND: XABOVE                      UNDRGRN2.74
C                                                                                UNDRGRN2.75
      DO 300 K=2,KSAFE-1                                                         UNDRGRN2.76
      DO 300 J=1,J1-1                                                            UNDRGRN2.77
      DO 300 I=1,I1-1                                                            UNDRGRN2.78
         IF(P(I,J,K).LE.PSFC(I,J)) THEN                                          UNDRGRN2.79
            UNDER(I,J,K)=XABOVE                                                  UNDRGRN2.80
         ELSE                                                                    UNDRGRN2.81
            UNDER(I,J,K)=XUNDER                                                  UNDRGRN2.82
         END IF                                                                  UNDRGRN2.83
300   CONTINUE                                                                   UNDRGRN2.84
      DO 400 K=KSAFE,K1                                                          UNDRGRN2.85
      DO 400 J=1,J1-1                                                            UNDRGRN2.86
      DO 400 I=1,I1-1                                                            UNDRGRN2.87
         UNDER(I,J,K)=XABOVE                                                     UNDRGRN2.88
400   CONTINUE                                                                   UNDRGRN2.89
      DO 500 J=1,J1-1                                                            UNDRGRN2.90
      DO 500 I=1,I1-1                                                            UNDRGRN2.91
         UNDER(I,J,1)=XABOVE                                                     UNDRGRN2.92
500   CONTINUE                                                                   UNDRGRN2.93
      UNDER(1,1,1)=XUNDER                                                        UNDRGRN2.94
C                                                                                UNDRGRN2.95
      RETURN                                                                     UNDRGRN2.96
      END                                                                        UNDRGRN2.97
