      SUBROUTINE UNDRGRND(UNDER,PSFC,P,I1,J1,K1,XUNDER,XABOVE)                   UNDRGRND.1
C                                                                                UNDRGRND.2
C     SECTION  DIAGNOSTIC                                                        UNDRGRND.3
C     PURPOSE  FROM INPUT SURFACE PRESSURE AND THE PRESSURE STRING,              UNDRGRND.4
C              RETURN A 3D ARRAY FILLED WITH XUNDER AND XABOVE.                  UNDRGRND.5
C              XUNDER SIGNIFIES LOCATIONS WHERE P(K) > SURFACE                   UNDRGRND.6
C              PRESSURE (UNDER GROUND).  XABOVE SIGNIFIES LOCATIONS              UNDRGRND.7
C              WHERE P(K) <= SURFACE PRESSURE (ABOVE OR AT GROUND LEVEL)         UNDRGRND.8
C                                                                                UNDRGRND.9
      DIMENSION UNDER(I1,J1,K1), PSFC(I1,J1), P(K1)                              UNDRGRND.10
C                                                                                UNDRGRND.11
C     ... FIND MINIMUM SURFACE PRESSURE                                          UNDRGRND.12
C                                                                                UNDRGRND.13
      SFCMIN=1300.                                                               UNDRGRND.14
      DO 100 J=1,J1-1                                                            UNDRGRND.15
      DO 100 I=1,I1-1                                                            UNDRGRND.16
         SFCMIN=AMIN1(SFCMIN,PSFC(I,J))                                          UNDRGRND.17
100   CONTINUE                                                                   UNDRGRND.18
C                                                                                UNDRGRND.19
C     ... FIND LEVEL OF P(K) WHERE ALWAYS ABOVE GROUND                           UNDRGRND.20
C                                                                                UNDRGRND.21
      DO 200 K=2,K1                                                              UNDRGRND.22
         IF(P(K).LE.SFCMIN) THEN                                                 UNDRGRND.23
            KSAFE=K                                                              UNDRGRND.24
            GOTO 201                                                             UNDRGRND.25
         END IF                                                                  UNDRGRND.26
200   CONTINUE                                                                   UNDRGRND.27
      PRINT *,'COULD NOT FIND A PRESSURE THAT WAS ABOVE GROUND'                  UNDRGRND.28
      PRINT *,'PRESSURES=',P                                                     UNDRGRND.29
      PRINT *,'MINIMUM SURFACE PRESSURE=',SFCMIN                                 UNDRGRND.30
      KSAFE=K1+1                                                                 UNDRGRND.31
201   CONTINUE                                                                   UNDRGRND.32
C                                                                                UNDRGRND.33
C     ... IF UNDER GROUND: XUNDER.  IF ABOVE GROUND: XABOVE                      UNDRGRND.34
C                                                                                UNDRGRND.35
      DO 300 K=2,KSAFE-1                                                         UNDRGRND.36
      DO 300 J=1,J1-1                                                            UNDRGRND.37
      DO 300 I=1,I1-1                                                            UNDRGRND.38
         IF(P(K).LE.PSFC(I,J)) THEN                                              UNDRGRND.39
            UNDER(I,J,K)=XABOVE                                                  UNDRGRND.40
         ELSE                                                                    UNDRGRND.41
            UNDER(I,J,K)=XUNDER                                                  UNDRGRND.42
         END IF                                                                  UNDRGRND.43
300   CONTINUE                                                                   UNDRGRND.44
      DO 400 K=KSAFE,K1                                                          UNDRGRND.45
      DO 400 J=1,J1-1                                                            UNDRGRND.46
      DO 400 I=1,I1-1                                                            UNDRGRND.47
         UNDER(I,J,K)=XABOVE                                                     UNDRGRND.48
400   CONTINUE                                                                   UNDRGRND.49
      DO 500 J=1,J1-1                                                            UNDRGRND.50
      DO 500 I=1,I1-1                                                            UNDRGRND.51
         UNDER(I,J,1)=XABOVE                                                     UNDRGRND.52
500   CONTINUE                                                                   UNDRGRND.53
      UNDER(1,1,1)=XUNDER                                                        UNDRGRND.54
C                                                                                UNDRGRND.55
      RETURN                                                                     UNDRGRND.56
      END                                                                        UNDRGRND.57
