      SUBROUTINE VOR(U,V,DMF,XMF,I1,J1,K1,DS,VORT)                               VOR.1
C                                                                                VOR.2
C     SECTION  DIAGNOSTICS                                                       VOR.3
C     PURPOSE  COMPUTE K COMPONENT OF DEL CROSS VELOCITY                         VOR.4
C              VORT = M*M (DV/DX - DU/DY) WHERE U AND V ARE COUPLED              VOR.5
C              WITH MAP FACTORS (DOT POINT) AND M IS THE MAP FACTORS             VOR.6
C              ON CROSS POINTS                                                   VOR.7
C                                                                                VOR.8
      DIMENSION U(I1,J1,K1), V(I1,J1,K1), VORT(I1,J1,K1),                        VOR.9
     *   XMF(I1,J1),DMF(I1,J1)                                                   VOR.10
C                                                                                VOR.11
      IF(DS.LT.1000.) THEN                                                       VOR.12
         DS2R=1./(2.*DS*1000.)                                                   VOR.13
      ELSE                                                                       VOR.14
         DS2R=1./(2.*DS)                                                         VOR.15
      END IF                                                                     VOR.16
C                                                                                VOR.17
      DO 100 K=1,K1                                                              VOR.18
      DO 100 J=1,J1-1                                                            VOR.19
      DO 100 I=1,I1-1                                                            VOR.20
         U1=U(I  ,J  ,K)/DMF(I  ,J  )                                            VOR.21
         U2=U(I+1,J  ,K)/DMF(I+1,J  )                                            VOR.22
         U3=U(I  ,J+1,K)/DMF(I  ,J+1)                                            VOR.23
         U4=U(I+1,J+1,K)/DMF(I+1,J+1)                                            VOR.24
         V1=V(I  ,J  ,K)/DMF(I  ,J  )                                            VOR.25
         V2=V(I+1,J  ,K)/DMF(I+1,J  )                                            VOR.26
         V3=V(I  ,J+1,K)/DMF(I  ,J+1)                                            VOR.27
         V4=V(I+1,J+1,K)/DMF(I+1,J+1)                                            VOR.28
         VORT(I,J,K)=XMF(I,J)*XMF(I,J)*DS2R*                                     VOR.29
     *      ((V4-V2+V3-V1)-(U2-U1+U4-U3))                                        VOR.30
100   CONTINUE                                                                   VOR.31
      RETURN                                                                     VOR.32
      END                                                                        VOR.33
