      SUBROUTINE VORTABS(U,V,F,DMF,XMF,I1,J1,K1,DS,VORT)                         VORTABS.1
C                                                                                VORTABS.2
C     SECTION  DIAGNOSTICS                                                       VORTABS.3
C     PURPOSE  COMPUTE K COMPONENT OF DEL CROSS VELOCITY                         VORTABS.4
C              VORT = M*M (F + DV/DX - DU/DY) WHERE U AND V ARE COUPLED          VORTABS.5
C              WITH MAP FACTORS (DOT POINT) AND M IS THE MAP FACTORS             VORTABS.6
C              ON CROSS POINTS                                                   VORTABS.7
C                                                                                VORTABS.8
      DIMENSION U(I1,J1,K1), V(I1,J1,K1), VORT(I1,J1,K1),                        VORTABS.9
     *   XMF(I1,J1),DMF(I1,J1),F(I1,J1)                                          VORTABS.10
C                                                                                VORTABS.11
      IF(DS.LT.1000.) THEN                                                       VORTABS.12
         DS2R=1./(2.*DS*1000.)                                                   VORTABS.13
      ELSE                                                                       VORTABS.14
         DS2R=1./(2.*DS)                                                         VORTABS.15
      END IF                                                                     VORTABS.16
C                                                                                VORTABS.17
      DO 100 K=1,K1                                                              VORTABS.18
      DO 100 J=1,J1-1                                                            VORTABS.19
      DO 100 I=1,I1-1                                                            VORTABS.20
         U1=U(I  ,J  ,K)/DMF(I  ,J  )                                            VORTABS.21
         U2=U(I+1,J  ,K)/DMF(I+1,J  )                                            VORTABS.22
         U3=U(I  ,J+1,K)/DMF(I  ,J+1)                                            VORTABS.23
         U4=U(I+1,J+1,K)/DMF(I+1,J+1)                                            VORTABS.24
         V1=V(I  ,J  ,K)/DMF(I  ,J  )                                            VORTABS.25
         V2=V(I+1,J  ,K)/DMF(I+1,J  )                                            VORTABS.26
         V3=V(I  ,J+1,K)/DMF(I  ,J+1)                                            VORTABS.27
         V4=V(I+1,J+1,K)/DMF(I+1,J+1)                                            VORTABS.28
         FX=(F(I,J)+F(I+1,J)+F(I,J+1)+F(I+1,J+1))*0.25                           VORTABS.29
         VORT(I,J,K)=XMF(I,J)*XMF(I,J)*DS2R*                                     VORTABS.30
     *      ((V4-V2+V3-V1)-(U2-U1+U4-U3)) + FX                                   VORTABS.31
100   CONTINUE                                                                   VORTABS.32
      RETURN                                                                     VORTABS.33
      END                                                                        VORTABS.34
