      SUBROUTINE WNDBARB (XBASE,YBASE,U,V)                                       WNDBARB.1
                                                                                 WNDBARB.2
C***********************************************************************         WNDBARB.3
C WNDBARB - FOR THE GRAPH PORTION OF GRIN                                        WNDBARB.4
C  THIS ROUTINE DRAWS A SINGLE WIND BARB PER CALL.                               WNDBARB.5
C                                                                                WNDBARB.6
C ON INPUT - FOUR VARIABLES COME IN.  XBASE CONTAINS THE HORIZONTAL COOR         WNDBARB.7
C            DINATE OF THE BASE OF THE WIND BARB.  YBASE CONTAINS THE            WNDBARB.8
C            VERTICAL COORDINATE OF THE BASE OF THE WIND BARB.  U CONTAI         WNDBARB.9
C            THE EAST-WEST WIND COMPONENT IN METERS PER SECOND.  V CONTA         WNDBARB.10
C            THE NORTH-SOUTH WIND COMPONENT IN METERS PER SECOND.                WNDBARB.11
C                                                                                WNDBARB.12
C ON OUTPUT - ONE BARB HAS BEEN DRAWN TO UNIT NUMBER 2, WHICH CORRESPOND         WNDBARB.13
C            TO GMETA.CGM, THE GKS OUTPUT META CODE FILE.                        WNDBARB.14
C                                                                                WNDBARB.15
C ASSUMPTIONS - THIS ROUTINE ASSUMES THAT GKS HAS BEEN OPENED AND A WORK         WNDBARB.16
C            STATION HAS BEEN SET.                                               WNDBARB.17
C                                                                                WNDBARB.18
C REVISED BY - JEREMY ASBILL ON MAY 3, 1990.                                     WNDBARB.19
C***********************************************************************         WNDBARB.20
                                                                                 WNDBARB.21
C  INPUT VARIABLE DECLARATIONS ...                                               WNDBARB.22
                                                                                 WNDBARB.23
      REAL      XBASE,YBASE,                                                     WNDBARB.24
     *          U,V                                                              WNDBARB.25
                                                                                 WNDBARB.26
C  LOCAL PARAMETER ...                                                           WNDBARB.27
C    SC SPECIFIES IN THE NORMALIZED (FRACTIONAL) GRAPHICS COORDINATE             WNDBARB.28
C       SYSTEM HOW LONG THE BARB SHAFT IS TO BE                                  WNDBARB.29
C    COORDINATE SYSTEMS ARE EXPLAINED IN NCAR GRAPHICS USER'S GUIDE VERS         WNDBARB.30
C    2.00 ON PAGE 46.                                                            WNDBARB.31
                                                                                 WNDBARB.32
      PARAMETER (SC = 0.05493)                                                   WNDBARB.33
                                                                                 WNDBARB.34
C  LOCAL VARIABLE DECLARATIONS ...                                               WNDBARB.35
                                                                                 WNDBARB.36
      INTEGER   LLSV                 ! SAVE VARIABLE, SCALING FOR SET            WNDBARB.37
                                                                                 WNDBARB.38
      LOGICAL DONE                   ! T => SUBROUTINE ENDS, F => LOOP A         WNDBARB.39
                                                                                 WNDBARB.40
      REAL      WINDVCT,             ! WIND VECTOR MAGNITUDE                     WNDBARB.41
     *          FLSV,FRSV,FBSV,FTSV, ! SAVE VARIABLES, FRACTIONAL COORDI         WNDBARB.42
     *          ULSV,URSV,UBSV,UTSV, ! SAVE VARIABLES, INCOMING USER COO         WNDBARB.43
     *          NEWXBASE,            ! FRACTIONAL X COORD. FOR BARB BASE         WNDBARB.44
     *          NEWYBASE,            ! FRACTIONAL Y COORD. FOR BARB BASE         WNDBARB.45
     *          XCOMP,               ! X COMPONENT OF GRAPHICAL VECTOR (         WNDBARB.46
     *          YCOMP,               ! Y COMPONENT OF GRAPHICAL VECTOR (         WNDBARB.47
     *          PK,                  ! PLACE KEEPER                              WNDBARB.48
     *          FETHLENX,            ! X COMPONENT OF GRAPHICAL VECT. (F         WNDBARB.49
     *          FETHLENY             ! Y COMPONENT OF GRAPHICAL VECT. (F         WNDBARB.50
                                                                                 WNDBARB.51
C  LOCAL ARRAY DECLARATIONS ...                                                  WNDBARB.52
                                                                                 WNDBARB.53
      INTEGER   IJUNK(5)             ! CALCULATION ARRAY FOR SFSGFA              WNDBARB.54
                                                                                 WNDBARB.55
      REAL      POINTX(3),           ! USED TO SPECIFY POINTS TO DRAW BE         WNDBARB.56
     *          POINTY(3),           ! USED TO SPECIFY POINTS TO DRAW BE         WNDBARB.57
     *          JUNK(7)              ! CALCULATION ARRAY FOR SFSGFA              WNDBARB.58
                                                                                 WNDBARB.59
C***************************** SUBROUTINE BEGIN ************************         WNDBARB.60
                                                                                 WNDBARB.61
C  INITIALIZE LOOP, BOOLEAN INDICATOR                                            WNDBARB.62
                                                                                 WNDBARB.63
      DONE = .FALSE.                                                             WNDBARB.64
                                                                                 WNDBARB.65
C  CALCULATE THE WIND VECTOR MAGNITUDE IN KNOTS                                  WNDBARB.66
                                                                                 WNDBARB.67
      IF ((U .EQ. 0) .AND. (V .EQ. 0)) THEN                                      WNDBARB.68
        WINDVCT = 1.0                                                            WNDBARB.69
      ELSE                                                                       WNDBARB.70
        WINDVCT = SQRT(U**2 + V**2) * 1.94                                       WNDBARB.71
      END IF                                                                     WNDBARB.72
                                                                                 WNDBARB.73
C  SAVE INCOMING USER COORDINATES AND CHANGE BACK TO NORMALIZED COORDINA         WNDBARB.74
C  DOCUMENTATION FOR SET AND GETSET CAN BE FOUND IN NCAR GRAPHICS USER'S         WNDBARB.75
C  GUIDE VERSION 2.00 ON PAGES 49 (GETSET) AND 53 (SET).                         WNDBARB.76
                                                                                 WNDBARB.77
      CALL GETSET (FLSV,FRSV,FBSV,FTSV,ULSV,URSV,UBSV,UTSV,LLSV)                 WNDBARB.78
      CALL SET    (FLSV,FRSV,FBSV,FTSV, 0.0, 1.0, 0.0, 1.0, 1)                   WNDBARB.79
                                                                                 WNDBARB.80
C  DETERMINE WHERE THE BASE OF THE BARB IS IN THE NORMALIZED COORDINATES         WNDBARB.81
                                                                                 WNDBARB.82
      NEWXBASE = (XBASE - ULSV)/(URSV - ULSV)                                    WNDBARB.83
      NEWYBASE = (YBASE - UBSV)/(UTSV - UBSV)                                    WNDBARB.84
                                                                                 WNDBARB.85
C  CALCULATE THE X DISTANCE AND Y DISTANCE FROM THE BASE OF THE BARB THA         WNDBARB.86
C  DEFINES THE BARBS TIP (NORMALIZED COORD'S)                                    WNDBARB.87
                                                                                 WNDBARB.88
      XCOMP = -SC * U * 1.94/WINDVCT                                             WNDBARB.89
      YCOMP = -SC * V * 1.94/WINDVCT                                             WNDBARB.90
                                                                                 WNDBARB.91
C  DETERMINE THE ACTUAL LOCATION IN NORMALIZED COORDINATES OF THE BARB'S         WNDBARB.92
                                                                                 WNDBARB.93
      POINTX(1) = NEWXBASE + XCOMP                                               WNDBARB.94
      POINTY(1) = NEWYBASE + YCOMP                                               WNDBARB.95
                                                                                 WNDBARB.96
C  DRAW THE BARB SHAFT, DOCUMENTATION FOR THE LINE SUBROUTINE CAN BE FOU         WNDBARB.97
C  IN NCAR GRAPHICS USER'S GUIDE VERSION 2.00 ON PAGE 50                         WNDBARB.98
                                                                                 WNDBARB.99
      CALL LINE (NEWXBASE,NEWYBASE,POINTX(1),POINTY(1))                          WNDBARB.100
                                                                                 WNDBARB.101
C  DETERMINE THE FEATHER LENGTH                                                  WNDBARB.102
                                                                                 WNDBARB.103
      FETHLENX = 0.3 * YCOMP                                                     WNDBARB.104
      FETHLENY = -0.3 * XCOMP                                                    WNDBARB.105
                                                                                 WNDBARB.106
C  SET THE PLACE KEEPER AND BOOST THE WIND MAGNITUDE                             WNDBARB.107
                                                                                 WNDBARB.108
      PK = 0.9                                                                   WNDBARB.109
      WINDVCT = WINDVCT + 2.5                                                    WNDBARB.110
                                                                                 WNDBARB.111
C  BEGIN MAKING FEATHERS                                                         WNDBARB.112
                                                                                 WNDBARB.113
10    CONTINUE                                                                   WNDBARB.114
                                                                                 WNDBARB.115
C    DRAW A FLAG FOR EVERY 50 KNOTS WIND MAGNITUDE                               WNDBARB.116
                                                                                 WNDBARB.117
      IF (WINDVCT .GE. 50.0) THEN                                                WNDBARB.118
                                                                                 WNDBARB.119
C      DETERMINE THE POSITION OF THE FLAG TIP, POINT_(2)                         WNDBARB.120
C      AND DETERMINE POSITION WHERE FLAG BOTTOM MEETS THE SHAFT, POINT_(         WNDBARB.121
                                                                                 WNDBARB.122
        POINTX(2) = POINTX(1) + FETHLENX + 0.0005                                WNDBARB.123
        POINTY(2) = POINTY(1) + FETHLENY + 0.0005                                WNDBARB.124
        POINTX(3) = PK * XCOMP + NEWXBASE                                        WNDBARB.125
        POINTY(3) = PK * YCOMP + NEWYBASE                                        WNDBARB.126
                                                                                 WNDBARB.127
C      DRAW FLAG                                                                 WNDBARB.128
                                                                                 WNDBARB.129
        CALL LINE (POINTX(1),POINTY(1),POINTX(2),POINTY(2))                      WNDBARB.130
        CALL LINE (POINTX(3),POINTY(3),POINTX(2),POINTY(2))                      WNDBARB.131
                                                                                 WNDBARB.132
C      FILL IN FLAG, DOCUMENTATION FOR SFSGFA CAN BE FOUND IN NCAR               WNDBARB.133
C      GRAPHICS GUIDE TO NEW UTILITIES VERSION 3.00 ON PAGE 4-8                  WNDBARB.134
                                                                                 WNDBARB.135
        CALL SFSETR ('SP',0.000001)                                              WNDBARB.136
        CALL SFSGFA (POINTX,POINTY,3,JUNK,5,IJUNK,7,2)                           WNDBARB.137
                                                                                 WNDBARB.138
C      REMOVE 50 KNOTS FROM WIND MAGNITUDE (ALREADY DRAWN IN)                    WNDBARB.139
                                                                                 WNDBARB.140
        WINDVCT = WINDVCT - 50.0                                                 WNDBARB.141
                                                                                 WNDBARB.142
C      DETERMINE NEW BEGIN POINT FOR NEXT FLAG OR FEATHER                        WNDBARB.143
                                                                                 WNDBARB.144
        PK = PK - 0.05                                                           WNDBARB.145
        POINTX(1) = PK * XCOMP + NEWXBASE                                        WNDBARB.146
        POINTY(1) = PK * YCOMP + NEWYBASE                                        WNDBARB.147
        PK = PK - 0.1                                                            WNDBARB.148
                                                                                 WNDBARB.149
C    DRAW A FULL FEATHER FOR WIND MAGNITUDE OF EVERY 10 KNOTS                    WNDBARB.150
                                                                                 WNDBARB.151
      ELSE IF (WINDVCT .GE. 10.0) THEN                                           WNDBARB.152
                                                                                 WNDBARB.153
C      CALCULATE POSITION OF FEATHER END                                         WNDBARB.154
                                                                                 WNDBARB.155
        POINTX(2) = POINTX(1) + FETHLENX + 0.0005                                WNDBARB.156
        POINTY(2) = POINTY(1) + FETHLENY + 0.0005                                WNDBARB.157
                                                                                 WNDBARB.158
C      DRAW FEATHER                                                              WNDBARB.159
                                                                                 WNDBARB.160
        CALL LINE (POINTX(1),POINTY(1),POINTX(2),POINTY(2))                      WNDBARB.161
                                                                                 WNDBARB.162
C      REMOVE 10 KNOTS FROM WIND MAGNITUDE (ALREADY DRAWN IN)                    WNDBARB.163
                                                                                 WNDBARB.164
        WINDVCT = WINDVCT - 10.0                                                 WNDBARB.165
                                                                                 WNDBARB.166
C      DETERMINE NEW START POINT FOR NEXT FEATHER OR FLAG                        WNDBARB.167
                                                                                 WNDBARB.168
        POINTX(1) = PK * XCOMP + NEWXBASE                                        WNDBARB.169
        POINTY(1) = PK * YCOMP + NEWYBASE                                        WNDBARB.170
        PK = PK - 0.1                                                            WNDBARB.171
                                                                                 WNDBARB.172
C    DRAW A HALF FEATHER FOR EVERY 5 KNOTS OF WIND MAGNITUDE                     WNDBARB.173
                                                                                 WNDBARB.174
      ELSE IF (WINDVCT .GE. 5.0) THEN                                            WNDBARB.175
                                                                                 WNDBARB.176
C      CALCULATE POSITION OF TIP OF HALF FEATHER                                 WNDBARB.177
                                                                                 WNDBARB.178
        POINTX(2) = POINTX(1) + 0.5 * FETHLENX + 0.0005                          WNDBARB.179
        POINTY(2) = POINTY(1) + 0.5 * FETHLENY + 0.0005                          WNDBARB.180
                                                                                 WNDBARB.181
C      DRAW IN FEATHER                                                           WNDBARB.182
                                                                                 WNDBARB.183
        CALL LINE (POINTX(1),POINTY(1),POINTX(2),POINTY(2))                      WNDBARB.184
                                                                                 WNDBARB.185
C      TELL LOOP TO QUIT                                                         WNDBARB.186
                                                                                 WNDBARB.187
        DONE = .TRUE.                                                            WNDBARB.188
      ELSE                                                                       WNDBARB.189
        DONE = .TRUE.                                                            WNDBARB.190
      END IF                                                                     WNDBARB.191
                                                                                 WNDBARB.192
C  IF THERE IS STILL MORE WIND MAGNITUDE (>= 5 KNOTS) LOOP AGAIN                 WNDBARB.193
                                                                                 WNDBARB.194
      IF (.NOT. DONE) GOTO 10                                                    WNDBARB.195
                                                                                 WNDBARB.196
C  RESET USER COORDINATES TO THE INCOMING VALUES                                 WNDBARB.197
                                                                                 WNDBARB.198
      CALL SET (FLSV,FRSV,FBSV,FTSV,ULSV,URSV,UBSV,UTSV,LLSV)                    WNDBARB.199
                                                                                 WNDBARB.200
C****************************** SUBROUTINE END *************************         WNDBARB.201
                                                                                 WNDBARB.202
      RETURN                                                                     WNDBARB.203
      END                                                                        WNDBARB.204
