      SUBROUTINE XYLL(X,Y,XLAT,XLON)                                             XYLL.1
C                                                                                XYLL.2
C     SECTION  TOOLS                                                             XYLL.3
C     PURPOSE  THIS SUBROUTINE TRANSFORMS X AND Y BACK TO                        XYLL.4
C              LAT AND LON                                                       XYLL.5
C   JULY 28,1980           1ST VERSION BY BILL KUO            C                  XYLL.6
C                                                                                XYLL.7
      COMMON /XYLLC/ XN,DS,XLATC,XLONC,IMAX,JMAX,KPROJ,PSI1,PSI2                 XYLL.8
      REAL LAMC                                                                  XYLL.9
C   XN: CONE FACTOR  = 0.0 FOR MERACTOR PROJECTION                               XYLL.10
C                    = 1.0 FOR POLAR STEREOGRAPHIC.                              XYLL.11
C                    = MRF(4,1) FOR LAMBERT CONFORMAL.                           XYLL.12
C   DS: GRID SPACING IN KM.                                                      XYLL.13
C   XLATC,XLONC: CENTRAL LATITUDE AND LONGITUDE.                                 XYLL.14
C   IMAX,JMAX: GRID NUMBER IN Y & X DIRECTION                                    XYLL.15
C   THE X AND Y ARE ON THE SAME COORDINATE AS THE GRID SYSTEM.                   XYLL.16
C   WHICH MEANS IF X = 1.5 IT FALLS BETWEEN J = 1 AND J = 2                      XYLL.17
C                                                                                XYLL.18
      A=6370.                                                                    XYLL.19
      CONV=57.29578                                                              XYLL.20
      CENTRI=(FLOAT(IMAX)+1.)/2.                                                 XYLL.21
      CENTRJ=(FLOAT(JMAX)+1.)/2.                                                 XYLL.22
      IF(KPROJ.EQ.1) THEN  ! LAMBERT CONFORMAL                                   XYLL.23
         PHI1=90.0-PSI2                                                          XYLL.24
         PHIC=90.0-XLATC                                                         XYLL.25
         PHI1=PHI1/CONV                                                          XYLL.26
         PHIC=PHIC/CONV                                                          XYLL.27
         CNST=A*SIN(PHI1)/(XN*TAN(PHI1/2.)**XN)                                  XYLL.28
         XXC=0.0                                                                 XYLL.29
         YYC=-1.*CNST*(TAN(PHIC/2.)**XN)                                         XYLL.30
         XX=(X-CENTRJ)*DS+XXC                                                    XYLL.31
         YY=(Y-CENTRI)*DS+YYC                                                    XYLL.32
         R=SQRT(XX*XX+YY*YY)                                                     XYLL.33
         YXN=1./XN                                                               XYLL.34
         PHI=(R*XN/(SIN(PHI1)*A))**YXN                                           XYLL.35
         PHI=PHI*TAN(PHI1/2.)                                                    XYLL.36
         PHI=2.0*ATAN(PHI)                                                       XYLL.37
         PHI=PHI*CONV                                                            XYLL.38
         XLAT=90.0-PHI                                                           XYLL.39
         S=ASIN(XX/R)                                                            XYLL.40
         S=S*CONV                                                                XYLL.41
         S=S/XN                                                                  XYLL.42
         XLON=XLONC+S                                                            XYLL.43
C                                                                                XYLL.44
      ELSE IF(KPROJ.EQ.2) THEN  ! POLAR STEREO                                   XYLL.45
C        PI=3.14159265358                                                        XYLL.46
         PI=3.141593                                                             XYLL.47
         LAMC=XLONC/CONV                                                         XYLL.48
         PHIC=XLATC/CONV                                                         XYLL.49
         PSI=PSI1/CONV                                                           XYLL.50
         XX=(X-FLOAT(JMAX+1)/2.)* DS                                             XYLL.51
         IF (PHIC.GT.0.) THEN
         YY=-A/XN*SIN(PI/2.-PHIC)*                                               XYLL.52
     *      (  (1.+COS(PI/2.-PSI)) / (1.+COS(PI/2.-PHIC))  )**XN +               XYLL.53
     *      (Y-FLOAT(IMAX+1)/2.)* DS                                             XYLL.54
         ELSE
         YY=-A/XN*SIN(-PI/2.-PHIC)*
     *      (  (1.+COS(-PI/2.-PSI)) / (1.+COS(-PI/2.-PHIC))  )**XN +
     *      (Y-FLOAT(IMAX+1)/2.)* DS
         END IF
         C1=1./A * SQRT(XX**2 + YY**2) *                                         XYLL.55
     *      (  1./(1. + COS(PI/2.-PSI)))                                         XYLL.56
         XLAT=PI/2. - 2.*ATAN(C1)                                                XYLL.57
         XLON=LAMC+ 1./XN * ATAN2(XX,-YY)                                        XYLL.58
         XLAT=XLAT*CONV                                                          XYLL.59
         XLON=XLON*CONV                                                          XYLL.60
C                                                                                XYLL.61
      ELSE IF(KPROJ.EQ.3) THEN  ! MERCATOR                                       XYLL.62
         PHI1 = 0.0                                                              XYLL.63
         PHI1 = PHI1/CONV                                                        XYLL.64
         C2   = A*COS(PHI1)                                                      XYLL.65
         PHICTR=XLATC/CONV                                                       XYLL.66
         XCNTR= 0.0                                                              XYLL.67
         CELL = COS(PHICTR)/(1.0+SIN(PHICTR))                                    XYLL.68
         YCNTR= -C2*ALOG(CELL)                                                   XYLL.69
         XX   = (X-CENTRJ)*DS                                                    XYLL.70
         YY   = (Y-CENTRI)*DS+YCNTR                                              XYLL.71
         XLON = XLONC + ((XX - XCNTR)/C2) * CONV                                 XYLL.72
         CELL = EXP(YY/C2)                                                       XYLL.73
         XLAT = 2.0*(CONV*ATAN(CELL)) - 90.                                      XYLL.74
C                                                                                XYLL.75
      ENDIF                                                                      XYLL.76
C                                                                                XYLL.77
      RETURN                                                                     XYLL.78
      END                                                                        XYLL.79
