!------------------------------------------------------------------------------
SUBROUTINE proc_final_analysis ( unit , filename , &
bhid , bhrd , bhicd , bhrcd , &
t , u , v , h , rh , &
terrain , land_use , map_factor_x , map_factor_d , coriolis , &
latitude_x , longitude_x , latitude_d , longitude_d , &
snow_cover , slp_d , slp_x , sst , tobbox , &
pressure , ptop , &
iew_alloc , jns_alloc , kbu_alloc , iewd , jnsd , & 
print_header , print_analysis , & 
current_date_8 , current_time_6 , fdda_loop , &
icount , total_count , interval , &
max_error_t , max_error_uv           , &
max_error_z , max_error_p , &
buddy_weight , start_date )

!  This routine is a driver for the required utilities to output the 
!  final analysis of this program.  The input values are the objectively 
!  analyzed data (the met fields) and the constant values (terrestrial
!  fields).  

   USE final_analysis
   USE observation

   IMPLICIT NONE 

   INTEGER                , INTENT ( IN )   :: unit
   CHARACTER *(*)         , INTENT ( IN )   :: filename
   INTEGER                , INTENT ( INOUT ) , &
   DIMENSION (50,20)                        :: bhid
   REAL                   , INTENT ( INOUT ) , &
   DIMENSION (20,20)                        :: bhrd
   CHARACTER ( LEN = 80 ) , INTENT ( INOUT ) , &
   DIMENSION (50,20)                        :: bhicd
   CHARACTER ( LEN = 80 ) , INTENT ( INOUT ) , &
   DIMENSION (20,20)                        :: bhrcd
   LOGICAL                                  :: print_header , &
                                               print_analysis
   INTEGER                                  :: current_date_8 , &
                                               current_time_6 , &
                                               fdda_loop
   INTEGER                                  :: icount , total_count , &
                                               interval
   REAL                                     :: max_error_t  , &
                                               max_error_uv , &
                                               max_error_z  , &
                                               max_error_p  , &
                                               buddy_weight
   CHARACTER (LEN=19)                       :: start_date
   CHARACTER (LEN=24)                       :: fdda_date_24
   INTEGER , SAVE                           :: interval_analysis

   !  Temporary holding arrays for the header information.  What is in the header
   !  on input is the data from the first guess file.  To output the data, we need
   !  to store the final analysis header in the bhi, bhr, bhic, bhrc arrays.  So that
   !  we do not clobber the input data, we use this temporary storage.  

   INTEGER                , DIMENSION (50,20) :: bhi_hold
   REAL                   , DIMENSION (20,20) :: bhr_hold
   CHARACTER ( LEN = 80 ) , DIMENSION (50,20) :: bhic_hold
   CHARACTER ( LEN = 80 ) , DIMENSION (20,20) :: bhrc_hold

   !  Temporary date integers

   INTEGER :: yy , mm , dd , hh , date8, time6

   !  The size of the data to be processed.

   INCLUDE 'first_guess_size.inc'
   INCLUDE 'first_guess.inc'
   INCLUDE 'proc_get_info_header.inc'
   REAL , DIMENSION(jns_alloc,iew_alloc)    :: tobbox

   INTERFACE
      INCLUDE 'proc_get_info_header.int'
      INCLUDE 'sample.int'
   END INTERFACE
   
   !  The record header is initialized with the call to this
   !  routine.  That data is assigned to these arrays that
   !  are accessible from a COMMON block in the proc_get_info_header
   !  routine.  

   INCLUDE 'header.common'

   !  Save the headers!

   bhi_hold  = bhi
   bhr_hold  = bhr
   bhic_hold = bhic
   bhrc_hold = bhrc

   !  Since this routine is called repeatedly by time, we
   !  only OPEN the file the first time with a particular UNIT number.
   !  Output the big header if this is the first time in here.

   IF      ( ( icount .EQ. 1 ) .AND. ( fdda_loop .EQ. 1 ) ) THEN
      CALL open_final_analysis ( unit , bhi(13,1) ) 
      CALL write_big_header ( unit , bhi , bhr , bhic , bhrc , start_date , kbu_alloc , interval , &
                              max_error_t , max_error_uv , max_error_p , buddy_weight )
      interval_analysis = interval
   ELSE IF ( ( icount .EQ. 1 ) .AND. ( fdda_loop .EQ. 2 ) ) THEN
      CALL open_final_analysis_fdda ( unit+1 , bhi(13,1) ) 
      CALL write_big_header_fdda ( unit+1 , bhi , bhr , bhic , bhrc , start_date , kbu_alloc , interval , &
                              max_error_t , max_error_uv , max_error_p , buddy_weight , interval_analysis )
   END IF

   !  Now that the record header is modified, we put the data into 
   !  these storage locations, which are the common variables.  This
   !  allows them to be used to print out information from the
   !  record header from the proc_get_info_header routine.

   bhi  = bhid
   bhr  = bhrd
   bhic = bhicd
   bhrc = bhrcd

   IF      ( fdda_loop .EQ. 1 ) THEN

      !  Put pressure values back on to Pa.

      slp_x(:jns_alloc-1,:iew_alloc-1) = slp_x(:jns_alloc-1,:iew_alloc-1) * 100.
      slp_d = slp_d * 100.

      CALL write_analysis ( unit , &
      t , u , v , h , rh , &
      terrain , land_use , map_factor_x , map_factor_d , coriolis , &
      latitude_x , longitude_x , latitude_d , longitude_d , &
      snow_cover , slp_d , slp_x , sst , tobbox , &
      iew_alloc , jns_alloc , kbu_alloc , iewd , jnsd , print_analysis )
   ELSE
      CALL make_date ( current_date_8 , current_time_6 , fdda_date_24 )
      slp_x(:jns_alloc-1,:iew_alloc-1) = slp_x(:jns_alloc-1,:iew_alloc-1) * 100.
      CALL write_analysis_fdda ( unit+1 , &
      t , u , v , h , rh , &
      terrain , slp_x , tobbox , pressure , &
      iew_alloc , jns_alloc , kbu_alloc , iewd , jnsd , fdda_date_24 , ptop )
   END IF

   !  With all of the final analysis contained here, we can print
   !  out some data.

   IF      ( fdda_loop .EQ. 1 ) THEN
      CALL proc_get_info_header ( print_header , program , &
      iewc , jnsc , map_projection , expanded , iewe , jnse , &
      dxc , lat_center , lon_center , cone_factor , true_lat1 , true_lat2 , pole , &
      domain_id , mother_id , nest_level , &
      iewd , jnsd , iew_startm , jns_startm , &
      ratio_wrt_coarse , ratio_wrt_mother , &
      dxd , xew_startc , yns_startc , &
      kbu , &
      ptop )
   END IF

   !  Now that we have all of this data input, we can do a fast run
   !  through of the values.

   IF ( ( print_analysis ) .AND. ( fdda_loop .EQ. 1 ) ) THEN

      CALL sample ( 'T       ' , field3=t            , &
      iewd=iew_alloc , jnsd=jns_alloc , kbu=kbu_alloc , crsdot=1 )
      CALL sample ( 'U       ' , field3=u            , &
      iewd=iew_alloc , jnsd=jns_alloc , kbu=kbu_alloc , crsdot=0 )
      CALL sample ( 'V       ' , field3=v            , &
      iewd=iew_alloc , jnsd=jns_alloc , kbu=kbu_alloc , crsdot=0 )
      CALL sample ( 'H       ' , field3=h            , &
      iewd=iew_alloc , jnsd=jns_alloc , kbu=kbu_alloc , crsdot=1 )
      CALL sample ( 'RH      ' , field3=rh           , &
      iewd=iew_alloc , jnsd=jns_alloc , kbu=kbu_alloc , crsdot=1 )
   
      CALL sample ( 'TERRAIN ' , field2=terrain      , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=1 )
      CALL sample ( 'LAND USE' , field2=land_use     , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=1 )
      CALL sample ( 'MAPFACRS' , field2=map_factor_x , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=1 )
      CALL sample ( 'MAPFACDT' , field2=map_factor_d , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=0 )
      CALL sample ( 'CORIOLIS' , field2=coriolis     , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=0 )
      CALL sample ( 'LATITCRS' , field2=latitude_x   , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=1 )
      CALL sample ( 'LONGICRS' , field2=longitude_x  , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=1 )
      CALL sample ( 'LATITDOT' , field2=latitude_d   , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=0 )
      CALL sample ( 'LONGIDOT' , field2=longitude_d  , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=0 )
      CALL sample ( 'SNOWCOVR' , field2=snow_cover   , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=1 )
      CALL sample ( 'PSEALVLD' , field2=slp_d        , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=0 )
      CALL sample ( 'PSEALVLC' , field2=slp_x        , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=1 )
      CALL sample ( 'TSEASFC ' , field2=sst          , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=1 )
      CALL sample ( 'TOBBOX  ' , field2=tobbox       , &
      iewd=iew_alloc , jnsd=jns_alloc ,                 crsdot=1 )
   END IF

   !  Restore the headers!

   bhi  = bhi_hold  
   bhr  = bhr_hold 
   bhic = bhic_hold
   bhrc = bhrc_hold

END SUBROUTINE proc_final_analysis
