!------------------------------------------------------------------------------
SUBROUTINE proc_header ( unit , filename , bhid , bhrd , bhicd , bhrcd , nml )

!  This routine processes the modeling system record header on input.

   USE header
   USE namelist

   IMPLICIT NONE

   INTEGER                , INTENT ( IN )       :: unit
   CHARACTER ( LEN = 132 ) ,INTENT ( IN )       :: filename
   INTEGER                , INTENT (OUT ) , &
                            DIMENSION (50,20)   :: bhid
   REAL                   , INTENT (OUT ) , &
                            DIMENSION (20,20)   :: bhrd
   CHARACTER ( LEN = 80 ) , INTENT (OUT ) ,  &
                            DIMENSION (50,20)   :: bhicd
   CHARACTER ( LEN = 80 ) , INTENT (OUT ) ,  &
                            DIMENSION (20,20)   :: bhrcd
   TYPE ( all_nml ) , INTENT ( IN )             :: nml

   !  The record header is initialized with the call to this
   !  routine.  That data is assigned to these arrays that
   !  are accessible from a COMMON block in the proc_get_info_header
   !  routine.  

   INCLUDE 'header.common'

   !  OPEN the record header file.

   CALL open_header ( unit , filename ) 

   !  Read in the record header.

   CALL read_header ( unit , bhid , bhrd , bhicd , bhrcd ) 

   !  Check the record header against itself.

   CALL self_check_header ( bhid , bhrd , bhicd , bhrcd ) 

   !  Check the record header against the NAMELIST for
   !  inconsistencies.
   
   CALL nml_check_header ( nml , bhid , bhrd , bhicd , bhrcd ) 

   !  We need this data to be rewound for the processing of the data after 
   !  the record header, so CLOSE it up.

   CLOSE ( unit )

   !  The reason to put the header data in COMMON is if it happens to be filled!

   bhi  = bhid
   bhr  = bhrd
   bhic = bhicd
   bhrc = bhrcd

END SUBROUTINE proc_header
