!------------------------------------------------------------------------------

!  This module processess the big header record.

MODULE header

   USE header_flags


CONTAINS

!------------------------------------------------------------------------------

SUBROUTINE nml_check_header ( nml , bhi , bhr , bhic , bhrc )

!  This routine compares the record header data with the information
!  provided through the NAMELIST.

   USE namelist

   IMPLICIT NONE

   INTEGER                , DIMENSION (50,20)   :: bhi
   REAL                   , DIMENSION (20,20)   :: bhr
   CHARACTER ( LEN = 80 ) , DIMENSION (50,20)   :: bhic
   CHARACTER ( LEN = 80 ) , DIMENSION (20,20)   :: bhrc
   TYPE ( all_nml ) , INTENT ( IN )             :: nml

   CHARACTER ( LEN = 19 )                       :: the_date

   INCLUDE 'error.inc'

   INTERFACE
      INCLUDE 'error.int'
   END INTERFACE

   !  Build a 19 character date YYYY-MM-DD_HH:mm:ss from the record header
   !  current date.

   WRITE ( the_date , FMT = '(I4.4,"-",I2.2,"-",I2.2,"_",I2.2,":",I2.2,":00")' ) &
   bhi(5,bhi(1,1)) , bhi(6,bhi(1,1)) , bhi(7,bhi(1,1)) , bhi(8,bhi(1,1)) , bhi(9,bhi(1,1))

   test_002: IF ( the_date .LT. nml%record_1%start_date ) THEN
      error_number = 00242002
      error_message(1:31) = 'nml_check_header               '
      error_message(32:)  = ' Specified bounding dates in NAMELIST is after the initial &
      &time period in record header: ' // the_date // '.'
      fatal = .false.
      listing = .false.
      CALL error_handler ( error_number , error_message ,  &
      fatal , listing )
   END IF test_002

   !  003:  Is the data included in input file after the last
   !  time from the NAMELIST.

   test_003: IF ( the_date .GT. nml%record_1%end_date   ) THEN   
      error_number = 00242003
      error_message(1:31) = 'nml_check_header               '
      error_message(32:)  = ' Specified bounding dates in NAMELIST is prior to the initial &
      &time period in record header: ' // the_date // '.'
      fatal = .true.
      listing = .false.
      CALL error_handler ( error_number , error_message ,  &
      fatal , listing )
   END IF test_003

END SUBROUTINE nml_check_header

!------------------------------------------------------------------------------

SUBROUTINE open_header ( unit , filename ) 

!  This routine OPENs the record header file

   IMPLICIT NONE

   INTEGER                 :: unit
   CHARACTER ( LEN = 132 ) :: filename

   INCLUDE 'error.inc'

   INTERFACE
      INCLUDE 'error.int'
   END INTERFACE

   OPEN ( UNIT   = unit          , &
          FILE   = filename      , &
          ACCESS = 'SEQUENTIAL'  , &
          STATUS = 'OLD'         , &
          FORM   = 'UNFORMATTED' , &
          IOSTAT = error_number      )
   IF ( error_number .NE. 0 ) THEN
      error_number = error_number + 00021000
      error_message(1:31) = 'open_header                    '
      error_message(32:)  = ' Error OPENing record header file.'
      fatal = .true.
      listing = .false.
      CALL error_handler ( error_number , error_message , &
      fatal , listing )
   END IF

END SUBROUTINE open_header

!------------------------------------------------------------------------------

SUBROUTINE read_header ( unit , bhi , bhr , bhic , bhrc )

!  Program 0.22

!  This routine processes the modeling system record header on input.

   IMPLICIT NONE

   INTEGER                                      :: unit

   INTEGER                , DIMENSION (50,20)   :: bhi
   REAL                   , DIMENSION (20,20)   :: bhr
   CHARACTER ( LEN = 80 ) , DIMENSION (50,20)   :: bhic
   CHARACTER ( LEN = 80 ) , DIMENSION (20,20)   :: bhrc

   INCLUDE 'error.inc'

   INTERFACE
      INCLUDE 'error.int'
   END INTERFACE

   READ ( UNIT = unit , IOSTAT = error_number ) flag

   !  Was there an error on the flag read.  If so, then process the error.

   IF ( error_number .NE. 0 ) THEN
      error_number = error_number + 00022000
      error_message(1:31) = 'read_header                    '
      error_message(32:)  = ' Error in big record header flag read'
      fatal = .true.
      listing = .false.
      CALL error_handler ( error_number , error_message ,  &
      fatal , listing )
   ELSE IF ( flag .eq. bh_flag ) THEN
      WRITE ( UNIT = * , FMT = * ) 'Big record header flag successfully input.'
   ELSE
      error_number = 00022100
      error_message(1:31) = 'read_header                    '
      error_message(32:)  = ' Wrong flag value input'
      fatal = .true.
      listing = .false.
      CALL error_handler ( error_number , error_message ,  &
      fatal , listing )
   END IF

   READ ( UNIT = unit , IOSTAT = error_number ) bhi , bhr , bhic , bhrc

   !  Was there an error on the read.  If so, then process the error.

   IF ( error_number .NE. 0 ) THEN
      error_number = error_number + 00022000
      error_message(1:31) = 'read_header                    '
      error_message(32:)  = ' Error in big record header read'
      fatal = .true.
      listing = .false.
      CALL error_handler ( error_number , error_message ,  &
      fatal , listing )
   ELSE
      WRITE ( UNIT = * , FMT = * ) 'Big record header successfully input.'
   END IF 

END SUBROUTINE read_header

!------------------------------------------------------------------------------

SUBROUTINE self_check_header ( bhi , bhr , bhic , bhrc )

!  Program 0.23

!  This routine checks the record header data to be sure this file is
!  acceptable.

   IMPLICIT NONE

   INTEGER                , DIMENSION (50,20)   :: bhi
   REAL                   , DIMENSION (20,20)   :: bhr
   CHARACTER ( LEN = 80 ) , DIMENSION (50,20)   :: bhic
   CHARACTER ( LEN = 80 ) , DIMENSION (20,20)   :: bhrc

   INCLUDE 'error.inc'

   INTERFACE
      INCLUDE 'error.int'
   END INTERFACE

   !  001:  Is this a reasonable data set to ingest by this program.

   test_001: IF (( bhi(1,1) .NE. 2 ) .AND. &
                 ( bhi(1,1) .NE. 3 ) .AND. &
                 ( bhi(1,1) .NE. 8 )) THEN
      error_number = 00023001
      error_message(1:31) = 'self_check_header              '
      error_message(32:)  = ' Wrong data ingested. ' // TRIM ( bhic(1,1) )
      fatal = .true.
      listing = .false.
      CALL error_handler ( error_number , error_message ,  &
      fatal , listing )
   END IF test_001

   !  002:  Is the record header date valid.
   
   test_002 : IF ( ( bhi( 5,bhi(1,1)) .LT. 0 ) .OR. &
                   ( bhi( 6,bhi(1,1)) .LT. 0 ) .OR. &
                   ( bhi( 7,bhi(1,1)) .LT. 0 ) .OR. &
                   ( bhi( 8,bhi(1,1)) .LT. 0 ) .OR. &
                   ( bhi( 9,bhi(1,1)) .LT. 0 ) .OR. &
                   ( bhi(10,bhi(1,1)) .LT. 0 ) .OR. &
                   ( bhi(11,bhi(1,1)) .LT. 0 ) ) THEN
      error_number = 00023001
      error_message(1:31) = 'self_check_header              '
      error_message(32:)  = ' Wrong date ingested, it is negative.'
      fatal = .true.
      listing = .false.
      CALL error_handler ( error_number , error_message ,  &
      fatal , listing )
   END IF test_002

END SUBROUTINE self_check_header

!------------------------------------------------------------------------------

END MODULE header
