!------------------------------------------------------------------------------
PROGRAM main

!  This program starts with a background analysis, and performs
!  an objective analysis with available observations.  The quality
!  control procedure on the observations makes them suitable for inclusion
!  into data assimilation schemes.  

   USE namelist
   USE date_pack
   USE input_data

   IMPLICIT NONE
 
   INCLUDE 'error.inc'

   INCLUDE 'big_header.inc'

   TYPE ( all_nml )  :: nml ! all NAMELIST information from all NAMELIST records
   CHARACTER ( LEN = 132 ) :: filename
   INTEGER                 :: unit

   INTERFACE

      SUBROUTINE proc_namelist ( unit , filename , nml )
         USE namelist
         INTEGER , INTENT ( IN )           :: unit
         CHARACTER *(*) , INTENT ( IN )    :: filename
         TYPE ( all_nml ) , INTENT ( OUT ) :: nml
      END SUBROUTINE proc_namelist

      INCLUDE 'proc_header.int'

      SUBROUTINE driver ( unit , filename , &
      bhi , bhr , bhic , bhrc , nml , &
      iew_alloc , jns_alloc, kbu_alloc , &
      current_date_8 , current_time_6 , date_char , icount , total_count )
         USE namelist
         CHARACTER ( LEN = 132 ), INTENT ( IN ) &
                                          :: filename
         INTEGER                , INTENT ( IN ) &
                                          :: unit
         INTEGER                , INTENT ( INOUT ) , &
         DIMENSION (50,20)                :: bhi
         REAL                   , INTENT ( INOUT ) , &
         DIMENSION (20,20)                :: bhr
         CHARACTER ( LEN = 80 ) , INTENT ( INOUT ) , &
         DIMENSION (50,20)                :: bhic
         CHARACTER ( LEN = 80 ) , INTENT ( INOUT ) , &
         DIMENSION (20,20)                :: bhrc
         TYPE ( all_nml ) , INTENT (IN )  :: nml
         INTEGER , INTENT ( IN )          :: iew_alloc , &
                                             jns_alloc , &
                                             kbu_alloc
         INTEGER , INTENT ( IN )          :: current_date_8 , & 
                                             current_time_6 , &
                                             icount , total_count
         CHARACTER (LEN=19) , INTENT(IN)  :: date_char
      END SUBROUTINE driver

      INCLUDE 'error.int'
 
      INCLUDE 'proc_get_info_header.int'

   END INTERFACE

   INTEGER                                :: iew_alloc , &
                                             jns_alloc , &
                                             kbu_alloc

   INTEGER                                :: iewe_dummy , &
                                             jnse_dummy , &
                                             iewd_dummy , &
                                             jnsd_dummy , &
                                             expanded_dummy , &
                                             program_dummy , &
                                             nest_level_dummy

   INTEGER                                :: icount , &
                                             total_count    , &
                                             current_date_8 , & 
                                             current_time_6

   CHARACTER (LEN=19)                     :: current_date , next_date
   INTEGER                                :: century_year , &
                                             month , &
                                             day , &
                                             hour , &
                                             minute , &
                                             second , &
                                             interval
#ifdef NCARG
call opngks
#endif

   !  Present the user with the program name, program initialization time.
   !  There are no common values or module values set here, this routine is
   !  very tame, really just some print out.

   CALL proc_intro

   !  Read in the NAMELIST information.  This file is connected to the given
   !  unit number and compile-time name.  All error processing on the 
   !  NAMELIST data are handled by this routine (all simple errors that allow
   !  consistency checks, etc).  The namelist MODULE is required for the nml
   !  data TYPE.  The NAMELIST file is CLOSEd during the routine, and the
   !  nml structure is filled.

   unit = 7
   filename = 'namelist.input'
   CALL proc_namelist ( unit , filename , nml )

   !  Now that the NAMELIST has been input, the other source of initial
   !  data is from the record header.  This file provides the information
   !  concerning the specific anlaysis data to be ingested.  This file is
   !  the same as the analysis file to be used later, so this routine CLOSEs
   !  the file after the initial time of the record header is input.  The
   !  NAMELIST structure is passed for error checking purposes.

   unit = 8
   filename = nml%record_2%fg_filename
   CALL proc_header ( unit , filename , bhi , bhr , bhic , bhrc , nml )

   !  Initialize the domain size constants, pass them through to the 
   !  driver routine to allow the data arrays to be allocated.

   CALL proc_get_info_header ( nml%record_5%print_header , program=program_dummy , &
   expanded=expanded_dummy , nest_level=nest_level_dummy , &
   iewe=iewe_dummy , jnse=jnse_dummy ,  &
   iewd=iewd_dummy , jnsd=jnsd_dummy ,  &
   kbu=kbu_alloc )

   !  Depending on the values of these domain parameters, we need to set the
   !  2D and 3D arrays to different choices.  If this is REGRID input, and if
   !  REGRID used the expanded option, and if this is the most coarse grid, then
   !  we have to use the expanded size for the I and J dimensions.  If any of these
   !  conditions is false, then we use the domain size as the I and J dimensions.

   IF ( ( program_dummy .EQ. 2 ) .AND. ( expanded_dummy .EQ. 1 ) .AND. ( nest_level_dummy .EQ. 0 ) ) THEN
      iew_alloc = iewe_dummy
      jns_alloc = jnse_dummy
   ELSE
      iew_alloc = iewd_dummy
      jns_alloc = jnsd_dummy
   END IF

   !  Compute the time perids that are to be processed.  This is specified
   !  in the NAMELIST.  The two dates are 19 digit long character strings
   !  of the form YYYY-MM-DD_HH:mm:ss, where:
   !   YYYY = year (1900 - 2099 are valid)
   !     MM = month of the year (01-12)
   !     DD = day of the month (01-31)
   !     HH = UTC hour of the day (00-23)
   !     mm = minute of the hour (00-59)
   !     ss = second of the minute (00-59)
   !  The time interval between the starting and ending times is an integer
   !  specified in seconds.

   interval = nml%record_1%interval
   current_date = nml%record_1%start_date

   CALL geth_newdate ( next_date , current_date , interval )
   
   !  With the starting and ending time, print out the time periods this 
   !  program will process.

   IF ( nml%record_7%f4d) THEN
      WRITE ( UNIT = * , FMT = * ) '3d analysis dates to be processed by this program (excluding SFC FDDA times):'
   ELSE
      WRITE ( UNIT = * , FMT = * ) 'Dates to be processed by this program:'
   END IF

   total_count = 0
   time_loop_1 : DO 

      !  Print out the loop counter increment and the computed date.

      total_count = total_count + 1 
      WRITE ( UNIT = * , FMT = '("      Time period #",i5.5," is for date ",A)' ) &
      total_count , current_date

      !  The next date is the current date plus a time interval.

      CALL geth_newdate ( next_date , current_date , interval )
      current_date = next_date

      !  Exit the loop if we have passed the last requested time period.  Exit with
      !  a fatal error if the NAMELIST request too many time periods (this is
      !  probably a mistake in setting up the NAMELIST).

      IF ( next_date .GT. nml%record_1%end_date ) THEN
         EXIT time_loop_1
      ELSE IF ( total_count .GT. max_times ) THEN
         error_number        = 1
         error_message(1:31) = 'main                           '
         error_message(32:)  = ' Too many time periods for processing have been specified.'
         fatal               = .TRUE.
         listing             = .TRUE.
         CALL error_handler ( error_number , error_message ,  &
         fatal , listing )
      END IF
   END DO time_loop_1

   !  ALLOCATE space for the temporary holders for the 3d, 2d and the 1d
   !  data.  Each of these has a large array space associated with it,
   !  but since we are not ALLOCATing that really big stuff, this is
   !  not a problem.   

   ALLOCATE ( all_3d( 20,2) )
   ALLOCATE ( all_2d(100,2) )
   ALLOCATE ( all_1d( 10) )

   !  Pass all of the data from the NAMELIST and record header to the
   !  driver routine.  Pick off the first guess field and the logical unit
   !  number.  Re-initialize the current date to the first time period
   !  requested.

   unit = 9
   filename = nml%record_2%fg_filename 
   icount = 0

   current_date = nml%record_1%start_date

   time_loop_2 : DO

      !  Which time period are we processing.

      icount = icount + 1 

      !  Set up the counting for the large arrays for FDDA.  Instead of copying
      !  arrays around, we are just going to change the last index and effectively
      !  just change the variable pointers.

      IF ( nml%record_7%f4d ) THEN
         IF       ( icount      .EQ. 1      ) THEN
            first_time  = 1
            second_time = 2
            initial_time = .TRUE.
         ELSE IF  ( icount      .EQ. 2      ) THEN
            first_time  = 1
            second_time = 2
            initial_time = .FALSE.
         ELSE IF ( (icount/2)*2 .NE. icount ) THEN
            first_time  = 2
            second_time = 1
         ELSE IF ( (icount/2)*2 .EQ. icount ) THEN
            first_time  = 1
            second_time = 2
         END IF
      ELSE IF ( .NOT. nml%record_7%f4d ) THEN
         first_time  = 1
         second_time = 1
         initial_time = .TRUE.
      END IF
     

      !  Compute the integer date (YYYYMMDD) and the integer time (HHmmss).

      CALL split_date_char ( current_date , century_year , month , day , hour , minute , second )

      current_date_8 = century_year * 10000 + month  * 100 + day
      current_time_6 = hour         * 10000 + minute * 100 + second

      !  This routine is called once for each time period to be processed.  This
      !  is the main driver routine for the program.

      CALL driver ( unit , filename , & 
      bhi , bhr , bhic , bhrc , nml  , &
      iew_alloc , jns_alloc , kbu_alloc , &
      current_date_8 , current_time_6 , current_date, icount , total_count )

      !  Increment to the next time and check if we should try to process the
      !  data at that time.  The only way to not process the data is if we have
      !  gone past the requested ending time.
     
      CALL geth_newdate ( next_date , current_date , interval )
      current_date = next_date

      IF ( current_date .GT. nml%record_1%end_date ) THEN
         EXIT time_loop_2
      END IF

   END DO time_loop_2

   WRITE ( UNIT = * , FMT = '("STOP 99999")' )
#ifdef NCARG
call clsgks
#endif

END PROGRAM main 
