!-------------------------------------------------------------------------------
SUBROUTINE proc_first_guess ( unit , filename , &
bhi , bhr , bhic , bhrc , &
num3d , num2d , num1d , &
t , u , v , h , rh , &
terrain , land_use , map_factor_x , map_factor_d , coriolis , &
latitude_x , longitude_x , latitude_d , longitude_d , &
snow_cover , slp_d , slp_x , sst , &
iew_alloc , jns_alloc , kbu_alloc , pressure , &
print_analysis , &
current_date_8 , current_time_6 , icount )

!  This routine processes the modeling system first guess data.  This data is
!  typically:
!  1) interpolated from a global analysis (NMC , ECMWF)
!  2) interpolated from a global model (MRF, AVN)
!  3) from a previous mesoscale model forecast (ETA)

   USE input_data
   USE first_guess

   IMPLICIT NONE

   INTEGER                , INTENT ( IN )           :: unit
   CHARACTER ( LEN = 132 ) ,INTENT ( IN )           :: filename
   INTEGER                , INTENT ( OUT )          :: num3d , &
                                                       num2d , &
                                                       num1d
   INTEGER                , INTENT ( IN )           :: iew_alloc  , &
                                                       jns_alloc  , &
                                                       kbu_alloc

   REAL, INTENT ( OUT ) , DIMENSION(kbu_alloc)      :: pressure

   REAL, INTENT ( OUT ) , DIMENSION(jns_alloc,iew_alloc,kbu_alloc) &
                                                    :: t  , &
                                                       u  , &
                                                       v  , &
                                                       h  , &
                                                       rh

   REAL , INTENT ( OUT ) , DIMENSION(jns_alloc,iew_alloc)  &
                                                    :: terrain      , &
                                                       land_use     , &
                                                       map_factor_x , &
                                                       map_factor_d , &
                                                       coriolis     , &
                                                       latitude_x   , &
                                                       longitude_x  , &
                                                       latitude_d   , &
                                                       longitude_d  , &
                                                       snow_cover   , &
                                                       slp_d        , &
                                                       slp_x        , &
                                                       sst

   LOGICAL                                          :: print_analysis

   INTEGER , INTENT ( IN )                          :: current_date_8 , & 
                                                       current_time_6 , & 
                                                       icount

   INTEGER                                          :: loop , icd

   INCLUDE 'big_header.inc'

   INTERFACE
      INCLUDE 'sample.int'
   END INTERFACE

   !  We need to keep track of where we are sticking the data for the FDDA option.

   IF ( initial_time ) THEN
      tt = first_time
   ELSE
      tt = second_time
   END IF

   !  OPEN the analysis file when this is the first time loop.

   IF ( icount .EQ. 1 ) THEN
      CALL open_first_guess ( unit , filename ) 
   END IF

   !  Read in the analysis data for this time period.

   CALL read_first_guess ( unit , &
   bhi , bhr , bhic , bhrc , &
   num3d , num2d , num1d , &
   t , u , v , h , rh , &
   terrain , land_use , map_factor_x , map_factor_d , coriolis , &
   latitude_x , longitude_x , latitude_d , longitude_d , &
   snow_cover , slp_d , slp_x , sst , &
   pressure , &
   iew_alloc , jns_alloc , kbu_alloc , & 
   current_date_8 , current_time_6 , icount , print_analysis ) 

   !  Now that we have all of this data input, we can do a fast run
   !  through of the values.

   IF ( print_analysis ) THEN

      three_d : DO loop = 1 , num3d
         IF      ( all_3d(loop,tt)%small_header%staggering(1:1) .EQ. 'D' ) THEN
            icd = 0
         ELSE IF ( all_3d(loop,tt)%small_header%staggering(1:1) .EQ. 'C' ) THEN
            icd = 1
         END IF
         CALL sample ( all_3d(loop,tt)%small_header%name(1:8) , field3=all_3d(loop,tt)%array , &
                       iewd=iew_alloc , jnsd=jns_alloc , kbu=kbu_alloc , crsdot=icd )
      END DO three_d

      two_d : DO loop = 1 , num2d
         IF      ( all_2d(loop,tt)%small_header%staggering(1:1) .EQ. 'D' ) THEN
            icd = 0
         ELSE IF ( all_2d(loop,tt)%small_header%staggering(1:1) .EQ. 'C' ) THEN
            icd = 1
         END IF
         CALL sample ( all_2d(loop,tt)%small_header%name(1:8) , field2=all_2d(loop,tt)%array , &
                       iewd=iew_alloc , jnsd=jns_alloc , crsdot=icd )
      END DO two_d
   
   END IF

END SUBROUTINE proc_first_guess
