#!/bin/csh

# "infilename" is the input file to the MM5toGrADS program
#  (include full path if file is not in current directory)
#
# "outfilename" is the name of the output from the MM5toGrADS program
#  (include full path if you do not want the files to be placed in
#   current directory)
# outfilename will be used for both the .ctl and .dat file
# In the case below the files test.ctl and test.dat will be created


set infilename = "/home/MM5_v35/MM5/Run/MMOUT_DOMAIN1"
set outfilename = "test"


###############################################################
###############################################################
#####                                                     #####
#####             END OF USER MODIFICATIONS               #####
#####                                                     #####
###############################################################
###############################################################

#------------------  SET THE SYMBOLIC LINKS  -----------------#
echo ....setting links to data....
echo dset ^${outfilename}.dat > ${outfilename}.ctl
rm -f fort.10
rm -f fort.80
rm -f fort.81
ln -s ${infilename} fort.10
ln -s ${outfilename}.dat fort.80
ln -s ${outfilename}.ctl fort.81
###assign -a ${outfilename}.dat -F null fort.80

#------------------  RUN THE PROGRAM  ------------------------#
echo ....running....
./grads.exe


#-----------------  CLEAN UP  --------------------------------#
rm -f fort.10
rm -f fort.80
rm -f fort.81
echo ....Program finished....
