      program grads
      implicit none

      integer :: mix,mjx,mkx, mrecl

      integer :: ifile,ofile
      parameter(ifile=10,ofile=80)   ! Unit numbers for input file and
                                     ! output file.

!  3d arrays
      real, dimension(:,:,:), allocatable :: u,v,t,qv,qc,qr,qi,qs,qg,    &
                                nci,pp,rtnd,tke,h,w,                     &
                                theta,thetae,dir,td,rh,prs,              &
                                dbz,div,vor,pv,tadv,z,dum3d
      integer, dimension(:,:,:), allocatable :: pk

!  2d arrays
      real, dimension(:,:), allocatable :: tg,rc,rn,ter,xmf,dmf,       &
                                  sc,ps,cor,tr,                        &
                                  xlat,xlon,lu,vgf,pblh,pblr,          &
                                  shf,lhf,ghf,ust,swd,lwd,sst,mav,     &
                                  st1,st2,st3,st4,st5,st6,             &
                                  sm1,sm2,sm3,sm4,sw1,sw2,sw3,sw4,     &
                                  swo,lwo,can,snh,snd,wsd,ssi,sro,uro, &
                                  t2m,q2m,u10,v10,alb,abb,asb,sif,     &
                                  psfc,cref,pslv,iclw,irnw,pwat,       &
                                  clfrlo,clfrmi,clfrhi,dum2d,          &
                                  dum2da,dum2db,dum2dc,dum2dd,dum2de

!  1d arrays
      real, dimension(:), allocatable :: sigma,pvals,dum1d

!  scratch arrays
      real, dimension(:,:), allocatable :: dumsfc
      real, dimension(100)    :: plev

!  header arrays and global variables
      integer, dimension(50,20) :: bhi
      real, dimension(20,20) :: bhr
      character(len=80), dimension(50,20) :: bhic
      character(len=80), dimension(20,20) :: bhrc
      integer flag,index,ndim
      integer, dimension(4) :: start_index,end_index
      real xtime
      character(len=4)  :: staggering,ordering
      character(len=24) :: current_date
      character(len=9)  :: name
      character(len=25) :: units
      character(len=46) :: description
      character(len=38) :: tdef 
      LOGICAL NEST
      integer stmon
      integer nplevs

!  some global constants

      real r,g,cp
      parameter(R=287.04, G=9.81, CP=1004.0)

!  misc.

      integer i,j,k,n,ierr,iallo
      integer timin,timax,nskip,iflinux,ifmap,ifsfc,ifskew,iskw,jskw,    &
              ztype
      integer ifu,ifv,ifw,ifpp,ift,ifq,ifclw,ifrnw,ifrtnd,ifz,iftke,     &
              ifice,ifsnow,ifgraup,ifnci,iftd,ifrh,ifth,ifthe,ifprs,     &
              ifvor,ifpv,ifdiv,ifdir,iftadv,ifdbz,ifh
      integer ifps,iftg,ifrc,ifrn,ifter,ifxmf,ifdmf,ifcor,iftr,          &
              ifxlat,ifxlon,iflu,ifvgf,ifsc,ifpblh,ifpblr,ifshf,iflhf,   &
              ifghf,ifust,ifswd,iflwd,ifsst,ifpslv,ifcref,               &
              ificlw,ifirnw,ifpwat,ifclfr,ifmav,                         &
              ifst1,ifst2,ifst3,ifst4,ifst5,ifst6,                       &
              ifsm1,ifsm2,ifsm3,ifsm4,ifsw1,ifsw2,ifsw3,ifsw4,           &
              ifswo,iflwo,ifcan,ifsnh,ifsnd,ifwsd,ifssi,ifsro,ifuro,     &
              ift2m,ifq2m,ifu10,ifv10,ifalb,ifabb,ifasb,ifsif
!Cb
      NAMELIST /RECORD1/  timin,timax,nskip,iflinux,ifmap,ifsfc,            &
                          ifskew,iskw,jskw,ztype,plev
      NAMELIST /RECORD10/ ifu,ifv,ifw,ifpp,ift,ifq,ifclw,ifrnw,ifrtnd,      &
                          ifz,iftke,ifice,ifsnow,ifgraup,ifnci
      NAMELIST /RECORD11/ iftd,ifrh,ifth,ifthe,ifprs,ifvor,ifpv,ifdiv,      &
                          ifdir,iftadv,ifdbz,ifh
      NAMELIST /RECORD12/ ifps,iftg,ifrc,ifrn,ifter,ifxmf,ifdmf,ifcor,      &
                          iftr,ifxlat,ifxlon,iflu,ifvgf,ifsc,ifpblh,ifpblr, &
                          ifshf,iflhf,ifghf,ifust,ifswd,iflwd,ifswo,iflwo,  &
                          ifsst,ifmav,ifst1,ifst2,ifst3,ifst4,ifst5,ifst6,  &
                          ifsm1,ifsm2,ifsm3,ifsm4,ifsw1,ifsw2,ifsw3,ifsw4,  &
                          ifcan,ifsnh,ifsnd,ifwsd,ifssi,ifsif,ifsro,ifuro,  &
                          ift2m,ifq2m,ifu10,ifv10,ifalb,ifabb,ifasb
      NAMELIST /RECORD13/ ifpslv,ifcref,ificlw,ifirnw,ifpwat,ifclfr
      integer unit_nml
      logical is_it_there
!CB
      integer il,jl,kl,ilx,jlx,klp1
      integer nout,nread,nwrite,irec
      integer iblt,iice,nestlev,ndt,maptype,nout2d,nout3d
      integer ix1,ix2,jx1,jx2,ka,kb,kc,ktot,nx,ny,navg,kfoo
      integer ipole,ilon,shem

      integer stat_u,stat_v,stat_w,stat_pp,stat_t,stat_qv,stat_qc,       &
              stat_qr,stat_rtnd,stat_tke,stat_qi,stat_qs,stat_qg,        &
              stat_nci,stat_h,stat_rh,stat_pslv

      real xlatc,xlonc,xn,ptop,dx,dx2inv,p00,ts0,tlp,ps0,phydro,sample,  &
           alatmax,alatmin,alonmax,alonmin,rlatinc,rloninc,              &
           centeri,centerj,clat,clon,bottomi,fleftj,aincavg

      character(len=3) :: cmon

      integer im,jm,itmp,iscan,jscan,nscan,iproj
      real rlat1,rlon1,orient,dy,hi,hj,dxs,dys,de,rerth,xp,yp,rpd,dr,pi
      real hfoo,lonref,dxnps

!  user-settable switches

!Cb  set all pressure levels to 0 before reading them in, to 
!    prevent NaN's in undefined pressure levels
     plev = 0.0
!CB

!Cb
      unit_nml = 9
      is_it_there = .FALSE.

	INQUIRE ( FILE = 'namelist.input' , EXIST = is_it_there )

      IF ( is_it_there ) THEN

         !  The file exists, get a unit number.

         OPEN ( FILE   = 'namelist.input' ,      &
                UNIT   =  unit_nml        ,      &
                STATUS = 'OLD'            ,      &
                FORM   = 'FORMATTED'      ,      &
                ACTION = 'READ'           ,      &
                ACCESS = 'SEQUENTIAL'     )
  
         !  File is opened, so read it.
  
         READ (unit_nml , NML = RECORD1 )
          WRITE (6    , NML = RECORD1 )
         READ (unit_nml , NML = RECORD10 )
          WRITE (6    , NML = RECORD10 )
         READ (unit_nml , NML = RECORD11 )
          WRITE (6    , NML = RECORD11 )
         READ (unit_nml , NML = RECORD12 )
          WRITE (6    , NML = RECORD12 )
         READ (unit_nml , NML = RECORD13 )
          WRITE (6    , NML = RECORD13 )
      ENDIF
!CB

!cccccccccccccccccccc  Let's Get Ready To Rumble!  cccccccccccccccccccc


      if(timax.eq.-99)then
        timax=99999999
      endif

      iallo=0

      stat_u=0
      stat_v=0
      stat_w=0
      stat_pp=0
      stat_t=0
      stat_qv=0
      stat_qc=0
      stat_qr=0
      stat_rtnd=0
      stat_tke=0
      stat_qi=0
      stat_qs=0
      stat_qg=0
      stat_nci=0
      stat_h=0
      stat_rh=0
      stat_pslv=0

      nread=0
      nwrite=0
      irec=1

      NOUT2D=IFPS+IFTG+IFRC+IFRN+IFTER+IFXMF+IFDMF+IFCOR+IFTR+         &
             IFXLAT+IFXLON+IFLU+IFVGF+IFSC+IFPBLH+IFPBLR+              &
             IFSHF+IFLHF+IFGHF+IFUST+IFSWD+IFLWD+IFSST+IFPSLV+         &
             IFCREF+IFICLW+IFIRNW+IFPWAT+IFCLFR+IFCLFR+IFCLFR+         &
             IFMAV+IFST1+IFST2+IFST3+IFST4+IFST5+IFST6+                &
             IFSM1+IFSM2+IFSM3+IFSM4+IFSW1+IFSW2+IFSW3+IFSW4+          &
             IFSWO+IFLWO+IFCAN+IFSNH+IFSND+IFWSD+IFSSI+IFSRO+IFURO+    &
             IFT2M+IFQ2M+IFU10+IFV10+IFALB+IFABB+IFASB+IFSIF
      NOUT3D=IFU+IFV+IFW+IFPP+IFT+IFQ+IFCLW+IFRNW+IFRTND+IFZ+IFH+      &
             IFTKE+IFICE+IFSNOW+IFGRAUP+IFNCI+IFTD+IFRH+IFTH+IFTHE+    &
             IFPRS+IFVOR+IFPV+IFDBZ+IFDIV+IFDIR+IFTADV
      print *
      print *,'You are requesting ',NOUT2D,' 2d variables and',        &
              NOUT3D,' 3d variables'

      if(ztype.eq.2)then
        print *
        print *,'data will be interpolated to pressure levels'
        nplevs=0
        do n=1,100
          if(plev(n).gt.1.0) nplevs=nplevs+1
        enddo
        print *,'  nplevs=',nplevs
      endif

      print *
      print *

!
!CCCCCCCCCCCCCC
! Read and interpret header information

  read(ifile,iostat=ierr)flag

  do while (ierr.eq.0)
  nout=0
  do while (nout.eq.0)
    nread=nread+1
    write(*,'("----- Reading output time = ",i5," -----")') nread
    do while (ierr.eq.0 .and. flag.ne.2)
      if(flag.eq.0)then
        print *
        print *,'Reading big header'
        read(ifile,iostat=ierr) bhi,bhr,bhic,bhrc
        index=bhi(1,1)
        if( index <= 2 .and. bhi(8,1) == 1 .and. bhi(15,1) == 0) then
          mix=bhi(9,1)
          mjx=bhi(10,1)
        else
          mix=bhi(16,1)
          mjx=bhi(17,1)
        endif
        if(index.eq.1)then
          mkx=1
        else
          mkx=bhi(12,index)
        endif
        print *,'  mix=',mix
        print *,'  mjx=',mjx
        print *,'  mkx=',mkx
        il=mix
        jl=mjx
        kl=mkx
        ilx=mix-1
        jlx=mjx-1
        klp1=mkx+1
        IBLT=bhi(4,13)
        XLATC=bhr(2,1)
        XLONC=bhr(3,1)
        xn=bhr(4,1)
        nestlev=bhi(15,1)
        ndt=nint(bhr(1,index)/60.)
        if ( index == 11 ) ndt=nint(bhr(4,12))
        ndt=ndt*NSKIP
        ndt=max0(ndt,1)
        ptop=bhr(2,2)
        dx=bhr(9,1)
        dx2inv=1.0/(2.0*dx)
        P00=bhr(2,5)
        TS0=bhr(3,5)
        TLP=bhr(4,5) 
        iice=bhi(18,index)
        maptype=bhi(7,1)
        if( ifmap.eq.0 )then
          print *,'   Not using any map projection'
        elseif(maptype.eq.1)then
          print *,'   Using Lambert conformal map projection'
          print *,'      note: GrADS interpolates to map for this ',     &
                     'projection'
        elseif(maptype.eq.2)then
          if(ifmap.eq.1 .and. bhr(2,1).lt.0.)then
            print *,'   Cannot do southern hemisphere polar ',           &
                 'stereographic map projection (yet)'
            print *,'   Not using any map projection'
            ifmap=0
          else
            print *,'   Using Polar Stereographic map projection'
            print *,'      note: GrADS interpolates to map for this ',   &
                       'projection'
          endif
        elseif(maptype.eq.3)then
          print *,'   Using Mercator map projection'
        endif 
        NEST=.FALSE.
        IF(nestlev.NE.0) NEST=.TRUE. 
        IF(INDEX.EQ.11 .OR. INDEX.EQ.5)THEN
          if(ztype.eq.1)then
            KA=mkx
            if(IFSFC.eq.1) then
              KB=mkx
              KTOT=1
            else
              KB=1
              KTOT=mkx
            endif
            KC=-1
          elseif(ztype.eq.2)then
            ka=1
            kb=nplevs
            kc=1
            ktot=nplevs
          endif
        ELSE
          KA=1
          KB=mkx
          KC=1
          ktot=mkx
        ENDIF
        print *,'Finished reading big header'
        print *
      elseif(flag.eq.1)then
        read(ifile,iostat=ierr)                                          &
          ndim,(start_index(i),i=1,4),(end_index(i),i=1,4),              &
          xtime,staggering,ordering,current_date,name,units,description
        sample=0.
        if(ordering.eq.'YXS ' .or. ordering.eq.'YXP ')then
          if(name(1:9).eq.'U        ')then
            if(iallo.eq.0) allocate(u(mix,mjx,mkx))
            read(ifile,iostat=ierr) u
            sample=u(1,1,kl)
            stat_u=1
          elseif(name(1:9).eq.'V        ')then
            if(iallo.eq.0) allocate(v(mix,mjx,mkx))
            read(ifile,iostat=ierr) v
            sample=v(1,1,kl)
            stat_v=1
          elseif(name(1:9).eq.'T        ')then
            if(iallo.eq.0) allocate(t(mix,mjx,mkx))
            read(ifile,iostat=ierr) t
            sample=t(1,1,kl) 
            stat_t=1
          elseif(name(1:9).eq.'Q        ')then
            if(iallo.eq.0) allocate(qv(mix,mjx,mkx))
            read(ifile,iostat=ierr) qv
            sample=qv(1,1,kl) 
            stat_qv=1
          elseif(name(1:9).eq.'CLW      ')then
            if(iallo.eq.0) allocate(qc(mix,mjx,mkx))
            read(ifile,iostat=ierr) qc
            sample=qc(1,1,kl) 
            stat_qc=1
          elseif(name(1:9).eq.'RNW      ')then
            if(iallo.eq.0) allocate(qr(mix,mjx,mkx))
            read(ifile,iostat=ierr) qr
            sample=qr(1,1,kl) 
            stat_qr=1
          elseif(name(1:9).eq.'RAD TEND ')then
            if(iallo.eq.0) allocate(rtnd(mix,mjx,mkx))
            read(ifile,iostat=ierr) rtnd
            sample=rtnd(1,1,kl) 
            stat_rtnd=1
          elseif(name(1:9).eq.'PP       ')then
            if(iallo.eq.0) allocate(pp(mix,mjx,mkx))
            read(ifile,iostat=ierr) pp
            sample=pp(1,1,kl) 
            stat_pp=1
          elseif(name(1:9).eq.'RH       ')then
            if(iallo.eq.0) allocate(rh(mix,mjx,mkx))
            read(ifile,iostat=ierr) rh
            sample=rh(1,1,kl)
            stat_rh=1
          elseif(name(1:9).eq.'H        ')then
            if(iallo.eq.0) allocate(h(mix,mjx,mkx))
            read(ifile,iostat=ierr) h
            sample=h(1,1,kl)
            stat_h=1
          elseif(name(1:9).eq.'ICE      ')then
            if(iallo.eq.0) allocate(qi(mix,mjx,mkx))
            read(ifile,iostat=ierr) qi
            sample=qi(1,1,kl)
            stat_qi=1
          elseif(name(1:9).eq.'SNOW     ')then
            if(iallo.eq.0) allocate(qs(mix,mjx,mkx))
            read(ifile,iostat=ierr) qs
            sample=qs(1,1,kl)
            stat_qs=1
          elseif(name(1:9).eq.'GRAUPEL  ')then
            if(iallo.eq.0) allocate(qg(mix,mjx,mkx))
            read(ifile,iostat=ierr) qg
            sample=qg(1,1,kl)
            stat_qg=1
          elseif(name(1:9).eq.'NCI      ')then
            if(iallo.eq.0) allocate(nci(mix,mjx,mkx))
            read(ifile,iostat=ierr) nci
            sample=nci(1,1,kl)
            stat_nci=1
          elseif(name(1:9).eq.'TKE      ')then
            if(iallo.eq.0) allocate(tke(end_index(1),end_index(2),end_index(3)))
            read(ifile,iostat=ierr) tke
            sample=tke(1,1,kl)
            stat_tke=1
          elseif(name(1:9).eq.'W        ')then
            if(iallo.eq.0) allocate(w(end_index(1),end_index(2),end_index(3)))
            read(ifile,iostat=ierr) w
            sample=w(1,1,kl)
            stat_w=1
          else
            allocate(dum3d(mix,mjx,mkx))
            read(ifile,iostat=ierr) dum3d
            sample=dum3d(1,1,kl)
            deallocate(dum3d)
          endif
        elseif(ordering.eq.'YXW ')then
          if(name.eq.'W        ')then
            if(iallo.eq.0) allocate(w(mix,mjx,mkx+1))
            read(ifile,iostat=ierr) w
            sample=w(1,1,kl)
            stat_w=1
          elseif(name(1:9).eq.'TKE      ')then
            if(iallo.eq.0) allocate(tke(mix,mjx,mkx+1))
            read(ifile,iostat=ierr) tke
            sample=tke(1,1,kl)
            stat_tke=1
          else
            allocate(dum3d(mix,mjx,mkx+1))
            read(ifile,iostat=ierr) dum3d
            sample=dum3d(i,i,kl)
            deallocate(dum3d)
          endif
        elseif(ordering.eq.'YX  ')then
          if(name.eq.'PSTARCRS ')then
            if(iallo.eq.0) allocate(ps(mix,mjx))
            read(ifile,iostat=ierr) ps
            sample=ps(1,1)
            if(iallo.eq.0) IFPS=IFPS+1
          elseif(name.eq.'GROUND T ')then
            if(iallo.eq.0) allocate(tg(mix,mjx))
            read(ifile,iostat=ierr) tg
            sample=tg(1,1) 
            if(iallo.eq.0) IFTG=IFTG+1
          elseif(name.eq.'RAIN CON ')then
            if(iallo.eq.0) allocate(rc(mix,mjx))
            read(ifile,iostat=ierr) rc
            sample=rc(1,1) 
            if(iallo.eq.0) IFRC=IFRC+1
          elseif(name.eq.'RAIN NON ')then
            if(iallo.eq.0) allocate(rn(mix,mjx))
            read(ifile,iostat=ierr) rn
            sample=rn(1,1) 
            if(iallo.eq.0) IFRN=IFRN+1
          elseif(name.eq.'TERRAIN  ')then
            if(iallo.eq.0) allocate(ter(mix,mjx))
            read(ifile,iostat=ierr)ter 
            sample=ter(1,1) 
            if(iallo.eq.0) IFTER=IFTER+1
          elseif(name.eq.'MAPFACCR ')then
            if(iallo.eq.0) allocate(xmf(mix,mjx))
            read(ifile,iostat=ierr) xmf
            sample=xmf(1,1) 
            if(iallo.eq.0) IFXMF=IFXMF+1
          elseif(name.eq.'MAPFACDT ')then
            if(iallo.eq.0) allocate(dmf(mix,mjx))
            read(ifile,iostat=ierr) dmf
            sample=dmf(1,1) 
            if(iallo.eq.0) IFDMF=IFDMF+1
          elseif(name.eq.'CORIOLIS ')then
            if(iallo.eq.0) allocate(cor(mix,mjx))
            read(ifile,iostat=ierr) cor
            sample=cor(1,1) 
            if(iallo.eq.0) IFCOR=IFCOR+1
          elseif(name.eq.'RES TEMP ')then
            if(iallo.eq.0) allocate(tr(mix,mjx))
            read(ifile,iostat=ierr) tr 
            sample=tr(1,1) 
            if(iallo.eq.0) IFTR=IFTR+1
          elseif(name.eq.'LATITCRS ')then
            if(iallo.eq.0) allocate(xlat(mix,mjx))
            read(ifile,iostat=ierr) xlat
            sample=xlat(1,1) 
            if(iallo.eq.0) IFXLAT=IFXLAT+1
          elseif(name.eq.'LONGICRS ')then
            if(iallo.eq.0) allocate(xlon(mix,mjx))
            read(ifile,iostat=ierr) xlon
            sample=xlon(1,1) 
            if(iallo.eq.0) IFXLON=IFXLON+1
          elseif(name.eq.'LAND USE ')then
            if(iallo.eq.0) allocate(lu(mix,mjx))
            read(ifile,iostat=ierr) lu
            sample=lu(1,1) 
            if(iallo.eq.0) IFLU=IFLU+1
          elseif(name.eq.'VEGFRC   ')then
            if(iallo.eq.0) allocate(vgf(mix,mjx))
            read(ifile,iostat=ierr) vgf
            sample=vgf(1,1) 
            if(iallo.eq.0) IFVGF=IFVGF+1
          elseif(name.eq.'SNOWCOVR ')then
            if(iallo.eq.0) allocate(sc(mix,mjx))
            read(ifile,iostat=ierr) sc
            sample=sc(1,1) 
            if(iallo.eq.0) IFSC=IFSC+1
          elseif(name.eq.'TSEASFC  ')then
            if(iallo.eq.0) allocate(sst(mix,mjx))
            read(ifile,iostat=ierr) sst
            sample=sst(1,1) 
            if(iallo.eq.0) IFSST=IFSST+1
          elseif(name.eq.'PBL HGT  ')then
            if(iallo.eq.0) allocate(pblh(mix,mjx))
            read(ifile,iostat=ierr) pblh
            sample=pblh(1,1) 
            if(iallo.eq.0) IFPBLH=IFPBLH+1
          elseif(name.eq.'REGIME   ')then
            if(iallo.eq.0) allocate(pblr(mix,mjx))
            read(ifile,iostat=ierr) pblr
            sample=pblr(1,1) 
            if(iallo.eq.0) IFPBLR=IFPBLR+1
          elseif(name.eq.'SHFLUX   ')then
            if(iallo.eq.0) allocate(shf(mix,mjx))
            read(ifile,iostat=ierr) shf
            sample=shf(1,1) 
            if(iallo.eq.0) IFSHF=IFSHF+1
          elseif(name.eq.'LHFLUX   ')then
            if(iallo.eq.0) allocate(lhf(mix,mjx))
            read(ifile,iostat=ierr) lhf
            sample=lhf(1,1) 
            if(iallo.eq.0) IFLHF=IFLHF+1
          elseif(name.eq.'GRNFLX   ')then
            if(iallo.eq.0) allocate(ghf(mix,mjx))
            read(ifile,iostat=ierr) ghf
            sample=ghf(1,1) 
            if(iallo.eq.0) IFGHF=IFGHF+1
          elseif(name.eq.'UST      ')then
            if(iallo.eq.0) allocate(ust(mix,mjx))
            read(ifile,iostat=ierr) ust
            sample=ust(1,1) 
            if(iallo.eq.0) IFUST=IFUST+1
          elseif(name.eq.'SWDOWN   ')then
            if(iallo.eq.0) allocate(swd(mix,mjx))
            read(ifile,iostat=ierr) swd
            sample=swd(1,1) 
            if(iallo.eq.0) IFSWD=IFSWD+1
          elseif(name.eq.'LWDOWN   ')then
            if(iallo.eq.0) allocate(lwd(mix,mjx))
            read(ifile,iostat=ierr) lwd
            sample=lwd(1,1) 
            if(iallo.eq.0) IFLWD=IFLWD+1
          elseif(name.eq.'SWOUT   ')then
            if(iallo.eq.0) allocate(swo(mix,mjx))
            read(ifile,iostat=ierr) swo
            sample=swo(1,1) 
            if(iallo.eq.0) IFSWO=IFSWO+1
          elseif(name.eq.'LWOUT   ')then
            if(iallo.eq.0) allocate(lwo(mix,mjx))
            read(ifile,iostat=ierr) lwo
            sample=lwo(1,1) 
            if(iallo.eq.0) IFLWO=IFLWO+1
          elseif(name.eq.'MAVAIL   ')then
            if(iallo.eq.0) allocate(mav(mix,mjx))
            read(ifile,iostat=ierr) mav
            sample=mav(1,1) 
            if(iallo.eq.0) IFMAV=IFMAV+1
          elseif(name.eq.'SOIL T 1 ')then
            if(iallo.eq.0) allocate(st1(mix,mjx))
            read(ifile,iostat=ierr) st1
            sample=st1(1,1) 
            if(iallo.eq.0) IFST1=IFST1+1
          elseif(name.eq.'SOIL T 2 ')then
            if(iallo.eq.0) allocate(st2(mix,mjx))
            read(ifile,iostat=ierr) st2
            sample=st2(1,1)
            if(iallo.eq.0) IFST2=IFST2+1
          elseif(name.eq.'SOIL T 3 ')then
            if(iallo.eq.0) allocate(st3(mix,mjx))
            read(ifile,iostat=ierr) st3
            sample=st3(1,1) 
            if(iallo.eq.0) IFST3=IFST3+1
          elseif(name.eq.'SOIL T 4 ')then
            if(iallo.eq.0) allocate(st4(mix,mjx))
            read(ifile,iostat=ierr) st4
            sample=st4(1,1) 
            if(iallo.eq.0) IFST4=IFST4+1
          elseif(name.eq.'SOIL T 5 ')then
            if(iallo.eq.0) allocate(st5(mix,mjx))
            read(ifile,iostat=ierr) st5
            sample=st5(1,1) 
            if(iallo.eq.0) IFST5=IFST5+1
          elseif(name.eq.'SOIL T 6 ')then
            if(iallo.eq.0) allocate(st6(mix,mjx))
            read(ifile,iostat=ierr) st6
            sample=st6(1,1) 
            if(iallo.eq.0) IFST6=IFST6+1
          elseif(name.eq.'SOIL M 1 ')then
            if(iallo.eq.0) allocate(sm1(mix,mjx))
            read(ifile,iostat=ierr) sm1
            sample=sm1(1,1) 
            if(iallo.eq.0) IFSM1=IFSM1+1
          elseif(name.eq.'SOIL M 2 ')then
            if(iallo.eq.0) allocate(sm2(mix,mjx))
            read(ifile,iostat=ierr) sm2
            sample=sm2(1,1) 
            if(iallo.eq.0) IFSM2=IFSM2+1
          elseif(name.eq.'SOIL M 3 ')then
            if(iallo.eq.0) allocate(sm3(mix,mjx))
            read(ifile,iostat=ierr) sm3
            sample=sm3(1,1) 
            if(iallo.eq.0) IFSM3=IFSM3+1
          elseif(name.eq.'SOIL M 4 ')then
            if(iallo.eq.0) allocate(sm4(mix,mjx))
            read(ifile,iostat=ierr) sm4
            sample=sm4(1,1) 
            if(iallo.eq.0) IFSM4=IFSM4+1
          elseif(name.eq.'SOIL W 1 ')then
            if(iallo.eq.0) allocate(sw1(mix,mjx))
            read(ifile,iostat=ierr) sw1
            sample=sw1(1,1) 
            if(iallo.eq.0) IFSW1=IFSW1+1
          elseif(name.eq.'SOIL W 2 ')then
            if(iallo.eq.0) allocate(sw2(mix,mjx))
            read(ifile,iostat=ierr) sw2
            sample=sw2(1,1) 
            if(iallo.eq.0) IFSW2=IFSW2+1
          elseif(name.eq.'SOIL W 3 ')then
            if(iallo.eq.0) allocate(sw3(mix,mjx))
            read(ifile,iostat=ierr) sw3
            sample=sw3(1,1) 
            if(iallo.eq.0) IFSW3=IFSW3+1
          elseif(name.eq.'SOIL W 4 ')then
            if(iallo.eq.0) allocate(sw4(mix,mjx))
            read(ifile,iostat=ierr) sw4
            sample=sw4(1,1) 
            if(iallo.eq.0) IFSW4=IFSW4+1
          elseif(name.eq.'CANOPYM  ')then
            if(iallo.eq.0) allocate(can(mix,mjx))
            read(ifile,iostat=ierr) can
            sample=can(1,1) 
            if(iallo.eq.0) IFCAN=IFCAN+1
          elseif(name.eq.'SNOWH    ')then
            if(iallo.eq.0) allocate(snh(mix,mjx))
            read(ifile,iostat=ierr) snh
            sample=snh(1,1) 
            if(iallo.eq.0) IFSNH=IFSNH+1
          elseif(name.eq.'SNODPTH  ')then
            if(iallo.eq.0) allocate(snd(mix,mjx))
            read(ifile,iostat=ierr) snd
            sample=snd(1,1) 
            if(iallo.eq.0) IFSND=IFSND+1
          elseif(name.eq.'WEASD    ')then
            if(iallo.eq.0) allocate(wsd(mix,mjx))
            read(ifile,iostat=ierr) wsd
            sample=wsd(1,1) 
            if(iallo.eq.0) IFWSD=IFWSD+1
          elseif(name.eq.'SEAICE   ')then
            if(iallo.eq.0) allocate(ssi(mix,mjx))
            read(ifile,iostat=ierr) ssi
            sample=ssi(1,1) 
            if(iallo.eq.0) IFSSI=IFSSI+1
          elseif(name.eq.'SEAICEFR ')then
            if(iallo.eq.0) allocate(sif(mix,mjx))
            read(ifile,iostat=ierr) sif
            sample=sif(1,1) 
            if(iallo.eq.0) IFSIF=IFSIF+1
          elseif(name.eq.'SFCRNOFF ')then
            if(iallo.eq.0) allocate(sro(mix,mjx))
            read(ifile,iostat=ierr) sro
            sample=sro(1,1) 
            if(iallo.eq.0) IFSRO=IFSRO+1
          elseif(name.eq.'UGDRNOFF ')then
            if(iallo.eq.0) allocate(uro(mix,mjx))
            read(ifile,iostat=ierr) uro
            sample=uro(1,1) 
            if(iallo.eq.0) IFURO=IFURO+1
          elseif(name.eq.'T2       ')then
            if(iallo.eq.0) allocate(t2m(mix,mjx))
            read(ifile,iostat=ierr) t2m
            sample=t2m(1,1) 
            if(iallo.eq.0) IFT2M=IFT2M+1
          elseif(name.eq.'Q2       ')then
            if(iallo.eq.0) allocate(q2m(mix,mjx))
            read(ifile,iostat=ierr) q2m
            sample=q2m(1,1) 
            if(iallo.eq.0) IFQ2M=IFQ2M+1
          elseif(name.eq.'U10      ')then
            if(iallo.eq.0) allocate(u10(mix,mjx))
            read(ifile,iostat=ierr) u10
            sample=u10(1,1) 
            if(iallo.eq.0) IFU10=IFU10+1
          elseif(name.eq.'V10      ')then
            if(iallo.eq.0) allocate(v10(mix,mjx))
            read(ifile,iostat=ierr) v10
            sample=v10(1,1) 
            if(iallo.eq.0) IFV10=IFV10+1
          elseif(name.eq.'ALB      ')then
            if(iallo.eq.0) allocate(alb(mix,mjx))
            read(ifile,iostat=ierr) alb
            sample=alb(1,1) 
            if(iallo.eq.0) IFALB=IFALB+1
          elseif(name.eq.'ALBEDO   ')then
            if(iallo.eq.0) allocate(abb(mix,mjx))
            read(ifile,iostat=ierr) abb
            sample=abb(1,1) 
            if(iallo.eq.0) IFABB=IFABB+1
          elseif(name.eq.'ALBSNOMX ')then
            if(iallo.eq.0) allocate(asb(mix,mjx))
            read(ifile,iostat=ierr) asb
            sample=asb(1,1) 
            if(iallo.eq.0) IFASB=IFASB+1
          elseif(name.eq.'PSEALVLC ')then
            if(iallo.eq.0) allocate(pslv(mix,mjx))
            read(ifile,iostat=ierr) pslv
            sample=pslv(1,1)
            stat_pslv=1
          else
            allocate(dum2d(mix,mjx))
            read(ifile,iostat=ierr) dum2d
            sample=dum2d(1,1) 
            deallocate(dum2d)
          endif
        elseif(ordering.eq.'CA  ')then
          allocate(dumsfc(end_index(1),end_index(2)))
          read(ifile,iostat=ierr) dumsfc
          deallocate(dumsfc)
        elseif(ordering.eq.'S   ')then
          if(name.eq.'SIGMAH   ')then
            if(iallo.eq.0) allocate(sigma(mkx))
            read(ifile,iostat=ierr) sigma
            sample=sigma(kl)
          else
            allocate(dum1d(mkx))
            read(ifile,iostat=ierr) dum1d
            sample=dum1d(kl)
            deallocate(dum1d)
          endif
        elseif(ordering.eq.'P   ')then
          if(name.eq.'PRESSURE ')then
            if(iallo.eq.0) allocate(pvals(mkx))
            read(ifile,iostat=ierr) pvals
            sample=pvals(kl)
          else
            allocate(dum1d(end_index(1)))
            read(ifile,iostat=ierr) dum1d
            sample=dum1d(1)
            deallocate(dum1d)
          endif
        else
          print *,'dont know how to read this'
          stop 1111
        endif
        write(*,'(A8,1x,I1,4(1x,I3),1x,A,1x,A," : ", F20.8,1x,A)')&
          name, ndim, end_index(1), end_index(2), end_index(3), end_index(4),&
          staggering, ordering, sample, trim(units)
      endif 
      read(ifile,iostat=ierr)flag
    enddo

    print *,'----- found end of time period -----'
    iallo=1

    if(nread.ge.timin) nout=1
    if(mod(nread-timin,nskip).ne.0) nout=0
    if(nout.eq.0) read(ifile,iostat=ierr)flag
  enddo

!cccccccccccccccccccccccccccccccccccccccc

      if((nread-timin+1).eq.1)then

        print *
        print *,'Found first requested output time'

        iallo=0

        if(IFSKEW.eq.1)then
          IX1=ISKW
          JX1=JSKW
          IX2=ISKW
          JX2=JSKW
          print *,'Printing 1 column only'
          print *,'   ISKW,JSKW=',ISKW,JSKW
        else
          IX1=1
          JX1=1
          IX2=ilx
          JX2=jlx
        endif

          mrecl = 4
#ifdef recl
          mrecl = 1
#endif

#ifdef linux
        if(IFSKEW.eq.1)then
          OPEN(UNIT=80,FORM='UNFORMATTED',ACCESS='DIRECT',RECL=4,     &
             STATUS='UNKNOWN')
        else
          OPEN(UNIT=80,FORM='UNFORMATTED',                            &
             ACCESS='DIRECT',RECL=(ilx*jlx*mrecl),STATUS='UNKNOWN')
        endif
#endif
#ifdef DEC
        if(IFSKEW.eq.1)then
          OPEN(UNIT=80,FORM='UNFORMATTED',ACCESS='DIRECT',RECL=1,     &
             STATUS='UNKNOWN')
        else
          OPEN(UNIT=80,FORM='UNFORMATTED',                            &
             ACCESS='DIRECT',RECL=(ilx*jlx),STATUS='UNKNOWN')
        endif
#endif
        open(unit=81,status='unknown')

        if(p00.gt.0. .and. ts0.gt.0. .and. tlp.gt.0. .and. index.ne.8 &
                     .and. ifz .eq. 1 )then

          if(iallo.eq.0) allocate(z(mix,mjx,mkx))

          do k=1,kl
          do j=1,jlx
          do i=1,ilx
            ps0=p00*exp( (-1.*ts0/tlp)+(( ((ts0/tlp)**2.)-             &
                  (2.*G*(ter(i,j)/(tlp*R)))  )**0.5) )
            phydro=(ps0-ptop)*sigma(k)+ptop
            z(i,j,k)=-1.*(  ((R*tlp/2./G)*((ALOG(phydro/p00)**2)))     &
                 + ((R*ts0/G)*ALOG(phydro/p00))  )
            z(i,j,k)=z(i,j,k)-ter(i,j)
          enddo
          enddo
          enddo
        else
          ifz = 0
        endif

!
!    0        1         2
!    123456789012345678901234
!    1999-10-18_00:00:00.0000
!
!              0        1         2         3
!             12345678901234567890123456789012345678
        tdef='tdef     linear hh:mmZddMMMccyy ttttMN' 
      if(index.eq.1)then
        tdef='tdef     linear 00:00Z01JAN2000  720MN' 
      else
        tdef(17:18)=current_date(12:13)
        tdef(20:21)=current_date(15:16)
        tdef(23:24)=current_date(9:10)
        read(current_date(6:7),221) stmon
221     format(i2)
        IF(stmon.EQ.1) CMON='JAN'
        IF(stmon.EQ.2) CMON='FEB'
        IF(stmon.EQ.3) CMON='MAR'
        IF(stmon.EQ.4) CMON='APR'
        IF(stmon.EQ.5) CMON='MAY'
        IF(stmon.EQ.6) CMON='JUN'
        IF(stmon.EQ.7) CMON='JUL'
        IF(stmon.EQ.8) CMON='AUG'
        IF(stmon.EQ.9) CMON='SEP'
        IF(stmon.EQ.10) CMON='OCT'
        IF(stmon.EQ.11) CMON='NOV'
        IF(stmon.EQ.12) CMON='DEC'
        write(tdef(25:27),222) cmon 
222     format(a3)
        write(tdef(33:36),228) ndt 
228     format(i4) 
        tdef(28:31)=current_date(1:4)
      endif
        print *,tdef
        print *
      ENDIF


!  get pressure (in Pa)

      if(iallo.eq.0) allocate(prs(mix,mjx,mkx))

      if(index.eq.1)then
        do k=1,kl
        do j=1,jlx
        do i=1,ilx
          prs(i,j,k)=0.
        enddo
        enddo
        enddo
      elseif(index.eq.11 .or. index.eq.5)then
        do k=1,kl
        do j=1,jlx
        do i=1,ilx
          prs(i,j,k)=ps(i,j)*sigma(k)+ptop+pp(i,j,k)
        enddo
        enddo
        enddo
      else
        do k=1,kl
        do j=1,jlx
        do i=1,ilx
          prs(i,j,k)=pvals(k)
        enddo
        enddo
        enddo 
      endif

      print *
      print *,'Calculating derived variables ...'
!
!cccccccccccccccccccccccccccccccccccccccccccccccccc
!  Check to see what is available

  IF(iallo.eq.0)THEN
!    print *,'  Checking for availability of data.'
    if(stat_u.eq.0)then
      if(IFU.eq.1)then
        IFU=0
!        print *,'      IFU'
      endif
    endif
    if(stat_v.eq.0)then
      if(IFV.eq.1)then
        IFV=0
!        print *,'      IFV'
      endif
    endif
    if(stat_u.eq.0 .or. stat_v.eq.0)then
      if(IFVOR.eq.1)then
        IFVOR=0
!        print *,'      IFVOR'
      endif
      if(IFPV.eq.1)then
        IFPV=0
!        print *,'      IFPV'
      endif
      if(IFDIV.eq.1)then
        IFDIV=0
!        print *,'      IFDIV'
      endif
      if(IFDIR.eq.1)then
        IFDIR=0
!        print *,'      IFDIR'
      endif
      if(IFTADV.eq.1)then
        IFTADV=0
!        print *,'      IFTADV'
      endif
    endif
    if(stat_t.eq.0)then
      if(IFT.eq.1)then
        IFT=0
!        print *,'      IFT'
      endif
      if(IFTH.eq.1)then
        IFTH=0
!        print *,'      IFTH'
      endif
      if(IFPSLV.eq.1 .and. (index.eq.5.or.index.eq.11) )then
        IFPSLV=0
!        print *,'      IFPSLV'
      endif
      if(IFTADV.eq.1)then
        IFTADV=0
!        print *,'      IFTADV'
      endif
    endif
    if(stat_qv.eq.0)then
      if(IFQ.eq.1)then
        IFQ=0
!        print *,'      IFQ'
      endif
      if(IFPWAT.eq.1)then
        IFPWAT=0
!        print *,'      IFPWAT'
      endif
    endif
    if(stat_qc.eq.0)then
      if(IFCLW.eq.1)then
        IFCLW=0
!        print *,'      IFCLW'
      endif
      if(IFICLW.eq.1)then
        IFICLW=0
!        print *,'      IFICLW'
      endif
    endif
    if(stat_qr.eq.0)then
      if(IFRNW.eq.1)then
        IFRNW=0
!        print *,'      IFRNW'
      endif
      if(IFIRNW.eq.1)then
        IFIRNW=0
!        print *,'      IFIRNW'
      endif
    endif
    if(stat_rtnd.eq.0)then
      if(IFRTND.eq.1)then
        IFRTND=0
!        print *,'      IFRTND'
      endif
    endif
    if(stat_tke.eq.0)then
      if(IFTKE.eq.1)then
        IFTKE=0
!        print *,'      IFTKE'
      endif
    endif
    if(stat_qi.eq.0)then
      if(IFICE.eq.1)then
        IFICE=0
!        print *,'      IFICE'
      endif
    endif
    if(stat_qs.eq.0)then
      if(IFSNOW.eq.1)then
        IFSNOW=0
!        print *,'      IFSNOW'
      endif
    endif
    if(stat_qg.eq.0)then
      if(IFGRAUP.eq.1)then
        IFGRAUP=0
!        print *,'      IFGRAUP'
      endif
    endif
    if(stat_nci.eq.0)then
      if(IFNCI.eq.1)then
        IFNCI=0
!        print *,'      IFNCI'
      endif
    endif
    if(stat_w.eq.0)then
      if(IFW.eq.1)then
        IFW=0
!        print *,'      IFW'
      endif
    endif

    if(stat_t.eq.0 .or. stat_qv.eq.0)then
      if( (index.eq.11.or.index.eq.5) .and. IFRH.eq.1 )then
        IFRH=0
!        print *,'      IFRH'
        IFCLFR=0
!        print *,'      IFCLFR'
      endif
      if(IFTD.eq.1)then
        IFTD=0
!        print *,'      IFTD'
      endif
      if(IFTHE.eq.1)then
        IFTHE=0
!        print *,'      IFTHE'
      endif
    endif
    if(stat_qr.eq.0)then
      IF(IFDBZ.eq.1 .or. IFCREF.eq.1)then
        IFDBZ=0
!        print *,'      IFDBZ'
        IFCREF=0
!        print *,'      IFCREF'
      endif
    endif
    if(stat_pp.eq.0)then
      if(IFPP.eq.1)then
        IFPP=0
!        print *,'      IFPP'
      endif
      if(IFPSLV.eq.1 .and. (index.eq.5.or.index.eq.11) )then
        IFPSLV=0
!        print *,'      IFPSLV'
      endif
    endif

    if(index.ne.5 .and. index.ne.11)then
      if(IFPWAT.eq.1)then
        IFPWAT=0
!        print *,'      IFPWAT'
      endif
      if(IFICLW.eq.1)then
        IFICLW=0
!        print *,'      IFICLW'
      endif
      if(IFIRNW.eq.1)then
        IFIRNW=0
!        print *,'      IFIRNW'
      endif
      if(stat_h.eq.0)then
        if(IFH.eq.1)then
          IFH=0
!          print *,'      IFH'
        endif
      endif

      if(stat_rh.eq.0)then
        if(IFRH.eq.1)then
          IFRH=0
!          print *,'      IFRH'
          IFCLFR=0
!          print *,'      IFCLFR'
        endif
      endif
      if(stat_pslv.eq.0)then
        if(IFPSLV.eq.1)then
          IFPSLV=0
!          print *,'      IFPSLV'
        endif
      endif
    endif

    if(index.eq.1)then
      IFZ=0
      IFPRS=0
    endif


!!  2d variables
      IFPS  =  max(IFPS-1,0)
      IFTG  =  max(IFTG-1,0)
      IFRC  =  max(IFRC-1,0)
      IFRN  =  max(IFRN-1,0)
      IFTER = max(IFTER-1,0)
      IFXMF = max(IFXMF-1,0)
      IFDMF = max(IFDMF-1,0)
      IFCOR = max(IFCOR-1,0)
      IFTR  =  max(IFTR-1,0)
      IFXLAT=max(IFXLAT-1,0)
      IFXLON=max(IFXLON-1,0)
      IFLU  =  max(IFLU-1,0)
      IFVGF = max(IFVGF-1,0)
      IFSC  =  max(IFSC-1,0)
      IFPBLH=max(IFPBLH-1,0)
      IFPBLR=max(IFPBLR-1,0)
      IFSHF = max(IFSHF-1,0)
      IFLHF = max(IFLHF-1,0)
      IFGHF = max(IFGHF-1,0)
      IFUST = max(IFUST-1,0)
      IFSWD = max(IFSWD-1,0)
      IFLWD = max(IFLWD-1,0)
      IFSWO = max(IFSWO-1,0)
      IFLWO = max(IFLWO-1,0)
      IFSST = max(IFSST-1,0)
      IFMAV = max(IFMAV-1,0)
      IFST1 = max(IFST1-1,0)
      IFST2 = max(IFST2-1,0)
      IFST3 = max(IFST3-1,0)
      IFST4 = max(IFST4-1,0)
      IFST5 = max(IFST5-1,0)
      IFST6 = max(IFST6-1,0)
      IFSM1 = max(IFSM1-1,0)
      IFSM2 = max(IFSM2-1,0)
      IFSM3 = max(IFSM3-1,0)
      IFSM4 = max(IFSM4-1,0)
      IFSW1 = max(IFSW1-1,0)
      IFSW2 = max(IFSW2-1,0)
      IFSW3 = max(IFSW3-1,0)
      IFSW4 = max(IFSW4-1,0)
      IFCAN = max(IFCAN-1,0)
      IFSNH = max(IFSNH-1,0)
      IFSND = max(IFSND-1,0)
      IFWSD = max(IFWSD-1,0)
      IFSSI = max(IFSSI-1,0)
      IFSIF = max(IFSIF-1,0)
      IFSRO = max(IFSRO-1,0)
      IFURO = max(IFURO-1,0)
      IFT2M = max(IFT2M-1,0)
      IFQ2M = max(IFQ2M-1,0)
      IFU10 = max(IFU10-1,0)
      IFV10 = max(IFV10-1,0)
      IFALB = max(IFALB-1,0)
      IFABB = max(IFABB-1,0)
      IFASB = max(IFASB-1,0)

  ENDIF

!cccccccccccccccccccccccccccccccccccccccccccccccccc
! compute derived variables

      allocate(dum3d(mix,mjx,mkx))

      if(IFTH.eq.1 .or. IFPV.eq.1)then
        if(iallo.eq.0) allocate(theta(mix,mjx,mkx))
        call calcpt(t,prs,mix,mjx,mkx,theta)
      endif
      if(IFTD.eq.1 .or. IFTHE.eq.1)then
        if(iallo.eq.0) allocate(td(mix,mjx,mkx))
        call calctd(qv,prs,t,mix,mjx,mkx,td)
      endif
      if(IFTHE.eq.1)then
        if(iallo.eq.0) allocate(thetae(mix,mjx,mkx))
        call calcthe(qv,t,prs,mix,mjx,mkx,thetae)
      endif
      if(IFDBZ.EQ.1 .or. IFCREF.EQ.1)then 
        if(iallo.eq.0) allocate(cref(mix,mjx))
        if(iallo.eq.0) allocate(dbz(mix,mjx,mkx))
        call calcdbz(t,qv,prs,qr,mix,mjx,mkx,dbz,cref,ifcref,iice)
      endif
      if(IFVOR.EQ.1 .or. IFDIV.EQ.1)then 
        if(iallo.eq.0) allocate(div(mix,mjx,mkx))
        if(iallo.eq.0) allocate(vor(mix,mjx,mkx))
        call calcvordiv(u,v,dmf,xmf,dx2inv,mix,mjx,mkx,ifvor,ifdiv,   &
                        vor,div)
      endif
      if(IFTADV.eq.1)then
        if(iallo.eq.0) allocate(tadv(mix,mjx,mkx))
        call advec(u,v,dmf,xmf,t,mix,mjx,mkx,dx,tadv)
      endif

      if(iallo.eq.0) allocate(psfc(mix,mjx))

      IF(INDEX.EQ.11 .or. index.eq.5)THEN
        DO J=1,jlx
        DO I=1,ilx
          PSFC(I,J)=PP(I,J,KL)+PS(I,J)+PTOP
        ENDDO
        ENDDO
        if(IFPV.eq.1)then
          allocate(dum2d(mix,mjx))
          allocate(dum2da(mix,mjx))
          allocate(dum2db(mix,mjx))
          allocate(dum2dc(mix,mjx))
          allocate(dum2dd(mix,mjx))
          allocate(dum2de(mix,mjx))
          if(iallo.eq.0) allocate(pv(mix,mjx,mkx))
          CALL PVS(U,V,THETA,PRS,DMF,XMF,COR,dx,                     &
                mix,mjx,mkx,PV,                                      &
                dum2d,dum2da,dum2db,dum2dc,dum2dd,dum2de,dum3d)
          deallocate(dum2d)
          deallocate(dum2da)
          deallocate(dum2db)
          deallocate(dum2dc)
          deallocate(dum2dd)
          deallocate(dum2de)
        endif
        if(IFICLW.EQ.1)then
          if(iallo.eq.0) allocate(iclw(mix,mjx))
          allocate(dum1d(mkx+1))
          CALL INTEGRAT(qc,PRS,PSFC,mix,mjx,mkx,SIGMA,PTOP,dum1d,ICLW)
          deallocate(dum1d)
        endif
        if(IFIRNW.EQ.1)then
          if(iallo.eq.0) allocate(irnw(mix,mjx))
          allocate(dum1d(mkx+1))
          CALL INTEGRAT(qr,PRS,PSFC,mix,mjx,mkx,SIGMA,PTOP,dum1d,IRNW)
          deallocate(dum1d)
        endif
        if(IFPWAT.EQ.1)then
          if(iallo.eq.0) allocate(pwat(mix,mjx))
          allocate(dum1d(mkx+1))
          CALL INTEGRAT(qv,PRS,PSFC,mix,mjx,mkx,SIGMA,PTOP,dum1d,PWAT)
          deallocate(dum1d)
        endif
        if(IFH.eq.1)then
          if(iallo.eq.0) allocate(h(mix,mjx,mkx))
          call nhgeosig(PS,SIGMA,PTOP,P00,TS0,TLP,mix,mjx,mkx,H)
        endif
        if(IFRH.eq.1 .or. IFCLFR.eq.1)then
          if(iallo.eq.0) allocate(rh(mix,mjx,mkx))
          call calcrh(t,qv,prs,mix,mjx,mkx,iice,rh)
        endif
      ELSEIF(INDEX.NE.1)THEN
        if(IFPV.eq.1)then
          allocate(dum2d(mix,mjx))
          allocate(dum2da(mix,mjx))
          allocate(dum2db(mix,mjx))
          allocate(dum2dc(mix,mjx))
          allocate(dum2dd(mix,mjx))
          allocate(dum2de(mix,mjx))
          if(iallo.eq.0) allocate(pv(mix,mjx,mkx))
          if ( index .eq. 8 ) then
             CALL PVP(U,V,T,DMF,XMF,COR,pvals/100.,dx,              &
                 mix,mjx,mkx,PV,                                    &
                 dum2d,dum2da,dum2db,dum2dc,dum2dd,dum2de,dum3d)
          else
             CALL PVP(U,V,T,DMF,XMF,COR,pvals,dx,                   &
                 mix,mjx,mkx,PV,                                    &
                 dum2d,dum2da,dum2db,dum2dc,dum2dd,dum2de,dum3d)
          endif
          deallocate(dum2d)
          deallocate(dum2da)
          deallocate(dum2db)
          deallocate(dum2dc)
          deallocate(dum2dd)
          deallocate(dum2de)
        endif
      ENDIF

      if(IFCLFR.eq.1)then
        if(iallo.eq.0) allocate(clfrlo(mix,mjx))
        if(iallo.eq.0) allocate(clfrmi(mix,mjx))
        if(iallo.eq.0) allocate(clfrhi(mix,mjx))
        call calcclfr(prs,rh,mix,mjx,mkx,clfrlo,clfrmi,clfrhi)
      endif

!-------------------------------------------------------------------

! interpolate w to half-sigma levels
      if(IFW.eq.1 .and. index.ne.8)then
        do k=1,kl
        do j=1,jlx
        do i=1,ilx
          w(i,j,k)=0.5*(w(i,j,k)+w(i,j,k+1))
        enddo
        enddo
        enddo
      endif
!
! interpolate tke to half-sigma levels (if necessary)
      if(IBLT.eq.6 .and. IFTKE.eq.1)then
        do k=1,kl
        do j=1,jlx
        do i=1,ilx
          tke(i,j,k)=0.5*(tke(i,j,k)+tke(i,j,k+1))
        enddo
        enddo
        enddo 
      endif
!
! interpolate u and v onto cross points

      if(IFU.eq.1)then
        do k=1,kl
        do j=1,jlx
        do i=1,ilx
          dum3d(i,j,k)=0.25*(u(i,j,k)+u(i+1,j,k)+u(i,j+1,k)+u(i+1,j+1,k))
        enddo
        enddo
        enddo

        do k=1,kl
        do j=1,jlx
        do i=1,ilx
          u(i,j,k)=dum3d(i,j,k)
        enddo
        enddo
        enddo
      endif

      if(IFV.eq.1)then
        do k=1,kl
        do j=1,jlx
        do i=1,ilx
          dum3d(i,j,k)=0.25*(v(i,j,k)+v(i+1,j,k)+v(i,j+1,k)+v(i+1,j+1,k))
        enddo
        enddo
        enddo

        do k=1,kl
        do j=1,jlx
        do i=1,ilx
          v(i,j,k)=dum3d(i,j,k)
        enddo
        enddo
        enddo
      endif

      deallocate(dum3d)

!
! rotate u and v into earth-relative frame
      IF(IFMAP.EQ.1 .and. maptype.ne.3)THEN
        if(stat_u.eq.1 .and. stat_v.eq.1)then
          call VECT(mix,mjx,mkx,xlon,xlonc,xlatc,xn,u,v)
        endif
      ENDIF
!
! calculate wind direction
      if(IFDIR.eq.1)then
        if(iallo.eq.0) allocate(dir(mix,mjx,mkx))
        call DIRCOMP(U,V,mix,mjx,mkx,DIR)
      endif

! calculate sea level pressure
      if(IFPSLV.EQ.1.and. (index.eq.11.or.index.eq.5)  &
                    .and. stat_pslv == 0 )then

        DO J=1,mjx-1
        DO I=1,mix-1
          PSFC(I,J)=(PP(I,J,KL)+PS(I,J)+PTOP)*0.01
        ENDDO
        ENDDO

        DO J=1,mjx-1
        DO I=1,mix-1
          PS(I,J)=PS(I,J)*0.01
        ENDDO
        ENDDO

        DO K=1,mkx
        DO J=1,mjx-1
        DO I=1,mix-1
          PP(I,J,K)=PP(I,J,K)*0.01
        ENDDO
        ENDDO
        ENDDO

        ptop=ptop*0.01

        allocate(dum2da(mix,mjx))
        allocate(dum2db(mix,mjx))
        allocate(dum2dc(mix,mjx))
        allocate(dum2dd(mix,mjx))
        if(iallo.eq.0) allocate(pslv(mix,mjx))
        call SEAPRSNH(T,TER,PS,psfc,PP,SIGMA,mix,mjx,mkx,PTOP,     &
                      pslv,dum2da,dum2db,dum2dc,dum2dd)
        deallocate(dum2da)
        deallocate(dum2db)
        deallocate(dum2dc)
        deallocate(dum2dd)

        ptop=ptop*100.

        DO J=1,mjx-1
        DO I=1,mix-1
          PS(I,J)=PS(I,J)*100.
        ENDDO
        ENDDO

        DO K=1,mkx
        DO J=1,mjx-1
        DO I=1,mix-1
          PP(I,J,K)=PP(I,J,K)*100.
        ENDDO
        ENDDO
        ENDDO
      endif

!-------------------------------------------------------------------
!  Pressure interpolating section
 
    IF(ZTYPE.eq.2 .and. (index.eq.5.or.index.eq.11))THEN
      print *,'INTERPOLATING TO PRESSURE LEVELS!'

      allocate(pk(mix,mjx,nplevs))
      allocate(dum3d(mix,mjx,nplevs))

      do n=1,nplevs
        if((nread-timin+1).eq.1)plev(n)=plev(n)*100.0
        print *,'  n,plev:',n,plev(n)
        do i=1,ilx
        do j=1,jlx
          pk(i,j,n)=0
          do k=1,kl
            if(prs(i,j,k).gt.plev(n) .and. pk(i,j,n).eq.0) pk(i,j,n)=k
          enddo
        enddo
        enddo
      enddo
 
      if(ifu.eq.1) call interp(u,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifv.eq.1) call interp(v,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifw.eq.1) call interp(w,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifpp.eq.1) call lninterp(pp,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ift.eq.1) call lninterp(t,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifq.eq.1) call interp(qv,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifclw.eq.1) call interp(qc,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifrnw.eq.1) call interp(qr,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifrtnd.eq.1) call interp(rtnd,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifz.eq.1) call lninterp(z,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifh.eq.1) call lninterp(h,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(iftke.eq.1) call interp(tke,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifice.eq.1) call interp(qi,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifsnow.eq.1) call interp(qs,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifgraup.eq.1) call interp(qg,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifnci.eq.1) call interp(nci,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(iftd.eq.1) call tdlninterp(td,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifrh.eq.1) call interp(rh,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifth.eq.1) call lninterp(theta,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifthe.eq.1) call lninterp(thetae,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifvor.eq.1) call interp(vor,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifpv.eq.1) call interp(pv,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifdbz.eq.1) call interp(dbz,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifdiv.eq.1) call interp(div,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifdir.eq.1) call interp(dir,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(iftadv.eq.1) call interp(tadv,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)
      if(ifprs.eq.1) call interp(prs,prs,pk,mix,mjx,mkx,nplevs,plev,dum3d)

!Cb
!Cb      deallocate(z)
!Cb      deallocate(prs)
!Cb      deallocate(psfc)
!CB
      deallocate(pk)
      deallocate(dum3d)

    ENDIF
!
!
!CCCCCCCCCCCCCCCCCCCCCCCCC
!
      nwrite=nwrite+1
      print *,'Writing to file:  nwrite=',nwrite

!
!
!  2d variables
!
  IF(IFPS.EQ.1) call writeout(ps,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFTG.EQ.1) call writeout(tg,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFRC.EQ.1) call writeout(rc,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFRN.EQ.1) call writeout(rn,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFTER.EQ.1) call writeout(ter,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFXMF.EQ.1) call writeout(xmf,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFDMF.EQ.1) call writeout(dmf,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFCOR.EQ.1) call writeout(cor,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFTR.EQ.1) call writeout(tr,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFXLAT.EQ.1) call writeout(xlat,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFXLON.EQ.1) call writeout(xlon,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFLU.EQ.1) call writeout(lu,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFVGF.EQ.1) call writeout(vgf,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSC.EQ.1) call writeout(sc,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFPBLH.EQ.1) call writeout(pblh,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFPBLR.EQ.1) call writeout(pblr,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSHF.EQ.1) call writeout(shf,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFLHF.EQ.1) call writeout(lhf,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFGHF.EQ.1) call writeout(ghf,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFUST.EQ.1) call writeout(ust,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSWD.EQ.1) call writeout(swd,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFLWD.EQ.1) call writeout(lwd,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSWO.EQ.1) call writeout(swo,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFLWO.EQ.1) call writeout(lwo,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSST.EQ.1) call writeout(sst,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFMAV.EQ.1) call writeout(mav,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFST1.EQ.1) call writeout(st1,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFST2.EQ.1) call writeout(st2,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFST3.EQ.1) call writeout(st3,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFST4.EQ.1) call writeout(st4,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFST5.EQ.1) call writeout(st5,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFST6.EQ.1) call writeout(st6,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSM1.EQ.1) call writeout(sm1,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSM2.EQ.1) call writeout(sm2,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSM3.EQ.1) call writeout(sm3,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSM4.EQ.1) call writeout(sm4,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSW1.EQ.1) call writeout(sw1,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSW2.EQ.1) call writeout(sw2,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSW3.EQ.1) call writeout(sw3,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSW4.EQ.1) call writeout(sw4,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFCAN.EQ.1) call writeout(can,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSNH.EQ.1) call writeout(snh,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSND.EQ.1) call writeout(snd,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFWSD.EQ.1) call writeout(wsd,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSSI.EQ.1) call writeout(ssi,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSIF.EQ.1) call writeout(sif,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFSRO.EQ.1) call writeout(sro,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFURO.EQ.1) call writeout(uro,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFT2M.EQ.1) call writeout(t2m,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFQ2M.EQ.1) call writeout(q2m,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFU10.EQ.1) call writeout(u10,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFV10.EQ.1) call writeout(v10,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFALB.EQ.1) call writeout(alb,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFABB.EQ.1) call writeout(abb,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFASB.EQ.1) call writeout(asb,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFPSLV.EQ.1) call writeout(pslv,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFCREF.EQ.1) call writeout(cref,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFICLW.EQ.1) call writeout(iclw,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFIRNW.EQ.1) call writeout(irnw,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFPWAT.EQ.1) call writeout(pwat,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  IF(IFCLFR.EQ.1) THEN
        call writeout(clfrlo,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
        call writeout(clfrmi,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
        call writeout(clfrhi,mix,mjx,1,ix1,ix2,jx1,jx2,1,1,1,irec)
  ENDIF
!
!  3d variables
!
  IF(IFU.EQ.1) call writeout(u,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFV.EQ.1) call writeout(v,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFW.EQ.1) call writeout(w,mix,mjx,mkx+1,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFPP.EQ.1) call writeout(pp,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFT.EQ.1) call writeout(t,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFQ.EQ.1) call writeout(qv,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFCLW.EQ.1) call writeout(qc,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFRNW.EQ.1) call writeout(qr,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFRTND.EQ.1) call writeout(rtnd,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFZ.EQ.1) call writeout(z,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFH.EQ.1) call writeout(h,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFTKE.EQ.1) call writeout(tke,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFICE.EQ.1) call writeout(qi,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFSNOW.EQ.1) call writeout(qs,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFGRAUP.EQ.1) call writeout(qg,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFNCI.EQ.1) call writeout(nci,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFTD.EQ.1) call writeout(td,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFRH.EQ.1) call writeout(rh,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFTH.EQ.1) call writeout(theta,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFTHE.EQ.1) call writeout(thetae,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFPRS.EQ.1) call writeout(prs,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFVOR.EQ.1) call writeout(vor,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFPV.EQ.1) call writeout(pv,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFDBZ.EQ.1) call writeout(dbz,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFDIV.EQ.1) call writeout(div,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFDIR.EQ.1) call writeout(dir,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
  IF(IFTADV.EQ.1) call writeout(tadv,mix,mjx,mkx,ix1,ix2,jx1,jx2,ka,kb,kc,irec)
!
!CCCCCCCCCCCC
!

    iallo=1

    if(ierr.eq.0) read(ifile,iostat=ierr)flag
    if(nread.ge.timax) ierr=1
    print *
    print *
  enddo

  if(ierr.lt.0) print *,'  End of file has been detected'

!-----------------------------------------------------------------------
!  Write GrADS descriptor file

      print *
777   continue
      print *,'Writing ctl file!'

      NOUT2D=IFPS+IFTG+IFRC+IFRN+IFTER+IFXMF+IFDMF+IFCOR+IFTR+         &
             IFXLAT+IFXLON+IFLU+IFVGF+IFSC+IFPBLH+IFPBLR+              &
             IFSHF+IFLHF+IFGHF+IFUST+IFSWD+IFLWD+IFSST+IFPSLV+         &
             IFCREF+IFICLW+IFIRNW+IFPWAT+IFCLFR+IFCLFR+IFCLFR+         &
             IFMAV+IFST1+IFST2+IFST3+IFST4+IFST5+IFST6+                &
             IFSM1+IFSM2+IFSM3+IFSM4+IFSW1+IFSW2+IFSW3+IFSW4+          &
             IFSWO+IFLWO+IFCAN+IFSNH+IFSND+IFWSD+IFSSI+IFSRO+IFURO+    &
             IFT2M+IFQ2M+IFU10+IFV10+IFALB+IFABB+IFASB+IFSIF
      NOUT3D=IFU+IFV+IFW+IFPP+IFT+IFQ+IFCLW+IFRNW+IFRTND+IFZ+IFH+      &
             IFTKE+IFICE+IFSNOW+IFGRAUP+IFNCI+IFTD+IFRH+IFTH+IFTHE+    &
             IFPRS+IFVOR+IFPV+IFDBZ+IFDIV+IFDIR+IFTADV

      write(*,'(i4," 2d variables and ",i4," 3d variables have been written to file")') NOUT2D,NOUT3D
      print *

      read(81,*)
      IF(IFLINUX.EQ.1) WRITE(81,225)
225   FORMAT('byteswapped')
      WRITE(81,202) 
202   FORMAT('title MM5 data')
      WRITE(81,203)
203   FORMAT('undef -9999.')
      if(IFSKEW.eq.1)then
         WRITE(81,204) 1
         WRITE(81,205) 1
      else
      IF(IFMAP.NE.1)THEN
         WRITE(81,204) jlx
204      FORMAT('xdef ',I3,' linear 1 1')
         WRITE(81,205) ilx
205      FORMAT('ydef ',I3,' linear 1 1')
      ELSEIF(IFMAP.EQ.1)THEN

!-----------------------------------------
         !! Check for pole and/or 180 lat
         ipole=0
         ilon=0
         shem=0
 
         i=1
         do j=1,jlx-1
           if(abs(xlon(i,j)-xlon(i,j+1)).gt.180.)then
             if(ipole.eq.1)then
               ilon=1
               ipole=0
             else
               ipole=1
             endif
           endif
         enddo
         j=jlx
         do i=1,ilx-1
           if(abs(xlon(i,j)-xlon(i+1,j)).gt.180.)then
             if(ipole.eq.1)then
               ilon=1
               ipole=0
             else
               ipole=1
             endif
           endif
         enddo
         i=ilx
         do j=jlx,2,-1
           if(abs(xlon(i,j)-xlon(i,j-1)).gt.180.)then
             if(ipole.eq.1)then
               ilon=1
               ipole=0
             else
               ipole=1
             endif
           endif
         enddo
         j=1
         do i=ilx,2,-1
           if(abs(xlon(i,j)-xlon(i-1,j)).gt.180.)then
             if(ipole.eq.1)then
               ilon=1
               ipole=0
             else
               ipole=1
             endif
           endif
         enddo
!-----------------------------------------

         if(maptype.eq.1)then
            ! Lambert projection
            alatmin=999999.
            alatmax=-999999.
            alonmin=999999.
            alonmax=-999999.
 
            do j=1,jlx
            do i=1,ilx
              alatmin=min(alatmin,xlat(i,j))
              alatmax=max(alatmax,xlat(i,j))
              if(xlon(i,j).lt.0. .and. ilon.eq.1)then
                alonmin=min(alonmin,360.0+xlon(i,j))
                alonmax=max(alonmax,360.0+xlon(i,j))
              else
                alonmin=min(alonmin,xlon(i,j))
                alonmax=max(alonmax,xlon(i,j))
              endif
            enddo
            enddo
 
            rlatinc=(dx/1000.)/111./2.
            rloninc=(dx/1000.)/111./2.
            ny=2+nint(abs(alatmax-alatmin)/rlatinc)
            nx=1+nint(abs((alonmax-alonmin)/rloninc))
 
        if( index <= 2 .and. bhi(8,1) == 1 .and. bhi(15,1) == 0) then
            centeri=float(bhi(9,1))/2.
            centerj=float(bhi(10,1))/2.
        else
            centeri=float(bhi(5,1))/2.
            centerj=float(bhi(6,1))/2.
        endif
            clat=xlatc
            clon=xlonc
            IF(NEST)THEN
               IF(nestlev.le.1)THEN
                  bottomi=bhr(10,1)+0.3333
                  fleftj=bhr(11,1)+0.3333
                  centeri=(1.+centeri-bottomi)*3.
                  centerj=(1.+centerj-fleftj)*3.
               ELSE
                  centeri=1.
                  centerj=1.
                  clat=xlat(1,1)
                  clon=xlon(1,1)
               ENDIF
            ENDIF
            write(81,300) jlx,ilx,clat,clon,           &
               centerj,centeri,bhr(6,1),bhr(5,1),      &
               xlonc,dx,dx
300         format('pdef ',i4,1x,i4,1x,'lcc',7(1x,f7.2),1x,2(f7.0,1x))
            write(81,301) nx,alonmin,rloninc
301         format('xdef ',i4,' linear ',f7.2,1x,f7.4)
            write(81,302) ny,alatmin,rlatinc
302         format('ydef ',i4,' linear ',f7.2,1x,f7.4)
         elseif(maptype.eq.2)then
            ! Polar Stereographic projection
            alatmin=999999.
            alatmax=-999999.
            alonmin=999999.
            alonmax=-999999.
 
            do j=1,jlx
            do i=1,ilx
              alatmin=min(alatmin,xlat(i,j))
              alatmax=max(alatmax,xlat(i,j))
            enddo
            enddo

            if(ipole.eq.1 .and. bhr(2,1).lt.0.) ipole=-1
            if(bhr(2,1).lt.0.) shem=1

            if(shem.eq.1)then
              print *
              print *,'*************************************************************************'
              print *
              print *,'  Southern Hemisphere Polar Stereographic Projections not supported!'
              print *,'  (sorry)'
              print *
              print *,'  Shutting down gradsv3.deck'
              print *
              print *,'*************************************************************************'
              print *
              stop
            endif

            if(ipole.ne.0)then
              alonmin=0.
              alonmax=360.
            else
              do j=1,jlx
              do i=1,ilx
                if(xlon(i,j).lt.0. .and. ilon.eq.1)then
                  alonmin=min(alonmin,360.0+xlon(i,j))
                  alonmax=max(alonmax,360.0+xlon(i,j))
                else
                  alonmin=min(alonmin,xlon(i,j))
                  alonmax=max(alonmax,xlon(i,j))
                endif
              enddo
              enddo
            endif
 
!-------------------------------
!  This section of code (most of it) comes from Wesley Ebisuzaki (NCEP)
!  via Bob Hart (PSU).   Thanks!   It works great!
!
            RERTH=6.3712E6
            PI=3.14159265358979
            rpd=0.01745329
!   !  Get the grid spacing valid at 60 degrees north
!      (since GrADS assumes that NPS projections are always true
!       at 60 degrees north ... weird)
            dxnps=dx/( (1.0+sin(bhr(5,1)*rpd))/(1.0+sin(60.0*rpd)) )
            lonref=bhr(3,1)
            im = jlx
            jm = ilx
            RLAT1=xlat(1,1)
            RLON1=xlon(1,1)
            ORIENT=bhr(3,1)
            DY=dxnps
            itmp = 64
            IPROJ=MOD(itmp/128,2)
            ISCAN=MOD(itmp/128,2)
            JSCAN=MOD(itmp/64,2)
            NSCAN=MOD(itmp/32,2)
            Hfoo=(-1.)**IPROJ
            HI=(-1.)**ISCAN
            HJ=(-1.)**(1-JSCAN)
            DXS=DXnps*HI
            DYS=DY*HJ
            DE=(1.+SIN(60.*rpd))*RERTH
            DR=DE*COS(RLAT1*rpd)/(1+Hfoo*SIN(RLAT1*rpd))
            XP=1-Hfoo*SIN((RLON1-ORIENT)*rpd)*DR/DXS
            YP=1+COS((RLON1-ORIENT)*rpd)*DR/DYS
!-------------------------------
            rlatinc=0.5*dx/(2.*pi*rerth/360.)
            rloninc=0.5*dx/(2.*pi*rerth/360.)

            rlatinc=0.0001*int(rlatinc*10000.)
            rloninc=0.0001*int(rloninc*10000.)
 
            ny=2+nint(abs(alatmax-alatmin)/rlatinc)
            nx=2+nint(abs((alonmax-alonmin)/rloninc))
 
            if(ipole.eq.1)then
              alatmin=90.000000-(ny-1)*rlatinc
            elseif(ipole.eq.-1)then
              alatmin=-90.000000
            endif
 
            write(81,310) jlx,ilx,xp,yp,lonref,dxnps*0.001
310         format('pdef ',i4,1x,i4,1x,'nps',4(1x,f9.4))
            write(81,311) nx,alonmin,rloninc
311         format('xdef ',i5,' linear ',2(1x,f9.4))
            write(81,312) ny,alatmin,rlatinc
312         format('ydef ',i5,' linear ',2(1x,f9.4))
         elseif(maptype.eq.3)then
            ! Mercator projection
            alonmin=9999999.0
            aincavg=0.
            navg=0
            do j=1,jlx
               if(xlon(2,j).lt.alonmin) alonmin=xlon(2,j)
               if(j.gt.1)then
                  aincavg=aincavg+( xlon(2,j)-xlon(2,j-1) )
                  navg=navg+1
               endif
            enddo
            aincavg=aincavg/float(navg)
            WRITE(81,305) jlx,alonmin,aincavg
305         format('xdef ',I3,' linear ',f9.4,' ',f9.4)
            WRITE(81,306) ilx
306         FORMAT('ydef ',I3,' levels')
            do i=1,ilx
               write(81,*) xlat(i,2)
            enddo
         endif
      ENDIF
      endif
      kfoo=max(ka,kb)
      if(index.eq.1)then
        write(81,216)
216     format('zdef   1 linear 1 1')
      else
      WRITE(81,206) kfoo
206   FORMAT('zdef ',I3,' levels ')
      DO K=1,kfoo
        IF(INDEX.EQ.11 .or. INDEX.eq.5)THEN
          if(ztype.eq.2)THEN
            WRITE(81,208) plev(k)/100.
          else
            WRITE(81,207) SIGMA(kl-K+1)
207         FORMAT(' ',F7.5)
          endif
        ELSE
          WRITE(81,208) pvals(K)/100.
208       FORMAT(' ',F7.2)
        ENDIF
      ENDDO
      endif

      write(tdef(6:8),224) nwrite 
224      format(i3) 
      write(81,226) tdef
226   format(a38)
      WRITE(81,209) (NOUT2D+NOUT3D)
209   FORMAT('vars ',I2)
      IF(IFPS.EQ.1)   WRITE(81,213)'ps      ','pstar (Pa)          '
      IF(IFTG.EQ.1)   WRITE(81,213)'tg      ','ground temp (K)     '
      IF(IFRC.EQ.1)   WRITE(81,213)'rc      ','accum conv pcn (cm) '
      IF(IFRN.EQ.1)   WRITE(81,213)'rn      ','accum non-c pcn (cm)'
      IF(IFTER.EQ.1)  WRITE(81,213)'ter     ','ter elevation (m)   '
      IF(IFXMF.EQ.1)  WRITE(81,213)'xmf     ','cross map factor    '
      IF(IFDMF.EQ.1)  WRITE(81,213)'dmf     ','dot map factor      '
      IF(IFCOR.EQ.1)  WRITE(81,213)'cor     ','coriolis (s-1)      '
      IF(IFTR.EQ.1)   WRITE(81,213)'tr      ','reservoir temp (K)  '
      IF(IFXLAT.EQ.1) WRITE(81,213)'xlat    ','cross lat (degree)  '
      IF(IFXLON.EQ.1) WRITE(81,213)'xlon    ','cross lon (degree)  '
      IF(IFLU.EQ.1)   WRITE(81,213)'lu      ','land use            '
      IF(IFVGF.EQ.1)  WRITE(81,213)'vgf     ','vegetation coverage '
      IF(IFSC.EQ.1)   WRITE(81,213)'sc      ','snow cover          '
      IF(IFPBLH.EQ.1) WRITE(81,213)'pblh    ','pbl height (m)      '
      IF(IFPBLR.EQ.1) WRITE(81,213)'pblr    ','pbl regime          '
      IF(IFSHF.EQ.1)  WRITE(81,213)'shf     ','sen heat flux (W/m2)'
      IF(IFLHF.EQ.1)  WRITE(81,213)'lhf     ','lat heat flux (W/m2)'
      IF(IFGHF.EQ.1)  WRITE(81,213)'ghf     ','grd heat flux (W/m2)'
      IF(IFUST.EQ.1)  WRITE(81,213)'ust     ','friction vel (m/s)  '
      IF(IFSWD.EQ.1)  WRITE(81,213)'swd     ','down sw rad (W/m2)  '
      IF(IFLWD.EQ.1)  WRITE(81,213)'lwd     ','down lw rad (W/m2)  '
      IF(IFSWO.EQ.1)  WRITE(81,213)'swo     ','out sw rad (W/m2)   '
      IF(IFLWO.EQ.1)  WRITE(81,213)'lwo     ','out lw rad (W/m2)   '
      IF(IFSST.EQ.1)  WRITE(81,213)'sst     ','sea sfc temp        '
      IF(IFMAV.EQ.1)  WRITE(81,213)'mav     ','sfc moisture avail  '
      IF(IFST1.EQ.1)  WRITE(81,213)'st1     ','soil temp 1 (K)     '
      IF(IFST2.EQ.1)  WRITE(81,213)'st2     ','soil temp 2 (K)     '
      IF(IFST3.EQ.1)  WRITE(81,213)'st3     ','soil temp 3 (K)     '
      IF(IFST4.EQ.1)  WRITE(81,213)'st4     ','soil temp 4 (K)     '
      IF(IFST5.EQ.1)  WRITE(81,213)'st5     ','soil temp 5 (K)     '
      IF(IFST6.EQ.1)  WRITE(81,213)'st6     ','soil temp 6 (K)     '
      IF(IFSM1.EQ.1)  WRITE(81,213)'sm1     ','soil moist1 (m3/m3) '
      IF(IFSM2.EQ.1)  WRITE(81,213)'sm2     ','soil moist2 (m3/m3) '
      IF(IFSM3.EQ.1)  WRITE(81,213)'sm3     ','soil moist3 (m3/m3) '
      IF(IFSM4.EQ.1)  WRITE(81,213)'sm4     ','soil moist4 (m3/m3) '
      IF(IFSW1.EQ.1)  WRITE(81,213)'sw1     ','soil water 1 (m3/m3)'
      IF(IFSW2.EQ.1)  WRITE(81,213)'sw2     ','soil water 2 (m3/m3)'
      IF(IFSW3.EQ.1)  WRITE(81,213)'sw3     ','soil water 3 (m3/m3)'
      IF(IFSW4.EQ.1)  WRITE(81,213)'sw4     ','soil water 4 (m3/m3)'
      IF(IFCAN.EQ.1)  WRITE(81,213)'can     ','canopy moisture (m) '
      IF(IFSNH.EQ.1)  WRITE(81,213)'snh     ','phys snow height (m)'
      IF(IFSND.EQ.1)  WRITE(81,213)'snd     ','snow depth - SNODPTH'
      IF(IFWSD.EQ.1)  WRITE(81,213)'wsd     ','snow depth - WEASD  '
      IF(IFSSI.EQ.1)  WRITE(81,213)'ssi     ','seaice              '
      IF(IFSIF.EQ.1)  WRITE(81,213)'sif     ','seaice fraction     '
      IF(IFSRO.EQ.1)  WRITE(81,213)'sro     ','surface runoff (mm) '
      IF(IFURO.EQ.1)  WRITE(81,213)'uro     ','undergrd runoff (mm)'
      IF(IFT2M.EQ.1)  WRITE(81,213)'t2m     ','2 m temperature (K) '
      IF(IFQ2M.EQ.1)  WRITE(81,213)'q2m     ','2m mix ratio (kg/kg)'
      IF(IFU10.EQ.1)  WRITE(81,213)'u10     ','10 m u wind (m/sec) '
      IF(IFV10.EQ.1)  WRITE(81,213)'v10     ','10 m v wind (m/sec) '
      IF(IFALB.EQ.1)  WRITE(81,213)'alb     ','albedo (fraction)   '
      IF(IFABB.EQ.1)  WRITE(81,213)'abb     ','backgrd albedo (%)  '
      IF(IFASB.EQ.1)  WRITE(81,213)'asb     ','max snow albedo (%) '

      IF(IFPSLV.EQ.1) WRITE(81,213)'pslv    ','sea level prs (mb)  '
      IF(IFCREF.EQ.1) WRITE(81,213)'cref    ','composite refl (dbz)'
      IF(IFICLW.EQ.1) WRITE(81,213)'iclw    ','integrat clw (cm)   '
      IF(IFIRNW.EQ.1) WRITE(81,213)'irnw    ','integrat rnw (cm)   '
      IF(IFPWAT.EQ.1) WRITE(81,213)'pwat    ','precipit water (cm) '
      IF(IFCLFR.EQ.1) THEN
          WRITE(81,213)'clfrlo  ','low cloud fraction  '
          WRITE(81,213)'clfrmi  ','mid cloud fraction  '
          WRITE(81,213)'clfrhi  ','high cloud fraction '
      ENDIF

213   FORMAT(A8,' 0 99 ',a20)

      IF(IFU.EQ.1)    WRITE(81,214)'u       ',KTOT,'u wind (m/s)        '
      IF(IFV.EQ.1)    WRITE(81,214)'v       ',KTOT,'v wind (m/s)        '
      IF(IFW.EQ.1)    WRITE(81,214)'w       ',KTOT,'vertical vel (m/s)  '
      IF(IFPP.EQ.1)   WRITE(81,214)'pp      ',KTOT,'prs pert (Pa)       '
      IF(IFT.EQ.1)    WRITE(81,214)'t       ',KTOT,'temperature (C)     '
      IF(IFQ.EQ.1)    WRITE(81,214)'q       ',KTOT,'mixing ratio (kg/kg)'
      IF(IFCLW.EQ.1)  WRITE(81,214)'clw     ',KTOT,'cloud water (kg/kg) '
      IF(IFRNW.EQ.1)  WRITE(81,214)'rnw     ',KTOT,'rain water (kg/kg)  '
      IF(IFRTND.EQ.1) WRITE(81,214)'rtnd    ',KTOT,'rad tend (K/day)    '
      IF(IFZ.EQ.1)    WRITE(81,214)'z       ',KTOT,'height AGL (m)      '
      IF(IFH.EQ.1)    WRITE(81,214)'h       ',KTOT,'geopot height (m)   '
      IF(IFTKE.EQ.1)  WRITE(81,214)'tke     ',KTOT,'turb kin ener (J/kg)'
      IF(IFICE.EQ.1)  WRITE(81,214)'ice     ',KTOT,'ice water (kg/kg)   '
      IF(IFSNOW.EQ.1) WRITE(81,214)'snow    ',KTOT,'snow water (kg/kg)  '
      IF(IFGRAUP.EQ.1) WRITE(81,214)'graupel ',KTOT,'graupel (kg/kg)    '
      IF(IFNCI.EQ.1)  WRITE(81,214)'nci     ',KTOT,'num conc ice (m-3)  '
      IF(IFTD.EQ.1)   WRITE(81,214)'td      ',KTOT,'dewpoint temp (C)   '
      IF(IFRH.EQ.1)   WRITE(81,214)'rh      ',KTOT,'rel humidity (%)    '
      IF(IFTH.EQ.1)   WRITE(81,214)'th      ',KTOT,'potential temp (K)  '
      IF(IFTHE.EQ.1)  WRITE(81,214)'the     ',KTOT,'theta-e (K)         '
      IF(IFPRS.EQ.1)  WRITE(81,214)'prs     ',KTOT,'pressure (Pa)       '
      IF(IFVOR.EQ.1)  WRITE(81,214)'vor     ',KTOT,'vorticity (s-1)     '
      IF(IFPV.EQ.1)   WRITE(81,214)'pv      ',KTOT,'potential vort (pvu)'
      IF(IFDBZ.EQ.1)  WRITE(81,214)'dbz     ',KTOT,'reflectivity (dbz)  '
      IF(IFDIV.EQ.1)  WRITE(81,214)'div     ',KTOT,'divergence (s-1)    '
      IF(IFDIR.EQ.1)  WRITE(81,214)'dir     ',KTOT,'dir (degrees)       '
      IF(IFTADV.EQ.1) WRITE(81,214)'tadv    ',KTOT,'temp advection (K/s)'
214   FORMAT(A8,' ',I3,' 99 ',A20)
      WRITE(81,212)
212   FORMAT('endvars')

      STOP
      end program grads
